/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/VarargWrongExecutionOrderChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class VarargWrongExecutionOrderChecker
implements CallChecker {
    @NotNull
    public static final VarargWrongExecutionOrderChecker INSTANCE = new VarargWrongExecutionOrderChecker();

    private VarargWrongExecutionOrderChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        int n;
        int varargIndex;
        List<? extends ValueArgument> valueArguments;
        block10: {
            int n2;
            Object $this$indexOfFirst$iv;
            block9: {
                Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
                Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                boolean isCorrectExecutionOrderForVarargArgumentsAlreadyUsed = context.getLanguageVersionSettings().getFeatureSupport(LanguageFeature.UseCorrectExecutionOrderForVarargArguments) == LanguageFeature.State.ENABLED;
                Object obj = resolvedCall2.getCandidateDescriptor();
                Intrinsics.checkNotNullExpressionValue(obj, (String)"resolvedCall.candidateDescriptor");
                if (DescriptorUtilsKt.isAnnotationConstructor((DeclarationDescriptor)obj)) {
                    return;
                }
                if (isCorrectExecutionOrderForVarargArgumentsAlreadyUsed) {
                    return;
                }
                List<? extends ValueArgument> list2 = resolvedCall2.getCall().getValueArguments();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"resolvedCall.call.valueArguments");
                valueArguments = list2;
                $this$indexOfFirst$iv = valueArguments;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<? extends ValueArgument> iterator2 = $this$indexOfFirst$iv.iterator();
                while (iterator2.hasNext()) {
                    ValueArgument item$iv;
                    ValueArgument it = item$iv = iterator2.next();
                    boolean bl = false;
                    ValueParameterDescriptor valueParameterDescriptor = CallUtilKt.getParameterForArgument(resolvedCall2, it);
                    boolean bl2 = valueParameterDescriptor != null ? ArgumentsUtilsKt.isVararg(valueParameterDescriptor) : false;
                    if (bl2) {
                        n2 = index$iv;
                        break block9;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            $this$indexOfFirst$iv = n2;
            int it = ((Number)$this$indexOfFirst$iv).intValue();
            boolean bl = false;
            Object object = it != -1 ? $this$indexOfFirst$iv : null;
            if (object == null) {
                return;
            }
            varargIndex = (Integer)object;
            List<? extends ValueArgument> $this$indexOfLast$iv = valueArguments;
            boolean $i$f$indexOfLast = false;
            ListIterator<? extends ValueArgument> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                ValueArgument it2 = iterator$iv.previous();
                boolean bl3 = false;
                ValueParameterDescriptor valueParameterDescriptor = CallUtilKt.getParameterForArgument(resolvedCall2, it2);
                boolean bl4 = valueParameterDescriptor != null ? ArgumentsUtilsKt.isVararg(valueParameterDescriptor) : false;
                if (!(!bl4)) continue;
                n = iterator$iv.nextIndex();
                break block10;
            }
            n = -1;
        }
        Integer n3 = n;
        int it = ((Number)n3).intValue();
        boolean bl = false;
        Integer n4 = it != -1 ? n3 : null;
        if (n4 == null) {
            return;
        }
        int nonVarargIndex = n4;
        if (varargIndex > nonVarargIndex) {
            return;
        }
        ValueArgument varargValueArgument = valueArguments.get(varargIndex);
        if (!varargValueArgument.isNamed() || !(varargValueArgument instanceof PsiElement)) {
            return;
        }
        context.getTrace().report(Errors.CHANGING_ARGUMENTS_EXECUTION_ORDER_FOR_NAMED_VARARGS.on((PsiElement)((Object)varargValueArgument)));
    }
}

