/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Multimap;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtContextReceiver;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.psiUtil.ReservedCheckingKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001,B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J>\u0010\t\u001a \u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\n2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u0010\u0017\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0013J0\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u0013H\u0002J\u001c\u0010$\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020%2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030'J\"\u0010(\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\"\u0010)\u001a\u00020*2\u0006\u0010\u0005\u001a\u00020+2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010\u000f\u001a\u00020\u0004\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/types/expressions/LabelResolver;", "", "()V", "getCallerName", "Lorg/jetbrains/kotlin/name/Name;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getContainingCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getElementsByLabelName", "Lkotlin/Pair;", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lkotlin/collections/LinkedHashSet;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "labelName", "labelExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "classNameLabelsEnabled", "", "getExpressionUnderLabel", "labeledExpression", "getLabelForFunctionalExpression", "element", "getLabelNamesIfAny", "", "Lcom/intellij/psi/PsiElement;", "addClassNameLabels", "reportLabelResolveWillChange", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "target", "declarationElement", "closestElement", "isForExtensionReceiver", "resolveControlLabel", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "resolveNamedLabel", "resolveThisOrSuperLabel", "Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult;", "Lorg/jetbrains/kotlin/psi/KtInstanceExpressionWithLabel;", "LabeledReceiverResolutionResult", "frontend"})
public final class LabelResolver {
    @NotNull
    public static final LabelResolver INSTANCE = new LabelResolver();

    private LabelResolver() {
    }

    private final Pair<LinkedHashSet<KtElement>, KtCallableDeclaration> getElementsByLabelName(Name labelName, KtSimpleNameExpression labelExpression, boolean classNameLabelsEnabled) {
        LinkedHashSet<KtExpression> elements = new LinkedHashSet<KtExpression>();
        KtCallableDeclaration typedElement = null;
        PsiElement parent2 = labelExpression.getParent();
        while (parent2 != null) {
            List<Name> names2 = this.getLabelNamesIfAny(parent2, classNameLabelsEnabled);
            if (names2.contains(labelName)) {
                elements.add(this.getExpressionUnderLabel((KtExpression)parent2));
            } else if (parent2 instanceof KtCallableDeclaration && typedElement == null) {
                String nameForReceiverLabel;
                KtTypeReference receiverTypeReference;
                KtTypeReference ktTypeReference = receiverTypeReference = ((KtCallableDeclaration)parent2).getReceiverTypeReference();
                String string2 = nameForReceiverLabel = ktTypeReference != null ? ktTypeReference.nameForReceiverLabel() : null;
                if (Intrinsics.areEqual((Object)nameForReceiverLabel, (Object)labelName.asString())) {
                    typedElement = (KtCallableDeclaration)parent2;
                }
            }
            parent2 = parent2 instanceof KtCodeFragment ? ((KtCodeFragment)parent2).getContext() : parent2.getParent();
        }
        return TuplesKt.to(elements, typedElement);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Name> getLabelNamesIfAny(@NotNull PsiElement element, boolean addClassNameLabels) {
        PsiElement psiElement;
        Object $i$f$mapNotNullTo2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List result2 = new ArrayList();
        Object object = element;
        if (object instanceof KtLabeledExpression) {
            CollectionsKt.addIfNotNull(result2, ((KtLabeledExpression)element).getLabelNameAsName());
        } else {
            if (object instanceof KtFunctionLiteral) {
                PsiElement psiElement2 = ((KtFunctionLiteral)element).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.parent");
                return this.getLabelNamesIfAny(psiElement2, false);
            }
            if (object instanceof KtLambdaExpression) {
                CollectionsKt.addIfNotNull(result2, this.getLabelForFunctionalExpression((KtExpression)element));
            }
        }
        if (element instanceof KtClass) {
            void $this$mapNotNullTo$iv;
            object = ((KtClass)element).getContextReceivers();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Name name;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                KtContextReceiver it = (KtContextReceiver)element$iv;
                boolean bl2 = false;
                if (it.name() != null) {
                    String s;
                    boolean bl3 = false;
                    name = Name.identifier(s);
                } else {
                    name = null;
                }
                if (name == null) continue;
                Name it$iv = name;
                boolean bl4 = false;
                ((Collection)result2).add(it$iv);
            }
        }
        if (($i$f$mapNotNullTo2 = element) instanceof KtNamedFunction) {
            Collection collection = result2;
            Name name = ((KtNamedFunction)element).getNameAsName();
            if (name == null) {
                name = this.getLabelForFunctionalExpression((KtExpression)element);
            }
            CollectionsKt.addIfNotNull(collection, name);
            psiElement = element;
        } else if ($i$f$mapNotNullTo2 instanceof KtPropertyAccessor) {
            KtProperty ktProperty = ((KtPropertyAccessor)element).getProperty();
            psiElement = ktProperty;
            Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"element.property");
        } else {
            return result2;
        }
        PsiElement functionOrProperty = psiElement;
        if (addClassNameLabels) {
            void $this$mapNotNullTo$iv;
            Object object2 = ((KtCallableDeclaration)functionOrProperty).getReceiverTypeReference();
            if (object2 != null && (object2 = ((KtTypeReference)object2).nameForReceiverLabel()) != null) {
                Object it = object2;
                boolean bl = false;
                Name name = Name.identifier((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(it)");
                result2.add(name);
            }
            List<KtContextReceiver> list2 = ((KtCallableDeclaration)functionOrProperty).getContextReceivers();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"functionOrProperty.contextReceivers");
            $i$f$mapNotNullTo2 = list2;
            boolean $i$f$mapNotNullTo3 = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Name name;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator3.next();
                boolean bl = false;
                KtContextReceiver it = (KtContextReceiver)element$iv;
                boolean bl5 = false;
                if (it.name() != null) {
                    String s;
                    boolean bl6 = false;
                    name = Name.identifier(s);
                } else {
                    name = null;
                }
                if (name == null) continue;
                Name it$iv = name;
                boolean bl7 = false;
                ((Collection)result2).add(it$iv);
            }
        }
        return result2;
    }

    private final Name getLabelForFunctionalExpression(KtExpression element) {
        PsiElement parent2 = element.getParent();
        return parent2 instanceof KtLabeledExpression ? (Name)kotlin.collections.CollectionsKt.singleOrNull(this.getLabelNamesIfAny(parent2, false)) : (parent2 instanceof KtBinaryExpression ? ((KtBinaryExpression)parent2).getOperationReference().getReferencedNameAsName() : this.getCallerName(element));
    }

    private final KtExpression getExpressionUnderLabel(KtExpression labeledExpression) {
        KtExpression ktExpression;
        KtExpression ktExpression2 = KtPsiUtil.safeDeparenthesize(labeledExpression);
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"safeDeparenthesize(labeledExpression)");
        KtExpression expression2 = ktExpression2;
        if (expression2 instanceof KtLambdaExpression) {
            KtFunctionLiteral ktFunctionLiteral = ((KtLambdaExpression)expression2).getFunctionLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"expression.functionLiteral");
            ktExpression = ktFunctionLiteral;
        } else {
            ktExpression = expression2;
        }
        return ktExpression;
    }

    private final Name getCallerName(KtExpression expression2) {
        KtSimpleNameExpression calleeExpression;
        KtCallExpression ktCallExpression = this.getContainingCallExpression(expression2);
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression callExpression = ktCallExpression;
        KtExpression ktExpression = callExpression.getCalleeExpression();
        KtSimpleNameExpression ktSimpleNameExpression = calleeExpression = ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
        return ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null;
    }

    private final KtCallExpression getContainingCallExpression(KtExpression expression2) {
        PsiElement call2;
        PsiElement parent2 = expression2.getParent();
        if (parent2 instanceof KtLambdaArgument && (call2 = ((KtLambdaArgument)parent2).getParent()) instanceof KtCallExpression) {
            return (KtCallExpression)call2;
        }
        if (parent2 instanceof KtValueArgument) {
            PsiElement psiElement = ((KtValueArgument)parent2).getParent();
            if (psiElement == null) {
                return null;
            }
            PsiElement argList = psiElement;
            PsiElement call3 = argList.getParent();
            if (call3 instanceof KtCallExpression) {
                return (KtCallExpression)call3;
            }
        }
        return null;
    }

    @Nullable
    public final KtElement resolveControlLabel(@NotNull KtExpressionWithLabel expression2, @NotNull ResolutionContext<?> context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        KtSimpleNameExpression labelElement = expression2.getTargetLabel();
        if (!context.languageVersionSettings.supportsFeature(LanguageFeature.YieldIsNoMoreReserved)) {
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
            ReservedCheckingKt.checkReservedYield(labelElement, bindingTrace);
        }
        Name labelName = expression2.getLabelNameAsName();
        if (labelElement == null || labelName == null) {
            return null;
        }
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
        KtElement ktElement = this.resolveNamedLabel(labelName, labelElement, bindingTrace);
        if (ktElement == null) {
            LabelResolver $this$resolveControlLabel_u24lambda_u2d5 = this;
            boolean bl = false;
            context.trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)labelElement), labelElement));
            ktElement = null;
        }
        return ktElement;
    }

    private final KtElement resolveNamedLabel(Name labelName, KtSimpleNameExpression labelExpression, BindingTrace trace) {
        LinkedHashSet list2 = (LinkedHashSet)this.getElementsByLabelName(labelName, labelExpression, false).getFirst();
        if (list2.isEmpty()) {
            return null;
        }
        if (list2.size() > 1) {
            trace.report(Errors.LABEL_NAME_CLASH.on((KtSimpleNameExpression)((PsiElement)labelExpression)));
        }
        Object object = kotlin.collections.CollectionsKt.first((Iterable)list2);
        KtElement it = (KtElement)object;
        boolean bl = false;
        trace.record(BindingContext.LABEL_TARGET, labelExpression, it);
        return (KtElement)object;
    }

    @NotNull
    public final LabeledReceiverResolutionResult resolveThisOrSuperLabel(@NotNull KtInstanceExpressionWithLabel expression2, @NotNull ResolutionContext<?> context, @NotNull Name labelName) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)labelName, (String)"labelName");
        KtReferenceExpression ktReferenceExpression = expression2.getInstanceReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktReferenceExpression, (String)"expression.instanceReference");
        KtReferenceExpression referenceExpression = ktReferenceExpression;
        KtSimpleNameExpression ktSimpleNameExpression = expression2.getTargetLabel();
        if (ktSimpleNameExpression == null) {
            throw new IllegalStateException(((Object)expression2).toString());
        }
        KtSimpleNameExpression targetLabelExpression = ktSimpleNameExpression;
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"context.scope");
        LexicalScope scope2 = lexicalScope;
        Collection<DeclarationDescriptor> declarationsByLabel = ScopeUtilsKt.getDeclarationsByLabel(scope2, labelName);
        Pair<LinkedHashSet<KtElement>, KtCallableDeclaration> pair = this.getElementsByLabelName(labelName, targetLabelExpression, expression2 instanceof KtThisExpression && context.languageVersionSettings.supportsFeature(LanguageFeature.ContextReceivers));
        LinkedHashSet elementsByLabel = (LinkedHashSet)pair.component1();
        KtCallableDeclaration typedElement = (KtCallableDeclaration)pair.component2();
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
        BindingTrace trace = bindingTrace;
        switch (declarationsByLabel.size()) {
            case 1: {
                ReceiverParameterDescriptor receiverParameterDescriptor;
                DeclarationDescriptor declarationDescriptor;
                DeclarationDescriptor declarationDescriptor2 = declarationDescriptor = (DeclarationDescriptor)kotlin.collections.CollectionsKt.single((Iterable)declarationsByLabel);
                if (declarationDescriptor2 instanceof ClassDescriptor) {
                    receiverParameterDescriptor = ((ClassDescriptor)declarationDescriptor).getThisAsReceiverParameter();
                } else if (declarationDescriptor2 instanceof FunctionDescriptor) {
                    receiverParameterDescriptor = ((FunctionDescriptor)declarationDescriptor).getExtensionReceiverParameter();
                } else if (declarationDescriptor2 instanceof PropertyDescriptor) {
                    receiverParameterDescriptor = ((PropertyDescriptor)declarationDescriptor).getExtensionReceiverParameter();
                } else {
                    throw new UnsupportedOperationException("Unsupported descriptor: " + declarationDescriptor);
                }
                ReceiverParameterDescriptor thisReceiver2 = receiverParameterDescriptor;
                PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
                if (psiElement == null) {
                    throw new IllegalStateException(("No PSI element for descriptor: " + declarationDescriptor).toString());
                }
                PsiElement declarationElement = psiElement;
                trace.record(BindingContext.LABEL_TARGET, targetLabelExpression, declarationElement);
                trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, declarationDescriptor);
                KtElement closestElement = (KtElement)kotlin.collections.CollectionsKt.firstOrNull((Iterable)elementsByLabel);
                if (closestElement != null && SequencesKt.contains(PsiUtilsKt.getParents(closestElement), (Object)declarationElement)) {
                    this.reportLabelResolveWillChange(trace, targetLabelExpression, declarationElement, closestElement, false);
                } else if (typedElement != null && SequencesKt.contains(PsiUtilsKt.getParents(typedElement), (Object)declarationElement)) {
                    this.reportLabelResolveWillChange(trace, targetLabelExpression, declarationElement, typedElement, true);
                }
                if (declarationDescriptor instanceof ClassDescriptor && !DescriptorResolver.checkHasOuterClassInstance(scope2, trace, targetLabelExpression, (ClassDescriptor)declarationDescriptor)) {
                    return LabeledReceiverResolutionResult.Companion.labelResolutionFailed();
                }
                return LabeledReceiverResolutionResult.Companion.labelResolutionSuccess(thisReceiver2);
            }
            case 0: {
                KtElement ktElement;
                if (elementsByLabel.size() > 1) {
                    trace.report(Errors.LABEL_NAME_CLASH.on((KtSimpleNameExpression)((PsiElement)targetLabelExpression)));
                }
                KtElement ktElement2 = (KtElement)kotlin.collections.CollectionsKt.firstOrNull((Iterable)elementsByLabel);
                if (ktElement2 != null) {
                    KtElement declarationElement;
                    KtElement it = declarationElement = ktElement2;
                    boolean bl = false;
                    trace.record(BindingContext.LABEL_TARGET, targetLabelExpression, it);
                    ktElement = declarationElement;
                } else {
                    ktElement = null;
                }
                KtElement element = ktElement;
                DeclarationDescriptor declarationDescriptor = trace.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
                if (declarationDescriptor instanceof FunctionDescriptor || declarationDescriptor instanceof ClassDescriptor) {
                    Object object;
                    ReceiverParameterDescriptor receiverParameterDescriptor;
                    Multimap labelNameToReceiverMap;
                    DeclarationDescriptor declarationDescriptor3;
                    BindingContext bindingContext = trace.getBindingContext();
                    ReadOnlySlice readOnlySlice = BindingContext.DESCRIPTOR_TO_CONTEXT_RECEIVER_MAP;
                    if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
                        PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)declarationDescriptor).getCorrespondingProperty();
                        Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"declarationDescriptor.correspondingProperty");
                        declarationDescriptor3 = propertyDescriptor;
                    } else {
                        declarationDescriptor3 = declarationDescriptor;
                    }
                    Multimap multimap = labelNameToReceiverMap = (Multimap)bindingContext.get(readOnlySlice, declarationDescriptor3);
                    Collection thisReceivers = multimap != null ? multimap.get(labelName.getIdentifier()) : null;
                    Object object2 = thisReceivers;
                    if (object2 == null || object2.isEmpty()) {
                        FunctionDescriptor functionDescriptor = declarationDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)declarationDescriptor : null;
                        receiverParameterDescriptor = functionDescriptor != null ? functionDescriptor.getExtensionReceiverParameter() : null;
                    } else if (thisReceivers.size() == 1) {
                        receiverParameterDescriptor = (ReceiverParameterDescriptor)kotlin.collections.CollectionsKt.single((Iterable)thisReceivers);
                    } else {
                        BindingContextUtils.reportAmbiguousLabel(trace, targetLabelExpression, declarationsByLabel);
                        return LabeledReceiverResolutionResult.Companion.labelResolutionFailed();
                    }
                    ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
                    if (receiverParameterDescriptor2 != null) {
                        Object it = object2 = receiverParameterDescriptor2;
                        boolean bl = false;
                        trace.record(BindingContext.LABEL_TARGET, targetLabelExpression, element);
                        trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, declarationDescriptor);
                        object = object2;
                    } else {
                        object = null;
                    }
                    Object thisReceiver3 = object;
                    return LabeledReceiverResolutionResult.Companion.labelResolutionSuccess((ReceiverParameterDescriptor)thisReceiver3);
                }
                trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)targetLabelExpression), targetLabelExpression));
                break;
            }
            default: {
                BindingContextUtils.reportAmbiguousLabel(trace, targetLabelExpression, declarationsByLabel);
            }
        }
        return LabeledReceiverResolutionResult.Companion.labelResolutionFailed();
    }

    private final void reportLabelResolveWillChange(BindingTrace trace, KtSimpleNameExpression target, PsiElement declarationElement, KtElement closestElement, boolean isForExtensionReceiver) {
        KtElement ktElement = closestElement;
        String closestDescription = ktElement instanceof KtFunctionLiteral ? "anonymous function" : (ktElement instanceof KtNamedFunction ? "function " + ((KtNamedFunction)closestElement).getName() + ' ' + LabelResolver.reportLabelResolveWillChange$suffix(isForExtensionReceiver) : (ktElement instanceof KtPropertyAccessor ? "property " + ((KtPropertyAccessor)closestElement).getProperty().getName() + ' ' + LabelResolver.reportLabelResolveWillChange$suffix(isForExtensionReceiver) : "???"));
        PsiElement psiElement = declarationElement;
        String declarationDescription = psiElement instanceof KtClass ? "class " + ((KtClass)declarationElement).getName() : (psiElement instanceof KtNamedFunction ? "function " + ((KtNamedFunction)declarationElement).getName() : (psiElement instanceof KtProperty ? "property " + ((KtProperty)declarationElement).getName() : (psiElement instanceof KtNamedDeclaration ? "declaration with name " + ((KtNamedDeclaration)declarationElement).getName() : "unknown declaration")));
        trace.report(Errors.LABEL_RESOLVE_WILL_CHANGE.on((KtSimpleNameExpression)((PsiElement)target), declarationDescription, closestDescription));
    }

    private static final String reportLabelResolveWillChange$suffix(boolean $isForExtensionReceiver) {
        return $isForExtensionReceiver ? "extension receiver" : "context receiver";
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0002\f\rB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult;", "", "code", "Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Code;", "receiverParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "(Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Code;Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;)V", "getCode", "()Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Code;", "getReceiverParameterDescriptor", "success", "", "Code", "Companion", "frontend"})
    public static final class LabeledReceiverResolutionResult {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Code code;
        @Nullable
        private final ReceiverParameterDescriptor receiverParameterDescriptor;

        private LabeledReceiverResolutionResult(Code code, ReceiverParameterDescriptor receiverParameterDescriptor) {
            this.code = code;
            this.receiverParameterDescriptor = receiverParameterDescriptor;
        }

        @NotNull
        public final Code getCode() {
            return this.code;
        }

        public final boolean success() {
            return this.code == Code.SUCCESS;
        }

        @Nullable
        public final ReceiverParameterDescriptor getReceiverParameterDescriptor() {
            boolean bl = this.success();
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "Don't try to obtain the receiver when resolution failed with " + (Object)((Object)this.code);
                throw new AssertionError((Object)string2);
            }
            return this.receiverParameterDescriptor;
        }

        public /* synthetic */ LabeledReceiverResolutionResult(Code code, ReceiverParameterDescriptor receiverParameterDescriptor, DefaultConstructorMarker $constructor_marker) {
            this(code, receiverParameterDescriptor);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Code;", "", "(Ljava/lang/String;I)V", "LABEL_RESOLUTION_ERROR", "NO_THIS", "SUCCESS", "frontend"})
        public static final class Code
        extends Enum<Code> {
            public static final /* enum */ Code LABEL_RESOLUTION_ERROR = new Code();
            public static final /* enum */ Code NO_THIS = new Code();
            public static final /* enum */ Code SUCCESS = new Code();
            private static final /* synthetic */ Code[] $VALUES;

            public static Code[] values() {
                return (Code[])$VALUES.clone();
            }

            public static Code valueOf(String value2) {
                return Enum.valueOf(Code.class, value2);
            }

            static {
                $VALUES = codeArray = new Code[]{Code.LABEL_RESOLUTION_ERROR, Code.NO_THIS, Code.SUCCESS};
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Companion;", "", "()V", "labelResolutionFailed", "Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult;", "labelResolutionSuccess", "receiverParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "frontend"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final LabeledReceiverResolutionResult labelResolutionSuccess(@Nullable ReceiverParameterDescriptor receiverParameterDescriptor) {
                if (receiverParameterDescriptor == null) {
                    return new LabeledReceiverResolutionResult(Code.NO_THIS, null, null);
                }
                return new LabeledReceiverResolutionResult(Code.SUCCESS, receiverParameterDescriptor, null);
            }

            @NotNull
            public final LabeledReceiverResolutionResult labelResolutionFailed() {
                return new LabeledReceiverResolutionResult(Code.LABEL_RESOLUTION_ERROR, null, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

