/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers.utils;

import com.google.common.collect.ImmutableSet;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/checkers/utils/DebugInfoUtil;", "", "()V", "EXCLUDED", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "MAY_BE_UNRESOLVED", "markDebugAnnotations", "", "root", "Lcom/intellij/psi/PsiElement;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "debugInfoReporter", "Lorg/jetbrains/kotlin/checkers/utils/DebugInfoUtil$DebugInfoReporter;", "reportIfDynamic", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "declarationDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "DebugInfoReporter", "frontend"})
public final class DebugInfoUtil {
    @NotNull
    public static final DebugInfoUtil INSTANCE = new DebugInfoUtil();
    @NotNull
    private static final TokenSet MAY_BE_UNRESOLVED;
    @NotNull
    private static final TokenSet EXCLUDED;

    private DebugInfoUtil() {
    }

    public final void markDebugAnnotations(@NotNull PsiElement root2, @NotNull BindingContext bindingContext, @NotNull DebugInfoReporter debugInfoReporter) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)debugInfoReporter, (String)"debugInfoReporter");
        Map markedWithErrorElements = new HashMap();
        for (Diagnostic diagnostic : bindingContext.getDiagnostics()) {
            DiagnosticFactory<?> factory2 = diagnostic.getFactory();
            ImmutableSet<? extends DiagnosticFactory<?>> immutableSet = Errors.UNRESOLVED_REFERENCE_DIAGNOSTICS;
            Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"UNRESOLVED_REFERENCE_DIAGNOSTICS");
            if (CollectionsKt.contains((Iterable)immutableSet, diagnostic.getFactory())) {
                markedWithErrorElements.put((KtReferenceExpression)diagnostic.getPsiElement(), factory2);
                continue;
            }
            if (factory2 == Errors.SUPER_IS_NOT_AN_EXPRESSION || factory2 == Errors.SUPER_NOT_AVAILABLE) {
                KtSuperExpression superExpression = (KtSuperExpression)diagnostic.getPsiElement();
                Map map = markedWithErrorElements;
                KtReferenceExpression ktReferenceExpression = superExpression.getInstanceReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktReferenceExpression, (String)"superExpression.instanceReference");
                map.put(ktReferenceExpression, factory2);
                continue;
            }
            if (factory2 == Errors.EXPRESSION_EXPECTED_PACKAGE_FOUND) {
                markedWithErrorElements.put((KtSimpleNameExpression)diagnostic.getPsiElement(), factory2);
                continue;
            }
            if (factory2 != Errors.UNSUPPORTED) continue;
            for (KtReferenceExpression reference : PsiTreeUtil.findChildrenOfType(diagnostic.getPsiElement(), KtReferenceExpression.class)) {
                Intrinsics.checkNotNullExpressionValue((Object)reference, (String)"reference");
                markedWithErrorElements.put(reference, factory2);
            }
        }
        root2.acceptChildren(new KtTreeVisitorVoid(bindingContext, debugInfoReporter, markedWithErrorElements){
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ DebugInfoReporter $debugInfoReporter;
            final /* synthetic */ Map<KtReferenceExpression, DiagnosticFactory<?>> $markedWithErrorElements;
            {
                this.$bindingContext = $bindingContext;
                this.$debugInfoReporter = $debugInfoReporter;
                this.$markedWithErrorElements = $markedWithErrorElements;
            }

            public void visitForExpression(@NotNull KtForExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                KtExpression range = expression2.getLoopRange();
                if (range != null) {
                    KtElement ktElement = range;
                    WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL;
                    Intrinsics.checkNotNullExpressionValue(writableSlice, (String)"LOOP_RANGE_ITERATOR_RESOLVED_CALL");
                    this.reportIfDynamicCall(ktElement, range, writableSlice);
                    KtElement ktElement2 = range;
                    WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice2 = BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL;
                    Intrinsics.checkNotNullExpressionValue(writableSlice2, (String)"LOOP_RANGE_HAS_NEXT_RESOLVED_CALL");
                    this.reportIfDynamicCall(ktElement2, range, writableSlice2);
                    KtElement ktElement3 = range;
                    WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice3 = BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL;
                    Intrinsics.checkNotNullExpressionValue(writableSlice3, (String)"LOOP_RANGE_NEXT_RESOLVED_CALL");
                    this.reportIfDynamicCall(ktElement3, range, writableSlice3);
                }
                super.visitForExpression(expression2);
            }

            public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration) {
                Intrinsics.checkNotNullParameter((Object)destructuringDeclaration, (String)"destructuringDeclaration");
                for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
                    KtElement ktElement = entry;
                    WritableSlice<KtDestructuringDeclarationEntry, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.COMPONENT_RESOLVED_CALL;
                    Intrinsics.checkNotNullExpressionValue(writableSlice, (String)"COMPONENT_RESOLVED_CALL");
                    this.reportIfDynamicCall(ktElement, entry, writableSlice);
                }
                super.visitDestructuringDeclaration(destructuringDeclaration);
            }

            public void visitProperty(@NotNull KtProperty property2) {
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                VariableDescriptor descriptor2 = (VariableDescriptor)this.$bindingContext.get(BindingContext.VARIABLE, property2);
                KtPropertyDelegate delegate2 = property2.getDelegate();
                if (descriptor2 instanceof PropertyDescriptor && delegate2 != null) {
                    KtElement ktElement = delegate2;
                    WritableSlice<VariableDescriptorWithAccessors, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL;
                    Intrinsics.checkNotNullExpressionValue(writableSlice, (String)"PROVIDE_DELEGATE_RESOLVED_CALL");
                    this.reportIfDynamicCall(ktElement, descriptor2, writableSlice);
                    KtElement ktElement2 = delegate2;
                    PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)descriptor2).getGetter();
                    WritableSlice<VariableAccessorDescriptor, ResolvedCall<FunctionDescriptor>> writableSlice2 = BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL;
                    Intrinsics.checkNotNullExpressionValue(writableSlice2, (String)"DELEGATED_PROPERTY_RESOLVED_CALL");
                    this.reportIfDynamicCall(ktElement2, propertyGetterDescriptor, writableSlice2);
                    KtElement ktElement3 = delegate2;
                    PropertySetterDescriptor propertySetterDescriptor = ((PropertyDescriptor)descriptor2).getSetter();
                    WritableSlice<VariableAccessorDescriptor, ResolvedCall<FunctionDescriptor>> writableSlice3 = BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL;
                    Intrinsics.checkNotNullExpressionValue(writableSlice3, (String)"DELEGATED_PROPERTY_RESOLVED_CALL");
                    this.reportIfDynamicCall(ktElement3, propertySetterDescriptor, writableSlice3);
                }
                super.visitProperty(property2);
            }

            public void visitThisExpression(@NotNull KtThisExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.$bindingContext);
                if (resolvedCall2 != null) {
                    DebugInfoUtil.access$reportIfDynamic(DebugInfoUtil.INSTANCE, expression2, resolvedCall2.getResultingDescriptor(), this.$debugInfoReporter);
                }
                super.visitThisExpression(expression2);
            }

            public void visitReferenceExpression(@NotNull KtReferenceExpression expression2) {
                Collection labelTargets;
                Collection declarationDescriptors;
                PsiElement labelTarget;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitReferenceExpression(expression2);
                if (!BindingContextUtils.isExpressionWithValidReference(expression2, this.$bindingContext)) {
                    return;
                }
                IElementType referencedNameElementType = null;
                if (expression2 instanceof KtSimpleNameExpression) {
                    IElementType iElementType = expression2.getNode().getElementType();
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"expression.getNode().elementType");
                    IElementType elementType = iElementType;
                    if (elementType == KtNodeTypes.OPERATION_REFERENCE) {
                        referencedNameElementType = ((KtSimpleNameExpression)expression2).getReferencedNameElementType();
                        if (DebugInfoUtil.access$getEXCLUDED$p().contains(referencedNameElementType)) {
                            return;
                        }
                    }
                    if (elementType == KtNodeTypes.LABEL || ((KtSimpleNameExpression)expression2).getReferencedNameElementType() == KtTokens.THIS_KEYWORD) {
                        return;
                    }
                }
                this.$debugInfoReporter.preProcessReference(expression2);
                String target = null;
                DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.$bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
                if (declarationDescriptor != null) {
                    target = declarationDescriptor.toString();
                    DebugInfoUtil.access$reportIfDynamic(DebugInfoUtil.INSTANCE, expression2, declarationDescriptor, this.$debugInfoReporter);
                }
                if (target == null && (labelTarget = (PsiElement)this.$bindingContext.get(BindingContext.LABEL_TARGET, expression2)) != null) {
                    target = labelTarget.getText();
                }
                if (target == null && (declarationDescriptors = (Collection)this.$bindingContext.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, expression2)) != null) {
                    target = "" + '[' + declarationDescriptors.size() + " descriptors]";
                }
                if (target == null && (labelTargets = (Collection)this.$bindingContext.get(BindingContext.AMBIGUOUS_LABEL_TARGET, expression2)) != null) {
                    target = "" + '[' + labelTargets.size() + " elements]";
                }
                if (DebugInfoUtil.access$getMAY_BE_UNRESOLVED$p().contains(referencedNameElementType) || expression2 instanceof KtNameReferenceExpression && ((KtNameReferenceExpression)expression2).isPlaceholder()) {
                    return;
                }
                boolean resolved = target != null;
                boolean markedWithError = this.$markedWithErrorElements.containsKey(expression2);
                if (expression2 instanceof KtArrayAccessExpression && this.$markedWithErrorElements.containsKey(((KtArrayAccessExpression)expression2).getArrayExpression())) {
                    markedWithError = true;
                }
                KotlinType expressionType = this.$bindingContext.getType(expression2);
                DiagnosticFactory<?> factory2 = this.$markedWithErrorElements.get(expression2);
                if (declarationDescriptor != null && (ErrorUtils.isError(declarationDescriptor) || ErrorUtils.containsErrorType(expressionType)) && factory2 != Errors.EXPRESSION_EXPECTED_PACKAGE_FOUND) {
                    this.$debugInfoReporter.reportElementWithErrorType(expression2);
                }
                if (resolved && markedWithError) {
                    ImmutableSet<? extends DiagnosticFactory<?>> immutableSet = Errors.UNRESOLVED_REFERENCE_DIAGNOSTICS;
                    Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"UNRESOLVED_REFERENCE_DIAGNOSTICS");
                    if (CollectionsKt.contains((Iterable)immutableSet, factory2)) {
                        String string2 = target;
                        Intrinsics.checkNotNull((Object)string2);
                        this.$debugInfoReporter.reportUnresolvedWithTarget(expression2, string2);
                    }
                } else if (!resolved && !markedWithError) {
                    this.$debugInfoReporter.reportMissingUnresolved(expression2);
                }
            }

            private final <E extends KtElement, K, D extends CallableDescriptor> boolean reportIfDynamicCall(E element, K key, WritableSlice<K, ResolvedCall<D>> slice) {
                ResolvedCall resolvedCall2 = (ResolvedCall)this.$bindingContext.get(slice, key);
                return resolvedCall2 != null ? DebugInfoUtil.access$reportIfDynamic(DebugInfoUtil.INSTANCE, element, (DeclarationDescriptor)resolvedCall2.getResultingDescriptor(), this.$debugInfoReporter) : false;
            }
        });
    }

    private final boolean reportIfDynamic(KtElement element, DeclarationDescriptor declarationDescriptor, DebugInfoReporter debugInfoReporter) {
        if (declarationDescriptor != null && DynamicCallsKt.isDynamic(declarationDescriptor)) {
            debugInfoReporter.reportDynamicCall(element, declarationDescriptor);
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean access$reportIfDynamic(DebugInfoUtil $this, KtElement element, DeclarationDescriptor declarationDescriptor, DebugInfoReporter debugInfoReporter) {
        return $this.reportIfDynamic(element, declarationDescriptor, debugInfoReporter);
    }

    public static final /* synthetic */ TokenSet access$getEXCLUDED$p() {
        return EXCLUDED;
    }

    public static final /* synthetic */ TokenSet access$getMAY_BE_UNRESOLVED$p() {
        return MAY_BE_UNRESOLVED;
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.IN_KEYWORD, KtTokens.NOT_IN};
        TokenSet tokenSet = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(KtTokens.IN_KEYWORD, KtTokens.NOT_IN)");
        MAY_BE_UNRESOLVED = tokenSet;
        iElementTypeArray = new IElementType[]{KtTokens.COLON, KtTokens.AS_KEYWORD, KtTokens.AS_SAFE, KtTokens.IS_KEYWORD, KtTokens.NOT_IS, KtTokens.OROR, KtTokens.ANDAND, KtTokens.EQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ, KtTokens.ELVIS, KtTokens.EXCLEXCL};
        TokenSet tokenSet2 = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(\n        KtTokens\u2026  KtTokens.EXCLEXCL\n    )");
        EXCLUDED = tokenSet2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H&\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/checkers/utils/DebugInfoUtil$DebugInfoReporter;", "", "()V", "preProcessReference", "", "expression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "reportDynamicCall", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "declarationDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "reportElementWithErrorType", "reportMissingUnresolved", "reportUnresolvedWithTarget", "target", "", "frontend"})
    public static abstract class DebugInfoReporter {
        public final void preProcessReference(@NotNull KtReferenceExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        }

        public abstract void reportElementWithErrorType(@NotNull KtReferenceExpression var1);

        public abstract void reportMissingUnresolved(@NotNull KtReferenceExpression var1);

        public abstract void reportUnresolvedWithTarget(@NotNull KtReferenceExpression var1, @NotNull String var2);

        public void reportDynamicCall(@NotNull KtElement element, @NotNull DeclarationDescriptor declarationDescriptor) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"declarationDescriptor");
        }
    }
}

