/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir.convertors;

import java.io.ByteArrayOutputStream;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0000H&J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0000H&J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\fH&J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eH&J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0010H\u0002J\u001b\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0012\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001b\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0012H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001a\u0010\u0014J\u000e\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u001c\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0010J\u000e\u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\fJ\u000e\u0010\u001e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001fJ\u001b\u0010 \u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0012\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b!\u0010\u0014J\u001b\u0010\"\u001a\u00020\t2\u0006\u0010\n\u001a\u00020#\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b$\u0010%R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/convertors/ByteWriter;", "", "()V", "written", "", "getWritten", "()I", "createTemp", "write", "", "v", "writeByte", "", "writeBytes", "", "writeSignedLeb128", "", "writeUInt32", "Lkotlin/UInt;", "writeUInt32-WZ4Q5Ns", "(I)V", "writeUInt64", "Lkotlin/ULong;", "writeUInt64-VKZWuLQ", "(J)V", "writeUnsignedLeb128", "writeUnsignedLeb128-WZ4Q5Ns", "writeVarInt32", "writeVarInt64", "writeVarInt7", "writeVarUInt1", "", "writeVarUInt32", "writeVarUInt32-WZ4Q5Ns", "writeVarUInt7", "Lkotlin/UShort;", "writeVarUInt7-xj2QHRw", "(S)V", "OutputStream", "wasm.ir"})
public abstract class ByteWriter {
    public abstract int getWritten();

    public abstract void write(@NotNull ByteWriter var1);

    public abstract void writeByte(byte var1);

    public abstract void writeBytes(@NotNull byte[] var1);

    @NotNull
    public abstract ByteWriter createTemp();

    public final void writeUInt32-WZ4Q5Ns(int v) {
        this.writeByte((byte)v);
        this.writeByte((byte)UInt.constructor-impl((int)(v >>> 8)));
        this.writeByte((byte)UInt.constructor-impl((int)(v >>> 16)));
        this.writeByte((byte)UInt.constructor-impl((int)(v >>> 24)));
    }

    public final void writeUInt64-VKZWuLQ(long v) {
        this.writeByte((byte)v);
        this.writeByte((byte)ULong.constructor-impl((long)(v >>> 8)));
        this.writeByte((byte)ULong.constructor-impl((long)(v >>> 16)));
        this.writeByte((byte)ULong.constructor-impl((long)(v >>> 24)));
        this.writeByte((byte)ULong.constructor-impl((long)(v >>> 32)));
        this.writeByte((byte)ULong.constructor-impl((long)(v >>> 40)));
        this.writeByte((byte)ULong.constructor-impl((long)(v >>> 48)));
        this.writeByte((byte)ULong.constructor-impl((long)(v >>> 56)));
    }

    public final void writeVarInt7(byte v) {
        this.writeSignedLeb128(v);
    }

    public final void writeVarInt32(int v) {
        this.writeSignedLeb128(v);
    }

    public final void writeVarInt64(long v) {
        this.writeSignedLeb128(v);
    }

    public final void writeVarUInt1(boolean v) {
        this.writeUnsignedLeb128-WZ4Q5Ns(v ? 1 : 0);
    }

    public final void writeVarUInt7-xj2QHRw(short v) {
        this.writeUnsignedLeb128-WZ4Q5Ns(UInt.constructor-impl((int)(v & 0xFFFF)));
    }

    public final void writeVarUInt32-WZ4Q5Ns(int v) {
        this.writeUnsignedLeb128-WZ4Q5Ns(v);
    }

    private final void writeUnsignedLeb128-WZ4Q5Ns(int v) {
        int n;
        int v2 = v;
        int remaining = UInt.constructor-impl((int)(v2 >>> 7));
        while (remaining != 0) {
            n = UInt.constructor-impl((int)(UInt.constructor-impl((int)(v2 & 0x7F)) | 0x80));
            this.writeByte((byte)n);
            v2 = remaining;
            remaining = UInt.constructor-impl((int)(remaining >>> 7));
        }
        n = UInt.constructor-impl((int)(v2 & 0x7F));
        this.writeByte((byte)n);
    }

    private final void writeSignedLeb128(long v) {
        long end;
        long v2 = v;
        long remaining = v2 >> 7;
        boolean hasMore = true;
        long l = end = (v2 & Long.MIN_VALUE) == 0L ? 0L : -1L;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1L) != (v2 >> 6 & 1L);
            int n = (int)(v2 & 0x7FL | (hasMore ? 128L : 0L));
            this.writeByte((byte)n);
            v2 = remaining;
            remaining >>= 7;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\u0000H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001H\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/convertors/ByteWriter$OutputStream;", "Lorg/jetbrains/kotlin/wasm/ir/convertors/ByteWriter;", "os", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;)V", "getOs", "()Ljava/io/OutputStream;", "<set-?>", "", "written", "getWritten", "()I", "createTemp", "write", "", "v", "writeByte", "", "writeBytes", "", "wasm.ir"})
    public static final class OutputStream
    extends ByteWriter {
        @NotNull
        private final java.io.OutputStream os;
        private int written;

        public OutputStream(@NotNull java.io.OutputStream os) {
            Intrinsics.checkNotNullParameter((Object)os, (String)"os");
            this.os = os;
        }

        @NotNull
        public final java.io.OutputStream getOs() {
            return this.os;
        }

        @Override
        public int getWritten() {
            return this.written;
        }

        @Override
        public void write(@NotNull ByteWriter v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            if (!(v instanceof OutputStream) || !(((OutputStream)v).os instanceof ByteArrayOutputStream)) {
                throw new IllegalStateException("Writer not created from createTemp".toString());
            }
            ((ByteArrayOutputStream)((OutputStream)v).os).writeTo(this.os);
            this.written = this.getWritten() + ((ByteArrayOutputStream)((OutputStream)v).os).size();
        }

        @Override
        public void writeByte(byte v) {
            this.os.write(v);
            int n = this.getWritten();
            this.written = n + 1;
        }

        @Override
        public void writeBytes(@NotNull byte[] v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            this.os.write(v);
            this.written = this.getWritten() + v.length;
        }

        @Override
        @NotNull
        public OutputStream createTemp() {
            return new OutputStream(new ByteArrayOutputStream());
        }
    }
}

