/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.build.GeneratedJvmClass;
import org.jetbrains.kotlin.build.SourcesUtilsKt;
import org.jetbrains.kotlin.build.report.BuildReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.FilteringMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.AbiSnapshot;
import org.jetbrains.kotlin.incremental.AbiSnapshotImpl;
import org.jetbrains.kotlin.incremental.BuildInfo;
import org.jetbrains.kotlin.incremental.BuildUtilKt;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.ChangedJavaFilesProcessor;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ChangesDetectionUtilsKt;
import org.jetbrains.kotlin.incremental.ChangesEither;
import org.jetbrains.kotlin.incremental.ClasspathChanges;
import org.jetbrains.kotlin.incremental.DirtyData;
import org.jetbrains.kotlin.incremental.DirtyFilesContainer;
import org.jetbrains.kotlin.incremental.FileUtilsKt;
import org.jetbrains.kotlin.incremental.IncrementalCachesManager;
import org.jetbrains.kotlin.incremental.IncrementalCompilationComponentsImpl;
import org.jetbrains.kotlin.incremental.IncrementalCompilerRunner;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache;
import org.jetbrains.kotlin.incremental.IncrementalJvmCachesManager;
import org.jetbrains.kotlin.incremental.IncrementalJvmCompilerRunner;
import org.jetbrains.kotlin.incremental.IncrementalJvmCompilerRunnerKt;
import org.jetbrains.kotlin.incremental.JavaClassesTrackerImpl;
import org.jetbrains.kotlin.incremental.LocalFileKotlinClass;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.classpathDiff.CachedClasspathSnapshotSerializer;
import org.jetbrains.kotlin.incremental.classpathDiff.ClassSnapshotWithHash;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathChangesComputer;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathSnapshotShrinker;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathSnapshotShrinkerKt;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistory;
import org.jetbrains.kotlin.incremental.storage.LookupSymbolKey;
import org.jetbrains.kotlin.incremental.util.BufferingMessageCollector;
import org.jetbrains.kotlin.incremental.util.Either;
import org.jetbrains.kotlin.load.java.JavaClassesTracker;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00e3\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000*\u0001!\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001BS\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J,\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050%2\u0006\u0010&\u001a\u00020\u00032\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00102\u0006\u0010)\u001a\u00020*H\u0014J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020,0%H\u0014J6\u0010-\u001a\u00020.2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00022\u0014\b\u0002\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020403H\u0002J<\u0010-\u001a\u00020.2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00022\u0006\u00105\u001a\u0002062\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020403H\u0014J\u001a\u00108\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00022\b\u00109\u001a\u0004\u0018\u00010\u0005H\u0014J\u0010\u0010:\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0002H\u0014J\b\u0010;\u001a\u00020\tH\u0014J>\u0010<\u001a\u00020=2\u0006\u00101\u001a\u00020\u00022\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010&\u001a\u00020\u00032\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00050C2\u0006\u0010D\u001a\u00020\tH\u0014J\u0010\u0010E\u001a\u00020F2\u0006\u0010&\u001a\u00020\u0003H\u0014J\u0018\u0010G\u001a\u00020F2\u0006\u00101\u001a\u00020\u00022\u0006\u0010H\u001a\u00020.H\u0014J\u001a\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010/\u001a\u0002002\u0006\u0010&\u001a\u00020\u0003H\u0002J\u0018\u0010K\u001a\u00020F2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\u0017H\u0002J\u0016\u0010O\u001a\b\u0012\u0004\u0012\u00020,0\f2\u0006\u0010/\u001a\u000200H\u0002J6\u0010P\u001a\u00020Q2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00050C2\u0006\u00101\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u00032\u0006\u0010)\u001a\u00020*2\u0006\u00105\u001a\u000206H\u0014J\u0010\u0010S\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u0003H\u0016J,\u0010T\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u000204032\u0006\u00101\u001a\u00020\u00022\u0006\u0010U\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J.\u0010V\u001a\u00020F2\u0006\u0010)\u001a\u00020*2\u0006\u0010&\u001a\u00020\u00032\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00102\u0006\u0010W\u001a\u00020XH\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\"R\u0016\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCompilerRunner;", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCachesManager;", "workingDir", "Ljava/io/File;", "reporter", "Lorg/jetbrains/kotlin/build/report/BuildReporter;", "usePreciseJavaTracking", "", "buildHistoryFile", "outputFiles", "", "modulesApiHistory", "Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistory;", "kotlinSourceFilesExtensions", "", "", "classpathChanges", "Lorg/jetbrains/kotlin/incremental/ClasspathChanges;", "(Ljava/io/File;Lorg/jetbrains/kotlin/build/report/BuildReporter;ZLjava/io/File;Ljava/util/Collection;Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistory;Ljava/util/List;Lorg/jetbrains/kotlin/incremental/ClasspathChanges;)V", "changedUntrackedJavaClasses", "", "Lorg/jetbrains/kotlin/name/ClassId;", "currentClasspathSnapshot", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ClassSnapshotWithHash;", "dirtyClasspathChanges", "Lorg/jetbrains/kotlin/name/FqName;", "javaFilesProcessor", "Lorg/jetbrains/kotlin/incremental/ChangedJavaFilesProcessor;", "getKotlinSourceFilesExtensions", "()Ljava/util/List;", "psiFileProvider", "org/jetbrains/kotlin/incremental/IncrementalJvmCompilerRunner$psiFileProvider$1", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCompilerRunner$psiFileProvider$1;", "shrunkCurrentClasspathAgainstPreviousLookups", "additionalDirtyFiles", "", "caches", "generatedFiles", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "services", "Lorg/jetbrains/kotlin/config/Services;", "additionalDirtyLookupSymbols", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "calculateSourcesToCompileImpl", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$CompilationMode;", "changedFiles", "Lorg/jetbrains/kotlin/incremental/ChangedFiles$Known;", "args", "abiSnapshots", "", "Lorg/jetbrains/kotlin/incremental/AbiSnapshot;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "classpathAbiSnapshots", "createCacheManager", "projectDir", "destinationDir", "isICEnabled", "makeServices", "Lorg/jetbrains/kotlin/config/Services$Builder;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "expectActualTracker", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "dirtySources", "", "isIncremental", "performWorkAfterSuccessfulCompilation", "", "preBuildHook", "compilationMode", "processChangedJava", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "processChangedUntrackedJavaClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "classId", "processLookupSymbolsForAndroidLayouts", "runCompiler", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "sourcesToCompile", "runWithNoDirtyKotlinSources", "setupJarDependencies", "withSnapshot", "updateCaches", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "incremental-compilation-impl"})
public final class IncrementalJvmCompilerRunner
extends IncrementalCompilerRunner<K2JVMCompilerArguments, IncrementalJvmCachesManager> {
    private final boolean usePreciseJavaTracking;
    @NotNull
    private final ModulesApiHistory modulesApiHistory;
    @NotNull
    private final List<String> kotlinSourceFilesExtensions;
    @NotNull
    private final ClasspathChanges classpathChanges;
    @NotNull
    private Collection<FqName> dirtyClasspathChanges;
    @NotNull
    private final psiFileProvider.1 psiFileProvider;
    @NotNull
    private final Set<ClassId> changedUntrackedJavaClasses;
    @Nullable
    private ChangedJavaFilesProcessor javaFilesProcessor;
    @Nullable
    private List<ClassSnapshotWithHash> currentClasspathSnapshot;
    @Nullable
    private List<ClassSnapshotWithHash> shrunkCurrentClasspathAgainstPreviousLookups;

    public IncrementalJvmCompilerRunner(@NotNull File workingDir, @NotNull BuildReporter reporter, boolean usePreciseJavaTracking, @NotNull File buildHistoryFile, @NotNull Collection<? extends File> outputFiles, @NotNull ModulesApiHistory modulesApiHistory, @NotNull List<String> kotlinSourceFilesExtensions, @NotNull ClasspathChanges classpathChanges2) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)buildHistoryFile, (String)"buildHistoryFile");
        Intrinsics.checkNotNullParameter(outputFiles, (String)"outputFiles");
        Intrinsics.checkNotNullParameter((Object)modulesApiHistory, (String)"modulesApiHistory");
        Intrinsics.checkNotNullParameter(kotlinSourceFilesExtensions, (String)"kotlinSourceFilesExtensions");
        Intrinsics.checkNotNullParameter((Object)classpathChanges2, (String)"classpathChanges");
        super(workingDir, "caches-jvm", reporter, buildHistoryFile, outputFiles);
        this.usePreciseJavaTracking = usePreciseJavaTracking;
        this.modulesApiHistory = modulesApiHistory;
        this.kotlinSourceFilesExtensions = kotlinSourceFilesExtensions;
        this.classpathChanges = classpathChanges2;
        this.dirtyClasspathChanges = SetsKt.emptySet();
        this.psiFileProvider = new Object(){
            @NotNull
            private final BufferingMessageCollector messageCollector;
            @NotNull
            private final Lazy psiFileFactory$delegate;
            {
                this.messageCollector = new BufferingMessageCollector();
                this.psiFileFactory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PsiFileFactory>(this){
                    final /* synthetic */ psiFileProvider.1 this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final PsiFileFactory invoke() {
                        Disposable disposable = Disposer.newDisposable();
                        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable()");
                        Disposable rootDisposable = disposable;
                        CompilerConfiguration configuration = new CompilerConfiguration();
                        FilteringMessageCollector filterMessageCollector = new FilteringMessageCollector(this.this$0.getMessageCollector(), psiFileProvider.psiFileFactory.2::invoke$lambda-0);
                        configuration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, filterMessageCollector);
                        KotlinCoreEnvironment environment = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.JVM_CONFIG_FILES);
                        Project project = environment.getProject();
                        return PsiFileFactory.getInstance(project);
                    }

                    private static final boolean invoke$lambda-0(CompilerMessageSeverity it) {
                        return !it.isError();
                    }
                }));
            }

            @NotNull
            public final BufferingMessageCollector getMessageCollector() {
                return this.messageCollector;
            }

            @Nullable
            public final PsiFile javaFile(@NotNull File file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                return this.getPsiFileFactory().createFileFromText(FilesKt.getNameWithoutExtension((File)file2), JavaLanguage.INSTANCE, (CharSequence)FilesKt.readText$default((File)file2, null, (int)1, null));
            }

            private final PsiFileFactory getPsiFileFactory() {
                Lazy lazy = this.psiFileFactory$delegate;
                Object object = lazy.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-psiFileFactory>(...)");
                return (PsiFileFactory)object;
            }
        };
        this.changedUntrackedJavaClasses = new LinkedHashSet();
        this.javaFilesProcessor = !this.usePreciseJavaTracking ? new ChangedJavaFilesProcessor(reporter, (Function1<? super File, ? extends PsiFile>)((Function1)new Function1<File, PsiFile>(this){
            final /* synthetic */ IncrementalJvmCompilerRunner this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final PsiFile invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return IncrementalJvmCompilerRunner.access$getPsiFileProvider$p(this.this$0).javaFile(it);
            }
        })) : null;
    }

    public /* synthetic */ IncrementalJvmCompilerRunner(File file2, BuildReporter buildReporter, boolean bl, File file3, Collection collection, ModulesApiHistory modulesApiHistory, List list2, ClasspathChanges classpathChanges2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            list2 = SourcesUtilsKt.getDEFAULT_KOTLIN_SOURCE_FILES_EXTENSIONS();
        }
        this(file2, buildReporter, bl, file3, collection, modulesApiHistory, list2, classpathChanges2);
    }

    @Override
    @NotNull
    protected List<String> getKotlinSourceFilesExtensions() {
        return this.kotlinSourceFilesExtensions;
    }

    @Override
    protected boolean isICEnabled() {
        return IncrementalCompilation.isEnabledForJvm();
    }

    @Override
    @NotNull
    protected IncrementalJvmCachesManager createCacheManager(@NotNull K2JVMCompilerArguments args, @Nullable File projectDir) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new IncrementalJvmCachesManager(this.getCacheDirectory(), projectDir, new File(args.getDestination()), this.getReporter(), this.getWithSnapshot() || this.classpathChanges instanceof ClasspathChanges.ClasspathSnapshotEnabled, this.classpathChanges instanceof ClasspathChanges.ClasspathSnapshotEnabled.IncrementalRun);
    }

    @Override
    @NotNull
    protected File destinationDir(@NotNull K2JVMCompilerArguments args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return IncrementalJvmCompilerRunnerKt.getDestinationAsFile(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected IncrementalCompilerRunner.CompilationMode calculateSourcesToCompileImpl(@NotNull IncrementalJvmCachesManager caches, @NotNull ChangedFiles.Known changedFiles, @NotNull K2JVMCompilerArguments args, @NotNull MessageCollector messageCollector, @NotNull Map<String, ? extends AbiSnapshot> classpathAbiSnapshots) {
        IncrementalCompilerRunner.CompilationMode compilationMode;
        Intrinsics.checkNotNullParameter((Object)caches, (String)"caches");
        Intrinsics.checkNotNullParameter((Object)changedFiles, (String)"changedFiles");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter(classpathAbiSnapshots, (String)"classpathAbiSnapshots");
        try {
            compilationMode = this.calculateSourcesToCompileImpl(caches, changedFiles, args, classpathAbiSnapshots);
        }
        finally {
            this.psiFileProvider.getMessageCollector().flush(messageCollector);
            this.psiFileProvider.getMessageCollector().clear();
        }
        return compilationMode;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Map<String, AbiSnapshot> setupJarDependencies(@NotNull K2JVMCompilerArguments args, boolean withSnapshot, @NotNull BuildReporter reporter) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!withSnapshot) {
            return MapsKt.emptyMap();
        }
        HashMap abiSnapshots = new HashMap();
        Iterable iterable = IncrementalJvmCompilerRunnerKt.getClasspathAsList(args);
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.equals((String)FilesKt.getExtension((File)it), (String)"jar", (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            Either<Set<File>> result2 = this.modulesApiHistory.abiSnapshot(it);
            boolean bl2 = false;
            if (!(result2 instanceof Either.Success)) continue;
            Iterable $this$forEach$iv2 = (Iterable)((Either.Success)result2).getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                AbiSnapshot abiSnapshot2;
                File file2 = (File)element$iv2;
                boolean bl3 = false;
                if (AbiSnapshotImpl.Companion.read(file2, reporter) == null) continue;
                AbiSnapshot abiSnapshot3 = abiSnapshot2;
                boolean bl4 = false;
                Map map = abiSnapshots;
                String string2 = it.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.absolutePath");
                map.put(string2, abiSnapshot3);
            }
        }
        return abiSnapshots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final IncrementalCompilerRunner.CompilationMode calculateSourcesToCompileImpl(IncrementalJvmCachesManager caches, ChangedFiles.Known changedFiles, K2JVMCompilerArguments args, Map<String, ? extends AbiSnapshot> abiSnapshots) {
        DirtyData dirtyData;
        void $this$measure$iv;
        Collection<LookupSymbol> collection;
        void $this$measure$iv2;
        Object $this$map$iv;
        List<ClassSnapshotWithHash> list2;
        LookupSymbolKey $this$measure$iv3;
        Object $this$measure$iv4;
        long start$iv;
        boolean $i$f$measure;
        Object time$iv;
        ChangesEither changesEither;
        DirtyFilesContainer dirtyFiles = new DirtyFilesContainer(caches, this.getReporter(), this.getKotlinSourceFilesExtensions());
        this.initDirtyFiles(dirtyFiles, changedFiles);
        ClasspathChanges classpathChanges2 = this.classpathChanges;
        if (classpathChanges2 instanceof ClasspathChanges.ClasspathSnapshotEnabled.IncrementalRun.NoChanges) {
            changesEither = new ChangesEither.Known(SetsKt.emptySet(), SetsKt.emptySet());
        } else if (classpathChanges2 instanceof ClasspathChanges.ClasspathSnapshotEnabled.IncrementalRun.ToBeComputedByIncrementalCompiler) {
            ChangesEither.Known $i$a$-measure-IncrementalJvmCompilerRunner$calculateSourcesToCompileImpl$classpathChanges$32;
            BuildMetricsReporter buildMetricsReporter = this.getReporter();
            time$iv = BuildTime.COMPUTE_CLASSPATH_CHANGES;
            $i$f$measure = false;
            start$iv = System.nanoTime();
            $this$measure$iv4.startMeasure((BuildTime)time$iv, start$iv);
            try {
                List<ClassSnapshotWithHash> $i$a$-measure-IncrementalJvmCompilerRunner$calculateSourcesToCompileImpl$classpathChanges$1$32;
                Object time$iv2;
                BuildMetricsReporter $this$measure$iv5;
                boolean $i$a$-measure-IncrementalJvmCompilerRunner$calculateSourcesToCompileImpl$classpathChanges$32 = false;
                if (!(this.currentClasspathSnapshot == null)) {
                    String string2 = "Check failed.";
                    throw new IllegalStateException(string2.toString());
                }
                BuildMetricsReporter buildMetricsReporter2 = this.getReporter();
                BuildTime buildTime = BuildTime.LOAD_CURRENT_CLASSPATH_SNAPSHOT;
                IncrementalJvmCompilerRunner incrementalJvmCompilerRunner = this;
                boolean $i$f$measure2 = false;
                long start$iv2 = System.nanoTime();
                $this$measure$iv5.startMeasure((BuildTime)time$iv2, start$iv2);
                try {
                    List<ClassSnapshotWithHash> $i$a$-measure-IncrementalJvmCompilerRunner$calculateSourcesToCompileImpl$classpathChanges$1$1$22;
                    boolean $i$a$-measure-IncrementalJvmCompilerRunner$calculateSourcesToCompileImpl$classpathChanges$1$32 = false;
                    ClasspathSnapshot classpathSnapshot = CachedClasspathSnapshotSerializer.INSTANCE.load(((ClasspathChanges.ClasspathSnapshotEnabled.IncrementalRun.ToBeComputedByIncrementalCompiler)this.classpathChanges).getClasspathSnapshotFiles().getCurrentClasspathEntrySnapshotFiles());
                    BuildMetricsReporter buildMetricsReporter3 = this.getReporter();
                    BuildTime time$iv3 = BuildTime.REMOVE_DUPLICATE_CLASSES;
                    boolean $i$f$measure3 = false;
                    long start$iv3 = System.nanoTime();
                    $this$measure$iv3.startMeasure(time$iv3, start$iv3);
                    try {
                        boolean $i$a$-measure-IncrementalJvmCompilerRunner$calculateSourcesToCompileImpl$classpathChanges$1$1$22 = false;
                        $i$a$-measure-IncrementalJvmCompilerRunner$calculateSourcesToCompileImpl$classpathChanges$1$1$22 = ClasspathSnapshotShrinkerKt.removeDuplicateAndInaccessibleClasses(classpathSnapshot);
                    }
                    finally {
                        long end$iv = System.nanoTime();
                        $this$measure$iv3.endMeasure(time$iv3, end$iv);
                    }
                    $i$a$-measure-IncrementalJvmCompilerRunner$calculateSourcesToCompileImpl$classpathChanges$1$32 = $i$a$-measure-IncrementalJvmCompilerRunner$calculateSourcesToCompileImpl$classpathChanges$1$1$22;
                }
                finally {
                    long end$iv = System.nanoTime();
                    $this$measure$iv5.endMeasure((BuildTime)time$iv2, end$iv);
                }
                incrementalJvmCompilerRunner.currentClasspathSnapshot = $i$a$-measure-IncrementalJvmCompilerRunner$calculateSourcesToCompileImpl$classpathChanges$1$32;
                if (!(this.shrunkCurrentClasspathAgainstPreviousLookups == null)) {
                    time$iv2 = "Check failed.";
                    throw new IllegalStateException(time$iv2.toString());
                }
                $this$measure$iv5 = this.getReporter();
                time$iv2 = BuildTime.SHRINK_CURRENT_CLASSPATH_SNAPSHOT;
                incrementalJvmCompilerRunner = this;
                $i$f$measure2 = false;
                start$iv2 = System.nanoTime();
                $this$measure$iv5.startMeasure((BuildTime)time$iv2, start$iv2);
                try {
                    boolean bl = false;
                    List<ClassSnapshotWithHash> list3 = this.currentClasspathSnapshot;
                    Intrinsics.checkNotNull(list3);
                    list2 = ClasspathSnapshotShrinker.INSTANCE.shrink(list3, caches.getLookupCache(), (BuildMetricsReporter)this.getReporter());
                }
                finally {
                    long end$iv = System.nanoTime();
                    $this$measure$iv5.endMeasure((BuildTime)time$iv2, end$iv);
                }
                incrementalJvmCompilerRunner.shrunkCurrentClasspathAgainstPreviousLookups = list2;
                List<ClassSnapshotWithHash> list4 = this.shrunkCurrentClasspathAgainstPreviousLookups;
                Intrinsics.checkNotNull(list4);
                $i$a$-measure-IncrementalJvmCompilerRunner$calculateSourcesToCompileImpl$classpathChanges$32 = ClasspathChangesComputer.INSTANCE.computeChangedAndImpactedSet(list4, ((ClasspathChanges.ClasspathSnapshotEnabled.IncrementalRun.ToBeComputedByIncrementalCompiler)this.classpathChanges).getClasspathSnapshotFiles().getShrunkPreviousClasspathSnapshotFile(), (BuildMetricsReporter)this.getReporter()).getChanges$incremental_compilation_impl();
            }
            finally {
                long end$iv = System.nanoTime();
                $this$measure$iv4.endMeasure((BuildTime)time$iv, end$iv);
            }
            changesEither = $i$a$-measure-IncrementalJvmCompilerRunner$calculateSourcesToCompileImpl$classpathChanges$32;
        } else if (classpathChanges2 instanceof ClasspathChanges.ClasspathSnapshotEnabled.NotAvailableDueToMissingClasspathSnapshot) {
            changesEither = new ChangesEither.Unknown(BuildAttribute.CLASSPATH_SNAPSHOT_NOT_FOUND);
        } else if (classpathChanges2 instanceof ClasspathChanges.ClasspathSnapshotEnabled.NotAvailableForNonIncrementalRun) {
            changesEither = new ChangesEither.Unknown(BuildAttribute.UNKNOWN_CHANGES_IN_GRADLE_INPUTS);
        } else if (classpathChanges2 instanceof ClasspathChanges.ClasspathSnapshotDisabled) {
            $this$measure$iv4 = this.getReporter();
            time$iv = BuildTime.IC_ANALYZE_CHANGES_IN_DEPENDENCIES;
            $i$f$measure = false;
            start$iv = System.nanoTime();
            $this$measure$iv4.startMeasure((BuildTime)time$iv, start$iv);
            try {
                void $this$mapTo$iv$iv;
                BuildInfo buildInfo;
                boolean bl = false;
                if (BuildInfo.Companion.read(this.getLastBuildInfoFile()) == null) {
                    IncrementalCompilerRunner.CompilationMode compilationMode = new IncrementalCompilerRunner.CompilationMode.Rebuild(BuildAttribute.IC_IS_NOT_ENABLED);
                    return compilationMode;
                }
                BuildInfo lastBuildInfo = buildInfo;
                this.getReporter().reportVerbose((Function0<String>)((Function0)new Function0<String>(lastBuildInfo){
                    final /* synthetic */ BuildInfo $lastBuildInfo;
                    {
                        this.$lastBuildInfo = $lastBuildInfo;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Last Kotlin Build info -- " + this.$lastBuildInfo;
                    }
                }));
                $this$map$iv = caches.getLookupCache().getLookupSymbols();
                boolean $i$f$map = false;
                Iterable $i$f$measure4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    CharSequence charSequence2;
                    void it;
                    $this$measure$iv3 = (LookupSymbolKey)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    CharSequence charSequence3 = it.getScope();
                    if (StringsKt.isBlank((CharSequence)charSequence3)) {
                        boolean bl3 = false;
                        charSequence2 = it.getName();
                    } else {
                        charSequence2 = charSequence3;
                    }
                    collection2.add((String)charSequence2);
                }
                List scopes = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                ChangesEither changesEither2 = ChangesDetectionUtilsKt.getClasspathChanges(IncrementalJvmCompilerRunnerKt.getClasspathAsList(args), changedFiles, lastBuildInfo, this.modulesApiHistory, this.getReporter(), abiSnapshots, this.getWithSnapshot(), caches.getPlatformCache(), scopes);
                changesEither = changesEither2;
            }
            finally {
                long l = System.nanoTime();
                $this$measure$iv4.endMeasure((BuildTime)time$iv, l);
            }
        } else {
            if (classpathChanges2 instanceof ClasspathChanges.NotAvailableForJSCompiler) {
                throw new IllegalStateException(("Unexpected type for this code path: " + this.classpathChanges.getClass().getName() + '.').toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        ChangesEither classpathChanges3 = changesEither;
        $this$measure$iv4 = classpathChanges3;
        if ($this$measure$iv4 instanceof ChangesEither.Unknown) {
            this.getReporter().report((Function0<String>)((Function0)new Function0<String>(classpathChanges3){
                final /* synthetic */ ChangesEither $classpathChanges;
                {
                    this.$classpathChanges = $classpathChanges;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Could not get classpath's changes: " + ((ChangesEither.Unknown)this.$classpathChanges).getReason();
                }
            }));
            return new IncrementalCompilerRunner.CompilationMode.Rebuild(((ChangesEither.Unknown)classpathChanges3).getReason());
        }
        if (!($this$measure$iv4 instanceof ChangesEither.Known)) {
            throw new NoWhenBranchMatchedException();
        }
        dirtyFiles.addByDirtySymbols(((ChangesEither.Known)classpathChanges3).getLookupSymbols());
        this.dirtyClasspathChanges = ((ChangesEither.Known)classpathChanges3).getFqNames();
        dirtyFiles.addByDirtyClasses(((ChangesEither.Known)classpathChanges3).getFqNames());
        Unit unused2 = Unit.INSTANCE;
        $this$measure$iv4 = this.getReporter();
        time$iv = BuildTime.IC_ANALYZE_CHANGES_IN_JAVA_SOURCES;
        $i$f$measure = false;
        start$iv = System.nanoTime();
        $this$measure$iv4.startMeasure((BuildTime)time$iv, start$iv);
        try {
            boolean bl = false;
            if (!this.usePreciseJavaTracking) {
                ChangedJavaFilesProcessor changedJavaFilesProcessor = this.javaFilesProcessor;
                Intrinsics.checkNotNull((Object)changedJavaFilesProcessor);
                ChangesEither javaFilesChanges = changedJavaFilesProcessor.process(changedFiles);
                $this$map$iv = javaFilesChanges;
                if (!($this$map$iv instanceof ChangesEither.Known)) {
                    if ($this$map$iv instanceof ChangesEither.Unknown) {
                        IncrementalCompilerRunner.CompilationMode compilationMode = new IncrementalCompilerRunner.CompilationMode.Rebuild(((ChangesEither.Unknown)javaFilesChanges).getReason());
                        return compilationMode;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                Collection<LookupSymbol> affectedJavaSymbols = ((ChangesEither.Known)javaFilesChanges).getLookupSymbols();
                dirtyFiles.addByDirtySymbols(affectedJavaSymbols);
            } else {
                BuildAttribute rebuildReason = this.processChangedJava(changedFiles, caches);
                if (rebuildReason != null) {
                    list2 = new IncrementalCompilerRunner.CompilationMode.Rebuild(rebuildReason);
                    return list2;
                }
            }
            Unit $this$mapTo$iv$iv = Unit.INSTANCE;
        }
        finally {
            long destination$iv$iv = System.nanoTime();
            $this$measure$iv4.endMeasure((BuildTime)time$iv, destination$iv$iv);
        }
        time$iv = this.getReporter();
        Object time$iv4 = BuildTime.IC_ANALYZE_CHANGES_IN_ANDROID_LAYOUTS;
        boolean $i$f$measure5 = false;
        long start$iv4 = System.nanoTime();
        $this$measure$iv2.startMeasure((BuildTime)time$iv4, start$iv4);
        try {
            boolean bl = false;
            collection = this.processLookupSymbolsForAndroidLayouts(changedFiles);
        }
        finally {
            long end$iv = System.nanoTime();
            $this$measure$iv2.endMeasure((BuildTime)time$iv4, end$iv);
        }
        Collection<LookupSymbol> androidLayoutChanges = collection;
        time$iv4 = this.getReporter();
        BuildTime time$iv5 = BuildTime.IC_DETECT_REMOVED_CLASSES;
        boolean $i$f$measure6 = false;
        long start$iv5 = System.nanoTime();
        $this$measure$iv.startMeasure(time$iv5, start$iv5);
        try {
            boolean bl = false;
            dirtyData = this.getRemovedClassesChanges(caches, changedFiles);
        }
        finally {
            long end$iv = System.nanoTime();
            $this$measure$iv.endMeasure(time$iv5, end$iv);
        }
        DirtyData removedClassesChanges = dirtyData;
        dirtyFiles.addByDirtySymbols(androidLayoutChanges);
        dirtyFiles.addByDirtySymbols(removedClassesChanges.getDirtyLookupSymbols());
        dirtyFiles.addByDirtyClasses(removedClassesChanges.getDirtyClassesFqNames());
        dirtyFiles.addByDirtyClasses(removedClassesChanges.getDirtyClassesFqNamesForceRecompile());
        return new IncrementalCompilerRunner.CompilationMode.Incremental(dirtyFiles);
    }

    /*
     * WARNING - void declaration
     */
    private final BuildAttribute processChangedJava(ChangedFiles.Known changedFiles, IncrementalJvmCachesManager caches) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = CollectionsKt.plus((Collection)changedFiles.getModified(), (Iterable)changedFiles.getRemoved());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File p0 = (File)element$iv$iv;
            boolean bl = false;
            if (!FileUtilsKt.isJavaFile(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List javaFiles2 = (List)destination$iv$iv;
        for (File javaFile : javaFiles2) {
            PsiClass[] psiClassArray;
            if (caches.getPlatformCache().isTrackedFile(javaFile)) continue;
            if (!javaFile.exists()) {
                this.getReporter().report((Function0<String>)((Function0)new Function0<String>(javaFile){
                    final /* synthetic */ File $javaFile;
                    {
                        this.$javaFile = $javaFile;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Could not get changed for untracked removed java file " + this.$javaFile;
                    }
                }));
                return BuildAttribute.JAVA_CHANGE_UNTRACKED_FILE_IS_REMOVED;
            }
            PsiFile psiFile = this.psiFileProvider.javaFile(javaFile);
            if (!(psiFile instanceof PsiJavaFile)) {
                this.getReporter().report((Function0<String>)((Function0)new Function0<String>(psiFile){
                    final /* synthetic */ PsiFile $psiFile;
                    {
                        this.$psiFile = $psiFile;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        PsiFile psiFile = this.$psiFile;
                        return "[Precise Java tracking] Expected PsiJavaFile, got " + (psiFile != null ? psiFile.getClass() : null);
                    }
                }));
                return BuildAttribute.JAVA_CHANGE_UNEXPECTED_PSI;
            }
            Intrinsics.checkNotNullExpressionValue((Object)((PsiJavaFile)psiFile).getClasses(), (String)"psiFile.classes");
            for (PsiClass psiClass : psiClassArray) {
                String qualifiedName = psiClass.getQualifiedName();
                if (qualifiedName == null) {
                    this.getReporter().report((Function0<String>)((Function0)new Function0<String>(javaFile){
                        final /* synthetic */ File $javaFile;
                        {
                            this.$javaFile = $javaFile;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "[Precise Java tracking] Class with unknown qualified name in " + this.$javaFile;
                        }
                    }));
                    return BuildAttribute.JAVA_CHANGE_UNKNOWN_QUALIFIER;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"psiClass");
                ClassId classId = ClassId.topLevel(new FqName(qualifiedName));
                Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(FqName(qualifiedName))");
                this.processChangedUntrackedJavaClass(psiClass, classId);
            }
        }
        caches.getPlatformCache().markDirty((Collection)javaFiles2);
        return null;
    }

    private final void processChangedUntrackedJavaClass(PsiClass psiClass, ClassId classId) {
        this.changedUntrackedJavaClasses.add(classId);
        PsiClass[] psiClassArray = psiClass.getInnerClasses();
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"psiClass.innerClasses");
        for (PsiClass innerClass : psiClassArray) {
            String name;
            if (innerClass.getName() == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)innerClass, (String)"innerClass");
            ClassId classId2 = classId.createNestedClassId(Name.identifier(name));
            Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"classId.createNestedClassId(Name.identifier(name))");
            this.processChangedUntrackedJavaClass(innerClass, classId2);
        }
    }

    private final Collection<LookupSymbol> processLookupSymbolsForAndroidLayouts(ChangedFiles.Known changedFiles) {
        List result2 = new ArrayList();
        for (File file2 : CollectionsKt.plus((Collection)changedFiles.getModified(), (Iterable)changedFiles.getRemoved())) {
            String string2 = FilesKt.getExtension((File)file2).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            if (!Intrinsics.areEqual((Object)string2, (Object)"xml")) continue;
            String string3 = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.name");
            String layoutName = StringsKt.substringBeforeLast$default((String)string3, (char)'.', null, (int)2, null);
            result2.add(new LookupSymbol("<LAYOUT-CONTENT>", layoutName));
        }
        return result2;
    }

    @Override
    protected void preBuildHook(@NotNull K2JVMCompilerArguments args, @NotNull IncrementalCompilerRunner.CompilationMode compilationMode) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)compilationMode, (String)"compilationMode");
        if (compilationMode instanceof IncrementalCompilerRunner.CompilationMode.Incremental) {
            File destinationDir = IncrementalJvmCompilerRunnerKt.getDestinationAsFile(args);
            destinationDir.mkdirs();
            IncrementalJvmCompilerRunnerKt.setClasspathAsList(args, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)destinationDir), (Iterable)IncrementalJvmCompilerRunnerKt.getClasspathAsList(args)));
        }
    }

    @Override
    protected void updateCaches(@NotNull Services services, @NotNull IncrementalJvmCachesManager caches, @NotNull List<? extends GeneratedFile> generatedFiles, @NotNull ChangesCollector changesCollector) {
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)caches, (String)"caches");
        Intrinsics.checkNotNullParameter(generatedFiles, (String)"generatedFiles");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        JavaClassesTracker javaClassesTracker = services.get(JavaClassesTracker.class);
        BuildUtilKt.updateIncrementalCache((Iterable<? extends GeneratedFile>)generatedFiles, caches.getPlatformCache(), changesCollector, javaClassesTracker instanceof JavaClassesTrackerImpl ? (JavaClassesTrackerImpl)javaClassesTracker : null);
    }

    @Override
    public boolean runWithNoDirtyKotlinSources(@NotNull IncrementalJvmCachesManager caches) {
        Intrinsics.checkNotNullParameter((Object)caches, (String)"caches");
        return !caches.getPlatformCache().getObsoleteJavaClasses().isEmpty() || !((Collection)this.changedUntrackedJavaClasses).isEmpty();
    }

    @Override
    @NotNull
    protected Iterable<File> additionalDirtyFiles(@NotNull IncrementalJvmCachesManager caches, @NotNull List<? extends GeneratedFile> generatedFiles, @NotNull Services services) {
        Intrinsics.checkNotNullParameter((Object)caches, (String)"caches");
        Intrinsics.checkNotNullParameter(generatedFiles, (String)"generatedFiles");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        IncrementalJvmCache cache2 = caches.getPlatformCache();
        HashSet<File> result2 = new HashSet<File>();
        for (GeneratedFile generatedFile : generatedFiles) {
            if (!(generatedFile instanceof GeneratedJvmClass)) continue;
            LocalFileKotlinClass outputClass = ((GeneratedJvmClass)generatedFile).getOutputClass();
            switch (WhenMappings.$EnumSwitchMapping$0[outputClass.getClassHeader().getKind().ordinal()]) {
                case 1: {
                    FqName fqName2;
                    Intrinsics.checkNotNullExpressionValue((Object)outputClass.getClassName().getFqNameForClassNameWithoutDollars(), (String)"outputClass.className.fq\u2026orClassNameWithoutDollars");
                    File cachedSourceFile = cache2.getSourceFileIfClass(fqName2);
                    if (cachedSourceFile == null) break;
                    result2.add(cachedSourceFile);
                    break;
                }
                case 2: {
                    String string2 = outputClass.getClassName().getInternalName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"outputClass.className.internalName");
                    result2.addAll((Collection)IncrementalJvmCompilerRunner.additionalDirtyFiles$partsByFacadeName(cache2, string2));
                    break;
                }
                case 3: {
                    String string3 = outputClass.getClassHeader().getMultifileClassName();
                    Intrinsics.checkNotNull((Object)string3);
                    result2.addAll((Collection)IncrementalJvmCompilerRunner.additionalDirtyFiles$partsByFacadeName(cache2, string3));
                }
            }
        }
        return result2;
    }

    @Override
    @NotNull
    protected Iterable<LookupSymbol> additionalDirtyLookupSymbols() {
        Object object = this.javaFilesProcessor;
        return object != null && (object = ((ChangedJavaFilesProcessor)object).getAllChangedSymbols()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    protected Services.Builder makeServices(@NotNull K2JVMCompilerArguments args, @NotNull LookupTracker lookupTracker, @NotNull ExpectActualTracker expectActualTracker, @NotNull IncrementalJvmCachesManager caches, @NotNull Set<? extends File> dirtySources, boolean isIncremental) {
        Services.Builder builder2;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)lookupTracker, (String)"lookupTracker");
        Intrinsics.checkNotNullParameter((Object)expectActualTracker, (String)"expectActualTracker");
        Intrinsics.checkNotNullParameter((Object)caches, (String)"caches");
        Intrinsics.checkNotNullParameter(dirtySources, (String)"dirtySources");
        Services.Builder $this$makeServices_u24lambda_u2d16 = builder2 = super.makeServices((CommonCompilerArguments)args, lookupTracker, expectActualTracker, (IncrementalCachesManager)caches, dirtySources, isIncremental);
        boolean bl = false;
        String string2 = args.getModuleName();
        Intrinsics.checkNotNull((Object)string2);
        TargetId targetId = new TargetId(string2, "java-production");
        Map targetToCache = MapsKt.mapOf((Pair)TuplesKt.to((Object)targetId, (Object)caches.getPlatformCache()));
        IncrementalCompilationComponentsImpl incrementalComponents = new IncrementalCompilationComponentsImpl(targetToCache);
        $this$makeServices_u24lambda_u2d16.register(IncrementalCompilationComponents.class, incrementalComponents);
        if (this.usePreciseJavaTracking) {
            JavaClassesTrackerImpl changesTracker = new JavaClassesTrackerImpl(caches.getPlatformCache(), CollectionsKt.toSet((Iterable)this.changedUntrackedJavaClasses));
            this.changedUntrackedJavaClasses.clear();
            $this$makeServices_u24lambda_u2d16.register(JavaClassesTracker.class, changesTracker);
        }
        return builder2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected ExitCode runCompiler(@NotNull Set<? extends File> sourcesToCompile, @NotNull K2JVMCompilerArguments args, @NotNull IncrementalJvmCachesManager caches, @NotNull Services services, @NotNull MessageCollector messageCollector) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(sourcesToCompile, (String)"sourcesToCompile");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)caches, (String)"caches");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        K2JVMCompiler compiler = new K2JVMCompiler();
        List freeArgsBackup = CollectionsKt.toList((Iterable)args.getFreeArgs());
        Iterable iterable = sourcesToCompile;
        Collection collection2 = args.getFreeArgs();
        K2JVMCompilerArguments k2JVMCompilerArguments = args;
        boolean $i$f$map = false;
        void var10_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file2 = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAbsolutePath());
        }
        collection = (List)destination$iv$iv;
        k2JVMCompilerArguments.setFreeArgs(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        args.setAllowNoSourceFiles(true);
        ExitCode exitCode = compiler.exec(messageCollector, services, (CommonToolArguments)args);
        args.setFreeArgs(freeArgsBackup);
        this.reportPerformanceData(compiler.getDefaultPerformanceManager());
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void performWorkAfterSuccessfulCompilation(@NotNull IncrementalJvmCachesManager caches) {
        Intrinsics.checkNotNullParameter((Object)caches, (String)"caches");
        if (this.classpathChanges instanceof ClasspathChanges.ClasspathSnapshotEnabled) {
            void $this$measure$iv;
            BuildMetricsReporter buildMetricsReporter = this.getReporter();
            BuildTime time$iv = BuildTime.SHRINK_AND_SAVE_CURRENT_CLASSPATH_SNAPSHOT_AFTER_COMPILATION;
            boolean $i$f$measure = false;
            long start$iv = System.nanoTime();
            $this$measure$iv.startMeasure(time$iv, start$iv);
            try {
                boolean bl = false;
                ClasspathSnapshotShrinkerKt.shrinkAndSaveClasspathSnapshot((ClasspathChanges.ClasspathSnapshotEnabled)this.classpathChanges, caches.getLookupCache(), this.currentClasspathSnapshot, this.shrunkCurrentClasspathAgainstPreviousLookups, this.getReporter());
                Unit unit2 = Unit.INSTANCE;
            }
            finally {
                long end$iv = System.nanoTime();
                $this$measure$iv.endMeasure(time$iv, end$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<File> additionalDirtyFiles$partsByFacadeName(IncrementalJvmCache cache2, String facadeInternalName) {
        void $this$flatMapTo$iv$iv;
        Collection collection = cache2.getStableMultifileFacadeParts(facadeInternalName);
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        Collection parts2 = collection;
        Iterable $this$flatMap$iv = parts2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = cache2.sourcesByInternalName(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ psiFileProvider.1 access$getPsiFileProvider$p(IncrementalJvmCompilerRunner $this) {
        return $this.psiFileProvider;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinClassHeader.Kind.values().length];
            nArray[KotlinClassHeader.Kind.CLASS.ordinal()] = 1;
            nArray[KotlinClassHeader.Kind.MULTIFILE_CLASS.ordinal()] = 2;
            nArray[KotlinClassHeader.Kind.MULTIFILE_CLASS_PART.ordinal()] = 3;
            nArray[KotlinClassHeader.Kind.FILE_FACADE.ordinal()] = 4;
            nArray[KotlinClassHeader.Kind.SYNTHETIC_CLASS.ordinal()] = 5;
            nArray[KotlinClassHeader.Kind.UNKNOWN.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

