/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.IsCommonSourceKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/SealedInheritorInSameModuleChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "isFromCommonSource", "", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;)Z", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class SealedInheritorInSameModuleChecker
implements DeclarationChecker {
    @NotNull
    public static final SealedInheritorInSameModuleChecker INSTANCE = new SealedInheritorInSameModuleChecker();

    private SealedInheritorInSameModuleChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor2 instanceof ClassDescriptor) || !(declaration2 instanceof KtClassOrObject)) {
            return;
        }
        ModuleDescriptor currentModule = DescriptorUtilsKt.getModule(descriptor2);
        for (KtSuperTypeListEntry superTypeListEntry : ((KtClassOrObject)declaration2).getSuperTypeListEntries()) {
            Object superClass;
            UnwrappedType superType2;
            ClassifierDescriptor classifierDescriptor;
            KtTypeReference ktTypeReference;
            Object object = superTypeListEntry.getTypeReference();
            if (object == null) continue;
            KtTypeReference typeReference = ktTypeReference = object;
            Object object2 = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context.trace.bindingContext");
            object = BindingContextUtilsKt.getAbbreviatedTypeOrType(typeReference, (BindingContext)object2);
            if (object == null || (classifierDescriptor = (superType2 = ((KotlinType)object).unwrap()).getConstructor().getDeclarationDescriptor()) == null || !DescriptorUtilKt.isSealed((DeclarationDescriptor)(superClass = (object2 = classifierDescriptor)))) continue;
            if (this.isFromCommonSource((ClassifierDescriptor)descriptor2) && Intrinsics.areEqual((Object)DescriptorUtilsKt.getModule((DeclarationDescriptor)superClass), (Object)currentModule)) {
                return;
            }
            if (((ClassDescriptor)superClass).isExpect() || Intrinsics.areEqual((Object)DescriptorUtilsKt.getModule((DeclarationDescriptor)superClass), (Object)currentModule) && !this.isFromCommonSource((ClassifierDescriptor)superClass)) continue;
            context2.getTrace().report(Errors.SEALED_INHERITOR_IN_DIFFERENT_MODULE.on((KtTypeReference)((PsiElement)typeReference)));
        }
    }

    private final boolean isFromCommonSource(ClassifierDescriptor $this$isFromCommonSource) {
        KtFile ktFile;
        SourceFile sourceFile = $this$isFromCommonSource.getSource().getContainingFile();
        PsiSourceFile psiSourceFile = sourceFile instanceof PsiSourceFile ? (PsiSourceFile)sourceFile : null;
        Object object = psiSourceFile == null ? null : psiSourceFile.getPsiFile();
        KtFile ktFile2 = ktFile = object instanceof KtFile ? (KtFile)object : null;
        return ktFile == null ? false : ((object = IsCommonSourceKt.isCommonSource(ktFile)) == null ? false : (Boolean)object);
    }
}

