/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ic;

import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ULong;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.ic.CacheAccessorsKt;
import org.jetbrains.kotlin.ir.backend.js.ic.DataKt;
import org.jetbrains.kotlin.ir.backend.js.ic.PersistentCacheConsumer;
import org.jetbrains.kotlin.ir.backend.js.ic.SerializedIcDataForFile;
import org.jetbrains.kotlin.ir.util.IdSignature;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0016JJ\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u001c\u0010\r\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0010\u0012\b\u0012\u00060\tj\u0002`\u00110\u000f0\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0016JB\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u001c\u0010\r\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0010\u0012\b\u0012\u00060\tj\u0002`\u00110\u000f0\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00140\u0013H\u0016JB\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u001c\u0010\r\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0010\u0012\b\u0012\u00060\tj\u0002`\u00110\u000f0\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/PersistentCacheConsumerImpl;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/PersistentCacheConsumer;", "cachePath", "", "(Ljava/lang/String;)V", "commitFileFingerPrint", "", "path", "fingerprint", "", "Lorg/jetbrains/kotlin/ir/backend/js/ic/Hash;", "commitFileHashMapping", "cacheDst", "hashes", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/TransHash;", "sigResolver", "Lkotlin/Function1;", "", "commitICCacheData", "icData", "Lorg/jetbrains/kotlin/ir/backend/js/ic/SerializedIcDataForFile;", "commitInlineFunctions", "commitInlineGraph", "invalidateForFile", "ir.serialization.js"})
public final class PersistentCacheConsumerImpl
implements PersistentCacheConsumer {
    @NotNull
    private final String cachePath;

    public PersistentCacheConsumerImpl(@NotNull String cachePath) {
        Intrinsics.checkNotNullParameter((Object)cachePath, (String)"cachePath");
        this.cachePath = cachePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void commitFileHashMapping(String path2, String cacheDst, Collection<? extends Pair<? extends IdSignature, Long>> hashes, Function1<? super IdSignature, Integer> sigResolver) {
        String fileId = CacheAccessorsKt.access$createFileCacheId(path2);
        File fileDir = new File(new File(this.cachePath), fileId);
        File destination = new File(fileDir, cacheDst);
        fileDir.mkdirs();
        destination.createNewFile();
        Closeable closeable = new PrintWriter(destination);
        Throwable throwable = null;
        try {
            PrintWriter it = (PrintWriter)closeable;
            boolean bl = false;
            Iterator<? extends Pair<? extends IdSignature, Long>> iterator2 = hashes.iterator();
            while (iterator2.hasNext()) {
                Pair<? extends IdSignature, Long> hashData;
                Pair<? extends IdSignature, Long> pair = hashData = iterator2.next();
                IdSignature sig = (IdSignature)pair.component1();
                long hash = ((Number)pair.component2()).longValue();
                int sigId = ((Number)sigResolver.invoke((Object)sig)).intValue();
                String hashString = UStringsKt.toString-JSWoG40((long)ULong.constructor-impl((long)hash), (int)16);
                it.println("" + sigId + ':' + hashString);
            }
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    public void commitInlineFunctions(@NotNull String path2, @NotNull Collection<? extends Pair<? extends IdSignature, Long>> hashes, @NotNull Function1<? super IdSignature, Integer> sigResolver) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
        Intrinsics.checkNotNullParameter(sigResolver, (String)"sigResolver");
        this.commitFileHashMapping(path2, "inline.functions", hashes, sigResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitFileFingerPrint(@NotNull String path2, long fingerprint) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String fileId = CacheAccessorsKt.access$createFileCacheId(path2);
        File fileDir = new File(new File(this.cachePath), fileId);
        fileDir.mkdirs();
        File infoFile = new File(fileDir, "file.info");
        if (infoFile.exists()) {
            infoFile.delete();
        }
        infoFile.createNewFile();
        Closeable closeable = new PrintWriter(infoFile);
        Throwable throwable = null;
        try {
            PrintWriter it = (PrintWriter)closeable;
            boolean bl = false;
            it.println(path2);
            it.println(UStringsKt.toString-JSWoG40((long)ULong.constructor-impl((long)fingerprint), (int)16));
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    public void commitInlineGraph(@NotNull String path2, @NotNull Collection<? extends Pair<? extends IdSignature, Long>> hashes, @NotNull Function1<? super IdSignature, Integer> sigResolver) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
        Intrinsics.checkNotNullParameter(sigResolver, (String)"sigResolver");
        this.commitFileHashMapping(path2, "inline.graph", hashes, sigResolver);
    }

    @Override
    public void commitICCacheData(@NotNull String path2, @NotNull SerializedIcDataForFile icData) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)icData, (String)"icData");
        String fileId = CacheAccessorsKt.access$createFileCacheId(path2);
        File fileDir = new File(new File(this.cachePath), fileId);
        DataKt.writeData(icData, fileDir);
    }

    @Override
    public void invalidateForFile(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String fileId = CacheAccessorsKt.access$createFileCacheId(path2);
        File cacheDir = new File(this.cachePath);
        File fileDir = new File(cacheDir, fileId);
        new File(fileDir, "inline.functions").delete();
        new File(fileDir, "inline.graph").delete();
        new File(fileDir, "file.info").delete();
    }
}

