/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirRealSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionParameterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkParameterTypes", "function", "checkUninitializedParameter", "checkValOrVarParameter", "checkVarargParameters", "checkers"})
public final class FirFunctionParameterChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirFunctionParameterChecker INSTANCE = new FirFunctionParameterChecker();

    private FirFunctionParameterChecker() {
    }

    @Override
    public void check(@NotNull FirFunction declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkVarargParameters(declaration2, context2, reporter);
        this.checkParameterTypes(declaration2, context2, reporter);
        this.checkUninitializedParameter(declaration2, context2, reporter);
        this.checkValOrVarParameter(declaration2, context2, reporter);
    }

    private final void checkParameterTypes(FirFunction function2, CheckerContext context2, DiagnosticReporter reporter) {
        if (function2 instanceof FirAnonymousFunction) {
            return;
        }
        for (FirValueParameter valueParameter2 : function2.getValueParameters()) {
            ConeDiagnostic diagnostic;
            FirSourceElement firSourceElement;
            FirTypeRef returnTypeRef = valueParameter2.getReturnTypeRef();
            if (!(returnTypeRef instanceof FirErrorTypeRef) || Intrinsics.areEqual((Object)((firSourceElement = returnTypeRef.getSource()) == null ? null : firSourceElement.getKind()), (Object)FirRealSourceElementKind.INSTANCE) || !((diagnostic = ((FirErrorTypeRef)returnTypeRef).getDiagnostic()) instanceof ConeSimpleDiagnostic) || ((ConeSimpleDiagnostic)diagnostic).getKind() != DiagnosticKind.ValueParameterWithNoTypeAnnotation) continue;
            DiagnosticReporterKt.reportOnWithSuppression$default(reporter, valueParameter2, FirErrors.INSTANCE.getVALUE_PARAMETER_WITH_NO_TYPE_ANNOTATION(), context2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVarargParameters(FirFunction function2, CheckerContext context2, DiagnosticReporter reporter) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = function2.getValueParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirValueParameter it = (FirValueParameter)element$iv$iv;
            boolean bl = false;
            if (!it.isVararg()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List varargParameters = (List)destination$iv$iv;
        if (varargParameters.size() > 1) {
            for (FirValueParameter parameter : varargParameters) {
                DiagnosticReporterKt.reportOnWithSuppression$default(reporter, parameter, FirErrors.INSTANCE.getMULTIPLE_VARARG_PARAMETERS(), context2, null, 8, null);
            }
        }
        ConeKotlinType nullableNothingType = FirTypeUtilsKt.getConeType(context2.getSession().getBuiltinTypes().getNullableNothingType());
        for (FirValueParameter varargParameter : varargParameters) {
            ConeKotlinType coneKotlinType = ArrayUtilsKt.arrayElementType(FirTypeUtilsKt.getConeType(varargParameter.getReturnTypeRef()));
            if (coneKotlinType == null) continue;
            ConeKotlinType varargParameterType = coneKotlinType;
            if (!AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, SessionUtilsKt.getTypeContext(context2.getSession()), (KotlinTypeMarker)varargParameterType, (KotlinTypeMarker)nullableNothingType, false, 8, null) && (!FirHelpersKt.isInlineClass(varargParameterType, context2.getSession()) || ConeTypeUtilsKt.isUnsignedTypeOrNullableUnsignedType(varargParameterType))) continue;
            DiagnosticReporterKt.reportOnWithSuppression$default(reporter, varargParameter, FirErrors.INSTANCE.getFORBIDDEN_VARARG_PARAMETER_TYPE(), varargParameterType, context2, null, 16, null);
        }
    }

    private final void checkUninitializedParameter(FirFunction function2, CheckerContext context2, DiagnosticReporter reporter) {
        Iterator<FirValueParameter> iterator2 = function2.getValueParameters().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            FirValueParameter parameter = iterator2.next();
            FirExpression firExpression2 = parameter.getDefaultValue();
            if (firExpression2 == null) continue;
            firExpression2.accept(new FirVisitorVoid(function2, index2, reporter, context2){
                final /* synthetic */ FirFunction $function;
                final /* synthetic */ int $index;
                final /* synthetic */ DiagnosticReporter $reporter;
                final /* synthetic */ CheckerContext $context;
                {
                    this.$function = $function;
                    this.$index = $index;
                    this.$reporter = $reporter;
                    this.$context = $context;
                }

                public void visitElement(@NotNull FirElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    element.acceptChildren(this);
                }

                public void visitQualifiedAccessExpression(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression) {
                    FirResolvedNamedReference firResolvedNamedReference;
                    Intrinsics.checkNotNullParameter((Object)qualifiedAccessExpression, (String)"qualifiedAccessExpression");
                    FirPureAbstractElement firPureAbstractElement = qualifiedAccessExpression.getCalleeReference();
                    FirResolvedNamedReference firResolvedNamedReference2 = firResolvedNamedReference = firPureAbstractElement instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firPureAbstractElement : null;
                    if (firResolvedNamedReference == null) {
                        return;
                    }
                    FirResolvedNamedReference namedReference = firResolvedNamedReference;
                    ? obj = namedReference.getResolvedSymbol().getFir();
                    FirPureAbstractElement firPureAbstractElement2 = firPureAbstractElement = obj instanceof FirValueParameter ? (FirValueParameter)obj : null;
                    if (firPureAbstractElement == null) {
                        return;
                    }
                    FirPureAbstractElement referredParameter = firPureAbstractElement;
                    int referredParameterIndex = this.$function.getValueParameters().indexOf(referredParameter);
                    if (referredParameterIndex < 0) {
                        return;
                    }
                    if (this.$index <= referredParameterIndex) {
                        DiagnosticReporterKt.reportOnWithSuppression$default(this.$reporter, qualifiedAccessExpression, FirErrors.INSTANCE.getUNINITIALIZED_PARAMETER(), ((FirValueParameter)referredParameter).getSymbol(), this.$context, null, 16, null);
                    }
                }

                public void visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression) {
                    Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
                    this.visitQualifiedAccessExpression(propertyAccessExpression);
                }
            });
        }
    }

    private final void checkValOrVarParameter(FirFunction function2, CheckerContext context2, DiagnosticReporter reporter) {
        if (function2 instanceof FirConstructor && ((FirConstructor)function2).isPrimary()) {
            return;
        }
        for (FirValueParameter valueParameter2 : function2.getValueParameters()) {
            Object object;
            FirSourceElement source = valueParameter2.getSource();
            Object object2 = source;
            if ((object2 == null ? null : ((FirSourceElement)object2).getKind()) instanceof FirFakeSourceElementKind || (object2 = FirKeywordUtilsKt.getValOrVarKeyword(source)) == null) continue;
            Object it = object = object2;
            boolean bl = false;
            if (function2 instanceof FirConstructor) {
                DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getVAL_OR_VAR_ON_SECONDARY_CONSTRUCTOR_PARAMETER(), it, context2, null, 16, null);
                continue;
            }
            DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getVAL_OR_VAR_ON_FUN_PARAMETER(), it, context2, null, 16, null);
        }
    }
}

