/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler.jarfs;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.io.FileAccessorCache;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.FastJarFileSystemKt;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.FastJarHandler;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB \b\u0002\u0012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0016\u001a\u00020\u0005J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0012H\u0016J\b\u0010\u001a\u001a\u00020\u0012H\u0016J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0012H\u0016R0\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000bj\u0002`\r0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarFileSystem;", "Lcom/intellij/openapi/vfs/DeprecatedVirtualFileSystem;", "unmapBuffer", "Lkotlin/Function1;", "Ljava/nio/MappedByteBuffer;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)V", "cachedOpenFileHandles", "Lcom/intellij/util/io/FileAccessorCache;", "Ljava/io/File;", "Lkotlin/Pair;", "Ljava/io/RandomAccessFile;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/RandomAccessFileAndBuffer;", "getCachedOpenFileHandles$cli", "()Lcom/intellij/util/io/FileAccessorCache;", "myHandlers", "", "", "Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarHandler;", "getUnmapBuffer$cli", "()Lkotlin/jvm/functions/Function1;", "clearHandlersCache", "findFileByPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "getProtocol", "refresh", "asynchronous", "", "refreshAndFindFileByPath", "Companion", "cli"})
public final class FastJarFileSystem
extends DeprecatedVirtualFileSystem {
    private final Map<String, FastJarHandler> myHandlers;
    @NotNull
    private final FileAccessorCache<File, Pair<RandomAccessFile, MappedByteBuffer>> cachedOpenFileHandles;
    @NotNull
    private final Function1<MappedByteBuffer, Unit> unmapBuffer;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final FileAccessorCache<File, Pair<RandomAccessFile, MappedByteBuffer>> getCachedOpenFileHandles$cli() {
        return this.cachedOpenFileHandles;
    }

    @Override
    @NotNull
    public String getProtocol() {
        return "jar";
    }

    @Override
    @Nullable
    public VirtualFile findFileByPath(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Couple<String> pair = Companion.splitPath(path2);
        FastJarHandler fastJarHandler = this.myHandlers.get(pair.first);
        Intrinsics.checkNotNull((Object)fastJarHandler);
        Object object = pair.second;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pair.second");
        return fastJarHandler.findFileByPath((String)object);
    }

    @Override
    public void refresh(boolean asynchronous) {
    }

    @Override
    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return this.findFileByPath(path2);
    }

    public final void clearHandlersCache() {
        this.myHandlers.clear();
        this.cachedOpenFileHandles.clear();
    }

    @NotNull
    public final Function1<MappedByteBuffer, Unit> getUnmapBuffer$cli() {
        return this.unmapBuffer;
    }

    private FastJarFileSystem(Function1<? super MappedByteBuffer, Unit> unmapBuffer) {
        this.unmapBuffer = unmapBuffer;
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(new Function(this){
            final /* synthetic */ FastJarFileSystem this$0;

            public final FastJarHandler fun(@NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return new FastJarHandler(this.this$0, key);
            }
            {
                this.this$0 = fastJarFileSystem;
            }
        });
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"ConcurrentFactoryMap.cre\u2026FastJarFileSystem, key) }");
        this.myHandlers = concurrentMap;
        this.cachedOpenFileHandles = new FileAccessorCache<File, Pair<? extends RandomAccessFile, ? extends MappedByteBuffer>>(this, 20, 10){
            final /* synthetic */ FastJarFileSystem this$0;

            @NotNull
            protected Pair<RandomAccessFile, MappedByteBuffer> createAccessor(@NotNull File file2) throws IOException {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "r");
                return new Pair((Object)randomAccessFile, (Object)randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, randomAccessFile.length()));
            }

            protected void disposeAccessor(@NotNull Pair<? extends RandomAccessFile, ? extends MappedByteBuffer> fileAccessor) throws IOException {
                Intrinsics.checkNotNullParameter(fileAccessor, (String)"fileAccessor");
                ((RandomAccessFile)fileAccessor.getFirst()).close();
                this.this$0.getUnmapBuffer$cli().invoke(fileAccessor.getSecond());
            }

            public boolean isEqual(@NotNull File val1, @NotNull File val2) {
                Intrinsics.checkNotNullParameter((Object)val1, (String)"val1");
                Intrinsics.checkNotNullParameter((Object)val2, (String)"val2");
                return Intrinsics.areEqual((Object)val1, (Object)val2);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2);
            }
        };
    }

    public /* synthetic */ FastJarFileSystem(Function1 unmapBuffer, DefaultConstructorMarker $constructor_marker) {
        this((Function1<? super MappedByteBuffer, Unit>)unmapBuffer);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarFileSystem$Companion;", "", "()V", "createIfUnmappingPossible", "Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarFileSystem;", "splitPath", "Lcom/intellij/openapi/util/Couple;", "", "path", "cli"})
    public static final class Companion {
        @NotNull
        public final Couple<String> splitPath(@NotNull String path2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            int separator = StringsKt.indexOf$default((CharSequence)path2, (String)"!/", (int)0, (boolean)false, (int)6, null);
            boolean bl2 = bl = separator >= 0;
            if (!bl) {
                boolean $i$a$-require-FastJarFileSystem$Companion$splitPath$22 = false;
                String $i$a$-require-FastJarFileSystem$Companion$splitPath$22 = "Path in JarFileSystem must contain a separator: " + path2;
                throw new IllegalArgumentException($i$a$-require-FastJarFileSystem$Companion$splitPath$22.toString());
            }
            String $i$a$-require-FastJarFileSystem$Companion$splitPath$22 = path2;
            int n = 0;
            String string2 = $i$a$-require-FastJarFileSystem$Companion$splitPath$22.substring(n, separator);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String localPath = string2;
            String string3 = path2;
            int n2 = separator + 2;
            String string4 = string3.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            String pathInJar = string4;
            Couple<String> couple = Couple.of(localPath, pathInJar);
            Intrinsics.checkNotNullExpressionValue(couple, (String)"Couple.of(localPath, pathInJar)");
            return couple;
        }

        @Nullable
        public final FastJarFileSystem createIfUnmappingPossible() {
            Function1 function1 = FastJarFileSystemKt.access$prepareCleanerCallback();
            if (function1 == null) {
                return null;
            }
            Function1 cleanerCallBack = function1;
            return new FastJarFileSystem(cleanerCallBack, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

