/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import com.google.common.collect.ImmutableSet;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.backend.jvm.intrinsics.AndAnd;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArrayGet;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArrayIterator;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArraySet;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArraySize;
import org.jetbrains.kotlin.backend.jvm.intrinsics.BinaryOp;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Clone;
import org.jetbrains.kotlin.backend.jvm.intrinsics.CompareTo;
import org.jetbrains.kotlin.backend.jvm.intrinsics.EnumValueOf;
import org.jetbrains.kotlin.backend.jvm.intrinsics.EnumValues;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Equals;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ExplicitEquals;
import org.jetbrains.kotlin.backend.jvm.intrinsics.GetJavaObjectType;
import org.jetbrains.kotlin.backend.jvm.intrinsics.GetJavaPrimitiveType;
import org.jetbrains.kotlin.backend.jvm.intrinsics.HashCode;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Ieee754Equals;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Increment;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicShouldHaveBeenLowered;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Inv;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrCheckNotNull;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrDataClassArrayMemberHashCode;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrDataClassArrayMemberToString;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrIllegalArgumentException;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrNoWhenBranchMatchedException;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IsArrayOf;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IteratorNext;
import org.jetbrains.kotlin.backend.jvm.intrinsics.JavaClassProperty;
import org.jetbrains.kotlin.backend.jvm.intrinsics.JvmInvokeDynamic;
import org.jetbrains.kotlin.backend.jvm.intrinsics.KClassJavaProperty;
import org.jetbrains.kotlin.backend.jvm.intrinsics.MonitorInstruction;
import org.jetbrains.kotlin.backend.jvm.intrinsics.NewArray;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Not;
import org.jetbrains.kotlin.backend.jvm.intrinsics.NumberCast;
import org.jetbrains.kotlin.backend.jvm.intrinsics.OrOr;
import org.jetbrains.kotlin.backend.jvm.intrinsics.PrimitiveComparison;
import org.jetbrains.kotlin.backend.jvm.intrinsics.RangeTo;
import org.jetbrains.kotlin.backend.jvm.intrinsics.SignatureString;
import org.jetbrains.kotlin.backend.jvm.intrinsics.StringGetChar;
import org.jetbrains.kotlin.backend.jvm.intrinsics.StringPlus;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ThrowException;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ThrowKotlinNothingValueException;
import org.jetbrains.kotlin.backend.jvm.intrinsics.TypeOf;
import org.jetbrains.kotlin.backend.jvm.intrinsics.UnaryMinus;
import org.jetbrains.kotlin.backend.jvm.intrinsics.UnaryPlus;
import org.jetbrains.kotlin.backend.jvm.intrinsics.UnsafeCoerce;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ;2\u00020\u0001:\u0002;<B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0!0 H\u0002J*\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0!0 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001bH\u0002J2\u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0!0 2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020#H\u0002J*\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0!0 2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000fH\u0002J*\u0010+\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0!0 2\u0006\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u000200J\u001a\u00101\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002020!0 H\u0002J\u001a\u00103\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0!0 H\u0002J6\u00104\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002050!0 2\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u0002070\r2\u0006\u00108\u001a\u000209H\u0002J*\u0010:\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0!0 2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\u00020\u001b*\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods;", "", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbols", "Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols;", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols;)V", "anyFqn", "Lorg/jetbrains/kotlin/name/FqName;", "arrayFqn", "cloneableFqn", "intFqn", "intrinsicsMap", "", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods$Key;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "kClassFqn", "kotlinFqn", "kotlinJvmFqn", "kotlinJvmInternalUnsafeFqn", "kotlinReflectFqn", "stringFqn", "getSymbols", "()Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols;", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "getSymbol", "(Lorg/jetbrains/kotlin/builtins/PrimitiveType;)Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "arrayMethods", "", "Lkotlin/Pair;", "elementClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "arrayClass", "binaryFunForPrimitives", "name", "", "intrinsic", "parameter", "binaryFunForPrimitivesAcrossPrimitives", "binaryOp", "methodName", "opcode", "", "getIntrinsic", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "intrinsicsThatShouldHaveBeenLowered", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicShouldHaveBeenLowered;", "numberConversionMethods", "primitiveComparisonIntrinsics", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/PrimitiveComparison;", "typeToIrFun", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "operator", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "unaryFunForPrimitives", "Companion", "Key", "backend.jvm"})
public final class IrIntrinsicMethods {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final JvmSymbols symbols;
    @NotNull
    private final FqName kotlinFqn;
    @NotNull
    private final FqName kotlinJvmFqn;
    @NotNull
    private final FqName kotlinJvmInternalUnsafeFqn;
    @NotNull
    private final FqName kotlinReflectFqn;
    @NotNull
    private final FqName anyFqn;
    @NotNull
    private final FqName arrayFqn;
    @NotNull
    private final FqName cloneableFqn;
    @NotNull
    private final FqName intFqn;
    @NotNull
    private final FqName kClassFqn;
    @NotNull
    private final FqName stringFqn;
    @NotNull
    private final Map<Key, IntrinsicMethod> intrinsicsMap;
    @NotNull
    public static final String INTRINSICS_CLASS_NAME = "kotlin/jvm/internal/Intrinsics";
    @NotNull
    private static final Increment INC = new Increment(1);
    @NotNull
    private static final Increment DEC = new Increment(-1);
    @NotNull
    private static final ExplicitEquals EXPLICIT_EQUALS = new ExplicitEquals();

    /*
     * WARNING - void declaration
     */
    public IrIntrinsicMethods(@NotNull IrBuiltIns irBuiltIns, @NotNull JvmSymbols symbols2) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter((Object)symbols2, (String)"symbols");
        this.irBuiltIns = irBuiltIns;
        this.symbols = symbols2;
        this.kotlinFqn = StandardNames.BUILT_INS_PACKAGE_FQ_NAME;
        this.kotlinJvmFqn = new FqName("kotlin.jvm");
        this.kotlinJvmInternalUnsafeFqn = new FqName("kotlin.jvm.internal.unsafe");
        this.kotlinReflectFqn = StandardNames.KOTLIN_REFLECT_FQ_NAME;
        Object object = StandardNames.FqNames.any.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"any.toSafe()");
        this.anyFqn = object;
        object = StandardNames.FqNames.array.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"array.toSafe()");
        this.arrayFqn = object;
        object = StandardNames.FqNames.cloneable.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cloneable.toSafe()");
        this.cloneableFqn = object;
        object = StandardNames.FqNames._int.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"_int.toSafe()");
        this.intFqn = object;
        object = StandardNames.FqNames.kClass.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kClass.toSafe()");
        this.kClassFqn = object;
        object = StandardNames.FqNames.string.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"string.toSafe()");
        this.stringFqn = object;
        object = new Pair[32];
        object[0] = TuplesKt.to((Object)new Key(this.kotlinJvmFqn, new FqName("T"), "<get-javaClass>", CollectionsKt.emptyList()), (Object)JavaClassProperty.INSTANCE);
        object[1] = TuplesKt.to((Object)new Key(this.kotlinJvmFqn, this.kClassFqn, "<get-javaObjectType>", CollectionsKt.emptyList()), (Object)GetJavaObjectType.INSTANCE);
        object[2] = TuplesKt.to((Object)new Key(this.kotlinJvmFqn, this.kClassFqn, "<get-javaPrimitiveType>", CollectionsKt.emptyList()), (Object)GetJavaPrimitiveType.INSTANCE);
        object[3] = TuplesKt.to((Object)new Key(this.kotlinJvmFqn, this.kClassFqn, "<get-java>", CollectionsKt.emptyList()), (Object)KClassJavaProperty.INSTANCE);
        object[4] = TuplesKt.to((Object)new Key(this.kotlinJvmInternalUnsafeFqn, null, "monitorEnter", CollectionsKt.listOf((Object)this.anyFqn)), (Object)MonitorInstruction.MONITOR_ENTER);
        object[5] = TuplesKt.to((Object)new Key(this.kotlinJvmInternalUnsafeFqn, null, "monitorExit", CollectionsKt.listOf((Object)this.anyFqn)), (Object)MonitorInstruction.MONITOR_EXIT);
        object[6] = TuplesKt.to((Object)new Key(this.kotlinJvmFqn, this.arrayFqn, "isArrayOf", CollectionsKt.emptyList()), (Object)IsArrayOf.INSTANCE);
        object[7] = TuplesKt.to((Object)new Key(this.kotlinFqn, null, "arrayOfNulls", CollectionsKt.listOf((Object)this.intFqn)), (Object)NewArray.INSTANCE);
        object[8] = TuplesKt.to((Object)new Key(this.cloneableFqn, null, "clone", CollectionsKt.emptyList()), (Object)Clone.INSTANCE);
        object[9] = TuplesKt.to((Object)new Key(this.kotlinFqn, null, "enumValues", CollectionsKt.emptyList()), (Object)EnumValues.INSTANCE);
        object[10] = TuplesKt.to((Object)new Key(this.kotlinFqn, null, "enumValueOf", CollectionsKt.listOf((Object)this.stringFqn)), (Object)EnumValueOf.INSTANCE);
        object[11] = TuplesKt.to((Object)new Key(this.kotlinFqn, this.stringFqn, "plus", CollectionsKt.listOf((Object)this.anyFqn)), (Object)StringPlus.INSTANCE);
        object[12] = TuplesKt.to((Object)new Key(this.kotlinReflectFqn, null, "typeOf", CollectionsKt.emptyList()), (Object)TypeOf.INSTANCE);
        Key key = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getEqeqSymbol());
        Intrinsics.checkNotNull((Object)key);
        Object object2 = KtTokens.EQEQ;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"EQEQ");
        object[13] = TuplesKt.to((Object)key, (Object)new Equals((IElementType)object2));
        Key key2 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getEqeqeqSymbol());
        Intrinsics.checkNotNull((Object)key2);
        object2 = KtTokens.EQEQEQ;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"EQEQEQ");
        object[14] = TuplesKt.to((Object)key2, (Object)new Equals((IElementType)object2));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.irBuiltIns.getIeee754equalsFunByOperandType().get(this.irBuiltIns.getFloatClass());
        Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
        Key key3 = IrIntrinsicMethods.Companion.toKey(irSimpleFunctionSymbol);
        Intrinsics.checkNotNull((Object)key3);
        object2 = Type.FLOAT_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"FLOAT_TYPE");
        object[15] = TuplesKt.to((Object)key3, (Object)new Ieee754Equals((Type)object2));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = this.irBuiltIns.getIeee754equalsFunByOperandType().get(this.irBuiltIns.getDoubleClass());
        Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol2);
        Key key4 = IrIntrinsicMethods.Companion.toKey(irSimpleFunctionSymbol2);
        Intrinsics.checkNotNull((Object)key4);
        object2 = Type.DOUBLE_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"DOUBLE_TYPE");
        object[16] = TuplesKt.to((Object)key4, (Object)new Ieee754Equals((Type)object2));
        Key key5 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getBooleanNotSymbol());
        Intrinsics.checkNotNull((Object)key5);
        object[17] = TuplesKt.to((Object)key5, (Object)Not.INSTANCE);
        Key key6 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getNoWhenBranchMatchedExceptionSymbol());
        Intrinsics.checkNotNull((Object)key6);
        object[18] = TuplesKt.to((Object)key6, (Object)IrNoWhenBranchMatchedException.INSTANCE);
        Key key7 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getIllegalArgumentExceptionSymbol());
        Intrinsics.checkNotNull((Object)key7);
        object[19] = TuplesKt.to((Object)key7, (Object)IrIllegalArgumentException.INSTANCE);
        Key key8 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getCheckNotNullSymbol());
        Intrinsics.checkNotNull((Object)key8);
        object[20] = TuplesKt.to((Object)key8, (Object)IrCheckNotNull.INSTANCE);
        Key key9 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getAndandSymbol());
        Intrinsics.checkNotNull((Object)key9);
        object[21] = TuplesKt.to((Object)key9, (Object)AndAnd.INSTANCE);
        Key key10 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getOrorSymbol());
        Intrinsics.checkNotNull((Object)key10);
        object[22] = TuplesKt.to((Object)key10, (Object)OrOr.INSTANCE);
        Key key11 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getDataClassArrayMemberHashCodeSymbol());
        Intrinsics.checkNotNull((Object)key11);
        object[23] = TuplesKt.to((Object)key11, (Object)IrDataClassArrayMemberHashCode.INSTANCE);
        Key key12 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getDataClassArrayMemberToStringSymbol());
        Intrinsics.checkNotNull((Object)key12);
        object[24] = TuplesKt.to((Object)key12, (Object)IrDataClassArrayMemberToString.INSTANCE);
        Key key13 = IrIntrinsicMethods.Companion.toKey(this.symbols.getUnsafeCoerceIntrinsic());
        Intrinsics.checkNotNull((Object)key13);
        object[25] = TuplesKt.to((Object)key13, (Object)UnsafeCoerce.INSTANCE);
        Key key14 = IrIntrinsicMethods.Companion.toKey(this.symbols.getSignatureStringIntrinsic());
        Intrinsics.checkNotNull((Object)key14);
        object[26] = TuplesKt.to((Object)key14, (Object)SignatureString.INSTANCE);
        Key key15 = IrIntrinsicMethods.Companion.toKey(this.symbols.getThrowNullPointerException());
        Intrinsics.checkNotNull((Object)key15);
        object2 = Type.getObjectType("java/lang/NullPointerException");
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getObjectType(\"java/lang/NullPointerException\")");
        object[27] = TuplesKt.to((Object)key15, (Object)new ThrowException((Type)object2));
        Key key16 = IrIntrinsicMethods.Companion.toKey(this.symbols.getThrowTypeCastException());
        Intrinsics.checkNotNull((Object)key16);
        object2 = Type.getObjectType("kotlin/TypeCastException");
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getObjectType(\"kotlin/TypeCastException\")");
        object[28] = TuplesKt.to((Object)key16, (Object)new ThrowException((Type)object2));
        Key key17 = IrIntrinsicMethods.Companion.toKey(this.symbols.getThrowUnsupportedOperationException());
        Intrinsics.checkNotNull((Object)key17);
        object2 = Type.getObjectType("java/lang/UnsupportedOperationException");
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getObjectType(\"java/lang\u2026ortedOperationException\")");
        object[29] = TuplesKt.to((Object)key17, (Object)new ThrowException((Type)object2));
        Key key18 = IrIntrinsicMethods.Companion.toKey(this.symbols.getThrowKotlinNothingValueException());
        Intrinsics.checkNotNull((Object)key18);
        object[30] = TuplesKt.to((Object)key18, (Object)ThrowKotlinNothingValueException.INSTANCE);
        Key key19 = IrIntrinsicMethods.Companion.toKey(this.symbols.getJvmIndyIntrinsic());
        Intrinsics.checkNotNull((Object)key19);
        object[31] = TuplesKt.to((Object)key19, (Object)JvmInvokeDynamic.INSTANCE);
        Collection collection2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])object), (Iterable)this.numberConversionMethods()), (Iterable)this.unaryFunForPrimitives("plus", UnaryPlus.INSTANCE)), (Iterable)this.unaryFunForPrimitives("unaryPlus", UnaryPlus.INSTANCE)), (Iterable)this.unaryFunForPrimitives("minus", UnaryMinus.INSTANCE)), (Iterable)this.unaryFunForPrimitives("unaryMinus", UnaryMinus.INSTANCE)), (Iterable)this.unaryFunForPrimitives("inv", Inv.INSTANCE)), (Iterable)this.unaryFunForPrimitives("inc", INC)), (Iterable)this.unaryFunForPrimitives("dec", DEC)), (Iterable)this.unaryFunForPrimitives("hashCode", HashCode.INSTANCE)), (Iterable)this.binaryFunForPrimitives("equals", EXPLICIT_EQUALS, this.irBuiltIns.getAnyClass())), (Iterable)this.binaryFunForPrimitivesAcrossPrimitives("rangeTo", RangeTo.INSTANCE)), (Iterable)this.binaryOp("plus", 96)), (Iterable)this.binaryOp("minus", 100)), (Iterable)this.binaryOp("times", 104)), (Iterable)this.binaryOp("div", 108)), (Iterable)this.binaryOp("mod", 112)), (Iterable)this.binaryOp("rem", 112)), (Iterable)this.binaryOp("shl", 120)), (Iterable)this.binaryOp("shr", 122)), (Iterable)this.binaryOp("ushr", 124)), (Iterable)this.binaryOp("and", 126)), (Iterable)this.binaryOp("or", 128)), (Iterable)this.binaryOp("xor", 130)), (Iterable)this.binaryFunForPrimitivesAcrossPrimitives("compareTo", CompareTo.INSTANCE)), (Object)IrIntrinsicMethods.Companion.createKeyMapping(Not.INSTANCE, this.irBuiltIns.getBooleanClass(), "not", new IrClassifierSymbol[0]));
        object = new IrClassifierSymbol[]{this.irBuiltIns.getIntClass()};
        Collection collection3 = CollectionsKt.plus((Collection)collection2, (Object)IrIntrinsicMethods.Companion.createKeyMapping(StringGetChar.INSTANCE, this.irBuiltIns.getStringClass(), "get", (IrClassifierSymbol[])object));
        object = this.symbols.getPrimitiveIteratorsByType().values();
        Collection collection4 = collection3;
        IrIntrinsicMethods irIntrinsicMethods = this;
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void iteratorClass;
            IrClassSymbol irClassSymbol = (IrClassSymbol)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = IrIntrinsicMethods.Companion.createKeyMapping(IteratorNext.INSTANCE, (IrClassSymbol)iteratorClass, "next", new IrClassifierSymbol[0]);
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        Collection collection5 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection4, (Iterable)collection), (Iterable)this.arrayMethods());
        Map<IrClassifierSymbol, IrSimpleFunctionSymbol> map = this.irBuiltIns.getLessFunByOperandType();
        object = KtTokens.LT;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"LT");
        Collection collection6 = CollectionsKt.plus((Collection)collection5, (Iterable)this.primitiveComparisonIntrinsics(map, (KtSingleValueToken)object));
        Map<IrClassifierSymbol, IrSimpleFunctionSymbol> map2 = this.irBuiltIns.getLessOrEqualFunByOperandType();
        object = KtTokens.LTEQ;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"LTEQ");
        Collection collection7 = CollectionsKt.plus((Collection)collection6, (Iterable)this.primitiveComparisonIntrinsics(map2, (KtSingleValueToken)object));
        Map<IrClassifierSymbol, IrSimpleFunctionSymbol> map3 = this.irBuiltIns.getGreaterFunByOperandType();
        object = KtTokens.GT;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"GT");
        Collection collection8 = CollectionsKt.plus((Collection)collection7, (Iterable)this.primitiveComparisonIntrinsics(map3, (KtSingleValueToken)object));
        Map<IrClassifierSymbol, IrSimpleFunctionSymbol> map4 = this.irBuiltIns.getGreaterOrEqualFunByOperandType();
        object = KtTokens.GTEQ;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"GTEQ");
        irIntrinsicMethods.intrinsicsMap = MapsKt.toMap((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection8, (Iterable)this.primitiveComparisonIntrinsics(map4, (KtSingleValueToken)object)), (Iterable)this.intrinsicsThatShouldHaveBeenLowered()));
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    @NotNull
    public final JvmSymbols getSymbols() {
        return this.symbols;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, IntrinsicShouldHaveBeenLowered>> intrinsicsThatShouldHaveBeenLowered() {
        Key key;
        Key $dstr$_u24__u24$primitiveClassSymbol;
        Collection collection;
        Map.Entry item$iv$iv;
        Object $this$mapTo$iv$iv;
        Object $this$map$iv = this.symbols.getPrimitiveTypesToPrimitiveArrays();
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            boolean bl = false;
            IrClassSymbol primitiveClassSymbol = (IrClassSymbol)$dstr$_u24__u24$primitiveClassSymbol.getValue();
            String string2 = ((IrClass)primitiveClassSymbol.getOwner()).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"primitiveClassSymbol.owner.name.asString()");
            String name = string2;
            String arrayOfFunName = Intrinsics.stringPlus((String)CapitalizeDecapitalizeKt.decapitalizeAsciiOnly(name), (Object)"Of");
            key = new Key(this.kotlinFqn, null, arrayOfFunName, CollectionsKt.listOf((Object)IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)primitiveClassSymbol.getOwner())));
            collection.add(key);
        }
        $this$map$iv = new Key[]{new Key(this.kotlinFqn, this.anyFqn, "toString", CollectionsKt.emptyList()), new Key(this.kotlinFqn, null, "arrayOf", CollectionsKt.listOf((Object)this.arrayFqn)), new Key(this.stringFqn, null, "plus", CollectionsKt.listOf((Object)this.anyFqn))};
        $this$map$iv = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)CollectionsKt.listOf((Object[])$this$map$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            item$iv$iv = iterator2.next();
            $dstr$_u24__u24$primitiveClassSymbol = (Key)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            key = TuplesKt.to((Object)it, (Object)IntrinsicShouldHaveBeenLowered.INSTANCE);
            collection.add(key);
        }
        return (List)destination$iv$iv;
    }

    private final IrClassSymbol getSymbol(PrimitiveType $this$symbol) {
        IrType irType = this.irBuiltIns.getPrimitiveTypeToIrType().get((Object)$this$symbol);
        Intrinsics.checkNotNull((Object)irType);
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(irType);
        Intrinsics.checkNotNull((Object)irClassSymbol);
        return irClassSymbol;
    }

    @Nullable
    public final IntrinsicMethod getIntrinsic(@NotNull IrFunctionSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return this.intrinsicsMap.get(IrIntrinsicMethods.Companion.toKey(symbol2));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, IntrinsicMethod>> unaryFunForPrimitives(String name, IntrinsicMethod intrinsic) {
        void $this$mapTo$iv$iv;
        PrimitiveType[] $this$map$iv = PrimitiveType.values();
        boolean $i$f$map = false;
        PrimitiveType[] primitiveTypeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void type2;
            void var12_12 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = IrIntrinsicMethods.Companion.createKeyMapping(intrinsic, this.getSymbol((PrimitiveType)type2), name, new IrClassifierSymbol[0]);
            collection.add(pair);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, IntrinsicMethod>> binaryFunForPrimitivesAcrossPrimitives(String name, IntrinsicMethod intrinsic) {
        void $this$flatMapTo$iv$iv;
        PrimitiveType[] $this$flatMap$iv = PrimitiveType.values();
        boolean $i$f$flatMap = false;
        PrimitiveType[] primitiveTypeArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (void element$iv$iv : $this$flatMapTo$iv$iv) {
            void parameter = element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.binaryFunForPrimitives(name, intrinsic, this.getSymbol((PrimitiveType)parameter));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, IntrinsicMethod>> binaryFunForPrimitives(String name, IntrinsicMethod intrinsic, IrClassifierSymbol parameter) {
        void $this$mapTo$iv$iv;
        PrimitiveType[] $this$map$iv = PrimitiveType.values();
        boolean $i$f$map = false;
        PrimitiveType[] primitiveTypeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void type2;
            void var13_13 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrClassifierSymbol[] irClassifierSymbolArray = new IrClassifierSymbol[]{parameter};
            Pair pair = IrIntrinsicMethods.Companion.createKeyMapping(intrinsic, this.getSymbol((PrimitiveType)type2), name, irClassifierSymbolArray);
            collection.add(pair);
        }
        return (List)destination$iv$iv;
    }

    private final List<Pair<Key, IntrinsicMethod>> binaryOp(String methodName, int opcode) {
        return this.binaryFunForPrimitivesAcrossPrimitives(methodName, new BinaryOp(opcode));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, IntrinsicMethod>> numberConversionMethods() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = PrimitiveType.NUMBER_TYPES;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PrimitiveType type2 = (PrimitiveType)((Object)element$iv$iv);
            boolean bl = false;
            Iterable list$iv$iv = IrIntrinsicMethods.Companion.numberConversionMethods(this.getSymbol(type2));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)IrIntrinsicMethods.Companion.numberConversionMethods(this.irBuiltIns.getNumberClass()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, IntrinsicMethod>> arrayMethods() {
        void $this$flatMapTo$iv$iv;
        Map<IrClassSymbol, PrimitiveType> $this$flatMap$iv = this.symbols.getPrimitiveArraysToPrimitiveTypes();
        boolean $i$f$flatMap = false;
        Map<IrClassSymbol, PrimitiveType> map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry $dstr$array$primitiveType = element$iv$iv = iterator2.next();
            boolean bl = false;
            IrClassSymbol array2 = (IrClassSymbol)$dstr$array$primitiveType.getKey();
            PrimitiveType primitiveType = (PrimitiveType)((Object)$dstr$array$primitiveType.getValue());
            Iterable list$iv$iv = this.arrayMethods(this.getSymbol(primitiveType), array2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)this.arrayMethods(((IrTypeParameter)CollectionsKt.single(((IrClass)this.symbols.getArray().getOwner()).getTypeParameters())).getSymbol(), this.symbols.getArray()));
    }

    private final List<Pair<Key, IntrinsicMethod>> arrayMethods(IrClassifierSymbol elementClass, IrClassSymbol arrayClass) {
        Object[] objectArray = new Pair[6];
        objectArray[0] = IrIntrinsicMethods.Companion.createKeyMapping(ArraySize.INSTANCE, arrayClass, "<get-size>", new IrClassifierSymbol[0]);
        IrClassifierSymbol[] irClassifierSymbolArray = new IrClassifierSymbol[]{this.irBuiltIns.getIntClass()};
        objectArray[1] = IrIntrinsicMethods.Companion.createKeyMapping(NewArray.INSTANCE, arrayClass, "<init>", irClassifierSymbolArray);
        irClassifierSymbolArray = new IrClassifierSymbol[]{this.irBuiltIns.getIntClass(), elementClass};
        objectArray[2] = IrIntrinsicMethods.Companion.createKeyMapping(ArraySet.INSTANCE, arrayClass, "set", irClassifierSymbolArray);
        irClassifierSymbolArray = new IrClassifierSymbol[]{this.irBuiltIns.getIntClass()};
        objectArray[3] = IrIntrinsicMethods.Companion.createKeyMapping(ArrayGet.INSTANCE, arrayClass, "get", irClassifierSymbolArray);
        objectArray[4] = IrIntrinsicMethods.Companion.createKeyMapping(Clone.INSTANCE, arrayClass, "clone", new IrClassifierSymbol[0]);
        objectArray[5] = IrIntrinsicMethods.Companion.createKeyMapping(ArrayIterator.INSTANCE, arrayClass, "iterator", new IrClassifierSymbol[0]);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, PrimitiveComparison>> primitiveComparisonIntrinsics(Map<IrClassifierSymbol, ? extends IrSimpleFunctionSymbol> typeToIrFun, KtSingleValueToken operator) {
        void $this$mapNotNullTo$iv$iv;
        PrimitiveType[] $this$mapNotNull$iv = PrimitiveType.values();
        boolean $i$f$mapNotNull = false;
        PrimitiveType[] primitiveTypeArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var10_10 = $this$forEach$iv$iv$iv;
        int n = 0;
        int n2 = ((void)var10_10).length;
        while (n < n2) {
            Pair pair;
            Pair pair2;
            Pair pair3;
            void element$iv$iv$iv = var10_10[n];
            ++n;
            void element$iv$iv = element$iv$iv$iv;
            boolean bl = false;
            void primitiveType = element$iv$iv;
            boolean bl2 = false;
            IrType irType = this.getIrBuiltIns().getPrimitiveTypeToIrType().get(primitiveType);
            Intrinsics.checkNotNull((Object)irType);
            IrClassifierSymbol irPrimitiveClassifier = IrTypesKt.getClassifierOrFail(irType);
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = typeToIrFun.get(irPrimitiveClassifier);
            if (irSimpleFunctionSymbol == null) {
                pair3 = null;
            } else {
                IrSimpleFunctionSymbol irFunSymbol = irSimpleFunctionSymbol;
                Key key = IrIntrinsicMethods.Companion.toKey(irFunSymbol);
                Intrinsics.checkNotNull((Object)key);
                pair3 = pair2 = TuplesKt.to((Object)key, (Object)new PrimitiveComparison((PrimitiveType)primitiveType, operator));
            }
            if (pair2 == null) continue;
            Pair it$iv$iv = pair = pair2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\u0011\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\bH\u00c6\u0003J;\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0019\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods$Key;", "", "owner", "Lorg/jetbrains/kotlin/name/FqName;", "receiverParameterTypeName", "name", "", "valueParameterTypeNames", "", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getOwner", "()Lorg/jetbrains/kotlin/name/FqName;", "getReceiverParameterTypeName", "getValueParameterTypeNames", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "backend.jvm"})
    public static final class Key {
        @NotNull
        private final FqName owner;
        @Nullable
        private final FqName receiverParameterTypeName;
        @NotNull
        private final String name;
        @NotNull
        private final List<FqName> valueParameterTypeNames;

        public Key(@NotNull FqName owner, @Nullable FqName receiverParameterTypeName, @NotNull String name, @NotNull List<FqName> valueParameterTypeNames) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(valueParameterTypeNames, (String)"valueParameterTypeNames");
            this.owner = owner;
            this.receiverParameterTypeName = receiverParameterTypeName;
            this.name = name;
            this.valueParameterTypeNames = valueParameterTypeNames;
        }

        @NotNull
        public final FqName getOwner() {
            return this.owner;
        }

        @Nullable
        public final FqName getReceiverParameterTypeName() {
            return this.receiverParameterTypeName;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<FqName> getValueParameterTypeNames() {
            return this.valueParameterTypeNames;
        }

        @NotNull
        public final FqName component1() {
            return this.owner;
        }

        @Nullable
        public final FqName component2() {
            return this.receiverParameterTypeName;
        }

        @NotNull
        public final String component3() {
            return this.name;
        }

        @NotNull
        public final List<FqName> component4() {
            return this.valueParameterTypeNames;
        }

        @NotNull
        public final Key copy(@NotNull FqName owner, @Nullable FqName receiverParameterTypeName, @NotNull String name, @NotNull List<FqName> valueParameterTypeNames) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(valueParameterTypeNames, (String)"valueParameterTypeNames");
            return new Key(owner, receiverParameterTypeName, name, valueParameterTypeNames);
        }

        public static /* synthetic */ Key copy$default(Key key, FqName fqName2, FqName fqName3, String string2, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                fqName2 = key.owner;
            }
            if ((n & 2) != 0) {
                fqName3 = key.receiverParameterTypeName;
            }
            if ((n & 4) != 0) {
                string2 = key.name;
            }
            if ((n & 8) != 0) {
                list2 = key.valueParameterTypeNames;
            }
            return key.copy(fqName2, fqName3, string2, list2);
        }

        @NotNull
        public String toString() {
            return "Key(owner=" + this.owner + ", receiverParameterTypeName=" + this.receiverParameterTypeName + ", name=" + this.name + ", valueParameterTypeNames=" + this.valueParameterTypeNames + ')';
        }

        public int hashCode() {
            int result2 = this.owner.hashCode();
            result2 = result2 * 31 + (this.receiverParameterTypeName == null ? 0 : this.receiverParameterTypeName.hashCode());
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + ((Object)this.valueParameterTypeNames).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key key = (Key)other;
            if (!Intrinsics.areEqual((Object)this.owner, (Object)key.owner)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.receiverParameterTypeName, (Object)key.receiverParameterTypeName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)key.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.valueParameterTypeNames, key.valueParameterTypeNames);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JE\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0014H\u0002J\"\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\u001b2\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\u000e\u0010\u001d\u001a\u0004\u0018\u00010\f*\u00020\u001eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods$Companion;", "", "()V", "DEC", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Increment;", "EXPLICIT_EQUALS", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/ExplicitEquals;", "INC", "INTRINSICS_CLASS_NAME", "", "createKeyMapping", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods$Key;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "intrinsic", "klass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "name", "args", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "(Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;Ljava/lang/String;[Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;)Lkotlin/Pair;", "getParameterFqName", "Lorg/jetbrains/kotlin/name/FqName;", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "numberConversionMethods", "", "numberClass", "toKey", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "backend.jvm"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final Key toKey(IrFunctionSymbol $this$toKey) {
            Collection<FqName> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object;
            FqName fqName2;
            IrDeclarationParent parent2 = $this$toKey.getOwner().getParent();
            if (parent2 instanceof IrClass && IrUtilsKt.isFileClass((IrDeclaration)((Object)parent2))) {
                fqName2 = ((IrPackageFragment)((IrClass)parent2).getParent()).getFqName();
            } else if (parent2 instanceof IrClass) {
                object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((Object)parent2));
                if (object == null) {
                    return null;
                }
                fqName2 = object;
            } else if (parent2 instanceof IrPackageFragment) {
                fqName2 = ((IrPackageFragment)parent2).getFqName();
            } else {
                return null;
            }
            FqName ownerFqName = fqName2;
            FqName fqName3 = this.getParameterFqName($this$toKey.getOwner().getExtensionReceiverParameter());
            object = $this$toKey.getOwner().getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"owner.name.asString()");
            Object object2 = object;
            object = $this$toKey.getOwner().getValueParameters();
            Object object3 = object2;
            FqName fqName4 = fqName3;
            FqName fqName5 = ownerFqName;
            boolean $i$f$map = false;
            void var6_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                FqName fqName6 = this.getParameterFqName((IrValueParameter)p0);
                collection.add(fqName6);
            }
            Collection<FqName> collection2 = collection = (List)destination$iv$iv;
            Object object4 = object3;
            FqName fqName7 = fqName4;
            FqName fqName8 = fqName5;
            return new Key(fqName8, fqName7, (String)object4, (List<FqName>)collection2);
        }

        private final FqName getParameterFqName(IrValueParameter parameter) {
            IrClassifierSymbol irClassifierSymbol;
            IrValueParameter irValueParameter = parameter;
            if (irValueParameter == null) {
                irClassifierSymbol = null;
            } else {
                IrType irType = irValueParameter.getType();
                irClassifierSymbol = IrTypesKt.getClassifierOrNull(irType);
            }
            return this.getParameterFqName(irClassifierSymbol);
        }

        private final FqName getParameterFqName(IrClassifierSymbol parameter) {
            FqName fqName2;
            IrClassifierSymbol irClassifierSymbol = parameter;
            if (irClassifierSymbol == null) {
                fqName2 = null;
            } else {
                IrSymbolOwner irSymbolOwner;
                IrSymbolOwner irSymbolOwner2;
                IrSymbolOwner it = irSymbolOwner2 = (irSymbolOwner = irClassifierSymbol.getOwner());
                boolean bl = false;
                IrSymbolOwner irSymbolOwner3 = it;
                fqName2 = irSymbolOwner3 instanceof IrClass ? IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)it) : (irSymbolOwner3 instanceof IrTypeParameter ? new FqName(((IrTypeParameter)it).getName().asString()) : null);
            }
            return fqName2;
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Key, IntrinsicMethod> createKeyMapping(IntrinsicMethod intrinsic, IrClassSymbol klass, String name, IrClassifierSymbol ... args) {
            Collection<FqName> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)klass.getOwner());
            Intrinsics.checkNotNull((Object)fqName2);
            IrClassifierSymbol[] irClassifierSymbolArray = args;
            String string2 = name;
            FqName fqName3 = null;
            FqName fqName4 = fqName2;
            boolean $i$f$map = false;
            void var7_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                void var14_17 = item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                FqName fqName5 = Companion.getParameterFqName((IrClassifierSymbol)it);
                collection.add(fqName5);
            }
            collection = (List)destination$iv$iv;
            List list2 = collection;
            String string3 = string2;
            FqName fqName6 = fqName3;
            FqName fqName7 = fqName4;
            return TuplesKt.to((Object)new Key(fqName7, fqName6, string3, list2), (Object)intrinsic);
        }

        /*
         * WARNING - void declaration
         */
        private final List<Pair<Key, IntrinsicMethod>> numberConversionMethods(IrClassSymbol numberClass) {
            void $this$mapTo$iv$iv;
            ImmutableSet<Name> immutableSet = OperatorConventions.NUMBER_CONVERSIONS;
            Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"NUMBER_CONVERSIONS");
            Iterable $this$map$iv = immutableSet;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void method;
                Name name = (Name)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                IntrinsicMethod intrinsicMethod = NumberCast.INSTANCE;
                String string2 = method.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"method.asString()");
                Pair<Key, IntrinsicMethod> pair = Companion.createKeyMapping(intrinsicMethod, numberClass, string2, new IrClassifierSymbol[0]);
                collection.add(pair);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

