/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.ir.IrUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.VariableRemapper;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0013H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/MakePropertyDelegateMethodsStaticLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "isSyntheticDelegateMethod", "", "backend.jvm"})
final class MakePropertyDelegateMethodsStaticLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public MakePropertyDelegateMethodsStaticLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.transform((IrElementTransformer)this, (Object)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
        Collection<IrValueParameter> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrSimpleFunction irSimpleFunction;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (!this.isSyntheticDelegateMethod(declaration2)) {
            return super.visitSimpleFunction(declaration2);
        }
        IrValueParameter irValueParameter = declaration2.getDispatchReceiverParameter();
        if (irValueParameter == null) {
            return super.visitSimpleFunction(declaration2);
        }
        IrValueParameter oldParameter = irValueParameter;
        IrValueParameter newParameter = IrUtilsKt.copyTo$default(oldParameter, declaration2, null, 0, 0, 0, null, null, null, null, null, false, false, false, 8186, null);
        IrSimpleFunction $this$visitSimpleFunction_u24lambda_u2d1 = irSimpleFunction = declaration2;
        boolean bl = false;
        Object object = $this$visitSimpleFunction_u24lambda_u2d1.getValueParameters();
        Collection collection2 = CollectionsKt.listOf((Object)newParameter);
        IrSimpleFunction irSimpleFunction2 = $this$visitSimpleFunction_u24lambda_u2d1;
        boolean $i$f$map = false;
        void var11_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter2 = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            IrValueParameter irValueParameter3 = IrUtilsKt.copyTo$default((IrValueParameter)it, $this$visitSimpleFunction_u24lambda_u2d1, null, it.getIndex() + 1, 0, 0, null, null, null, null, null, false, false, false, 8186, null);
            collection.add(irValueParameter3);
        }
        collection = (List)destination$iv$iv;
        irSimpleFunction2.setValueParameters(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        $this$visitSimpleFunction_u24lambda_u2d1.setDispatchReceiverParameter(null);
        object = $this$visitSimpleFunction_u24lambda_u2d1.getBody();
        $this$visitSimpleFunction_u24lambda_u2d1.setBody((IrBody)(object == null ? null : ((IrBody)object).transform((IrElementTransformer)new VariableRemapper(MapsKt.mapOf((Pair)TuplesKt.to((Object)oldParameter, (Object)newParameter))), (Object)null)));
        return irSimpleFunction;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (this.isSyntheticDelegateMethod((IrSimpleFunction)expression2.getSymbol().getOwner())) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"`$delegate` method should not be called. Please either remove the call, or support remapping of dispatch receiver in MakePropertyDelegateMethodsStaticLowering: ", (Object)RenderIrElementKt.render((IrElement)expression2.getSymbol().getOwner())).toString());
        }
        return super.visitCall(expression2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSyntheticDelegateMethod(IrSimpleFunction $this$isSyntheticDelegateMethod) {
        if (!Intrinsics.areEqual((Object)$this$isSyntheticDelegateMethod.getOrigin(), (Object)IrDeclarationOrigin.PROPERTY_DELEGATE.INSTANCE)) return false;
        String string2 = $this$isSyntheticDelegateMethod.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name.asString()");
        if (!StringsKt.endsWith$default((String)string2, (String)"$delegate", (boolean)false, (int)2, null)) return false;
        return true;
    }
}

