/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.compiled;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.psi.compiled.ClsStubBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class ClassFileDecompilers {
    public final ExtensionPointName<Decompiler> EP_NAME = new ExtensionPointName("com.intellij.psi.classFileDecompiler");

    public static ClassFileDecompilers getInstance() {
        return ApplicationManager.getApplication().getService(ClassFileDecompilers.class);
    }

    private ClassFileDecompilers() {
        Application app = ApplicationManager.getApplication();
        if (!app.isHeadlessEnvironment() || app.isUnitTestMode()) {
            this.EP_NAME.addChangeListener(() -> BinaryFileTypeDecompilers.getInstance().notifyDecompilerSetChange(), null);
        }
    }

    @Nullable
    public Decompiler find(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ClassFileDecompilers.$$$reportNull$$$0(0);
        }
        return this.EP_NAME.findFirstSafe(decompiler -> (decompiler instanceof Light || decompiler instanceof Full) && decompiler.accepts(file2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/compiled/ClassFileDecompilers", "find"));
    }

    public static abstract class Full
    implements Decompiler {
        @NotNull
        public abstract ClsStubBuilder getStubBuilder();

        @NotNull
        public abstract FileViewProvider createFileViewProvider(@NotNull VirtualFile var1, @NotNull PsiManager var2, boolean var3);
    }

    public static abstract class Light
    implements Decompiler {
        @NotNull
        public abstract CharSequence getText(@NotNull VirtualFile var1) throws CannotDecompileException;

        public static class CannotDecompileException
        extends RuntimeException {
            public CannotDecompileException(String message2) {
                super(message2);
            }

            public CannotDecompileException(Throwable cause) {
                super(cause);
            }
        }
    }

    public static interface Decompiler {
        public boolean accepts(@NotNull VirtualFile var1);
    }
}

