/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.load.java.JavaClassFinder;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CodeAnalyzerInitializer;
import org.jetbrains.kotlin.resolve.jvm.JvmCodeAnalyzerInitializer;
import org.jetbrains.kotlin.resolve.jvm.TopPackageNamesProvider;
import org.jetbrains.kotlin.resolve.lazy.KotlinCodeAnalyzer;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0004H\u0007R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/load/java/AbstractJavaClassFinder;", "Lorg/jetbrains/kotlin/load/java/JavaClassFinder;", "()V", "javaSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getJavaSearchScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "setJavaSearchScope", "(Lcom/intellij/psi/search/GlobalSearchScope;)V", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "initialize", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "codeAnalyzer", "Lorg/jetbrains/kotlin/resolve/lazy/KotlinCodeAnalyzer;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "setProjectInstance", "setScope", "scope", "FilterOutKotlinSourceFilesScope", "frontend.java"})
public abstract class AbstractJavaClassFinder
implements JavaClassFinder {
    protected Project project;
    protected GlobalSearchScope javaSearchScope;

    @NotNull
    protected final Project getProject() {
        Project project = this.project;
        if (project != null) {
            return project;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        throw null;
    }

    protected final void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @NotNull
    protected final GlobalSearchScope getJavaSearchScope() {
        GlobalSearchScope globalSearchScope = this.javaSearchScope;
        if (globalSearchScope != null) {
            return globalSearchScope;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"javaSearchScope");
        throw null;
    }

    protected final void setJavaSearchScope(@NotNull GlobalSearchScope globalSearchScope) {
        Intrinsics.checkNotNullParameter((Object)globalSearchScope, (String)"<set-?>");
        this.javaSearchScope = globalSearchScope;
    }

    @Inject
    public final void setScope(@NotNull GlobalSearchScope scope2) {
        GlobalSearchScope globalSearchScope;
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        if (Intrinsics.areEqual((Object)scope2, (Object)GlobalSearchScope.EMPTY_SCOPE)) {
            GlobalSearchScope globalSearchScope2 = GlobalSearchScope.EMPTY_SCOPE;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"{\n                GlobalSearchScope.EMPTY_SCOPE\n            }");
            globalSearchScope = globalSearchScope2;
        } else {
            globalSearchScope = new FilterOutKotlinSourceFilesScope(scope2);
        }
        this.setJavaSearchScope(globalSearchScope);
    }

    @Inject
    public void setProjectInstance(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.setProject(project);
    }

    @PostConstruct
    public void initialize(@NotNull BindingTrace trace, @NotNull KotlinCodeAnalyzer codeAnalyzer, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull JvmTarget jvmTarget) {
        JvmCodeAnalyzerInitializer jvmCodeAnalyzerInitializer;
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)codeAnalyzer, (String)"codeAnalyzer");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)jvmTarget, (String)"jvmTarget");
        Object object = CodeAnalyzerInitializer.Companion.getInstance(this.getProject());
        JvmCodeAnalyzerInitializer jvmCodeAnalyzerInitializer2 = jvmCodeAnalyzerInitializer = object instanceof JvmCodeAnalyzerInitializer ? (JvmCodeAnalyzerInitializer)object : null;
        if (jvmCodeAnalyzerInitializer != null) {
            object = codeAnalyzer.getModuleDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"codeAnalyzer.moduleDescriptor");
            jvmCodeAnalyzerInitializer.initialize(trace, (ModuleDescriptor)object, codeAnalyzer, languageVersionSettings, jvmTarget);
        }
    }

    @Override
    @Nullable
    public JavaClass findClass(@NotNull ClassId classId) {
        return JavaClassFinder.DefaultImpls.findClass(this, classId);
    }

    @Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0016R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/load/java/AbstractJavaClassFinder$FilterOutKotlinSourceFilesScope;", "Lcom/intellij/psi/search/DelegatingGlobalSearchScope;", "Lorg/jetbrains/kotlin/resolve/jvm/TopPackageNamesProvider;", "baseScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lorg/jetbrains/kotlin/load/java/AbstractJavaClassFinder;Lcom/intellij/psi/search/GlobalSearchScope;)V", "base", "getBase", "()Lcom/intellij/psi/search/GlobalSearchScope;", "topPackageNames", "", "", "getTopPackageNames", "()Ljava/util/Set;", "contains", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getProject", "Lcom/intellij/openapi/project/Project;", "toString", "frontend.java"})
    public final class FilterOutKotlinSourceFilesScope
    extends DelegatingGlobalSearchScope
    implements TopPackageNamesProvider {
        @NotNull
        private final GlobalSearchScope base;

        public FilterOutKotlinSourceFilesScope(GlobalSearchScope baseScope) {
            Intrinsics.checkNotNullParameter((Object)AbstractJavaClassFinder.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)baseScope, (String)"baseScope");
            super(baseScope);
            GlobalSearchScope globalSearchScope = this.myBaseScope;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"myBaseScope");
            this.base = globalSearchScope;
        }

        @Override
        @Nullable
        public Set<String> getTopPackageNames() {
            GlobalSearchScope globalSearchScope = this.myBaseScope;
            TopPackageNamesProvider topPackageNamesProvider = globalSearchScope instanceof TopPackageNamesProvider ? (TopPackageNamesProvider)((Object)globalSearchScope) : null;
            return topPackageNamesProvider == null ? null : topPackageNamesProvider.getTopPackageNames();
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return (file2.isDirectory() || file2.getFileType() != KotlinFileType.INSTANCE) && this.myBaseScope.contains(file2);
        }

        @NotNull
        public final GlobalSearchScope getBase() {
            return this.base;
        }

        @Override
        @NotNull
        public Project getProject() {
            return AbstractJavaClassFinder.this.getProject();
        }

        @Override
        @NotNull
        public String toString() {
            return Intrinsics.stringPlus((String)"JCFI: ", (Object)this.myBaseScope);
        }
    }
}

