/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 5, 0}, k=2, xi=50, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\f\u001a\u00020\r\u001a&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u0012\u001a\u00020\u0001*\u00020\r2\u0006\u0010\n\u001a\u00020\u000b\"\u0019\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0013"}, d2={"name", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getName", "(Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "setInlineCallMetadata", "", "expression", "psiElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "nameRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "aliasedName", "js.translator"})
@JvmName(name="InlineUtils")
public final class InlineUtils {
    public static final void setInlineCallMetadata(@NotNull JsExpression expression2, @NotNull KtElement psiElement, @NotNull CallableDescriptor descriptor2, @NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        boolean bl = CallExpressionTranslator.shouldBeInlined(descriptor2);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = Intrinsics.stringPlus((String)"Expected descriptor of callable, that should be inlined, but got: ", (Object)descriptor2);
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        Object[] objectArray = new JsName[2];
        objectArray[0] = InlineUtils.aliasedName(context2, descriptor2);
        JsName jsName = context2.getInnerNameForDescriptor(descriptor2);
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"context.getInnerNameForDescriptor(descriptor)");
        objectArray[1] = jsName;
        Set candidateNames = SetsKt.setOf((Object[])objectArray);
        RecursiveJsVisitor visitor2 = new RecursiveJsVisitor(candidateNames, descriptor2, psiElement){
            final /* synthetic */ Set<JsName> $candidateNames;
            final /* synthetic */ CallableDescriptor $descriptor;
            final /* synthetic */ KtElement $psiElement;
            {
                this.$candidateNames = $candidateNames;
                this.$descriptor = $descriptor;
                this.$psiElement = $psiElement;
            }

            public void visitInvocation(@NotNull JsInvocation invocation) {
                DeclarationDescriptor declarationDescriptor;
                JsName jsName;
                Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
                super.visitInvocation(invocation);
                if (CollectionsKt.contains((Iterable)this.$candidateNames, (Object)InlineUtils.getName(invocation)) || Intrinsics.areEqual((jsName = InlineUtils.getName(invocation)) == null ? null : ((declarationDescriptor = MetadataProperties.getDescriptor(jsName)) == null ? null : declarationDescriptor.getOriginal()), (Object)this.$descriptor.getOriginal())) {
                    MetadataProperties.setDescriptor(invocation, this.$descriptor);
                    MetadataProperties.setInline(invocation, (Boolean)true);
                    MetadataProperties.setPsiElement(invocation, (PsiElement)this.$psiElement);
                }
            }
        };
        visitor2.accept((JsNode)expression2);
        context2.addInlineCall(descriptor2);
    }

    public static final void setInlineCallMetadata(@NotNull JsExpression expression2, @NotNull KtElement psiElement, @NotNull ResolvedCall<?> resolvedCall2, @NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        CallableDescriptor callableDescriptor = PsiUtils.getFunctionDescriptor(resolvedCall2);
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getFunctionDescriptor(resolvedCall)");
        InlineUtils.setInlineCallMetadata(expression2, psiElement, callableDescriptor, context2);
    }

    public static final void setInlineCallMetadata(@NotNull JsNameRef nameRef, @NotNull KtElement psiElement, @NotNull CallableDescriptor descriptor2, @NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (MetadataProperties.isInline(nameRef) != null) {
            return;
        }
        MetadataProperties.setDescriptor(nameRef, descriptor2);
        MetadataProperties.setInline(nameRef, (Boolean)true);
        MetadataProperties.setPsiElement(nameRef, (PsiElement)psiElement);
        context2.addInlineCall(descriptor2);
    }

    @NotNull
    public static final JsName aliasedName(@NotNull TranslationContext $this$aliasedName, @NotNull CallableDescriptor descriptor2) {
        HasMetadata hasMetadata;
        Intrinsics.checkNotNullParameter((Object)$this$aliasedName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        JsExpression alias = $this$aliasedName.getAliasForDescriptor(descriptor2);
        HasMetadata hasMetadata2 = alias instanceof JsNameRef ? (JsNameRef)alias : null;
        JsName aliasName = hasMetadata2 == null ? null : hasMetadata2.getName();
        hasMetadata2 = aliasName;
        if (hasMetadata2 == null) {
            JsName jsName = $this$aliasedName.getNameForDescriptor(descriptor2);
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getNameForDescriptor(descriptor)");
            hasMetadata = jsName;
        } else {
            hasMetadata = hasMetadata2;
        }
        return hasMetadata;
    }

    @Nullable
    public static final JsName getName(@Nullable JsExpression $this$name) {
        JsName jsName;
        JsExpression jsExpression = $this$name;
        if (jsExpression instanceof JsInvocation) {
            JsExpression jsExpression2 = ((JsInvocation)$this$name).getQualifier();
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"this.qualifier");
            JsExpression qualifier = jsExpression2;
            jsName = InvocationUtilsKt.isCallInvocation((JsInvocation)$this$name) ? InlineUtils.getName(((JsNameRef)qualifier).getQualifier()) : InlineUtils.getName(qualifier);
        } else {
            jsName = jsExpression instanceof JsNameRef ? ((JsNameRef)$this$name).getName() : null;
        }
        return jsName;
    }
}

