/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedType;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFileKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.builtins.CompileTimeUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.Common;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.ExceptionState;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 5, 0}, k=2, xi=50, d1={"\u0000\u009a\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a \u0010\u0000\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0000\u001a2\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0000\u001a\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u0004\u0018\u00010\u0010H\u0000\u001a\u0012\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\"\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0007*\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\fH\u0000\u001a\f\u0010\u001d\u001a\u00020\u001e*\u00020\u0019H\u0000\u001a\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u0010*\u0004\u0018\u00010\u00102\u0006\u0010 \u001a\u00020\u0019H\u0000\u001a\u000e\u0010!\u001a\u0004\u0018\u00010\"*\u00020\u0019H\u0000\u001a\u000e\u0010#\u001a\u0004\u0018\u00010\u001e*\u00020\u0014H\u0000\u001a\u000e\u0010$\u001a\u0004\u0018\u00010\"*\u00020\u0019H\u0000\u001a\n\u0010%\u001a\u00020\u0019*\u00020\u0019\u001a\u000e\u0010&\u001a\u0004\u0018\u00010'*\u00020\u0019H\u0000\u001a\u0014\u0010(\u001a\u0004\u0018\u00010\u0003*\u00020\f2\u0006\u0010)\u001a\u00020*\u001a\u0014\u0010+\u001a\u00020\u0005*\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\n\u0010,\u001a\u00020\u001e*\u00020-\u001a\f\u0010.\u001a\u00020\u0005*\u00020\u0003H\u0000\u001a\f\u0010/\u001a\u00020\u0005*\u00020\u0003H\u0000\u001a\f\u00100\u001a\u00020\u0005*\u00020\u0003H\u0000\u001a\f\u00101\u001a\u00020\u0005*\u00020\u0003H\u0000\u001a\f\u00102\u001a\u00020\u0005*\u00020\u0003H\u0000\u001a,\u00103\u001a\u0006\u0012\u0002\b\u000304*\u0004\u0018\u00010\u00182\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u00105\u001a\u00020*2\b\b\u0002\u00106\u001a\u00020*\u001a\u0014\u00107\u001a\u000208*\u00020\u00102\u0006\u0010\u000b\u001a\u000208H\u0000\u001a\u001e\u00109\u001a\b\u0012\u0004\u0012\u0002H;0:\"\u0004\b\u0000\u0010;*\b\u0012\u0004\u0012\u0002H;04H\u0000\u001a \u0010<\u001a\u0006\u0012\u0002\b\u00030:*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00072\u0006\u0010=\u001a\u00020\u0003H\u0000\u001a\u0016\u0010>\u001a\u00020\u0010*\u0004\u0018\u00010\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006?"}, d2={"getPrimitiveClass", "Ljava/lang/Class;", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "asObject", "", "getTypeArguments", "", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "mapper", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "extractNonLocalDeclarations", "getAnnotation", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "annotation", "Lorg/jetbrains/kotlin/name/FqName;", "getArgsForMethodInvocation", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "args", "getBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "getCapitalizedFileName", "", "getCorrectReceiverByFunction", "irFunction", "getDispatchReceiver", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "getEvaluateIntrinsicValue", "getExtensionReceiver", "getLastOverridden", "getReceiver", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getVarargType", "index", "", "hasAnnotation", "internalName", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isFunction", "isInterface", "isPrimitiveArray", "isThrowable", "isTypeParameter", "toIrConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "startOffset", "endOffset", "toIrExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "toPrimitive", "Lorg/jetbrains/kotlin/ir/interpreter/state/Primitive;", "T", "toPrimitiveStateArray", "type", "toState", "ir.interpreter"})
public final class UtilsKt {
    @Nullable
    public static final IrValueParameterSymbol getDispatchReceiver(@NotNull IrFunction $this$getDispatchReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$getDispatchReceiver, (String)"<this>");
        IrValueParameter irValueParameter = $this$getDispatchReceiver.getDispatchReceiverParameter();
        return irValueParameter == null ? null : irValueParameter.getSymbol();
    }

    @Nullable
    public static final IrValueParameterSymbol getExtensionReceiver(@NotNull IrFunction $this$getExtensionReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$getExtensionReceiver, (String)"<this>");
        IrValueParameter irValueParameter = $this$getExtensionReceiver.getExtensionReceiverParameter();
        return irValueParameter == null ? null : irValueParameter.getSymbol();
    }

    @Nullable
    public static final IrSymbol getReceiver(@NotNull IrFunction $this$getReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$getReceiver, (String)"<this>");
        IrValueParameterSymbol irValueParameterSymbol = UtilsKt.getDispatchReceiver($this$getReceiver);
        return irValueParameterSymbol == null ? (IrSymbol)UtilsKt.getExtensionReceiver($this$getReceiver) : (IrSymbol)irValueParameterSymbol;
    }

    @Nullable
    public static final IrBody getBody(@NotNull IrFunctionAccessExpression $this$getBody) {
        Intrinsics.checkNotNullParameter((Object)$this$getBody, (String)"<this>");
        return ((IrFunctionSymbol)$this$getBody.getSymbol()).getOwner().getBody();
    }

    @NotNull
    public static final IrExpression toIrExpression(@NotNull State $this$toIrExpression, @NotNull IrExpression expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)$this$toIrExpression, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        int start = expression2.getStartOffset();
        int end = expression2.getEndOffset();
        IrType type2 = IrTypesKt.makeNotNull(expression2.getType());
        State state = $this$toIrExpression;
        if (state instanceof Primitive) {
            irExpression = ((Primitive)$this$toIrExpression).getValue() == null ? (IrExpression)UtilsKt.toIrConst(((Primitive)$this$toIrExpression).getValue(), type2, start, end) : (IrTypePredicatesKt.isPrimitiveType$default(type2, false, 1, null) || IrTypePredicatesKt.isString(type2) ? (IrExpression)UtilsKt.toIrConst(((Primitive)$this$toIrExpression).getValue(), type2, start, end) : expression2);
        } else if (state instanceof Complex) {
            IrSimpleType stateType = IrUtilsKt.getDefaultType($this$toIrExpression.getIrClass());
            irExpression = IrTypePredicatesKt.isUnsignedType$default(stateType, false, 1, null) ? (IrExpression)UtilsKt.toIrConst(((Primitive)((Variable)CollectionsKt.single($this$toIrExpression.getFields())).getState()).getValue(), type2, start, end) : expression2;
        } else {
            irExpression = expression2;
        }
        return irExpression;
    }

    @NotNull
    public static final State toState(@Nullable Object $this$toState, @NotNull IrType irType) {
        State state;
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        Object object = $this$toState;
        if (object instanceof State) {
            state = (State)$this$toState;
        } else if (((((((((((((((((object instanceof Boolean ? true : object instanceof Character) ? true : object instanceof Byte) ? true : object instanceof Short) ? true : object instanceof Integer) ? true : object instanceof Long) ? true : object instanceof String) ? true : object instanceof Float) ? true : object instanceof Double) ? true : object instanceof Object[]) ? true : object instanceof byte[]) ? true : object instanceof char[]) ? true : object instanceof short[]) ? true : object instanceof int[]) ? true : object instanceof long[]) ? true : object instanceof float[]) ? true : object instanceof double[]) ? true : object instanceof boolean[]) {
            state = new Primitive<Object>($this$toState, irType);
        } else if (object == null) {
            state = new Primitive<Object>($this$toState, irType);
        } else {
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(irType);
            Intrinsics.checkNotNull((Object)irClassSymbol);
            state = new Wrapper($this$toState, (IrClass)irClassSymbol.getOwner());
        }
        return state;
    }

    @NotNull
    public static final IrConst<?> toIrConst(@Nullable Object $this$toIrConst, @NotNull IrType irType, int startOffset, int endOffset) {
        IrConst irConst;
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        if ($this$toIrConst == null) {
            return IrConstImpl.Companion.constNull(startOffset, endOffset, irType);
        }
        IrType constType = IrTypesKt.makeNotNull(irType);
        PrimitiveType primitiveType = IrTypePredicatesKt.getPrimitiveType(irType);
        int n = primitiveType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[primitiveType.ordinal()];
        switch (n) {
            case 1: {
                irConst = IrConstImpl.Companion.boolean(startOffset, endOffset, constType, (Boolean)$this$toIrConst);
                break;
            }
            case 2: {
                irConst = IrConstImpl.Companion.char(startOffset, endOffset, constType, ((Character)$this$toIrConst).charValue());
                break;
            }
            case 3: {
                irConst = IrConstImpl.Companion.byte(startOffset, endOffset, constType, ((Number)$this$toIrConst).byteValue());
                break;
            }
            case 4: {
                irConst = IrConstImpl.Companion.short(startOffset, endOffset, constType, ((Number)$this$toIrConst).shortValue());
                break;
            }
            case 5: {
                irConst = IrConstImpl.Companion.int(startOffset, endOffset, constType, ((Number)$this$toIrConst).intValue());
                break;
            }
            case 6: {
                irConst = IrConstImpl.Companion.float(startOffset, endOffset, constType, ((Number)$this$toIrConst).floatValue());
                break;
            }
            case 7: {
                irConst = IrConstImpl.Companion.long(startOffset, endOffset, constType, ((Number)$this$toIrConst).longValue());
                break;
            }
            case 8: {
                irConst = IrConstImpl.Companion.double(startOffset, endOffset, constType, ((Number)$this$toIrConst).doubleValue());
                break;
            }
            case -1: {
                IrConstImpl<Object> irConstImpl;
                UnsignedType unsignedType = IrTypePredicatesKt.getUnsignedType(constType);
                int n2 = unsignedType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[unsignedType.ordinal()];
                switch (n2) {
                    case 1: {
                        irConstImpl = IrConstImpl.Companion.byte(startOffset, endOffset, constType, ((Number)$this$toIrConst).byteValue());
                        break;
                    }
                    case 2: {
                        irConstImpl = IrConstImpl.Companion.short(startOffset, endOffset, constType, ((Number)$this$toIrConst).shortValue());
                        break;
                    }
                    case 3: {
                        irConstImpl = IrConstImpl.Companion.int(startOffset, endOffset, constType, ((Number)$this$toIrConst).intValue());
                        break;
                    }
                    case 4: {
                        irConstImpl = IrConstImpl.Companion.long(startOffset, endOffset, constType, ((Number)$this$toIrConst).longValue());
                        break;
                    }
                    case -1: {
                        if (IrTypePredicatesKt.isString(constType)) {
                            irConstImpl = IrConstImpl.Companion.string(startOffset, endOffset, constType, (String)$this$toIrConst);
                            break;
                        }
                        throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"Unsupported const element type ", (Object)RenderIrElementKt.render(constType)));
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                irConst = irConstImpl;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return irConst;
    }

    public static /* synthetic */ IrConst toIrConst$default(Object object, IrType irType, int n, int n2, int n3, Object object2) {
        if ((n3 & 2) != 0) {
            n = -1;
        }
        if ((n3 & 4) != 0) {
            n2 = -1;
        }
        return UtilsKt.toIrConst(object, irType, n, n2);
    }

    @NotNull
    public static final <T> Primitive<T> toPrimitive(@NotNull IrConst<T> $this$toPrimitive) {
        Intrinsics.checkNotNullParameter($this$toPrimitive, (String)"<this>");
        return new Primitive<T>($this$toPrimitive.getValue(), $this$toPrimitive.getType());
    }

    public static final boolean hasAnnotation(@Nullable IrAnnotationContainer $this$hasAnnotation, @NotNull FqName annotation2) {
        Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
        Object object = $this$hasAnnotation;
        if (object == null) {
            return false;
        }
        object = $this$hasAnnotation.getAnnotations();
        boolean bl = false;
        if (!object.isEmpty()) {
            boolean bl2;
            block5: {
                Iterable $this$any$iv = $this$hasAnnotation.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrConstructorCall it = (IrConstructorCall)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass((IrDeclaration)it.getSymbol().getOwner())), (Object)annotation2)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            return bl2;
        }
        return false;
    }

    @NotNull
    public static final IrConstructorCall getAnnotation(@NotNull IrAnnotationContainer $this$getAnnotation, @NotNull FqName annotation2) {
        IrConstructorCall irConstructorCall;
        Object v0;
        IrConstructorCall it;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$getAnnotation, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
            Iterable $this$firstOrNull$iv = $this$getAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                it = (IrConstructorCall)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass((IrDeclaration)it.getSymbol().getOwner())), (Object)annotation2)) continue;
                v0 = element$iv2;
                break block4;
            }
            v0 = null;
        }
        IrConstructorCall irConstructorCall2 = v0;
        if (irConstructorCall2 == null) {
            Object element$iv2;
            block5: {
                Iterable $this$first$iv = ((IrClass)((IrFunction)$this$getAnnotation).getParent()).getAnnotations();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    it = (IrConstructorCall)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass((IrDeclaration)it.getSymbol().getOwner())), (Object)annotation2)) continue;
                    break block5;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            irConstructorCall = (IrConstructorCall)element$iv2;
        } else {
            irConstructorCall = irConstructorCall2;
        }
        return irConstructorCall;
    }

    @Nullable
    public static final String getEvaluateIntrinsicValue(@NotNull IrAnnotationContainer $this$getEvaluateIntrinsicValue) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getEvaluateIntrinsicValue, (String)"<this>");
        if ($this$getEvaluateIntrinsicValue instanceof IrClass && Intrinsics.areEqual((object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)$this$getEvaluateIntrinsicValue)) == null ? null : Boolean.valueOf(((FqName)object).startsWith(Name.identifier("java"))), (Object)true)) {
            object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)$this$getEvaluateIntrinsicValue);
            return object == null ? null : ((FqName)object).asString();
        }
        if (!UtilsKt.hasAnnotation($this$getEvaluateIntrinsicValue, CompileTimeUtilsKt.getEvaluateIntrinsicAnnotation())) {
            return null;
        }
        object = UtilsKt.getAnnotation($this$getEvaluateIntrinsicValue, CompileTimeUtilsKt.getEvaluateIntrinsicAnnotation()).getValueArgument(0);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<*>");
        }
        return String.valueOf(((IrConst)object).getValue());
    }

    @Nullable
    public static final Class<?> getPrimitiveClass(@NotNull IrType irType, boolean asObject) {
        Class clazz;
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        PrimitiveType primitiveType = IrTypePredicatesKt.getPrimitiveType(irType);
        int n = primitiveType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[primitiveType.ordinal()];
        switch (n) {
            case 1: {
                if (asObject) {
                    clazz = Boolean.class;
                    break;
                }
                clazz = Boolean.TYPE;
                break;
            }
            case 2: {
                if (asObject) {
                    clazz = Character.class;
                    break;
                }
                clazz = Character.TYPE;
                break;
            }
            case 3: {
                if (asObject) {
                    clazz = Byte.class;
                    break;
                }
                clazz = Byte.TYPE;
                break;
            }
            case 4: {
                if (asObject) {
                    clazz = Short.class;
                    break;
                }
                clazz = Short.TYPE;
                break;
            }
            case 5: {
                if (asObject) {
                    clazz = Integer.class;
                    break;
                }
                clazz = Integer.TYPE;
                break;
            }
            case 6: {
                if (asObject) {
                    clazz = Float.class;
                    break;
                }
                clazz = Float.TYPE;
                break;
            }
            case 7: {
                if (asObject) {
                    clazz = Long.class;
                    break;
                }
                clazz = Long.TYPE;
                break;
            }
            case 8: {
                if (asObject) {
                    clazz = Double.class;
                    break;
                }
                clazz = Double.TYPE;
                break;
            }
            default: {
                clazz = IrTypePredicatesKt.isString(irType) ? String.class : null;
            }
        }
        return clazz;
    }

    public static /* synthetic */ Class getPrimitiveClass$default(IrType irType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UtilsKt.getPrimitiveClass(irType, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Object> getArgsForMethodInvocation(@NotNull IrFunction $this$getArgsForMethodInvocation, @NotNull List<Variable> args) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getArgsForMethodInvocation, (String)"<this>");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Object $this$map$iv = args;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            void it;
            Variable variable2 = (Variable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            State state = it.getState();
            if (state instanceof ExceptionState) {
                object = ((ExceptionState)state).getThisAsCauseForException();
            } else if (state instanceof Wrapper) {
                object = ((Wrapper)state).getValue();
            } else if (state instanceof Primitive) {
                object = ((Primitive)state).getValue();
            } else {
                throw new AssertionError((Object)(Reflection.getOrCreateKotlinClass(state.getClass()) + " is unsupported as argument for wrapper method invocation"));
            }
            ExceptionState.ExceptionData exceptionData = object;
            collection.add(exceptionData);
        }
        List argsValues = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        $this$map$iv = (IrValueParameter)CollectionsKt.lastOrNull($this$getArgsForMethodInvocation.getValueParameters());
        if (($this$map$iv == null ? null : ((IrValueParameter)$this$map$iv).getVarargElementType()) != null) {
            Object varargValue = CollectionsKt.last((List)argsValues);
            argsValues.remove(argsValues.size() - 1);
            if (varargValue == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<out kotlin.Any?>");
            }
            CollectionsKt.addAll((Collection)argsValues, (Object[])((Object[])varargValue));
        }
        return argsValues;
    }

    @NotNull
    public static final IrFunction getLastOverridden(@NotNull IrFunction $this$getLastOverridden) {
        Intrinsics.checkNotNullParameter((Object)$this$getLastOverridden, (String)"<this>");
        if (!($this$getLastOverridden instanceof IrSimpleFunction)) {
            return $this$getLastOverridden;
        }
        return (IrFunction)SequencesKt.last((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.generateSequence((Object)CollectionsKt.listOf((Object)$this$getLastOverridden), (Function1)getLastOverridden.1.INSTANCE)));
    }

    @NotNull
    public static final Primitive<?> toPrimitiveStateArray(@NotNull List<? extends Object> $this$toPrimitiveStateArray, @NotNull IrType type2) {
        Primitive<boolean[]> primitive;
        Intrinsics.checkNotNullParameter($this$toPrimitiveStateArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (IrTypePredicatesKt.isByteArray(type2)) {
            int n = 0;
            int n2 = $this$toPrimitiveStateArray.size();
            byte[] byArray = new byte[n2];
            while (n < n2) {
                int n3;
                Object object;
                if ((object = $this$toPrimitiveStateArray.get(n3 = n++)) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                byArray[n3] = ((Number)object).byteValue();
            }
            IrType irType = type2;
            byte[] byArray2 = byArray;
            primitive = new Primitive<boolean[]>((boolean[])byArray2, irType);
        } else if (IrTypePredicatesKt.isCharArray(type2)) {
            int n = 0;
            int n4 = $this$toPrimitiveStateArray.size();
            char[] cArray = new char[n4];
            while (n < n4) {
                int n5;
                Object object;
                if ((object = $this$toPrimitiveStateArray.get(n5 = n++)) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                }
                cArray[n5] = ((Character)object).charValue();
            }
            IrType irType = type2;
            char[] cArray2 = cArray;
            primitive = new Primitive<boolean[]>((boolean[])cArray2, irType);
        } else if (IrTypePredicatesKt.isShortArray(type2)) {
            int n = 0;
            int n6 = $this$toPrimitiveStateArray.size();
            short[] sArray = new short[n6];
            while (n < n6) {
                int n7;
                Object object;
                if ((object = $this$toPrimitiveStateArray.get(n7 = n++)) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                sArray[n7] = ((Number)object).shortValue();
            }
            IrType irType = type2;
            short[] sArray2 = sArray;
            primitive = new Primitive<boolean[]>((boolean[])sArray2, irType);
        } else if (IrTypePredicatesKt.isIntArray(type2)) {
            int n = 0;
            int n8 = $this$toPrimitiveStateArray.size();
            int[] nArray = new int[n8];
            while (n < n8) {
                int n9;
                Object object;
                if ((object = $this$toPrimitiveStateArray.get(n9 = n++)) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                nArray[n9] = ((Number)object).intValue();
            }
            IrType irType = type2;
            int[] nArray2 = nArray;
            primitive = new Primitive<boolean[]>((boolean[])nArray2, irType);
        } else if (IrTypePredicatesKt.isLongArray(type2)) {
            int n = 0;
            int n10 = $this$toPrimitiveStateArray.size();
            long[] lArray = new long[n10];
            while (n < n10) {
                int n11;
                Object object;
                if ((object = $this$toPrimitiveStateArray.get(n11 = n++)) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                lArray[n11] = ((Number)object).longValue();
            }
            IrType irType = type2;
            long[] lArray2 = lArray;
            primitive = new Primitive<boolean[]>((boolean[])lArray2, irType);
        } else if (IrTypePredicatesKt.isFloatArray(type2)) {
            int n = 0;
            int n12 = $this$toPrimitiveStateArray.size();
            float[] fArray = new float[n12];
            while (n < n12) {
                int n13;
                Object object;
                if ((object = $this$toPrimitiveStateArray.get(n13 = n++)) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                fArray[n13] = ((Number)object).floatValue();
            }
            IrType irType = type2;
            float[] fArray2 = fArray;
            primitive = new Primitive<boolean[]>((boolean[])fArray2, irType);
        } else if (IrTypePredicatesKt.isDoubleArray(type2)) {
            int n = 0;
            int n14 = $this$toPrimitiveStateArray.size();
            double[] dArray = new double[n14];
            while (n < n14) {
                int n15;
                Object object;
                if ((object = $this$toPrimitiveStateArray.get(n15 = n++)) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                dArray[n15] = ((Number)object).doubleValue();
            }
            IrType irType = type2;
            double[] dArray2 = dArray;
            primitive = new Primitive<boolean[]>((boolean[])dArray2, irType);
        } else if (IrTypePredicatesKt.isBooleanArray(type2)) {
            int n = 0;
            int n16 = $this$toPrimitiveStateArray.size();
            boolean[] blArray = new boolean[n16];
            while (n < n16) {
                int n17 = n++;
                String string2 = String.valueOf($this$toPrimitiveStateArray.get(n17));
                boolean bl = false;
                blArray[n17] = Boolean.parseBoolean(string2);
            }
            IrType irType = type2;
            boolean[] blArray2 = blArray;
            primitive = new Primitive<boolean[]>(blArray2, irType);
        } else {
            Collection $this$toTypedArray$iv = $this$toPrimitiveStateArray;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            primitive = new Primitive<Object[]>(objectArray, type2);
        }
        return primitive;
    }

    @Nullable
    public static final IrType getVarargType(@NotNull IrFunctionAccessExpression $this$getVarargType, int index2) {
        Intrinsics.checkNotNullParameter((Object)$this$getVarargType, (String)"<this>");
        Object object = ((IrFunctionSymbol)$this$getVarargType.getSymbol()).getOwner().getValueParameters().get(index2).getVarargElementType();
        if (object == null) {
            return null;
        }
        Object varargType = object;
        if ((object = IrTypesKt.getClassOrNull((IrType)varargType)) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            return ((IrFunctionSymbol)$this$getVarargType.getSymbol()).getOwner().getValueParameters().get(index2).getType();
        }
        IrTypeParameter typeParameter = (IrTypeParameter)IrTypesKt.getClassifierOrFail((IrType)varargType).getOwner();
        return $this$getVarargType.getTypeArgument(typeParameter.getIndex());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Variable> getTypeArguments(@NotNull IrTypeParametersContainer container2, @NotNull IrFunctionAccessExpression expression2, @NotNull Function1<? super IrTypeParameterSymbol, ? extends State> mapper) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        Iterable $this$mapIndexed$iv = container2.getTypeParameters();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void typeParameter;
            void index2;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrTypeParameter irTypeParameter2 = (IrTypeParameter)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            IrType irType = expression2.getTypeArgument((int)index2);
            Intrinsics.checkNotNull((Object)irType);
            IrType typeArgument = irType;
            Variable variable2 = new Variable(typeParameter.getSymbol(), UtilsKt.getTypeArguments$getState(typeArgument, mapper));
            collection.add(variable2);
        }
        List typeArguments2 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (container2 instanceof IrSimpleFunction) {
            IrTypeParameter irTypeParameter3;
            IrSymbolOwner $this$safeAs$iv = IrTypesKt.getClassifierOrFail(((IrSimpleFunction)container2).getReturnType()).getOwner();
            boolean $i$f$safeAs = false;
            IrSymbolOwner irSymbolOwner = $this$safeAs$iv;
            if (!(irSymbolOwner instanceof IrTypeParameter)) {
                irSymbolOwner = null;
            }
            if ((irTypeParameter3 = (IrTypeParameter)irSymbolOwner) != null) {
                IrTypeParameter irTypeParameter4 = irTypeParameter3;
                boolean bl = false;
                boolean bl3 = false;
                IrTypeParameter it = irTypeParameter4;
                boolean bl4 = false;
                typeArguments2.add(new Variable(it.getSymbol(), UtilsKt.getTypeArguments$getState(expression2.getType(), mapper)));
            }
        }
        return typeArguments2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Variable> extractNonLocalDeclarations(@Nullable State $this$extractNonLocalDeclarations) {
        void $this$filterTo$iv$iv;
        State state;
        State state2;
        State state3 = $this$extractNonLocalDeclarations;
        if (state3 == null) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        State state4 = $this$extractNonLocalDeclarations;
        boolean bl = false;
        boolean bl2 = false;
        State it = state4;
        boolean bl3 = false;
        State state5 = state2 = !(it instanceof Complex) ? state4 : null;
        if (state2 == null) {
            if ($this$extractNonLocalDeclarations == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Complex");
            }
            state = ((Complex)$this$extractNonLocalDeclarations).getOriginal();
        } else {
            state = state2;
        }
        State state6 = state;
        Iterable $this$filter$iv = state6.getFields();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Variable it2 = (Variable)element$iv$iv;
            boolean bl4 = false;
            if (!(!(it2.getSymbol() instanceof IrFieldSymbol))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final State getCorrectReceiverByFunction(@Nullable State $this$getCorrectReceiverByFunction, @NotNull IrFunction irFunction2) {
        Object v1;
        Object object;
        block3: {
            Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
            if (!($this$getCorrectReceiverByFunction instanceof Complex)) {
                return $this$getCorrectReceiverByFunction;
            }
            Complex original = ((Complex)$this$getCorrectReceiverByFunction).getOriginal();
            IrClass irClass2 = IrUtilsKt.getParentClassOrNull(irFunction2);
            Object object2 = object = irClass2 == null ? null : irClass2.getThisReceiver();
            if (object == null) {
                return $this$getCorrectReceiverByFunction;
            }
            IrValueParameter other = object;
            Sequence $this$firstOrNull$iv = SequencesKt.generateSequence((Object)original, (Function1)getCorrectReceiverByFunction.1.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Complex it = (Complex)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getIrClass().getThisReceiver(), (Object)other)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        object = v1;
        return object == null ? $this$getCorrectReceiverByFunction : (State)object;
    }

    @NotNull
    public static final String getCapitalizedFileName(@NotNull IrFunction $this$getCapitalizedFileName) {
        Intrinsics.checkNotNullParameter((Object)$this$getCapitalizedFileName, (String)"<this>");
        return CapitalizeDecapitalizeKt.capitalizeAsciiOnly(StringsKt.replace$default((String)IrFileKt.getName(IrUtilsKt.getFile($this$getCapitalizedFileName)), (String)".kt", (String)"Kt", (boolean)false, (int)4, null));
    }

    public static final boolean isPrimitiveArray(@NotNull IrType $this$isPrimitiveArray) {
        boolean bl;
        FqName fqName2;
        FqNameUnsafe fqNameUnsafe;
        Intrinsics.checkNotNullParameter((Object)$this$isPrimitiveArray, (String)"<this>");
        IrClass irClass2 = IrTypesKt.getClass($this$isPrimitiveArray);
        FqNameUnsafe fqNameUnsafe2 = irClass2 == null ? null : (fqNameUnsafe = (fqName2 = IrUtilsKt.getFqNameWhenAvailable(irClass2)) == null ? null : fqName2.toUnsafe());
        if (fqNameUnsafe == null) {
            bl = false;
        } else {
            boolean bl2;
            fqName2 = fqNameUnsafe;
            boolean bl3 = false;
            boolean bl4 = false;
            FqName it = fqName2;
            boolean bl5 = false;
            bl = bl2 = StandardNames.isPrimitiveArray((FqNameUnsafe)((Object)it));
        }
        return bl;
    }

    public static final boolean isFunction(@NotNull IrType $this$isFunction) {
        boolean bl;
        FqName fqName2;
        Intrinsics.checkNotNullParameter((Object)$this$isFunction, (String)"<this>");
        IrClass irClass2 = IrTypesKt.getClass($this$isFunction);
        String string2 = irClass2 == null ? null : ((fqName2 = IrUtilsKt.getFqNameWhenAvailable(irClass2)) == null ? null : fqName2.asString());
        return string2 == null ? false : (bl = StringsKt.startsWith$default((String)string2, (String)"kotlin.Function", (boolean)false, (int)2, null));
    }

    public static final boolean isTypeParameter(@NotNull IrType $this$isTypeParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$isTypeParameter, (String)"<this>");
        return IrTypesKt.getClassifierOrNull($this$isTypeParameter) instanceof IrTypeParameterSymbol;
    }

    public static final boolean isInterface(@NotNull IrType $this$isInterface) {
        IrClass irClass2;
        Intrinsics.checkNotNullParameter((Object)$this$isInterface, (String)"<this>");
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$isInterface);
        return (irClassSymbol == null ? null : ((irClass2 = (IrClass)irClassSymbol.getOwner()) == null ? null : irClass2.getKind())) == ClassKind.INTERFACE;
    }

    public static final boolean isThrowable(@NotNull IrType $this$isThrowable) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter((Object)$this$isThrowable, (String)"<this>");
        IrClass irClass2 = IrTypesKt.getClass($this$isThrowable);
        return Intrinsics.areEqual(irClass2 == null ? null : ((fqName2 = IrUtilsKt.getFqNameWhenAvailable(irClass2)) == null ? null : fqName2.asString()), (Object)"kotlin.Throwable");
    }

    @NotNull
    public static final String internalName(@NotNull IrClass $this$internalName) {
        Intrinsics.checkNotNullParameter((Object)$this$internalName, (String)"<this>");
        StringBuilder internalName2 = new StringBuilder($this$internalName.getName().asString());
        Sequence $this$forEach$iv = SequencesKt.drop((Sequence)SequencesKt.generateSequence((Object)($this$internalName instanceof IrDeclarationParent ? (IrDeclarationParent)$this$internalName : null), (Function1)internalName.1.INSTANCE), (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string2;
            IrDeclarationParent it = (IrDeclarationParent)element$iv;
            boolean bl = false;
            IrDeclarationParent irDeclarationParent = it;
            if (irDeclarationParent instanceof IrClass) {
                internalName2.insert(0, Intrinsics.stringPlus((String)((IrClass)it).getName().asString(), (Object)"$"));
                continue;
            }
            if (!(irDeclarationParent instanceof IrPackageFragment)) continue;
            String string3 = ((IrPackageFragment)it).getFqName().asString();
            boolean bl2 = false;
            boolean bl3 = false;
            String it2 = string3;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
            CharSequence charSequence = it2;
            boolean bl5 = false;
            String string4 = string2 = charSequence.length() > 0 ? string3 : null;
            if (string2 == null) continue;
            string3 = string2;
            bl2 = false;
            bl3 = false;
            it2 = string3;
            boolean bl6 = false;
            internalName2.insert(0, Intrinsics.stringPlus((String)it2, (Object)"."));
        }
        String string5 = internalName2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"internalName.toString()");
        return string5;
    }

    private static final State getTypeArguments$getState(IrType $this$getTypeArguments_u24getState, Function1<? super IrTypeParameterSymbol, ? extends State> $mapper) {
        Common common;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$getTypeArguments_u24getState);
        if (irClassSymbol == null) {
            common = null;
        } else {
            IrClass irClass2 = (IrClass)irClassSymbol.getOwner();
            if (irClass2 == null) {
                common = null;
            } else {
                IrClass irClass3 = irClass2;
                boolean bl = false;
                boolean bl2 = false;
                IrClass it = irClass3;
                boolean bl3 = false;
                common = new Common(it);
            }
        }
        Common common2 = common;
        return common2 == null ? (State)$mapper.invoke((Object)((IrTypeParameterSymbol)IrTypesKt.getClassifierOrFail($this$getTypeArguments_u24getState))) : (State)common2;
    }

    @Metadata(mv={1, 5, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PrimitiveType.values().length];
            nArray[PrimitiveType.BOOLEAN.ordinal()] = 1;
            nArray[PrimitiveType.CHAR.ordinal()] = 2;
            nArray[PrimitiveType.BYTE.ordinal()] = 3;
            nArray[PrimitiveType.SHORT.ordinal()] = 4;
            nArray[PrimitiveType.INT.ordinal()] = 5;
            nArray[PrimitiveType.FLOAT.ordinal()] = 6;
            nArray[PrimitiveType.LONG.ordinal()] = 7;
            nArray[PrimitiveType.DOUBLE.ordinal()] = 8;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[UnsignedType.values().length];
            nArray[UnsignedType.UBYTE.ordinal()] = 1;
            nArray[UnsignedType.USHORT.ordinal()] = 2;
            nArray[UnsignedType.UINT.ordinal()] = 3;
            nArray[UnsignedType.ULONG.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

