/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.range;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.range.RangeCodegenUtilKt;
import org.jetbrains.kotlin.codegen.range.ReversableRangeValue;
import org.jetbrains.kotlin.codegen.range.comparison.ComparisonGeneratorKt;
import org.jetbrains.kotlin.codegen.range.forLoop.ForInRangeInstanceLoopGenerator;
import org.jetbrains.kotlin.codegen.range.forLoop.ForLoopGenerator;
import org.jetbrains.kotlin.codegen.range.inExpression.CallBasedInExpressionGenerator;
import org.jetbrains.kotlin.codegen.range.inExpression.InExpressionGenerator;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/codegen/range/PrimitiveRangeRangeValue;", "Lorg/jetbrains/kotlin/codegen/range/ReversableRangeValue;", "rangeExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/psi/KtExpression;)V", "createForInReversedLoopGenerator", "Lorg/jetbrains/kotlin/codegen/range/forLoop/ForLoopGenerator;", "codegen", "Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;", "forExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "createForLoopGenerator", "Lorg/jetbrains/kotlin/codegen/range/forLoop/ForInRangeInstanceLoopGenerator;", "createInExpressionGenerator", "Lorg/jetbrains/kotlin/codegen/range/inExpression/InExpressionGenerator;", "operatorReference", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "getRangeElementType", "Lorg/jetbrains/kotlin/types/KotlinType;", "backend"})
public final class PrimitiveRangeRangeValue
implements ReversableRangeValue {
    @NotNull
    private final KtExpression rangeExpression;

    public PrimitiveRangeRangeValue(@NotNull KtExpression rangeExpression) {
        Intrinsics.checkNotNullParameter((Object)rangeExpression, (String)"rangeExpression");
        this.rangeExpression = rangeExpression;
    }

    @Override
    @NotNull
    public ForInRangeInstanceLoopGenerator createForLoopGenerator(@NotNull ExpressionCodegen codegen2, @NotNull KtForExpression forExpression) {
        Intrinsics.checkNotNullParameter((Object)codegen2, (String)"codegen");
        Intrinsics.checkNotNullParameter((Object)forExpression, (String)"forExpression");
        return new ForInRangeInstanceLoopGenerator(codegen2, forExpression, this.rangeExpression, ComparisonGeneratorKt.getComparisonGeneratorForKotlinType(this.getRangeElementType(codegen2, forExpression)), false);
    }

    @Override
    @NotNull
    public InExpressionGenerator createInExpressionGenerator(@NotNull ExpressionCodegen codegen2, @NotNull KtSimpleNameExpression operatorReference) {
        Intrinsics.checkNotNullParameter((Object)codegen2, (String)"codegen");
        Intrinsics.checkNotNullParameter((Object)operatorReference, (String)"operatorReference");
        return new CallBasedInExpressionGenerator(codegen2, operatorReference);
    }

    @Override
    @NotNull
    public ForLoopGenerator createForInReversedLoopGenerator(@NotNull ExpressionCodegen codegen2, @NotNull KtForExpression forExpression) {
        Intrinsics.checkNotNullParameter((Object)codegen2, (String)"codegen");
        Intrinsics.checkNotNullParameter((Object)forExpression, (String)"forExpression");
        return new ForInRangeInstanceLoopGenerator(codegen2, forExpression, this.rangeExpression, ComparisonGeneratorKt.getComparisonGeneratorForKotlinType(this.getRangeElementType(codegen2, forExpression)), true);
    }

    private final KotlinType getRangeElementType(ExpressionCodegen codegen2, KtForExpression forExpression) {
        KtExpression ktExpression;
        Object object = forExpression.getLoopRange();
        if (object == null) {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"No loop range expression: ", (Object)forExpression.getText()));
        }
        KtExpression ktLoopRange = ktExpression = object;
        KotlinType kotlinType = codegen2.getBindingContext().getType(ktLoopRange);
        if (kotlinType == null) {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"No type for loop range expression: ", (Object)ktLoopRange.getText()));
        }
        object = kotlinType;
        Object rangeType = object;
        object = RangeCodegenUtilKt.getRangeOrProgressionElementType((KotlinType)rangeType);
        if (object == null) {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unexpected range type: ", (Object)rangeType));
        }
        return object;
    }
}

