/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin;

import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/ElementTypeUtils;", "", "()V", "getKotlinBlockImbalanceCount", "", "seq", "", "psi"})
public final class ElementTypeUtils {
    @NotNull
    public static final ElementTypeUtils INSTANCE = new ElementTypeUtils();

    private ElementTypeUtils() {
    }

    @JvmStatic
    public static final int getKotlinBlockImbalanceCount(@NotNull CharSequence seq) {
        IElementType iElementType;
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        KotlinLexer lexer = new KotlinLexer();
        lexer.start(seq);
        if (lexer.getTokenType() != KtTokens.LBRACE) {
            return Integer.MIN_VALUE;
        }
        lexer.advance();
        int balance = 1;
        while (!Intrinsics.areEqual((Object)lexer.getTokenType(), (Object)KtTokens.EOF) && (iElementType = lexer.getTokenType()) != null) {
            IElementType iElementType2;
            IElementType type2 = iElementType2 = iElementType;
            if (balance == 0) {
                return Integer.MIN_VALUE;
            }
            if (type2 == KtTokens.LBRACE) {
                int n = balance;
                balance = n + 1;
            } else if (type2 == KtTokens.RBRACE) {
                int n = balance;
                balance = n + -1;
            }
            lexer.advance();
        }
        return balance;
    }
}

