/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.diagnostics;

import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticsElementsCache;
import org.jetbrains.kotlin.resolve.diagnostics.SimpleDiagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.SimpleGenericDiagnostics;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\r\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00020\u00020\u0007H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0000H\u0016R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/SimpleDiagnostics;", "Lorg/jetbrains/kotlin/resolve/diagnostics/SimpleGenericDiagnostics;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "diagnostics", "", "(Ljava/util/Collection;)V", "Ljava/util/ArrayList;", "kotlin.jvm.PlatformType", "elementsCache", "Lorg/jetbrains/kotlin/resolve/diagnostics/DiagnosticsElementsCache;", "getElementsCache$annotations", "()V", "all", "forElement", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "noSuppression", "frontend"})
public final class SimpleDiagnostics
extends SimpleGenericDiagnostics<Diagnostic>
implements Diagnostics {
    @NotNull
    private final ArrayList<Diagnostic> diagnostics;
    @NotNull
    private final DiagnosticsElementsCache elementsCache;

    public SimpleDiagnostics(@NotNull Collection<? extends Diagnostic> diagnostics2) {
        Intrinsics.checkNotNullParameter(diagnostics2, (String)"diagnostics");
        super(diagnostics2);
        this.diagnostics = new ArrayList<Diagnostic>(diagnostics2);
        this.elementsCache = new DiagnosticsElementsCache(this, (Function1<Diagnostic, Boolean>)((Function1)elementsCache.1.INSTANCE));
    }

    @Override
    @NotNull
    public ArrayList<Diagnostic> all() {
        return this.diagnostics;
    }

    @Override
    @NotNull
    public Collection<Diagnostic> forElement(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Collection<Diagnostic> collection = this.elementsCache.getDiagnostics(psiElement);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"elementsCache.getDiagnostics(psiElement)");
        return collection;
    }

    @Override
    @NotNull
    public SimpleDiagnostics noSuppression() {
        return this;
    }

    @Override
    @NotNull
    public ModificationTracker getModificationTracker() {
        return Diagnostics.DefaultImpls.getModificationTracker(this);
    }

    @Override
    public boolean isEmpty() {
        return Diagnostics.DefaultImpls.isEmpty(this);
    }

    @Override
    @NotNull
    public Iterator<Diagnostic> iterator() {
        return Diagnostics.DefaultImpls.iterator(this);
    }
}

