/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.ParameterTypeConversion;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemOperation;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionCandidateKt;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J*\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u0010\u001a\u00020\u0004*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\f\u0010\u0014\u001a\u00020\u0004*\u00020\u0011H\u0002J\u0014\u0010\u0015\u001a\u00020\u0004*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/UnitTypeConversions;", "Lorg/jetbrains/kotlin/resolve/calls/components/ParameterTypeConversion;", "()V", "conversionDefinitelyNotNeeded", "", "candidate", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinResolutionCandidate;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "expectedParameterType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "conversionIsNeededAfterSubtypingCheck", "conversionIsNeededBeforeSubtypingCheck", "convertParameterType", "parameter", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "hasUnitOrSubtypeReturnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "c", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemOperation;", "isUnitOrSubtype", "isUnitOrSubtypeOrVariable", "resolution"})
public final class UnitTypeConversions
implements ParameterTypeConversion {
    @NotNull
    public static final UnitTypeConversions INSTANCE = new UnitTypeConversions();

    private UnitTypeConversions() {
    }

    @Override
    public boolean conversionDefinitelyNotNeeded(@NotNull KotlinResolutionCandidate candidate2, @NotNull KotlinCallArgument argument, @NotNull UnwrappedType expectedParameterType) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            Intrinsics.checkNotNullParameter((Object)expectedParameterType, (String)"expectedParameterType");
            if (!(argument instanceof SimpleKotlinCallArgument)) {
                return true;
            }
            ReceiverValueWithSmartCastInfo receiver = ((SimpleKotlinCallArgument)argument).getReceiver();
            KotlinType kotlinType = receiver.getReceiverValue().getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"receiver.receiverValue.type");
            if (this.hasUnitOrSubtypeReturnType(kotlinType, candidate2.getCsBuilder$resolution())) {
                return true;
            }
            Iterable $this$any$iv = receiver.getTypesFromSmartCasts();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    if (!this.hasUnitOrSubtypeReturnType(it, candidate2.getCsBuilder$resolution())) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        return !FunctionTypesKt.isBuiltinFunctionalType(expectedParameterType) || !TypeUtilsKt.isUnit(FunctionTypesKt.getReturnTypeFromFunctionType(expectedParameterType));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasUnitOrSubtypeReturnType(KotlinType $this$hasUnitOrSubtypeReturnType, ConstraintSystemOperation c) {
        if (!FunctionTypesKt.isFunctionOrKFunctionTypeWithAnySuspendability($this$hasUnitOrSubtypeReturnType)) return false;
        KotlinType kotlinType = ((TypeProjection)CollectionsKt.last($this$hasUnitOrSubtypeReturnType.getArguments())).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"arguments.last().type");
        if (!this.isUnitOrSubtypeOrVariable(kotlinType, c)) return false;
        return true;
    }

    private final boolean isUnitOrSubtypeOrVariable(KotlinType $this$isUnitOrSubtypeOrVariable, ConstraintSystemOperation c) {
        return this.isUnitOrSubtype($this$isUnitOrSubtypeOrVariable) || c.isTypeVariable($this$isUnitOrSubtypeOrVariable);
    }

    private final boolean isUnitOrSubtype(KotlinType $this$isUnitOrSubtype) {
        return TypeUtilsKt.isUnit($this$isUnitOrSubtype) || DynamicTypesKt.isDynamic($this$isUnitOrSubtype) || TypeUtilsKt.isNothing($this$isUnitOrSubtype);
    }

    @Override
    public boolean conversionIsNeededBeforeSubtypingCheck(@NotNull KotlinCallArgument argument) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return argument instanceof SimpleKotlinCallArgument && FunctionTypesKt.isFunctionType(ArgumentsUtilsKt.getStableType(((SimpleKotlinCallArgument)argument).getReceiver()));
    }

    @Override
    public boolean conversionIsNeededAfterSubtypingCheck(@NotNull KotlinCallArgument argument) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        if (!(argument instanceof SimpleKotlinCallArgument)) {
            return false;
        }
        Ref.BooleanRef isFunctionTypeOrSubtype2 = new Ref.BooleanRef();
        boolean hasReturnTypeInSubtypes2 = FunctionTypesKt.isFunctionTypeOrSubtype(ArgumentsUtilsKt.getStableType(((SimpleKotlinCallArgument)argument).getReceiver()), (Function1<? super KotlinType, Boolean>)((Function1)new Function1<KotlinType, Boolean>(isFunctionTypeOrSubtype2, this){
            final /* synthetic */ Ref.BooleanRef $isFunctionTypeOrSubtype;
            final /* synthetic */ UnitTypeConversions this$0;
            {
                this.$isFunctionTypeOrSubtype = $isFunctionTypeOrSubtype;
                this.this$0 = $receiver;
                super(1);
            }

            public final boolean invoke(@NotNull KotlinType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$isFunctionTypeOrSubtype.element = true;
                return UnitTypeConversions.access$isUnitOrSubtype(this.this$0, FunctionTypesKt.getReturnTypeFromFunctionType(it));
            }
        }));
        if (!isFunctionTypeOrSubtype2.element) {
            return false;
        }
        return !hasReturnTypeInSubtypes2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public UnwrappedType convertParameterType(@NotNull KotlinResolutionCandidate candidate2, @NotNull KotlinCallArgument argument, @NotNull ParameterDescriptor parameter, @NotNull UnwrappedType expectedParameterType) {
        Collection<KotlinType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)expectedParameterType, (String)"expectedParameterType");
        Object object = FunctionTypesKt.getValueParameterTypesFromFunctionType(expectedParameterType);
        KotlinType kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType(expectedParameterType);
        Annotations annotations2 = expectedParameterType.getAnnotations();
        KotlinBuiltIns kotlinBuiltIns = candidate2.getCallComponents().getBuiltIns();
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            KotlinType kotlinType2 = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"it.type");
            KotlinType kotlinType3 = kotlinType2;
            collection.add(kotlinType3);
        }
        collection = (List)destination$iv$iv;
        object = candidate2.getCallComponents().getBuiltIns().getNullableAnyType();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"candidate.callComponents.builtIns.nullableAnyType");
        SimpleType nonUnitReturnedParameterType = FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType, collection, null, (KotlinType)object, FunctionTypesKt.isSuspendFunctionType(expectedParameterType));
        candidate2.getResolvedCall().registerArgumentWithUnitConversion(argument, nonUnitReturnedParameterType);
        ResolutionCandidateKt.markCandidateForCompatibilityResolve(candidate2);
        return nonUnitReturnedParameterType;
    }

    public static final /* synthetic */ boolean access$isUnitOrSubtype(UnitTypeConversions $this, KotlinType $receiver) {
        return $this.isUnitOrSubtype($receiver);
    }
}

