/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsQualifierChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "()V", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "validateQualifier", "", "qualifier", "", "js.frontend"})
public final class JsQualifierChecker
implements AdditionalAnnotationChecker {
    @NotNull
    public static final JsQualifierChecker INSTANCE = new JsQualifierChecker();

    private JsQualifierChecker() {
    }

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Intrinsics.checkNotNullParameter(actualTargets, (String)"actualTargets");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        BindingContext bindingContext2 = bindingContext;
        for (KtAnnotationEntry ktAnnotationEntry : entries) {
            Object argument;
            ConstantValue constantValue;
            KtValueArgumentList ktValueArgumentList;
            AnnotationDescriptor annotationDescriptor;
            AnnotationDescriptor annotation2;
            Object object = (AnnotationDescriptor)bindingContext2.get(BindingContext.ANNOTATION, ktAnnotationEntry);
            if (object == null || !Intrinsics.areEqual((Object)(annotation2 = (annotationDescriptor = object)).getFqName(), (Object)AnnotationsUtils.JS_QUALIFIER_ANNOTATION) || (object = (ktValueArgumentList = (constantValue = (ConstantValue)CollectionsKt.singleOrNull((Iterable)annotation2.getAllValueArguments().values())) == null ? null : (KtValueArgumentList)constantValue.getValue()) instanceof String ? (String)((Object)ktValueArgumentList) : null) == null || this.validateQualifier((String)(argument = object))) continue;
            ktValueArgumentList = ktAnnotationEntry.getValueArgumentList();
            Intrinsics.checkNotNull((Object)ktValueArgumentList);
            KtValueArgument argumentPsi = ktValueArgumentList.getArguments().get(0);
            trace.report(ErrorsJs.WRONG_JS_QUALIFIER.on((KtValueArgument)((PsiElement)argumentPsi)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean validateQualifier(String qualifier) {
        boolean bl;
        char[] cArray = new char[]{'.'};
        List parts2 = StringsKt.split$default((CharSequence)qualifier, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (parts2.isEmpty()) {
            return false;
        }
        Iterable $this$all$iv = parts2;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            String part = (String)element$iv;
            boolean bl2 = false;
            CharSequence charSequence = part;
            boolean bl3 = false;
            if (charSequence.length() <= 0) return false;
            boolean bl4 = true;
            if (!bl4) return false;
            char c = part.charAt(0);
            bl3 = false;
            if (!Character.isJavaIdentifierStart(c)) return false;
            CharSequence $this$all$iv2 = StringsKt.drop((String)part, (int)1);
            boolean $i$f$all2 = false;
            CharSequence charSequence2 = $this$all$iv2;
            for (int i = 0; i < charSequence2.length(); ++i) {
                char element$iv2;
                char p0 = element$iv2 = charSequence2.charAt(i);
                boolean bl5 = false;
                char c2 = p0;
                boolean bl6 = false;
                if (Character.isJavaIdentifierPart(c2)) continue;
                return false;
            }
            boolean bl7 = true;
            if (!bl7) return false;
            bl = true;
        } while (bl);
        return false;
    }
}

