/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;

final class Constants {
    static void checkAsmExperimental(Object caller) {
        Class<?> callerClass = caller.getClass();
        String internalName2 = callerClass.getName().replace('.', '/');
        if (!Constants.isWhitelisted(internalName2)) {
            Constants.checkIsPreview(callerClass.getClassLoader().getResourceAsStream(internalName2 + ".class"));
        }
    }

    static boolean isWhitelisted(String internalName2) {
        if (!internalName2.startsWith("org/jetbrains/org/objectweb/asm/")) {
            return false;
        }
        String member = "(Annotation|Class|Field|Method|Module|RecordComponent|Signature)";
        return internalName2.contains("Test$") || Pattern.matches("org/jetbrains/org/objectweb/asm/util/Trace" + member + "Visitor(\\$.*)?", internalName2) || Pattern.matches("org/jetbrains/org/objectweb/asm/util/Check" + member + "Adapter(\\$.*)?", internalName2);
    }

    static void checkIsPreview(InputStream classInputStream) {
        int minorVersion;
        if (classInputStream == null) {
            throw new IllegalStateException("Bytecode not available, can't check class version");
        }
        try {
            DataInputStream callerClassStream = new DataInputStream(classInputStream);
            Throwable throwable = null;
            try {
                callerClassStream.readInt();
                minorVersion = callerClassStream.readUnsignedShort();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (callerClassStream != null) {
                    if (throwable != null) {
                        try {
                            callerClassStream.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        callerClassStream.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("I/O error, can't check class version", ioe);
        }
        if (minorVersion != 65535) {
            throw new IllegalStateException("ASM9_EXPERIMENTAL can only be used by classes compiled with --enable-preview");
        }
    }
}

