/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/FileClassAnnotationsChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "()V", "alwaysApplicable", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/name/FqName;", "Lkotlin/collections/HashSet;", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "frontend.java"})
public final class FileClassAnnotationsChecker
implements AdditionalAnnotationChecker {
    private static final HashSet<FqName> alwaysApplicable;
    @NotNull
    public static final FileClassAnnotationsChecker INSTANCE;

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries2, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace) {
        KtAnnotationEntry entry;
        boolean bl;
        KtAnnotationEntry classDescriptor3;
        ArrayList<Pair> fileAnnotationsToCheck;
        block19: {
            boolean bl2;
            Intrinsics.checkNotNullParameter(entries2, (String)"entries");
            Intrinsics.checkNotNullParameter(actualTargets, (String)"actualTargets");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            boolean bl22 = false;
            fileAnnotationsToCheck = new ArrayList<Pair>();
            for (KtAnnotationEntry ktAnnotationEntry : entries2) {
                AnnotationDescriptor descriptor2;
                KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = ktAnnotationEntry.getUseSiteTarget();
                if ((ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null) != AnnotationUseSiteTarget.FILE) continue;
                if ((AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, ktAnnotationEntry) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)descriptor2, (String)"trace.get(BindingContext\u2026ATION, entry) ?: continue");
                if (DescriptorUtilsKt.getAnnotationClass(descriptor2) == null) {
                    continue;
                }
                Set<KotlinTarget> applicableTargets = AnnotationChecker.Companion.applicableTargetSet((ClassDescriptor)((Object)classDescriptor3));
                if (applicableTargets == null || !applicableTargets.contains((Object)KotlinTarget.FILE)) continue;
                fileAnnotationsToCheck.add(new Pair((Object)ktAnnotationEntry, (Object)classDescriptor3));
            }
            Iterable $this$any$iv = fileAnnotationsToCheck;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)it.getSecond()), (Object)JvmFileClassUtil.INSTANCE.getJVM_MULTIFILE_CLASS())) continue;
                    bl2 = true;
                    break block19;
                }
                bl2 = bl = false;
            }
        }
        if (bl) {
            for (Pair pair : fileAnnotationsToCheck) {
                classDescriptor3 = (KtAnnotationEntry)pair.component1();
                ClassDescriptor classDescriptor2 = (ClassDescriptor)pair.component2();
                FqName classFqName = DescriptorUtilsKt.getFqNameSafe(classDescriptor2);
                if (alwaysApplicable.contains(classFqName) || DescriptorUtilsKt.getAnnotationRetention(classDescriptor2) == KotlinRetention.SOURCE) continue;
                trace.report(ErrorsJvm.ANNOTATION_IS_NOT_APPLICABLE_TO_MULTIFILE_CLASSES.on((KtAnnotationEntry)((PsiElement)entry), classFqName));
            }
        } else {
            for (Pair pair : fileAnnotationsToCheck) {
                boolean bl3;
                block20: {
                    String value2;
                    Object[] objectArray;
                    entry = (KtAnnotationEntry)pair.component1();
                    ClassDescriptor classDescriptor2 = (ClassDescriptor)pair.component2();
                    if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(classDescriptor2), (Object)JvmFileClassUtil.INSTANCE.getJVM_PACKAGE_NAME()) ^ true) continue;
                    List<? extends ValueArgument> list2 = entry.getValueArguments();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"entry.valueArguments");
                    Object object = (ValueArgument)CollectionsKt.firstOrNull(list2);
                    if (object == null || (object = object.getArgumentExpression()) == null) {
                        continue;
                    }
                    Object argumentExpression = object;
                    Object object2 = argumentExpression;
                    if (!(object2 instanceof KtStringTemplateExpression)) {
                        object2 = null;
                    }
                    if ((objectArray = (Object[])object2) == null || (objectArray = objectArray.getEntries()) == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"(argumentExpression as? \u2026ion)?.entries ?: continue");
                    Object[] stringTemplateEntries = objectArray;
                    if (stringTemplateEntries.length > 1) continue;
                    Object object3 = ArraysKt.singleOrNull((Object[])stringTemplateEntries);
                    if (!(object3 instanceof KtLiteralStringTemplateEntry)) {
                        object3 = null;
                    }
                    KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = (KtLiteralStringTemplateEntry)object3;
                    String string2 = value2 = ktLiteralStringTemplateEntry != null ? ktLiteralStringTemplateEntry.getText() : null;
                    if (value2 == null) {
                        trace.report(ErrorsJvm.JVM_PACKAGE_NAME_CANNOT_BE_EMPTY.on((KtAnnotationEntry)((PsiElement)entry)));
                        continue;
                    }
                    if (!FqNamesUtilKt.isValidJavaFqName(value2)) {
                        trace.report(ErrorsJvm.JVM_PACKAGE_NAME_MUST_BE_VALID_NAME.on((KtAnnotationEntry)((PsiElement)entry)));
                        continue;
                    }
                    KtFile ktFile = entry.getContainingKtFile();
                    Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"entry.containingKtFile");
                    Iterable $this$any$iv = ktFile.getDeclarations();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KtDeclaration it = (KtDeclaration)element$iv;
                            boolean bl4 = false;
                            if (!(!(it instanceof KtFunction) && !(it instanceof KtProperty) && !(it instanceof KtTypeAlias))) continue;
                            bl3 = true;
                            break block20;
                        }
                        bl3 = false;
                    }
                }
                if (!bl3) continue;
                trace.report(ErrorsJvm.JVM_PACKAGE_NAME_NOT_SUPPORTED_IN_FILES_WITH_CLASSES.on((KtAnnotationEntry)((PsiElement)entry)));
            }
        }
    }

    private FileClassAnnotationsChecker() {
    }

    static {
        FileClassAnnotationsChecker fileClassAnnotationsChecker;
        INSTANCE = fileClassAnnotationsChecker = new FileClassAnnotationsChecker();
        alwaysApplicable = SetsKt.hashSetOf((Object[])new FqName[]{JvmFileClassUtil.INSTANCE.getJVM_NAME(), JvmFileClassUtil.INSTANCE.getJVM_MULTIFILE_CLASS()});
    }
}

