/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\f*\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\f*\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/InlineClassDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isParameterAcceptableForInlineClass", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "isGenericArrayOfTypeParameter", "Lorg/jetbrains/kotlin/types/KotlinType;", "isInapplicableParameterType", "frontend"})
public final class InlineClassDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final InlineClassDeclarationChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Annotated annotated;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(declaration2 instanceof KtClass)) {
            return;
        }
        if (!(descriptor2 instanceof ClassDescriptor) || !((ClassDescriptor)descriptor2).isInline() && !((ClassDescriptor)descriptor2).isValue()) {
            return;
        }
        if (((ClassDescriptor)descriptor2).getKind() != ClassKind.CLASS) {
            return;
        }
        PsiElement psiElement = ((KtClass)declaration2).getModifierList();
        if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.INLINE_KEYWORD)) == null) {
            KtModifierList ktModifierList = ((KtClass)declaration2).getModifierList();
            psiElement = ktModifierList != null ? ktModifierList.getModifier(KtTokens.VALUE_KEYWORD) : null;
        }
        PsiElement inlineOrValueKeyword = psiElement;
        boolean bl = inlineOrValueKeyword != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Declaration of inline class must have 'inline' keyword";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        BindingTrace trace = context2.getTrace();
        if (!DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            trace.report(Errors.INLINE_CLASS_NOT_TOP_LEVEL.on(inlineOrValueKeyword));
            return;
        }
        PsiElement modalityModifier = KtPsiUtilKt.modalityModifier(declaration2);
        if (modalityModifier != null && ((ClassDescriptor)descriptor2).getModality() != Modality.FINAL) {
            trace.report(Errors.INLINE_CLASS_NOT_FINAL.on(modalityModifier));
            return;
        }
        KtPrimaryConstructor primaryConstructor2 = ((KtClass)declaration2).getPrimaryConstructor();
        if (primaryConstructor2 == null) {
            trace.report(Errors.ABSENCE_OF_PRIMARY_CONSTRUCTOR_FOR_INLINE_CLASS.on(inlineOrValueKeyword));
            return;
        }
        KtParameter baseParameter = (KtParameter)CollectionsKt.singleOrNull(primaryConstructor2.getValueParameters());
        if (baseParameter == null) {
            KtParameterList ktParameterList = primaryConstructor2.getValueParameterList();
            KtElementImplStub ktElementImplStub = ktParameterList != null ? (KtElementImplStub)ktParameterList : (KtElementImplStub)((Object)declaration2);
            boolean bl5 = false;
            boolean bl6 = false;
            KtElementImplStub it = ktElementImplStub;
            boolean bl7 = false;
            trace.report(Errors.INLINE_CLASS_CONSTRUCTOR_WRONG_PARAMETERS_SIZE.on((KtElement)((PsiElement)it)));
            return;
        }
        if (!this.isParameterAcceptableForInlineClass(baseParameter)) {
            trace.report(Errors.INLINE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER.on((KtParameter)((PsiElement)baseParameter)));
            return;
        }
        DeclarationDescriptor $this$safeAs$iv = descriptor2;
        boolean $i$f$safeAs = false;
        DeclarationDescriptor declarationDescriptor = $this$safeAs$iv;
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        KotlinType baseParameterType = (annotated = (ClassDescriptor)declarationDescriptor) != null && (annotated = annotated.getDefaultType()) != null ? InlineClassesUtilsKt.substitutedUnderlyingType((KotlinType)annotated) : null;
        KtTypeReference baseParameterTypeReference = baseParameter.getTypeReference();
        if (baseParameterType != null && baseParameterTypeReference != null) {
            if (this.isInapplicableParameterType(baseParameterType)) {
                trace.report(Errors.INLINE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE.on((KtTypeReference)((PsiElement)baseParameterTypeReference), baseParameterType));
                return;
            }
            if (InlineClassesUtilsKt.isRecursiveInlineClassType(baseParameterType)) {
                trace.report(Errors.INLINE_CLASS_CANNOT_BE_RECURSIVE.on((KtTypeReference)((PsiElement)baseParameterTypeReference)));
                return;
            }
        }
        for (KtSuperTypeListEntry supertypeEntry : ((KtClass)declaration2).getSuperTypeListEntries()) {
            ClassifierDescriptor typeDescriptor;
            KotlinType type2;
            KtTypeReference typeReference;
            if (supertypeEntry instanceof KtDelegatedSuperTypeEntry) {
                trace.report(Errors.INLINE_CLASS_CANNOT_IMPLEMENT_INTERFACE_BY_DELEGATION.on(supertypeEntry));
                return;
            }
            if (supertypeEntry.getTypeReference() == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)typeReference, (String)"supertypeEntry.typeReference ?: continue");
            if ((KotlinType)trace.get(BindingContext.TYPE, typeReference) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"trace[BindingContext.TYP\u2026ypeReference] ?: continue");
            if (type2.getConstructor().getDeclarationDescriptor() == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)typeDescriptor, (String)"type.constructor.declarationDescriptor ?: continue");
            if (DescriptorUtils.isInterface(typeDescriptor)) continue;
            trace.report(Errors.INLINE_CLASS_CANNOT_EXTEND_CLASSES.on((KtTypeReference)((PsiElement)typeReference)));
            return;
        }
    }

    private final boolean isInapplicableParameterType(KotlinType $this$isInapplicableParameterType) {
        return TypeUtilsKt.isUnit($this$isInapplicableParameterType) || TypeUtilsKt.isNothing($this$isInapplicableParameterType) || TypeUtilsKt.isTypeParameter($this$isInapplicableParameterType) || this.isGenericArrayOfTypeParameter($this$isInapplicableParameterType);
    }

    private final boolean isGenericArrayOfTypeParameter(KotlinType $this$isGenericArrayOfTypeParameter) {
        if (!KotlinBuiltIns.isArray($this$isGenericArrayOfTypeParameter)) {
            return false;
        }
        TypeProjection argument0 = $this$isGenericArrayOfTypeParameter.getArguments().get(0);
        if (argument0.isStarProjection()) {
            return false;
        }
        KotlinType kotlinType = argument0.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"argument0.type");
        KotlinType argument0type = kotlinType;
        return TypeUtilsKt.isTypeParameter(argument0type) || this.isGenericArrayOfTypeParameter(argument0type);
    }

    private final boolean isParameterAcceptableForInlineClass(KtParameter parameter) {
        UserDataHolder userDataHolder = KtPsiUtilKt.modalityModifier(parameter);
        boolean isOpen = Intrinsics.areEqual((Object)(userDataHolder != null && (userDataHolder = userDataHolder.getNode()) != null ? userDataHolder.getElementType() : null), (Object)KtTokens.OPEN_KEYWORD);
        return parameter.hasValOrVar() && !parameter.isMutable() && !parameter.isVarArg() && !isOpen;
    }

    private InlineClassDeclarationChecker() {
    }

    static {
        InlineClassDeclarationChecker inlineClassDeclarationChecker;
        INSTANCE = inlineClassDeclarationChecker = new InlineClassDeclarationChecker();
    }
}

