/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorPsiUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationResolverImpl;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.DeclarationsChecker;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ExposedVisibilityChecker;
import org.jetbrains.kotlin.resolve.FiniteBoundRestrictionChecker;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.LateinitModifierApplicabilityChecker;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.NonExpansiveInheritanceRestrictionChecker;
import org.jetbrains.kotlin.resolve.ShadowedExtensionChecker;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.resolve.checkers.PlatformDiagnosticSuppressor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SubstitutionUtils;
import org.jetbrains.kotlin.types.TypeAliasExpander;
import org.jetbrains.kotlin.types.TypeAliasExpansion;
import org.jetbrains.kotlin.types.TypeAliasExpansionReportStrategy;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b6\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ~2\u00020\u0001:\u0002~\u007fBE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00100\u001a\u00020\u00192\u0006\u00101\u001a\u0002022\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00103\u001a\u00020\u00192\u0006\u00104\u001a\u0002052\u0006\u00101\u001a\u000202H\u0002J\u001c\u00106\u001a\u00020\u00192\u0006\u00107\u001a\u0002082\n\u0010)\u001a\u0006\u0012\u0002\b\u000309H\u0002J\u0010\u0010:\u001a\u00020\u00192\u0006\u0010;\u001a\u000205H\u0002J\u0018\u0010<\u001a\u00020\u00192\u0006\u00107\u001a\u0002082\u0006\u0010)\u001a\u00020%H\u0002J\u0018\u0010=\u001a\u00020\u00192\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u001c\u0010B\u001a\u00020\u00192\u0006\u00107\u001a\u0002082\n\u0010)\u001a\u0006\u0012\u0002\b\u000309H\u0002J\u0018\u0010C\u001a\u00020\u00192\u0006\u0010D\u001a\u00020E2\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u0010F\u001a\u00020\u00192\u0006\u0010D\u001a\u00020E2\u0006\u0010&\u001a\u00020GJ\u0018\u0010H\u001a\u00020\u00192\u0006\u0010)\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0002J\u0018\u0010L\u001a\u00020\u00192\u0006\u00101\u001a\u00020A2\u0006\u0010.\u001a\u00020/H\u0002J\u0016\u0010M\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J \u0010N\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00101\u001a\u00020AH\u0002J\u0010\u0010O\u001a\u00020\u00192\u0006\u00101\u001a\u000202H\u0002J\u0010\u0010P\u001a\u00020\u00192\u0006\u0010Q\u001a\u00020RH\u0002J\u0018\u0010S\u001a\u00020\u00192\u0006\u0010)\u001a\u00020T2\u0006\u00101\u001a\u000202H\u0002J \u0010U\u001a\u00020\u00192\u0006\u0010J\u001a\u00020V2\u0006\u0010)\u001a\u00020W2\u0006\u0010X\u001a\u00020YH\u0002J\u0010\u0010Z\u001a\u00020\u00192\u0006\u00101\u001a\u000202H\u0002J\u0018\u0010[\u001a\u00020\u00192\u0006\u0010.\u001a\u00020/2\u0006\u00101\u001a\u00020AH\u0002J\u0018\u0010\\\u001a\u00020\u00192\u0006\u0010)\u001a\u00020%2\u0006\u0010J\u001a\u00020]H\u0002J\u0018\u0010^\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010_\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010`\u001a\u00020\u00192\u0006\u0010J\u001a\u00020\u001bH\u0002J\u0018\u0010a\u001a\u00020\u00192\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020eH\u0002J\u0018\u0010f\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010g\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010h\u001a\u00020\u00192\u0006\u0010i\u001a\u00020YH\u0002J\u0010\u0010j\u001a\u00020\u00192\u0006\u0010i\u001a\u00020YH\u0002J\u0010\u0010k\u001a\u00020\u00192\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u0010l\u001a\u00020\u00192\u0006\u00104\u001a\u000205H\u0002J\u0018\u0010m\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010n\u001a\u00020KH\u0002J\u001e\u0010o\u001a\b\u0012\u0004\u0012\u00020V0p2\u0006\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020,H\u0002J\u0010\u0010t\u001a\u00020u2\u0006\u0010!\u001a\u00020\"H\u0002J\u000e\u0010v\u001a\u00020\u00192\u0006\u0010w\u001a\u00020xJ$\u0010y\u001a\u00020\u00192\f\u0010z\u001a\b\u0012\u0004\u0012\u00020e0{2\f\u0010|\u001a\b\u0012\u0004\u0012\u00020e0}H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0015R\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0080\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker;", "", "descriptorResolver", "Lorg/jetbrains/kotlin/resolve/DescriptorResolver;", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "annotationChecker", "Lorg/jetbrains/kotlin/resolve/AnnotationChecker;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "typeSpecificityComparator", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "diagnosticSuppressor", "Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;", "(Lorg/jetbrains/kotlin/resolve/DescriptorResolver;Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/AnnotationChecker;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;)V", "exposedChecker", "Lorg/jetbrains/kotlin/resolve/ExposedVisibilityChecker;", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure;", "shadowedExtensionChecker", "Lorg/jetbrains/kotlin/resolve/ShadowedExtensionChecker;", "checkAccessor", "", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "accessorDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "checkAccessors", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "checkActualFunction", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkActualTypeAlias", "declaration", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "checkAnnotationClassMembers", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "checkClass", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "checkClassButNotObject", "aClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "checkConstructorDeclaration", "constructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "Lorg/jetbrains/kotlin/psi/KtConstructor;", "checkConstructorInInterface", "klass", "checkConstructorVisibility", "checkEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "enumEntryClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "checkExpectedClassConstructor", "checkExpectedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "checkFunction", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "checkImplicitCallableType", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "checkLocalAnnotation", "checkLocalTypeAliasDeclaration", "checkMemberProperty", "checkMethodsOfAnyInInterface", "checkModifiersAndAnnotationsInPackageDirective", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "checkObject", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "checkOnlyOneTypeParameterBound", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "owner", "Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwner;", "checkOpenMembers", "checkPrimaryConstructor", "checkPrivateExpectedDeclaration", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "checkProperty", "checkPropertyInitializer", "checkPropertyTypeParametersAreUsedInReceiverType", "checkSupertypesForConsistency", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "sourceElement", "Lcom/intellij/psi/PsiElement;", "checkTypeAliasDeclaration", "checkTypeAliasExpansion", "checkTypeParameterConstraints", "typeParameterListOwner", "checkTypeParameters", "checkTypesInClassHeader", "checkValOnAnnotationParameter", "checkVarargParameters", "callableDescriptor", "getUsedTypeAliasParameters", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "typeAlias", "noExplicitTypeOrGetterType", "", "process", "bodiesResolveContext", "Lorg/jetbrains/kotlin/resolve/BodiesResolveContext;", "reportVisibilityModifierDiagnostics", "tokens", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "Companion", "TypeAliasDeclarationCheckingReportStrategy", "frontend"})
public final class DeclarationsChecker {
    private final ModifiersChecker.ModifiersCheckingProcedure modifiersChecker;
    private final ExposedVisibilityChecker exposedChecker;
    private final ShadowedExtensionChecker shadowedExtensionChecker;
    private final DescriptorResolver descriptorResolver;
    private final AnnotationChecker annotationChecker;
    private final IdentifierChecker identifierChecker;
    private final BindingTrace trace;
    private final LanguageVersionSettings languageVersionSettings;
    private final PlatformDiagnosticSuppressor diagnosticSuppressor;
    private static final ImmutableSet<String> METHOD_OF_ANY_NAMES;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public final void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        KtTypeAlias declaration2;
        KtSecondaryConstructor $this$filterIsInstanceTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Object propertyDescriptor;
        KtProperty function2;
        KtNamedFunction classOrObject;
        boolean bl;
        Map.Entry entry;
        Intrinsics.checkNotNullParameter((Object)bodiesResolveContext, (String)"bodiesResolveContext");
        Object object2 = bodiesResolveContext.getFiles().iterator();
        while (object2.hasNext()) {
            KtFile ktFile;
            KtFile ktFile2 = ktFile = object2.next();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"file");
            this.checkModifiersAndAnnotationsInPackageDirective(ktFile2);
            this.annotationChecker.check(ktFile, this.trace, null);
        }
        object2 = bodiesResolveContext.getDeclaredClasses().entrySet().iterator();
        while (object2.hasNext()) {
            ClassDescriptorWithResolutionScopes classDescriptor2;
            Map.Entry entry2;
            entry = entry2 = (Map.Entry)object2.next();
            bl = false;
            KtClassOrObject ktClassOrObject = (KtClassOrObject)entry.getKey();
            entry = entry2;
            bl = false;
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = classDescriptor2 = (ClassDescriptorWithResolutionScopes)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)classDescriptorWithResolutionScopes, (String)"classDescriptor");
            KtNamedFunction ktNamedFunction = classOrObject;
            Intrinsics.checkNotNullExpressionValue((Object)ktNamedFunction, (String)"classOrObject");
            this.checkClass(classDescriptorWithResolutionScopes, (KtClassOrObject)((Object)ktNamedFunction));
            this.modifiersChecker.checkModifiersForDeclaration(classOrObject, classDescriptor2);
            this.identifierChecker.checkDeclaration(classOrObject, this.trace);
            this.exposedChecker.checkClassHeader((KtClassOrObject)((Object)classOrObject), classDescriptor2);
        }
        object2 = bodiesResolveContext.getFunctions().entrySet().iterator();
        while (object2.hasNext()) {
            Map.Entry entry3;
            entry = entry3 = (Map.Entry)object2.next();
            bl = false;
            classOrObject = (KtNamedFunction)entry.getKey();
            entry = entry3;
            bl = false;
            SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)entry.getValue();
            KtProperty ktProperty = function2;
            Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"function");
            SimpleFunctionDescriptor simpleFunctionDescriptor = functionDescriptor;
            Intrinsics.checkNotNullExpressionValue((Object)simpleFunctionDescriptor, (String)"functionDescriptor");
            this.checkFunction((KtNamedFunction)((Object)ktProperty), simpleFunctionDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(function2, functionDescriptor);
            this.identifierChecker.checkDeclaration(function2, this.trace);
        }
        object2 = bodiesResolveContext.getProperties().entrySet().iterator();
        while (object2.hasNext()) {
            void property2;
            Map.Entry entry4;
            entry = entry4 = (Map.Entry)object2.next();
            bl = false;
            function2 = (KtProperty)entry.getKey();
            entry = entry4;
            bl = false;
            propertyDescriptor = (PropertyDescriptor)entry.getValue();
            void v5 = property2;
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"property");
            Object object = propertyDescriptor;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"propertyDescriptor");
            this.checkProperty((KtProperty)v5, (PropertyDescriptor)object);
            this.modifiersChecker.checkModifiersForDeclaration((KtDeclaration)property2, (MemberDescriptor)propertyDescriptor);
            this.identifierChecker.checkDeclaration((KtDeclaration)property2, this.trace);
        }
        Iterable $this$map$iv = bodiesResolveContext.getDestructuringDeclarationEntries().entrySet();
        boolean $i$f$map = false;
        propertyDescriptor = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KtDestructuringDeclarationEntry entry5;
            void $dstr$entry$_u24__u24;
            Map.Entry entry6 = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var12_26 = $dstr$entry$_u24__u24;
            boolean bl3 = false;
            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = entry5 = (KtDestructuringDeclarationEntry)var12_26.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)ktDestructuringDeclarationEntry, (String)"entry");
            PsiElement psiElement = ktDestructuringDeclarationEntry.getParent();
            collection.add(psiElement);
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            if (!(element$iv$iv instanceof KtDestructuringDeclaration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        for (KtDestructuringDeclaration multiDeclaration : list2) {
            this.modifiersChecker.checkModifiersForDestructuringDeclaration(multiDeclaration);
            this.identifierChecker.checkDeclaration(multiDeclaration, this.trace);
        }
        Iterator<Object> iterator3 = bodiesResolveContext.getSecondaryConstructors().entrySet().iterator();
        while (iterator3.hasNext()) {
            ClassConstructorDescriptor constructorDescriptor;
            Object object = object2 = (Map.Entry)iterator3.next();
            boolean bl4 = false;
            $this$filterIsInstanceTo$iv$iv = (KtSecondaryConstructor)object.getKey();
            object = object2;
            bl4 = false;
            ClassConstructorDescriptor classConstructorDescriptor = constructorDescriptor = (ClassConstructorDescriptor)object.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)classConstructorDescriptor, (String)"constructorDescriptor");
            KtTypeAlias ktTypeAlias = declaration2;
            Intrinsics.checkNotNullExpressionValue((Object)ktTypeAlias, (String)"declaration");
            this.checkConstructorDeclaration(classConstructorDescriptor, (KtConstructor)((Object)ktTypeAlias));
            ExposedVisibilityChecker.checkFunction$default(this.exposedChecker, (KtFunction)((Object)declaration2), constructorDescriptor, null, 4, null);
        }
        iterator3 = bodiesResolveContext.getTypeAliases().entrySet().iterator();
        while (iterator3.hasNext()) {
            void declaration3;
            Object object = object2 = (Map.Entry)iterator3.next();
            boolean bl5 = false;
            declaration2 = (KtTypeAlias)object.getKey();
            object = object2;
            bl5 = false;
            TypeAliasDescriptor typeAliasDescriptor = (TypeAliasDescriptor)object.getValue();
            void v10 = declaration3;
            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"declaration");
            TypeAliasDescriptor typeAliasDescriptor2 = typeAliasDescriptor;
            Intrinsics.checkNotNullExpressionValue((Object)typeAliasDescriptor2, (String)"typeAliasDescriptor");
            this.checkTypeAliasDeclaration((KtTypeAlias)v10, typeAliasDescriptor2);
            this.modifiersChecker.checkModifiersForDeclaration((KtDeclaration)declaration3, typeAliasDescriptor);
            this.exposedChecker.checkTypeAlias((KtTypeAlias)declaration3, typeAliasDescriptor);
        }
    }

    public final void checkLocalTypeAliasDeclaration(@NotNull KtTypeAlias declaration2, @NotNull TypeAliasDescriptor typeAliasDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)typeAliasDescriptor, (String)"typeAliasDescriptor");
        this.checkTypeAliasDeclaration(declaration2, typeAliasDescriptor);
        this.modifiersChecker.checkModifiersForDeclaration(declaration2, typeAliasDescriptor);
        this.exposedChecker.checkTypeAlias(declaration2, typeAliasDescriptor);
    }

    private final void checkTypeAliasDeclaration(KtTypeAlias declaration2, TypeAliasDescriptor typeAliasDescriptor) {
        KtTypeReference ktTypeReference = declaration2.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference = ktTypeReference;
        this.checkTypeAliasExpansion(declaration2, typeAliasDescriptor);
        SimpleType expandedType2 = typeAliasDescriptor.getExpandedType();
        if (KotlinTypeKt.isError(expandedType2)) {
            return;
        }
        ClassifierDescriptor expandedClassifier = expandedType2.getConstructor().getDeclarationDescriptor();
        if (DynamicTypesKt.isDynamic(expandedType2) || expandedClassifier instanceof TypeParameterDescriptor) {
            this.trace.report(Errors.TYPEALIAS_SHOULD_EXPAND_TO_CLASS.on((KtTypeReference)((PsiElement)typeReference), expandedType2));
        }
        if (TypeUtils.contains((KotlinType)expandedType2, (Function1<UnwrappedType, Boolean>)((Function1)checkTypeAliasDeclaration.1.INSTANCE))) {
            this.trace.report(Errors.TYPEALIAS_EXPANDED_TO_MALFORMED_TYPE.on((KtTypeReference)((PsiElement)typeReference), expandedType2, "Array<Nothing> is illegal"));
        }
        Set<TypeParameterDescriptor> usedTypeAliasParameters = this.getUsedTypeAliasParameters(expandedType2, typeAliasDescriptor);
        for (TypeParameterDescriptor typeParameter : typeAliasDescriptor.getDeclaredTypeParameters()) {
            KtTypeParameter source;
            if (usedTypeAliasParameters.contains(typeParameter)) continue;
            TypeParameterDescriptor typeParameterDescriptor = typeParameter;
            Intrinsics.checkNotNullExpressionValue((Object)typeParameterDescriptor, (String)"typeParameter");
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(typeParameterDescriptor);
            if (!(psiElement instanceof KtTypeParameter)) {
                psiElement = null;
            }
            if ((KtTypeParameter)psiElement == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No source element for type parameter " + typeParameter + " of " + typeAliasDescriptor)));
            }
            this.trace.report(Errors.UNUSED_TYPEALIAS_PARAMETER.on((KtTypeParameter)((PsiElement)source), typeParameter, expandedType2));
        }
        if (PsiUtilsKt.hasActualModifier(declaration2)) {
            this.checkActualTypeAlias(declaration2, typeAliasDescriptor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkActualTypeAlias(KtTypeAlias declaration2, TypeAliasDescriptor typeAliasDescriptor) {
        void $this$mapTo$iv$iv;
        boolean bl;
        SimpleType rhs;
        block13: {
            Object it;
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block12: {
                rhs = typeAliasDescriptor.getUnderlyingType();
                ClassifierDescriptor classDescriptor2 = rhs.getConstructor().getDeclarationDescriptor();
                if (!(classDescriptor2 instanceof ClassDescriptor)) {
                    this.trace.report(Errors.ACTUAL_TYPE_ALIAS_NOT_TO_CLASS.on((KtTypeAlias)((PsiElement)declaration2)));
                    return;
                }
                List<TypeParameterDescriptor> list2 = ((ClassDescriptor)classDescriptor2).getDeclaredTypeParameters();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"classDescriptor.declaredTypeParameters");
                $this$any$iv = list2;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (TypeParameterDescriptor)element$iv;
                        boolean bl3 = false;
                        TypeParameterDescriptor typeParameterDescriptor = it;
                        Intrinsics.checkNotNullExpressionValue((Object)typeParameterDescriptor, (String)"it");
                        if (!(typeParameterDescriptor.getVariance() != Variance.INVARIANT)) continue;
                        bl2 = true;
                        break block12;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                this.trace.report(Errors.ACTUAL_TYPE_ALIAS_TO_CLASS_WITH_DECLARATION_SITE_VARIANCE.on((KtTypeAlias)((PsiElement)declaration2)));
                return;
            }
            $this$any$iv = rhs.getArguments();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (TypeProjection)element$iv;
                    boolean bl4 = false;
                    if (!(it.getProjectionKind() != Variance.INVARIANT || it.isStarProjection())) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            this.trace.report(Errors.ACTUAL_TYPE_ALIAS_WITH_USE_SITE_VARIANCE.on((KtTypeAlias)((PsiElement)declaration2)));
            return;
        }
        Iterable $this$map$iv = rhs.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            ClassifierDescriptor classifierDescriptor = it.getType().getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
                classifierDescriptor = null;
            }
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)classifierDescriptor;
            collection.add(typeParameterDescriptor);
        }
        if (Intrinsics.areEqual((Object)((List)destination$iv$iv), typeAliasDescriptor.getDeclaredTypeParameters()) ^ true) {
            this.trace.report(Errors.ACTUAL_TYPE_ALIAS_WITH_COMPLEX_SUBSTITUTION.on((KtTypeAlias)((PsiElement)declaration2)));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<TypeParameterDescriptor> getUsedTypeAliasParameters(KotlinType type2, TypeAliasDescriptor typeAlias) {
        void $this$mapNotNullTo$iv;
        Iterable iterable = TypeUtilsKt.constituentTypes(type2);
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor typeParameterDescriptor;
            TypeParameterDescriptor descriptor2;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            KotlinType it = (KotlinType)element$iv;
            boolean bl2 = false;
            ClassifierDescriptor classifierDescriptor = it.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
                classifierDescriptor = null;
            }
            if ((descriptor2 = (TypeParameterDescriptor)classifierDescriptor) != null) {
                TypeParameterDescriptor typeParameterDescriptor2;
                boolean bl3 = false;
                boolean bl4 = false;
                TypeParameterDescriptor it2 = typeParameterDescriptor2;
                boolean bl5 = false;
                typeParameterDescriptor = Intrinsics.areEqual((Object)it2.getContainingDeclaration(), (Object)typeAlias) ? typeParameterDescriptor2 : null;
            } else {
                typeParameterDescriptor = null;
            }
            if (typeParameterDescriptor == null) continue;
            TypeParameterDescriptor typeParameterDescriptor3 = typeParameterDescriptor;
            boolean bl6 = false;
            boolean bl7 = false;
            TypeParameterDescriptor it$iv = typeParameterDescriptor3;
            boolean bl8 = false;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }

    private final void checkTypeAliasExpansion(KtTypeAlias declaration2, TypeAliasDescriptor typeAliasDescriptor) {
        TypeAliasExpansion typeAliasExpansion = TypeAliasExpansion.Companion.createWithFormalArguments(typeAliasDescriptor);
        TypeAliasDeclarationCheckingReportStrategy reportStrategy = new TypeAliasDeclarationCheckingReportStrategy(this.trace, typeAliasDescriptor, declaration2);
        new TypeAliasExpander(reportStrategy, true).expandWithoutAbbreviation(typeAliasExpansion, Annotations.Companion.getEMPTY());
    }

    private final void checkConstructorDeclaration(ClassConstructorDescriptor constructorDescriptor, KtConstructor<?> declaration2) {
        this.modifiersChecker.checkModifiersForDeclaration(declaration2, constructorDescriptor);
        this.identifierChecker.checkDeclaration(declaration2, this.trace);
        this.checkVarargParameters(this.trace, constructorDescriptor);
        this.checkConstructorVisibility(constructorDescriptor, declaration2);
        this.checkExpectedClassConstructor(constructorDescriptor, declaration2);
        if (constructorDescriptor.isActual()) {
            this.checkActualFunction(declaration2, constructorDescriptor);
        }
    }

    private final void checkExpectedClassConstructor(ClassConstructorDescriptor constructorDescriptor, KtConstructor<?> declaration2) {
        KtConstructorDelegationCall delegationCall;
        if (!constructorDescriptor.isExpect()) {
            return;
        }
        if (declaration2.hasBody()) {
            this.trace.report(Errors.EXPECTED_DECLARATION_WITH_BODY.on((KtDeclaration)((PsiElement)declaration2)));
        }
        if (constructorDescriptor.getContainingDeclaration().getKind() == ClassKind.ENUM_CLASS) {
            this.trace.report(Errors.EXPECTED_ENUM_CONSTRUCTOR.on((KtConstructor<?>)((PsiElement)declaration2)));
        }
        if (declaration2 instanceof KtPrimaryConstructor && !DescriptorUtils.isAnnotationClass(constructorDescriptor.getConstructedClass())) {
            ClassDescriptor classDescriptor2 = constructorDescriptor.getConstructedClass();
            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"constructorDescriptor.constructedClass");
            if (!InlineClassesUtilsKt.isInlineClass(classDescriptor2)) {
                for (KtParameter parameter : ((KtPrimaryConstructor)declaration2).getValueParameters()) {
                    if (!parameter.hasValOrVar()) continue;
                    this.trace.report(Errors.EXPECTED_CLASS_CONSTRUCTOR_PROPERTY_PARAMETER.on((KtParameter)((PsiElement)parameter)));
                }
            }
        }
        if (declaration2 instanceof KtSecondaryConstructor && !(delegationCall = ((KtSecondaryConstructor)declaration2).getDelegationCall()).isImplicit()) {
            this.trace.report(Errors.EXPECTED_CLASS_CONSTRUCTOR_DELEGATION_CALL.on((KtConstructorDelegationCall)((PsiElement)delegationCall)));
        }
    }

    private final void checkConstructorVisibility(ClassConstructorDescriptor constructorDescriptor, KtDeclaration declaration2) {
        PsiElement visibilityModifier = KtPsiUtilKt.visibilityModifier(declaration2);
        if (visibilityModifier != null) {
            ASTNode aSTNode = visibilityModifier.getNode();
            if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtTokens.PRIVATE_KEYWORD) ^ true) {
                ClassDescriptor classDescriptor2 = constructorDescriptor.getContainingDeclaration();
                if (classDescriptor2.getKind() == ClassKind.ENUM_CLASS) {
                    this.trace.report(Errors.NON_PRIVATE_CONSTRUCTOR_IN_ENUM.on(visibilityModifier));
                } else if (classDescriptor2.getModality() == Modality.SEALED) {
                    this.trace.report(Errors.NON_PRIVATE_CONSTRUCTOR_IN_SEALED.on(visibilityModifier));
                }
            }
        }
    }

    private final void checkModifiersAndAnnotationsInPackageDirective(KtFile file2) {
        KtPackageDirective ktPackageDirective = file2.getPackageDirective();
        if (ktPackageDirective == null) {
            return;
        }
        KtPackageDirective packageDirective = ktPackageDirective;
        KtModifierList ktModifierList = packageDirective.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierList, (String)"packageDirective.modifierList ?: return");
        KtModifierList modifierList2 = ktModifierList;
        Iterator<KtAnnotationEntry> iterator2 = modifierList2.getAnnotationEntries().iterator();
        while (iterator2.hasNext()) {
            KtSimpleNameExpression ktSimpleNameExpression;
            KtAnnotationEntry annotationEntry;
            KtAnnotationEntry ktAnnotationEntry = annotationEntry = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)ktAnnotationEntry, (String)"annotationEntry");
            KtConstructorCalleeExpression calleeExpression = ktAnnotationEntry.getCalleeExpression();
            if (calleeExpression == null) continue;
            if (calleeExpression.getConstructorReferenceExpression() == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            KtSimpleNameExpression it = ktSimpleNameExpression;
            boolean bl3 = false;
            this.trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)it), it));
        }
        this.annotationChecker.check(packageDirective, this.trace, null);
        ModifierCheckerCore.INSTANCE.check(packageDirective, this.trace, null, this.languageVersionSettings);
    }

    private final void checkClass(ClassDescriptorWithResolutionScopes classDescriptor2, KtClassOrObject classOrObject) {
        this.checkSupertypesForConsistency(classDescriptor2, classOrObject);
        this.checkLocalAnnotation(classDescriptor2, classOrObject);
        this.checkTypesInClassHeader(classOrObject);
        KtClassOrObject ktClassOrObject = classOrObject;
        if (ktClassOrObject instanceof KtClass) {
            this.checkClassButNotObject((KtClass)classOrObject, classDescriptor2);
            this.descriptorResolver.checkNamesInConstraints(classOrObject, classDescriptor2, classDescriptor2.getScopeForClassHeaderResolution(), this.trace);
        } else if (ktClassOrObject instanceof KtObjectDeclaration) {
            this.checkObject((KtObjectDeclaration)classOrObject, classDescriptor2);
        }
        this.checkPrimaryConstructor(classOrObject, classDescriptor2);
        this.checkPrivateExpectedDeclaration(classOrObject, classDescriptor2);
    }

    private final void checkLocalAnnotation(ClassDescriptor classDescriptor2, KtClassOrObject classOrObject) {
        if (classDescriptor2.getKind() == ClassKind.ANNOTATION_CLASS && DescriptorUtils.isLocal(classDescriptor2)) {
            if (this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitLocalAnnotations)) {
                this.trace.report(Errors.LOCAL_ANNOTATION_CLASS_ERROR.on((KtClassOrObject)((PsiElement)classOrObject)));
            } else {
                this.trace.report(Errors.LOCAL_ANNOTATION_CLASS.on((KtClassOrObject)((PsiElement)classOrObject)));
            }
        }
    }

    private final void checkTypesInClassHeader(KtClassOrObject classOrObject) {
        KtTypeReference typeReference;
        Function1<KtTypeReference, KotlinType> $fun$type$1 = new Function1<KtTypeReference, KotlinType>(this){
            final /* synthetic */ DeclarationsChecker this$0;

            @Nullable
            public final KotlinType invoke(@NotNull KtTypeReference $this$type) {
                Intrinsics.checkNotNullParameter((Object)$this$type, (String)"$this$type");
                return (KotlinType)DeclarationsChecker.access$getTrace$p(this.this$0).getBindingContext().get(BindingContext.TYPE, $this$type);
            }
            {
                this.this$0 = declarationsChecker;
                super(1);
            }
        };
        for (KtSuperTypeListEntry delegationSpecifier : classOrObject.getSuperTypeListEntries()) {
            KotlinType kotlinType;
            KtTypeReference typeReference2;
            if (delegationSpecifier.getTypeReference() == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)typeReference2, (String)"delegationSpecifier.typeReference ?: continue");
            if ($fun$type$1.invoke(typeReference2) == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            KotlinType it = kotlinType;
            boolean bl3 = false;
            DescriptorResolver.checkBounds(typeReference2, it, this.trace);
        }
        if (!(classOrObject instanceof KtClass)) {
            return;
        }
        ArrayList<DescriptorResolver.UpperBoundCheckRequest> upperBoundCheckRequests = new ArrayList<DescriptorResolver.UpperBoundCheckRequest>();
        Iterator<KtElementImplStub> iterator2 = ((KtClass)classOrObject).getTypeParameters().iterator();
        while (iterator2.hasNext()) {
            KotlinType type2;
            KtTypeParameter typeParameter;
            KtTypeParameter ktTypeParameter = typeParameter = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)ktTypeParameter, (String)"typeParameter");
            if (ktTypeParameter.getExtendsBound() == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)typeReference, (String)"typeParameter.extendsBound ?: continue");
            if ($fun$type$1.invoke(typeReference) == null) {
                continue;
            }
            upperBoundCheckRequests.add(new DescriptorResolver.UpperBoundCheckRequest(typeParameter.getNameAsName(), typeReference, type2));
        }
        iterator2 = ((KtClass)classOrObject).getTypeConstraints().iterator();
        while (iterator2.hasNext()) {
            KotlinType type3;
            KtTypeConstraint constraint;
            KtTypeConstraint ktTypeConstraint = constraint = (KtTypeConstraint)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)ktTypeConstraint, (String)"constraint");
            if (ktTypeConstraint.getBoundTypeReference() == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)typeReference, (String)"constraint.boundTypeReference ?: continue");
            if ($fun$type$1.invoke(typeReference) == null) {
                continue;
            }
            Object object = constraint.getSubjectTypeParameterName();
            if (object == null || (object = object.getReferencedNameAsName()) == null) {
                continue;
            }
            Object name = object;
            upperBoundCheckRequests.add(new DescriptorResolver.UpperBoundCheckRequest((Name)name, typeReference, type3));
        }
        DescriptorResolver.checkUpperBoundTypes(this.trace, (List<DescriptorResolver.UpperBoundCheckRequest>)upperBoundCheckRequests, false);
        for (DescriptorResolver.UpperBoundCheckRequest request : upperBoundCheckRequests) {
            DescriptorResolver.checkBounds(request.upperBound, request.upperBoundType, this.trace);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOnlyOneTypeParameterBound(TypeParameterDescriptor descriptor2, KtTypeParameter declaration2, KtTypeParameterListOwner owner) {
        block16: {
            KtModifierListOwnerStub ktModifierListOwnerStub;
            void boundsWhichAreTypeParameters;
            Set otherBounds;
            Pair pair;
            TypeConstructor typeConstructor2;
            Collection collection;
            block15: {
                Pair $this$partition$iv22;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                List<KotlinType> list2 = descriptor2.getUpperBounds();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.upperBounds");
                List<KotlinType> upperBounds = list2;
                Iterable iterable = upperBounds;
                boolean $i$f$map = false;
                void var10_12 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void receiver;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator2.next();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    typeConstructor2 = ((KotlinType)receiver).getConstructor();
                    collection.add(typeConstructor2);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$partition = false;
                ArrayList first$iv22 = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv : $this$partition$iv22) {
                    TypeConstructor constructor2 = (TypeConstructor)element$iv;
                    boolean bl = false;
                    if (constructor2.getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
                        first$iv22.add(element$iv);
                        continue;
                    }
                    second$iv.add(element$iv);
                }
                $this$partition$iv22 = new Pair(first$iv22, second$iv);
                $i$f$partition = false;
                boolean first$iv22 = false;
                pair = $this$partition$iv22;
                boolean bl = false;
                Object object = TuplesKt.to((Object)CollectionsKt.toSet((Iterable)((Iterable)pair.getFirst())), (Object)CollectionsKt.toSet((Iterable)((Iterable)pair.getSecond())));
                Set set = (Set)object.component1();
                otherBounds = (Set)object.component2();
                if (boundsWhichAreTypeParameters.size() > 1) break block15;
                if (boundsWhichAreTypeParameters.size() != 1) break block16;
                object = otherBounds;
                boolean $this$partition$iv22 = false;
                if (!(!object.isEmpty())) break block16;
            }
            if (boundsWhichAreTypeParameters.size() + otherBounds.size() == 2) {
                Pair problematicBound;
                Object object;
                Object v6;
                block14: {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    List<KtTypeConstraint> list3 = owner.getTypeConstraints();
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"owner.typeConstraints");
                    Iterable $i$f$partition = list3;
                    boolean $i$f$filter = false;
                    pair = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        KtTypeConstraint constraint = (KtTypeConstraint)element$iv$iv;
                        boolean bl = false;
                        KtTypeConstraint ktTypeConstraint = constraint;
                        Intrinsics.checkNotNullExpressionValue((Object)ktTypeConstraint, (String)"constraint");
                        KtSimpleNameExpression ktSimpleNameExpression = ktTypeConstraint.getSubjectTypeParameterName();
                        if (!Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null), (Object)declaration2.getNameAsName())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$mapNotNull = false;
                    $this$filterTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Object constraint = $this$forEach$iv$iv$iv.iterator();
                    while (constraint.hasNext()) {
                        KtTypeReference ktTypeReference;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = constraint.next();
                        boolean bl = false;
                        KtTypeConstraint constraint2 = (KtTypeConstraint)element$iv$iv;
                        boolean bl2 = false;
                        KtTypeConstraint ktTypeConstraint = constraint2;
                        Intrinsics.checkNotNullExpressionValue((Object)ktTypeConstraint, (String)"constraint");
                        if (ktTypeConstraint.getBoundTypeReference() == null) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        KtTypeReference it$iv$iv = ktTypeReference;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void typeReference;
                        constraint = (KtTypeReference)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        typeConstructor2 = TuplesKt.to((Object)typeReference, this.trace.getBindingContext().get(BindingContext.TYPE, typeReference));
                        collection.add(typeConstructor2);
                    }
                    List allBounds = (List)destination$iv$iv;
                    Iterable $this$firstOrNull$iv = allBounds;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Pair bound = (Pair)element$iv;
                        boolean bl = false;
                        KotlinType kotlinType = (KotlinType)bound.getSecond();
                        if (!(Intrinsics.areEqual((Object)(kotlinType != null ? kotlinType.getConstructor() : null), (Object)((TypeConstructor)CollectionsKt.first((Iterable)((Iterable)boundsWhichAreTypeParameters)))) ^ true)) continue;
                        v6 = element$iv;
                        break block14;
                    }
                    v6 = null;
                }
                ktModifierListOwnerStub = (object = (problematicBound = (Pair)v6)) != null && (object = (KtTypeReference)object.getFirst()) != null ? (KtModifierListOwnerStub)object : (KtModifierListOwnerStub)declaration2;
            } else {
                ktModifierListOwnerStub = declaration2;
            }
            KtModifierListOwnerStub reportOn = ktModifierListOwnerStub;
            DeclarationDescriptor $this$safeAs$iv = descriptor2.getContainingDeclaration();
            boolean $i$f$safeAs = false;
            DeclarationDescriptor declarationDescriptor = $this$safeAs$iv;
            if (!(declarationDescriptor instanceof MemberDescriptor)) {
                declarationDescriptor = null;
            }
            MemberDescriptor memberDescriptor = (MemberDescriptor)declarationDescriptor;
            if (memberDescriptor != null) {
                if (InlineOnlyKt.isInlineOnly(memberDescriptor)) {
                    return;
                }
            }
            this.trace.report(Errors.BOUNDS_NOT_ALLOWED_IF_BOUNDED_BY_TYPE_PARAMETER.on((KtElement)((PsiElement)reportOn)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkSupertypesForConsistency(ClassifierDescriptor classifier2, PsiElement sourceElement) {
        Object object;
        Iterable it;
        Collection collection;
        Object $this$mapTo$iv$iv;
        if (classifier2 instanceof TypeParameterDescriptor) {
            List<KotlinType> list2 = ((TypeParameterDescriptor)classifier2).getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"classifier.upperBounds");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv = iterator2.next();
                KotlinType kotlinType = (KotlinType)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                object = ((KotlinType)((Object)it)).getConstructor();
                collection.add(object);
            }
            List immediateUpperBounds = (List)destination$iv$iv;
            if (immediateUpperBounds.size() != CollectionsKt.toSet((Iterable)immediateUpperBounds).size()) {
                return;
            }
        }
        Multimap<TypeParameterDescriptor, TypeProjection> multimap = SubstitutionUtils.buildDeepSubstitutionMultimap(classifier2.getDefaultType());
        Intrinsics.checkNotNullExpressionValue(multimap, (String)"SubstitutionUtils.buildD\u2026p(classifier.defaultType)");
        Multimap<TypeParameterDescriptor, TypeProjection> multiMap = multimap;
        Map<TypeParameterDescriptor, Collection<TypeProjection>> map2 = multiMap.asMap();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"multiMap.asMap()");
        $this$mapTo$iv$iv = map2;
        boolean destination$iv$iv = false;
        Iterator<Map.Entry<TypeParameterDescriptor, Collection<TypeProjection>>> iterator3 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            ClassDescriptor containingDeclaration;
            void typeParameterDescriptor;
            void $this$mapTo$iv$iv2;
            Map.Entry<TypeParameterDescriptor, Collection<TypeProjection>> entry;
            Map.Entry<TypeParameterDescriptor, Collection<TypeProjection>> $i$f$mapTo = entry = iterator3.next();
            boolean bl = false;
            $this$mapTo$iv$iv = $i$f$mapTo.getKey();
            $i$f$mapTo = entry;
            bl = false;
            Collection<TypeProjection> projections = $i$f$mapTo.getValue();
            if (projections.size() <= 1) continue;
            Collection<TypeProjection> collection2 = projections;
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"projections");
            Iterable $this$map$iv = collection2;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                void v4 = it2;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
                object = v4.getType();
                collection.add(object);
            }
            Set conflictingTypes = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv2));
            DeclarationsChecker.Companion.removeDuplicateTypes(conflictingTypes);
            if (conflictingTypes.size() <= 1) continue;
            void v5 = typeParameterDescriptor;
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"typeParameterDescriptor");
            DeclarationDescriptor declarationDescriptor = v5.getContainingDeclaration();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                declarationDescriptor = null;
            }
            if ((ClassDescriptor)declarationDescriptor == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Not a class descriptor: " + typeParameterDescriptor.getContainingDeclaration())));
            }
            if (sourceElement instanceof KtClassOrObject) {
                KtSuperTypeList delegationSpecifierList;
                if (((KtClassOrObject)sourceElement).getSuperTypeList() == null) {
                    continue;
                }
                this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_VALUES.on((KtSuperTypeList)((PsiElement)delegationSpecifierList), (TypeParameterDescriptor)typeParameterDescriptor, containingDeclaration, conflictingTypes));
                continue;
            }
            if (!(sourceElement instanceof KtTypeParameter)) continue;
            this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_BOUNDS.on((KtTypeParameter)sourceElement, (TypeParameterDescriptor)typeParameterDescriptor, containingDeclaration, conflictingTypes));
        }
    }

    private final void checkObject(KtObjectDeclaration declaration2, ClassDescriptorWithResolutionScopes classDescriptor2) {
        this.checkOpenMembers(classDescriptor2);
        if (declaration2.isLocal() && !declaration2.isCompanion() && !declaration2.isObjectLiteral()) {
            this.trace.report(Errors.LOCAL_OBJECT_NOT_ALLOWED.on((KtObjectDeclaration)((PsiElement)declaration2), classDescriptor2));
        }
    }

    private final void checkClassButNotObject(KtClass aClass2, ClassDescriptorWithResolutionScopes classDescriptor2) {
        block1: {
            block2: {
                block0: {
                    this.checkOpenMembers(classDescriptor2);
                    this.checkTypeParameters(aClass2);
                    this.checkTypeParameterConstraints(aClass2);
                    FiniteBoundRestrictionChecker.check(aClass2, classDescriptor2, this.trace);
                    NonExpansiveInheritanceRestrictionChecker.check(aClass2, classDescriptor2, this.trace);
                    if (!aClass2.isInterface()) break block0;
                    this.checkConstructorInInterface(aClass2);
                    this.checkMethodsOfAnyInInterface(classDescriptor2);
                    if (!aClass2.isLocal() || classDescriptor2.getContainingDeclaration() instanceof ClassDescriptor) break block1;
                    this.trace.report(Errors.LOCAL_INTERFACE_NOT_ALLOWED.on((KtClass)((PsiElement)aClass2), classDescriptor2));
                    break block1;
                }
                if (classDescriptor2.getKind() != ClassKind.ANNOTATION_CLASS) break block2;
                this.checkAnnotationClassMembers(aClass2);
                this.checkValOnAnnotationParameter(aClass2);
                break block1;
            }
            if (!(aClass2 instanceof KtEnumEntry)) break block1;
            this.checkEnumEntry((KtEnumEntry)aClass2, classDescriptor2);
        }
    }

    private final void checkPrimaryConstructor(KtClassOrObject classOrObject, ClassDescriptor classDescriptor2) {
        PsiElement psiElement;
        ClassConstructorDescriptor classConstructorDescriptor = classDescriptor2.getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)classConstructorDescriptor, (String)"classDescriptor.unsubsti\u2026maryConstructor ?: return");
        ClassConstructorDescriptor primaryConstructor2 = classConstructorDescriptor;
        KtPrimaryConstructor ktPrimaryConstructor = classOrObject.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return;
        }
        KtPrimaryConstructor declaration2 = ktPrimaryConstructor;
        for (KtParameter parameter : declaration2.getValueParameters()) {
            PropertyDescriptor propertyDescriptor;
            if ((PropertyDescriptor)this.trace.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter) == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            PropertyDescriptor it = propertyDescriptor;
            boolean bl3 = false;
            this.modifiersChecker.checkModifiersForDeclaration(parameter, it);
            KtParameter ktParameter = parameter;
            Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"parameter");
            KtCallableDeclaration ktCallableDeclaration = ktParameter;
            PropertyDescriptor propertyDescriptor2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor2, (String)"it");
            LateinitModifierApplicabilityChecker.INSTANCE.checkLateinitModifierApplicability(this.trace, ktCallableDeclaration, propertyDescriptor2);
        }
        if (!declaration2.hasConstructorKeyword()) {
            KtModifierList ktModifierList = declaration2.getModifierList();
            if (ktModifierList != null) {
                psiElement = ktModifierList;
                boolean bl = false;
                boolean bl4 = false;
                PsiElement it = psiElement;
                boolean bl5 = false;
                this.trace.report(Errors.MISSING_CONSTRUCTOR_KEYWORD.on((KtElement)it));
            }
        }
        if (declaration2.getValueParameterList() == null) {
            PsiElement psiElement2 = declaration2.getConstructorKeyword();
            if (psiElement2 != null) {
                psiElement = psiElement2;
                boolean bl = false;
                boolean bl6 = false;
                PsiElement it = psiElement;
                boolean bl7 = false;
                this.trace.report(Errors.MISSING_CONSTRUCTOR_BRACKETS.on(it));
            }
        }
        if (!(classOrObject instanceof KtClass)) {
            this.trace.report(Errors.CONSTRUCTOR_IN_OBJECT.on((KtDeclaration)((PsiElement)declaration2)));
        }
        this.checkConstructorDeclaration(primaryConstructor2, declaration2);
    }

    private final void checkTypeParameters(KtTypeParameterListOwner typeParameterListOwner) {
        for (KtTypeParameter jetTypeParameter : typeParameterListOwner.getTypeParameters()) {
            TypeParameterDescriptor typeParameterDescriptor;
            AnnotationResolverImpl.reportUnsupportedAnnotationForTypeParameter(jetTypeParameter, this.trace);
            if ((TypeParameterDescriptor)this.trace.get(BindingContext.TYPE_PARAMETER, jetTypeParameter) == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            TypeParameterDescriptor it = typeParameterDescriptor;
            boolean bl3 = false;
            DescriptorResolver.checkConflictingUpperBounds(this.trace, it, jetTypeParameter);
        }
    }

    private final void checkTypeParameterConstraints(KtTypeParameterListOwner typeParameterListOwner) {
        List<KtTypeConstraint> list2 = typeParameterListOwner.getTypeConstraints();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"typeParameterListOwner.typeConstraints");
        List<KtTypeConstraint> constraints = list2;
        if (constraints.isEmpty()) {
            return;
        }
        Iterator<KtTypeParameter> iterator2 = typeParameterListOwner.getTypeParameters().iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor typeParameterDescriptor;
            KtTypeParameter typeParameter;
            KtTypeParameter ktTypeParameter = typeParameter = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)ktTypeParameter, (String)"typeParameter");
            if (ktTypeParameter.getExtendsBound() != null && DeclarationsChecker.Companion.hasConstraints(typeParameter, constraints)) {
                this.trace.report(Errors.MISPLACED_TYPE_PARAMETER_CONSTRAINTS.on((KtTypeParameter)((PsiElement)typeParameter)));
            }
            if ((TypeParameterDescriptor)this.trace.get(BindingContext.TYPE_PARAMETER, typeParameter) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)typeParameterDescriptor, (String)"trace.get(TYPE_PARAMETER\u2026ypeParameter) ?: continue");
            this.checkSupertypesForConsistency(typeParameterDescriptor, typeParameter);
            this.checkOnlyOneTypeParameterBound(typeParameterDescriptor, typeParameter, typeParameterListOwner);
        }
    }

    private final void checkConstructorInInterface(KtClass klass) {
        block0: {
            KtPrimaryConstructor ktPrimaryConstructor = klass.getPrimaryConstructor();
            if (ktPrimaryConstructor == null) break block0;
            KtPrimaryConstructor ktPrimaryConstructor2 = ktPrimaryConstructor;
            boolean bl = false;
            boolean bl2 = false;
            KtPrimaryConstructor it = ktPrimaryConstructor2;
            boolean bl3 = false;
            this.trace.report(Errors.CONSTRUCTOR_IN_INTERFACE.on((KtDeclaration)((PsiElement)it)));
        }
    }

    private final void checkMethodsOfAnyInInterface(ClassDescriptorWithResolutionScopes classDescriptor2) {
        for (CallableMemberDescriptor declaredCallableMember : classDescriptor2.getDeclaredCallableMembers()) {
            PsiElement declaration2;
            if (!(declaredCallableMember instanceof FunctionDescriptor) || !((declaration2 = DescriptorToSourceUtils.descriptorToDeclaration(declaredCallableMember)) instanceof KtNamedFunction) || DeclarationsChecker.Companion.isHidingParentMemberIfPresent(declaredCallableMember) || !DeclarationsChecker.Companion.isImplementingMethodOfAny(declaredCallableMember)) continue;
            this.trace.report(Errors.METHOD_OF_ANY_IMPLEMENTED_IN_INTERFACE.on((KtDeclaration)declaration2));
        }
    }

    private final void checkAnnotationClassMembers(KtClassOrObject classOrObject) {
        for (KtDeclaration declaration2 : classOrObject.getDeclarations()) {
            if (declaration2 instanceof KtClassOrObject && this.languageVersionSettings.supportsFeature(LanguageFeature.NestedClassesInAnnotations)) continue;
            this.trace.report(Errors.ANNOTATION_CLASS_MEMBER.on(declaration2));
        }
    }

    private final void checkValOnAnnotationParameter(KtClass aClass2) {
        for (KtParameter parameter : aClass2.getPrimaryConstructorParameters()) {
            if (!parameter.hasValOrVar()) {
                this.trace.report(Errors.MISSING_VAL_ON_ANNOTATION_PARAMETER.on((KtParameter)((PsiElement)parameter)));
                continue;
            }
            if (!parameter.isMutable()) continue;
            this.trace.report(Errors.VAR_ANNOTATION_PARAMETER.on((KtParameter)((PsiElement)parameter)));
        }
    }

    private final void checkOpenMembers(ClassDescriptorWithResolutionScopes classDescriptor2) {
        if (DescriptorUtils.classCanHaveOpenMembers(classDescriptor2)) {
            return;
        }
        Iterator<CallableMemberDescriptor> iterator2 = classDescriptor2.getDeclaredCallableMembers().iterator();
        while (iterator2.hasNext()) {
            KtNamedDeclaration member;
            CallableMemberDescriptor memberDescriptor;
            CallableMemberDescriptor callableMemberDescriptor = memberDescriptor = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor, (String)"memberDescriptor");
            if (callableMemberDescriptor.getKind() != CallableMemberDescriptor.Kind.DECLARATION) continue;
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(memberDescriptor);
            if (!(psiElement instanceof KtNamedDeclaration)) {
                psiElement = null;
            }
            if ((member = (KtNamedDeclaration)psiElement) == null || !member.hasModifier(KtTokens.OPEN_KEYWORD)) continue;
            if (classDescriptor2.getKind() == ClassKind.OBJECT) {
                this.trace.report(Errors.NON_FINAL_MEMBER_IN_OBJECT.on((KtNamedDeclaration)((PsiElement)member)));
                continue;
            }
            this.trace.report(Errors.NON_FINAL_MEMBER_IN_FINAL_CLASS.on((KtNamedDeclaration)((PsiElement)member)));
        }
    }

    private final void checkProperty(KtProperty property2, PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor declarationDescriptor = propertyDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"propertyDescriptor.containingDeclaration");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (containingDeclaration instanceof ClassDescriptor) {
            this.checkMemberProperty(property2, propertyDescriptor, (ClassDescriptor)containingDeclaration);
        }
        LateinitModifierApplicabilityChecker.INSTANCE.checkLateinitModifierApplicability(this.trace, property2, propertyDescriptor);
        this.checkPropertyInitializer(property2, propertyDescriptor);
        this.checkAccessors(property2, propertyDescriptor);
        this.checkTypeParameterConstraints(property2);
        ExposedVisibilityChecker.checkProperty$default(this.exposedChecker, property2, propertyDescriptor, null, 4, null);
        this.shadowedExtensionChecker.checkDeclaration(property2, propertyDescriptor);
        this.checkPropertyTypeParametersAreUsedInReceiverType(propertyDescriptor);
        this.checkImplicitCallableType(property2, propertyDescriptor);
        this.checkPrivateExpectedDeclaration(property2, propertyDescriptor);
    }

    private final void checkPrivateExpectedDeclaration(KtDeclaration declaration2, MemberDescriptor descriptor2) {
        if (descriptor2.isExpect() && DescriptorVisibilities.isPrivate(descriptor2.getVisibility())) {
            PsiElement psiElement = declaration2.getModifierList();
            if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.PRIVATE_KEYWORD)) == null) {
                psiElement = declaration2;
            }
            this.trace.report(Errors.EXPECTED_PRIVATE_DECLARATION.on(psiElement));
        }
    }

    private final void checkPropertyTypeParametersAreUsedInReceiverType(PropertyDescriptor descriptor2) {
        List<TypeParameterDescriptor> list2 = descriptor2.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.typeParameters");
        Set allTypeParameters = CollectionsKt.toSet((Iterable)list2);
        HashSet allAccessibleTypeParameters = new HashSet();
        Function1<KotlinType, Unit> $fun$addAccessibleTypeParametersFromType$1 = new Function1<KotlinType, Unit>(allTypeParameters, allAccessibleTypeParameters){
            final /* synthetic */ Set $allTypeParameters;
            final /* synthetic */ HashSet $allAccessibleTypeParameters;

            public final void invoke(@Nullable KotlinType type2) {
                TypeUtils.contains(type2, (Function1<UnwrappedType, Boolean>)((Function1)new Function1<UnwrappedType, Boolean>(this){
                    final /* synthetic */ checkPropertyTypeParametersAreUsedInReceiverType.1 this$0;

                    public final Boolean invoke(UnwrappedType it) {
                        ClassifierDescriptor declarationDescriptor = it.getConstructor().getDeclarationDescriptor();
                        if (declarationDescriptor instanceof TypeParameterDescriptor && this.this$0.$allTypeParameters.contains(declarationDescriptor) && this.this$0.$allAccessibleTypeParameters.add(declarationDescriptor)) {
                            List<KotlinType> list2 = ((TypeParameterDescriptor)declarationDescriptor).getUpperBounds();
                            Intrinsics.checkNotNullExpressionValue(list2, (String)"declarationDescriptor.upperBounds");
                            Iterable $this$forEach$iv = list2;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                KotlinType p1 = (KotlinType)element$iv;
                                boolean bl = false;
                                this.this$0.invoke(p1);
                            }
                        }
                        return false;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.$allTypeParameters = set;
                this.$allAccessibleTypeParameters = hashSet;
                super(1);
            }
        };
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        $fun$addAccessibleTypeParametersFromType$1.invoke(receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null);
        Set typeParametersInaccessibleFromReceiver = SetsKt.minus((Set)allTypeParameters, (Iterable)allAccessibleTypeParameters);
        Iterator iterator2 = typeParametersInaccessibleFromReceiver.iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor typeParameter;
            TypeParameterDescriptor typeParameterDescriptor = typeParameter = (TypeParameterDescriptor)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)typeParameterDescriptor, (String)"typeParameter");
            PsiElement typeParameterPsi = DescriptorToSourceUtils.getSourceFromDescriptor(typeParameterDescriptor);
            if (!(typeParameterPsi instanceof KtTypeParameter)) continue;
            this.trace.report(Errors.TYPE_PARAMETER_OF_PROPERTY_NOT_USED_IN_RECEIVER.on((KtTypeParameter)typeParameterPsi));
        }
    }

    private final void checkMemberProperty(KtProperty property2, PropertyDescriptor propertyDescriptor, ClassDescriptor classDescriptor2) {
        KtModifierList modifierList2 = property2.getModifierList();
        if (modifierList2 != null) {
            if (modifierList2.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                if (!DescriptorUtils.classCanHaveAbstractDeclaration(classDescriptor2)) {
                    PsiElement psiElement = property2;
                    String string2 = property2.getName();
                    if (string2 == null) {
                        string2 = "";
                    }
                    this.trace.report(Errors.ABSTRACT_PROPERTY_IN_NON_ABSTRACT_CLASS.on((KtModifierListOwner)psiElement, string2, classDescriptor2));
                    return;
                }
            } else if (classDescriptor2.getKind() == ClassKind.INTERFACE && modifierList2.hasModifier(KtTokens.OPEN_KEYWORD) && propertyDescriptor.getModality() == Modality.ABSTRACT) {
                this.trace.report(Errors.REDUNDANT_OPEN_IN_INTERFACE.on((KtModifierListOwner)((PsiElement)property2)));
            }
        }
        if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
            KtPropertyAccessor setter2;
            KtExpression it;
            boolean bl;
            boolean bl2;
            KtElement ktElement;
            KtExpression ktExpression = property2.getInitializer();
            if (ktExpression != null) {
                ktElement = ktExpression;
                bl2 = false;
                bl = false;
                it = ktElement;
                boolean bl3 = false;
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_INITIALIZER.on((KtExpression)((PsiElement)it)));
            }
            KtPropertyDelegate ktPropertyDelegate = property2.getDelegate();
            if (ktPropertyDelegate != null) {
                ktElement = ktPropertyDelegate;
                bl2 = false;
                bl = false;
                it = ktElement;
                boolean bl4 = false;
                this.trace.report(Errors.ABSTRACT_DELEGATED_PROPERTY.on((KtPropertyDelegate)((Object)it)));
            }
            KtPropertyAccessor getter2 = property2.getGetter();
            if (getter2 != null && getter2.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_GETTER.on((KtPropertyAccessor)((PsiElement)getter2)));
            }
            if ((setter2 = property2.getSetter()) != null && setter2.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_SETTER.on((KtPropertyAccessor)((PsiElement)setter2)));
            }
        }
    }

    private final void checkPropertyInitializer(KtProperty property2, PropertyDescriptor propertyDescriptor) {
        boolean hasAccessorImplementation = Companion.hasAccessorImplementation(propertyDescriptor);
        DeclarationDescriptor declarationDescriptor = propertyDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"propertyDescriptor.containingDeclaration");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        boolean inInterface = DescriptorUtils.isInterface(containingDeclaration);
        if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
            if (!property2.hasDelegateExpressionOrInitializer() && property2.getTypeReference() == null) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on((KtProperty)((PsiElement)property2)));
            }
            if (inInterface && property2.hasModifier(KtTokens.PRIVATE_KEYWORD) && !property2.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                this.trace.report(Errors.PRIVATE_PROPERTY_IN_INTERFACE.on((KtProperty)((PsiElement)property2)));
            }
            return;
        }
        Boolean bl = (Boolean)this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
        if (bl == null) {
            bl = false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"trace.bindingContext.get\u2026pertyDescriptor) ?: false");
        boolean backingFieldRequired = bl;
        if (inInterface && backingFieldRequired && hasAccessorImplementation) {
            this.trace.report(Errors.BACKING_FIELD_IN_INTERFACE.on((KtProperty)((PsiElement)property2)));
        }
        KtExpression initializer2 = property2.getInitializer();
        KtPropertyDelegate delegate = property2.getDelegate();
        boolean isExpect = propertyDescriptor.isExpect();
        if (initializer2 != null) {
            if (inInterface) {
                this.trace.report(Errors.PROPERTY_INITIALIZER_IN_INTERFACE.on((KtExpression)((PsiElement)initializer2)));
            } else if (isExpect) {
                this.trace.report(Errors.EXPECTED_PROPERTY_INITIALIZER.on((KtExpression)((PsiElement)initializer2)));
            } else if (!backingFieldRequired) {
                this.trace.report(Errors.PROPERTY_INITIALIZER_NO_BACKING_FIELD.on((KtExpression)((PsiElement)initializer2)));
            } else if (property2.getReceiverTypeReference() != null) {
                this.trace.report(Errors.EXTENSION_PROPERTY_WITH_BACKING_FIELD.on((KtExpression)((PsiElement)initializer2)));
            }
        } else if (delegate != null) {
            if (inInterface) {
                this.trace.report(Errors.DELEGATED_PROPERTY_IN_INTERFACE.on((KtPropertyDelegate)((PsiElement)delegate)));
            } else if (isExpect) {
                this.trace.report(Errors.EXPECTED_DELEGATED_PROPERTY.on((KtPropertyDelegate)((PsiElement)delegate)));
            }
        } else {
            Boolean bl2 = (Boolean)this.trace.getBindingContext().get(BindingContext.IS_UNINITIALIZED, propertyDescriptor);
            if (bl2 == null) {
                bl2 = false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"trace.bindingContext.get\u2026pertyDescriptor) ?: false");
            boolean isUninitialized = bl2;
            boolean isExternal = DescriptorUtilsKt.isEffectivelyExternal(propertyDescriptor);
            if (backingFieldRequired && !inInterface && !propertyDescriptor.isLateInit() && !isExpect && isUninitialized && !isExternal) {
                if (propertyDescriptor.getExtensionReceiverParameter() != null && !hasAccessorImplementation) {
                    this.trace.report(Errors.EXTENSION_PROPERTY_MUST_HAVE_ACCESSORS_OR_BE_ABSTRACT.on((KtProperty)((PsiElement)property2)));
                } else if (this.diagnosticSuppressor.shouldReportNoBody(propertyDescriptor)) {
                    if (!(containingDeclaration instanceof ClassDescriptor) || hasAccessorImplementation) {
                        this.trace.report(Errors.MUST_BE_INITIALIZED.on((KtProperty)((PsiElement)property2)));
                    } else {
                        this.trace.report(Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT.on((KtProperty)((PsiElement)property2)));
                    }
                }
            } else if (property2.getTypeReference() == null && !this.languageVersionSettings.supportsFeature(LanguageFeature.ShortSyntaxForPropertyGetters)) {
                this.trace.report(Errors.UNSUPPORTED_FEATURE.on(property2, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.ShortSyntaxForPropertyGetters), (Object)this.languageVersionSettings)));
            } else if (this.noExplicitTypeOrGetterType(property2)) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on((KtProperty)((PsiElement)property2)));
            }
            if (propertyDescriptor.isLateInit()) {
                if (propertyDescriptor.isExpect()) {
                    PsiElement psiElement = property2.getModifierList();
                    if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.LATEINIT_KEYWORD)) == null) {
                        psiElement = property2;
                    }
                    this.trace.report(Errors.EXPECTED_LATEINIT_PROPERTY.on(psiElement));
                }
                if (backingFieldRequired && !inInterface && !isUninitialized && Intrinsics.areEqual((Object)((Boolean)this.trace.get(BindingContext.MUST_BE_LATEINIT, propertyDescriptor)), (Object)true) ^ true) {
                    this.trace.report(Errors.UNNECESSARY_LATEINIT.on((KtProperty)((PsiElement)property2)));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean noExplicitTypeOrGetterType(KtProperty property2) {
        if (property2.getTypeReference() != null) return false;
        if (property2.getGetter() == null) return true;
        KtPropertyAccessor ktPropertyAccessor = property2.getGetter();
        Intrinsics.checkNotNull((Object)ktPropertyAccessor);
        if (!ktPropertyAccessor.hasBlockBody()) return false;
        KtPropertyAccessor ktPropertyAccessor2 = property2.getGetter();
        Intrinsics.checkNotNull((Object)ktPropertyAccessor2);
        Intrinsics.checkNotNullExpressionValue((Object)ktPropertyAccessor2, (String)"property.getter!!");
        if (ktPropertyAccessor2.getReturnTypeReference() != null) return false;
        return true;
    }

    public final void checkFunction(@NotNull KtNamedFunction function2, @NotNull SimpleFunctionDescriptor functionDescriptor) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
        KtTypeParameterList typeParameterList = function2.getTypeParameterList();
        PsiElement nameIdentifier = function2.getNameIdentifier();
        if (typeParameterList != null && nameIdentifier != null) {
            TextRange textRange = typeParameterList.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"typeParameterList.textRange");
            int n = textRange.getStartOffset();
            TextRange textRange2 = nameIdentifier.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"nameIdentifier.textRange");
            if (n > textRange2.getStartOffset()) {
                this.trace.report(Errors.DEPRECATED_TYPE_PARAMETER_SYNTAX.on((KtTypeParameterList)((PsiElement)typeParameterList)));
            }
        }
        this.checkTypeParameterConstraints(function2);
        this.checkImplicitCallableType(function2, functionDescriptor);
        ExposedVisibilityChecker.checkFunction$default(this.exposedChecker, function2, functionDescriptor, null, 4, null);
        this.checkVarargParameters(this.trace, functionDescriptor);
        DeclarationDescriptor declarationDescriptor = functionDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"functionDescriptor.containingDeclaration");
        DeclarationDescriptor containingDescriptor = declarationDescriptor;
        boolean hasAbstractModifier = function2.hasModifier(KtTokens.ABSTRACT_KEYWORD);
        boolean hasExternalModifier = DescriptorUtilsKt.isEffectivelyExternal(functionDescriptor);
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean hasBody;
            boolean inInterface = ((ClassDescriptor)containingDescriptor).getKind() == ClassKind.INTERFACE;
            boolean isExpectClass = ((ClassDescriptor)containingDescriptor).isExpect();
            if (hasAbstractModifier && !DescriptorUtils.classCanHaveAbstractDeclaration((ClassDescriptor)containingDescriptor)) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_IN_NON_ABSTRACT_CLASS.on((KtFunction)((PsiElement)function2), functionDescriptor.getName().asString(), (ClassDescriptor)containingDescriptor));
            }
            if ((hasBody = function2.hasBody()) && hasAbstractModifier) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_WITH_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
            }
            if (!hasBody && inInterface) {
                if (function2.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
                    this.trace.report(Errors.PRIVATE_FUNCTION_WITH_NO_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
                }
                if (!((ClassDescriptor)containingDescriptor).isExpect() && !hasAbstractModifier && function2.hasModifier(KtTokens.OPEN_KEYWORD)) {
                    this.trace.report(Errors.REDUNDANT_OPEN_IN_INTERFACE.on((KtModifierListOwner)((PsiElement)function2)));
                }
            }
            if (!(hasBody || hasAbstractModifier || hasExternalModifier || inInterface || isExpectClass || !this.diagnosticSuppressor.shouldReportNoBody(functionDescriptor))) {
                this.trace.report(Errors.NON_ABSTRACT_FUNCTION_WITH_NO_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
            }
        } else if (!(function2.hasBody() || hasAbstractModifier || hasExternalModifier || functionDescriptor.isExpect() || !this.diagnosticSuppressor.shouldReportNoBody(functionDescriptor))) {
            this.trace.report(Errors.NON_MEMBER_FUNCTION_NO_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
        }
        if (functionDescriptor.isExpect()) {
            this.checkExpectedFunction(function2, functionDescriptor);
        }
        if (functionDescriptor.isActual()) {
            this.checkActualFunction(function2, functionDescriptor);
        }
        this.shadowedExtensionChecker.checkDeclaration(function2, functionDescriptor);
    }

    private final void checkExpectedFunction(KtNamedFunction function2, FunctionDescriptor functionDescriptor) {
        if (function2.hasBody()) {
            this.trace.report(Errors.EXPECTED_DECLARATION_WITH_BODY.on((KtDeclaration)((PsiElement)function2)));
        }
        this.checkPrivateExpectedDeclaration(function2, functionDescriptor);
    }

    private final void checkActualFunction(KtDeclaration element, FunctionDescriptor functionDescriptor) {
        if (!DescriptorUtilsKt.isAnnotationConstructor(functionDescriptor)) {
            for (ValueParameterDescriptor valueParameter : functionDescriptor.getValueParameters()) {
                if (!valueParameter.declaresDefaultValue()) continue;
                ValueParameterDescriptor valueParameterDescriptor = valueParameter;
                Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"valueParameter");
                PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(valueParameterDescriptor);
                if (psiElement == null) {
                    psiElement = element;
                }
                this.trace.report(Errors.ACTUAL_FUNCTION_WITH_DEFAULT_ARGUMENTS.on(psiElement));
            }
        }
    }

    private final void checkImplicitCallableType(KtCallableDeclaration declaration2, CallableDescriptor descriptor2) {
        block2: {
            PsiElement target;
            KotlinType it;
            block3: {
                KotlinType kotlinType = descriptor2.getReturnType();
                if (kotlinType == null || (kotlinType = kotlinType.unwrap()) == null) break block2;
                KotlinType kotlinType2 = kotlinType;
                boolean bl = false;
                boolean bl2 = false;
                it = kotlinType2;
                boolean bl3 = false;
                PsiElement psiElement = declaration2.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = declaration2;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"declaration.nameIdentifier ?: declaration");
                target = psiElement;
                if (declaration2.getTypeReference() != null) break block3;
                if (TypeUtilsKt.isNothing(it) && !declaration2.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                    this.trace.report((declaration2 instanceof KtProperty ? Errors.IMPLICIT_NOTHING_PROPERTY_TYPE : Errors.IMPLICIT_NOTHING_RETURN_TYPE).on(target));
                }
                if (!TypeUtilsKt.contains(it, (Function1<? super UnwrappedType, Boolean>)((Function1)checkImplicitCallableType.1.1.INSTANCE))) break block2;
                this.trace.report(Errors.IMPLICIT_INTERSECTION_TYPE.on(target, it));
                break block2;
            }
            if (!TypeUtilsKt.isNothing(it) || !(it instanceof AbbreviatedType)) break block2;
            this.trace.report((declaration2 instanceof KtProperty ? Errors.ABBREVIATED_NOTHING_PROPERTY_TYPE : Errors.ABBREVIATED_NOTHING_RETURN_TYPE).on(target));
        }
    }

    private final void checkAccessors(KtProperty property2, PropertyDescriptor propertyDescriptor) {
        for (PropertyAccessorDescriptor accessorDescriptor : propertyDescriptor.getAccessors()) {
            KtPropertyAccessor accessor;
            KtPropertyAccessor ktPropertyAccessor = accessor = accessorDescriptor instanceof PropertyGetterDescriptor ? property2.getGetter() : property2.getSetter();
            if (accessor != null) {
                this.modifiersChecker.checkModifiersForDeclaration(accessor, accessorDescriptor);
                this.identifierChecker.checkDeclaration(accessor, this.trace);
                continue;
            }
            this.modifiersChecker.runDeclarationCheckers(property2, accessorDescriptor);
        }
        this.checkAccessor(propertyDescriptor, property2.getGetter(), propertyDescriptor.getGetter());
        this.checkAccessor(propertyDescriptor, property2.getSetter(), propertyDescriptor.getSetter());
    }

    private final void reportVisibilityModifierDiagnostics(Collection<? extends PsiElement> tokens, DiagnosticFactory0<PsiElement> diagnostic) {
        for (PsiElement psiElement : tokens) {
            this.trace.report(diagnostic.on(psiElement));
        }
    }

    private final void checkAccessor(PropertyDescriptor propertyDescriptor, KtPropertyAccessor accessor, PropertyAccessorDescriptor accessorDescriptor) {
        if (accessor == null || accessorDescriptor == null) {
            return;
        }
        if (propertyDescriptor.isExpect() && accessor.hasBody()) {
            this.trace.report(Errors.EXPECTED_DECLARATION_WITH_BODY.on((KtDeclaration)((PsiElement)accessor)));
        }
        KtModifierList ktModifierList = accessor.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierList, (String)"accessor.modifierList ?: return");
        KtModifierList accessorModifierList = ktModifierList;
        Map<KtModifierKeywordToken, PsiElement> map2 = this.modifiersChecker.getTokensCorrespondingToModifiers(accessorModifierList, SetsKt.setOf((Object[])new KtModifierKeywordToken[]{KtTokens.PUBLIC_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.PRIVATE_KEYWORD, KtTokens.INTERNAL_KEYWORD}));
        Intrinsics.checkNotNullExpressionValue(map2, (String)"modifiersChecker.getToke\u2026TERNAL_KEYWORD)\n        )");
        Map<KtModifierKeywordToken, PsiElement> tokens = map2;
        if (accessor.isGetter()) {
            if (Intrinsics.areEqual((Object)accessorDescriptor.getVisibility(), (Object)propertyDescriptor.getVisibility()) ^ true) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.GETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"Errors.GETTER_VISIBILITY\u2026_FROM_PROPERTY_VISIBILITY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            } else {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.REDUNDANT_MODIFIER_IN_GETTER;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"Errors.REDUNDANT_MODIFIER_IN_GETTER");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        } else if (ModalityUtilsKt.isOverridable(propertyDescriptor) && Intrinsics.areEqual((Object)accessorDescriptor.getVisibility(), (Object)DescriptorVisibilities.PRIVATE) && Intrinsics.areEqual((Object)propertyDescriptor.getVisibility(), (Object)DescriptorVisibilities.PRIVATE) ^ true) {
            if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.PRIVATE_SETTER_FOR_ABSTRACT_PROPERTY;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"Errors.PRIVATE_SETTER_FOR_ABSTRACT_PROPERTY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            } else {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.PRIVATE_SETTER_FOR_OPEN_PROPERTY;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"Errors.PRIVATE_SETTER_FOR_OPEN_PROPERTY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        } else {
            Integer compare = DescriptorVisibilities.compare(accessorDescriptor.getVisibility(), propertyDescriptor.getVisibility());
            if (compare == null || compare > 0) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.SETTER_VISIBILITY_INCONSISTENT_WITH_PROPERTY_VISIBILITY;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"Errors.SETTER_VISIBILITY\u2026_WITH_PROPERTY_VISIBILITY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        }
    }

    private final void checkEnumEntry(KtEnumEntry enumEntry, ClassDescriptor enumEntryClass) {
        DeclarationDescriptor declarationDescriptor = enumEntryClass.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ClassDescriptor enumClass2 = (ClassDescriptor)declarationDescriptor;
        if (DescriptorUtils.isEnumClass(enumClass2)) {
            if (enumClass2.isExpect() && enumEntry.getBody() != null) {
                this.trace.report(Errors.EXPECTED_ENUM_ENTRY_WITH_BODY.on((KtEnumEntry)((PsiElement)enumEntry)));
            }
        } else {
            boolean bl = DescriptorUtils.isInterface(enumClass2);
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Enum entry should be declared in enum class: " + enumEntryClass;
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVarargParameters(BindingTrace trace, CallableDescriptor callableDescriptor) {
        void $this$filterTo$iv$iv;
        List<ValueParameterDescriptor> list2 = callableDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"callableDescriptor.valueParameters");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter2 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(it.getVarargElementType() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List varargParameters = (List)destination$iv$iv;
        if (varargParameters.size() > 1) {
            Iterator $i$f$filter2 = varargParameters.iterator();
            while ($i$f$filter2.hasNext()) {
                KtParameter parameterDeclaration;
                ValueParameterDescriptor parameter;
                ValueParameterDescriptor valueParameterDescriptor = parameter = (ValueParameterDescriptor)$i$f$filter2.next();
                Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"parameter");
                PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(valueParameterDescriptor);
                if (!(psiElement instanceof KtParameter)) {
                    psiElement = null;
                }
                if ((KtParameter)psiElement == null) {
                    continue;
                }
                trace.report(Errors.MULTIPLE_VARARG_PARAMETERS.on((KtParameter)((PsiElement)parameterDeclaration)));
            }
        }
        SimpleType simpleType2 = DescriptorUtilsKt.getBuiltIns(callableDescriptor).getNullableNothingType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"callableDescriptor.builtIns.nullableNothingType");
        SimpleType nullableNothing = simpleType2;
        for (ValueParameterDescriptor parameter : varargParameters) {
            KtParameter parameterDeclaration;
            KotlinType kotlinType = parameter.getVarargElementType();
            Intrinsics.checkNotNull((Object)kotlinType);
            SimpleType varargElementType = FlexibleTypesKt.upperIfFlexible(kotlinType);
            if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(varargElementType, nullableNothing) && (!InlineClassesUtilsKt.isInlineClassType(varargElementType) || UnsignedTypes.isUnsignedType(varargElementType) || KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType(varargElementType))) continue;
            ValueParameterDescriptor valueParameterDescriptor = parameter;
            Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"parameter");
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(valueParameterDescriptor);
            if (!(psiElement instanceof KtParameter)) {
                psiElement = null;
            }
            if ((KtParameter)psiElement == null) {
                continue;
            }
            trace.report(Errors.FORBIDDEN_VARARG_PARAMETER_TYPE.on((KtParameter)((PsiElement)parameterDeclaration), varargElementType));
        }
    }

    public DeclarationsChecker(@NotNull DescriptorResolver descriptorResolver, @NotNull ModifiersChecker modifiersChecker, @NotNull AnnotationChecker annotationChecker, @NotNull IdentifierChecker identifierChecker, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull TypeSpecificityComparator typeSpecificityComparator, @NotNull PlatformDiagnosticSuppressor diagnosticSuppressor) {
        Intrinsics.checkNotNullParameter((Object)descriptorResolver, (String)"descriptorResolver");
        Intrinsics.checkNotNullParameter((Object)modifiersChecker, (String)"modifiersChecker");
        Intrinsics.checkNotNullParameter((Object)annotationChecker, (String)"annotationChecker");
        Intrinsics.checkNotNullParameter((Object)identifierChecker, (String)"identifierChecker");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)typeSpecificityComparator, (String)"typeSpecificityComparator");
        Intrinsics.checkNotNullParameter((Object)diagnosticSuppressor, (String)"diagnosticSuppressor");
        this.descriptorResolver = descriptorResolver;
        this.annotationChecker = annotationChecker;
        this.identifierChecker = identifierChecker;
        this.trace = trace;
        this.languageVersionSettings = languageVersionSettings;
        this.diagnosticSuppressor = diagnosticSuppressor;
        ModifiersChecker.ModifiersCheckingProcedure modifiersCheckingProcedure = modifiersChecker.withTrace(this.trace);
        Intrinsics.checkNotNullExpressionValue((Object)modifiersCheckingProcedure, (String)"modifiersChecker.withTrace(trace)");
        this.modifiersChecker = modifiersCheckingProcedure;
        this.exposedChecker = new ExposedVisibilityChecker(this.trace);
        this.shadowedExtensionChecker = new ShadowedExtensionChecker(typeSpecificityComparator, this.trace);
    }

    static {
        Companion = new Companion(null);
        METHOD_OF_ANY_NAMES = ImmutableSet.of("toString", "hashCode", "equals");
    }

    public static final /* synthetic */ BindingTrace access$getTrace$p(DeclarationsChecker $this) {
        return $this.trace;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker$TypeAliasDeclarationCheckingReportStrategy;", "Lorg/jetbrains/kotlin/types/TypeAliasExpansionReportStrategy;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;Lorg/jetbrains/kotlin/psi/KtTypeAlias;)V", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "boundsViolationInSubstitution", "", "bound", "Lorg/jetbrains/kotlin/types/KotlinType;", "unsubstitutedArgument", "argument", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "conflictingProjection", "typeAlias", "substitutedArgument", "recursiveTypeAlias", "repeatedAnnotation", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "wrongNumberOfTypeArguments", "numberOfParameters", "", "frontend"})
    private static final class TypeAliasDeclarationCheckingReportStrategy
    implements TypeAliasExpansionReportStrategy {
        private final KtTypeReference typeReference;
        private final BindingTrace trace;

        @Override
        public void wrongNumberOfTypeArguments(@NotNull TypeAliasDescriptor typeAlias, int numberOfParameters) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        }

        @Override
        public void conflictingProjection(@NotNull TypeAliasDescriptor typeAlias, @Nullable TypeParameterDescriptor typeParameter, @NotNull KotlinType substitutedArgument) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            Intrinsics.checkNotNullParameter((Object)substitutedArgument, (String)"substitutedArgument");
            this.trace.report(Errors.CONFLICTING_PROJECTION_IN_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.typeReference), substitutedArgument));
        }

        @Override
        public void recursiveTypeAlias(@NotNull TypeAliasDescriptor typeAlias) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            this.trace.report(Errors.RECURSIVE_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.typeReference), typeAlias));
        }

        @Override
        public void boundsViolationInSubstitution(@NotNull KotlinType bound, @NotNull KotlinType unsubstitutedArgument, @NotNull KotlinType argument, @NotNull TypeParameterDescriptor typeParameter) {
            Intrinsics.checkNotNullParameter((Object)bound, (String)"bound");
            Intrinsics.checkNotNullParameter((Object)unsubstitutedArgument, (String)"unsubstitutedArgument");
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
            if (!TypeUtilsKt.containsTypeAliasParameters(argument) && !TypeUtilsKt.containsTypeAliasParameters(bound)) {
                this.trace.report(Errors.UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.typeReference), bound, argument, typeParameter));
            }
        }

        @Override
        public void repeatedAnnotation(@NotNull AnnotationDescriptor annotation2) {
            Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
            SourceElement sourceElement = annotation2.getSource();
            if (!(sourceElement instanceof KotlinSourceElement)) {
                sourceElement = null;
            }
            KotlinSourceElement kotlinSourceElement = (KotlinSourceElement)sourceElement;
            KtElement ktElement = kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null;
            if (!(ktElement instanceof KtAnnotationEntry)) {
                ktElement = null;
            }
            KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)ktElement;
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry = ktAnnotationEntry;
            this.trace.report(Errors.REPEATED_ANNOTATION.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
        }

        public TypeAliasDeclarationCheckingReportStrategy(@NotNull BindingTrace trace, @NotNull TypeAliasDescriptor typeAliasDescriptor, @NotNull KtTypeAlias declaration2) {
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)typeAliasDescriptor, (String)"typeAliasDescriptor");
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            this.trace = trace;
            KtTypeReference ktTypeReference = declaration2.getTypeReference();
            if (ktTypeReference == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Incorrect type alias declaration for " + typeAliasDescriptor)));
            }
            this.typeReference = ktTypeReference;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0014H\u0002J\n\u0010\u001a\u001a\u00020\b*\u00020\u001bR2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker$Companion;", "", "()V", "METHOD_OF_ANY_NAMES", "Lcom/google/common/collect/ImmutableSet;", "", "kotlin.jvm.PlatformType", "hasConstraints", "", "typeParameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "constraints", "", "Lorg/jetbrains/kotlin/psi/KtTypeConstraint;", "isHidingParentMemberIfPresent", "member", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isImplementingMethodOfAny", "isImplementingMethodOfAnyInternal", "visitedClasses", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "removeDuplicateTypes", "", "conflictingTypes", "Lorg/jetbrains/kotlin/types/KotlinType;", "hasAccessorImplementation", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "frontend"})
    public static final class Companion {
        private final void removeDuplicateTypes(Set<KotlinType> conflictingTypes) {
            Iterator<KotlinType> iterator2 = conflictingTypes.iterator();
            block0: while (iterator2.hasNext()) {
                KotlinType type2 = iterator2.next();
                for (KotlinType otherType : conflictingTypes) {
                    boolean subtypeOf = KotlinTypeChecker.DEFAULT.equalTypes(type2, otherType);
                    if (type2 == otherType || !subtypeOf) continue;
                    iterator2.remove();
                    continue block0;
                }
            }
        }

        private final boolean hasConstraints(KtTypeParameter typeParameter, List<? extends KtTypeConstraint> constraints) {
            boolean bl;
            block4: {
                if (typeParameter.getName() == null) {
                    return false;
                }
                Iterable $this$any$iv = constraints;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtTypeConstraint it = (KtTypeConstraint)element$iv;
                        boolean bl2 = false;
                        KtSimpleNameExpression ktSimpleNameExpression = it.getSubjectTypeParameterName();
                        if (!Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null), (Object)typeParameter.getName())) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean isImplementingMethodOfAny(CallableMemberDescriptor member) {
            if (!METHOD_OF_ANY_NAMES.contains(member.getName().asString())) {
                return false;
            }
            if (member.getModality() == Modality.ABSTRACT) {
                return false;
            }
            return this.isImplementingMethodOfAnyInternal(member, new HashSet());
        }

        private final boolean isImplementingMethodOfAnyInternal(CallableMemberDescriptor member, Set<ClassDescriptor> visitedClasses) {
            Iterator<? extends CallableMemberDescriptor> iterator2 = member.getOverriddenDescriptors().iterator();
            while (iterator2.hasNext()) {
                DeclarationDescriptor containingDeclaration;
                CallableMemberDescriptor overridden;
                CallableMemberDescriptor callableMemberDescriptor = overridden = iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor, (String)"overridden");
                Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor.getContainingDeclaration(), (String)"overridden.containingDeclaration");
                if (!(containingDeclaration instanceof ClassDescriptor) || visitedClasses.contains(containingDeclaration)) continue;
                if (Intrinsics.areEqual((Object)DescriptorUtils.getFqName(containingDeclaration), (Object)StandardNames.FqNames.any)) {
                    return true;
                }
                if (this.isHidingParentMemberIfPresent(overridden)) continue;
                visitedClasses.add((ClassDescriptor)containingDeclaration);
                if (!this.isImplementingMethodOfAnyInternal(overridden, visitedClasses)) continue;
                return true;
            }
            return false;
        }

        private final boolean isHidingParentMemberIfPresent(CallableMemberDescriptor member) {
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(member);
            if (!(psiElement instanceof KtNamedDeclaration)) {
                psiElement = null;
            }
            KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)psiElement;
            if (ktNamedDeclaration == null) {
                return false;
            }
            KtNamedDeclaration declaration2 = ktNamedDeclaration;
            KtModifierList ktModifierList = declaration2.getModifierList();
            if (ktModifierList == null) {
                return true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierList, (String)"declaration.modifierList ?: return true");
            KtModifierList modifierList2 = ktModifierList;
            return !modifierList2.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        }

        public final boolean hasAccessorImplementation(@NotNull PropertyDescriptor $this$hasAccessorImplementation) {
            PropertyGetterDescriptor it;
            boolean bl;
            boolean bl2;
            PropertyAccessorDescriptor propertyAccessorDescriptor;
            Intrinsics.checkNotNullParameter((Object)$this$hasAccessorImplementation, (String)"$this$hasAccessorImplementation");
            PropertyGetterDescriptor propertyGetterDescriptor = $this$hasAccessorImplementation.getGetter();
            if (propertyGetterDescriptor != null) {
                propertyAccessorDescriptor = propertyGetterDescriptor;
                bl2 = false;
                bl = false;
                it = propertyAccessorDescriptor;
                boolean bl3 = false;
                PropertyGetterDescriptor propertyGetterDescriptor2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)propertyGetterDescriptor2, (String)"it");
                if (DescriptorPsiUtilsKt.hasBody(propertyGetterDescriptor2)) {
                    return true;
                }
            }
            PropertySetterDescriptor propertySetterDescriptor = $this$hasAccessorImplementation.getSetter();
            if (propertySetterDescriptor != null) {
                propertyAccessorDescriptor = propertySetterDescriptor;
                bl2 = false;
                bl = false;
                it = propertyAccessorDescriptor;
                boolean bl4 = false;
                PropertyGetterDescriptor propertyGetterDescriptor3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)propertyGetterDescriptor3, (String)"it");
                if (DescriptorPsiUtilsKt.hasBody(propertyGetterDescriptor3)) {
                    return true;
                }
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

