/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a8\u0006\u0005"}, d2={"computeUnderlyingType", "Lorg/jetbrains/kotlin/types/KotlinType;", "inlineClassType", "shouldUseUnderlyingType", "", "descriptors.jvm"})
public final class InlineClassMappingKt {
    @Nullable
    public static final KotlinType computeUnderlyingType(@NotNull KotlinType inlineClassType) {
        Intrinsics.checkNotNullParameter((Object)inlineClassType, (String)"inlineClassType");
        if (!InlineClassMappingKt.shouldUseUnderlyingType(inlineClassType)) {
            return null;
        }
        Object object = InlineClassesUtilsKt.unsubstitutedUnderlyingType(inlineClassType);
        if (object == null || (object = ((KotlinType)object).getConstructor()) == null || (object = object.getDeclarationDescriptor()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inlineClassType.unsubsti\u2026Descriptor ?: return null");
        Object descriptor2 = object;
        return descriptor2 instanceof TypeParameterDescriptor ? TypeUtilsKt.getRepresentativeUpperBound((TypeParameterDescriptor)descriptor2) : InlineClassesUtilsKt.substitutedUnderlyingType(inlineClassType);
    }

    public static final boolean shouldUseUnderlyingType(@NotNull KotlinType inlineClassType) {
        Intrinsics.checkNotNullParameter((Object)inlineClassType, (String)"inlineClassType");
        KotlinType kotlinType = InlineClassesUtilsKt.unsubstitutedUnderlyingType(inlineClassType);
        if (kotlinType == null) {
            return false;
        }
        KotlinType underlyingType = kotlinType;
        return !inlineClassType.isMarkedNullable() || !TypeUtils.isNullableType(underlyingType) && !KotlinBuiltIns.isPrimitiveType(underlyingType);
    }
}

