/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.components;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.FilePreprocessorExtension;
import org.jetbrains.kotlin.resolve.FilePreprocessorKt;
import org.jetbrains.kotlin.util.slicedMap.BasicWritableSlice;
import org.jetbrains.kotlin.util.slicedMap.Slices;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/load/java/components/FilesByFacadeFqNameIndexer;", "Lorg/jetbrains/kotlin/resolve/FilePreprocessorExtension;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "preprocessFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "frontend.java"})
public final class FilesByFacadeFqNameIndexer
implements FilePreprocessorExtension {
    private final BindingTrace trace;
    @JvmField
    @NotNull
    public static final WritableSlice<FqName, Collection<KtFile>> FACADE_FILES_BY_FQ_NAME;
    @JvmField
    @NotNull
    public static final WritableSlice<FqName, Collection<KtFile>> FACADE_FILES_BY_PACKAGE_NAME;
    @NotNull
    public static final Companion Companion;

    @Override
    public void preprocessFile(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!file2.hasTopLevelCallables()) {
            return;
        }
        FilePreprocessorKt.addElementToSlice(this.trace, FACADE_FILES_BY_FQ_NAME, JvmFileClassUtilKt.getJavaFileFacadeFqName(file2), file2);
        FqName fqName2 = JvmFileClassUtilKt.getJavaFileFacadeFqName(file2).parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"file.javaFileFacadeFqName.parent()");
        FilePreprocessorKt.addElementToSlice(this.trace, FACADE_FILES_BY_PACKAGE_NAME, fqName2, file2);
    }

    public FilesByFacadeFqNameIndexer(@NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        this.trace = trace;
    }

    static {
        Companion = new Companion(null);
        WritableSlice writableSlice = Slices.createSimpleSlice();
        Intrinsics.checkNotNullExpressionValue(writableSlice, (String)"Slices.createSimpleSlice()");
        FACADE_FILES_BY_FQ_NAME = writableSlice;
        WritableSlice writableSlice2 = Slices.createSimpleSlice();
        Intrinsics.checkNotNullExpressionValue(writableSlice2, (String)"Slices.createSimpleSlice()");
        FACADE_FILES_BY_PACKAGE_NAME = writableSlice2;
        BasicWritableSlice.initSliceDebugNames(FilesByFacadeFqNameIndexer.class);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/load/java/components/FilesByFacadeFqNameIndexer$Companion;", "", "()V", "FACADE_FILES_BY_FQ_NAME", "Lorg/jetbrains/kotlin/util/slicedMap/WritableSlice;", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "FACADE_FILES_BY_PACKAGE_NAME", "frontend.java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

