/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.CallableReferenceTranslator;
import org.jetbrains.kotlin.js.translate.reference.CallableReferenceTranslator$isSetterVisible$;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.DelegatingResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rJ*\u0010\u0011\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002J*\u0010\u0013\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002Jr\u0010\u0014\u001a\u00020\u00042\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u00162\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\t2.\u0010\u0019\u001a*\u0012\u0004\u0012\u00020\r\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00040\u001aH\u0002J&\u0010\u001b\u001a\u00020\u0004*\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J8\u0010\u001e\u001a\u00020\u0004*\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallableReferenceTranslator;", "", "()V", "bindIfNecessary", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "receiver", "isSetterVisible", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "translate", "expression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "translateForFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "translateForProperty", "translateForPropertyAccessor", "call", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isSetter", "translator", "Lkotlin/Function4;", "wrapFunctionCallableRef", "name", "", "wrapPropertyCallableRef", "getter", "setter", "js.translator"})
public final class CallableReferenceTranslator {
    @NotNull
    public static final CallableReferenceTranslator INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final JsExpression translate(@NotNull KtCallableReferenceExpression expression2, @NotNull TranslationContext context2) {
        JsExpression jsExpression;
        CallableDescriptor callableDescriptor;
        JsExpression receiver;
        JsExpression jsExpression2;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KtSimpleNameExpression ktSimpleNameExpression = expression2.getCallableReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"expression.callableReference");
        KtElement ktElement = ktSimpleNameExpression;
        BindingContext bindingContext = context2.bindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.bindingContext()");
        ResolvedCall<? extends CallableDescriptor> referencedFunction = CallUtilKt.getResolvedCallWithAssert(ktElement, bindingContext);
        CallableDescriptor descriptor2 = referencedFunction.getResultingDescriptor();
        ReceiverValue extensionReceiver = referencedFunction.getExtensionReceiver();
        ReceiverValue dispatchReceiver = referencedFunction.getDispatchReceiver();
        boolean bl = dispatchReceiver == null || extensionReceiver == null;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Cannot generate reference with both receivers: " + descriptor2;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        ReceiverValue receiverValue = dispatchReceiver;
        if (receiverValue == null) {
            receiverValue = extensionReceiver;
        }
        if (receiverValue != null) {
            ReceiverValue receiverValue2 = receiverValue;
            boolean bl4 = false;
            boolean bl5 = false;
            ReceiverValue it = receiverValue2;
            boolean bl6 = false;
            ReceiverValue receiverValue3 = it;
            if (receiverValue3 instanceof TransientReceiver) {
                jsExpression2 = null;
            } else if (receiverValue3 instanceof ImplicitClassReceiver || receiverValue3 instanceof ExtensionReceiver) {
                jsExpression2 = context2.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForReceiver(it));
            } else {
                if (!(receiverValue3 instanceof ExpressionReceiver)) throw (Throwable)new UnsupportedOperationException("Unsupported receiver value: " + it);
                jsExpression2 = Translation.translateAsExpression(((ExpressionReceiver)it).getExpression(), context2);
            }
        } else {
            jsExpression2 = receiver = null;
        }
        if ((callableDescriptor = descriptor2) instanceof PropertyDescriptor) {
            jsExpression = this.translateForProperty((PropertyDescriptor)descriptor2, context2, expression2, receiver);
            return jsExpression;
        } else {
            if (!(callableDescriptor instanceof FunctionDescriptor)) throw (Throwable)new IllegalArgumentException("Expected property or function: " + descriptor2 + ", expression=" + expression2.getText());
            jsExpression = this.translateForFunction((FunctionDescriptor)descriptor2, context2, expression2, receiver);
        }
        return jsExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final JsExpression translateForFunction(FunctionDescriptor descriptor2, TranslationContext context2, KtCallableReferenceExpression expression2, JsExpression receiver) {
        JsNameRef jsNameRef;
        KtSimpleNameExpression ktSimpleNameExpression = expression2.getCallableReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"expression.callableReference");
        KtExpression ktExpression = ktSimpleNameExpression;
        BindingContext bindingContext = context2.bindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.bindingContext()");
        ResolvedCall<? extends FunctionDescriptor> realResolvedCall = CallUtilKt.getFunctionResolvedCallWithAssert(ktExpression, bindingContext);
        Object v = context2.bindingContext().get(BindingContext.FUNCTION, expression2);
        Intrinsics.checkNotNull(v);
        Intrinsics.checkNotNullExpressionValue(v, (String)"context.bindingContext()\u2026t.FUNCTION, expression)!!");
        SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)v;
        int receivers = receiver == null && (descriptor2.getDispatchReceiverParameter() != null || descriptor2.getExtensionReceiverParameter() != null) ? 1 : 0;
        int fakeArgCount = functionDescriptor.getValueParameters().size() - receivers;
        Project project = expression2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"expression.project");
        KtCallExpression fakeExpression = CodegenUtil.constructFakeFunctionCall(project, fakeArgCount);
        List<KtValueArgument> list2 = fakeExpression.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"fakeExpression.valueArguments");
        List<KtValueArgument> fakeArguments = list2;
        Call call2 = CallMaker.makeCall(fakeExpression, null, null, fakeExpression, fakeArguments);
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"CallMaker.makeCall(fakeE\u2026xpression, fakeArguments)");
        Call fakeCall = call2;
        DelegatingResolvedCall<FunctionDescriptor> fakeResolvedCall2 = new DelegatingResolvedCall<FunctionDescriptor>(fakeCall, receiver, descriptor2, fakeArgCount, functionDescriptor, receivers, fakeArguments, realResolvedCall, realResolvedCall){
            @NotNull
            private final Map<ValueParameterDescriptor, ResolvedValueArgument> valueArgumentMap;
            @NotNull
            private final List<ResolvedValueArgument> valueArgumentList;
            final /* synthetic */ Call $fakeCall;
            final /* synthetic */ JsExpression $receiver;
            final /* synthetic */ FunctionDescriptor $descriptor;
            final /* synthetic */ int $fakeArgCount;
            final /* synthetic */ SimpleFunctionDescriptor $functionDescriptor;
            final /* synthetic */ int $receivers;
            final /* synthetic */ List $fakeArguments;
            final /* synthetic */ ResolvedCall $realResolvedCall;

            @NotNull
            public final Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArgumentMap() {
                return this.valueArgumentMap;
            }

            @NotNull
            public final List<ResolvedValueArgument> getValueArgumentList() {
                return this.valueArgumentList;
            }

            @NotNull
            public Call getCall() {
                return this.$fakeCall;
            }

            @NotNull
            public List<ResolvedValueArgument> getValueArgumentsByIndex() {
                return this.valueArgumentList;
            }

            @NotNull
            public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
                return this.valueArgumentMap;
            }

            @NotNull
            public ExplicitReceiverKind getExplicitReceiverKind() {
                if (this.$receiver != null) {
                    return DescriptorUtilsKt.isExtension(this.$descriptor) ? ExplicitReceiverKind.EXTENSION_RECEIVER : ExplicitReceiverKind.DISPATCH_RECEIVER;
                }
                ExplicitReceiverKind explicitReceiverKind = super.getExplicitReceiverKind();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)explicitReceiverKind), (String)"super.getExplicitReceiverKind()");
                return explicitReceiverKind;
            }
            {
                this.$fakeCall = $captured_local_variable$0;
                this.$receiver = $captured_local_variable$1;
                this.$descriptor = $captured_local_variable$2;
                this.$fakeArgCount = $captured_local_variable$3;
                this.$functionDescriptor = $captured_local_variable$4;
                this.$receivers = $captured_local_variable$5;
                this.$fakeArguments = $captured_local_variable$6;
                this.$realResolvedCall = $captured_local_variable$7;
                super($super_call_param$8);
                boolean bl = false;
                Map map2 = new LinkedHashMap<K, V>();
                boolean bl2 = false;
                boolean bl3 = false;
                Map map3 = map2;
                translateForFunction.fakeResolvedCall.1 var21_15 = this;
                boolean bl4 = false;
                int i = 0;
                for (ValueParameterDescriptor parameter : this.$descriptor.getValueParameters()) {
                    void argumentMap;
                    if (parameter.getVarargElementType() != null) {
                        if (i == this.$fakeArgCount) {
                            ValueParameterDescriptor valueParameterDescriptor = parameter;
                            Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"parameter");
                            ResolvedValueArgument resolvedValueArgument = ArgumentsUtilsKt.hasDefaultValue(parameter) ? (ResolvedValueArgument)DefaultValueArgument.DEFAULT : (ResolvedValueArgument)new VarargValueArgument();
                            Intrinsics.checkNotNullExpressionValue((Object)resolvedValueArgument, (String)"if (parameter.hasDefault\u2026lse VarargValueArgument()");
                            argumentMap.put(valueParameterDescriptor, resolvedValueArgument);
                            continue;
                        }
                        ValueParameterDescriptor valueParameterDescriptor = this.$functionDescriptor.getValueParameters().get(this.$receivers + i);
                        Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"functionDescriptor.valueParameters[receivers + i]");
                        if (Intrinsics.areEqual((Object)valueParameterDescriptor.getType(), (Object)parameter.getVarargElementType())) {
                            ValueParameterDescriptor valueParameterDescriptor2 = parameter;
                            Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor2, (String)"parameter");
                            argumentMap.put(valueParameterDescriptor2, new VarargValueArgument(this.$fakeArguments.subList(i, this.$fakeArgCount)));
                            i = this.$fakeArgCount;
                            continue;
                        }
                    }
                    if (i < this.$fakeArgCount) {
                        ValueParameterDescriptor valueParameterDescriptor = parameter;
                        Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"parameter");
                        argumentMap.put(valueParameterDescriptor, new ExpressionValueArgument((ValueArgument)this.$fakeArguments.get(i++)));
                        continue;
                    }
                    ValueParameterDescriptor valueParameterDescriptor = parameter;
                    Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"parameter");
                    boolean bl5 = ArgumentsUtilsKt.hasDefaultValue(valueParameterDescriptor);
                    boolean bl6 = false;
                    if (_Assertions.ENABLED && !bl5) {
                        boolean bl7 = false;
                        String string2 = "Parameter should be either vararg or expression or default: " + parameter + " (reference in: " + this.$functionDescriptor.getContainingDeclaration() + ")";
                        throw (Throwable)((Object)new AssertionError((Object)string2));
                    }
                    DefaultValueArgument defaultValueArgument = DefaultValueArgument.DEFAULT;
                    Intrinsics.checkNotNullExpressionValue((Object)defaultValueArgument, (String)"DefaultValueArgument.DEFAULT");
                    argumentMap.put(parameter, defaultValueArgument);
                }
                Unit unit = Unit.INSTANCE;
                var21_15.valueArgumentMap = map2;
                this.valueArgumentList = CollectionsKt.toList((Iterable)this.valueArgumentMap.values());
            }
        };
        JsFunction function2 = new JsFunction(context2.scope(), new JsBlock(), "");
        function2.setSource(expression2);
        if (descriptor2.getDispatchReceiverParameter() != null || descriptor2.getExtensionReceiverParameter() != null || receiver != null) {
            JsName jsName = JsScope.declareTemporaryName(Namer.getReceiverParameterName());
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"JsScope.declareTemporary\u2026tReceiverParameterName())");
            JsName paramName = jsName;
            Collection collection = function2.getParameters();
            JsParameter jsParameter = new JsParameter(paramName);
            boolean bl = false;
            collection.add(jsParameter);
            jsNameRef = paramName.makeRef();
        } else {
            jsNameRef = null;
        }
        JsNameRef receiverParam = jsNameRef;
        boolean bl = false;
        Map aliases = new LinkedHashMap();
        bl = false;
        List<? extends ValueArgument> list3 = fakeCall.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"fakeCall.valueArguments");
        for (Object valueArg : (Iterable)list3) {
            JsNameRef paramRef;
            JsName paramName;
            void index2;
            ValueParameterDescriptor valueParameterDescriptor = functionDescriptor.getValueParameters().get((int)index2);
            Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"functionDescriptor.valueParameters[index]");
            Intrinsics.checkNotNullExpressionValue((Object)JsScope.declareTemporaryName(valueParameterDescriptor.getName().asString()), (String)"JsScope.declareTemporary\u2026s[index].name.asString())");
            Collection collection = function2.getParameters();
            JsParameter jsParameter = new JsParameter(paramName);
            boolean bl2 = false;
            collection.add(jsParameter);
            Intrinsics.checkNotNullExpressionValue((Object)paramName.makeRef(), (String)"paramName.makeRef()");
            MetadataProperties.setType(paramRef, context2.getCurrentModule().getBuiltIns().getAnyType());
            KtExpression ktExpression2 = valueArg.getArgumentExpression();
            Intrinsics.checkNotNull((Object)ktExpression2);
            aliases.put(ktExpression2, paramRef);
            ++index2;
        }
        TranslationContext translationContext = context2.innerBlock(function2.getBody()).innerContextWithAliasesForExpressions(aliases).inner(descriptor2);
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context.innerBlock(funct\u2026liases).inner(descriptor)");
        TranslationContext functionContext = translationContext;
        ValueParameterDescriptor valueParameterDescriptor = functionContext.getContinuationParameterDescriptor();
        if (valueParameterDescriptor != null) {
            Object valueArg;
            valueArg = valueParameterDescriptor;
            boolean bl3 = false;
            boolean bl4 = false;
            Object continuationDescriptor = valueArg;
            boolean bl5 = false;
            Collection collection = function2.getParameters();
            JsParameter jsParameter = new JsParameter(context2.getNameForDescriptor((DeclarationDescriptor)continuationDescriptor));
            boolean bl6 = false;
            collection.add(jsParameter);
            TranslationContext translationContext2 = functionContext.innerContextWithDescriptorsAliased(MapsKt.mapOf((Pair)TuplesKt.to((Object)continuationDescriptor, (Object)JsAstUtils.stateMachineReceiver())));
            Intrinsics.checkNotNullExpressionValue((Object)translationContext2, (String)"functionContext.innerCon\u2026.stateMachineReceiver()))");
            functionContext = translationContext2;
        }
        if (descriptor2.isSuspend()) {
            UtilsKt.fillCoroutineMetadata(function2, functionContext, functionDescriptor, false);
        }
        JsExpression invocation = CallTranslator.translate(functionContext, (ResolvedCall<? extends FunctionDescriptor>)fakeResolvedCall2, receiverParam);
        JsBlock jsBlock = function2.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"function.body");
        Collection collection = jsBlock.getStatements();
        JsReturn jsReturn = new JsReturn(TranslationUtils.coerce(context2, invocation, context2.getCurrentModule().getBuiltIns().getAnyType()));
        boolean bl7 = false;
        collection.add(jsReturn);
        JsExpression rawCallableRef = this.bindIfNecessary(function2, receiver);
        return this.wrapFunctionCallableRef(context2, receiver, expression2.getCallableReference().getReferencedName(), rawCallableRef);
    }

    private final JsExpression translateForProperty(PropertyDescriptor descriptor2, TranslationContext context2, KtCallableReferenceExpression expression2, JsExpression receiver) {
        KtSimpleNameExpression ktSimpleNameExpression = expression2.getCallableReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"expression.callableReference");
        KtExpression ktExpression = ktSimpleNameExpression;
        BindingContext bindingContext = context2.bindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.bindingContext()");
        ResolvedCall<? extends PropertyDescriptor> realCall = CallUtilKt.getPropertyResolvedCallWithAssert(ktExpression, bindingContext);
        DelegatingResolvedCall<PropertyDescriptor> call2 = new DelegatingResolvedCall<PropertyDescriptor>(receiver, descriptor2, realCall, realCall){
            final /* synthetic */ JsExpression $receiver;
            final /* synthetic */ PropertyDescriptor $descriptor;
            final /* synthetic */ ResolvedCall $realCall;

            @NotNull
            public ExplicitReceiverKind getExplicitReceiverKind() {
                if (this.$receiver != null) {
                    return DescriptorUtilsKt.isExtension(this.$descriptor) ? ExplicitReceiverKind.EXTENSION_RECEIVER : ExplicitReceiverKind.DISPATCH_RECEIVER;
                }
                ExplicitReceiverKind explicitReceiverKind = super.getExplicitReceiverKind();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)explicitReceiverKind), (String)"super.getExplicitReceiverKind()");
                return explicitReceiverKind;
            }
            {
                this.$receiver = $captured_local_variable$0;
                this.$descriptor = $captured_local_variable$1;
                this.$realCall = $captured_local_variable$2;
                super($super_call_param$3);
            }
        };
        JsExpression getter2 = this.translateForPropertyAccessor((ResolvedCall<? extends PropertyDescriptor>)call2, expression2, descriptor2, context2, receiver, false, (Function4<? super TranslationContext, ? super ResolvedCall<? extends PropertyDescriptor>, ? super JsExpression, ? super JsExpression, ? extends JsExpression>)((Function4)translateForProperty.getter.1.INSTANCE));
        JsExpression setter2 = this.isSetterVisible(descriptor2, context2) ? this.translateForPropertyAccessor((ResolvedCall<? extends PropertyDescriptor>)call2, expression2, descriptor2, context2, receiver, true, (Function4<? super TranslationContext, ? super ResolvedCall<? extends PropertyDescriptor>, ? super JsExpression, ? super JsExpression, ? extends JsExpression>)((Function4)new Function4<TranslationContext, ResolvedCall<? extends VariableDescriptor>, JsExpression, JsExpression, JsExpression>(CallTranslator.INSTANCE){

            @NotNull
            public final JsExpression invoke(@NotNull TranslationContext p1, @NotNull ResolvedCall<? extends VariableDescriptor> p2, @NotNull JsExpression p3, @Nullable JsExpression p4) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter(p2, (String)"p2");
                Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
                return ((CallTranslator)this.receiver).translateSet(p1, p2, p3, p4);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(CallTranslator.class);
            }

            public final String getName() {
                return "translateSet";
            }

            public final String getSignature() {
                return "translateSet(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;";
            }
        })) : null;
        return this.wrapPropertyCallableRef(context2, receiver, descriptor2, expression2.getCallableReference().getReferencedName(), getter2, setter2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSetterVisible(PropertyDescriptor descriptor2, TranslationContext context2) {
        void $this$filterIsInstance$iv;
        PropertySetterDescriptor propertySetterDescriptor = descriptor2.getSetter();
        if (propertySetterDescriptor == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)propertySetterDescriptor, (String)"descriptor.setter ?: return false");
        PropertySetterDescriptor setter2 = propertySetterDescriptor;
        if (Intrinsics.areEqual((Object)setter2.getVisibility(), (Object)DescriptorVisibilities.PRIVATE) ^ true) {
            return true;
        }
        ClassDescriptor classDescriptor2 = context2.getClassDescriptor();
        if (classDescriptor2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"context.classDescriptor ?: return false");
        ClassDescriptor classDescriptor3 = classDescriptor2;
        Sequence sequence2 = SequencesKt.generateSequence((Object)classDescriptor3, (Function1)isSetterVisible.outerClasses.1.INSTANCE);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence3 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)isSetterVisible$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        Sequence outerClasses2 = sequence3;
        return SequencesKt.contains((Sequence)outerClasses2, (Object)descriptor2.getContainingDeclaration());
    }

    private final JsExpression translateForPropertyAccessor(ResolvedCall<? extends PropertyDescriptor> call2, KtExpression expression2, PropertyDescriptor descriptor2, TranslationContext context2, JsExpression receiver, boolean isSetter, Function4<? super TranslationContext, ? super ResolvedCall<? extends PropertyDescriptor>, ? super JsExpression, ? super JsExpression, ? extends JsExpression> translator) {
        JsExpression jsExpression;
        boolean bl;
        JsNameRef receiverParam;
        JsNameRef jsNameRef;
        Object object;
        JsFunction accessorFunction = new JsFunction(context2.scope(), new JsBlock(), "");
        accessorFunction.setSource(expression2);
        TranslationContext translationContext = context2.innerBlock(accessorFunction.getBody());
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context.innerBlock(accessorFunction.body)");
        TranslationContext accessorContext = translationContext;
        if (descriptor2.getDispatchReceiverParameter() != null || descriptor2.getExtensionReceiverParameter() != null) {
            JsName jsName = JsScope.declareTemporaryName(Namer.getReceiverParameterName());
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"JsScope.declareTemporary\u2026tReceiverParameterName())");
            JsName name = jsName;
            Collection collection = accessorFunction.getParameters();
            object = new JsParameter(name);
            boolean bl2 = false;
            collection.add(object);
            jsNameRef = name.makeRef();
        } else {
            jsNameRef = receiverParam = null;
        }
        if (isSetter) {
            JsName jsName = JsScope.declareTemporaryName("value");
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"JsScope.declareTemporaryName(\"value\")");
            JsName name = jsName;
            object = accessorFunction.getParameters();
            JsParameter jsParameter = new JsParameter(name);
            bl = false;
            object.add(jsParameter);
            JsNameRef jsNameRef2 = name.makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef2, (String)"name.makeRef()");
            jsExpression = jsNameRef2;
        } else {
            jsExpression = new JsNullLiteral();
        }
        JsExpression valueParam = jsExpression;
        JsExpression accessorResult = (JsExpression)translator.invoke((Object)accessorContext, call2, (Object)valueParam, receiverParam);
        JsBlock jsBlock = accessorFunction.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"accessorFunction.body");
        object = jsBlock.getStatements();
        JsStatement jsStatement = isSetter ? accessorResult.makeStmt() : (JsStatement)new JsReturn(accessorResult);
        bl = false;
        object.add(jsStatement);
        JsBlock jsBlock2 = accessorFunction.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock2, (String)"accessorFunction.body");
        PsiElement psiElement = UtilsKt.getFinalElement(expression2);
        if (!(psiElement instanceof LeafPsiElement)) {
            psiElement = null;
        }
        jsBlock2.setSource((LeafPsiElement)psiElement);
        return this.bindIfNecessary(accessorFunction, receiver);
    }

    private final JsExpression bindIfNecessary(JsFunction function2, JsExpression receiver) {
        return receiver != null ? (JsExpression)new JsInvocation((JsExpression)new JsNameRef("bind", (JsExpression)function2), new JsNullLiteral(), receiver) : (JsExpression)function2;
    }

    private final JsExpression wrapPropertyCallableRef(TranslationContext $this$wrapPropertyCallableRef, JsExpression receiver, PropertyDescriptor descriptor2, String name, JsExpression getter2, JsExpression setter2) {
        int argCount;
        int n = argCount = descriptor2.getContainingDeclaration() instanceof ClassDescriptor || descriptor2.getExtensionReceiverParameter() != null ? 1 : 0;
        if (receiver != null) {
            --argCount;
        }
        JsStringLiteral nameLiteral = new JsStringLiteral(name);
        JsIntLiteral argCountLiteral = new JsIntLiteral(argCount);
        JsExpression jsExpression = $this$wrapPropertyCallableRef.getReferenceToIntrinsic("getPropertyCallableRef");
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getReferenceToIntrinsic(\u2026er.PROPERTY_CALLABLE_REF)");
        JsExpression invokeFun = jsExpression;
        JsInvocation invocation = new JsInvocation(invokeFun, nameLiteral, argCountLiteral, getter2);
        if (setter2 != null) {
            Collection collection = invocation.getArguments();
            boolean bl = false;
            collection.add(setter2);
        }
        MetadataProperties.setCallableReferenceReceiver(invocation, receiver);
        return invocation;
    }

    private final JsExpression wrapFunctionCallableRef(TranslationContext $this$wrapFunctionCallableRef, JsExpression receiver, String name, JsExpression function2) {
        JsStringLiteral nameLiteral = new JsStringLiteral(name);
        JsExpression jsExpression = $this$wrapFunctionCallableRef.getReferenceToIntrinsic("getCallableRef");
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getReferenceToIntrinsic(\u2026er.FUNCTION_CALLABLE_REF)");
        JsExpression invokeFun = jsExpression;
        MetadataProperties.setSideEffects(invokeFun, SideEffectKind.PURE);
        JsInvocation invocation = new JsInvocation(invokeFun, nameLiteral, function2);
        MetadataProperties.setCallableReference(invocation, true);
        MetadataProperties.setSideEffects(invocation, SideEffectKind.PURE);
        MetadataProperties.setCallableReferenceReceiver(invocation, receiver);
        return invocation;
    }

    private CallableReferenceTranslator() {
    }

    static {
        CallableReferenceTranslator callableReferenceTranslator;
        INSTANCE = callableReferenceTranslator = new CallableReferenceTranslator();
    }
}

