/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0002J$\u0010\u0012\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsExportDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isExportable", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "currentlyProcessed", "", "isExportableReturn", "js.frontend"})
public final class JsExportDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final JsExportDeclarationChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        block19: {
            DeclarationDescriptor declarationDescriptor;
            Function1<String, Unit> $fun$reportWrongExportedDeclaration$3;
            Function1<TypeParameterDescriptor, Unit> $fun$checkTypeParameter$1;
            BindingContext bindingContext;
            BindingTrace trace;
            block18: {
                Annotated parameter;
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                trace = context2.getTrace();
                BindingContext bindingContext2 = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"trace.bindingContext");
                bindingContext = bindingContext2;
                $fun$checkTypeParameter$1 = new Function1<TypeParameterDescriptor, Unit>(bindingContext, trace){
                    final /* synthetic */ BindingContext $bindingContext;
                    final /* synthetic */ BindingTrace $trace;

                    public final void invoke(@NotNull TypeParameterDescriptor descriptor2) {
                        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                        Iterator<KotlinType> iterator2 = descriptor2.getUpperBounds().iterator();
                        while (iterator2.hasNext()) {
                            PsiElement typeParameterDeclaration;
                            KotlinType upperBound;
                            KotlinType kotlinType = upperBound = iterator2.next();
                            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"upperBound");
                            if (JsExportDeclarationChecker.isExportable$default(JsExportDeclarationChecker.INSTANCE, kotlinType, this.$bindingContext, null, 2, null)) continue;
                            Intrinsics.checkNotNull((Object)DescriptorToSourceUtils.descriptorToDeclaration(descriptor2));
                            this.$trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(typeParameterDeclaration, "upper bound", upperBound));
                        }
                    }
                    {
                        this.$bindingContext = bindingContext;
                        this.$trace = bindingTrace;
                        super(1);
                    }
                };
                Function1<ValueParameterDescriptor, Unit> $fun$checkValueParameter$2 = new Function1<ValueParameterDescriptor, Unit>(bindingContext, trace){
                    final /* synthetic */ BindingContext $bindingContext;
                    final /* synthetic */ BindingTrace $trace;

                    public final void invoke(@NotNull ValueParameterDescriptor descriptor2) {
                        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                        KotlinType kotlinType = descriptor2.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"descriptor.type");
                        if (!JsExportDeclarationChecker.isExportable$default(JsExportDeclarationChecker.INSTANCE, kotlinType, this.$bindingContext, null, 2, null)) {
                            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
                            Intrinsics.checkNotNull((Object)psiElement);
                            PsiElement valueParameterDeclaration = psiElement;
                            this.$trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(valueParameterDeclaration, "parameter", descriptor2.getType()));
                        }
                    }
                    {
                        this.$bindingContext = bindingContext;
                        this.$trace = bindingTrace;
                        super(1);
                    }
                };
                if (!AnnotationsUtils.isExportedObject(descriptor2, bindingContext)) {
                    return;
                }
                if (!(descriptor2 instanceof MemberDescriptor)) {
                    return;
                }
                boolean hasJsName = AnnotationsUtils.getJsNameAnnotation(descriptor2) != null;
                $fun$reportWrongExportedDeclaration$3 = new Function1<String, Unit>(trace, declaration2){
                    final /* synthetic */ BindingTrace $trace;
                    final /* synthetic */ KtDeclaration $declaration;

                    public final void invoke(@NotNull String kind) {
                        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
                        this.$trace.report(ErrorsJs.WRONG_EXPORTED_DECLARATION.on((KtExpression)((PsiElement)this.$declaration), kind));
                    }
                    {
                        this.$trace = bindingTrace;
                        this.$declaration = ktDeclaration;
                        super(1);
                    }
                };
                if (((MemberDescriptor)descriptor2).isExpect()) {
                    $fun$reportWrongExportedDeclaration$3.invoke("expect");
                }
                if (!((declarationDescriptor = descriptor2) instanceof FunctionDescriptor)) break block18;
                Iterator<DeclarationDescriptorNonRoot> iterator2 = ((FunctionDescriptor)descriptor2).getTypeParameters().iterator();
                while (iterator2.hasNext()) {
                    TypeParameterDescriptor typeParameter;
                    TypeParameterDescriptor typeParameterDescriptor = typeParameter = iterator2.next();
                    Intrinsics.checkNotNullExpressionValue((Object)typeParameterDescriptor, (String)"typeParameter");
                    $fun$checkTypeParameter$1.invoke(typeParameterDescriptor);
                }
                if (InlineOnlyKt.isInlineWithReified((MemberDescriptor)descriptor2)) {
                    $fun$reportWrongExportedDeclaration$3.invoke("inline function with reified type parameters");
                    return;
                }
                if (((FunctionDescriptor)descriptor2).isSuspend()) {
                    $fun$reportWrongExportedDeclaration$3.invoke("suspend function");
                    return;
                }
                if (descriptor2 instanceof ConstructorDescriptor && !((ConstructorDescriptor)descriptor2).isPrimary() && !hasJsName) {
                    $fun$reportWrongExportedDeclaration$3.invoke("secondary constructor without @JsName");
                }
                if (descriptor2 instanceof PropertyAccessorDescriptor) break block19;
                iterator2 = ((FunctionDescriptor)descriptor2).getValueParameters().iterator();
                while (iterator2.hasNext()) {
                    ValueParameterDescriptor valueParameterDescriptor = parameter = (ValueParameterDescriptor)iterator2.next();
                    Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"parameter");
                    $fun$checkValueParameter$2.invoke(valueParameterDescriptor);
                }
                KotlinType kotlinType = ((FunctionDescriptor)descriptor2).getReturnType();
                if (kotlinType == null) break block19;
                parameter = kotlinType;
                boolean bl = false;
                boolean bl2 = false;
                Annotated returnType2 = parameter;
                boolean bl3 = false;
                Annotated annotated = returnType2;
                Intrinsics.checkNotNullExpressionValue((Object)annotated, (String)"returnType");
                if (JsExportDeclarationChecker.isExportableReturn$default(INSTANCE, (KotlinType)annotated, bindingContext, null, 2, null)) break block19;
                trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(declaration2, "return", (KotlinType)returnType2));
                break block19;
            }
            if (declarationDescriptor instanceof PropertyDescriptor) {
                if (DescriptorUtilsKt.isExtensionProperty(descriptor2)) {
                    $fun$reportWrongExportedDeclaration$3.invoke("extension property");
                    return;
                }
                KotlinType kotlinType = ((PropertyDescriptor)descriptor2).getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"descriptor.type");
                if (!JsExportDeclarationChecker.isExportable$default(this, kotlinType, bindingContext, null, 2, null)) {
                    trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(declaration2, "property", ((PropertyDescriptor)descriptor2).getType()));
                }
            } else if (declarationDescriptor instanceof ClassDescriptor) {
                Iterator<Annotated> iterator3 = ((ClassDescriptor)descriptor2).getDeclaredTypeParameters().iterator();
                while (iterator3.hasNext()) {
                    TypeParameterDescriptor typeParameter;
                    TypeParameterDescriptor typeParameterDescriptor = typeParameter = iterator3.next();
                    Intrinsics.checkNotNullExpressionValue((Object)typeParameterDescriptor, (String)"typeParameter");
                    $fun$checkTypeParameter$1.invoke(typeParameterDescriptor);
                }
                if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_CLASS) {
                    $fun$reportWrongExportedDeclaration$3.invoke("enum class");
                    return;
                }
                if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ANNOTATION_CLASS) {
                    $fun$reportWrongExportedDeclaration$3.invoke("annotation class");
                    return;
                }
                if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY) {
                    return;
                }
                SimpleType simpleType2 = ((ClassDescriptor)descriptor2).getDefaultType();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"descriptor.defaultType");
                for (KotlinType superType : TypeUtilsKt.supertypes(simpleType2)) {
                    if (JsExportDeclarationChecker.isExportable$default(this, superType, bindingContext, null, 2, null)) continue;
                    trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(declaration2, "super", superType));
                }
            }
        }
    }

    private final boolean isExportableReturn(KotlinType $this$isExportableReturn, BindingContext bindingContext, Set<KotlinType> currentlyProcessed) {
        return TypeUtilsKt.isUnit($this$isExportableReturn) || this.isExportable($this$isExportableReturn, bindingContext, currentlyProcessed);
    }

    static /* synthetic */ boolean isExportableReturn$default(JsExportDeclarationChecker jsExportDeclarationChecker, KotlinType kotlinType, BindingContext bindingContext, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl = false;
            set = new LinkedHashSet();
        }
        return jsExportDeclarationChecker.isExportableReturn(kotlinType, bindingContext, set);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isExportable(KotlinType $this$isExportable, BindingContext bindingContext, Set<KotlinType> currentlyProcessed) {
        boolean isPrimitiveExportableType;
        if (!currentlyProcessed.add($this$isExportable)) {
            return true;
        }
        currentlyProcessed.add($this$isExportable);
        if (FunctionTypesKt.isFunctionType($this$isExportable)) {
            int n = 0;
            int n2 = CollectionsKt.getLastIndex($this$isExportable.getArguments());
            while (n < n2) {
                void i;
                KotlinType kotlinType = $this$isExportable.getArguments().get((int)i).getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"arguments[i].type");
                if (!this.isExportable(kotlinType, bindingContext, currentlyProcessed)) {
                    currentlyProcessed.remove($this$isExportable);
                    return false;
                }
                ++i;
            }
            currentlyProcessed.remove($this$isExportable);
            KotlinType kotlinType = ((TypeProjection)CollectionsKt.last($this$isExportable.getArguments())).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"arguments.last().type");
            return this.isExportableReturn(kotlinType, bindingContext, currentlyProcessed);
        }
        for (TypeProjection argument : $this$isExportable.getArguments()) {
            KotlinType kotlinType = argument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"argument.type");
            if (this.isExportable(kotlinType, bindingContext, currentlyProcessed)) continue;
            currentlyProcessed.remove($this$isExportable);
            return false;
        }
        currentlyProcessed.remove($this$isExportable);
        KotlinType nonNullable = TypeUtilsKt.makeNotNullable($this$isExportable);
        boolean bl = isPrimitiveExportableType = TypeUtilsKt.isAnyOrNullableAny(nonNullable) || DynamicTypesKt.isDynamic(nonNullable) || TypeUtilsKt.isBoolean(nonNullable) || KotlinBuiltIns.isThrowableOrNullableThrowable(nonNullable) || KotlinBuiltIns.isString(nonNullable) || TypeUtilsKt.isPrimitiveNumberOrNullableType(nonNullable) && !TypeUtilsKt.isLong(nonNullable) || TypeUtilsKt.isNothingOrNullableNothing(nonNullable) || KotlinBuiltIns.isArray($this$isExportable) || KotlinBuiltIns.isPrimitiveArray($this$isExportable);
        if (isPrimitiveExportableType) {
            return true;
        }
        ClassifierDescriptor descriptor2 = $this$isExportable.getConstructor().getDeclarationDescriptor();
        if (!(descriptor2 instanceof MemberDescriptor)) {
            return false;
        }
        return DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)((Object)descriptor2)) || AnnotationsUtils.isExportedObject(descriptor2, bindingContext);
    }

    static /* synthetic */ boolean isExportable$default(JsExportDeclarationChecker jsExportDeclarationChecker, KotlinType kotlinType, BindingContext bindingContext, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl = false;
            set = new LinkedHashSet();
        }
        return jsExportDeclarationChecker.isExportable(kotlinType, bindingContext, set);
    }

    private JsExportDeclarationChecker() {
    }

    static {
        JsExportDeclarationChecker jsExportDeclarationChecker;
        INSTANCE = jsExportDeclarationChecker = new JsExportDeclarationChecker();
    }
}

