/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0005\u0017\u0018\u0019\u001a\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u0000H&J\b\u0010\u000f\u001a\u00020\u0010H&J\b\u0010\u0011\u001a\u00020\u0012H&J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0000H&J\n\u0010\u0015\u001a\u00020\u0004*\u00020\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0006R\u0012\u0010\b\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u0082\u0001\u0004\n\u001c\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/ir/util/IdSignature;", "", "()V", "hasTopLevel", "", "getHasTopLevel", "()Z", "isLocal", "isPublic", "asPublic", "Lorg/jetbrains/kotlin/ir/util/IdSignature$PublicSignature;", "flags", "", "isPackageSignature", "nearestPublicSig", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "render", "", "toString", "topLevelSignature", "test", "Lorg/jetbrains/kotlin/ir/util/IdSignature$Flags;", "AccessorSignature", "FileLocalSignature", "Flags", "PublicSignature", "ScopeLocalDeclaration", "Lorg/jetbrains/kotlin/ir/util/IdSignature$AccessorSignature;", "Lorg/jetbrains/kotlin/ir/util/IdSignature$FileLocalSignature;", "Lorg/jetbrains/kotlin/ir/util/IdSignature$ScopeLocalDeclaration;", "ir.tree"})
public abstract class IdSignature {
    public abstract boolean isPublic();

    public boolean isPackageSignature() {
        return false;
    }

    @NotNull
    public abstract IdSignature topLevelSignature();

    @NotNull
    public abstract IdSignature nearestPublicSig();

    @NotNull
    public abstract FqName packageFqName();

    @Nullable
    public PublicSignature asPublic() {
        return null;
    }

    @NotNull
    public abstract String render();

    public final boolean test(@NotNull Flags $this$test) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$test), (String)"$this$test");
        return $this$test.decode(this.flags());
    }

    protected long flags() {
        return 0L;
    }

    public boolean getHasTopLevel() {
        return !this.isPackageSignature();
    }

    public final boolean isLocal() {
        return !this.isPublic();
    }

    @NotNull
    public String toString() {
        return (this.isPublic() ? "public" : "private") + ' ' + this.render();
    }

    private IdSignature() {
    }

    public /* synthetic */ IdSignature(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/util/IdSignature$Flags;", "", "recursive", "", "(Ljava/lang/String;IZ)V", "getRecursive", "()Z", "decode", "flags", "", "encode", "isSet", "IS_EXPECT", "IS_JAVA_FOR_KOTLIN_OVERRIDE_PROPERTY", "IS_NATIVE_INTEROP_LIBRARY", "ir.tree"})
    public static final class Flags
    extends Enum<Flags> {
        public static final /* enum */ Flags IS_EXPECT;
        public static final /* enum */ Flags IS_JAVA_FOR_KOTLIN_OVERRIDE_PROPERTY;
        public static final /* enum */ Flags IS_NATIVE_INTEROP_LIBRARY;
        private static final /* synthetic */ Flags[] $VALUES;
        private final boolean recursive;

        static {
            Flags[] flagsArray = new Flags[3];
            Flags[] flagsArray2 = flagsArray;
            flagsArray[0] = IS_EXPECT = new Flags(true);
            flagsArray[1] = IS_JAVA_FOR_KOTLIN_OVERRIDE_PROPERTY = new Flags(false);
            flagsArray[2] = IS_NATIVE_INTEROP_LIBRARY = new Flags(true);
            $VALUES = flagsArray;
        }

        public final long encode(boolean isSet) {
            return isSet ? 1L << this.ordinal() : 0L;
        }

        public final boolean decode(long flags) {
            return (flags & 1L << this.ordinal()) != 0L;
        }

        public final boolean getRecursive() {
            return this.recursive;
        }

        private Flags(boolean recursive) {
            this.recursive = recursive;
        }

        public static Flags[] values() {
            return (Flags[])$VALUES.clone();
        }

        public static Flags valueOf(String string2) {
            return Enum.valueOf(Flags.class, string2);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0000H\u0016J\u0013\u0010\u001f\u001a\u00020\u00112\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020\u0006H\u0014J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0011H\u0016J\b\u0010&\u001a\u00020\u0000H\u0016J\b\u0010\u0002\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0003H\u0016J\b\u0010)\u001a\u00020\u0001H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\nR\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\n\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/ir/util/IdSignature$PublicSignature;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "packageFqName", "", "declarationFqName", "id", "", "mask", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;J)V", "getDeclarationFqName", "()Ljava/lang/String;", "firstNameSegment", "getFirstNameSegment", "getId", "()Ljava/lang/Long;", "Ljava/lang/Long;", "isPublic", "", "()Z", "getMask", "()J", "nameSegments", "", "getNameSegments", "()Ljava/util/List;", "getPackageFqName", "shortName", "getShortName", "adaptMask", "old", "asPublic", "equals", "other", "", "flags", "hashCode", "", "isPackageSignature", "nearestPublicSig", "Lorg/jetbrains/kotlin/name/FqName;", "render", "topLevelSignature", "ir.tree"})
    public static final class PublicSignature
    extends IdSignature {
        @NotNull
        private final String packageFqName;
        @NotNull
        private final String declarationFqName;
        @Nullable
        private final Long id;
        private final long mask;

        @Override
        public boolean isPublic() {
            return true;
        }

        @Override
        @NotNull
        public FqName packageFqName() {
            return new FqName(this.packageFqName);
        }

        @NotNull
        public final String getShortName() {
            return StringsKt.substringAfterLast$default((String)this.declarationFqName, (char)'.', null, (int)2, null);
        }

        @NotNull
        public final String getFirstNameSegment() {
            return StringsKt.substringBefore$default((String)this.declarationFqName, (char)'.', null, (int)2, null);
        }

        @NotNull
        public final List<String> getNameSegments() {
            return StringsKt.split$default((CharSequence)this.declarationFqName, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
        }

        /*
         * WARNING - void declaration
         */
        private final long adaptMask(long old) {
            void $this$fold$iv;
            void initial$iv;
            Flags[] flagsArray = Flags.values();
            long l = 0L;
            long l2 = old;
            boolean $i$f$fold = false;
            void accumulator$iv = initial$iv;
            void var9_7 = $this$fold$iv;
            int n = ((void)var9_7).length;
            for (int i = 0; i < n; ++i) {
                void f;
                void element$iv;
                void var13_11 = element$iv = var9_7[i];
                void a = accumulator$iv;
                boolean bl = false;
                accumulator$iv = !f.getRecursive() ? a | old & 1L << f.ordinal() : a;
            }
            void var19_14 = accumulator$iv;
            return l2 ^ var19_14;
        }

        @Override
        @NotNull
        public IdSignature topLevelSignature() {
            CharSequence charSequence = this.declarationFqName;
            boolean bl = false;
            if (charSequence.length() == 0) {
                boolean bl2 = this.id == null;
                bl = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl4 = false;
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                return this;
            }
            List<String> nameSegments = this.getNameSegments();
            if (nameSegments.size() == 1) {
                return this;
            }
            return new PublicSignature(this.packageFqName, (String)CollectionsKt.first(nameSegments), null, this.adaptMask(this.mask));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isPackageSignature() {
            if (this.id != null) return false;
            CharSequence charSequence = this.declarationFqName;
            boolean bl = false;
            if (charSequence.length() != 0) return false;
            return true;
        }

        @Override
        @NotNull
        public PublicSignature nearestPublicSig() {
            return this;
        }

        @Override
        protected long flags() {
            return this.mask;
        }

        @Override
        @NotNull
        public String render() {
            StringBuilder stringBuilder2 = new StringBuilder().append(this.packageFqName).append('/').append(this.declarationFqName).append('|').append(this.id).append('[');
            long l = this.mask;
            int n = 2;
            boolean bl = false;
            String string2 = Long.toString(l, CharsKt.checkRadix((int)n));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.Long.toString(this, checkRadix(radix))");
            return stringBuilder2.append(string2).append(']').toString();
        }

        @Override
        @Nullable
        public PublicSignature asPublic() {
            return this;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof PublicSignature && Intrinsics.areEqual((Object)this.packageFqName, (Object)((PublicSignature)other).packageFqName) && Intrinsics.areEqual((Object)this.declarationFqName, (Object)((PublicSignature)other).declarationFqName) && Intrinsics.areEqual((Object)this.id, (Object)((PublicSignature)other).id) && this.mask == ((PublicSignature)other).mask;
        }

        public int hashCode() {
            Long l = this.id;
            boolean bl = false;
            Long l2 = l;
            return ((this.packageFqName.hashCode() * 31 + this.declarationFqName.hashCode()) * 31 + (l2 != null ? ((Object)l2).hashCode() : 0)) * 31 + Long.hashCode(this.mask);
        }

        @NotNull
        public final String getPackageFqName() {
            return this.packageFqName;
        }

        @NotNull
        public final String getDeclarationFqName() {
            return this.declarationFqName;
        }

        @Nullable
        public final Long getId() {
            return this.id;
        }

        public final long getMask() {
            return this.mask;
        }

        public PublicSignature(@NotNull String packageFqName, @NotNull String declarationFqName, @Nullable Long id, long mask) {
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)declarationFqName, (String)"declarationFqName");
            super(null);
            this.packageFqName = packageFqName;
            this.declarationFqName = declarationFqName;
            this.id = id;
            this.mask = mask;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\n\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0016J\u0013\u0010\u000e\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0001H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0001H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/ir/util/IdSignature$AccessorSignature;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "propertySignature", "accessorSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$PublicSignature;", "(Lorg/jetbrains/kotlin/ir/util/IdSignature;Lorg/jetbrains/kotlin/ir/util/IdSignature$PublicSignature;)V", "getAccessorSignature", "()Lorg/jetbrains/kotlin/ir/util/IdSignature$PublicSignature;", "isPublic", "", "()Z", "getPropertySignature", "()Lorg/jetbrains/kotlin/ir/util/IdSignature;", "asPublic", "equals", "other", "", "flags", "", "hashCode", "", "nearestPublicSig", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "render", "", "topLevelSignature", "ir.tree"})
    public static final class AccessorSignature
    extends IdSignature {
        @NotNull
        private final IdSignature propertySignature;
        @NotNull
        private final PublicSignature accessorSignature;

        @Override
        public boolean isPublic() {
            return true;
        }

        @Override
        @NotNull
        public IdSignature topLevelSignature() {
            return this.propertySignature.topLevelSignature();
        }

        @Override
        @NotNull
        public IdSignature nearestPublicSig() {
            return this;
        }

        @Override
        @NotNull
        public FqName packageFqName() {
            return this.propertySignature.packageFqName();
        }

        @Override
        @NotNull
        public String render() {
            return this.accessorSignature.render();
        }

        @Override
        protected long flags() {
            return this.accessorSignature.getMask();
        }

        @Override
        @Nullable
        public PublicSignature asPublic() {
            return this.accessorSignature;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof AccessorSignature ? Intrinsics.areEqual((Object)this.accessorSignature, (Object)((AccessorSignature)other).accessorSignature) : Intrinsics.areEqual((Object)this.accessorSignature, (Object)other);
        }

        public int hashCode() {
            return this.accessorSignature.hashCode();
        }

        @NotNull
        public final IdSignature getPropertySignature() {
            return this.propertySignature;
        }

        @NotNull
        public final PublicSignature getAccessorSignature() {
            return this.accessorSignature;
        }

        public AccessorSignature(@NotNull IdSignature propertySignature, @NotNull PublicSignature accessorSignature) {
            Intrinsics.checkNotNullParameter((Object)propertySignature, (String)"propertySignature");
            Intrinsics.checkNotNullParameter((Object)accessorSignature, (String)"accessorSignature");
            super(null);
            this.propertySignature = propertySignature;
            this.accessorSignature = accessorSignature;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\r\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0001H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0001H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/ir/util/IdSignature$FileLocalSignature;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "container", "id", "", "(Lorg/jetbrains/kotlin/ir/util/IdSignature;J)V", "getContainer", "()Lorg/jetbrains/kotlin/ir/util/IdSignature;", "getId", "()J", "isPublic", "", "()Z", "equals", "other", "", "hashCode", "", "nearestPublicSig", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "render", "", "topLevelSignature", "ir.tree"})
    public static final class FileLocalSignature
    extends IdSignature {
        @NotNull
        private final IdSignature container;
        private final long id;

        @Override
        public boolean isPublic() {
            return false;
        }

        @Override
        @NotNull
        public FqName packageFqName() {
            return this.container.packageFqName();
        }

        @Override
        @NotNull
        public IdSignature topLevelSignature() {
            IdSignature topLevelContainer = this.container.topLevelSignature();
            if (topLevelContainer == this.container && topLevelContainer instanceof PublicSignature) {
                CharSequence charSequence = ((PublicSignature)topLevelContainer).getDeclarationFqName();
                boolean bl = false;
                if (charSequence.length() == 0) {
                    return this;
                }
            }
            return topLevelContainer;
        }

        @Override
        @NotNull
        public IdSignature nearestPublicSig() {
            return this.container.nearestPublicSig();
        }

        @Override
        @NotNull
        public String render() {
            return this.container.render() + ':' + this.id;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof FileLocalSignature && this.id == ((FileLocalSignature)other).id && Intrinsics.areEqual((Object)this.container, (Object)((FileLocalSignature)other).container);
        }

        public int hashCode() {
            return this.container.hashCode() * 31 + Long.hashCode(this.id);
        }

        @NotNull
        public final IdSignature getContainer() {
            return this.container;
        }

        public final long getId() {
            return this.id;
        }

        public FileLocalSignature(@NotNull IdSignature container2, long id) {
            Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
            super(null);
            this.container = container2;
            this.id = id;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0010\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0001H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0001H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/ir/util/IdSignature$ScopeLocalDeclaration;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "id", "", "description", "", "(ILjava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "hasTopLevel", "", "getHasTopLevel", "()Z", "getId", "()I", "isPublic", "equals", "other", "", "hashCode", "nearestPublicSig", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "render", "topLevelSignature", "ir.tree"})
    public static final class ScopeLocalDeclaration
    extends IdSignature {
        private final int id;
        @NotNull
        private final String description;

        @Override
        public boolean isPublic() {
            return false;
        }

        @Override
        public boolean getHasTopLevel() {
            return false;
        }

        @Override
        @NotNull
        public IdSignature topLevelSignature() {
            String string2 = "Is not supported for Local ID";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }

        @Override
        @NotNull
        public IdSignature nearestPublicSig() {
            String string2 = "Is not supported for Local ID";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }

        @Override
        @NotNull
        public FqName packageFqName() {
            String string2 = "Is not supported for Local ID";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }

        @Override
        @NotNull
        public String render() {
            return "" + '#' + this.id;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof ScopeLocalDeclaration && this.id == ((ScopeLocalDeclaration)other).id;
        }

        public int hashCode() {
            return this.id;
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public ScopeLocalDeclaration(int id, @NotNull String description2) {
            Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
            super(null);
            this.id = id;
            this.description = description2;
        }

        public /* synthetic */ ScopeLocalDeclaration(int n, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                string2 = "<no description>";
            }
            this(n, string2);
        }
    }
}

