/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIntrinsicTransformers;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrClassModel;
import org.jetbrains.kotlin.ir.backend.js.utils.IrNamer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u000fH\u0096\u0001\u00a2\u0006\u0002\u0010\u001dJ\u0011\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000fH\u0096\u0001J\u0011\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0096\u0001J\u0011\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0096\u0001J\u0013\u0010'\u001a\u0004\u0018\u00010\u001f2\u0006\u0010(\u001a\u00020)H\u0096\u0001J\u0011\u0010*\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0096\u0001J\u0011\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-H\u0096\u0001J\u0011\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u000200H\u0096\u0001J\u0011\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u000203H\u0096\u0001J\u0011\u00104\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-H\u0096\u0001J\u0011\u00105\u001a\u00020\u001f2\u0006\u00102\u001a\u000206H\u0096\u0001J\u0011\u00107\u001a\u0002082\u0006\u0010 \u001a\u00020\u000fH\u0096\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamer;", "backendContext", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "irNamer", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamer;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "classModels", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrClassModel;", "getClassModels", "()Ljava/util/Map;", "coroutineImplDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getCoroutineImplDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "initializerBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsGlobalBlock;", "getInitializerBlock", "()Lorg/jetbrains/kotlin/js/backend/ast/JsGlobalBlock;", "intrinsics", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIntrinsicTransformers;", "getIntrinsics", "()Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIntrinsicTransformers;", "getAssociatedObjectKey", "", "irClass", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Ljava/lang/Integer;", "getNameForClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "klass", "getNameForConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getNameForField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getNameForLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "getNameForMemberField", "getNameForMemberFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getNameForProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getNameForStaticDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getNameForStaticFunction", "getNameForValueDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "getRefForExternalClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "backend.js"})
public final class JsStaticContext
implements IrNamer {
    @NotNull
    private final JsIntrinsicTransformers intrinsics;
    @NotNull
    private final Map<IrClassSymbol, JsIrClassModel> classModels;
    @NotNull
    private final IrClass coroutineImplDeclaration;
    @NotNull
    private final JsGlobalBlock initializerBlock;
    @NotNull
    private final JsIrBackendContext backendContext;
    private final IrNamer irNamer;

    @NotNull
    public final JsIntrinsicTransformers getIntrinsics() {
        return this.intrinsics;
    }

    @NotNull
    public final Map<IrClassSymbol, JsIrClassModel> getClassModels() {
        return this.classModels;
    }

    @NotNull
    public final IrClass getCoroutineImplDeclaration() {
        return this.coroutineImplDeclaration;
    }

    @NotNull
    public final JsGlobalBlock getInitializerBlock() {
        return this.initializerBlock;
    }

    @NotNull
    public final JsIrBackendContext getBackendContext() {
        return this.backendContext;
    }

    public JsStaticContext(@NotNull JsIrBackendContext backendContext, @NotNull IrNamer irNamer) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        Intrinsics.checkNotNullParameter((Object)irNamer, (String)"irNamer");
        this.backendContext = backendContext;
        this.irNamer = irNamer;
        this.intrinsics = new JsIntrinsicTransformers(this.backendContext);
        boolean bl = false;
        this.classModels = new LinkedHashMap();
        this.coroutineImplDeclaration = (IrClass)this.backendContext.getIr().getSymbols().getCoroutineImpl().getOwner();
        this.initializerBlock = new JsGlobalBlock();
    }

    @Override
    @Nullable
    public Integer getAssociatedObjectKey(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        return this.irNamer.getAssociatedObjectKey(irClass2);
    }

    @Override
    @NotNull
    public JsName getNameForClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return this.irNamer.getNameForClass(klass);
    }

    @Override
    @NotNull
    public JsName getNameForConstructor(@NotNull IrConstructor constructor2) {
        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
        return this.irNamer.getNameForConstructor(constructor2);
    }

    @Override
    @NotNull
    public JsName getNameForField(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return this.irNamer.getNameForField(field);
    }

    @Override
    @Nullable
    public JsName getNameForLoop(@NotNull IrLoop loop2) {
        Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
        return this.irNamer.getNameForLoop(loop2);
    }

    @Override
    @NotNull
    public JsName getNameForMemberField(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return this.irNamer.getNameForMemberField(field);
    }

    @Override
    @NotNull
    public JsName getNameForMemberFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return this.irNamer.getNameForMemberFunction(function2);
    }

    @Override
    @NotNull
    public JsName getNameForProperty(@NotNull IrProperty property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        return this.irNamer.getNameForProperty(property2);
    }

    @Override
    @NotNull
    public JsName getNameForStaticDeclaration(@NotNull IrDeclarationWithName declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return this.irNamer.getNameForStaticDeclaration(declaration2);
    }

    @Override
    @NotNull
    public JsName getNameForStaticFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return this.irNamer.getNameForStaticFunction(function2);
    }

    @Override
    @NotNull
    public JsName getNameForValueDeclaration(@NotNull IrValueDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return this.irNamer.getNameForValueDeclaration(declaration2);
    }

    @Override
    @NotNull
    public JsNameRef getRefForExternalClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return this.irNamer.getRefForExternalClass(klass);
    }
}

