/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.BuildReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.incremental.BuildDifference;
import org.jetbrains.kotlin.incremental.BuildDiffsStorage;
import org.jetbrains.kotlin.incremental.BuildInfo;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.ChangesDetectionUtilsKt;
import org.jetbrains.kotlin.incremental.ChangesEither;
import org.jetbrains.kotlin.incremental.DirtyData;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistory;
import org.jetbrains.kotlin.incremental.util.Either;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a6\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a8\u0006\r"}, d2={"getClasspathChanges", "Lorg/jetbrains/kotlin/incremental/ChangesEither;", "classpath", "", "Ljava/io/File;", "changedFiles", "Lorg/jetbrains/kotlin/incremental/ChangedFiles$Known;", "lastBuildInfo", "Lorg/jetbrains/kotlin/incremental/BuildInfo;", "modulesApiHistory", "Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistory;", "reporter", "Lorg/jetbrains/kotlin/build/report/BuildReporter;", "incremental-compilation-impl"})
public final class ChangesDetectionUtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final ChangesEither getClasspathChanges(@NotNull List<? extends File> classpath, @NotNull ChangedFiles.Known changedFiles, @NotNull BuildInfo lastBuildInfo, @NotNull ModulesApiHistory modulesApiHistory, @NotNull BuildReporter reporter) {
        Object object;
        void $this$measure$iv;
        Either<Set<File>> $i$a$-measure-ChangesDetectionUtilsKt$getClasspathChanges$historyFilesEither$232;
        void $this$measure$iv2;
        Collection $this$filterTo$iv;
        void $this$filterTo$iv2;
        boolean bl;
        File it;
        boolean $i$f$filterTo;
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)changedFiles, (String)"changedFiles");
        Intrinsics.checkNotNullParameter((Object)lastBuildInfo, (String)"lastBuildInfo");
        Intrinsics.checkNotNullParameter((Object)modulesApiHistory, (String)"modulesApiHistory");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        HashSet<File> classpathSet = new HashSet<File>();
        for (File file2 : classpath) {
            if (file2.isFile()) {
                classpathSet.add(file2);
                continue;
            }
            if (!file2.isDirectory()) continue;
            Sequence $this$filterTo$iv22 = (Sequence)FilesKt.walk$default((File)file2, null, (int)1, null);
            $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv22) {
                it = (File)element$iv;
                bl = false;
                if (!it.isFile()) continue;
                ((Collection)classpathSet).add(element$iv);
            }
        }
        Iterable iterable = changedFiles.getModified();
        Iterable destination$iv = new HashSet();
        $i$f$filterTo = false;
        for (Object element$iv2 : $this$filterTo$iv2) {
            it = (File)element$iv2;
            bl = false;
            if (!classpathSet.contains(it)) continue;
            destination$iv.add(element$iv2);
        }
        HashSet hashSet = (HashSet)destination$iv;
        destination$iv = changedFiles.getRemoved();
        Collection destination$iv2 = new HashSet();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv3 : $this$filterTo$iv) {
            File it2 = (File)element$iv3;
            boolean bl2 = false;
            if (!classpathSet.contains(it2)) continue;
            destination$iv2.add(element$iv3);
        }
        HashSet removedClasspath = (HashSet)destination$iv2;
        $this$filterTo$iv = removedClasspath;
        boolean bl3 = false;
        if (!$this$filterTo$iv.isEmpty()) {
            reporter.report((Function0<String>)((Function0)new Function0<String>(removedClasspath){
                final /* synthetic */ HashSet $removedClasspath;

                @NotNull
                public final String invoke() {
                    return "Some files are removed from classpath: " + this.$removedClasspath;
                }
                {
                    this.$removedClasspath = hashSet;
                    super(0);
                }
            }));
            return new ChangesEither.Unknown(BuildAttribute.DEP_CHANGE_REMOVED_ENTRY);
        }
        if (hashSet.isEmpty()) {
            return new ChangesEither.Known(null, null, 3, null);
        }
        long lastBuildTS = lastBuildInfo.getStartTS();
        HashSet symbols2 = new HashSet();
        HashSet fqNames = new HashSet();
        BuildMetricsReporter it2 = reporter;
        Object metric$iv = BuildTime.IC_FIND_HISTORY_FILES;
        boolean $i$f$measure232 = false;
        long start$iv = System.nanoTime();
        $this$measure$iv2.startMeasure((BuildTime)metric$iv, start$iv);
        try {
            boolean $i$a$-measure-ChangesDetectionUtilsKt$getClasspathChanges$historyFilesEither$232 = false;
            $i$a$-measure-ChangesDetectionUtilsKt$getClasspathChanges$historyFilesEither$232 = modulesApiHistory.historyFilesForChangedFiles(hashSet);
        }
        finally {
            long end$iv = System.nanoTime();
            $this$measure$iv2.endMeasure((BuildTime)metric$iv, end$iv);
        }
        Either<Set<File>> historyFilesEither = $i$a$-measure-ChangesDetectionUtilsKt$getClasspathChanges$historyFilesEither$232;
        metric$iv = historyFilesEither;
        if (!(metric$iv instanceof Either.Success)) {
            if (metric$iv instanceof Either.Error) {
                reporter.report((Function0<String>)((Function0)new Function0<String>(historyFilesEither){
                    final /* synthetic */ Either $historyFilesEither;

                    @NotNull
                    public final String invoke() {
                        return "Could not find history files: " + ((Either.Error)this.$historyFilesEither).getReason();
                    }
                    {
                        this.$historyFilesEither = either;
                        super(0);
                    }
                }));
                return new ChangesEither.Unknown(BuildAttribute.DEP_CHANGE_HISTORY_IS_NOT_FOUND);
            }
            throw new NoWhenBranchMatchedException();
        }
        Set historyFiles2 = (Set)((Either.Success)historyFilesEither).getValue();
        Function0<ChangesEither> $fun$analyzeHistoryFiles$3 = new Function0<ChangesEither>(historyFiles2, reporter, lastBuildTS, symbols2, fqNames){
            final /* synthetic */ Set $historyFiles;
            final /* synthetic */ BuildReporter $reporter;
            final /* synthetic */ long $lastBuildTS;
            final /* synthetic */ HashSet $symbols;
            final /* synthetic */ HashSet $fqNames;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ChangesEither invoke() {
                for (File historyFile : this.$historyFiles) {
                    void knownBuilds;
                    List<BuildDifference> allBuilds;
                    if (BuildDiffsStorage.Companion.readDiffsFromFile(historyFile, this.$reporter) == null) {
                        boolean bl = false;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        this.$reporter.report((Function0<String>)((Function0)new Function0<String>(this, historyFile){
                            final /* synthetic */ getClasspathChanges.3 this$0;
                            final /* synthetic */ File $historyFile$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$historyFile$inlined = file2;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return "Could not read diffs from " + this.$historyFile$inlined;
                            }
                        }));
                        return new ChangesEither.Unknown(BuildAttribute.DEP_CHANGE_HISTORY_CANNOT_BE_READ);
                    }
                    Iterable $this$partition$iv = allBuilds;
                    boolean $i$f$partition = false;
                    ArrayList<T> first$iv = new ArrayList<T>();
                    ArrayList<T> second$iv = new ArrayList<T>();
                    for (T element$iv : $this$partition$iv) {
                        BuildDifference it = (BuildDifference)element$iv;
                        boolean bl = false;
                        if (it.getTs() <= this.$lastBuildTS) {
                            first$iv.add(element$iv);
                            continue;
                        }
                        second$iv.add(element$iv);
                    }
                    Pair bl3 = new Pair(first$iv, second$iv);
                    List list2 = (List)bl3.component1();
                    List newBuilds = (List)bl3.component2();
                    if (knownBuilds.isEmpty()) {
                        this.$reporter.report((Function0<String>)((Function0)new Function0<String>(historyFile){
                            final /* synthetic */ File $historyFile;

                            @NotNull
                            public final String invoke() {
                                return "No previously known builds for " + this.$historyFile;
                            }
                            {
                                this.$historyFile = file2;
                                super(0);
                            }
                        }));
                        return new ChangesEither.Unknown(BuildAttribute.DEP_CHANGE_HISTORY_NO_KNOWN_BUILDS);
                    }
                    for (BuildDifference buildDiff : newBuilds) {
                        if (!buildDiff.isIncremental()) {
                            this.$reporter.report((Function0<String>)((Function0)new Function0<String>(historyFile){
                                final /* synthetic */ File $historyFile;

                                @NotNull
                                public final String invoke() {
                                    return "Non-incremental build from dependency " + this.$historyFile;
                                }
                                {
                                    this.$historyFile = file2;
                                    super(0);
                                }
                            }));
                            return new ChangesEither.Unknown(BuildAttribute.DEP_CHANGE_NON_INCREMENTAL_BUILD_IN_DEP);
                        }
                        DirtyData dirtyData = buildDiff.getDirtyData();
                        this.$symbols.addAll(dirtyData.getDirtyLookupSymbols());
                        this.$fqNames.addAll(dirtyData.getDirtyClassesFqNames());
                    }
                }
                return new ChangesEither.Known(this.$symbols, this.$fqNames);
            }
            {
                this.$historyFiles = set;
                this.$reporter = buildReporter;
                this.$lastBuildTS = l;
                this.$symbols = hashSet;
                this.$fqNames = hashSet2;
                super(0);
            }
        };
        BuildMetricsReporter $i$f$measure232 = reporter;
        BuildTime metric$iv2 = BuildTime.IC_ANALYZE_HISTORY_FILES;
        boolean $i$f$measure = false;
        long start$iv2 = System.nanoTime();
        $this$measure$iv.startMeasure(metric$iv2, start$iv2);
        try {
            boolean bl2 = false;
            object = $fun$analyzeHistoryFiles$3.invoke();
        }
        finally {
            long end$iv = System.nanoTime();
            $this$measure$iv.endMeasure(metric$iv2, end$iv);
        }
        return object;
    }
}

