/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.calls.tower.TowerScopeLevel;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJD\u0010\u0011\u001a\u00020\u0012\"\f\b\u0000\u0010\u0013*\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00172\u0016\u0010\u0018\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0004\u0012\u00020\u00120\u0019H\u0016J.\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000b2\u001c\u0010\u0018\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00120\u001bH\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractStarImportingScope;", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractImportingScope;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "lookupInFir", "", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Z)V", "absentClassifierNames", "", "Lorg/jetbrains/kotlin/name/Name;", "starImports", "", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedImport;", "getStarImports", "()Ljava/util/List;", "processCallables", "", "T", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "name", "token", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerScopeLevel$Token;", "processor", "Lkotlin/Function1;", "processClassifiersByNameWithSubstitution", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "resolve"})
public abstract class FirAbstractStarImportingScope
extends FirAbstractImportingScope {
    private final Set<Name> absentClassifierNames;

    @NotNull
    public abstract List<FirResolvedImport> getStarImports();

    @Override
    public void processClassifiersByNameWithSubstitution(@NotNull Name name, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        if (this.getStarImports().isEmpty() || this.absentClassifierNames.contains(name)) {
            return;
        }
        boolean empty2 = true;
        for (FirResolvedImport firResolvedImport : this.getStarImports()) {
            FirClassLikeSymbol<?> symbol2;
            ClassId classId;
            FqName relativeClassName = firResolvedImport.getRelativeClassName();
            if (!name.isSpecial()) {
                String string2 = name.getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name.identifier");
                CharSequence charSequence = string2;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    return;
                }
            }
            ClassId classId2 = classId = relativeClassName == null ? new ClassId(firResolvedImport.getPackageFqName(), name) : new ClassId(firResolvedImport.getPackageFqName(), relativeClassName.child(name), false);
            if (this.getProvider().getClassLikeSymbolByFqName(classId) == null) {
                continue;
            }
            empty2 = false;
            processor2.invoke(symbol2, (Object)ConeSubstitutor.Empty.INSTANCE);
        }
        if (empty2) {
            Collection collection = this.absentClassifierNames;
            boolean bl = false;
            collection.add(name);
        }
    }

    @Override
    public <T extends FirCallableSymbol<?>> void processCallables(@NotNull Name name, @NotNull TowerScopeLevel.Token<? extends T> token, @NotNull Function1<? super FirCallableSymbol<?>, Unit> processor2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(token, (String)"token");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        if (this.getStarImports().isEmpty()) {
            return;
        }
        for (FirResolvedImport firResolvedImport : this.getStarImports()) {
            this.processCallables(firResolvedImport, name, token, processor2);
        }
    }

    public FirAbstractStarImportingScope(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, boolean lookupInFir) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        super(session2, scopeSession, lookupInFir);
        boolean bl = false;
        this.absentClassifierNames = new LinkedHashSet();
    }

    public /* synthetic */ FirAbstractStarImportingScope(FirSession firSession, ScopeSession scopeSession, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(firSession, scopeSession, bl);
    }
}

