/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.tower;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.calls.tower.InvokeResolvePriority;
import org.jetbrains.kotlin.fir.resolve.calls.tower.TowerGroupKind;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001fB\u001f\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u0011\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0016\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\u0010\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\b\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;", "", "kinds", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;", "invokeResolvePriority", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/InvokeResolvePriority;", "([Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;Lorg/jetbrains/kotlin/fir/resolve/calls/tower/InvokeResolvePriority;)V", "InvokeExtension", "getInvokeExtension", "()Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;", "Member", "getMember", "[Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;", "Implicit", "depth", "", "InvokeResolvePriority", "Local", "NonLocal", "TopPrioritized", "compareTo", "other", "equals", "", "", "hashCode", "kindOf", "kind", "toString", "", "Companion", "resolve"})
public final class TowerGroup
implements Comparable<TowerGroup> {
    private final TowerGroupKind[] kinds;
    private final InvokeResolvePriority invokeResolvePriority;
    @NotNull
    private static final TowerGroup EmptyRoot;
    @NotNull
    private static final TowerGroup Start;
    @NotNull
    private static final TowerGroup ClassifierPrioritized;
    @NotNull
    private static final TowerGroup Qualifier;
    @NotNull
    private static final TowerGroup Classifier;
    @NotNull
    private static final TowerGroup QualifierValue;
    @NotNull
    private static final TowerGroup Member;
    @NotNull
    private static final TowerGroup Last;
    @NotNull
    public static final Companion Companion;

    private final TowerGroup kindOf(TowerGroupKind kind) {
        return new TowerGroup((TowerGroupKind[])ArraysKt.plus((Object[])this.kinds, (Object)kind), null, 2, null);
    }

    @NotNull
    public final TowerGroup getMember() {
        return this.kindOf(TowerGroupKind.Member.INSTANCE);
    }

    @NotNull
    public final TowerGroup Local(int depth) {
        return this.kindOf(new TowerGroupKind.Local(depth));
    }

    @NotNull
    public final TowerGroup Implicit(int depth) {
        return this.kindOf(TowerGroupKind.Companion.Implicit(depth));
    }

    @NotNull
    public final TowerGroup NonLocal(int depth) {
        return this.kindOf(TowerGroupKind.Companion.NonLocal(depth));
    }

    @NotNull
    public final TowerGroup getInvokeExtension() {
        return this.kindOf(TowerGroupKind.InvokeExtension.INSTANCE);
    }

    @NotNull
    public final TowerGroup TopPrioritized(int depth) {
        return this.kindOf(new TowerGroupKind.TopPrioritized(depth));
    }

    @NotNull
    public final TowerGroup InvokeResolvePriority(@NotNull InvokeResolvePriority invokeResolvePriority) {
        Intrinsics.checkNotNullParameter((Object)((Object)invokeResolvePriority), (String)"invokeResolvePriority");
        if (invokeResolvePriority == InvokeResolvePriority.NONE) {
            return this;
        }
        return new TowerGroup(this.kinds, invokeResolvePriority);
    }

    @Override
    public int compareTo(@NotNull TowerGroup other) {
        int index2;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        for (index2 = 0; index2 < this.kinds.length; ++index2) {
            if (index2 >= other.kinds.length) {
                return 1;
            }
            if (this.kinds[index2].compareTo(other.kinds[index2]) < 0) {
                return -1;
            }
            if (this.kinds[index2].compareTo(other.kinds[index2]) <= 0) continue;
            return 1;
        }
        if (index2 < other.kinds.length) {
            return -1;
        }
        return this.invokeResolvePriority.compareTo((Enum)other.invokeResolvePriority);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.resolve.calls.tower.TowerGroup");
        }
        TowerGroup cfr_ignored_0 = (TowerGroup)object2;
        Object[] objectArray = this.kinds;
        Object[] objectArray2 = ((TowerGroup)other).kinds;
        boolean bl = false;
        if (!Arrays.equals(objectArray, objectArray2)) {
            return false;
        }
        return this.invokeResolvePriority == ((TowerGroup)other).invokeResolvePriority;
    }

    public int hashCode() {
        Object[] objectArray = this.kinds;
        boolean bl = false;
        int result2 = Arrays.hashCode(objectArray);
        result2 = 31 * result2 + this.invokeResolvePriority.hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder2 = new StringBuilder().append("TowerGroup(kinds=");
        Object[] objectArray = this.kinds;
        boolean bl = false;
        String string2 = Arrays.toString(objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.util.Arrays.toString(this)");
        return stringBuilder2.append(string2).append(", invokeResolvePriority=").append((Object)this.invokeResolvePriority).append(')').toString();
    }

    private TowerGroup(TowerGroupKind[] kinds, InvokeResolvePriority invokeResolvePriority) {
        this.kinds = kinds;
        this.invokeResolvePriority = invokeResolvePriority;
    }

    /* synthetic */ TowerGroup(TowerGroupKind[] towerGroupKindArray, InvokeResolvePriority invokeResolvePriority, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            invokeResolvePriority = InvokeResolvePriority.NONE;
        }
        this(towerGroupKindArray, invokeResolvePriority);
    }

    static {
        Companion = new Companion(null);
        EmptyRoot = new TowerGroup(new TowerGroupKind[0], null, 2, null);
        Start = TowerGroup.Companion.kindOf(TowerGroupKind.Start.INSTANCE);
        ClassifierPrioritized = TowerGroup.Companion.kindOf(TowerGroupKind.ClassifierPrioritized.INSTANCE);
        Qualifier = TowerGroup.Companion.kindOf(TowerGroupKind.Qualifier.INSTANCE);
        Classifier = TowerGroup.Companion.kindOf(TowerGroupKind.Classifier.INSTANCE);
        QualifierValue = TowerGroup.Companion.kindOf(TowerGroupKind.QualifierValue.INSTANCE);
        Member = TowerGroup.Companion.kindOf(TowerGroupKind.Member.INSTANCE);
        Last = TowerGroup.Companion.kindOf(TowerGroupKind.Last.INSTANCE);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup$Companion;", "", "()V", "Classifier", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;", "getClassifier", "()Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;", "ClassifierPrioritized", "getClassifierPrioritized", "EmptyRoot", "getEmptyRoot", "Last", "getLast", "Member", "getMember", "Qualifier", "getQualifier", "QualifierValue", "getQualifierValue", "Start", "getStart", "Implicit", "depth", "", "Local", "NonLocal", "TopPrioritized", "kindOf", "kind", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroupKind;", "resolve"})
    public static final class Companion {
        private final TowerGroup kindOf(TowerGroupKind kind) {
            return new TowerGroup(new TowerGroupKind[]{kind}, null, 2, null);
        }

        @NotNull
        public final TowerGroup getEmptyRoot() {
            return EmptyRoot;
        }

        @NotNull
        public final TowerGroup getStart() {
            return Start;
        }

        @NotNull
        public final TowerGroup getClassifierPrioritized() {
            return ClassifierPrioritized;
        }

        @NotNull
        public final TowerGroup getQualifier() {
            return Qualifier;
        }

        @NotNull
        public final TowerGroup getClassifier() {
            return Classifier;
        }

        @NotNull
        public final TowerGroup getQualifierValue() {
            return QualifierValue;
        }

        @NotNull
        public final TowerGroup getMember() {
            return Member;
        }

        @NotNull
        public final TowerGroup Local(int depth) {
            return this.kindOf(new TowerGroupKind.Local(depth));
        }

        @NotNull
        public final TowerGroup Implicit(int depth) {
            return this.kindOf(TowerGroupKind.Companion.Implicit(depth));
        }

        @NotNull
        public final TowerGroup NonLocal(int depth) {
            return this.kindOf(TowerGroupKind.Companion.NonLocal(depth));
        }

        @NotNull
        public final TowerGroup TopPrioritized(int depth) {
            return this.kindOf(new TowerGroupKind.TopPrioritized(depth));
        }

        @NotNull
        public final TowerGroup getLast() {
            return Last;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

