/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.builder.FirSimpleFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirTypeParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.resolve.FirOuterClassManager;
import org.jetbrains.kotlin.fir.resolve.FirSamResolver;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.SamResolutionKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.FirSyntheticFunctionSymbol;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.SubstitutorsKt;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0014\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/FirSamResolverImpl;", "Lorg/jetbrains/kotlin/fir/resolve/FirSamResolver;", "firSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "outerClassManager", "Lorg/jetbrains/kotlin/fir/resolve/FirOuterClassManager;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/resolve/FirOuterClassManager;)V", "resolvedFunctionType", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "", "samConstructor", "buildSamConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "firRegularClass", "getFunctionTypeForPossibleSamType", "Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getSamConstructor", "resolveFunctionTypeIfSamInterface", "shouldRunSamConversionForFunction", "", "firFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "resolve"})
public final class FirSamResolverImpl
extends FirSamResolver {
    private final Map<FirRegularClass, Object> resolvedFunctionType;
    private final Map<FirRegularClass, Object> samConstructor;
    private final FirSession firSession;
    private final ScopeSession scopeSession;
    private final FirOuterClassManager outerClassManager;

    @Override
    @Nullable
    public ConeKotlinType getFunctionTypeForPossibleSamType(@NotNull ConeKotlinType type2) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ConeKotlinType coneKotlinType2 = type2;
        if (coneKotlinType2 instanceof ConeClassLikeType) {
            coneKotlinType = this.getFunctionTypeForPossibleSamType(TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)type2, this.firSession, null, 2, null));
        } else if (coneKotlinType2 instanceof ConeFlexibleType) {
            ConeKotlinType coneKotlinType3 = this.getFunctionTypeForPossibleSamType(((ConeFlexibleType)type2).getLowerBound());
            if (coneKotlinType3 == null) {
                return null;
            }
            ConeKotlinType coneKotlinType4 = this.getFunctionTypeForPossibleSamType(((ConeFlexibleType)type2).getUpperBound());
            if (coneKotlinType4 == null) {
                return null;
            }
            coneKotlinType = new ConeFlexibleType(coneKotlinType3, coneKotlinType4);
        } else if (coneKotlinType2 instanceof ConeClassErrorType || coneKotlinType2 instanceof ConeStubType) {
            coneKotlinType = null;
        } else if (coneKotlinType2 instanceof ConeTypeParameterType || coneKotlinType2 instanceof ConeTypeVariableType || coneKotlinType2 instanceof ConeCapturedType || coneKotlinType2 instanceof ConeDefinitelyNotNullType || coneKotlinType2 instanceof ConeIntersectionType || coneKotlinType2 instanceof ConeIntegerLiteralType) {
            coneKotlinType = null;
        } else if (coneKotlinType2 instanceof ConeLookupTagBasedType) {
            coneKotlinType = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return coneKotlinType;
    }

    /*
     * WARNING - void declaration
     */
    private final ConeLookupTagBasedType getFunctionTypeForPossibleSamType(ConeClassLikeType type2) {
        FirTypeParameterSymbol firTypeParameterSymbol;
        Pair it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.getSymbolByLookupTag(MainSessionComponentsKt.getFirSymbolProvider(this.firSession), type2.getLookupTag());
        FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        if (!(firClassLikeDeclaration instanceof FirRegularClass)) {
            firClassLikeDeclaration = null;
        }
        FirRegularClass firRegularClass = (FirRegularClass)firClassLikeDeclaration;
        if (firRegularClass == null) {
            return null;
        }
        FirRegularClass firRegularClass2 = firRegularClass;
        ConeLookupTagBasedType coneLookupTagBasedType = this.resolveFunctionTypeIfSamInterface(firRegularClass2);
        if (coneLookupTagBasedType == null) {
            return null;
        }
        ConeLookupTagBasedType unsubstitutedFunctionType = coneLookupTagBasedType;
        if (firRegularClass2.getTypeParameters().isEmpty()) {
            return (ConeLookupTagBasedType)TypeUtilsKt.withNullability$default(unsubstitutedFunctionType, ConeNullability.Companion.create(ConeTypeUtilsKt.isMarkedNullable(type2)), SessionUtilsKt.getTypeContext(this.firSession), null, 4, null);
        }
        Iterable iterable = firRegularClass2.getTypeParameters();
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            firTypeParameterSymbol = it.getSymbol();
            collection.add(firTypeParameterSymbol);
        }
        $this$map$iv = CollectionsKt.zip((Iterable)((List)destination$iv$iv), (Object[])type2.getTypeArguments());
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ConeKotlinTypeProjection coneKotlinTypeProjection;
            void parameterSymbol;
            ConeKotlinTypeProjection coneKotlinTypeProjection2;
            void $dstr$parameterSymbol$projection;
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            FirTypeParameterSymbol firTypeParameterSymbol2 = (FirTypeParameterSymbol)$dstr$parameterSymbol$projection.component1();
            ConeTypeProjection projection = (ConeTypeProjection)$dstr$parameterSymbol$projection.component2();
            ConeTypeProjection coneTypeProjection = projection;
            if (!(coneTypeProjection instanceof ConeKotlinTypeProjection)) {
                coneTypeProjection = null;
            }
            if ((coneKotlinTypeProjection2 = (ConeKotlinTypeProjection)coneTypeProjection) == null || (coneKotlinTypeProjection2 = coneKotlinTypeProjection2.getType()) == null) {
                if ((FirTypeRef)CollectionsKt.firstOrNull(((FirTypeParameter)parameterSymbol.getFir()).getBounds()) != null) {
                    FirTypeRef $this$coneTypeSafe$iv;
                    boolean $i$f$coneTypeSafe = false;
                    boolean bl2 = false;
                    FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
                    if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                        firTypeRef = null;
                    }
                    FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
                    coneKotlinTypeProjection2 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinTypeProjection2 instanceof ConeKotlinType)) {
                        coneKotlinTypeProjection2 = null;
                    }
                } else {
                    coneKotlinTypeProjection2 = coneKotlinTypeProjection = null;
                }
            }
            if (coneKotlinTypeProjection2 == null) {
                coneKotlinTypeProjection = this.firSession.getBuiltinTypes().getNullableAnyType().getType();
            }
            ConeKotlinTypeProjection typeArgument = coneKotlinTypeProjection;
            firTypeParameterSymbol = new Pair((Object)parameterSymbol, (Object)typeArgument);
            collection.add(firTypeParameterSymbol);
        }
        ConeSubstitutor substitutor2 = SubstitutorsKt.substitutorByMap(MapsKt.toMap((Iterable)((List)destination$iv$iv)));
        ConeKotlinType result2 = TypeUtilsKt.withNullability$default(substitutor2.substituteOrSelf(unsubstitutedFunctionType), ConeNullability.Companion.create(ConeTypeUtilsKt.isMarkedNullable(type2)), SessionUtilsKt.getTypeContext(this.firSession), null, 4, null);
        boolean bl = result2 instanceof ConeLookupTagBasedType;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Function type should always be ConeLookupTagBasedType, but " + Reflection.getOrCreateKotlinClass(result2.getClass()) + " was found";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return (ConeLookupTagBasedType)result2;
    }

    @Override
    @Nullable
    public FirSimpleFunction getSamConstructor(@NotNull FirRegularClass firRegularClass) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)firRegularClass, (String)"firRegularClass");
        Map<FirRegularClass, Object> $this$getOrPut$iv = this.samConstructor;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(firRegularClass);
        if (value$iv == null) {
            boolean bl = false;
            Object object2 = this.buildSamConstructor(firRegularClass);
            if (object2 == null) {
                object2 = SamResolutionKt.access$getNULL_STUB$p();
            }
            FirSimpleFunction answer$iv = object2;
            $this$getOrPut$iv.put(firRegularClass, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Object object3 = object;
        if (!(object instanceof FirSimpleFunction)) {
            object3 = null;
        }
        return (FirSimpleFunction)object3;
    }

    /*
     * WARNING - void declaration
     */
    private final FirSimpleFunction buildSamConstructor(FirRegularClass firRegularClass) {
        void $this$buildResolvedTypeRef;
        void $this$buildResolvedTypeRef2;
        void $this$mapTo$iv$iv;
        Iterable $this$apply;
        FirResolvedTypeRefBuilder $this$coneType$iv;
        boolean bl;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder;
        FirTypeParameterBuilder $this$mapTo$iv$iv2;
        Pair $this$map$iv4;
        Object item$iv$iv3;
        void $this$mapTo$iv$iv3;
        void $this$map$iv2;
        Object object;
        Object object2;
        Collection collection;
        void $this$mapTo$iv$iv4;
        Iterable it;
        ConeLookupTagBasedType coneLookupTagBasedType = this.resolveFunctionTypeIfSamInterface(firRegularClass);
        if (coneLookupTagBasedType == null) {
            return null;
        }
        ConeLookupTagBasedType functionType = coneLookupTagBasedType;
        ClassId classId = FirDeclarationUtilKt.getClassId(firRegularClass);
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classId.packageFqName");
        FqName fqName3 = classId.getRelativeClassName().parent();
        boolean bl2 = false;
        boolean bl3 = false;
        FqName fqName4 = fqName3;
        FqName fqName5 = fqName2;
        boolean bl4 = false;
        void v2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
        boolean bl5 = !v2.isRoot();
        FqName fqName6 = bl5 ? fqName3 : null;
        Name name = classId.getShortClassName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"classId.shortClassName");
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 8;
        FqName fqName7 = null;
        Name name2 = name;
        FqName fqName8 = fqName6;
        FqName fqName9 = fqName5;
        CallableId callableId = new CallableId(fqName9, fqName8, name2, fqName7, n, defaultConstructorMarker);
        FirSyntheticFunctionSymbol symbol2 = new FirSyntheticFunctionSymbol(callableId);
        Iterable $this$map$iv3 = firRegularClass.getTypeParameters();
        boolean $i$f$map22 = false;
        it = $this$map$iv3;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
            void typeParameter;
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl6 = false;
            FirTypeParameter declaredTypeParameter = (FirTypeParameter)typeParameter.getSymbol().getFir();
            FirTypeParameterBuilder firTypeParameterBuilder = new FirTypeParameterBuilder();
            boolean bl7 = false;
            boolean bl8 = false;
            FirTypeParameterBuilder $this$apply2 = firTypeParameterBuilder;
            boolean bl9 = false;
            $this$apply2.setSource(declaredTypeParameter.getSource());
            $this$apply2.setSession(this.firSession);
            $this$apply2.setOrigin(FirDeclarationOrigin.SamConstructor.INSTANCE);
            $this$apply2.setName(declaredTypeParameter.getName());
            $this$apply2.setSymbol(new FirTypeParameterSymbol());
            $this$apply2.setVariance(Variance.INVARIANT);
            $this$apply2.setReified(false);
            object2 = $this$apply2.getAnnotations();
            Iterable iterable = declaredTypeParameter.getAnnotations();
            boolean bl10 = false;
            CollectionsKt.addAll((Collection)object2, (Iterable)iterable);
            object = firTypeParameterBuilder;
            collection.add(object);
        }
        List newTypeParameters = (List)destination$iv$iv;
        Iterable $i$f$map22 = newTypeParameters;
        boolean $i$f$map32 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
            void it2;
            FirTypeParameterBuilder bl6 = (FirTypeParameterBuilder)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl11 = false;
            object = new ConeTypeParameterTypeImpl(it2.getSymbol().toLookupTag(), false, null, 4, null);
            collection.add(object);
        }
        List newTypeParameterTypes = (List)destination$iv$iv2;
        Iterable $i$f$map32 = firRegularClass.getTypeParameters();
        boolean $i$f$map = false;
        destination$iv$iv2 = $this$map$iv4;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo3 = false;
        item$iv$iv3 = $this$mapTo$iv$iv2.iterator();
        while (item$iv$iv3.hasNext()) {
            void it3;
            Object item$iv$iv4 = item$iv$iv3.next();
            FirTypeParameterRef bl11 = (FirTypeParameterRef)item$iv$iv4;
            collection = destination$iv$iv3;
            boolean bl12 = false;
            object = it3.getSymbol();
            collection.add(object);
        }
        ConeSubstitutor substitutor2 = SubstitutorsKt.substitutorByMap(MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)((List)destination$iv$iv3), (Iterable)newTypeParameterTypes)));
        for (Pair $this$map$iv4 : CollectionsKt.zip((Iterable)newTypeParameters, (Iterable)firRegularClass.getTypeParameters())) {
            void $this$mapTo$iv$iv5;
            void newTypeParameter;
            $this$mapTo$iv$iv2 = (FirTypeParameterBuilder)$this$map$iv4.component1();
            FirTypeParameterRef oldTypeParameter = (FirTypeParameterRef)$this$map$iv4.component2();
            FirTypeParameter declared = (FirTypeParameter)oldTypeParameter.getSymbol().getFir();
            item$iv$iv3 = newTypeParameter.getBounds();
            Iterable $this$map$iv5 = declared.getBounds();
            boolean $i$f$map4 = false;
            Iterable bl12 = $this$map$iv5;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv5 : $this$mapTo$iv$iv5) {
                void typeRef;
                object2 = (FirTypeRef)item$iv$iv5;
                collection = destination$iv$iv4;
                boolean bl13 = false;
                boolean $i$f$buildResolvedTypeRef = false;
                boolean bl14 = false;
                firAnnotationContainerBuilder = new FirResolvedTypeRefBuilder();
                boolean bl15 = false;
                bl = false;
                FirResolvedTypeRefBuilder $this$buildResolvedTypeRef3 = firAnnotationContainerBuilder;
                boolean bl16 = false;
                $this$buildResolvedTypeRef3.setSource(typeRef.getSource());
                $this$coneType$iv = typeRef;
                boolean $i$f$getConeType = false;
                void $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
                boolean $i$f$coneTypeUnsafe = false;
                ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
                if (coneKotlinType == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                }
                $this$buildResolvedTypeRef3.setType(substitutor2.substituteOrSelf(coneKotlinType));
                object = firAnnotationContainerBuilder.build();
                collection.add(object);
            }
            $this$map$iv5 = (List)destination$iv$iv4;
            $i$f$map4 = false;
            CollectionsKt.addAll((Collection)item$iv$iv3, (Iterable)$this$map$iv5);
        }
        boolean $i$f$buildSimpleFunction = false;
        boolean bl17 = false;
        FirSimpleFunctionBuilder firSimpleFunctionBuilder = new FirSimpleFunctionBuilder();
        boolean bl18 = false;
        boolean oldTypeParameter = false;
        FirSimpleFunctionBuilder $this$buildSimpleFunction = firSimpleFunctionBuilder;
        boolean bl19 = false;
        $this$buildSimpleFunction.setSession(this.firSession);
        $this$buildSimpleFunction.setSource(firRegularClass.getSource());
        Name name3 = classId.getShortClassName();
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"classId.shortClassName");
        $this$buildSimpleFunction.setName(name3);
        $this$buildSimpleFunction.setOrigin(FirDeclarationOrigin.SamConstructor.INSTANCE);
        Object $this$visibility$iv = firRegularClass;
        boolean $i$f$getVisibility = false;
        $this$visibility$iv = new FirDeclarationStatusImpl($this$visibility$iv.getStatus().getVisibility(), Modality.FINAL);
        $i$f$getVisibility = false;
        boolean $this$mapTo$iv$iv5 = false;
        FirElement destination$iv$iv4 = $this$visibility$iv;
        Object object3 = $this$buildSimpleFunction;
        boolean bl20 = false;
        FirMemberDeclaration $this$isExpect$iv = firRegularClass;
        boolean $i$f$isExpect = false;
        ((FirDeclarationStatusImpl)((Object)$this$apply)).setExpect($this$isExpect$iv.getStatus().isExpect());
        FirMemberDeclaration $this$isActual$iv = firRegularClass;
        boolean $i$f$isActual22 = false;
        ((FirDeclarationStatusImpl)((Object)$this$apply)).setActual($this$isActual$iv.getStatus().isActual());
        ((FirDeclarationStatusImpl)((Object)$this$apply)).setOverride(false);
        ((FirDeclarationStatusImpl)((Object)$this$apply)).setOperator(false);
        ((FirDeclarationStatusImpl)((Object)$this$apply)).setInfix(false);
        ((FirDeclarationStatusImpl)((Object)$this$apply)).setExternal(false);
        ((FirDeclarationStatusImpl)((Object)$this$apply)).setInline(false);
        ((FirDeclarationStatusImpl)((Object)$this$apply)).setSuspend(false);
        ((FirDeclarationStatusImpl)((Object)$this$apply)).setTailRec(false);
        Object object4 = Unit.INSTANCE;
        ((FirSimpleFunctionBuilder)object3).setStatus((FirDeclarationStatus)$this$visibility$iv);
        $this$buildSimpleFunction.setSymbol(symbol2);
        $this$visibility$iv = $this$buildSimpleFunction.getTypeParameters();
        Iterable $this$map$iv6 = newTypeParameters;
        boolean $i$f$map5 = false;
        $this$apply = $this$map$iv6;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv6, (int)10));
        boolean $i$f$mapTo5 = false;
        for (Object item$iv$iv6 : $this$mapTo$iv$iv) {
            void it4;
            firAnnotationContainerBuilder = (FirTypeParameterBuilder)item$iv$iv6;
            object3 = destination$iv$iv5;
            boolean bl21 = false;
            object4 = it4.build();
            object3.add(object4);
        }
        $this$map$iv6 = (List)destination$iv$iv5;
        $i$f$map5 = false;
        CollectionsKt.addAll((Collection)$this$visibility$iv, (Iterable)$this$map$iv6);
        ConeKotlinType substitutedFunctionType = substitutor2.substituteOrSelf(functionType);
        Collection $this$toTypedArray$iv = newTypeParameterTypes;
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ConeTypeParameterTypeImpl[] coneTypeParameterTypeImplArray = thisCollection$iv.toArray(new ConeTypeParameterTypeImpl[0]);
        if (coneTypeParameterTypeImplArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ConeClassLikeTypeImpl substitutedReturnType = new ConeClassLikeTypeImpl(firRegularClass.getSymbol().toLookupTag(), coneTypeParameterTypeImplArray, false, null, 8, null);
        boolean $i$f$buildResolvedTypeRef = false;
        $i$f$toTypedArray22 = false;
        FirResolvedTypeRefBuilder $i$f$toTypedArray22 = new FirResolvedTypeRefBuilder();
        boolean bl22 = false;
        boolean bl23 = false;
        FirResolvedTypeRefBuilder $i$f$isActual22 = $i$f$toTypedArray22;
        object3 = $this$buildSimpleFunction;
        boolean bl24 = false;
        $this$buildResolvedTypeRef2.setSource(null);
        $this$buildResolvedTypeRef2.setType(substitutedReturnType);
        object4 = Unit.INSTANCE;
        ((FirSimpleFunctionBuilder)object3).setReturnTypeRef($i$f$toTypedArray22.build());
        Collection collection2 = $this$buildSimpleFunction.getValueParameters();
        boolean $i$f$buildValueParameter = false;
        bl22 = false;
        FirValueParameterBuilder firValueParameterBuilder = new FirValueParameterBuilder();
        bl23 = false;
        boolean bl25 = false;
        FirValueParameterBuilder $this$buildValueParameter = firValueParameterBuilder;
        boolean bl26 = false;
        $this$buildValueParameter.setSession(this.firSession);
        $this$buildValueParameter.setOrigin(FirDeclarationOrigin.SamConstructor.INSTANCE);
        boolean $i$f$buildResolvedTypeRef2 = false;
        bl = false;
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
        boolean bl27 = false;
        boolean bl28 = false;
        $this$coneType$iv = firResolvedTypeRefBuilder;
        FirValueParameterBuilder firValueParameterBuilder2 = $this$buildValueParameter;
        boolean bl29 = false;
        $this$buildResolvedTypeRef.setSource(firRegularClass.getSource());
        $this$buildResolvedTypeRef.setType(substitutedFunctionType);
        Unit unit = Unit.INSTANCE;
        firValueParameterBuilder2.setReturnTypeRef(firResolvedTypeRefBuilder.build());
        $this$buildValueParameter.setName(SamResolutionKt.getSAM_PARAMETER_NAME());
        $this$buildValueParameter.setSymbol(new FirVariableSymbol<FirValueParameter>(SamResolutionKt.getSAM_PARAMETER_NAME()));
        $this$buildValueParameter.setCrossinline(false);
        $this$buildValueParameter.setNoinline(false);
        $this$buildValueParameter.setVararg(false);
        FirValueParameter firValueParameter = firValueParameterBuilder.build();
        boolean bl30 = false;
        collection2.add(firValueParameter);
        $this$buildSimpleFunction.setResolvePhase(FirResolvePhase.BODY_RESOLVE);
        FirSimpleFunction firSimpleFunction = firSimpleFunctionBuilder.build();
        boolean bl31 = false;
        bl18 = false;
        FirSimpleFunction $this$apply3 = firSimpleFunction;
        boolean bl32 = false;
        FirClassLikeSymbol<?> firClassLikeSymbol = this.outerClassManager.outerClass(firRegularClass.getSymbol());
        ClassMembersKt.setContainingClassAttr($this$apply3, firClassLikeSymbol != null ? firClassLikeSymbol.toLookupTag() : null);
        return firSimpleFunction;
    }

    private final ConeLookupTagBasedType resolveFunctionTypeIfSamInterface(FirRegularClass firRegularClass) {
        Object object;
        Map<FirRegularClass, Object> $this$getOrPut$iv = this.resolvedFunctionType;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(firRegularClass);
        if (value$iv == null) {
            Object object2;
            boolean bl = false;
            if (!firRegularClass.getStatus().isFun()) {
                object2 = SamResolutionKt.access$getNULL_STUB$p();
            } else {
                FirSimpleFunction firSimpleFunction = SamResolutionKt.access$getSingleAbstractMethodOrNull(firRegularClass, this.firSession, this.scopeSession);
                if (firSimpleFunction == null) {
                    object2 = SamResolutionKt.access$getNULL_STUB$p();
                } else {
                    FirSimpleFunction abstractMethod = firSimpleFunction;
                    object2 = SamResolutionKt.access$getFunctionTypeForAbstractMethod(abstractMethod);
                }
            }
            Object answer$iv = object2;
            $this$getOrPut$iv.put(firRegularClass, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Object object3 = object;
        if (!(object instanceof ConeLookupTagBasedType)) {
            object3 = null;
        }
        return (ConeLookupTagBasedType)object3;
    }

    @Override
    public boolean shouldRunSamConversionForFunction(@NotNull FirFunction<?> firFunction) {
        Intrinsics.checkNotNullParameter(firFunction, (String)"firFunction");
        return true;
    }

    public FirSamResolverImpl(@NotNull FirSession firSession, @NotNull ScopeSession scopeSession, @NotNull FirOuterClassManager outerClassManager) {
        Intrinsics.checkNotNullParameter((Object)firSession, (String)"firSession");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter((Object)outerClassManager, (String)"outerClassManager");
        this.firSession = firSession;
        this.scopeSession = scopeSession;
        this.outerClassManager = outerClassManager;
        boolean bl = false;
        this.resolvedFunctionType = new LinkedHashMap();
        bl = false;
        this.samConstructor = new LinkedHashMap();
    }
}

