/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree.converter;

import com.google.common.collect.ImmutableSet;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirExpressionRef;
import org.jetbrains.kotlin.fir.FirFunctionTarget;
import org.jetbrains.kotlin.fir.FirLabel;
import org.jetbrains.kotlin.fir.FirLightSourceElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirTargetElement;
import org.jetbrains.kotlin.fir.builder.BaseFirBuilder;
import org.jetbrains.kotlin.fir.builder.CalleeAndReceiver;
import org.jetbrains.kotlin.fir.builder.Context;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.builder.FirLabelBuilder;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirAnonymousFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCatch;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirConstKind;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenSubjectExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirAbstractFunctionCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArrayOfCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBlockBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBreakExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallableReferenceAccessBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCatchBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCheckNotNullCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.expressions.builder.FirContinueExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirDoWhileLoopBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirElseIfTrueConditionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirEmptyExpressionBlockBuilderKt;
import org.jetbrains.kotlin.fir.expressions.builder.FirEqualityOperatorCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirErrorExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirExpressionStubBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirGetClassCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirImplicitInvokeCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirLambdaArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirLoopBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirLoopJumpBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirNamedArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirQualifiedAccessBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirQualifiedAccessExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirReturnExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirSpreadArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirThisReceiverExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirThrowExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirTryExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirTypeOperatorCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirUnitExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhenBranchBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhenExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhenSubjectExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhileLoopBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.lightTree.LightTree2Fir;
import org.jetbrains.kotlin.fir.lightTree.converter.BaseConverter;
import org.jetbrains.kotlin.fir.lightTree.converter.ConverterUtilKt;
import org.jetbrains.kotlin.fir.lightTree.converter.DeclarationsConverter;
import org.jetbrains.kotlin.fir.lightTree.converter.ExpressionsConverter;
import org.jetbrains.kotlin.fir.lightTree.fir.DestructuringDeclaration;
import org.jetbrains.kotlin.fir.lightTree.fir.ValueParameter;
import org.jetbrains.kotlin.fir.lightTree.fir.WhenEntry;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.builder.FirErrorNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirExplicitSuperReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirExplicitThisReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirSimpleNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirImplicitTypeRefBuilder;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.stubs.elements.KtConstantExpressionElementType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bH\u0002J)\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\b2\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c\u00a2\u0006\u0002\b\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\bH\u0002J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\bH\u0002J \u0010%\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010'\u0012\u0004\u0012\u00020(\u0018\u00010&2\u0006\u0010)\u001a\u00020\bH\u0002J\u0010\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020\bH\u0002J\u0010\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020\bH\u0002J\u0010\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020\bH\u0002J\u0010\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u00020\bH\u0002J\u0016\u00102\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\b2\u0006\u00103\u001a\u00020\u001dJ\u0010\u00104\u001a\u00020(2\u0006\u00105\u001a\u00020\bH\u0002J\u0010\u00106\u001a\u00020\u00112\u0006\u00107\u001a\u00020\bH\u0002J\u0010\u00108\u001a\u00020!2\u0006\u00109\u001a\u00020\bH\u0002J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020!0;2\u0006\u0010<\u001a\u00020\bH\u0002J\u0010\u0010=\u001a\u00020\u00112\u0006\u0010>\u001a\u00020\bH\u0002J\u0010\u0010?\u001a\u00020!2\u0006\u0010@\u001a\u00020\bH\u0002J\u0012\u0010A\u001a\u00020(2\b\u0010B\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010C\u001a\u00020!2\u0006\u0010D\u001a\u00020\bH\u0002J\u0010\u0010E\u001a\u00020!2\u0006\u0010F\u001a\u00020\bH\u0002J\u0010\u0010G\u001a\u00020!2\u0006\u0010H\u001a\u00020\bH\u0002J\u0010\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\bH\u0002J\u0010\u0010L\u001a\u00020!2\u0006\u0010M\u001a\u00020\bH\u0002J\u0010\u0010N\u001a\u00020J2\u0006\u0010O\u001a\u00020\bH\u0002J\u0010\u0010P\u001a\u00020J2\u0006\u0010Q\u001a\u00020\bH\u0002J\u0010\u0010R\u001a\u00020!2\u0006\u0010S\u001a\u00020\bH\u0002J\u0010\u0010T\u001a\u00020!2\u0006\u0010U\u001a\u00020\bH\u0002J\u0010\u0010V\u001a\u00020!2\u0006\u0010W\u001a\u00020\bH\u0002J\u0010\u0010X\u001a\u00020!2\u0006\u0010Y\u001a\u00020\bH\u0002J\u0014\u0010Z\u001a\b\u0012\u0004\u0012\u00020!0;2\u0006\u0010[\u001a\u00020\bJ \u0010\\\u001a\u00020!2\u0006\u0010]\u001a\u00020\b2\u000e\u0010^\u001a\n\u0012\u0004\u0012\u00020`\u0018\u00010_H\u0002J \u0010a\u001a\u00020!2\u0006\u0010]\u001a\u00020\b2\u000e\u0010^\u001a\n\u0012\u0004\u0012\u00020`\u0018\u00010_H\u0002J \u0010b\u001a\u00020!2\u0006\u0010]\u001a\u00020\b2\u000e\u0010^\u001a\n\u0012\u0004\u0012\u00020`\u0018\u00010_H\u0002J \u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020\b2\u000e\u0010^\u001a\n\u0012\u0004\u0012\u00020`\u0018\u00010_H\u0002J\u0010\u0010f\u001a\u00020!2\u0006\u0010g\u001a\u00020\bH\u0002J\u0010\u0010h\u001a\u00020\u00112\u0006\u0010i\u001a\u00020\bH\u0002J.\u0010j\u001a\u0002Hk\"\n\b\u0000\u0010k\u0018\u0001*\u00020\u00112\b\u0010-\u001a\u0004\u0018\u00010\b2\b\b\u0002\u00103\u001a\u00020\u001dH\u0086\b\u00a2\u0006\u0002\u0010lJ\u0016\u0010m\u001a\u00020!*\u0004\u0018\u00010\b2\u0006\u00103\u001a\u00020\u001dH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006n"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/converter/ExpressionsConverter;", "Lorg/jetbrains/kotlin/fir/lightTree/converter/BaseConverter;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "stubMode", "", "tree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/lang/LighterASTNode;", "declarationsConverter", "Lorg/jetbrains/kotlin/fir/lightTree/converter/DeclarationsConverter;", "offset", "", "context", "Lorg/jetbrains/kotlin/fir/builder/Context;", "(Lorg/jetbrains/kotlin/fir/FirSession;ZLcom/intellij/util/diff/FlyweightCapableTreeStructure;Lorg/jetbrains/kotlin/fir/lightTree/converter/DeclarationsConverter;ILorg/jetbrains/kotlin/fir/builder/Context;)V", "convertAnnotatedExpression", "Lorg/jetbrains/kotlin/fir/FirElement;", "annotatedExpression", "convertArrayAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "arrayAccess", "convertBinaryExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "binaryExpression", "convertBinaryWithTypeRHSExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "toFirOperation", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/fir/expressions/FirOperation;", "Lkotlin/ExtensionFunctionType;", "convertCallExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "callSuffix", "convertCallableReferenceExpression", "callableReferenceExpression", "convertCatchClause", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/lightTree/fir/ValueParameter;", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "catchClause", "convertClassLiteralExpression", "classLiteralExpression", "convertCollectionLiteralExpression", "expression", "convertConstantExpression", "constantExpression", "convertDoWhile", "doWhileLoop", "convertExpression", "errorReason", "convertFinally", "finallyExpression", "convertFor", "forLoop", "convertIfExpression", "ifExpression", "convertIndices", "", "indices", "convertLabeledExpression", "labeledExpression", "convertLambdaExpression", "lambdaExpression", "convertLoopBody", "body", "convertLoopJump", "jump", "convertQualifiedExpression", "dotQualifiedExpression", "convertReturn", "returnExpression", "convertSimpleNameExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "referenceExpression", "convertStringTemplate", "stringTemplate", "convertSuperExpression", "superExpression", "convertThisExpression", "thisExpression", "convertThrow", "throwExpression", "convertTryExpression", "tryExpression", "convertUnaryExpression", "unaryExpression", "convertValueArgument", "valueArgument", "convertValueArguments", "valueArguments", "convertWhenConditionExpression", "whenCondition", "whenRefWithSubject", "Lorg/jetbrains/kotlin/fir/FirExpressionRef;", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "convertWhenConditionInRange", "convertWhenConditionIsPattern", "convertWhenEntry", "Lorg/jetbrains/kotlin/fir/lightTree/fir/WhenEntry;", "whenEntry", "convertWhenExpression", "whenExpression", "convertWhile", "whileLoop", "getAsFirExpression", "R", "(Lcom/intellij/lang/LighterASTNode;Ljava/lang/String;)Lorg/jetbrains/kotlin/fir/FirElement;", "convertShortOrLongStringTemplate", "light-tree2fir"})
public final class ExpressionsConverter
extends BaseConverter {
    private final boolean stubMode;
    private final DeclarationsConverter declarationsConverter;

    public final /* synthetic */ <R extends FirElement> R getAsFirExpression(LighterASTNode expression2, String errorReason) {
        FirElement firElement;
        int $i$f$getAsFirExpression = 0;
        Intrinsics.checkNotNullParameter((Object)errorReason, (String)"errorReason");
        LighterASTNode lighterASTNode2 = expression2;
        if (lighterASTNode2 != null) {
            LighterASTNode lighterASTNode3 = lighterASTNode2;
            boolean bl = false;
            boolean bl2 = false;
            LighterASTNode it = lighterASTNode3;
            boolean bl3 = false;
            firElement = this.convertExpression(it, errorReason);
        } else {
            firElement = null;
        }
        Intrinsics.reifiedOperationMarker((int)2, (String)"R");
        FirElement firElement2 = firElement;
        if (firElement2 == null) {
            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason, DiagnosticKind.ExpressionRequired));
            Intrinsics.reifiedOperationMarker((int)1, (String)"R");
            firElement2 = firErrorExpression;
        }
        return (R)firElement2;
    }

    public static /* synthetic */ FirElement getAsFirExpression$default(ExpressionsConverter this_, LighterASTNode expression2, String errorReason, int n, Object object) {
        FirElement firElement;
        if ((n & 2) != 0) {
            errorReason = "";
        }
        boolean $i$f$getAsFirExpression = false;
        Intrinsics.checkNotNullParameter((Object)errorReason, (String)"errorReason");
        LighterASTNode lighterASTNode2 = expression2;
        if (lighterASTNode2 != null) {
            object = lighterASTNode2;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            firElement = this_.convertExpression((LighterASTNode)it, errorReason);
        } else {
            firElement = null;
        }
        Intrinsics.reifiedOperationMarker((int)2, (String)"R");
        FirElement firElement2 = firElement;
        if (firElement2 == null) {
            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason, DiagnosticKind.ExpressionRequired));
            Intrinsics.reifiedOperationMarker((int)1, (String)"R");
            firElement2 = firErrorExpression;
        }
        return firElement2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FirElement convertExpression(@NotNull LighterASTNode expression2, @NotNull String errorReason) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)errorReason, (String)"errorReason");
        if (!this.stubMode) {
            FirElement firElement;
            IElementType iElementType = expression2.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.LAMBDA_EXPRESSION)) {
                FlyweightCapableTreeStructure<LighterASTNode> lambdaTree = LightTree2Fir.Companion.buildLightTreeLambdaExpression(this.getAsText(expression2));
                ExpressionsConverter expressionsConverter = new ExpressionsConverter(this.getBaseSession(), this.stubMode, lambdaTree, this.declarationsConverter, this.getOffset(), this.getContext());
                LighterASTNode lighterASTNode2 = lambdaTree.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)lighterASTNode2, (String)"lambdaTree.root");
                firElement = expressionsConverter.convertLambdaExpression(lighterASTNode2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BINARY_EXPRESSION)) {
                firElement = this.convertBinaryExpression(expression2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BINARY_WITH_TYPE)) {
                firElement = this.convertBinaryWithTypeRHSExpression(expression2, (Function1<? super String, ? extends FirOperation>)((Function1)convertExpression.1.INSTANCE));
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.IS_EXPRESSION)) {
                firElement = this.convertBinaryWithTypeRHSExpression(expression2, (Function1<? super String, ? extends FirOperation>)((Function1)convertExpression.2.INSTANCE));
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.LABELED_EXPRESSION)) {
                firElement = this.convertLabeledExpression(expression2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PREFIX_EXPRESSION) || Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.POSTFIX_EXPRESSION)) {
                firElement = this.convertUnaryExpression(expression2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.ANNOTATED_EXPRESSION)) {
                firElement = this.convertAnnotatedExpression(expression2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CLASS_LITERAL_EXPRESSION)) {
                firElement = this.convertClassLiteralExpression(expression2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CALLABLE_REFERENCE_EXPRESSION)) {
                firElement = this.convertCallableReferenceExpression(expression2);
            } else if (ConverterUtilKt.getQualifiedAccessTokens().contains(iElementType)) {
                firElement = this.convertQualifiedExpression(expression2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CALL_EXPRESSION)) {
                firElement = this.convertCallExpression(expression2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.WHEN)) {
                firElement = this.convertWhenExpression(expression2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.ARRAY_ACCESS_EXPRESSION)) {
                firElement = this.convertArrayAccessExpression(expression2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.COLLECTION_LITERAL_EXPRESSION)) {
                firElement = this.convertCollectionLiteralExpression(expression2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.STRING_TEMPLATE)) {
                firElement = this.convertStringTemplate(expression2);
            } else if (iElementType instanceof KtConstantExpressionElementType) {
                firElement = this.convertConstantExpression(expression2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.REFERENCE_EXPRESSION)) {
                firElement = this.convertSimpleNameExpression(expression2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.DO_WHILE)) {
                firElement = this.convertDoWhile(expression2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.WHILE)) {
                firElement = this.convertWhile(expression2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FOR)) {
                firElement = this.convertFor(expression2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.TRY)) {
                firElement = this.convertTryExpression(expression2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.IF)) {
                firElement = this.convertIfExpression(expression2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BREAK) || Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CONTINUE)) {
                firElement = this.convertLoopJump(expression2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.RETURN)) {
                firElement = this.convertReturn(expression2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.THROW)) {
                firElement = this.convertThrow(expression2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PARENTHESIZED)) {
                FirElement firElement2;
                FirElement firElement3;
                void expression$iv;
                ExpressionsConverter lambdaTree = this;
                LighterASTNode lighterASTNode3 = this.getExpressionInParentheses(expression2);
                String errorReason$iv = "Empty parentheses";
                boolean $i$f$getAsFirExpression = false;
                void v3 = expression$iv;
                if (v3 != null) {
                    void this_$iv;
                    void var8_18 = v3;
                    boolean bl = false;
                    boolean bl2 = false;
                    void it$iv = var8_18;
                    boolean bl3 = false;
                    firElement3 = this_$iv.convertExpression((LighterASTNode)it$iv, errorReason$iv);
                } else {
                    firElement3 = firElement2 = null;
                }
                if (!(firElement3 instanceof FirElement)) {
                    firElement2 = firElement = null;
                }
                if (firElement2 == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirElement");
                    }
                    firElement = firErrorExpression;
                }
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PROPERTY_DELEGATE) || Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.INDICES) || Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CONDITION) || Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.LOOP_RANGE)) {
                FirElement firElement4;
                FirElement firElement5;
                ExpressionsConverter this_$iv = this;
                LighterASTNode expression$iv = this.getExpressionInParentheses(expression2);
                boolean $i$f$getAsFirExpression = false;
                LighterASTNode lighterASTNode4 = expression$iv;
                if (lighterASTNode4 != null) {
                    LighterASTNode lighterASTNode5 = lighterASTNode4;
                    boolean bl = false;
                    boolean bl4 = false;
                    LighterASTNode it$iv = lighterASTNode5;
                    boolean bl5 = false;
                    firElement5 = this_$iv.convertExpression(it$iv, errorReason);
                } else {
                    firElement5 = firElement4 = null;
                }
                if (!(firElement5 instanceof FirElement)) {
                    firElement4 = firElement = null;
                }
                if (firElement4 == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason, DiagnosticKind.ExpressionRequired));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirElement");
                    }
                    firElement = firErrorExpression;
                }
            } else {
                firElement = Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.THIS_EXPRESSION) ? (FirElement)this.convertThisExpression(expression2) : (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.SUPER_EXPRESSION) ? (FirElement)this.convertSuperExpression(expression2) : (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.OBJECT_LITERAL) ? this.declarationsConverter.convertObjectLiteral(expression2) : (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FUN) ? (FirElement)DeclarationsConverter.convertFunctionDeclaration$default(this.declarationsConverter, expression2, null, 2, null) : (FirElement)FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason, DiagnosticKind.ExpressionRequired)))));
            }
            return firElement;
        }
        boolean $i$f$buildExpressionStub = false;
        boolean bl = false;
        FirExpressionStubBuilder firExpressionStubBuilder = new FirExpressionStubBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirExpressionStubBuilder $receiver = firExpressionStubBuilder;
        return firExpressionStubBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertLambdaExpression(LighterASTNode lambdaExpression) {
        FirBlock firBlock;
        FirValueParameterBuilder firValueParameterBuilder;
        boolean bl;
        boolean bl2;
        Object object;
        boolean $i$f$buildValueParameter232;
        FirLabel firLabel;
        boolean bl322;
        boolean bl3;
        boolean bl4;
        Object object2;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        boolean bl6 = false;
        List valueParameterList = new ArrayList();
        LighterASTNode block = null;
        IElementType iElementType = KtNodeTypes.FUNCTION_LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"FUNCTION_LITERAL");
        LighterASTNode lighterASTNode2 = (LighterASTNode)CollectionsKt.first(this.getChildNodesByType(lambdaExpression, iElementType));
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode lighterASTNode3 : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (lighterASTNode3 == null) break;
            IElementType tokenType$iv = lighterASTNode3.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it2 = lighterASTNode3;
            boolean bl7 = false;
            object2 = it2.getTokenType();
            if (Intrinsics.areEqual((Object)object2, (Object)KtNodeTypes.VALUE_PARAMETER_LIST)) {
                Collection collection = valueParameterList;
                Iterable iterable = this.declarationsConverter.convertValueParameters(it2);
                bl4 = false;
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                continue;
            }
            if (!Intrinsics.areEqual((Object)object2, (Object)KtNodeTypes.BLOCK)) continue;
            block = it2;
        }
        FirLightSourceElement expressionSource = (FirLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, lambdaExpression, null, 1, null);
        FirFunctionTarget target = null;
        boolean $i$f$buildAnonymousFunction = false;
        boolean bl8 = false;
        FirAnonymousFunctionBuilder firAnonymousFunctionBuilder = new FirAnonymousFunctionBuilder();
        boolean bl9 = false;
        boolean bl10 = false;
        FirAnonymousFunctionBuilder $this$buildAnonymousFunction = firAnonymousFunctionBuilder;
        boolean bl11 = false;
        $this$buildAnonymousFunction.setSource(expressionSource);
        $this$buildAnonymousFunction.setSession(this.getBaseSession());
        $this$buildAnonymousFunction.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
        $this$buildAnonymousFunction.setReturnTypeRef(this.getImplicitType());
        $this$buildAnonymousFunction.setReceiverTypeRef(this.getImplicitType());
        $this$buildAnonymousFunction.setSymbol(new FirAnonymousFunctionSymbol());
        $this$buildAnonymousFunction.setLambda(true);
        Object object3 = $this$buildAnonymousFunction;
        FirLabel firLabel2 = this.pop(this.getContext().getFirLabels());
        if (firLabel2 == null) {
            Name name = (Name)CollectionsKt.lastOrNull(this.getContext().getCalleeNamesForLambda());
            if (name != null) {
                void it;
                Name name2 = name;
                boolean tokenType$iv = false;
                boolean it2 = false;
                Name bl7 = name2;
                object2 = object3;
                boolean bl12 = false;
                boolean $i$f$buildLabel = false;
                bl4 = false;
                FirLabelBuilder firLabelBuilder = new FirLabelBuilder();
                boolean bl5 = false;
                bl3 = false;
                FirLabelBuilder $this$buildLabel = firLabelBuilder;
                bl322 = false;
                String string2 = it.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.asString()");
                $this$buildLabel.setName(string2);
                firLabel = firLabelBuilder.build();
                object3 = object2;
                firLabel2 = firLabel;
            } else {
                firLabel2 = null;
            }
        }
        ((FirAnonymousFunctionBuilder)object3).setLabel(firLabel2);
        FirLabel firLabel3 = $this$buildAnonymousFunction.getLabel();
        target = new FirFunctionTarget(firLabel3 != null ? firLabel3.getName() : null, true);
        Collection collection = this.getContext().getFirFunctionTargets();
        FirFunctionTarget tokenType$iv = target;
        boolean it2 = false;
        collection.add(tokenType$iv);
        FirExpression firExpression2 = null;
        for (Object valueParameter : valueParameterList) {
            FirValueParameter firValueParameter;
            Object name;
            DestructuringDeclaration multiDeclaration = ((ValueParameter)valueParameter).getDestructuringDeclaration();
            Collection bl12 = $this$buildAnonymousFunction.getValueParameters();
            if (multiDeclaration != null) {
                Name name3 = Name.special("<destruct>");
                Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"Name.special(\"<destruct>\")");
                name = name3;
                $i$f$buildValueParameter232 = false;
                bl3 = false;
                FirValueParameterBuilder firValueParameterBuilder2 = new FirValueParameterBuilder();
                boolean bl7 = false;
                bl322 = false;
                FirValueParameterBuilder $this$buildValueParameter = firValueParameterBuilder2;
                boolean bl15 = false;
                $this$buildValueParameter.setSession(this.getBaseSession());
                $this$buildValueParameter.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                boolean $i$f$buildImplicitTypeRef = false;
                boolean bl13 = false;
                object = new FirImplicitTypeRefBuilder();
                bl2 = false;
                bl = false;
                FirImplicitTypeRefBuilder firImplicitTypeRefBuilder = object;
                firValueParameterBuilder = $this$buildValueParameter;
                Unit unit = Unit.INSTANCE;
                firValueParameterBuilder.setReturnTypeRef(((FirImplicitTypeRefBuilder)object).build());
                $this$buildValueParameter.setName((Name)name);
                $this$buildValueParameter.setSymbol(new FirVariableSymbol<FirValueParameter>((Name)name));
                $this$buildValueParameter.setDefaultValue(null);
                $this$buildValueParameter.setCrossinline(false);
                $this$buildValueParameter.setNoinline(false);
                $this$buildValueParameter.setVararg(false);
                FirValueParameter multiParameter = firValueParameterBuilder2.build();
                FirExpression firExpression3 = ConverterUtilKt.generateDestructuringBlock(this.getBaseSession(), multiDeclaration, multiParameter, false);
                firValueParameter = multiParameter;
            } else {
                firValueParameter = ((ValueParameter)valueParameter).getFirValueParameter();
            }
            name = firValueParameter;
            boolean multiParameter = false;
            bl12.add(name);
        }
        Object object4 = $this$buildAnonymousFunction;
        if (block != null) {
            void var12_27;
            void $this$apply;
            Object valueParameter;
            LighterASTNode lighterASTNode4 = block;
            Intrinsics.checkNotNull((Object)lighterASTNode4);
            valueParameter = this.declarationsConverter.convertBlockExpressionWithoutBuilding(lighterASTNode4);
            it2 = false;
            boolean bl14 = false;
            Object bl12 = valueParameter;
            object2 = object4;
            boolean bl18 = false;
            if ($this$apply.getStatements().isEmpty()) {
                void $this$buildUnitExpression;
                void $this$buildReturnExpression;
                boolean $i$f$buildReturnExpression = false;
                $i$f$buildValueParameter232 = false;
                FirReturnExpressionBuilder $i$f$buildValueParameter232 = new FirReturnExpressionBuilder();
                bl3 = false;
                boolean bl15 = false;
                FirReturnExpressionBuilder bl322 = $i$f$buildValueParameter232;
                List<FirStatement> list2 = $this$apply.getStatements();
                boolean bl20 = false;
                $this$buildReturnExpression.setSource(expressionSource);
                $this$buildReturnExpression.setTarget(target);
                boolean $i$f$buildUnitExpression = false;
                boolean bl16 = false;
                object = new FirUnitExpressionBuilder();
                bl2 = false;
                bl = false;
                Object $receiver = object;
                firValueParameterBuilder = $this$buildReturnExpression;
                boolean bl22 = false;
                $this$buildUnitExpression.setSource(expressionSource);
                Unit unit = Unit.INSTANCE;
                ((FirReturnExpressionBuilder)((Object)firValueParameterBuilder)).setResult(((FirUnitExpressionBuilder)object).build());
                Unit unit2 = Unit.INSTANCE;
                list2.add($i$f$buildValueParameter232.build());
            }
            if (var12_27 instanceof FirBlock) {
                boolean $i$f$buildReturnExpression = false;
                for (FirStatement statement2 : (Iterable)((FirBlock)var12_27).getStatements()) {
                    void index2;
                    $this$apply.getStatements().add((int)index2, statement2);
                    ++index2;
                }
            }
            firLabel = Unit.INSTANCE;
            object4 = object2;
            firBlock = ((FirBlockBuilder)valueParameter).build();
        } else {
            FirStatement statement$iv = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("Lambda has no body", DiagnosticKind.Syntax));
            boolean $i$f$buildSingleExpressionBlock = false;
            firBlock = new FirSingleExpressionBlock(statement$iv);
        }
        ((FirAnonymousFunctionBuilder)object4).setBody(firBlock);
        this.removeLast(this.getContext().getFirFunctionTargets());
        FirAnonymousFunction firAnonymousFunction = firAnonymousFunctionBuilder.build();
        boolean bl23 = false;
        bl9 = false;
        FirAnonymousFunction it = firAnonymousFunction;
        boolean bl24 = false;
        target.bind((FirTargetElement)it);
        return firAnonymousFunction;
    }

    /*
     * WARNING - void declaration
     */
    private final FirStatement convertBinaryExpression(LighterASTNode binaryExpression) {
        FirStatement firStatement;
        boolean bl;
        FirElement firElement;
        FirElement firElement2;
        FirElement firElement3;
        IElementType this_$iv;
        void expression$iv;
        FirExpression firExpression2;
        ExpressionsConverter expression$iv2;
        Object errorReason$iv;
        IElementType operationToken;
        void $this$forEachChildren$iv;
        void this_$iv2;
        Object kidsArray$iv2;
        boolean isLeftArgument = true;
        String operationTokenName = null;
        LighterASTNode leftArgNode = null;
        LighterASTNode rightArg = null;
        FirLightSourceElement operationReferenceSource = null;
        LighterASTNode lighterASTNode2 = binaryExpression;
        BaseConverter baseConverter = this;
        Object skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren2 = false;
        for (LighterASTNode kid$iv : kidsArray$iv2 = this_$iv2.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl2 = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.OPERATION_REFERENCE)) {
                isLeftArgument = false;
                operationTokenName = this.getAsText(it);
                operationReferenceSource = (FirLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null);
                continue;
            }
            if (!ConverterUtilKt.isExpression(it)) continue;
            if (isLeftArgument) {
                leftArgNode = it;
                continue;
            }
            rightArg = it;
        }
        FirLightSourceElement baseSource = (FirLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, binaryExpression, null, 1, null);
        String string2 = operationTokenName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"operationTokenName");
        }
        if (Intrinsics.areEqual((Object)(operationToken = ConverterUtilKt.getOperationSymbol(string2)), (Object)KtTokens.IDENTIFIER)) {
            skipTokens$iv = this.getContext().getCalleeNamesForLambda();
            Name $i$f$forEachChildren2 = ConverterUtilKt.nameAsSafeName$default(operationTokenName, null, 1, null);
            boolean kidsArray$iv2 = false;
            skipTokens$iv.add($i$f$forEachChildren2);
        }
        if (rightArg != null) {
            FirElement firElement4;
            FirElement firElement5;
            FirElement firElement6;
            ExpressionsConverter $i$f$forEachChildren2 = this;
            kidsArray$iv2 = rightArg;
            errorReason$iv = "No right operand";
            boolean $i$f$getAsFirExpression = false;
            void v1 = expression$iv2;
            if (v1 != null) {
                void this_$iv3;
                void var14_24 = v1;
                boolean bl3 = false;
                boolean tokenType$iv = false;
                void it$iv = var14_24;
                boolean bl4 = false;
                firElement6 = this_$iv3.convertExpression((LighterASTNode)it$iv, (String)errorReason$iv);
            } else {
                firElement6 = firElement5 = null;
            }
            if (!(firElement6 instanceof FirExpression)) {
                firElement5 = null;
            }
            if ((firElement4 = (FirElement)((FirExpression)firElement5)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic((String)errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement4 = firErrorExpression;
            }
            firExpression2 = (FirExpression)firElement4;
        } else {
            firExpression2 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No right operand", DiagnosticKind.Syntax));
        }
        FirExpression rightArgAsFir = firExpression2;
        expression$iv2 = this;
        errorReason$iv = leftArgNode;
        String errorReason$iv222 = "No left operand";
        boolean $i$f$getAsFirExpression = false;
        void v7 = expression$iv;
        if (v7 != null) {
            void var15_29 = v7;
            boolean tokenType$iv = false;
            boolean it$iv = false;
            void it$iv2 = var15_29;
            boolean bl5 = false;
            firElement3 = ((ExpressionsConverter)((Object)this_$iv)).convertExpression((LighterASTNode)it$iv2, errorReason$iv222);
        } else {
            firElement3 = firElement2 = null;
        }
        if (!(firElement3 instanceof FirExpression)) {
            firElement2 = null;
        }
        if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv222, DiagnosticKind.ExpressionRequired));
            if (firErrorExpression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
            }
            firElement = firErrorExpression;
        }
        FirExpression leftArgAsFir = (FirExpression)firElement;
        if (Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.IDENTIFIER)) {
            this.removeLast(this.getContext().getCalleeNamesForLambda());
        }
        if (Intrinsics.areEqual((Object)(this_$iv = operationToken), (Object)KtTokens.ELVIS)) {
            return ConversionUtilsKt.generateNotNullOrOther(leftArgAsFir, rightArgAsFir, baseSource);
        }
        if (Intrinsics.areEqual((Object)this_$iv, (Object)KtTokens.ANDAND) || Intrinsics.areEqual((Object)this_$iv, (Object)KtTokens.OROR)) {
            return ConversionUtilsKt.generateLazyLogicalOperation(leftArgAsFir, rightArgAsFir, Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.ANDAND), baseSource);
        }
        ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.IN_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"OperatorConventions.IN_OPERATIONS");
        if (CollectionsKt.contains((Iterable)immutableSet, (Object)this_$iv)) {
            return ConversionUtilsKt.generateContainsOperation(rightArgAsFir, leftArgAsFir, Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.NOT_IN), baseSource, operationReferenceSource);
        }
        ImmutableSet<KtSingleValueToken> immutableSet2 = OperatorConventions.COMPARISON_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(immutableSet2, (String)"OperatorConventions.COMPARISON_OPERATIONS");
        if (CollectionsKt.contains((Iterable)immutableSet2, (Object)this_$iv)) {
            return ConversionUtilsKt.generateComparisonExpression(leftArgAsFir, rightArgAsFir, operationToken, baseSource, operationReferenceSource);
        }
        Name conventionCallName = ConversionUtilsKt.toBinaryName(operationToken);
        if (conventionCallName != null || Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.IDENTIFIER)) {
            void $this$buildSimpleNamedReference;
            boolean $i$f$buildFunctionCall = false;
            boolean errorReason$iv222 = false;
            FirFunctionCallBuilder errorReason$iv222 = new FirFunctionCallBuilder();
            bl = false;
            boolean bl6 = false;
            FirFunctionCallBuilder $this$buildFunctionCall = errorReason$iv222;
            boolean bl7 = false;
            $this$buildFunctionCall.setSource(BaseFirBuilder.toFirSourceElement$default(this, binaryExpression, null, 1, null));
            boolean $i$f$buildSimpleNamedReference = false;
            boolean bl8 = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
            boolean bl9 = false;
            boolean bl10 = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder;
            FirFunctionCallBuilder firFunctionCallBuilder = $this$buildFunctionCall;
            boolean bl11 = false;
            $this$buildSimpleNamedReference.setSource($this$buildFunctionCall.getSource());
            Name name = conventionCallName;
            if (name == null) {
                name = ConverterUtilKt.nameAsSafeName$default(operationTokenName, null, 1, null);
            }
            $this$buildSimpleNamedReference.setName(name);
            Unit unit = Unit.INSTANCE;
            firFunctionCallBuilder.setCalleeReference(firSimpleNamedReferenceBuilder.build());
            $this$buildFunctionCall.setExplicitReceiver(leftArgAsFir);
            $this$buildFunctionCall.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(rightArgAsFir));
            firStatement = errorReason$iv222.build();
        } else {
            FirOperation firOperation = ConversionUtilsKt.toFirOperation(operationToken);
            if (FirOperation.Companion.getASSIGNMENTS().contains((Object)firOperation)) {
                return this.generateAssignment(leftArgNode, BaseFirBuilder.toFirSourceElement$default(this, binaryExpression, null, 1, null), rightArg, rightArgAsFir, firOperation, (Function1)new Function1<LighterASTNode, FirExpression>(this){
                    final /* synthetic */ ExpressionsConverter this$0;

                    @NotNull
                    public final FirExpression invoke(@NotNull LighterASTNode $this$generateAssignment) {
                        FirElement firElement;
                        Intrinsics.checkNotNullParameter((Object)$this$generateAssignment, (String)"$receiver");
                        ExpressionsConverter this_$iv = this.this$0;
                        String errorReason$iv = "";
                        boolean $i$f$getAsFirExpression = false;
                        LighterASTNode lighterASTNode2 = $this$generateAssignment;
                        boolean bl = false;
                        boolean bl2 = false;
                        LighterASTNode it$iv = lighterASTNode2;
                        boolean bl3 = false;
                        FirElement firElement2 = this_$iv.convertExpression(it$iv, errorReason$iv);
                        if (!(firElement2 instanceof FirExpression)) {
                            firElement2 = null;
                        }
                        if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                            if (firErrorExpression == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                            }
                            firElement = firErrorExpression;
                        }
                        return (FirExpression)firElement;
                    }
                    {
                        this.this$0 = expressionsConverter;
                        super(1);
                    }
                });
            }
            boolean $i$f$buildEqualityOperatorCall = false;
            bl = false;
            FirEqualityOperatorCallBuilder firEqualityOperatorCallBuilder = new FirEqualityOperatorCallBuilder();
            boolean bl12 = false;
            boolean bl13 = false;
            FirEqualityOperatorCallBuilder $this$buildEqualityOperatorCall = firEqualityOperatorCallBuilder;
            boolean bl14 = false;
            $this$buildEqualityOperatorCall.setSource(BaseFirBuilder.toFirSourceElement$default(this, binaryExpression, null, 1, null));
            $this$buildEqualityOperatorCall.setOperation(firOperation);
            $this$buildEqualityOperatorCall.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(leftArgAsFir, rightArgAsFir));
            firStatement = firEqualityOperatorCallBuilder.build();
        }
        return firStatement;
    }

    /*
     * WARNING - void declaration
     */
    private final FirTypeOperatorCall convertBinaryWithTypeRHSExpression(LighterASTNode binaryExpression, Function1<? super String, ? extends FirOperation> toFirOperation) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        String operationTokenName = null;
        FirExpression leftArgAsFir = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No left operand", DiagnosticKind.Syntax));
        FirTypeRef firType = null;
        LighterASTNode lighterASTNode2 = binaryExpression;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.OPERATION_REFERENCE)) {
                operationTokenName = this.getAsText(it);
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.TYPE_REFERENCE)) {
                firType = this.declarationsConverter.convertType(it);
                continue;
            }
            if (!ConverterUtilKt.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "No left operand";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode3 = it;
            boolean bl2 = false;
            boolean bl3 = false;
            LighterASTNode it$iv = lighterASTNode3;
            boolean bl4 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            leftArgAsFir = (FirExpression)firElement;
        }
        boolean $i$f$buildTypeOperatorCall = false;
        boolean bl = false;
        FirTypeOperatorCallBuilder firTypeOperatorCallBuilder = new FirTypeOperatorCallBuilder();
        boolean bl5 = false;
        boolean bl6 = false;
        FirTypeOperatorCallBuilder $this$buildTypeOperatorCall = firTypeOperatorCallBuilder;
        boolean bl7 = false;
        $this$buildTypeOperatorCall.setSource(BaseFirBuilder.toFirSourceElement$default(this, binaryExpression, null, 1, null));
        String string2 = operationTokenName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"operationTokenName");
        }
        $this$buildTypeOperatorCall.setOperation((FirOperation)((Object)toFirOperation.invoke(string2)));
        FirTypeRef firTypeRef = firType;
        if (firTypeRef == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"firType");
        }
        $this$buildTypeOperatorCall.setConversionTypeRef(firTypeRef);
        $this$buildTypeOperatorCall.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(leftArgAsFir));
        return firTypeOperatorCallBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirElement convertLabeledExpression(LighterASTNode labeledExpression) {
        FirElement firElement;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        int size = this.getContext().getFirLabels().size();
        FirElement firExpression2 = null;
        LighterASTNode lighterASTNode2 = labeledExpression;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement2;
            boolean bl;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl2 = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.LABEL_QUALIFIER)) {
                Collection collection = this.getContext().getFirLabels();
                boolean $i$f$buildLabel22 = false;
                boolean bl3 = false;
                FirLabelBuilder firLabelBuilder = new FirLabelBuilder();
                boolean bl4 = false;
                bl = false;
                FirLabelBuilder $this$buildLabel = firLabelBuilder;
                boolean bl5 = false;
                $this$buildLabel.setName(StringsKt.replace$default((String)it.toString(), (String)"@", (String)"", (boolean)false, (int)4, null));
                FirLabel $i$f$buildLabel22 = firLabelBuilder.build();
                bl3 = false;
                collection.add($i$f$buildLabel22);
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BLOCK)) {
                firExpression2 = this.declarationsConverter.convertBlock(it);
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PROPERTY)) {
                firExpression2 = DeclarationsConverter.convertPropertyDeclaration$default(this.declarationsConverter, it, null, 2, null);
                continue;
            }
            if (!ConverterUtilKt.isExpression(it)) continue;
            ExpressionsConverter this_$iv2 = this;
            String errorReason$iv = "";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode3 = it;
            bl = false;
            boolean bl6 = false;
            LighterASTNode it$iv = lighterASTNode3;
            boolean bl7 = false;
            FirElement firElement3 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement3 instanceof FirElement)) {
                firElement3 = firElement2 = null;
            }
            if (firElement3 == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirElement");
                }
                firElement2 = firErrorExpression;
            }
            firExpression2 = firElement2;
        }
        if (size != this.getContext().getFirLabels().size()) {
            this.removeLast(this.getContext().getFirLabels());
        }
        if ((firElement = firExpression2) == null) {
            firElement = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("Empty label", DiagnosticKind.Syntax));
        }
        return firElement;
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertUnaryExpression(LighterASTNode unaryExpression) {
        FirExpression firExpression2;
        IElementType bl10;
        boolean bl;
        Object tokenType$iv;
        void $this$forEachChildren$iv;
        void this_$iv;
        Object kidsArray$iv22;
        String operationTokenName = null;
        LighterASTNode argument = null;
        LighterASTNode operationReference = null;
        LighterASTNode lighterASTNode2 = unaryExpression;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren22 = false;
        for (LighterASTNode lighterASTNode3 : kidsArray$iv22 = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (lighterASTNode3 == null) break;
            tokenType$iv = lighterASTNode3.getTokenType();
            if (KtTokens.COMMENTS.contains((IElementType)tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it = lighterASTNode3;
            bl = false;
            bl10 = it.getTokenType();
            if (Intrinsics.areEqual((Object)bl10, (Object)KtNodeTypes.OPERATION_REFERENCE)) {
                operationReference = it;
                operationTokenName = this.getAsText(it);
                continue;
            }
            if (!ConverterUtilKt.isExpression(it)) continue;
            argument = it;
        }
        String string2 = operationTokenName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"operationTokenName");
        }
        IElementType operationToken = ConverterUtilKt.getOperationSymbol(string2);
        Name conventionCallName = ConversionUtilsKt.toUnaryName(operationToken);
        if (Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.EXCLEXCL)) {
            FirElement firElement;
            FirElement firElement2;
            FirElement firElement3;
            void expression$iv2;
            boolean $i$f$buildCheckNotNullCall = false;
            $i$f$forEachChildren22 = false;
            FirCheckNotNullCallBuilder $i$f$forEachChildren22 = new FirCheckNotNullCallBuilder();
            boolean kidsArray$iv22 = false;
            boolean bl2 = false;
            FirCheckNotNullCallBuilder $this$buildCheckNotNullCall = $i$f$forEachChildren22;
            boolean bl22 = false;
            $this$buildCheckNotNullCall.setSource(BaseFirBuilder.toFirSourceElement$default(this, unaryExpression, null, 1, null));
            ExpressionsConverter expressionsConverter = this;
            tokenType$iv = argument;
            String errorReason$iv = "No operand";
            boolean $i$f$getAsFirExpression = false;
            void v1 = expression$iv2;
            if (v1 != null) {
                bl10 = v1;
                boolean firSimpleNamedReferenceBuilder2 = false;
                boolean firFunctionCallBuilder2 = false;
                IElementType it$iv = bl10;
                boolean bl5 = false;
                firElement3 = expressionsConverter.convertExpression((LighterASTNode)((Object)it$iv), errorReason$iv);
            } else {
                firElement3 = firElement2 = null;
            }
            if (!(firElement3 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            $this$buildCheckNotNullCall.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList((FirExpression)firElement));
            firExpression2 = $i$f$forEachChildren22.build();
        } else if (conventionCallName != null) {
            void $this$buildSimpleNamedReference;
            FirElement firElement;
            FirElement firElement4;
            FirElement firElement5;
            void expression$iv;
            ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.INCREMENT_OPERATIONS;
            Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"OperatorConventions.INCREMENT_OPERATIONS");
            if (CollectionsKt.contains((Iterable)immutableSet, (Object)operationToken)) {
                return this.generateIncrementOrDecrementBlock(unaryExpression, operationReference, argument, conventionCallName, Intrinsics.areEqual((Object)unaryExpression.getTokenType(), (Object)KtNodeTypes.PREFIX_EXPRESSION), (Function1)new Function1<LighterASTNode, FirExpression>(this){
                    final /* synthetic */ ExpressionsConverter this$0;

                    @NotNull
                    public final FirExpression invoke(@NotNull LighterASTNode $this$generateIncrementOrDecrementBlock) {
                        FirElement firElement;
                        Intrinsics.checkNotNullParameter((Object)$this$generateIncrementOrDecrementBlock, (String)"$receiver");
                        ExpressionsConverter this_$iv = this.this$0;
                        String errorReason$iv = "";
                        boolean $i$f$getAsFirExpression = false;
                        LighterASTNode lighterASTNode2 = $this$generateIncrementOrDecrementBlock;
                        boolean bl = false;
                        boolean bl2 = false;
                        LighterASTNode it$iv = lighterASTNode2;
                        boolean bl3 = false;
                        FirElement firElement2 = this_$iv.convertExpression(it$iv, errorReason$iv);
                        if (!(firElement2 instanceof FirExpression)) {
                            firElement2 = null;
                        }
                        if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                            if (firErrorExpression == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                            }
                            firElement = firErrorExpression;
                        }
                        return (FirExpression)firElement;
                    }
                    {
                        this.this$0 = expressionsConverter;
                        super(1);
                    }
                });
            }
            ExpressionsConverter $i$f$forEachChildren22 = this;
            kidsArray$iv22 = argument;
            String errorReason$iv = "No operand";
            boolean $i$f$getAsFirExpression = false;
            void v8 = expression$iv;
            if (v8 != null) {
                void this_$iv3;
                void bl22 = v8;
                boolean bl3 = false;
                boolean expression$iv2 = false;
                void it$iv = bl22;
                bl = false;
                firElement5 = this_$iv3.convertExpression((LighterASTNode)it$iv, errorReason$iv);
            } else {
                firElement5 = firElement4 = null;
            }
            if (!(firElement5 instanceof FirExpression)) {
                firElement4 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement4)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            FirExpression receiver = (FirExpression)firElement;
            if ((Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.PLUS) || Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.MINUS)) && receiver instanceof FirConstExpression && Intrinsics.areEqual(((FirConstExpression)receiver).getKind(), (Object)FirConstKind.IntegerLiteral.INSTANCE)) {
                long l;
                Object t = ((FirConstExpression)receiver).getValue();
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                }
                long value2 = (Long)t;
                IElementType bl22 = operationToken;
                if (Intrinsics.areEqual((Object)bl22, (Object)KtTokens.MINUS)) {
                    l = -value2;
                } else if (Intrinsics.areEqual((Object)bl22, (Object)KtTokens.PLUS)) {
                    l = value2;
                } else {
                    String string3 = "Should not be here";
                    boolean expression$iv2 = false;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
                long convertedValue = l;
                return FirConstExpressionBuilderKt.buildConstExpression$default(BaseFirBuilder.toFirSourceElement$default(this, unaryExpression, null, 1, null), FirConstKind.IntegerLiteral.INSTANCE, convertedValue, null, 8, null);
            }
            boolean $i$f$buildFunctionCall = false;
            boolean bl4 = false;
            FirFunctionCallBuilder firFunctionCallBuilder = new FirFunctionCallBuilder();
            boolean bl6 = false;
            int n = 0;
            FirFunctionCallBuilder $this$buildFunctionCall = firFunctionCallBuilder;
            boolean bl5 = false;
            $this$buildFunctionCall.setSource(BaseFirBuilder.toFirSourceElement$default(this, unaryExpression, null, 1, null));
            boolean $i$f$buildSimpleNamedReference = false;
            boolean firSimpleNamedReferenceBuilder = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = new FirSimpleNamedReferenceBuilder();
            boolean bl7 = false;
            boolean bl8 = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder3 = firSimpleNamedReferenceBuilder2;
            FirFunctionCallBuilder firFunctionCallBuilder2 = $this$buildFunctionCall;
            boolean bl11 = false;
            $this$buildSimpleNamedReference.setSource($this$buildFunctionCall.getSource());
            $this$buildSimpleNamedReference.setName(conventionCallName);
            Unit unit = Unit.INSTANCE;
            firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder2.build());
            $this$buildFunctionCall.setExplicitReceiver(receiver);
            firExpression2 = firFunctionCallBuilder.build();
        } else {
            throw (Throwable)new IllegalStateException("Unexpected expression: " + this.getAsText(unaryExpression));
        }
        return firExpression2;
    }

    /*
     * WARNING - void declaration
     */
    private final FirElement convertAnnotatedExpression(LighterASTNode annotatedExpression) {
        Object object;
        block12: {
            FirElement firExpression2;
            block11: {
                void $this$forEachChildren$iv;
                void this_$iv;
                LighterASTNode[] kidsArray$iv;
                firExpression2 = null;
                boolean bl = false;
                List firAnnotationList = new ArrayList();
                LighterASTNode lighterASTNode2 = annotatedExpression;
                Object object2 = this;
                Object[] skipTokens$iv = new KtToken[]{};
                boolean $i$f$forEachChildren = false;
                for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
                    FirElement firElement;
                    boolean bl2;
                    Object object3;
                    Collection collection;
                    if (kid$iv == null) break;
                    IElementType tokenType$iv = kid$iv.getTokenType();
                    if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
                    LighterASTNode it = kid$iv;
                    boolean bl3 = false;
                    IElementType iElementType = it.getTokenType();
                    if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.ANNOTATION)) {
                        collection = firAnnotationList;
                        object3 = this.declarationsConverter.convertAnnotation(it);
                        bl2 = false;
                        CollectionsKt.addAll((Collection)collection, (Iterable)object3);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.ANNOTATION_ENTRY)) {
                        collection = firAnnotationList;
                        object3 = DeclarationsConverter.convertAnnotationEntry$default(this.declarationsConverter, it, null, 2, null);
                        bl2 = false;
                        collection.add(object3);
                        continue;
                    }
                    if (!ConverterUtilKt.isExpression(it)) continue;
                    ExpressionsConverter this_$iv2 = this;
                    String errorReason$iv = "";
                    boolean $i$f$getAsFirExpression = false;
                    LighterASTNode lighterASTNode3 = it;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    LighterASTNode it$iv = lighterASTNode3;
                    boolean bl6 = false;
                    FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
                    if (!(firElement2 instanceof FirElement)) {
                        firElement2 = firElement = null;
                    }
                    if (firElement2 == null) {
                        FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                        if (firErrorExpression == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirElement");
                        }
                        firElement = firErrorExpression;
                    }
                    firExpression2 = firElement;
                }
                object = firExpression2;
                if (object == null) break block11;
                object2 = object;
                boolean bl7 = false;
                boolean bl8 = false;
                Object it = object2;
                boolean bl9 = false;
                boolean bl10 = it instanceof FirAnnotationContainer;
                int n = 0;
                int n2 = 0;
                n2 = 0;
                boolean bl11 = false;
                if (!bl10) {
                    boolean bl12 = false;
                    String string2 = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string2.toString());
                }
                List<FirAnnotationCall> list2 = ((FirAnnotationContainer)it).getAnnotations();
                if (list2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<org.jetbrains.kotlin.fir.expressions.FirAnnotationCall>");
                }
                Collection collection = TypeIntrinsics.asMutableList(list2);
                Iterable iterable = firAnnotationList;
                n2 = 0;
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                object = object2;
                if (object != null) break block12;
            }
            FirElement firElement = firExpression2;
            object = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("Strange annotated expression: " + (firElement != null ? FirRendererKt.render$default(firElement, null, 1, null) : null), DiagnosticKind.Syntax));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertClassLiteralExpression(LighterASTNode classLiteralExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        FirExpression firReceiverExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No receiver in class literal", DiagnosticKind.Syntax));
        LighterASTNode lighterASTNode2 = classLiteralExpression;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (!ConverterUtilKt.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "No receiver in class literal";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode3 = it;
            boolean bl2 = false;
            boolean bl3 = false;
            LighterASTNode it$iv = lighterASTNode3;
            boolean bl4 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firReceiverExpression = (FirExpression)firElement;
        }
        boolean $i$f$buildGetClassCall = false;
        boolean bl = false;
        FirGetClassCallBuilder firGetClassCallBuilder = new FirGetClassCallBuilder();
        boolean bl5 = false;
        boolean bl6 = false;
        FirGetClassCallBuilder $this$buildGetClassCall = firGetClassCallBuilder;
        boolean bl7 = false;
        $this$buildGetClassCall.setSource(BaseFirBuilder.toFirSourceElement$default(this, classLiteralExpression, null, 1, null));
        $this$buildGetClassCall.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(firReceiverExpression));
        return firGetClassCallBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertCallableReferenceExpression(LighterASTNode callableReferenceExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        boolean isReceiver = true;
        boolean hasQuestionMarkAtLHS = false;
        FirExpression firReceiverExpression = null;
        FirQualifiedAccess firCallableReference = null;
        LighterASTNode lighterASTNode2 = callableReferenceExpression;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.COLONCOLON)) {
                isReceiver = false;
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.QUEST)) {
                hasQuestionMarkAtLHS = true;
                continue;
            }
            if (!ConverterUtilKt.isExpression(it)) continue;
            if (isReceiver) {
                FirElement firElement;
                void this_$iv2;
                ExpressionsConverter expressionsConverter = this;
                String errorReason$iv = "Incorrect receiver expression";
                boolean $i$f$getAsFirExpression = false;
                LighterASTNode lighterASTNode3 = it;
                boolean bl2 = false;
                boolean bl3 = false;
                LighterASTNode it$iv = lighterASTNode3;
                boolean bl4 = false;
                FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
                if (!(firElement2 instanceof FirExpression)) {
                    firElement2 = null;
                }
                if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement = firErrorExpression;
                }
                firReceiverExpression = (FirExpression)firElement;
                continue;
            }
            firCallableReference = this.convertSimpleNameExpression(it);
        }
        boolean $i$f$buildCallableReferenceAccess = false;
        boolean bl = false;
        FirCallableReferenceAccessBuilder firCallableReferenceAccessBuilder = new FirCallableReferenceAccessBuilder();
        boolean bl5 = false;
        boolean bl6 = false;
        FirCallableReferenceAccessBuilder $this$buildCallableReferenceAccess = firCallableReferenceAccessBuilder;
        boolean bl7 = false;
        $this$buildCallableReferenceAccess.setSource(BaseFirBuilder.toFirSourceElement$default(this, callableReferenceExpression, null, 1, null));
        FirQualifiedAccess firQualifiedAccess = firCallableReference;
        if (firQualifiedAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"firCallableReference");
        }
        FirReference firReference = firQualifiedAccess.getCalleeReference();
        if (firReference == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.references.FirNamedReference");
        }
        $this$buildCallableReferenceAccess.setCalleeReference((FirNamedReference)firReference);
        $this$buildCallableReferenceAccess.setExplicitReceiver(firReceiverExpression);
        $this$buildCallableReferenceAccess.setHasQuestionMarkAtLHS(hasQuestionMarkAtLHS);
        return firCallableReferenceAccessBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertQualifiedExpression(LighterASTNode dotQualifiedExpression) {
        FirExpression firSelector;
        block12: {
            void $this$forEachChildren$iv;
            void this_$iv;
            LighterASTNode[] kidsArray$iv;
            boolean isSelector = false;
            boolean isSafe = false;
            firSelector = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("Qualified expression without selector", DiagnosticKind.Syntax));
            FirExpression firReceiver = null;
            LighterASTNode lighterASTNode2 = dotQualifiedExpression;
            Object object = this;
            Object[] skipTokens$iv = new KtToken[]{};
            boolean $i$f$forEachChildren = false;
            for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
                FirElement firElement;
                ExpressionsConverter this_$iv2;
                boolean bl;
                LighterASTNode it$iv;
                boolean bl2;
                boolean bl3;
                LighterASTNode lighterASTNode3;
                boolean $i$f$getAsFirExpression;
                String errorReason$iv;
                if (kid$iv == null) break;
                IElementType tokenType$iv = kid$iv.getTokenType();
                if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
                LighterASTNode it = kid$iv;
                boolean bl4 = false;
                IElementType iElementType = it.getTokenType();
                if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DOT)) {
                    isSelector = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.SAFE_ACCESS)) {
                    isSafe = true;
                    isSelector = true;
                    continue;
                }
                if (isSelector && Intrinsics.areEqual((Object)it.getTokenType(), (Object)TokenType.ERROR_ELEMENT) ^ true) {
                    FirElement firElement2;
                    ExpressionsConverter expressionsConverter = this;
                    errorReason$iv = "Incorrect selector expression";
                    $i$f$getAsFirExpression = false;
                    lighterASTNode3 = it;
                    bl3 = false;
                    bl2 = false;
                    it$iv = lighterASTNode3;
                    bl = false;
                    FirElement firElement3 = this_$iv2.convertExpression(it$iv, errorReason$iv);
                    if (!(firElement3 instanceof FirExpression)) {
                        firElement3 = null;
                    }
                    if ((firElement2 = (FirElement)((FirExpression)firElement3)) == null) {
                        FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                        if (firErrorExpression == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                        }
                        firElement2 = firErrorExpression;
                    }
                    firSelector = (FirExpression)firElement2;
                    continue;
                }
                this_$iv2 = this;
                errorReason$iv = "Incorrect receiver expression";
                $i$f$getAsFirExpression = false;
                lighterASTNode3 = it;
                bl3 = false;
                bl2 = false;
                it$iv = lighterASTNode3;
                bl = false;
                FirElement firElement4 = this_$iv2.convertExpression(it$iv, errorReason$iv);
                if (!(firElement4 instanceof FirExpression)) {
                    firElement4 = null;
                }
                if ((firElement = (FirElement)((FirExpression)firElement4)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement = firErrorExpression;
                }
                firReceiver = (FirExpression)firElement;
            }
            FirExpression firExpression2 = firSelector;
            if (!(firExpression2 instanceof FirQualifiedAccess)) {
                firExpression2 = null;
            }
            FirQualifiedAccess firQualifiedAccess = (FirQualifiedAccess)((Object)firExpression2);
            if (firQualifiedAccess == null) break block12;
            object = firQualifiedAccess;
            boolean bl = false;
            boolean bl5 = false;
            Object it = object;
            boolean bl6 = false;
            if (isSafe) {
                FirExpression firExpression3 = firReceiver;
                Intrinsics.checkNotNull((Object)firExpression3);
                return ConversionUtilsKt.wrapWithSafeCall((FirQualifiedAccess)it, firExpression3);
            }
            it.replaceExplicitReceiver(firReceiver);
        }
        return firSelector;
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertCallExpression(LighterASTNode callSuffix) {
        void explicitReceiver;
        FirQualifiedAccessBuilder builder2;
        FirQualifiedAccessBuilder firQualifiedAccessBuilder;
        FirQualifiedAccessBuilder firQualifiedAccessBuilder2;
        void calleeReference;
        Object $this$buildErrorNamedReference;
        boolean $i$f$buildErrorNamedReference;
        CalleeAndReceiver calleeAndReceiver;
        Unit unit;
        Object $this$buildSimpleNamedReference;
        boolean kid$iv2;
        int n;
        Object object;
        int n2;
        boolean $i$f$buildSimpleNamedReference;
        Object $fun$process$1;
        void hasArguments;
        void additionalArgument;
        void superNode;
        void name;
        FirNamedReference $this$forEachChildren$iv;
        void this_$iv;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        boolean bl = false;
        List firTypeArguments = new ArrayList();
        boolean bl2 = false;
        List valueArguments = new ArrayList();
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = null;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Ref.ObjectRef objectRef3 = new Ref.ObjectRef();
        objectRef3.element = null;
        LighterASTNode lighterASTNode2 = callSuffix;
        BaseConverter baseConverter = this;
        Object skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        Object kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)((Object)$this$forEachChildren$iv));
        for (LighterASTNode kid$iv2 : kidsArray$iv) {
            if (kid$iv2 == null) break;
            IElementType tokenType$iv = kid$iv2.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode child = kid$iv2;
            boolean bl3 = false;
            $fun$process$1 = new Function1<LighterASTNode, Unit>(this, (Ref.ObjectRef)name, (Ref.ObjectRef)superNode, (Ref.ObjectRef)additionalArgument, firTypeArguments, (Ref.BooleanRef)hasArguments, valueArguments){
                final /* synthetic */ ExpressionsConverter this$0;
                final /* synthetic */ Ref.ObjectRef $name$inlined;
                final /* synthetic */ Ref.ObjectRef $superNode$inlined;
                final /* synthetic */ Ref.ObjectRef $additionalArgument$inlined;
                final /* synthetic */ List $firTypeArguments$inlined;
                final /* synthetic */ Ref.BooleanRef $hasArguments$inlined;
                final /* synthetic */ List $valueArguments$inlined;
                {
                    this.this$0 = expressionsConverter;
                    this.$name$inlined = objectRef;
                    this.$superNode$inlined = objectRef2;
                    this.$additionalArgument$inlined = objectRef3;
                    this.$firTypeArguments$inlined = list2;
                    this.$hasArguments$inlined = booleanRef;
                    this.$valueArguments$inlined = list3;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull LighterASTNode node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    IElementType iElementType = node.getTokenType();
                    if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.REFERENCE_EXPRESSION)) {
                        this.$name$inlined.element = this.this$0.getAsText(node);
                    } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.SUPER_EXPRESSION)) {
                        this.$superNode$inlined.element = node;
                    } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PARENTHESIZED)) {
                        LighterASTNode lighterASTNode2 = this.this$0.getExpressionInParentheses(node);
                        if (lighterASTNode2 != null) {
                            LighterASTNode lighterASTNode3 = lighterASTNode2;
                            boolean bl = false;
                            boolean bl2 = false;
                            LighterASTNode it = lighterASTNode3;
                            boolean bl3 = false;
                            this.invoke(it);
                        } else {
                            FirElement firElement;
                            void this_$iv;
                            void expression$iv;
                            ExpressionsConverter expressionsConverter = this.this$0;
                            boolean bl = false;
                            boolean bl4 = false;
                            ExpressionsConverter $this$run = expressionsConverter;
                            boolean bl5 = false;
                            ExpressionsConverter expressionsConverter2 = $this$run;
                            LighterASTNode lighterASTNode4 = node;
                            String errorReason$iv = "Incorrect invoke receiver";
                            boolean $i$f$getAsFirExpression = false;
                            void var12_30 = expression$iv;
                            boolean bl6 = false;
                            boolean bl7 = false;
                            void it$iv = var12_30;
                            boolean bl8 = false;
                            FirElement firElement2 = this_$iv.convertExpression((LighterASTNode)it$iv, errorReason$iv);
                            if (!(firElement2 instanceof FirExpression)) {
                                firElement2 = null;
                            }
                            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                                if (firErrorExpression == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                                }
                                firElement = firErrorExpression;
                            }
                            this.$additionalArgument$inlined.element = (FirExpression)firElement;
                        }
                    } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.TYPE_ARGUMENT_LIST)) {
                        Collection collection = this.$firTypeArguments$inlined;
                        Iterable iterable = ExpressionsConverter.access$getDeclarationsConverter$p(this.this$0).convertTypeArguments(node);
                        boolean bl = false;
                        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                    } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.VALUE_ARGUMENT_LIST) || Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.LAMBDA_ARGUMENT)) {
                        this.$hasArguments$inlined.element = true;
                        Collection collection = this.$valueArguments$inlined;
                        boolean bl = false;
                        collection.add(node);
                    } else if (Intrinsics.areEqual((Object)node.getTokenType(), (Object)TokenType.ERROR_ELEMENT) ^ true) {
                        FirElement firElement;
                        void this_$iv;
                        ExpressionsConverter expressionsConverter = this.this$0;
                        String errorReason$iv = "Incorrect invoke receiver";
                        boolean $i$f$getAsFirExpression = false;
                        LighterASTNode lighterASTNode5 = node;
                        boolean bl = false;
                        boolean bl9 = false;
                        LighterASTNode it$iv = lighterASTNode5;
                        boolean bl10 = false;
                        FirElement firElement3 = this_$iv.convertExpression(it$iv, errorReason$iv);
                        if (!(firElement3 instanceof FirExpression)) {
                            firElement3 = null;
                        }
                        if ((firElement = (FirElement)((FirExpression)firElement3)) == null) {
                            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                            if (firErrorExpression == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                            }
                            firElement = firErrorExpression;
                        }
                        this.$additionalArgument$inlined.element = (FirExpression)firElement;
                    }
                }
            };
            $fun$process$1.invoke(child);
        }
        FirLightSourceElement source = (FirLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, callSuffix, null, 1, null);
        if ((String)name.element != null) {
            $i$f$buildSimpleNamedReference = false;
            n2 = 0;
            object = new FirSimpleNamedReferenceBuilder();
            n = 0;
            kid$iv2 = false;
            $this$buildSimpleNamedReference = object;
            boolean bl4 = false;
            ((FirSimpleNamedReferenceBuilder)$this$buildSimpleNamedReference).setSource(source);
            ((FirSimpleNamedReferenceBuilder)$this$buildSimpleNamedReference).setName(ConverterUtilKt.nameAsSafeName$default((String)name.element, null, 1, null));
            unit = Unit.INSTANCE;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n3 = 6;
            boolean bl5 = false;
            FirExpression firExpression2 = null;
            FirNamedReference firNamedReference = ((FirSimpleNamedReferenceBuilder)object).build();
            calleeAndReceiver = new CalleeAndReceiver(firNamedReference, firExpression2, bl5, n3, defaultConstructorMarker);
        } else if ((FirExpression)additionalArgument.element != null) {
            $i$f$buildSimpleNamedReference = false;
            n2 = 0;
            object = new FirSimpleNamedReferenceBuilder();
            n = 0;
            kid$iv2 = false;
            $this$buildSimpleNamedReference = object;
            boolean bl6 = false;
            ((FirSimpleNamedReferenceBuilder)$this$buildSimpleNamedReference).setSource(source);
            ((FirSimpleNamedReferenceBuilder)$this$buildSimpleNamedReference).setName(OperatorNameConventions.INVOKE);
            unit = Unit.INSTANCE;
            FirNamedReference firNamedReference = ((FirSimpleNamedReferenceBuilder)object).build();
            FirExpression firExpression3 = (FirExpression)additionalArgument.element;
            Intrinsics.checkNotNull((Object)firExpression3);
            boolean bl7 = true;
            FirExpression firExpression4 = firExpression3;
            FirNamedReference firNamedReference2 = firNamedReference;
            calleeAndReceiver = new CalleeAndReceiver(firNamedReference2, firExpression4, bl7);
        } else if ((LighterASTNode)superNode.element != null) {
            $i$f$buildErrorNamedReference = false;
            n2 = 0;
            object = new FirErrorNamedReferenceBuilder();
            n = 0;
            kid$iv2 = false;
            $this$buildErrorNamedReference = object;
            boolean bl8 = false;
            LighterASTNode lighterASTNode3 = (LighterASTNode)superNode.element;
            Intrinsics.checkNotNull((Object)lighterASTNode3);
            LighterASTNode node = lighterASTNode3;
            ((FirErrorNamedReferenceBuilder)$this$buildErrorNamedReference).setSource(BaseFirBuilder.toFirSourceElement$default(this, node, null, 1, null));
            ((FirErrorNamedReferenceBuilder)$this$buildErrorNamedReference).setDiagnostic(new ConeSimpleDiagnostic("Super cannot be a callee", DiagnosticKind.SuperNotAllowed));
            unit = Unit.INSTANCE;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n4 = 6;
            boolean bl9 = false;
            FirExpression firExpression5 = null;
            FirNamedReference firNamedReference = ((FirErrorNamedReferenceBuilder)object).build();
            calleeAndReceiver = new CalleeAndReceiver(firNamedReference, firExpression5, bl9, n4, defaultConstructorMarker);
        } else {
            $i$f$buildErrorNamedReference = false;
            n2 = 0;
            object = new FirErrorNamedReferenceBuilder();
            n = 0;
            kid$iv2 = false;
            $this$buildErrorNamedReference = object;
            boolean bl10 = false;
            ((FirErrorNamedReferenceBuilder)$this$buildErrorNamedReference).setSource(source);
            ((FirErrorNamedReferenceBuilder)$this$buildErrorNamedReference).setDiagnostic(new ConeSimpleDiagnostic("Call has no callee", DiagnosticKind.Syntax));
            unit = Unit.INSTANCE;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n5 = 6;
            boolean bl11 = false;
            FirExpression firExpression6 = null;
            FirNamedReference firNamedReference = ((FirErrorNamedReferenceBuilder)object).build();
            calleeAndReceiver = new CalleeAndReceiver(firNamedReference, firExpression6, bl11, n5, defaultConstructorMarker);
        }
        kidsArray$iv = calleeAndReceiver;
        $this$forEachChildren$iv = ((CalleeAndReceiver)kidsArray$iv).component1();
        skipTokens$iv = ((CalleeAndReceiver)kidsArray$iv).component2();
        boolean isImplicitInvoke = ((CalleeAndReceiver)kidsArray$iv).component3();
        if (hasArguments.element) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            FirAnnotationContainerBuilder builder3 = isImplicitInvoke ? new FirImplicitInvokeCallBuilder() : new FirFunctionCallBuilder();
            object = builder3;
            n = 0;
            kid$iv2 = false;
            Object $this$apply = object;
            boolean bl12 = false;
            ((FirAbstractFunctionCallBuilder)$this$apply).setSource(source);
            ((FirAbstractFunctionCallBuilder)$this$apply).setCalleeReference((FirNamedReference)calleeReference);
            Iterable node = this.getContext().getCalleeNamesForLambda();
            $fun$process$1 = calleeReference.getName();
            boolean bl13 = false;
            node.add($fun$process$1);
            node = valueArguments;
            FirCallBuilder firCallBuilder = (FirCallBuilder)$this$apply;
            boolean $i$f$flatMap = false;
            void var21_60 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                LighterASTNode it = (LighterASTNode)element$iv$iv;
                boolean bl14 = false;
                Iterable list$iv$iv = this.convertValueArguments(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            ConverterUtilKt.extractArgumentsFrom(firCallBuilder, list2, this.stubMode);
            this.removeLast(this.getContext().getCalleeNamesForLambda());
            firQualifiedAccessBuilder2 = (FirQualifiedAccessBuilder)object;
        } else {
            firQualifiedAccessBuilder = new FirQualifiedAccessExpressionBuilder();
            boolean bl15 = false;
            n = 0;
            FirQualifiedAccessExpressionBuilder $this$apply = firQualifiedAccessBuilder;
            boolean bl16 = false;
            $this$apply.setSource(source);
            $this$apply.setCalleeReference((FirReference)calleeReference);
            firQualifiedAccessBuilder2 = firQualifiedAccessBuilder;
        }
        firQualifiedAccessBuilder = builder2 = firQualifiedAccessBuilder2;
        boolean bl17 = false;
        n = 0;
        FirQualifiedAccessBuilder $this$apply = firQualifiedAccessBuilder;
        boolean bl18 = false;
        $this$apply.setExplicitReceiver((FirExpression)explicitReceiver);
        Collection collection = $this$apply.getTypeArguments();
        Iterable iterable = firTypeArguments;
        boolean bl19 = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        FirQualifiedAccess firQualifiedAccess = firQualifiedAccessBuilder.build();
        if (firQualifiedAccess == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
        }
        return (FirExpression)((Object)firQualifiedAccess);
    }

    private final FirExpression convertStringTemplate(LighterASTNode stringTemplate) {
        return BaseFirBuilder.toInterpolatingCall$default(this, this.getChildrenAsArray(stringTemplate), stringTemplate, null, (Function2)new Function2<LighterASTNode, String, FirExpression>(this){
            final /* synthetic */ ExpressionsConverter this$0;

            @NotNull
            public final FirExpression invoke(@Nullable LighterASTNode $this$toInterpolatingCall, @NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ExpressionsConverter.access$convertShortOrLongStringTemplate(this.this$0, $this$toInterpolatingCall, it);
            }
            {
                this.this$0 = expressionsConverter;
                super(2);
            }
        }, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertShortOrLongStringTemplate(LighterASTNode $this$convertShortOrLongStringTemplate, String errorReason) {
        FirExpression firExpression2 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason, DiagnosticKind.Syntax));
        LighterASTNode lighterASTNode2 = $this$convertShortOrLongStringTemplate;
        if (lighterASTNode2 != null) {
            void $this$forEachChildren$iv;
            void this_$iv;
            LighterASTNode[] kidsArray$iv;
            LighterASTNode lighterASTNode3 = lighterASTNode2;
            BaseConverter baseConverter = this;
            Object[] objectArray = new KtToken[2];
            KtToken ktToken = KtTokens.LONG_TEMPLATE_ENTRY_START;
            Intrinsics.checkNotNullExpressionValue((Object)ktToken, (String)"LONG_TEMPLATE_ENTRY_START");
            objectArray[0] = ktToken;
            KtToken ktToken2 = KtTokens.LONG_TEMPLATE_ENTRY_END;
            Intrinsics.checkNotNullExpressionValue((Object)ktToken2, (String)"LONG_TEMPLATE_ENTRY_END");
            objectArray[1] = ktToken2;
            Object[] skipTokens$iv = objectArray;
            boolean $i$f$forEachChildren = false;
            for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
                FirElement firElement;
                void this_$iv2;
                if (kid$iv == null) break;
                IElementType tokenType$iv = kid$iv.getTokenType();
                if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
                LighterASTNode it = kid$iv;
                boolean bl = false;
                ExpressionsConverter expressionsConverter = this;
                String errorReason$iv = errorReason;
                boolean $i$f$getAsFirExpression = false;
                LighterASTNode lighterASTNode4 = it;
                boolean bl2 = false;
                boolean bl3 = false;
                LighterASTNode it$iv = lighterASTNode4;
                boolean bl4 = false;
                FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
                if (!(firElement2 instanceof FirExpression)) {
                    firElement2 = null;
                }
                if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement = firErrorExpression;
                }
                firExpression2 = (FirExpression)firElement;
            }
        }
        return firExpression2;
    }

    private final FirExpression convertConstantExpression(LighterASTNode constantExpression) {
        return this.generateConstantExpressionByLiteral(constantExpression);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertWhenExpression(LighterASTNode whenExpression) {
        Object this_$iv;
        boolean bl;
        boolean bl2;
        Object object;
        void $this$forEachChildren$iv;
        void this_$iv2;
        LighterASTNode[] kidsArray$iv;
        FirPureAbstractElement subjectExpression = null;
        FirVariable subjectVariable = null;
        boolean bl3 = false;
        List whenEntryNodes = new ArrayList();
        boolean bl4 = false;
        List whenEntries = new ArrayList();
        LighterASTNode lighterASTNode2 = whenExpression;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv2.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            boolean bl5;
            Object it$iv;
            boolean bl6;
            boolean $i$f$getAsFirExpression;
            boolean bl7;
            Object variable2;
            Object object2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it2 = kid$iv;
            boolean bl8 = false;
            object = it2.getTokenType();
            if (Intrinsics.areEqual((Object)object, (Object)KtNodeTypes.PROPERTY)) {
                FirDeclaration firDeclaration = DeclarationsConverter.convertPropertyDeclaration$default(this.declarationsConverter, it2, null, 2, null);
                if (firDeclaration == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirVariable<*>");
                }
                object2 = (FirVariable)firDeclaration;
                boolean bl9 = false;
                bl2 = false;
                variable2 = object2;
                bl7 = false;
                boolean $i$f$buildProperty = false;
                boolean bl10 = false;
                FirPropertyBuilder firPropertyBuilder = new FirPropertyBuilder();
                bl = false;
                boolean bl11 = false;
                FirPropertyBuilder $this$buildProperty = firPropertyBuilder;
                boolean bl12 = false;
                $this$buildProperty.setSource(BaseFirBuilder.toFirSourceElement$default(this, it2, null, 1, null));
                $this$buildProperty.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                $this$buildProperty.setSession(this.getBaseSession());
                $this$buildProperty.setReturnTypeRef(((FirVariable)variable2).getReturnTypeRef());
                $this$buildProperty.setName(((FirVariable)variable2).getName());
                $this$buildProperty.setInitializer(((FirVariable)variable2).getInitializer());
                $this$buildProperty.setVar(false);
                $this$buildProperty.setSymbol(new FirPropertySymbol(((FirVariable)variable2).getName()));
                $this$buildProperty.setLocal(true);
                $this$buildProperty.setStatus(new FirDeclarationStatusImpl(Visibilities.Local.INSTANCE, Modality.FINAL));
                FirProperty firProperty = firPropertyBuilder.build();
                subjectVariable = firProperty;
                continue;
            }
            if (Intrinsics.areEqual((Object)object, (Object)KtNodeTypes.DESTRUCTURING_DECLARATION)) {
                FirElement firElement2;
                object2 = this;
                String errorReason$iv = "Incorrect when subject expression: " + this.getAsText(whenExpression);
                $i$f$getAsFirExpression = false;
                variable2 = it2;
                bl7 = false;
                bl6 = false;
                it$iv = variable2;
                bl5 = false;
                FirElement firElement3 = ((ExpressionsConverter)this_$iv).convertExpression((LighterASTNode)it$iv, errorReason$iv);
                if (!(firElement3 instanceof FirExpression)) {
                    firElement3 = null;
                }
                if ((firElement2 = (FirElement)((FirExpression)firElement3)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement2 = firErrorExpression;
                }
                subjectExpression = (FirExpression)firElement2;
                continue;
            }
            if (Intrinsics.areEqual((Object)object, (Object)KtNodeTypes.WHEN_ENTRY)) {
                this_$iv = whenEntryNodes;
                boolean errorReason$iv = false;
                this_$iv.add(it2);
                continue;
            }
            if (!ConverterUtilKt.isExpression(it2)) continue;
            this_$iv = this;
            String errorReason$iv = "Incorrect when subject expression: " + this.getAsText(whenExpression);
            $i$f$getAsFirExpression = false;
            variable2 = it2;
            bl7 = false;
            bl6 = false;
            it$iv = variable2;
            bl5 = false;
            FirElement firElement4 = ((ExpressionsConverter)this_$iv).convertExpression((LighterASTNode)it$iv, errorReason$iv);
            if (!(firElement4 instanceof FirExpression)) {
                firElement4 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement4)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            subjectExpression = (FirExpression)firElement;
        }
        FirPureAbstractElement firPureAbstractElement = subjectVariable;
        if (firPureAbstractElement == null || (firPureAbstractElement = firPureAbstractElement.getInitializer()) == null) {
            firPureAbstractElement = subjectExpression;
        }
        subjectExpression = firPureAbstractElement;
        boolean hasSubject = subjectExpression != null;
        FirExpressionRef<FirWhenExpression> subject = new FirExpressionRef<FirWhenExpression>();
        Iterable $this$mapTo$iv = whenEntryNodes;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            LighterASTNode lighterASTNode3 = (LighterASTNode)item$iv;
            Collection collection = whenEntries;
            boolean bl13 = false;
            FirExpressionRef<FirWhenExpression> firExpressionRef = subject;
            boolean tokenType$iv = false;
            boolean it2 = false;
            FirExpressionRef<FirWhenExpression> bl8 = firExpressionRef;
            object = it;
            this_$iv = this;
            boolean bl14 = false;
            bl2 = hasSubject;
            WhenEntry whenEntry = super.convertWhenEntry((LighterASTNode)object, (FirExpressionRef<FirWhenExpression>)(bl2 ? firExpressionRef : null));
            collection.add(whenEntry);
        }
        boolean $i$f$buildWhenExpression = false;
        boolean bl15 = false;
        FirWhenExpressionBuilder firWhenExpressionBuilder = new FirWhenExpressionBuilder();
        boolean bl16 = false;
        boolean item$iv = false;
        FirWhenExpressionBuilder $this$buildWhenExpression = firWhenExpressionBuilder;
        boolean bl17 = false;
        $this$buildWhenExpression.setSource(BaseFirBuilder.toFirSourceElement$default(this, whenExpression, null, 1, null));
        $this$buildWhenExpression.setSubject((FirExpression)subjectExpression);
        $this$buildWhenExpression.setSubjectVariable(subjectVariable);
        for (WhenEntry entry : whenEntries) {
            FirWhenBranch firWhenBranch;
            FirBlock branch = entry.getFirBlock();
            Collection collection = $this$buildWhenExpression.getBranches();
            if (!entry.isElse()) {
                FirExpression firCondition;
                if (hasSubject) {
                    firCondition = entry.toFirWhenCondition();
                    boolean $i$f$buildWhenBranch = false;
                    boolean bl18 = false;
                    FirWhenBranchBuilder firWhenBranchBuilder = new FirWhenBranchBuilder();
                    bl2 = false;
                    boolean variable2 = false;
                    FirWhenBranchBuilder $this$buildWhenBranch = firWhenBranchBuilder;
                    boolean bl19 = false;
                    $this$buildWhenBranch.setSource(branch.getSource());
                    $this$buildWhenBranch.setCondition(firCondition);
                    $this$buildWhenBranch.setResult(branch);
                    firWhenBranch = firWhenBranchBuilder.build();
                } else {
                    firCondition = entry.toFirWhenConditionWithoutSubject();
                    boolean $i$f$buildWhenBranch = false;
                    boolean bl20 = false;
                    FirWhenBranchBuilder firWhenBranchBuilder = new FirWhenBranchBuilder();
                    bl2 = false;
                    boolean variable2 = false;
                    FirWhenBranchBuilder $this$buildWhenBranch = firWhenBranchBuilder;
                    boolean bl21 = false;
                    $this$buildWhenBranch.setSource(branch.getSource());
                    $this$buildWhenBranch.setCondition(firCondition);
                    $this$buildWhenBranch.setResult(branch);
                    firWhenBranch = firWhenBranchBuilder.build();
                }
            } else {
                boolean $i$f$buildWhenBranch = false;
                boolean bl22 = false;
                FirWhenBranchBuilder firWhenBranchBuilder = new FirWhenBranchBuilder();
                boolean bl23 = false;
                bl2 = false;
                FirWhenBranchBuilder $this$buildWhenBranch = firWhenBranchBuilder;
                boolean bl24 = false;
                $this$buildWhenBranch.setSource(branch.getSource());
                boolean $i$f$buildElseIfTrueCondition = false;
                boolean bl25 = false;
                FirElseIfTrueConditionBuilder firElseIfTrueConditionBuilder = new FirElseIfTrueConditionBuilder();
                boolean bl26 = false;
                bl = false;
                FirElseIfTrueConditionBuilder firElseIfTrueConditionBuilder2 = firElseIfTrueConditionBuilder;
                FirWhenBranchBuilder firWhenBranchBuilder2 = $this$buildWhenBranch;
                Unit unit = Unit.INSTANCE;
                firWhenBranchBuilder2.setCondition(firElseIfTrueConditionBuilder.build());
                $this$buildWhenBranch.setResult(branch);
                firWhenBranch = firWhenBranchBuilder.build();
            }
            object = firWhenBranch;
            boolean bl27 = false;
            collection.add(object);
        }
        FirWhenExpression firWhenExpression = firWhenExpressionBuilder.build();
        boolean bl28 = false;
        bl16 = false;
        FirWhenExpression it = firWhenExpression;
        boolean bl29 = false;
        if (hasSubject) {
            subject.bind((FirWhenExpression)((FirExpression)it));
        }
        return firWhenExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final WhenEntry convertWhenEntry(LighterASTNode whenEntry, FirExpressionRef<FirWhenExpression> whenRefWithSubject) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        boolean isElse = false;
        FirBlock firBlock = FirEmptyExpressionBlockBuilderKt.buildEmptyExpressionBlock();
        boolean bl = false;
        List conditions2 = new ArrayList();
        LighterASTNode lighterASTNode2 = whenEntry;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            boolean bl2;
            FirExpression firExpression2;
            Collection collection;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl3 = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.WHEN_CONDITION_EXPRESSION)) {
                collection = conditions2;
                firExpression2 = this.convertWhenConditionExpression(it, whenRefWithSubject);
                bl2 = false;
                collection.add(firExpression2);
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.WHEN_CONDITION_IN_RANGE)) {
                collection = conditions2;
                firExpression2 = this.convertWhenConditionInRange(it, whenRefWithSubject);
                bl2 = false;
                collection.add(firExpression2);
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.WHEN_CONDITION_IS_PATTERN)) {
                collection = conditions2;
                firExpression2 = this.convertWhenConditionIsPattern(it, whenRefWithSubject);
                bl2 = false;
                collection.add(firExpression2);
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.ELSE_KEYWORD)) {
                isElse = true;
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BLOCK)) {
                firBlock = this.declarationsConverter.convertBlock(it);
                continue;
            }
            if (!ConverterUtilKt.isExpression(it)) continue;
            firBlock = this.declarationsConverter.convertBlock(it);
        }
        return new WhenEntry(conditions2, firBlock, isElse);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertWhenConditionExpression(LighterASTNode whenCondition, FirExpressionRef<FirWhenExpression> whenRefWithSubject) {
        FirExpression firExpression2;
        ExpressionsConverter expressionsConverter;
        Object it;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        FirExpression firExpression3 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No expression in condition with expression", DiagnosticKind.Syntax));
        LighterASTNode lighterASTNode2 = whenCondition;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (!ConverterUtilKt.isExpression((LighterASTNode)it)) continue;
            expressionsConverter = this;
            String errorReason$iv = "No expression in condition with expression";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode3 = it;
            boolean bl2 = false;
            boolean bl3 = false;
            LighterASTNode it$iv = lighterASTNode3;
            boolean bl4 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression3 = (FirExpression)firElement;
        }
        if (whenRefWithSubject != null) {
            void $this$buildWhenSubjectExpression;
            boolean $i$f$buildEqualityOperatorCall = false;
            boolean bl = false;
            FirEqualityOperatorCallBuilder firEqualityOperatorCallBuilder = new FirEqualityOperatorCallBuilder();
            boolean bl5 = false;
            boolean bl6 = false;
            FirEqualityOperatorCallBuilder $this$buildEqualityOperatorCall = firEqualityOperatorCallBuilder;
            boolean bl7 = false;
            $this$buildEqualityOperatorCall.setSource(BaseFirBuilder.toFirSourceElement$default(this, whenCondition, null, 1, null));
            $this$buildEqualityOperatorCall.setOperation(FirOperation.EQ);
            boolean $i$f$buildWhenSubjectExpression = false;
            int n = 0;
            FirWhenSubjectExpressionBuilder firWhenSubjectExpressionBuilder = new FirWhenSubjectExpressionBuilder();
            boolean bl8 = false;
            boolean bl9 = false;
            it = firWhenSubjectExpressionBuilder;
            FirEqualityOperatorCallBuilder firEqualityOperatorCallBuilder2 = $this$buildEqualityOperatorCall;
            boolean bl10 = false;
            $this$buildWhenSubjectExpression.setWhenRef(whenRefWithSubject);
            expressionsConverter = Unit.INSTANCE;
            firEqualityOperatorCallBuilder2.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(firWhenSubjectExpressionBuilder.build(), firExpression3));
            firExpression2 = firEqualityOperatorCallBuilder.build();
        } else {
            firExpression2 = firExpression3;
        }
        return firExpression2;
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertWhenConditionInRange(LighterASTNode whenCondition, FirExpressionRef<FirWhenExpression> whenRefWithSubject) {
        boolean bl;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        boolean isNegate = false;
        FirExpression firExpression2 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No range in condition with range", DiagnosticKind.Syntax));
        FirLightSourceElement conditionSource = null;
        LighterASTNode lighterASTNode2 = whenCondition;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.OPERATION_REFERENCE)) {
                String string2 = this.getAsText(it);
                KtKeywordToken ktKeywordToken = KtTokens.NOT_IN;
                Intrinsics.checkNotNullExpressionValue((Object)ktKeywordToken, (String)"NOT_IN");
                if (Intrinsics.areEqual((Object)string2, (Object)ktKeywordToken.getValue())) {
                    conditionSource = (FirLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null);
                    isNegate = true;
                    continue;
                }
            }
            if (!ConverterUtilKt.isExpression(it)) continue;
            ExpressionsConverter this_$iv2 = this;
            String errorReason$iv = "";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode3 = it;
            boolean bl3 = false;
            boolean bl4 = false;
            LighterASTNode it$iv = lighterASTNode3;
            boolean bl5 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression2 = (FirExpression)firElement;
        }
        if (whenRefWithSubject == null) {
            boolean $i$f$buildErrorExpression = false;
            boolean bl6 = false;
            FirErrorExpressionBuilder firErrorExpressionBuilder = new FirErrorExpressionBuilder();
            bl = false;
            boolean bl7 = false;
            FirErrorExpressionBuilder $this$buildErrorExpression = firErrorExpressionBuilder;
            boolean bl8 = false;
            $this$buildErrorExpression.setSource(BaseFirBuilder.toFirSourceElement$default(this, whenCondition, null, 1, null));
            $this$buildErrorExpression.setDiagnostic(new ConeSimpleDiagnostic("No expression in condition with expression", DiagnosticKind.Syntax));
            return firErrorExpressionBuilder.build();
        }
        boolean $i$f$buildWhenSubjectExpression = false;
        boolean bl9 = false;
        FirWhenSubjectExpressionBuilder firWhenSubjectExpressionBuilder = new FirWhenSubjectExpressionBuilder();
        bl = false;
        boolean bl10 = false;
        FirWhenSubjectExpressionBuilder $this$buildWhenSubjectExpression = firWhenSubjectExpressionBuilder;
        boolean bl11 = false;
        $this$buildWhenSubjectExpression.setWhenRef(whenRefWithSubject);
        FirWhenSubjectExpression subjectExpression = firWhenSubjectExpressionBuilder.build();
        return ConversionUtilsKt.generateContainsOperation(firExpression2, subjectExpression, isNegate, BaseFirBuilder.toFirSourceElement$default(this, whenCondition, null, 1, null), conditionSource);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertWhenConditionIsPattern(LighterASTNode whenCondition, FirExpressionRef<FirWhenExpression> whenRefWithSubject) {
        boolean bl;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        FirOperation firOperation = null;
        FirTypeRef firType = null;
        LighterASTNode lighterASTNode2 = whenCondition;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl2 = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.TYPE_REFERENCE)) {
                firType = this.declarationsConverter.convertType(it);
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.IS_KEYWORD)) {
                firOperation = FirOperation.IS;
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.NOT_IS)) continue;
            firOperation = FirOperation.NOT_IS;
        }
        if (whenRefWithSubject == null) {
            boolean $i$f$buildErrorExpression = false;
            boolean bl3 = false;
            FirErrorExpressionBuilder firErrorExpressionBuilder = new FirErrorExpressionBuilder();
            bl = false;
            boolean bl4 = false;
            FirErrorExpressionBuilder $this$buildErrorExpression = firErrorExpressionBuilder;
            boolean bl5 = false;
            $this$buildErrorExpression.setSource(BaseFirBuilder.toFirSourceElement$default(this, whenCondition, null, 1, null));
            $this$buildErrorExpression.setDiagnostic(new ConeSimpleDiagnostic("No expression in condition with expression", DiagnosticKind.Syntax));
            return firErrorExpressionBuilder.build();
        }
        boolean $i$f$buildWhenSubjectExpression = false;
        boolean bl6 = false;
        FirWhenSubjectExpressionBuilder firWhenSubjectExpressionBuilder = new FirWhenSubjectExpressionBuilder();
        bl = false;
        boolean bl7 = false;
        FirWhenSubjectExpressionBuilder $this$buildWhenSubjectExpression = firWhenSubjectExpressionBuilder;
        boolean bl8 = false;
        $this$buildWhenSubjectExpression.setWhenRef(whenRefWithSubject);
        FirWhenSubjectExpression subjectExpression = firWhenSubjectExpressionBuilder.build();
        boolean $i$f$buildTypeOperatorCall = false;
        boolean bl9 = false;
        FirTypeOperatorCallBuilder firTypeOperatorCallBuilder = new FirTypeOperatorCallBuilder();
        bl = false;
        bl7 = false;
        FirTypeOperatorCallBuilder $this$buildTypeOperatorCall = firTypeOperatorCallBuilder;
        boolean bl10 = false;
        $this$buildTypeOperatorCall.setSource(BaseFirBuilder.toFirSourceElement$default(this, whenCondition, null, 1, null));
        FirOperation firOperation2 = firOperation;
        if (firOperation2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"firOperation");
        }
        $this$buildTypeOperatorCall.setOperation(firOperation2);
        FirTypeRef firTypeRef = firType;
        if (firTypeRef == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"firType");
        }
        $this$buildTypeOperatorCall.setConversionTypeRef(firTypeRef);
        $this$buildTypeOperatorCall.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(subjectExpression));
        return firTypeOperatorCallBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirFunctionCall convertArrayAccessExpression(LighterASTNode arrayAccess) {
        void $this$buildArgumentList;
        FirArgumentListBuilder $this$buildSimpleNamedReference;
        boolean bl;
        Object object;
        Iterable iterable;
        Object object2;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        FirExpression firExpression2 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No array expression", DiagnosticKind.Syntax));
        boolean bl2 = false;
        List indices = new ArrayList();
        LighterASTNode lighterASTNode2 = arrayAccess;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            Object object3;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl3 = false;
            object2 = it.getTokenType();
            if (Intrinsics.areEqual((Object)object2, (Object)KtNodeTypes.INDICES)) {
                object3 = indices;
                iterable = this.convertIndices(it);
                boolean bl4 = false;
                CollectionsKt.addAll((Collection)object3, (Iterable)iterable);
                continue;
            }
            if (!ConverterUtilKt.isExpression(it)) continue;
            object3 = this;
            String errorReason$iv = "No array expression";
            boolean $i$f$getAsFirExpression = false;
            object = it;
            bl = false;
            boolean bl5 = false;
            LighterASTNode it$iv = object;
            boolean bl6 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression2 = (FirExpression)firElement;
        }
        FirExpression getArgument = this.getContext().getArraySetArgument().remove(arrayAccess);
        boolean $i$f$buildFunctionCall = false;
        boolean bl7 = false;
        FirFunctionCallBuilder firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl8 = false;
        boolean bl9 = false;
        FirFunctionCallBuilder $this$buildFunctionCall = firFunctionCallBuilder;
        boolean bl10 = false;
        $this$buildFunctionCall.setSource(BaseFirBuilder.toFirSourceElement$default(this, arrayAccess, null, 1, null));
        boolean $i$f$buildSimpleNamedReference = false;
        boolean bl11 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        boolean bl12 = false;
        boolean bl13 = false;
        FirSimpleNamedReferenceBuilder bl3 = firSimpleNamedReferenceBuilder;
        object2 = $this$buildFunctionCall;
        boolean bl14 = false;
        ((FirSimpleNamedReferenceBuilder)((Object)$this$buildSimpleNamedReference)).setSource($this$buildFunctionCall.getSource());
        ((FirSimpleNamedReferenceBuilder)((Object)$this$buildSimpleNamedReference)).setName(getArgument == null ? OperatorNameConventions.GET : OperatorNameConventions.SET);
        iterable = Unit.INSTANCE;
        ((FirFunctionCallBuilder)object2).setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$buildFunctionCall.setExplicitReceiver(firExpression2);
        boolean $i$f$buildArgumentList = false;
        boolean bl15 = false;
        FirArgumentListBuilder firArgumentListBuilder = new FirArgumentListBuilder();
        bl12 = false;
        bl13 = false;
        $this$buildSimpleNamedReference = firArgumentListBuilder;
        object2 = $this$buildFunctionCall;
        boolean bl16 = false;
        Object object4 = $this$buildArgumentList.getArguments();
        object = indices;
        bl = false;
        CollectionsKt.addAll((Collection)object4, (Iterable)object);
        FirExpression firExpression3 = getArgument;
        if (firExpression3 != null) {
            object4 = firExpression3;
            boolean bl17 = false;
            bl = false;
            Object it = object4;
            boolean bl18 = false;
            Collection collection = $this$buildArgumentList.getArguments();
            boolean bl19 = false;
            collection.add(it);
        }
        iterable = Unit.INSTANCE;
        ((FirFunctionCallBuilder)object2).setArgumentList(firArgumentListBuilder.build());
        return firFunctionCallBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertCollectionLiteralExpression(LighterASTNode expression2) {
        void $this$buildArgumentList;
        Object object;
        Object object2;
        Object it;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        boolean bl = false;
        List firExpressionList = new ArrayList();
        LighterASTNode lighterASTNode2 = expression2;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            it = kid$iv;
            boolean bl2 = false;
            if (!ConverterUtilKt.isExpression((LighterASTNode)it)) continue;
            Collection collection = firExpressionList;
            object2 = this;
            String errorReason$iv = "Incorrect collection literal argument";
            boolean $i$f$getAsFirExpression = false;
            object = it;
            boolean bl3 = false;
            boolean bl4 = false;
            Object it$iv = object;
            boolean bl5 = false;
            FirElement firElement2 = this_$iv2.convertExpression((LighterASTNode)it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            object2 = firElement;
            boolean bl6 = false;
            collection.add(object2);
        }
        boolean $i$f$buildArrayOfCall = false;
        boolean bl7 = false;
        FirArrayOfCallBuilder firArrayOfCallBuilder = new FirArrayOfCallBuilder();
        boolean bl8 = false;
        boolean bl9 = false;
        FirArrayOfCallBuilder $this$buildArrayOfCall = firArrayOfCallBuilder;
        boolean bl10 = false;
        $this$buildArrayOfCall.setSource(BaseFirBuilder.toFirSourceElement$default(this, expression2, null, 1, null));
        boolean $i$f$buildArgumentList = false;
        int n = 0;
        FirArgumentListBuilder firArgumentListBuilder = new FirArgumentListBuilder();
        boolean bl11 = false;
        boolean bl12 = false;
        it = firArgumentListBuilder;
        FirArrayOfCallBuilder firArrayOfCallBuilder2 = $this$buildArrayOfCall;
        boolean bl13 = false;
        object2 = $this$buildArgumentList.getArguments();
        Iterable iterable = firExpressionList;
        boolean bl14 = false;
        CollectionsKt.addAll((Collection)object2, (Iterable)iterable);
        object = Unit.INSTANCE;
        firArrayOfCallBuilder2.setArgumentList(firArgumentListBuilder.build());
        return firArrayOfCallBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirExpression> convertIndices(LighterASTNode indices) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        boolean bl = false;
        List firExpressionList = new ArrayList();
        LighterASTNode lighterASTNode2 = indices;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl2 = false;
            if (!ConverterUtilKt.isExpression(it)) continue;
            Collection collection = firExpressionList;
            Object object = this;
            String errorReason$iv = "Incorrect index expression";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode3 = it;
            boolean bl3 = false;
            boolean bl4 = false;
            LighterASTNode it$iv = lighterASTNode3;
            boolean bl5 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            object = firElement;
            boolean bl6 = false;
            collection.add(object);
        }
        return firExpressionList;
    }

    /*
     * WARNING - void declaration
     */
    private final FirQualifiedAccessExpression convertSimpleNameExpression(LighterASTNode referenceExpression) {
        void $this$buildSimpleNamedReference;
        boolean $i$f$buildQualifiedAccessExpression = false;
        boolean bl = false;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder = new FirQualifiedAccessExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirQualifiedAccessExpressionBuilder $this$buildQualifiedAccessExpression = firQualifiedAccessExpressionBuilder;
        boolean bl4 = false;
        $this$buildQualifiedAccessExpression.setSource(BaseFirBuilder.toFirSourceElement$default(this, referenceExpression, null, 1, null));
        boolean $i$f$buildSimpleNamedReference = false;
        boolean bl5 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder2 = $this$buildQualifiedAccessExpression;
        boolean bl8 = false;
        $this$buildSimpleNamedReference.setSource($this$buildQualifiedAccessExpression.getSource());
        $this$buildSimpleNamedReference.setName(ConverterUtilKt.nameAsSafeName$default(this.getAsText(referenceExpression), null, 1, null));
        Unit unit = Unit.INSTANCE;
        firQualifiedAccessExpressionBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        return firQualifiedAccessExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirElement convertDoWhile(LighterASTNode doWhileLoop) {
        void block;
        void $this$apply;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        FirExpression firCondition = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No condition in do-while loop", DiagnosticKind.Syntax));
        LighterASTNode lighterASTNode2 = doWhileLoop;
        Object object = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren22 = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BODY)) {
                block.element = it;
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CONDITION)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "No condition in do-while loop";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode3 = it;
            boolean bl2 = false;
            boolean bl3 = false;
            LighterASTNode it$iv = lighterASTNode3;
            boolean bl4 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firCondition = (FirExpression)firElement;
        }
        object = new FirDoWhileLoopBuilder();
        boolean bl = false;
        boolean bl5 = false;
        Object $i$f$forEachChildren22 = object;
        ExpressionsConverter expressionsConverter = this;
        boolean bl6 = false;
        $this$apply.setSource(BaseFirBuilder.toFirSourceElement$default(this, doWhileLoop, null, 1, null));
        $this$apply.setCondition(firCondition);
        Unit unit = Unit.INSTANCE;
        return expressionsConverter.configure((FirLoopBuilder)object, (Function0<FirBlock>)((Function0)new Function0<FirBlock>(this, (Ref.ObjectRef)block){
            final /* synthetic */ ExpressionsConverter this$0;
            final /* synthetic */ Ref.ObjectRef $block;

            @NotNull
            public final FirBlock invoke() {
                return ExpressionsConverter.access$convertLoopBody(this.this$0, (LighterASTNode)this.$block.element);
            }
            {
                this.this$0 = expressionsConverter;
                this.$block = objectRef;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final FirElement convertWhile(LighterASTNode whileLoop) {
        void block;
        void $this$apply;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        FirExpression firCondition = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No condition in while loop", DiagnosticKind.Syntax));
        LighterASTNode lighterASTNode2 = whileLoop;
        Object object = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren22 = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BODY)) {
                block.element = it;
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CONDITION)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "No condition in while loop";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode3 = it;
            boolean bl2 = false;
            boolean bl3 = false;
            LighterASTNode it$iv = lighterASTNode3;
            boolean bl4 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firCondition = (FirExpression)firElement;
        }
        object = new FirWhileLoopBuilder();
        boolean bl = false;
        boolean bl5 = false;
        Object $i$f$forEachChildren22 = object;
        ExpressionsConverter expressionsConverter = this;
        boolean bl6 = false;
        $this$apply.setSource(BaseFirBuilder.toFirSourceElement$default(this, whileLoop, null, 1, null));
        $this$apply.setCondition(firCondition);
        Unit unit = Unit.INSTANCE;
        return expressionsConverter.configure((FirLoopBuilder)object, (Function0<FirBlock>)((Function0)new Function0<FirBlock>(this, (Ref.ObjectRef)block){
            final /* synthetic */ ExpressionsConverter this$0;
            final /* synthetic */ Ref.ObjectRef $block;

            @NotNull
            public final FirBlock invoke() {
                return ExpressionsConverter.access$convertLoopBody(this.this$0, (LighterASTNode)this.$block.element);
            }
            {
                this.this$0 = expressionsConverter;
                this.$block = objectRef;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final FirElement convertFor(LighterASTNode forLoop) {
        void parameter;
        void blockNode;
        void $this$buildSimpleNamedReference;
        void $this$buildFunctionCall;
        void $this$apply;
        void rangeExpression;
        FirFunctionCallBuilder $this$buildSimpleNamedReference2;
        FirWhileLoopBuilder $this$buildFunctionCall2;
        Object it$iv;
        boolean bl;
        boolean bl2;
        Object object;
        IElementType iElementType;
        Object it;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No range in for loop", DiagnosticKind.Syntax));
        Ref.ObjectRef objectRef3 = new Ref.ObjectRef();
        objectRef3.element = null;
        LighterASTNode lighterASTNode2 = forLoop;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            it = kid$iv;
            boolean bl3 = false;
            iElementType = it.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.VALUE_PARAMETER)) {
                parameter.element = this.declarationsConverter.convertValueParameter((LighterASTNode)it);
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.LOOP_RANGE)) {
                FirElement firElement;
                void this_$iv2;
                object = this;
                String errorReason$iv = "No range in for loop";
                boolean $i$f$getAsFirExpression = false;
                Object object2 = it;
                bl2 = false;
                bl = false;
                it$iv = object2;
                boolean bl4 = false;
                FirElement firElement2 = this_$iv2.convertExpression((LighterASTNode)it$iv, errorReason$iv);
                if (!(firElement2 instanceof FirExpression)) {
                    firElement2 = null;
                }
                if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement = firErrorExpression;
                }
                rangeExpression.element = (FirExpression)firElement;
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BODY)) continue;
            blockNode.element = it;
        }
        boolean $i$f$buildBlock = false;
        boolean bl5 = false;
        FirBlockBuilder firBlockBuilder = new FirBlockBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirBlockBuilder $this$buildBlock = firBlockBuilder;
        boolean bl8 = false;
        $this$buildBlock.setSource(BaseFirBuilder.toFirSourceElement$default(this, forLoop, null, 1, null));
        FirSession firSession = this.getBaseSession();
        Name name = Name.special("<iterator>");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.special(\"<iterator>\")");
        boolean $i$f$buildFunctionCall = false;
        int n = 0;
        FirFunctionCallBuilder firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl9 = false;
        boolean bl10 = false;
        it = firFunctionCallBuilder;
        Name name2 = name;
        iElementType = null;
        object = firSession;
        boolean bl11 = false;
        boolean $i$f$buildSimpleNamedReference = false;
        boolean bl12 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        bl2 = false;
        bl = false;
        it$iv = firSimpleNamedReferenceBuilder;
        void var25_43 = $this$buildFunctionCall2;
        boolean bl13 = false;
        Name name3 = Name.identifier("iterator");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"Name.identifier(\"iterator\")");
        ((FirSimpleNamedReferenceBuilder)((Object)$this$buildSimpleNamedReference2)).setName(name3);
        Unit unit = Unit.INSTANCE;
        var25_43.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        ((FirFunctionCallBuilder)((Object)$this$buildFunctionCall2)).setExplicitReceiver((FirExpression)rangeExpression.element);
        Unit unit2 = Unit.INSTANCE;
        FirVariable iteratorVal = ConversionUtilsKt.generateTemporaryVariable$default((FirSession)object, (FirSourceElement)((Object)iElementType), name2, firFunctionCallBuilder.build(), null, 16, null);
        Collection collection = $this$buildBlock.getStatements();
        boolean bl14 = false;
        collection.add(iteratorVal);
        collection = $this$buildBlock.getStatements();
        Object object3 = new FirWhileLoopBuilder();
        bl9 = false;
        bl10 = false;
        $this$buildFunctionCall2 = object3;
        object = this;
        boolean bl15 = false;
        $this$apply.setSource(BaseFirBuilder.toFirSourceElement$default(this, forLoop, null, 1, null));
        boolean $i$f$buildFunctionCall2 = false;
        boolean bl16 = false;
        FirFunctionCallBuilder firFunctionCallBuilder2 = new FirFunctionCallBuilder();
        bl2 = false;
        bl = false;
        $this$buildSimpleNamedReference2 = firFunctionCallBuilder2;
        var25_43 = $this$apply;
        boolean bl17 = false;
        boolean $i$f$buildSimpleNamedReference2 = false;
        boolean bl18 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = new FirSimpleNamedReferenceBuilder();
        boolean bl19 = false;
        boolean bl20 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder3 = firSimpleNamedReferenceBuilder2;
        void var34_54 = $this$buildFunctionCall;
        boolean bl21 = false;
        Name name4 = Name.identifier("hasNext");
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"Name.identifier(\"hasNext\")");
        $this$buildSimpleNamedReference.setName(name4);
        Unit unit3 = Unit.INSTANCE;
        var34_54.setCalleeReference(firSimpleNamedReferenceBuilder2.build());
        $this$buildFunctionCall.setExplicitReceiver(ConversionUtilsKt.generateResolvedAccessExpression(null, iteratorVal));
        Unit unit4 = Unit.INSTANCE;
        var25_43.setCondition(firFunctionCallBuilder2.build());
        iElementType = Unit.INSTANCE;
        object3 = ((BaseFirBuilder)object).configure((FirLoopBuilder)object3, (Function0<? extends FirBlock>)((Function0)new Function0<FirBlock>(iteratorVal, this, forLoop, (Ref.ObjectRef)rangeExpression, (Ref.ObjectRef)blockNode, (Ref.ObjectRef)parameter){
            final /* synthetic */ FirVariable $iteratorVal;
            final /* synthetic */ ExpressionsConverter this$0;
            final /* synthetic */ LighterASTNode $forLoop$inlined;
            final /* synthetic */ Ref.ObjectRef $rangeExpression$inlined;
            final /* synthetic */ Ref.ObjectRef $blockNode$inlined;
            final /* synthetic */ Ref.ObjectRef $parameter$inlined;
            {
                this.$iteratorVal = firVariable;
                this.this$0 = expressionsConverter;
                this.$forLoop$inlined = lighterASTNode2;
                this.$rangeExpression$inlined = objectRef;
                this.$blockNode$inlined = objectRef2;
                this.$parameter$inlined = objectRef3;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final FirBlock invoke() {
                boolean $i$f$buildBlock = false;
                boolean bl = false;
                FirBlockBuilder firBlockBuilder = new FirBlockBuilder();
                boolean bl2 = false;
                boolean bl3 = false;
                FirBlockBuilder $this$block = firBlockBuilder;
                boolean bl4 = false;
                LighterASTNode lighterASTNode2 = (LighterASTNode)this.$blockNode$inlined.element;
                $this$block.setSource(lighterASTNode2 != null ? (FirLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this.this$0, lighterASTNode2, null, 1, null) : null);
                Collection collection = $this$block.getStatements();
                Iterable iterable = ExpressionsConverter.access$convertLoopBody(this.this$0, (LighterASTNode)this.$blockNode$inlined.element).getStatements();
                boolean bl5 = false;
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                if ((ValueParameter)this.$parameter$inlined.element != null) {
                    void $this$buildSimpleNamedReference;
                    void $this$buildFunctionCall;
                    Name name;
                    ValueParameter valueParameter = (ValueParameter)this.$parameter$inlined.element;
                    Intrinsics.checkNotNull((Object)valueParameter);
                    DestructuringDeclaration multiDeclaration = valueParameter.getDestructuringDeclaration();
                    FirSession firSession = this.this$0.getBaseSession();
                    if (multiDeclaration != null) {
                        name = Name.special("<destruct>");
                    } else {
                        ValueParameter valueParameter2 = (ValueParameter)this.$parameter$inlined.element;
                        Intrinsics.checkNotNull((Object)valueParameter2);
                        name = valueParameter2.getFirValueParameter().getName();
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"if (multiDeclaration != \u2026!!.firValueParameter.name");
                    boolean $i$f$buildFunctionCall = false;
                    boolean bl6 = false;
                    FirFunctionCallBuilder firFunctionCallBuilder = new FirFunctionCallBuilder();
                    boolean bl7 = false;
                    boolean bl8 = false;
                    FirFunctionCallBuilder firFunctionCallBuilder2 = firFunctionCallBuilder;
                    Name name2 = name;
                    FirSourceElement firSourceElement = null;
                    FirSession firSession2 = firSession;
                    boolean bl9 = false;
                    boolean $i$f$buildSimpleNamedReference = false;
                    boolean bl10 = false;
                    FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
                    boolean bl11 = false;
                    boolean bl12 = false;
                    FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder;
                    void var23_30 = $this$buildFunctionCall;
                    boolean bl13 = false;
                    Name name3 = Name.identifier("next");
                    Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"Name.identifier(\"next\")");
                    $this$buildSimpleNamedReference.setName(name3);
                    Unit unit = Unit.INSTANCE;
                    var23_30.setCalleeReference(firSimpleNamedReferenceBuilder.build());
                    $this$buildFunctionCall.setExplicitReceiver(ConversionUtilsKt.generateResolvedAccessExpression(null, this.$iteratorVal));
                    Unit unit2 = Unit.INSTANCE;
                    FirExpression firExpression2 = firFunctionCallBuilder.build();
                    ValueParameter valueParameter3 = (ValueParameter)this.$parameter$inlined.element;
                    Intrinsics.checkNotNull((Object)valueParameter3);
                    FirVariable<?> firLoopParameter = ConversionUtilsKt.generateTemporaryVariable(firSession2, firSourceElement, name2, firExpression2, valueParameter3.getFirValueParameter().getReturnTypeRef());
                    if (multiDeclaration != null) {
                        FirExpression destructuringBlock = ConverterUtilKt.generateDestructuringBlock(this.this$0.getBaseSession(), multiDeclaration, firLoopParameter, true);
                        if (destructuringBlock instanceof FirBlock) {
                            boolean bl14 = false;
                            for (FirStatement statement2 : (Iterable)((FirBlock)destructuringBlock).getStatements()) {
                                void index2;
                                $this$block.getStatements().add((int)index2, statement2);
                                ++index2;
                            }
                        }
                    } else {
                        $this$block.getStatements().add(0, firLoopParameter);
                    }
                }
                return firBlockBuilder.build();
            }
        }));
        bl9 = false;
        collection.add(object3);
        return firBlockBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirBlock convertLoopBody(LighterASTNode body2) {
        FirBlock firBlock;
        FirBlock firBlock2 = null;
        FirStatement firStatement = null;
        LighterASTNode lighterASTNode2 = body2;
        if (lighterASTNode2 != null) {
            void $this$forEachChildren$iv;
            void this_$iv;
            LighterASTNode[] kidsArray$iv;
            LighterASTNode lighterASTNode3 = lighterASTNode2;
            BaseConverter baseConverter = this;
            Object[] skipTokens$iv = new KtToken[]{};
            boolean $i$f$forEachChildren = false;
            for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
                FirElement firElement;
                if (kid$iv == null) break;
                IElementType tokenType$iv = kid$iv.getTokenType();
                if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
                LighterASTNode it = kid$iv;
                boolean bl = false;
                IElementType iElementType = it.getTokenType();
                if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BLOCK)) {
                    firBlock2 = this.declarationsConverter.convertBlockExpression(it);
                    continue;
                }
                if (!ConverterUtilKt.isExpression(it)) continue;
                ExpressionsConverter this_$iv2 = this;
                String errorReason$iv = "";
                boolean $i$f$getAsFirExpression = false;
                LighterASTNode lighterASTNode4 = it;
                boolean bl2 = false;
                boolean bl3 = false;
                LighterASTNode it$iv = lighterASTNode4;
                boolean bl4 = false;
                FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
                if (!(firElement2 instanceof FirStatement)) {
                    firElement2 = null;
                }
                if ((firElement = (FirElement)((FirStatement)firElement2)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
                    }
                    firElement = firErrorExpression;
                }
                firStatement = (FirStatement)firElement;
            }
        }
        if (firStatement != null) {
            FirStatement firStatement2 = firStatement;
            Intrinsics.checkNotNull((Object)firStatement2);
            firBlock = new FirSingleExpressionBlock(firStatement2);
        } else if (firBlock2 == null) {
            firBlock = FirEmptyExpressionBlockBuilderKt.buildEmptyExpressionBlock();
        } else {
            FirBlock firBlock3 = firBlock2;
            firBlock = firBlock3;
            Intrinsics.checkNotNull((Object)firBlock3);
        }
        return firBlock;
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertTryExpression(LighterASTNode tryExpression) {
        boolean bl;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        FirBlock tryBlock = null;
        boolean bl2 = false;
        List catchClauses = new ArrayList();
        FirBlock finallyBlock = null;
        LighterASTNode lighterASTNode2 = tryExpression;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode lighterASTNode3 : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (lighterASTNode3 == null) break;
            IElementType tokenType$iv = lighterASTNode3.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it = lighterASTNode3;
            boolean bl3 = false;
            IElementType firCatchBuilder = it.getTokenType();
            if (Intrinsics.areEqual((Object)firCatchBuilder, (Object)KtNodeTypes.BLOCK)) {
                tryBlock = this.declarationsConverter.convertBlock(it);
                continue;
            }
            if (Intrinsics.areEqual((Object)firCatchBuilder, (Object)KtNodeTypes.CATCH)) {
                if (this.convertCatchClause(it) != null) {
                    Pair<ValueParameter, FirBlock> pair;
                    bl = false;
                    boolean bl4 = false;
                    Pair<ValueParameter, FirBlock> oneClause = pair;
                    boolean bl5 = false;
                    Collection collection = catchClauses;
                    boolean bl6 = false;
                    collection.add(oneClause);
                }
                continue;
            }
            if (!Intrinsics.areEqual((Object)firCatchBuilder, (Object)KtNodeTypes.FINALLY)) continue;
            finallyBlock = this.convertFinally(it);
        }
        boolean $i$f$buildTryExpression = false;
        boolean bl7 = false;
        FirTryExpressionBuilder firTryExpressionBuilder = new FirTryExpressionBuilder();
        boolean bl8 = false;
        boolean bl9 = false;
        FirTryExpressionBuilder $this$buildTryExpression = firTryExpressionBuilder;
        boolean bl10 = false;
        $this$buildTryExpression.setSource(BaseFirBuilder.toFirSourceElement$default(this, tryExpression, null, 1, null));
        FirBlock firBlock = tryBlock;
        if (firBlock == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tryBlock");
        }
        $this$buildTryExpression.setTryBlock(firBlock);
        $this$buildTryExpression.setFinallyBlock(finallyBlock);
        for (Pair pair : catchClauses) {
            ValueParameter valueParameter = (ValueParameter)pair.component1();
            FirBlock block = (FirBlock)pair.component2();
            if (valueParameter == null) continue;
            Collection collection = $this$buildTryExpression.getCatches();
            boolean $i$f$buildCatch = false;
            boolean bl14 = false;
            FirCatchBuilder firCatchBuilder = new FirCatchBuilder();
            boolean bl11 = false;
            bl = false;
            FirCatchBuilder $this$buildCatch = firCatchBuilder;
            boolean bl13 = false;
            $this$buildCatch.setParameter(valueParameter.getFirValueParameter());
            $this$buildCatch.setBlock(block);
            FirCatch firCatch = firCatchBuilder.build();
            boolean bl12 = false;
            collection.add(firCatch);
        }
        return firTryExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<ValueParameter, FirBlock> convertCatchClause(LighterASTNode catchClause) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        ValueParameter valueParameter = null;
        LighterASTNode blockNode = null;
        LighterASTNode lighterASTNode2 = catchClause;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.VALUE_PARAMETER_LIST)) {
                if ((ValueParameter)CollectionsKt.firstOrNull(this.declarationsConverter.convertValueParameters(it)) != null) continue;
                return null;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BLOCK)) continue;
            blockNode = it;
        }
        return new Pair((Object)valueParameter, (Object)this.declarationsConverter.convertBlock(blockNode));
    }

    /*
     * WARNING - void declaration
     */
    private final FirBlock convertFinally(LighterASTNode finallyExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        LighterASTNode blockNode = null;
        LighterASTNode lighterASTNode2 = finallyExpression;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (!Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BLOCK)) continue;
            blockNode = it;
        }
        return this.declarationsConverter.convertBlock(blockNode);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertIfExpression(LighterASTNode ifExpression) {
        Object it$iv;
        boolean bl;
        boolean bl2;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        FirExpression firCondition = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("If statement should have condition", DiagnosticKind.Syntax));
        LighterASTNode thenBlock = null;
        LighterASTNode elseBlock = null;
        LighterASTNode lighterASTNode2 = ifExpression;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv322 = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv322) || Intrinsics.areEqual((Object)tokenType$iv322, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv322, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv322)) continue;
            LighterASTNode it = kid$iv;
            boolean bl3 = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CONDITION)) {
                FirElement firElement;
                void this_$iv2;
                ExpressionsConverter expressionsConverter = this;
                String errorReason$iv = "If statement should have condition";
                boolean $i$f$getAsFirExpression = false;
                LighterASTNode lighterASTNode3 = it;
                bl2 = false;
                bl = false;
                it$iv = lighterASTNode3;
                boolean bl4 = false;
                FirElement firElement2 = this_$iv2.convertExpression((LighterASTNode)it$iv, errorReason$iv);
                if (!(firElement2 instanceof FirExpression)) {
                    firElement2 = null;
                }
                if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement = firErrorExpression;
                }
                firCondition = (FirExpression)firElement;
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.THEN)) {
                thenBlock = it;
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.ELSE)) continue;
            elseBlock = it;
        }
        boolean $i$f$buildWhenExpression = false;
        boolean bl5 = false;
        FirWhenExpressionBuilder firWhenExpressionBuilder = new FirWhenExpressionBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirWhenExpressionBuilder $this$buildWhenExpression = firWhenExpressionBuilder;
        boolean bl8 = false;
        FirBlock trueBranch = this.convertLoopBody(thenBlock);
        Collection collection = $this$buildWhenExpression.getBranches();
        boolean $i$f$buildWhenBranch = false;
        boolean tokenType$iv322 = false;
        FirWhenBranchBuilder tokenType$iv322 = new FirWhenBranchBuilder();
        boolean bl9 = false;
        boolean bl10 = false;
        FirWhenBranchBuilder $this$buildWhenBranch = tokenType$iv322;
        boolean bl11 = false;
        LighterASTNode lighterASTNode4 = thenBlock;
        $this$buildWhenBranch.setSource(lighterASTNode4 != null ? (FirLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, lighterASTNode4, null, 1, null) : null);
        $this$buildWhenBranch.setCondition(firCondition);
        $this$buildWhenBranch.setResult(trueBranch);
        Object object = tokenType$iv322.build();
        boolean tokenType$iv322 = false;
        collection.add(object);
        if (elseBlock != null) {
            FirBlock elseBranch = this.convertLoopBody(elseBlock);
            object = $this$buildWhenExpression.getBranches();
            boolean $i$f$buildWhenBranch2 = false;
            bl9 = false;
            FirWhenBranchBuilder firWhenBranchBuilder = new FirWhenBranchBuilder();
            bl10 = false;
            boolean bl12 = false;
            FirWhenBranchBuilder $this$buildWhenBranch2 = firWhenBranchBuilder;
            boolean bl13 = false;
            LighterASTNode lighterASTNode5 = elseBlock;
            $this$buildWhenBranch2.setSource(lighterASTNode5 != null ? (FirLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, lighterASTNode5, null, 1, null) : null);
            boolean $i$f$buildElseIfTrueCondition = false;
            boolean bl14 = false;
            FirElseIfTrueConditionBuilder firElseIfTrueConditionBuilder = new FirElseIfTrueConditionBuilder();
            bl2 = false;
            bl = false;
            it$iv = firElseIfTrueConditionBuilder;
            FirWhenBranchBuilder firWhenBranchBuilder2 = $this$buildWhenBranch2;
            Unit unit = Unit.INSTANCE;
            firWhenBranchBuilder2.setCondition(firElseIfTrueConditionBuilder.build());
            $this$buildWhenBranch2.setResult(elseBranch);
            FirWhenBranch firWhenBranch = firWhenBranchBuilder.build();
            boolean bl15 = false;
            object.add(firWhenBranch);
        }
        return firWhenExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertLoopJump(LighterASTNode jump) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        boolean isBreak = true;
        LighterASTNode lighterASTNode2 = jump;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (!Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.CONTINUE_KEYWORD)) continue;
            isBreak = false;
        }
        FirLoopJumpBuilder jumpBuilder = isBreak ? new FirBreakExpressionBuilder() : new FirContinueExpressionBuilder();
        FirLightSourceElement sourceElement = (FirLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, jump, null, 1, null);
        FirLoopJumpBuilder firLoopJumpBuilder = jumpBuilder;
        boolean bl = false;
        boolean bl2 = false;
        FirLoopJumpBuilder firLoopJumpBuilder2 = firLoopJumpBuilder;
        ExpressionsConverter expressionsConverter = this;
        boolean bl3 = false;
        ((FirLoopJumpBuilder)firLoopJumpBuilder2).setSource(sourceElement);
        Unit unit = Unit.INSTANCE;
        return expressionsConverter.bindLabel(firLoopJumpBuilder, jump).build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertReturn(LighterASTNode returnExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        String labelName = null;
        boolean $i$f$buildUnitExpression22 = false;
        boolean bl = false;
        FirUnitExpressionBuilder firUnitExpressionBuilder = new FirUnitExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirUnitExpressionBuilder $receiver = firUnitExpressionBuilder;
        Unit unit = Unit.INSTANCE;
        FirExpression firExpression2 = firUnitExpressionBuilder.build();
        LighterASTNode $i$f$buildUnitExpression22 = returnExpression;
        BaseConverter init$iv = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl4 = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.LABEL_QUALIFIER)) {
                labelName = StringsKt.replace$default((String)ConverterUtilKt.getAsStringWithoutBacktick(it), (String)"@", (String)"", (boolean)false, (int)4, null);
                continue;
            }
            if (!ConverterUtilKt.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "Incorrect return expression";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode2 = it;
            boolean bl5 = false;
            boolean bl6 = false;
            LighterASTNode it$iv = lighterASTNode2;
            boolean bl7 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression2 = (FirExpression)firElement;
        }
        return BaseFirBuilder.toReturn$default(this, firExpression2, null, labelName, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertThrow(LighterASTNode throwExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        FirExpression firExpression2 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("Nothing to throw", DiagnosticKind.Syntax));
        LighterASTNode lighterASTNode2 = throwExpression;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (!ConverterUtilKt.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "Nothing to throw";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode3 = it;
            boolean bl2 = false;
            boolean bl3 = false;
            LighterASTNode it$iv = lighterASTNode3;
            boolean bl4 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression2 = (FirExpression)firElement;
        }
        boolean $i$f$buildThrowExpression = false;
        boolean bl = false;
        FirThrowExpressionBuilder firThrowExpressionBuilder = new FirThrowExpressionBuilder();
        boolean bl5 = false;
        boolean bl6 = false;
        FirThrowExpressionBuilder $this$buildThrowExpression = firThrowExpressionBuilder;
        boolean bl7 = false;
        $this$buildThrowExpression.setSource(BaseFirBuilder.toFirSourceElement$default(this, throwExpression, null, 1, null));
        $this$buildThrowExpression.setException(firExpression2);
        return firThrowExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirQualifiedAccessExpression convertThisExpression(LighterASTNode thisExpression) {
        void $this$buildExplicitThisReference;
        String label = this.getLabelName(thisExpression);
        boolean $i$f$buildThisReceiverExpression = false;
        boolean bl = false;
        FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirThisReceiverExpressionBuilder $this$buildThisReceiverExpression = firThisReceiverExpressionBuilder;
        boolean bl4 = false;
        $this$buildThisReceiverExpression.setSource(BaseFirBuilder.toFirSourceElement$default(this, thisExpression, null, 1, null));
        boolean $i$f$buildExplicitThisReference = false;
        boolean bl5 = false;
        FirExplicitThisReferenceBuilder firExplicitThisReferenceBuilder = new FirExplicitThisReferenceBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirExplicitThisReferenceBuilder firExplicitThisReferenceBuilder2 = firExplicitThisReferenceBuilder;
        FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder2 = $this$buildThisReceiverExpression;
        boolean bl8 = false;
        $this$buildExplicitThisReference.setLabelName(label);
        Unit unit = Unit.INSTANCE;
        firThisReceiverExpressionBuilder2.setCalleeReference(firExplicitThisReferenceBuilder.build());
        return firThisReceiverExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirQualifiedAccessExpression convertSuperExpression(LighterASTNode superExpression) {
        void $this$buildExplicitSuperReference;
        Object it;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        String label = this.getLabelName(superExpression);
        FirTypeRef superTypeRef = this.getImplicitType();
        LighterASTNode lighterASTNode2 = superExpression;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (!Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.TYPE_REFERENCE)) continue;
            superTypeRef = this.declarationsConverter.convertType((LighterASTNode)it);
        }
        boolean $i$f$buildQualifiedAccessExpression = false;
        boolean bl = false;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder = new FirQualifiedAccessExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirQualifiedAccessExpressionBuilder $this$buildQualifiedAccessExpression = firQualifiedAccessExpressionBuilder;
        boolean bl4 = false;
        $this$buildQualifiedAccessExpression.setSource(BaseFirBuilder.toFirSourceElement$default(this, superExpression, null, 1, null));
        boolean $i$f$buildExplicitSuperReference = false;
        int n = 0;
        FirExplicitSuperReferenceBuilder firExplicitSuperReferenceBuilder = new FirExplicitSuperReferenceBuilder();
        boolean bl5 = false;
        boolean bl6 = false;
        it = firExplicitSuperReferenceBuilder;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder2 = $this$buildQualifiedAccessExpression;
        boolean bl7 = false;
        $this$buildExplicitSuperReference.setLabelName(label);
        $this$buildExplicitSuperReference.setSuperTypeRef(superTypeRef);
        Unit unit = Unit.INSTANCE;
        firQualifiedAccessExpressionBuilder2.setCalleeReference(firExplicitSuperReferenceBuilder.build());
        return firQualifiedAccessExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirExpression> convertValueArguments(@NotNull LighterASTNode valueArguments) {
        void $this$forEachChildrenReturnList$iv;
        Intrinsics.checkNotNullParameter((Object)valueArguments, (String)"valueArguments");
        LighterASTNode lighterASTNode2 = valueArguments;
        BaseConverter this_$iv = this;
        boolean $i$f$forEachChildrenReturnList = false;
        LighterASTNode[] kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildrenReturnList$iv);
        boolean bl = false;
        List container$iv = new ArrayList();
        for (LighterASTNode kid$iv : kidsArray$iv) {
            FirElement firElement;
            void this_$iv2;
            boolean bl2;
            FirExpression firExpression2;
            Collection collection;
            void container2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON)) continue;
            List list2 = container$iv;
            LighterASTNode node = kid$iv;
            boolean bl3 = false;
            IElementType iElementType = node.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.VALUE_ARGUMENT)) {
                collection = (Collection)container2;
                firExpression2 = this.convertValueArgument(node);
                bl2 = false;
                collection.add(firExpression2);
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.LAMBDA_EXPRESSION) && !Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.LABELED_EXPRESSION) && !Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.ANNOTATED_EXPRESSION)) continue;
            collection = (Collection)container2;
            boolean $i$f$buildLambdaArgumentExpression = false;
            bl2 = false;
            FirLambdaArgumentExpressionBuilder firLambdaArgumentExpressionBuilder = new FirLambdaArgumentExpressionBuilder();
            boolean bl4 = false;
            boolean bl5 = false;
            FirLambdaArgumentExpressionBuilder $this$buildLambdaArgumentExpression = firLambdaArgumentExpressionBuilder;
            boolean bl6 = false;
            $this$buildLambdaArgumentExpression.setSource(BaseFirBuilder.toFirSourceElement$default(this, valueArguments, null, 1, null));
            ExpressionsConverter expressionsConverter = this;
            LighterASTNode expression$iv = node;
            String errorReason$iv = "";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode3 = expression$iv;
            boolean bl7 = false;
            boolean bl8 = false;
            LighterASTNode it$iv = lighterASTNode3;
            boolean bl9 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            $this$buildLambdaArgumentExpression.setExpression((FirExpression)firElement);
            firExpression2 = firLambdaArgumentExpressionBuilder.build();
            bl2 = false;
            collection.add(firExpression2);
        }
        return container$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertValueArgument(LighterASTNode valueArgument) {
        FirExpression firExpression2;
        boolean bl;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        String identifier = null;
        boolean isSpread = false;
        FirExpression firExpression3 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("Argument is absent", DiagnosticKind.Syntax));
        LighterASTNode lighterASTNode2 = valueArgument;
        BaseConverter baseConverter = this;
        Object[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.WHITE_SPACE) || Intrinsics.areEqual((Object)tokenType$iv, (Object)KtTokens.SEMICOLON) || ArraysKt.contains((Object[])skipTokens$iv, (Object)tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl2 = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.VALUE_ARGUMENT_NAME)) {
                identifier = this.getAsText(it);
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MUL)) {
                isSpread = true;
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.STRING_TEMPLATE)) {
                firExpression3 = this.convertStringTemplate(it);
                continue;
            }
            if (iElementType instanceof KtConstantExpressionElementType) {
                firExpression3 = this.convertConstantExpression(it);
                continue;
            }
            if (!ConverterUtilKt.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "Argument is absent";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode3 = it;
            boolean bl3 = false;
            boolean bl4 = false;
            LighterASTNode it$iv = lighterASTNode3;
            boolean bl5 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression3 = (FirExpression)firElement;
        }
        if (identifier != null) {
            boolean $i$f$buildNamedArgumentExpression = false;
            boolean bl6 = false;
            FirNamedArgumentExpressionBuilder firNamedArgumentExpressionBuilder = new FirNamedArgumentExpressionBuilder();
            boolean bl7 = false;
            bl = false;
            FirNamedArgumentExpressionBuilder $this$buildNamedArgumentExpression = firNamedArgumentExpressionBuilder;
            boolean bl8 = false;
            $this$buildNamedArgumentExpression.setSource(BaseFirBuilder.toFirSourceElement$default(this, valueArgument, null, 1, null));
            $this$buildNamedArgumentExpression.setExpression(firExpression3);
            $this$buildNamedArgumentExpression.setSpread(isSpread);
            $this$buildNamedArgumentExpression.setName(ConverterUtilKt.nameAsSafeName$default(identifier, null, 1, null));
            firExpression2 = firNamedArgumentExpressionBuilder.build();
        } else if (isSpread) {
            boolean $i$f$buildSpreadArgumentExpression = false;
            boolean bl9 = false;
            FirSpreadArgumentExpressionBuilder firSpreadArgumentExpressionBuilder = new FirSpreadArgumentExpressionBuilder();
            boolean bl10 = false;
            bl = false;
            FirSpreadArgumentExpressionBuilder $this$buildSpreadArgumentExpression = firSpreadArgumentExpressionBuilder;
            boolean bl11 = false;
            $this$buildSpreadArgumentExpression.setSource(BaseFirBuilder.toFirSourceElement$default(this, valueArgument, null, 1, null));
            $this$buildSpreadArgumentExpression.setExpression(firExpression3);
            firExpression2 = firSpreadArgumentExpressionBuilder.build();
        } else {
            firExpression2 = firExpression3;
        }
        return firExpression2;
    }

    public ExpressionsConverter(@NotNull FirSession session2, boolean stubMode, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull DeclarationsConverter declarationsConverter, int offset2, @NotNull Context<LighterASTNode> context2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)declarationsConverter, (String)"declarationsConverter");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        super(session2, tree, offset2, context2);
        this.stubMode = stubMode;
        this.declarationsConverter = declarationsConverter;
    }

    public /* synthetic */ ExpressionsConverter(FirSession firSession, boolean bl, FlyweightCapableTreeStructure flyweightCapableTreeStructure, DeclarationsConverter declarationsConverter, int n, Context context2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            context2 = new Context<LighterASTNode>();
        }
        this(firSession, bl, flyweightCapableTreeStructure, declarationsConverter, n, context2);
    }

    public static final /* synthetic */ DeclarationsConverter access$getDeclarationsConverter$p(ExpressionsConverter $this) {
        return $this.declarationsConverter;
    }

    public static final /* synthetic */ FirExpression access$convertShortOrLongStringTemplate(ExpressionsConverter $this, LighterASTNode $this$access_u24convertShortOrLongStringTemplate, String errorReason) {
        return $this.convertShortOrLongStringTemplate($this$access_u24convertShortOrLongStringTemplate, errorReason);
    }

    public static final /* synthetic */ FirBlock access$convertLoopBody(ExpressionsConverter $this, LighterASTNode body2) {
        return $this.convertLoopBody(body2);
    }
}

