/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ImmutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import org.jetbrains.kotlin.fir.analysis.cfa.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.PathAwarePropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.PropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.TraverseDirection;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.QualifiedAccessNode;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0016\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\f0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirPropertyInitializationAnalyzer;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "()V", "analyze", "", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "data", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/PathAwarePropertyInitializationInfo;", "properties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "UninitializedPropertyReporter", "checkers"})
public final class FirPropertyInitializationAnalyzer
extends AbstractFirPropertyInitializationChecker {
    @NotNull
    public static final FirPropertyInitializationAnalyzer INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    public void analyze(@NotNull ControlFlowGraph graph2, @NotNull DiagnosticReporter reporter, @NotNull Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data, @NotNull Set<? extends FirPropertySymbol> properties2) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)graph2, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(properties2, (String)"properties");
        Map<CFGNode<?>, PathAwarePropertyInitializationInfo> $this$filter$iv = data;
        boolean $i$f$filter = false;
        Map<CFGNode<?>, PathAwarePropertyInitializationInfo> map2 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var11_13 = $this$filterTo$iv$iv2;
        boolean bl = false;
        Iterator iterator2 = var11_13.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            Object e = ((CFGNode)it.getKey()).getFir();
            if (!(e instanceof FirVariableSymbol)) {
                e = null;
            }
            FirVariableSymbol firVariableSymbol = (FirVariableSymbol)e;
            FirVariable symbolFir = firVariableSymbol != null ? (FirVariable)firVariableSymbol.getFir() : null;
            if (!(symbolFir == null || symbolFir.getInitializer() == null && symbolFir.getDelegate() == null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map localData = destination$iv$iv;
        Iterable $this$filter$iv2 = properties2;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirPropertySymbol it = (FirPropertySymbol)element$iv$iv;
            boolean bl3 = false;
            if (!(((FirProperty)it.getFir()).getInitializer() == null && ((FirProperty)it.getFir()).getDelegate() == null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set localProperties = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        UninitializedPropertyReporter reporterVisitor = new UninitializedPropertyReporter(localData, localProperties, reporter);
        CfgTraverserKt.traverse(graph2, TraverseDirection.Forward, reporterVisitor);
    }

    private FirPropertyInitializationAnalyzer() {
    }

    static {
        FirPropertyInitializationAnalyzer firPropertyInitializationAnalyzer;
        INSTANCE = firPropertyInitializationAnalyzer = new FirPropertyInitializationAnalyzer();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0016\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0014\u0010\u0019\u001a\u00020\u001a2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R!\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirPropertyInitializationAnalyzer$UninitializedPropertyReporter;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "data", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/PathAwarePropertyInitializationInfo;", "localProperties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "(Ljava/util/Map;Ljava/util/Set;Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;)V", "getData", "()Ljava/util/Map;", "getLocalProperties", "()Ljava/util/Set;", "getReporter", "()Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "investigate", "", "info", "Lorg/jetbrains/kotlin/fir/analysis/cfa/PropertyInitializationInfo;", "symbol", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/QualifiedAccessNode;", "visitNode", "", "visitQualifiedAccessNode", "checkers"})
    private static final class UninitializedPropertyReporter
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data;
        @NotNull
        private final Set<FirPropertySymbol> localProperties;
        @NotNull
        private final DiagnosticReporter reporter;

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
        }

        @Override
        public void visitQualifiedAccessNode(@NotNull QualifiedAccessNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            FirReference firReference = node.getFir().getCalleeReference();
            if (!(firReference instanceof FirResolvedNamedReference)) {
                firReference = null;
            }
            FirResolvedNamedReference firResolvedNamedReference = (FirResolvedNamedReference)firReference;
            if (firResolvedNamedReference == null) {
                return;
            }
            FirResolvedNamedReference reference = firResolvedNamedReference;
            AbstractFirBasedSymbol<?> abstractFirBasedSymbol = reference.getResolvedSymbol();
            if (!(abstractFirBasedSymbol instanceof FirPropertySymbol)) {
                abstractFirBasedSymbol = null;
            }
            FirPropertySymbol firPropertySymbol = (FirPropertySymbol)abstractFirBasedSymbol;
            if (firPropertySymbol == null) {
                return;
            }
            FirPropertySymbol symbol2 = firPropertySymbol;
            if (!this.localProperties.contains(symbol2)) {
                return;
            }
            FirMemberDeclaration $this$isLateInit$iv = (FirMemberDeclaration)symbol2.getFir();
            boolean $i$f$isLateInit = false;
            if ($this$isLateInit$iv.getStatus().isLateInit()) {
                return;
            }
            PathAwarePropertyInitializationInfo pathAwareInfo = (PathAwarePropertyInitializationInfo)MapsKt.getValue(this.data, (Object)node);
            for (EdgeLabel label : (ImmutableSet)pathAwareInfo.keySet()) {
                Object s = pathAwareInfo.get((Object)label);
                Intrinsics.checkNotNull(s);
                if (!this.investigate((PropertyInitializationInfo)s, symbol2, node)) continue;
                break;
            }
        }

        private final boolean investigate(PropertyInitializationInfo info, FirPropertySymbol symbol2, QualifiedAccessNode node) {
            EventOccurrencesRange kind;
            EventOccurrencesRange eventOccurrencesRange = (EventOccurrencesRange)((Object)info.get(symbol2));
            if (eventOccurrencesRange == null) {
                eventOccurrencesRange = kind = EventOccurrencesRange.ZERO;
            }
            if (!EventOccurrencesRangeKt.isDefinitelyVisited(kind)) {
                FirSourceElement firSourceElement = node.getFir().getSource();
                if (firSourceElement != null) {
                    FirSourceElement firSourceElement2 = firSourceElement;
                    boolean bl = false;
                    boolean bl2 = false;
                    FirSourceElement it = firSourceElement2;
                    boolean bl3 = false;
                    this.reporter.report((FirDiagnostic)FirErrors.INSTANCE.getUNINITIALIZED_VARIABLE().on(it, symbol2));
                    return true;
                }
            }
            return false;
        }

        @NotNull
        public final Map<CFGNode<?>, PathAwarePropertyInitializationInfo> getData() {
            return this.data;
        }

        @NotNull
        public final Set<FirPropertySymbol> getLocalProperties() {
            return this.localProperties;
        }

        @NotNull
        public final DiagnosticReporter getReporter() {
            return this.reporter;
        }

        public UninitializedPropertyReporter(@NotNull Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data, @NotNull Set<? extends FirPropertySymbol> localProperties, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            Intrinsics.checkNotNullParameter(localProperties, (String)"localProperties");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            this.data = data;
            this.localProperties = localProperties;
            this.reporter = reporter;
        }
    }
}

