/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.builder.FirResolvedQualifierBuilder;
import org.jetbrains.kotlin.fir.references.impl.FirSimpleNamedReference;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.transformers.FirImportResolveTransformerKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PackageOrClass;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\rJ\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/FirQualifiedNameResolver;", "", "components", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "(Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;)V", "qualifierPartsToDrop", "", "qualifierStack", "", "Lorg/jetbrains/kotlin/name/Name;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "initProcessingQualifiedAccess", "", "callee", "Lorg/jetbrains/kotlin/fir/references/impl/FirSimpleNamedReference;", "isPotentialQualifierPartPosition", "", "replacedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "qualifiedAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;", "reset", "tryResolveAsQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "resolve"})
public final class FirQualifiedNameResolver {
    private final FirSession session;
    private List<Name> qualifierStack;
    private int qualifierPartsToDrop;
    private final BodyResolveComponents components;

    public final void reset() {
        this.qualifierStack.clear();
        this.qualifierPartsToDrop = 0;
    }

    public final boolean isPotentialQualifierPartPosition() {
        return this.qualifierStack.size() > 1;
    }

    public final void initProcessingQualifiedAccess(@NotNull FirSimpleNamedReference callee) {
        Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
        if (callee.getName().isSpecial()) {
            this.qualifierStack.clear();
        } else {
            this.qualifierStack.add(callee.getName());
        }
    }

    @Nullable
    public final FirStatement replacedQualifier(@NotNull FirQualifiedAccess qualifiedAccess) {
        FirStatement firStatement;
        Intrinsics.checkNotNullParameter((Object)qualifiedAccess, (String)"qualifiedAccess");
        if (this.qualifierPartsToDrop > 0) {
            int n = this.qualifierPartsToDrop;
            this.qualifierPartsToDrop = n + -1;
            FirExpression firExpression2 = qualifiedAccess.getExplicitReceiver();
            firStatement = firExpression2 != null ? (FirStatement)firExpression2 : (FirStatement)qualifiedAccess;
        } else {
            firStatement = null;
        }
        return firStatement;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FirResolvedQualifier tryResolveAsQualifier(@Nullable FirSourceElement source) {
        void $this$mapTo$iv$iv;
        if (this.qualifierStack.isEmpty()) {
            return null;
        }
        FirSymbolProvider symbolProvider2 = MainSessionComponentsKt.getFirSymbolProvider(this.session);
        Iterable $this$map$iv = CollectionsKt.asReversedMutable(this.qualifierStack);
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Name name = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.asString();
            collection.add(string2);
        }
        List qualifierParts = (List)destination$iv$iv;
        PackageOrClass resolved = null;
        do {
            FqName fqName2 = FqName.fromSegments(qualifierParts);
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"FqName.fromSegments(qualifierParts)");
            resolved = FirImportResolveTransformerKt.resolveToPackageOrClass(symbolProvider2, fqName2);
            if (resolved == null) {
                qualifierParts = CollectionsKt.dropLast((List)qualifierParts, (int)1);
            }
            if (resolved != null) break;
            Collection $i$f$map2 = qualifierParts;
            boolean bl = false;
        } while (!$i$f$map2.isEmpty());
        if (resolved != null) {
            void type$iv;
            this.qualifierPartsToDrop = qualifierParts.size() - 1;
            boolean $i$f$buildResolvedQualifier = false;
            boolean bl = false;
            FirResolvedQualifierBuilder firResolvedQualifierBuilder = new FirResolvedQualifierBuilder();
            boolean bl2 = false;
            $i$f$mapTo = false;
            FirResolvedQualifierBuilder $this$buildResolvedQualifier = firResolvedQualifierBuilder;
            boolean $i$a$-buildResolvedQualifier-FirQualifiedNameResolver$tryResolveAsQualifier$22 = false;
            $this$buildResolvedQualifier.setSource(source);
            $this$buildResolvedQualifier.setPackageFqName(resolved.getPackageFqName());
            $this$buildResolvedQualifier.setRelativeClassFqName(resolved.getRelativeClassFqName());
            $this$buildResolvedQualifier.setSymbol(resolved.getClassSymbol());
            FirResolvedQualifier firResolvedQualifier = firResolvedQualifierBuilder.build();
            boolean bl3 = false;
            bl2 = false;
            FirResolvedQualifier $this$apply = firResolvedQualifier;
            boolean bl4 = false;
            FirTypeRef $i$a$-buildResolvedQualifier-FirQualifiedNameResolver$tryResolveAsQualifier$22 = ResolveUtilsKt.typeForQualifier(this.components, $this$apply);
            FirExpression $this$resultType$iv = $this$apply;
            boolean $i$f$setResultType = false;
            $this$resultType$iv.replaceTypeRef((FirTypeRef)type$iv);
            return firResolvedQualifier;
        }
        return null;
    }

    public FirQualifiedNameResolver(@NotNull BodyResolveComponents components) {
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        this.components = components;
        this.session = this.components.getSession();
        boolean bl = false;
        this.qualifierStack = new ArrayList();
    }
}

