/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirEffectiveVisibility;
import org.jetbrains.kotlin.fir.FirEffectiveVisibilityImpl;
import org.jetbrains.kotlin.fir.FirEffectiveVisibilityResolver;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rH\u0014J&\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015J4\u0010\u0016\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\b\u0018\u00010\u0017*\u00020\u00182\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0019\u001a\u00020\b*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rH\u0004J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u0018*\u00020\u0013H\u0002J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u0018*\u00020\u0013H\u0002J6\u0010\u001c\u001a\u0014\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\r\u0012\u0004\u0012\u00020\b0\u0017*\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u001d\u001a\u00020\b*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\bH\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/FirEffectiveVisibilityResolverImpl;", "Lorg/jetbrains/kotlin/fir/FirEffectiveVisibilityResolver;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "cache", "", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "Lorg/jetbrains/kotlin/fir/FirEffectiveVisibility;", "computeEffectiveVisibility", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "containerSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "resolveFor", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "containingDeclarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "findOuterContainerInfo", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/name/ClassId;", "forVisibility", "getClassId", "getParentClassId", "getParentInfo", "remember", "Lorg/jetbrains/kotlin/fir/FirElement;", "effectiveVisibility", "resolve"})
public class FirEffectiveVisibilityResolverImpl
extends FirEffectiveVisibilityResolver {
    private final Map<FirSourceElement, FirEffectiveVisibility> cache;
    private final FirSession session;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final FirEffectiveVisibility resolveFor(@NotNull FirMemberDeclaration declaration2, @Nullable List<? extends FirDeclaration> containingDeclarations, @NotNull ScopeSession scopeSession) {
        void parentSymbol;
        Object object;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        if (declaration2.getSource() != null) {
            object = this.cache;
            FirSourceElement firSourceElement = declaration2.getSource();
            boolean bl = false;
            FirEffectiveVisibility firEffectiveVisibility = object.get(firSourceElement);
            if (firEffectiveVisibility != null) {
                object = firEffectiveVisibility;
                boolean bl2 = false;
                bl = false;
                Object it = object;
                boolean bl3 = false;
                return it;
            }
        }
        Pair<FirClassLikeSymbol<?>, FirEffectiveVisibility> pair = this.getParentInfo(declaration2, containingDeclarations, scopeSession);
        object = (FirClassLikeSymbol)pair.component1();
        FirEffectiveVisibility parentEffectiveVisibility = (FirEffectiveVisibility)pair.component2();
        FirMemberDeclaration $this$visibility$iv = declaration2;
        boolean $i$f$getVisibility = false;
        Visibility visibility2 = $this$visibility$iv.getStatus().getVisibility();
        if (declaration2 instanceof FirSimpleFunction) {
            void v1 = parentSymbol;
            FirClassLikeDeclaration $this$safeAs$iv = v1 != null ? (FirClassLikeDeclaration)v1.getFir() : null;
            boolean $i$f$safeAs = false;
            FirClassLikeDeclaration firClassLikeDeclaration = $this$safeAs$iv;
            if (!(firClassLikeDeclaration instanceof FirClass)) {
                firClassLikeDeclaration = null;
            }
            FirClass firClass = (FirClass)firClassLikeDeclaration;
            if (firClass != null) {
                $this$safeAs$iv = firClass;
                boolean bl = false;
                boolean bl4 = false;
                FirClassLikeDeclaration it = $this$safeAs$iv;
                boolean bl5 = false;
                visibility2 = SessionUtilsKt.lowestVisibilityAmongOverrides((FirSimpleFunction)declaration2, it, this.session, scopeSession);
            }
        }
        FirEffectiveVisibility selfEffectiveVisibility = this.computeEffectiveVisibility(visibility2, (FirClassLikeSymbol<?>)parentSymbol);
        selfEffectiveVisibility = parentEffectiveVisibility.lowerBound(selfEffectiveVisibility);
        return this.remember(declaration2, selfEffectiveVisibility);
    }

    @NotNull
    protected FirEffectiveVisibility computeEffectiveVisibility(@NotNull Visibility visibility2, @Nullable FirClassLikeSymbol<?> containerSymbol) {
        Intrinsics.checkNotNullParameter((Object)visibility2, (String)"visibility");
        return this.forVisibility(visibility2.normalize(), containerSymbol);
    }

    @NotNull
    protected final FirEffectiveVisibility forVisibility(@NotNull Visibility $this$forVisibility, @Nullable FirClassLikeSymbol<?> containerSymbol) {
        FirEffectiveVisibility firEffectiveVisibility;
        Intrinsics.checkNotNullParameter((Object)$this$forVisibility, (String)"$this$forVisibility");
        Visibility visibility2 = $this$forVisibility;
        if (Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Private.INSTANCE) || Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.PrivateToThis.INSTANCE) || Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.InvisibleFake.INSTANCE)) {
            firEffectiveVisibility = FirEffectiveVisibilityImpl.Private.INSTANCE;
        } else if (Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Protected.INSTANCE)) {
            firEffectiveVisibility = new FirEffectiveVisibilityImpl.Protected(containerSymbol, this.session);
        } else if (Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Internal.INSTANCE)) {
            firEffectiveVisibility = FirEffectiveVisibilityImpl.Internal.INSTANCE;
        } else if (Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Public.INSTANCE)) {
            firEffectiveVisibility = FirEffectiveVisibilityImpl.Public.INSTANCE;
        } else if (Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Local.INSTANCE)) {
            firEffectiveVisibility = FirEffectiveVisibilityImpl.Local.INSTANCE;
        } else if (Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Unknown.INSTANCE)) {
            firEffectiveVisibility = FirEffectiveVisibilityImpl.Private.INSTANCE;
        } else {
            String string2 = "Visibility " + $this$forVisibility.getName() + " is not allowed in forVisibility";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return firEffectiveVisibility;
    }

    private final FirEffectiveVisibility remember(FirElement $this$remember, FirEffectiveVisibility effectiveVisibility) {
        FirSourceElement source = $this$remember.getSource();
        if (source != null) {
            this.cache.put(source, effectiveVisibility);
        }
        return effectiveVisibility;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Pair<FirClassLikeSymbol<?>, FirEffectiveVisibility> getParentInfo(FirMemberDeclaration $this$getParentInfo, List<? extends FirDeclaration> containingDeclarations, ScopeSession scopeSession) {
        Object it;
        boolean bl;
        boolean bl2;
        FirEffectiveVisibility parentEffectiveVisibility = FirEffectiveVisibilityImpl.Public.INSTANCE;
        FirClassLikeSymbol<?> parentSymbol = null;
        ClassId parentClassId = this.getParentClassId($this$getParentInfo);
        boolean succeededToGetSymbol = false;
        if (parentClassId != null && containingDeclarations != null) {
            Pair<FirClassLikeSymbol<?>, FirEffectiveVisibility> pair = this.findOuterContainerInfo(parentClassId, containingDeclarations, scopeSession);
            if (pair != null) {
                Pair<FirClassLikeSymbol<?>, FirEffectiveVisibility> pair2 = pair;
                bl2 = false;
                bl = false;
                it = pair2;
                boolean bl3 = false;
                parentSymbol = (FirClassLikeSymbol<?>)it.getFirst();
                parentEffectiveVisibility = (FirEffectiveVisibility)it.getSecond();
                succeededToGetSymbol = true;
            }
        }
        if (succeededToGetSymbol) return TuplesKt.to((Object)parentSymbol, (Object)parentEffectiveVisibility);
        ClassId classId = parentClassId;
        if (classId != null) {
            if (!classId.isLocal()) {
                FirClassLikeSymbol<?> firClassLikeSymbol = MainSessionComponentsKt.getFirSymbolProvider($this$getParentInfo.getSession()).getClassLikeSymbolByFqName(parentClassId);
                if (firClassLikeSymbol == null) {
                    ClassId classId2 = parentClassId.getOuterClassId();
                    if (classId2 != null) {
                        FirClassLikeSymbol<?> firClassLikeSymbol2;
                        ClassId classId3 = classId2;
                        bl2 = false;
                        bl = false;
                        it = classId3;
                        boolean bl4 = false;
                        FirSymbolProvider firSymbolProvider = MainSessionComponentsKt.getFirSymbolProvider($this$getParentInfo.getSession());
                        Object object = it;
                        Intrinsics.checkNotNullExpressionValue(object, (String)"it");
                        firClassLikeSymbol = firClassLikeSymbol2 = firSymbolProvider.getClassLikeSymbolByFqName((ClassId)object);
                    } else {
                        firClassLikeSymbol = null;
                    }
                }
                FirClassLikeSymbol<?> firClassLikeSymbol3 = parentSymbol = firClassLikeSymbol;
                FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol3 != null ? (FirClassLikeDeclaration)firClassLikeSymbol3.getFir() : null;
                boolean $i$f$safeAs = false;
                FirClassLikeDeclaration firClassLikeDeclaration2 = firClassLikeDeclaration;
                if (!(firClassLikeDeclaration2 instanceof FirMemberDeclaration)) {
                    firClassLikeDeclaration2 = null;
                }
                FirMemberDeclaration firMemberDeclaration = (FirMemberDeclaration)((Object)firClassLikeDeclaration2);
                if (firMemberDeclaration == null) return TuplesKt.to((Object)parentSymbol, (Object)parentEffectiveVisibility);
                FirMemberDeclaration firMemberDeclaration2 = firMemberDeclaration;
                bl2 = false;
                bl = false;
                it = firMemberDeclaration2;
                boolean bl5 = false;
                parentEffectiveVisibility = this.resolveFor((FirMemberDeclaration)it, null, scopeSession);
                return TuplesKt.to((Object)parentSymbol, (Object)parentEffectiveVisibility);
            }
        }
        ClassId classId4 = parentClassId;
        if (classId4 == null) return TuplesKt.to((Object)parentSymbol, (Object)parentEffectiveVisibility);
        if (!classId4.isLocal()) return TuplesKt.to((Object)parentSymbol, (Object)parentEffectiveVisibility);
        parentEffectiveVisibility = FirEffectiveVisibilityImpl.Local.INSTANCE;
        return TuplesKt.to((Object)parentSymbol, (Object)parentEffectiveVisibility);
    }

    private final ClassId getParentClassId(FirDeclaration $this$getParentClassId) {
        ClassId classId;
        FirDeclaration firDeclaration = $this$getParentClassId;
        if (firDeclaration instanceof FirCallableMemberDeclaration) {
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass((FirCallableDeclaration)$this$getParentClassId);
            classId = coneClassLikeLookupTag != null ? coneClassLikeLookupTag.getClassId() : null;
        } else {
            classId = firDeclaration instanceof FirClassLikeDeclaration ? ((FirClassLikeDeclaration)$this$getParentClassId).getSymbol().getClassId().getOuterClassId() : null;
        }
        return classId;
    }

    private final ClassId getClassId(FirDeclaration $this$getClassId) {
        ClassId classId;
        FirDeclaration firDeclaration = $this$getClassId;
        if (firDeclaration instanceof FirCallableMemberDeclaration) {
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass((FirCallableDeclaration)$this$getClassId);
            classId = coneClassLikeLookupTag != null ? coneClassLikeLookupTag.getClassId() : null;
        } else {
            classId = firDeclaration instanceof FirClassLikeDeclaration ? ((FirClassLikeDeclaration)$this$getClassId).getSymbol().getClassId() : null;
        }
        return classId;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<FirClassLikeSymbol<?>, FirEffectiveVisibility> findOuterContainerInfo(ClassId $this$findOuterContainerInfo, List<? extends FirDeclaration> containingDeclarations, ScopeSession scopeSession) {
        int n = 0;
        int n2 = ((Collection)containingDeclarations).size();
        while (n < n2) {
            void index2;
            FirDeclaration declaration2 = containingDeclarations.get((int)index2);
            ClassId declarationClassId = this.getClassId(declaration2);
            ClassId classId = declarationClassId;
            if (Intrinsics.areEqual((Object)$this$findOuterContainerInfo.getRelativeClassName(), (Object)(classId != null ? classId.getRelativeClassName() : null))) {
                FirDeclaration firDeclaration = declaration2;
                return firDeclaration instanceof FirRegularClass ? TuplesKt.to((Object)((FirRegularClass)declaration2).getSymbol(), (Object)this.resolveFor((FirMemberDeclaration)declaration2, containingDeclarations.subList(0, (int)index2), scopeSession)) : (firDeclaration instanceof FirAnonymousObject ? TuplesKt.to((Object)((FirAnonymousObject)declaration2).getSymbol(), (Object)this.remember(declaration2, FirEffectiveVisibilityImpl.Local.INSTANCE)) : null);
            }
            ++index2;
        }
        return null;
    }

    public FirEffectiveVisibilityResolverImpl(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        boolean bl = false;
        this.cache = new LinkedHashMap();
    }
}

