/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.psi.tree.IElementType;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.AccessorForPropertyBackingField;
import org.jetbrains.kotlin.codegen.AccessorKind;
import org.jetbrains.kotlin.codegen.And;
import org.jetbrains.kotlin.codegen.ArgumentGenerator;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.BranchedValue;
import org.jetbrains.kotlin.codegen.CallBasedArgumentGenerator;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.CallReceiver;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CoercionValue;
import org.jetbrains.kotlin.codegen.DefaultCallArgs;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FrameMapBase;
import org.jetbrains.kotlin.codegen.FunctionCallStackValue;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.JvmKotlinType;
import org.jetbrains.kotlin.codegen.OperationStackValue;
import org.jetbrains.kotlin.codegen.Or;
import org.jetbrains.kotlin.codegen.SyntheticClassDescriptorForLambda;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.load.java.DescriptorsJvmAbiUtil;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImportedFromObjectCallableDescriptor;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public abstract class StackValue {
    public static final Local LOCAL_0 = StackValue.local(0, AsmTypes.OBJECT_TYPE);
    private static final StackValue UNIT = StackValue.operation(AsmTypes.UNIT_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
        v.visitFieldInsn(178, AsmTypes.UNIT_TYPE.getInternalName(), "INSTANCE", AsmTypes.UNIT_TYPE.getDescriptor());
        return null;
    }));
    @NotNull
    public final Type type;
    @Nullable
    public final KotlinType kotlinType;
    private final boolean canHaveSideEffects;

    protected StackValue(@NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(0);
        }
        this(type2, null, true);
    }

    protected StackValue(@NotNull Type type2, boolean canHaveSideEffects) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(1);
        }
        this(type2, null, canHaveSideEffects);
    }

    protected StackValue(@NotNull Type type2, @Nullable KotlinType kotlinType) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(2);
        }
        this(type2, kotlinType, true);
    }

    protected StackValue(@NotNull Type type2, @Nullable KotlinType kotlinType, boolean canHaveSideEffects) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(3);
        }
        this.type = type2;
        this.kotlinType = kotlinType;
        this.canHaveSideEffects = canHaveSideEffects;
    }

    public void moveToTopOfStack(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v, int depth) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(4);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(5);
        }
        this.put(type2, kotlinType, v);
    }

    public void put(@NotNull InstructionAdapter v) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(6);
        }
        this.put(this.type, null, v, false);
    }

    public void put(@NotNull Type type2, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(7);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(8);
        }
        this.put(type2, null, v, false);
    }

    public void put(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(9);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(10);
        }
        this.put(type2, kotlinType, v, false);
    }

    public void put(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v, boolean skipReceiver) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(11);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(12);
        }
        if (!skipReceiver) {
            this.putReceiver(v, true);
        }
        this.putSelector(type2, kotlinType, v);
    }

    public abstract void putSelector(@NotNull Type var1, @Nullable KotlinType var2, @NotNull InstructionAdapter var3);

    public boolean isNonStaticAccess(boolean isRead) {
        return false;
    }

    public void putReceiver(@NotNull InstructionAdapter v, boolean isRead) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(13);
        }
    }

    public void dup(@NotNull InstructionAdapter v, boolean withReceiver) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(14);
        }
        if (!Type.VOID_TYPE.equals(this.type)) {
            AsmUtil.dup(v, this.type);
        }
    }

    public void store(@NotNull StackValue value2, @NotNull InstructionAdapter v) {
        if (value2 == null) {
            StackValue.$$$reportNull$$$0(15);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(16);
        }
        this.store(value2, v, false);
    }

    public boolean canHaveSideEffects() {
        return this.canHaveSideEffects;
    }

    public void store(@NotNull StackValue value2, @NotNull InstructionAdapter v, boolean skipReceiver) {
        if (value2 == null) {
            StackValue.$$$reportNull$$$0(17);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(18);
        }
        if (!skipReceiver) {
            this.putReceiver(v, false);
        }
        value2.put(value2.type, value2.kotlinType, v);
        this.storeSelector(value2.type, value2.kotlinType, v);
    }

    protected void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
        if (topOfStackType == null) {
            StackValue.$$$reportNull$$$0(19);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(20);
        }
        throw new UnsupportedOperationException("Cannot store to value " + this);
    }

    @NotNull
    public static Local local(int index2, @NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(21);
        }
        return new Local(index2, type2);
    }

    public static Local local(int index2, @NotNull Type type2, @Nullable KotlinType kotlinType) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(22);
        }
        return new Local(index2, type2, kotlinType);
    }

    @NotNull
    public static StackValue local(int index2, @NotNull Type type2, @NotNull VariableDescriptor descriptor2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(23);
        }
        if (descriptor2 == null) {
            StackValue.$$$reportNull$$$0(24);
        }
        return StackValue.local(index2, type2, descriptor2, null);
    }

    @NotNull
    public static StackValue local(int index2, @NotNull Type type2, @NotNull VariableDescriptor descriptor2, @Nullable KotlinType delegateKotlinType) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(25);
        }
        if (descriptor2 == null) {
            StackValue.$$$reportNull$$$0(26);
        }
        if (descriptor2.isLateInit()) {
            assert (delegateKotlinType == null) : "Delegated property can't be lateinit: " + descriptor2 + ", delegate type: " + delegateKotlinType;
            return new LateinitLocal(index2, type2, descriptor2.getType(), descriptor2.getName());
        }
        return new Local(index2, type2, delegateKotlinType != null ? delegateKotlinType : descriptor2.getType());
    }

    @NotNull
    public static Delegate localDelegate(@NotNull Type type2, @NotNull StackValue delegateValue, @NotNull StackValue metadataValue, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull ExpressionCodegen codegen2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(27);
        }
        if (delegateValue == null) {
            StackValue.$$$reportNull$$$0(28);
        }
        if (metadataValue == null) {
            StackValue.$$$reportNull$$$0(29);
        }
        if (variableDescriptor == null) {
            StackValue.$$$reportNull$$$0(30);
        }
        if (codegen2 == null) {
            StackValue.$$$reportNull$$$0(31);
        }
        return new Delegate(type2, delegateValue, metadataValue, variableDescriptor, codegen2);
    }

    @NotNull
    public static StackValue shared(int index2, @NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(32);
        }
        return new Shared(index2, type2);
    }

    @NotNull
    public static StackValue shared(int index2, @NotNull Type type2, @NotNull VariableDescriptor descriptor2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(33);
        }
        if (descriptor2 == null) {
            StackValue.$$$reportNull$$$0(34);
        }
        return StackValue.shared(index2, type2, descriptor2, null);
    }

    @NotNull
    public static StackValue shared(int index2, @NotNull Type type2, @NotNull VariableDescriptor descriptor2, @Nullable KotlinType delegateKotlinType) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(35);
        }
        if (descriptor2 == null) {
            StackValue.$$$reportNull$$$0(36);
        }
        return new Shared(index2, type2, delegateKotlinType != null ? delegateKotlinType : descriptor2.getType(), descriptor2.isLateInit(), descriptor2.getName());
    }

    @NotNull
    public static StackValue onStack(@NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(37);
        }
        return StackValue.onStack(type2, null);
    }

    @NotNull
    public static StackValue onStack(@NotNull Type type2, @Nullable KotlinType kotlinType) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(38);
        }
        return type2 == Type.VOID_TYPE ? StackValue.none() : new OnStack(type2, kotlinType);
    }

    @NotNull
    public static StackValue integerConstant(int value2, @NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(39);
        }
        if (type2 == Type.LONG_TYPE) {
            return StackValue.constant(value2, type2);
        }
        if (type2 == Type.BYTE_TYPE || type2 == Type.SHORT_TYPE || type2 == Type.INT_TYPE) {
            return StackValue.constant(value2, type2);
        }
        if (type2 == Type.CHAR_TYPE) {
            return StackValue.constant(Character.valueOf((char)value2), type2);
        }
        throw new AssertionError((Object)("Unexpected integer type: " + type2));
    }

    @NotNull
    public static StackValue constant(int value2) {
        return StackValue.constant(value2, Type.INT_TYPE);
    }

    @NotNull
    public static StackValue constant(@Nullable Object value2, @NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(40);
        }
        return StackValue.constant(value2, type2, null);
    }

    @NotNull
    public static StackValue constant(@Nullable Object value2, @NotNull Type type2, @Nullable KotlinType kotlinType) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(41);
        }
        if (type2 == Type.BOOLEAN_TYPE) {
            assert (value2 instanceof Boolean) : "Value for boolean constant should have boolean type: " + value2;
            BranchedValue branchedValue = BranchedValue.Companion.booleanConstant((Boolean)value2);
            if (branchedValue == null) {
                StackValue.$$$reportNull$$$0(42);
            }
            return branchedValue;
        }
        return new Constant(value2, type2, kotlinType);
    }

    public static StackValue createDefaultValue(@NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(43);
        }
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            return StackValue.constant(null, type2);
        }
        return StackValue.createDefaultPrimitiveValue(type2);
    }

    private static StackValue createDefaultPrimitiveValue(@NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(44);
        }
        assert (1 <= type2.getSort() && type2.getSort() <= 8) : "'createDefaultPrimitiveValue' method should be called only for primitive types, but " + type2;
        Constable value2 = 0;
        if (type2.getSort() == 1) {
            value2 = Boolean.FALSE;
        } else if (type2.getSort() == 6) {
            value2 = new Float(0.0);
        } else if (type2.getSort() == 8) {
            value2 = new Double(0.0);
        } else if (type2.getSort() == 7) {
            value2 = new Long(0L);
        }
        return StackValue.constant(value2, type2);
    }

    @NotNull
    public static StackValue cmp(@NotNull IElementType opToken, @NotNull Type type2, StackValue left, StackValue right) {
        if (opToken == null) {
            StackValue.$$$reportNull$$$0(45);
        }
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(46);
        }
        BranchedValue branchedValue = BranchedValue.Companion.cmp(opToken, type2, left, right);
        if (branchedValue == null) {
            StackValue.$$$reportNull$$$0(47);
        }
        return branchedValue;
    }

    @NotNull
    public static StackValue not(@NotNull StackValue stackValue) {
        if (stackValue == null) {
            StackValue.$$$reportNull$$$0(48);
        }
        StackValue stackValue2 = BranchedValue.Companion.createInvertValue(stackValue);
        if (stackValue2 == null) {
            StackValue.$$$reportNull$$$0(49);
        }
        return stackValue2;
    }

    public static StackValue or(@NotNull StackValue left, @NotNull StackValue right) {
        if (left == null) {
            StackValue.$$$reportNull$$$0(50);
        }
        if (right == null) {
            StackValue.$$$reportNull$$$0(51);
        }
        return new Or(left, right);
    }

    public static StackValue and(@NotNull StackValue left, @NotNull StackValue right) {
        if (left == null) {
            StackValue.$$$reportNull$$$0(52);
        }
        if (right == null) {
            StackValue.$$$reportNull$$$0(53);
        }
        return new And(left, right);
    }

    public static StackValue compareIntWithZero(@NotNull StackValue argument, int operation) {
        if (argument == null) {
            StackValue.$$$reportNull$$$0(54);
        }
        return new BranchedValue(argument, null, Type.INT_TYPE, operation);
    }

    public static StackValue compareWithNull(@NotNull StackValue argument, int operation) {
        if (argument == null) {
            StackValue.$$$reportNull$$$0(55);
        }
        return new BranchedValue(argument, null, AsmTypes.OBJECT_TYPE, operation);
    }

    @NotNull
    public static StackValue arrayElement(@NotNull Type type2, @Nullable KotlinType kotlinType, StackValue array, StackValue index2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(56);
        }
        return new ArrayElement(type2, kotlinType, array, index2);
    }

    @NotNull
    public static StackValue collectionElement(CollectionElementReceiver collectionElementReceiver, Type type2, KotlinType kotlinType, ResolvedCall<FunctionDescriptor> getter2, ResolvedCall<FunctionDescriptor> setter2, ExpressionCodegen codegen2) {
        return new CollectionElement(collectionElementReceiver, type2, kotlinType, getter2, setter2, codegen2);
    }

    public static UnderlyingValueOfInlineClass underlyingValueOfInlineClass(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull StackValue receiver) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(57);
        }
        if (receiver == null) {
            StackValue.$$$reportNull$$$0(58);
        }
        return new UnderlyingValueOfInlineClass(type2, kotlinType, receiver);
    }

    @NotNull
    public static Field field(@NotNull Type type2, @NotNull Type owner, @NotNull String name, boolean isStatic, @NotNull StackValue receiver) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(59);
        }
        if (owner == null) {
            StackValue.$$$reportNull$$$0(60);
        }
        if (name == null) {
            StackValue.$$$reportNull$$$0(61);
        }
        if (receiver == null) {
            StackValue.$$$reportNull$$$0(62);
        }
        return StackValue.field(type2, null, owner, name, isStatic, receiver);
    }

    @NotNull
    public static Field field(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull Type owner, @NotNull String name, boolean isStatic, @NotNull StackValue receiver) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(63);
        }
        if (owner == null) {
            StackValue.$$$reportNull$$$0(64);
        }
        if (name == null) {
            StackValue.$$$reportNull$$$0(65);
        }
        if (receiver == null) {
            StackValue.$$$reportNull$$$0(66);
        }
        return StackValue.field(type2, kotlinType, owner, name, isStatic, receiver, null);
    }

    @NotNull
    public static Field field(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull Type owner, @NotNull String name, boolean isStatic, @NotNull StackValue receiver, @Nullable DeclarationDescriptor descriptor2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(67);
        }
        if (owner == null) {
            StackValue.$$$reportNull$$$0(68);
        }
        if (name == null) {
            StackValue.$$$reportNull$$$0(69);
        }
        if (receiver == null) {
            StackValue.$$$reportNull$$$0(70);
        }
        return new Field(type2, kotlinType, owner, name, isStatic, receiver, descriptor2);
    }

    @NotNull
    public static Field field(@NotNull Field field, @NotNull StackValue newReceiver) {
        if (field == null) {
            StackValue.$$$reportNull$$$0(71);
        }
        if (newReceiver == null) {
            StackValue.$$$reportNull$$$0(72);
        }
        return StackValue.field(field.type, field.kotlinType, field.owner, field.name, field.isStaticPut, newReceiver, field.descriptor);
    }

    @NotNull
    public static Field field(@NotNull FieldInfo info, @NotNull StackValue receiver) {
        if (info == null) {
            StackValue.$$$reportNull$$$0(73);
        }
        if (receiver == null) {
            StackValue.$$$reportNull$$$0(74);
        }
        return StackValue.field(info.getFieldType(), info.getFieldKotlinType(), Type.getObjectType(info.getOwnerInternalName()), info.getFieldName(), info.isStatic(), receiver);
    }

    @NotNull
    public static StackValue changeReceiverForFieldAndSharedVar(@NotNull StackValueWithSimpleReceiver stackValue, @Nullable StackValue newReceiver) {
        if (stackValue == null) {
            StackValue.$$$reportNull$$$0(75);
        }
        if (newReceiver == null || stackValue.isStaticPut) {
            StackValueWithSimpleReceiver stackValueWithSimpleReceiver = stackValue;
            if (stackValueWithSimpleReceiver == null) {
                StackValue.$$$reportNull$$$0(76);
            }
            return stackValueWithSimpleReceiver;
        }
        StackValueWithSimpleReceiver stackValueWithSimpleReceiver = stackValue.changeReceiver(newReceiver);
        if (stackValueWithSimpleReceiver == null) {
            StackValue.$$$reportNull$$$0(77);
        }
        return stackValueWithSimpleReceiver;
    }

    @NotNull
    public static Property property(@NotNull PropertyDescriptor descriptor2, @Nullable Type backingFieldOwner, @NotNull Type type2, boolean isStaticBackingField, @Nullable String fieldName, @Nullable CallableMethod getter2, @Nullable CallableMethod setter2, @NotNull StackValue receiver, @NotNull ExpressionCodegen codegen2, @Nullable ResolvedCall resolvedCall2, boolean skipLateinitAssertion, @Nullable KotlinType delegateKotlinType) {
        if (descriptor2 == null) {
            StackValue.$$$reportNull$$$0(78);
        }
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(79);
        }
        if (receiver == null) {
            StackValue.$$$reportNull$$$0(80);
        }
        if (codegen2 == null) {
            StackValue.$$$reportNull$$$0(81);
        }
        return new Property(descriptor2, backingFieldOwner, getter2, setter2, isStaticBackingField, fieldName, type2, receiver, codegen2, resolvedCall2, skipLateinitAssertion, delegateKotlinType);
    }

    @NotNull
    public static StackValue expression(Type type2, KtExpression expression2, ExpressionCodegen generator2) {
        return new Expression(type2, expression2, generator2);
    }

    private static void box(Type type2, Type toType, InstructionAdapter v) {
        Type boxedType;
        if (type2 == Type.INT_TYPE) {
            if (toType.getInternalName().equals("java/lang/Byte")) {
                type2 = Type.BYTE_TYPE;
            } else if (toType.getInternalName().equals("java/lang/Short")) {
                type2 = Type.SHORT_TYPE;
            } else if (toType.getInternalName().equals("java/lang/Long")) {
                type2 = Type.LONG_TYPE;
            }
            v.cast(Type.INT_TYPE, type2);
        }
        if ((boxedType = AsmUtil.boxType(type2)) == type2) {
            return;
        }
        v.invokestatic(boxedType.getInternalName(), "valueOf", Type.getMethodDescriptor(boxedType, type2), false);
        StackValue.coerce(boxedType, toType, v);
    }

    private static void unbox(Type methodOwner, Type type2, InstructionAdapter v) {
        assert (AsmUtil.isPrimitive(type2)) : "Unboxing should be performed to primitive type, but " + type2.getClassName();
        v.invokevirtual(methodOwner.getInternalName(), type2.getClassName() + "Value", "()" + type2.getDescriptor(), false);
    }

    public static void boxInlineClass(@NotNull KotlinType kotlinType, @NotNull InstructionAdapter v) {
        if (kotlinType == null) {
            StackValue.$$$reportNull$$$0(82);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(83);
        }
        Type boxedType = KotlinTypeMapper.mapInlineClassTypeAsDeclaration(kotlinType);
        Type underlyingType = KotlinTypeMapper.mapUnderlyingTypeOfInlineClassType(kotlinType);
        if (TypeUtils.isNullableType(kotlinType) && !AsmUtil.isPrimitive(underlyingType)) {
            StackValue.boxOrUnboxWithNullCheck(v, vv -> StackValue.invokeBoxMethod(vv, boxedType, underlyingType));
        } else {
            StackValue.invokeBoxMethod(v, boxedType, underlyingType);
        }
    }

    private static void invokeBoxMethod(@NotNull InstructionAdapter v, @NotNull Type boxedType, @NotNull Type underlyingType) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(84);
        }
        if (boxedType == null) {
            StackValue.$$$reportNull$$$0(85);
        }
        if (underlyingType == null) {
            StackValue.$$$reportNull$$$0(86);
        }
        v.invokestatic(boxedType.getInternalName(), KotlinTypeMapper.BOX_JVM_METHOD_NAME, Type.getMethodDescriptor(boxedType, underlyingType), false);
    }

    public static void unboxInlineClass(@NotNull Type type2, @NotNull KotlinType targetInlineClassType, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(87);
        }
        if (targetInlineClassType == null) {
            StackValue.$$$reportNull$$$0(88);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(89);
        }
        Type owner = KotlinTypeMapper.mapInlineClassTypeAsDeclaration(targetInlineClassType);
        StackValue.coerce(type2, owner, v);
        Type resultType = KotlinTypeMapper.mapUnderlyingTypeOfInlineClassType(targetInlineClassType);
        if (TypeUtils.isNullableType(targetInlineClassType) && !AsmUtil.isPrimitive(resultType)) {
            StackValue.boxOrUnboxWithNullCheck(v, vv -> StackValue.invokeUnboxMethod(vv, owner, resultType));
        } else {
            StackValue.invokeUnboxMethod(v, owner, resultType);
        }
    }

    private static void invokeUnboxMethod(@NotNull InstructionAdapter v, @NotNull Type owner, @NotNull Type resultType) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(90);
        }
        if (owner == null) {
            StackValue.$$$reportNull$$$0(91);
        }
        if (resultType == null) {
            StackValue.$$$reportNull$$$0(92);
        }
        v.invokevirtual(owner.getInternalName(), KotlinTypeMapper.UNBOX_JVM_METHOD_NAME, "()" + resultType.getDescriptor(), false);
    }

    private static void boxOrUnboxWithNullCheck(@NotNull InstructionAdapter v, @NotNull Consumer<InstructionAdapter> body2) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(93);
        }
        if (body2 == null) {
            StackValue.$$$reportNull$$$0(94);
        }
        Label lNull = new Label();
        Label lDone = new Label();
        v.dup();
        v.ifnull(lNull);
        body2.accept(v);
        v.goTo(lDone);
        v.mark(lNull);
        v.pop();
        v.aconst(null);
        v.mark(lDone);
    }

    protected void coerceTo(@NotNull Type toType, @Nullable KotlinType toKotlinType, @NotNull InstructionAdapter v) {
        if (toType == null) {
            StackValue.$$$reportNull$$$0(95);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(96);
        }
        StackValue.coerce(this.type, this.kotlinType, toType, toKotlinType, v);
    }

    protected void coerceFrom(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v) {
        if (topOfStackType == null) {
            StackValue.$$$reportNull$$$0(97);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(98);
        }
        StackValue.coerce(topOfStackType, topOfStackKotlinType, this.type, this.kotlinType, v);
    }

    public static void coerce(@NotNull Type fromType, @Nullable KotlinType fromKotlinType, @NotNull Type toType, @Nullable KotlinType toKotlinType, @NotNull InstructionAdapter v) {
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(99);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(100);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(101);
        }
        if (StackValue.coerceInlineClasses(fromType, fromKotlinType, toType, toKotlinType, v)) {
            return;
        }
        StackValue.coerce(fromType, toType, v);
    }

    public static boolean requiresInlineClassBoxingOrUnboxing(@NotNull Type fromType, @Nullable KotlinType fromKotlinType, @NotNull Type toType, @Nullable KotlinType toKotlinType) {
        boolean isToTypeUnboxed;
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(102);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(103);
        }
        if (fromKotlinType == null || toKotlinType == null) {
            return false;
        }
        boolean isFromTypeInlineClass = InlineClassesUtilsKt.isInlineClassType(fromKotlinType);
        boolean isToTypeInlineClass = InlineClassesUtilsKt.isInlineClassType(toKotlinType);
        if (!isFromTypeInlineClass && !isToTypeInlineClass) {
            return false;
        }
        boolean isFromTypeUnboxed = isFromTypeInlineClass && StackValue.isUnboxedInlineClass(fromKotlinType, fromType);
        boolean bl = isToTypeUnboxed = isToTypeInlineClass && StackValue.isUnboxedInlineClass(toKotlinType, toType);
        if (isFromTypeInlineClass && isToTypeInlineClass) {
            return isFromTypeUnboxed != isToTypeUnboxed;
        }
        return isFromTypeInlineClass && isFromTypeUnboxed || isToTypeInlineClass && isToTypeUnboxed;
    }

    private static boolean coerceInlineClasses(@NotNull Type fromType, @Nullable KotlinType fromKotlinType, @NotNull Type toType, @Nullable KotlinType toKotlinType, @NotNull InstructionAdapter v) {
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(104);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(105);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(106);
        }
        if (fromKotlinType == null || toKotlinType == null) {
            return false;
        }
        boolean isFromTypeInlineClass = InlineClassesUtilsKt.isInlineClassType(fromKotlinType);
        boolean isToTypeInlineClass = InlineClassesUtilsKt.isInlineClassType(toKotlinType);
        if (!isFromTypeInlineClass && !isToTypeInlineClass) {
            return false;
        }
        if (fromKotlinType.equals(toKotlinType) && fromType.equals(toType)) {
            return true;
        }
        if (isFromTypeInlineClass && isToTypeInlineClass) {
            boolean isFromTypeUnboxed = StackValue.isUnboxedInlineClass(fromKotlinType, fromType);
            boolean isToTypeUnboxed = StackValue.isUnboxedInlineClass(toKotlinType, toType);
            if (isFromTypeUnboxed && !isToTypeUnboxed) {
                StackValue.boxInlineClass(fromKotlinType, v);
                return true;
            }
            if (!isFromTypeUnboxed && isToTypeUnboxed) {
                StackValue.unboxInlineClass(fromType, toKotlinType, v);
                return true;
            }
        } else if (isFromTypeInlineClass) {
            if (StackValue.isUnboxedInlineClass(fromKotlinType, fromType)) {
                StackValue.boxInlineClass(fromKotlinType, v);
                return true;
            }
        } else if (StackValue.isUnboxedInlineClass(toKotlinType, toType)) {
            StackValue.unboxInlineClass(fromType, toKotlinType, v);
            return true;
        }
        return false;
    }

    public static boolean isUnboxedInlineClass(@NotNull KotlinType kotlinType, @NotNull Type actualType) {
        if (kotlinType == null) {
            StackValue.$$$reportNull$$$0(107);
        }
        if (actualType == null) {
            StackValue.$$$reportNull$$$0(108);
        }
        return KotlinTypeMapper.mapUnderlyingTypeOfInlineClassType(kotlinType).equals(actualType);
    }

    public static void coerce(@NotNull Type fromType, @NotNull Type toType, @NotNull InstructionAdapter v) {
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(109);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(110);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(111);
        }
        if (toType.equals(fromType)) {
            return;
        }
        if (toType.getSort() == 0) {
            AsmUtil.pop(v, fromType);
        } else if (fromType.getSort() == 0) {
            if (toType.equals(AsmTypes.UNIT_TYPE) || toType.equals(AsmTypes.OBJECT_TYPE)) {
                StackValue.putUnitInstance(v);
            } else {
                AsmUtil.pushDefaultValueOnStack(toType, v);
            }
        } else if (toType.equals(AsmTypes.UNIT_TYPE)) {
            if (fromType.equals(AsmTypes.getType(Object.class))) {
                v.checkcast(AsmTypes.UNIT_TYPE);
            } else if (!fromType.equals(AsmTypes.getType(Void.class))) {
                AsmUtil.pop(v, fromType);
                StackValue.putUnitInstance(v);
            }
        } else if (toType.getSort() == 9) {
            if (fromType.getSort() != 9) {
                v.checkcast(toType);
            } else if (toType.getDimensions() != fromType.getDimensions()) {
                v.checkcast(toType);
            } else if (!toType.getElementType().equals(AsmTypes.OBJECT_TYPE)) {
                v.checkcast(toType);
            }
        } else if (toType.getSort() == 10) {
            if (fromType.getSort() == 10 || fromType.getSort() == 9) {
                if (!toType.equals(AsmTypes.OBJECT_TYPE)) {
                    v.checkcast(toType);
                }
            } else {
                StackValue.box(fromType, toType, v);
            }
        } else if (fromType.getSort() == 10 || fromType.getSort() == 9) {
            Type unboxedType = AsmUtil.unboxPrimitiveTypeOrNull(fromType);
            if (unboxedType != null) {
                StackValue.unbox(fromType, unboxedType, v);
                StackValue.coerce(unboxedType, toType, v);
            } else if (toType.getSort() == 1) {
                StackValue.coerce(fromType, AsmTypes.BOOLEAN_WRAPPER_TYPE, v);
                StackValue.unbox(AsmTypes.BOOLEAN_WRAPPER_TYPE, Type.BOOLEAN_TYPE, v);
            } else if (toType.getSort() == 2) {
                if (fromType.equals(AsmTypes.NUMBER_TYPE)) {
                    StackValue.unbox(AsmTypes.NUMBER_TYPE, Type.INT_TYPE, v);
                    v.visitInsn(146);
                } else {
                    StackValue.coerce(fromType, AsmTypes.CHARACTER_WRAPPER_TYPE, v);
                    StackValue.unbox(AsmTypes.CHARACTER_WRAPPER_TYPE, Type.CHAR_TYPE, v);
                }
            } else {
                StackValue.coerce(fromType, AsmTypes.NUMBER_TYPE, v);
                StackValue.unbox(AsmTypes.NUMBER_TYPE, toType, v);
            }
        } else {
            v.cast(fromType, toType);
        }
    }

    public static void putUnitInstance(@NotNull InstructionAdapter v) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(112);
        }
        StackValue.unit().put(AsmTypes.UNIT_TYPE, null, v);
    }

    public static StackValue unit() {
        return UNIT;
    }

    public static StackValue none() {
        return None.INSTANCE;
    }

    public static Field receiverWithRefWrapper(@NotNull Type localType, @NotNull Type classType, @NotNull String fieldName, @NotNull StackValue receiver, @Nullable DeclarationDescriptor descriptor2) {
        if (localType == null) {
            StackValue.$$$reportNull$$$0(113);
        }
        if (classType == null) {
            StackValue.$$$reportNull$$$0(114);
        }
        if (fieldName == null) {
            StackValue.$$$reportNull$$$0(115);
        }
        if (receiver == null) {
            StackValue.$$$reportNull$$$0(116);
        }
        return StackValue.field(StackValue.sharedTypeForType(localType), null, classType, fieldName, false, receiver, descriptor2);
    }

    public static FieldForSharedVar fieldForSharedVar(@NotNull Type localType, @NotNull Type classType, @NotNull String fieldName, @NotNull Field refWrapper, @NotNull VariableDescriptor variableDescriptor) {
        if (localType == null) {
            StackValue.$$$reportNull$$$0(117);
        }
        if (classType == null) {
            StackValue.$$$reportNull$$$0(118);
        }
        if (fieldName == null) {
            StackValue.$$$reportNull$$$0(119);
        }
        if (refWrapper == null) {
            StackValue.$$$reportNull$$$0(120);
        }
        if (variableDescriptor == null) {
            StackValue.$$$reportNull$$$0(121);
        }
        return new FieldForSharedVar(localType, variableDescriptor.getType(), classType, fieldName, refWrapper, variableDescriptor.isLateInit(), variableDescriptor.getName());
    }

    @NotNull
    public static FieldForSharedVar fieldForSharedVar(@NotNull FieldForSharedVar field, @NotNull StackValue newReceiver) {
        if (field == null) {
            StackValue.$$$reportNull$$$0(122);
        }
        if (newReceiver == null) {
            StackValue.$$$reportNull$$$0(123);
        }
        Field oldReceiver = (Field)field.receiver;
        Field newSharedVarReceiver = StackValue.field(oldReceiver, newReceiver);
        return new FieldForSharedVar(field.type, field.kotlinType, field.owner, field.name, newSharedVarReceiver, field.isLateinit, field.variableName);
    }

    public static StackValue coercion(@NotNull StackValue value2, @NotNull Type castType2, @Nullable KotlinType castKotlinType) {
        if (value2 == null) {
            StackValue.$$$reportNull$$$0(124);
        }
        if (castType2 == null) {
            StackValue.$$$reportNull$$$0(125);
        }
        return StackValue.coercionValueForArgumentOfInlineClassConstructor(value2, castType2, castKotlinType, null);
    }

    public static StackValue coercionValueForArgumentOfInlineClassConstructor(@NotNull StackValue value2, @NotNull Type castType2, @Nullable KotlinType castKotlinType, @Nullable KotlinType underlyingKotlinType) {
        boolean kotlinTypesAreEqual;
        if (value2 == null) {
            StackValue.$$$reportNull$$$0(126);
        }
        if (castType2 == null) {
            StackValue.$$$reportNull$$$0(127);
        }
        boolean bl = kotlinTypesAreEqual = value2.kotlinType == null && castKotlinType == null || value2.kotlinType != null && castKotlinType != null && castKotlinType.equals(value2.kotlinType);
        if (value2.type.equals(castType2) && kotlinTypesAreEqual) {
            return value2;
        }
        return new CoercionValue(value2, castType2, castKotlinType, underlyingKotlinType);
    }

    @NotNull
    public static StackValue thisOrOuter(@NotNull ExpressionCodegen codegen2, @NotNull ClassDescriptor descriptor2, boolean isSuper, boolean castReceiver) {
        if (codegen2 == null) {
            StackValue.$$$reportNull$$$0(128);
        }
        if (descriptor2 == null) {
            StackValue.$$$reportNull$$$0(129);
        }
        boolean coerceType = descriptor2.getKind() == ClassKind.INTERFACE || InlineClassesUtilsKt.isInlineClass(descriptor2) || castReceiver && !isSuper;
        return new ThisOuter(codegen2, descriptor2, isSuper, coerceType);
    }

    public static StackValue postIncrement(int index2, int increment) {
        return new PostIncrement(index2, increment);
    }

    public static StackValue preIncrementForLocalVar(int index2, int increment, @Nullable KotlinType kotlinType) {
        return new PreIncrementForLocalVar(index2, increment, kotlinType);
    }

    public static StackValue preIncrement(@NotNull Type type2, @NotNull StackValue stackValue, int delta, ResolvedCall resolvedCall2, @NotNull ExpressionCodegen codegen2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(130);
        }
        if (stackValue == null) {
            StackValue.$$$reportNull$$$0(131);
        }
        if (codegen2 == null) {
            StackValue.$$$reportNull$$$0(132);
        }
        KotlinType kotlinType = stackValue.kotlinType;
        if (stackValue instanceof Local && Type.INT_TYPE == stackValue.type && kotlinType != null && KotlinBuiltIns.isPrimitiveType(kotlinType)) {
            return StackValue.preIncrementForLocalVar(((Local)stackValue).index, delta, kotlinType);
        }
        return new PrefixIncrement(type2, stackValue, resolvedCall2, codegen2);
    }

    public static StackValue receiver(ResolvedCall<?> resolvedCall2, StackValue receiver, ExpressionCodegen codegen2, @Nullable Callable callableMethod) {
        ReceiverValue callDispatchReceiver = resolvedCall2.getDispatchReceiver();
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        if (descriptor2 instanceof SyntheticFieldDescriptor) {
            callDispatchReceiver = ((SyntheticFieldDescriptor)descriptor2).getDispatchReceiverForBackend();
        }
        ReceiverValue callExtensionReceiver = resolvedCall2.getExtensionReceiver();
        boolean isImportedObjectMember = false;
        if (descriptor2 instanceof ImportedFromObjectCallableDescriptor) {
            isImportedObjectMember = true;
            descriptor2 = ((ImportedFromObjectCallableDescriptor)descriptor2).getCallableFromObject();
        }
        if (callDispatchReceiver != null || callExtensionReceiver != null || StackValue.isLocalFunCall(callableMethod) || isImportedObjectMember) {
            ReceiverParameterDescriptor dispatchReceiverParameter2 = descriptor2.getDispatchReceiverParameter();
            ReceiverParameterDescriptor extensionReceiverParameter2 = descriptor2.getExtensionReceiverParameter();
            if (descriptor2 instanceof SyntheticFieldDescriptor) {
                dispatchReceiverParameter2 = ((SyntheticFieldDescriptor)descriptor2).getDispatchReceiverParameterForBackend();
            }
            boolean hasExtensionReceiver = callExtensionReceiver != null;
            StackValue dispatchReceiver = StackValue.platformStaticCallIfPresent(StackValue.genReceiver(hasExtensionReceiver ? StackValue.none() : receiver, codegen2, (CallableDescriptor)descriptor2, callableMethod, callDispatchReceiver, false), (CallableDescriptor)descriptor2);
            StackValue extensionReceiver = StackValue.genReceiver(receiver, codegen2, (CallableDescriptor)descriptor2, callableMethod, callExtensionReceiver, true);
            return CallReceiver.generateCallReceiver(resolvedCall2, codegen2, callableMethod, dispatchReceiverParameter2, dispatchReceiver, extensionReceiverParameter2, extensionReceiver);
        }
        return receiver;
    }

    private static StackValue genReceiver(@NotNull StackValue receiver, @NotNull ExpressionCodegen codegen2, @NotNull CallableDescriptor descriptor2, @Nullable Callable callableMethod, @Nullable ReceiverValue receiverValue, boolean isExtension) {
        if (receiver == null) {
            StackValue.$$$reportNull$$$0(133);
        }
        if (codegen2 == null) {
            StackValue.$$$reportNull$$$0(134);
        }
        if (descriptor2 == null) {
            StackValue.$$$reportNull$$$0(135);
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (receiver == StackValue.none()) {
            if (receiverValue != null) {
                return codegen2.generateReceiverValue(receiverValue, false);
            }
            if (StackValue.isLocalFunCall(callableMethod) && !isExtension) {
                SimpleFunctionDescriptor initial;
                if (descriptor2 instanceof SimpleFunctionDescriptor && (initial = CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction((SimpleFunctionDescriptor)descriptor2)) != null && initial.isSuspend()) {
                    return StackValue.putLocalSuspendFunctionOnStack(codegen2, initial.getOriginal());
                }
                StackValue value2 = codegen2.findLocalOrCapturedValue(descriptor2.getOriginal());
                assert (value2 != null) : "Local fun should be found in locals or in captured params: " + descriptor2;
                return value2;
            }
            if (!isExtension && DescriptorUtils.isObject(containingDeclaration)) {
                return StackValue.singleton((ClassDescriptor)containingDeclaration, codegen2.typeMapper);
            }
        } else if (receiverValue != null) {
            return receiver;
        }
        return StackValue.none();
    }

    private static StackValue putLocalSuspendFunctionOnStack(@NotNull ExpressionCodegen codegen2, SimpleFunctionDescriptor callee) {
        int index2;
        if (codegen2 == null) {
            StackValue.$$$reportNull$$$0(136);
        }
        if ((index2 = codegen2.lookupLocalIndex(callee)) >= 0) {
            return StackValue.local(index2, AsmTypes.OBJECT_TYPE);
        }
        BindingContext bindingContext = codegen2.getBindingContext();
        Type calleeType = CodegenBinding.asmTypeForAnonymousClass(bindingContext, callee);
        if (codegen2.context.hasThisDescriptor()) {
            ClassDescriptor thisDescriptor = codegen2.context.getThisDescriptor();
            ClassDescriptor classDescriptor2 = bindingContext.get(CodegenBinding.CLASS_FOR_CALLABLE, callee);
            if (thisDescriptor instanceof SyntheticClassDescriptorForLambda && ((SyntheticClassDescriptorForLambda)thisDescriptor).isCallableReference()) {
                Boolean isRecursive = bindingContext.get(CodegenBinding.RECURSIVE_SUSPEND_CALLABLE_REFERENCE, thisDescriptor);
                if (isRecursive != null && isRecursive.booleanValue()) {
                    assert (classDescriptor2 != null) : "No CLASS_FOR_CALLABLE" + callee;
                    return StackValue.thisOrOuter(codegen2, classDescriptor2, false, false);
                }
                return codegen2.findCapturedValue(callee);
            }
            if (classDescriptor2 == thisDescriptor) {
                codegen2.v.visitVarInsn(25, 0);
                return StackValue.onStack(calleeType);
            }
        }
        return codegen2.findCapturedValue(callee);
    }

    private static StackValue platformStaticCallIfPresent(@NotNull StackValue resultReceiver, @NotNull CallableDescriptor descriptor2) {
        if (resultReceiver == null) {
            StackValue.$$$reportNull$$$0(137);
        }
        if (descriptor2 == null) {
            StackValue.$$$reportNull$$$0(138);
        }
        if (CodegenUtilKt.isJvmStaticInObjectOrClassOrInterface(descriptor2)) {
            if (resultReceiver.canHaveSideEffects()) {
                return StackValue.coercion(resultReceiver, Type.VOID_TYPE, null);
            }
            return StackValue.none();
        }
        return resultReceiver;
    }

    @Contract(value="null -> false")
    static boolean isLocalFunCall(@Nullable Callable callableMethod) {
        return callableMethod != null && callableMethod.getGenerateCalleeType() != null;
    }

    public static StackValue receiverWithoutReceiverArgument(StackValue receiverWithParameter) {
        if (receiverWithParameter instanceof CallReceiver) {
            return ((CallReceiver)receiverWithParameter).withoutReceiverArgument();
        }
        return receiverWithParameter;
    }

    @NotNull
    public static Field enumEntry(@NotNull ClassDescriptor descriptor2, @NotNull KotlinTypeMapper typeMapper2) {
        if (descriptor2 == null) {
            StackValue.$$$reportNull$$$0(139);
        }
        if (typeMapper2 == null) {
            StackValue.$$$reportNull$$$0(140);
        }
        DeclarationDescriptor enumClass2 = descriptor2.getContainingDeclaration();
        assert (DescriptorUtils.isEnumClass(enumClass2)) : "Enum entry should be declared in enum class: " + descriptor2;
        SimpleType enumType = ((ClassDescriptor)enumClass2).getDefaultType();
        Type type2 = typeMapper2.mapType(enumType);
        return StackValue.field(type2, enumType, type2, descriptor2.getName().asString(), true, StackValue.none(), descriptor2);
    }

    @NotNull
    public static Field singleton(@NotNull ClassDescriptor classDescriptor2, @NotNull KotlinTypeMapper typeMapper2) {
        if (classDescriptor2 == null) {
            StackValue.$$$reportNull$$$0(141);
        }
        if (typeMapper2 == null) {
            StackValue.$$$reportNull$$$0(142);
        }
        return StackValue.field(FieldInfo.createForSingleton(classDescriptor2, typeMapper2), StackValue.none());
    }

    public static Field createSingletonViaInstance(@NotNull ClassDescriptor classDescriptor2, @NotNull KotlinTypeMapper typeMapper2, @NotNull String name) {
        if (classDescriptor2 == null) {
            StackValue.$$$reportNull$$$0(143);
        }
        if (typeMapper2 == null) {
            StackValue.$$$reportNull$$$0(144);
        }
        if (name == null) {
            StackValue.$$$reportNull$$$0(145);
        }
        return StackValue.field(FieldInfo.createSingletonViaInstance(classDescriptor2, typeMapper2, name), StackValue.none());
    }

    public static StackValue operation(Type type2, Function1<InstructionAdapter, Unit> lambda2) {
        return StackValue.operation(type2, null, lambda2);
    }

    public static StackValue operation(Type type2, KotlinType kotlinType, Function1<InstructionAdapter, Unit> lambda2) {
        return new OperationStackValue(type2, kotlinType, lambda2);
    }

    public static StackValue functionCall(Type type2, KotlinType kotlinType, Function1<InstructionAdapter, Unit> lambda2) {
        return new FunctionCallStackValue(type2, kotlinType, lambda2);
    }

    public static boolean couldSkipReceiverOnStaticCall(StackValue value2) {
        return value2 instanceof Local || value2 instanceof Constant;
    }

    private static void genNonNullAssertForLateinit(@NotNull InstructionAdapter v, @NotNull String name) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(146);
        }
        if (name == null) {
            StackValue.$$$reportNull$$$0(147);
        }
        v.dup();
        Label ok = new Label();
        v.ifnonnull(ok);
        v.visitLdcInsn(name);
        v.invokestatic("kotlin/jvm/internal/Intrinsics", "throwUninitializedPropertyAccessException", "(Ljava/lang/String;)V", false);
        v.mark(ok);
    }

    @NotNull
    public static Type sharedTypeForType(@NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(148);
        }
        switch (type2.getSort()) {
            case 9: 
            case 10: {
                Type type3 = AsmTypes.OBJECT_REF_TYPE;
                if (type3 == null) {
                    StackValue.$$$reportNull$$$0(149);
                }
                return type3;
            }
        }
        PrimitiveType primitiveType = AsmUtil.asmPrimitiveTypeToLangPrimitiveType(type2);
        if (primitiveType == null) {
            throw new UnsupportedOperationException();
        }
        Type type4 = AsmTypes.sharedTypeForPrimitive(primitiveType);
        if (type4 == null) {
            StackValue.$$$reportNull$$$0(150);
        }
        return type4;
    }

    public static Type refType(Type type2) {
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            return AsmTypes.OBJECT_TYPE;
        }
        return type2;
    }

    public static StackValue complexWriteReadReceiver(StackValue stackValue) {
        return StackValue.complexReceiver(stackValue, false, true);
    }

    private static StackValue complexReceiver(StackValue stackValue, boolean ... isReadOperations) {
        if (stackValue instanceof Delegate) {
            StackValue.throwUnsupportedComplexOperation(((Delegate)stackValue).variableDescriptor);
        }
        if (stackValue instanceof StackValueWithSimpleReceiver) {
            return new DelegatedForComplexReceiver(stackValue.type, (StackValueWithSimpleReceiver)stackValue, new ComplexReceiver((StackValueWithSimpleReceiver)stackValue, isReadOperations));
        }
        return stackValue;
    }

    private static void throwUnsupportedComplexOperation(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            StackValue.$$$reportNull$$$0(151);
        }
        throw new RuntimeException("Augmented assignment and increment are not supported for local delegated properties and inline properties: " + descriptor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 42: 
            case 47: 
            case 49: 
            case 76: 
            case 77: 
            case 149: 
            case 150: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 42: 
            case 47: 
            case 49: 
            case 76: 
            case 77: 
            case 149: 
            case 150: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 83: 
            case 84: 
            case 89: 
            case 90: 
            case 93: 
            case 96: 
            case 98: 
            case 101: 
            case 106: 
            case 111: 
            case 112: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 15: 
            case 17: 
            case 124: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 19: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topOfStackType";
                break;
            }
            case 24: 
            case 26: 
            case 34: 
            case 36: 
            case 78: 
            case 129: 
            case 135: 
            case 138: 
            case 139: 
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateValue";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadataValue";
                break;
            }
            case 30: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDescriptor";
                break;
            }
            case 31: 
            case 81: 
            case 128: 
            case 132: 
            case 134: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegen";
                break;
            }
            case 42: 
            case 47: 
            case 49: 
            case 76: 
            case 77: 
            case 149: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/StackValue";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opToken";
                break;
            }
            case 48: 
            case 75: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackValue";
                break;
            }
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 58: 
            case 62: 
            case 66: 
            case 70: 
            case 74: 
            case 80: 
            case 116: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 60: 
            case 64: 
            case 68: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 61: 
            case 65: 
            case 69: 
            case 145: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 71: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 72: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newReceiver";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 82: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinType";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxedType";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingType";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetInlineClassType";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 95: 
            case 100: 
            case 103: 
            case 105: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 99: 
            case 102: 
            case 104: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromType";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
            case 113: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localType";
                break;
            }
            case 114: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 115: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refWrapper";
                break;
            }
            case 125: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "castType";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultReceiver";
                break;
            }
            case 140: 
            case 142: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 141: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "constant";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "cmp";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "not";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "changeReceiverForFieldAndSharedVar";
                break;
            }
            case 149: 
            case 150: {
                objectArray = objectArray2;
                objectArray2[1] = "sharedTypeForType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "moveToTopOfStack";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "putReceiver";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "dup";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "store";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "storeSelector";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "local";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "localDelegate";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "shared";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "onStack";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "integerConstant";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "constant";
                break;
            }
            case 42: 
            case 47: 
            case 49: 
            case 76: 
            case 77: 
            case 149: 
            case 150: {
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultValue";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultPrimitiveValue";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "cmp";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "not";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "compareIntWithZero";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "compareWithNull";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "arrayElement";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "underlyingValueOfInlineClass";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "field";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "changeReceiverForFieldAndSharedVar";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "property";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "boxInlineClass";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "invokeBoxMethod";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "unboxInlineClass";
                break;
            }
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "invokeUnboxMethod";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "boxOrUnboxWithNullCheck";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "coerceTo";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "coerceFrom";
                break;
            }
            case 99: 
            case 100: 
            case 101: 
            case 109: 
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "coerce";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "requiresInlineClassBoxingOrUnboxing";
                break;
            }
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "coerceInlineClasses";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "isUnboxedInlineClass";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "putUnitInstance";
                break;
            }
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "receiverWithRefWrapper";
                break;
            }
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "fieldForSharedVar";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "coercion";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "coercionValueForArgumentOfInlineClassConstructor";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "thisOrOuter";
                break;
            }
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "preIncrement";
                break;
            }
            case 133: 
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "genReceiver";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "putLocalSuspendFunctionOnStack";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "platformStaticCallIfPresent";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "enumEntry";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "singleton";
                break;
            }
            case 143: 
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "createSingletonViaInstance";
                break;
            }
            case 146: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "genNonNullAssertForLateinit";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "sharedTypeForType";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "throwUnsupportedComplexOperation";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 42: 
            case 47: 
            case 49: 
            case 76: 
            case 77: 
            case 149: 
            case 150: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class SafeFallback
    extends StackValueWithSimpleReceiver {
        @Nullable
        private final Label ifNull;

        public SafeFallback(@NotNull Type type2, @Nullable KotlinType kotlinType, @Nullable Label ifNull2, StackValue receiver) {
            if (type2 == null) {
                SafeFallback.$$$reportNull$$$0(0);
            }
            super(type2, kotlinType, false, false, receiver, true);
            this.ifNull = ifNull2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                SafeFallback.$$$reportNull$$$0(1);
            }
            if (v == null) {
                SafeFallback.$$$reportNull$$$0(2);
            }
            Label end = new Label();
            v.goTo(end);
            v.mark(this.ifNull);
            v.pop();
            if (!this.type.equals(Type.VOID_TYPE)) {
                v.aconst(null);
            }
            v.mark(end);
            this.coerceTo(type2, kotlinType, v);
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v, boolean skipReceiver) {
            if (rightSide == null) {
                SafeFallback.$$$reportNull$$$0(3);
            }
            if (v == null) {
                SafeFallback.$$$reportNull$$$0(4);
            }
            this.receiver.store(rightSide, v, skipReceiver);
            Label end = new Label();
            v.goTo(end);
            v.mark(this.ifNull);
            v.pop();
            v.mark(end);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightSide";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$SafeFallback";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "store";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class SafeCall
    extends StackValue {
        @NotNull
        private final Type type;
        private final StackValue receiver;
        @Nullable
        private final Label ifNull;

        public SafeCall(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull StackValue value2, @Nullable Label ifNull2) {
            if (type2 == null) {
                SafeCall.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                SafeCall.$$$reportNull$$$0(1);
            }
            super(type2, kotlinType);
            this.type = type2;
            this.receiver = value2;
            this.ifNull = ifNull2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                SafeCall.$$$reportNull$$$0(2);
            }
            if (v == null) {
                SafeCall.$$$reportNull$$$0(3);
            }
            this.receiver.put(this.type, this.kotlinType, v);
            if (this.ifNull != null) {
                v.dup();
                v.ifnull(this.ifNull);
            }
            this.coerceTo(type2, kotlinType, v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$SafeCall";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DelegatedForComplexReceiver
    extends StackValueWithSimpleReceiver {
        public final StackValueWithSimpleReceiver originalValue;

        public DelegatedForComplexReceiver(@NotNull Type type2, @NotNull StackValueWithSimpleReceiver originalValue, @NotNull ComplexReceiver receiver) {
            if (type2 == null) {
                DelegatedForComplexReceiver.$$$reportNull$$$0(0);
            }
            if (originalValue == null) {
                DelegatedForComplexReceiver.$$$reportNull$$$0(1);
            }
            if (receiver == null) {
                DelegatedForComplexReceiver.$$$reportNull$$$0(2);
            }
            super(type2, null, DelegatedForComplexReceiver.bothReceiverStatic(originalValue), DelegatedForComplexReceiver.bothReceiverStatic(originalValue), receiver, originalValue.canHaveSideEffects());
            this.originalValue = originalValue;
        }

        private static boolean bothReceiverStatic(StackValueWithSimpleReceiver originalValue) {
            return !originalValue.isNonStaticAccess(true) && !originalValue.isNonStaticAccess(false);
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                DelegatedForComplexReceiver.$$$reportNull$$$0(3);
            }
            if (v == null) {
                DelegatedForComplexReceiver.$$$reportNull$$$0(4);
            }
            this.originalValue.putSelector(type2, kotlinType, v);
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v, boolean skipReceiver) {
            if (rightSide == null) {
                DelegatedForComplexReceiver.$$$reportNull$$$0(5);
            }
            if (v == null) {
                DelegatedForComplexReceiver.$$$reportNull$$$0(6);
            }
            if (!skipReceiver) {
                this.putReceiver(v, false);
            }
            this.originalValue.store(rightSide, v, true);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                DelegatedForComplexReceiver.$$$reportNull$$$0(7);
            }
            if (v == null) {
                DelegatedForComplexReceiver.$$$reportNull$$$0(8);
            }
            this.originalValue.storeSelector(topOfStackType, kotlinType, v);
        }

        @Override
        public void dup(@NotNull InstructionAdapter v, boolean withWriteReceiver) {
            if (v == null) {
                DelegatedForComplexReceiver.$$$reportNull$$$0(9);
            }
            this.originalValue.dup(v, withWriteReceiver);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightSide";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$DelegatedForComplexReceiver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "store";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dup";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Receiver
    extends StackValue {
        private final StackValue[] instructions;

        protected Receiver(@NotNull Type type2, StackValue ... receiverInstructions) {
            if (type2 == null) {
                Receiver.$$$reportNull$$$0(0);
            }
            super(type2);
            this.instructions = receiverInstructions;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Receiver.$$$reportNull$$$0(1);
            }
            if (v == null) {
                Receiver.$$$reportNull$$$0(2);
            }
            for (StackValue instruction : this.instructions) {
                instruction.put(instruction.type, instruction.kotlinType, v);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$Receiver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ComplexReceiver
    extends StackValue {
        private final StackValueWithSimpleReceiver originalValueWithReceiver;
        private final boolean[] isReadOperations;

        public ComplexReceiver(StackValueWithSimpleReceiver value2, boolean[] isReadOperations) {
            super(value2.type, value2.receiver.canHaveSideEffects());
            this.originalValueWithReceiver = value2;
            this.isReadOperations = isReadOperations;
            if (value2 instanceof CollectionElement && value2.receiver instanceof CollectionElementReceiver) {
                ((CollectionElementReceiver)value2.receiver).isComplexOperationWithDup = true;
            }
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                ComplexReceiver.$$$reportNull$$$0(0);
            }
            if (v == null) {
                ComplexReceiver.$$$reportNull$$$0(1);
            }
            boolean wasPut = false;
            StackValue receiver = this.originalValueWithReceiver.receiver;
            for (boolean operation : this.isReadOperations) {
                if (!this.originalValueWithReceiver.isNonStaticAccess(operation)) continue;
                if (!wasPut) {
                    receiver.put(receiver.type, receiver.kotlinType, v);
                    wasPut = true;
                    continue;
                }
                receiver.dup(v, false);
            }
            if (!wasPut && receiver.canHaveSideEffects()) {
                receiver.put(Type.VOID_TYPE, null, v);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$ComplexReceiver";
            objectArray[2] = "putSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class StackValueWithSimpleReceiver
    extends StackValue {
        public final boolean isStaticPut;
        public final boolean isStaticStore;
        @NotNull
        public final StackValue receiver;

        public StackValueWithSimpleReceiver(@NotNull Type type2, @Nullable KotlinType kotlinType, boolean isStaticPut, boolean isStaticStore, @NotNull StackValue receiver, boolean canHaveSideEffects) {
            if (type2 == null) {
                StackValueWithSimpleReceiver.$$$reportNull$$$0(0);
            }
            if (receiver == null) {
                StackValueWithSimpleReceiver.$$$reportNull$$$0(1);
            }
            super(type2, kotlinType, canHaveSideEffects);
            this.receiver = receiver;
            this.isStaticPut = isStaticPut;
            this.isStaticStore = isStaticStore;
        }

        @Override
        public void putReceiver(@NotNull InstructionAdapter v, boolean isRead) {
            boolean hasReceiver;
            if (v == null) {
                StackValueWithSimpleReceiver.$$$reportNull$$$0(2);
            }
            if ((hasReceiver = this.isNonStaticAccess(isRead)) || this.receiver.canHaveSideEffects()) {
                this.receiver.put(hasReceiver ? this.receiver.type : Type.VOID_TYPE, hasReceiver ? this.receiver.kotlinType : null, v);
            }
        }

        @Override
        public boolean isNonStaticAccess(boolean isRead) {
            return isRead ? !this.isStaticPut : !this.isStaticStore;
        }

        public int receiverSize() {
            return this.receiver.type.getSize();
        }

        @Override
        public void dup(@NotNull InstructionAdapter v, boolean withWriteReceiver) {
            if (v == null) {
                StackValueWithSimpleReceiver.$$$reportNull$$$0(3);
            }
            if (!withWriteReceiver) {
                super.dup(v, false);
            } else {
                int receiverSize = this.isNonStaticAccess(false) ? this.receiverSize() : 0;
                switch (receiverSize) {
                    case 0: {
                        AsmUtil.dup(v, this.type);
                        break;
                    }
                    case 1: {
                        if (this.type.getSize() == 2) {
                            v.dup2X1();
                            break;
                        }
                        v.dupX1();
                        break;
                    }
                    case 2: {
                        if (this.type.getSize() == 2) {
                            v.dup2X2();
                            break;
                        }
                        v.dupX2();
                        break;
                    }
                    case -1: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v, boolean skipReceiver) {
            if (rightSide == null) {
                StackValueWithSimpleReceiver.$$$reportNull$$$0(4);
            }
            if (v == null) {
                StackValueWithSimpleReceiver.$$$reportNull$$$0(5);
            }
            if (!skipReceiver) {
                this.putReceiver(v, false);
            }
            rightSide.put(rightSide.type, rightSide.kotlinType, v);
            this.storeSelector(rightSide.type, rightSide.kotlinType, v);
        }

        protected StackValueWithSimpleReceiver changeReceiver(@NotNull StackValue newReceiver) {
            if (newReceiver == null) {
                StackValueWithSimpleReceiver.$$$reportNull$$$0(6);
            }
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightSide";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newReceiver";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$StackValueWithSimpleReceiver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putReceiver";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dup";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "store";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "changeReceiver";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PrefixIncrement
    extends StackValue {
        private final ResolvedCall resolvedCall;
        private final ExpressionCodegen codegen;
        private StackValue value;

        public PrefixIncrement(@NotNull Type type2, @NotNull StackValue value2, ResolvedCall resolvedCall2, @NotNull ExpressionCodegen codegen2) {
            if (type2 == null) {
                PrefixIncrement.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                PrefixIncrement.$$$reportNull$$$0(1);
            }
            if (codegen2 == null) {
                PrefixIncrement.$$$reportNull$$$0(2);
            }
            super(type2, value2.kotlinType);
            this.value = value2;
            this.resolvedCall = resolvedCall2;
            this.codegen = codegen2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                PrefixIncrement.$$$reportNull$$$0(3);
            }
            if (v == null) {
                PrefixIncrement.$$$reportNull$$$0(4);
            }
            this.value = StackValue.complexReceiver(this.value, new boolean[]{true, false, true});
            this.value.put(this.type, this.kotlinType, v);
            this.value.store(this.codegen.invokeFunction(this.resolvedCall, StackValue.onStack(this.type, this.kotlinType)), v, true);
            this.value.put(this.type, this.kotlinType, v, true);
            this.coerceTo(type2, kotlinType, v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codegen";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$PrefixIncrement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PreIncrementForLocalVar
    extends StackValue {
        private final int index;
        private final int increment;

        public PreIncrementForLocalVar(int index2, int increment, @Nullable KotlinType kotlinType) {
            super(Type.INT_TYPE, kotlinType);
            this.index = index2;
            this.increment = increment;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                PreIncrementForLocalVar.$$$reportNull$$$0(0);
            }
            if (v == null) {
                PreIncrementForLocalVar.$$$reportNull$$$0(1);
            }
            v.iinc(this.index, this.increment);
            if (!type2.equals(Type.VOID_TYPE)) {
                v.load(this.index, Type.INT_TYPE);
                this.coerceTo(type2, kotlinType, v);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$PreIncrementForLocalVar";
            objectArray[2] = "putSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PostIncrement
    extends StackValue {
        private final int index;
        private final int increment;

        public PostIncrement(int index2, int increment) {
            super(Type.INT_TYPE);
            this.index = index2;
            this.increment = increment;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                PostIncrement.$$$reportNull$$$0(0);
            }
            if (v == null) {
                PostIncrement.$$$reportNull$$$0(1);
            }
            if (!type2.equals(Type.VOID_TYPE)) {
                v.load(this.index, Type.INT_TYPE);
                this.coerceTo(type2, kotlinType, v);
            }
            v.iinc(this.index, this.increment);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$PostIncrement";
            objectArray[2] = "putSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ThisOuter
    extends StackValue {
        private final ExpressionCodegen codegen;
        private final ClassDescriptor descriptor;
        private final boolean isSuper;
        private final boolean coerceType;

        public ThisOuter(ExpressionCodegen codegen2, ClassDescriptor descriptor2, boolean isSuper, boolean coerceType) {
            super(AsmTypes.OBJECT_TYPE, false);
            this.codegen = codegen2;
            this.descriptor = descriptor2;
            this.isSuper = isSuper;
            this.coerceType = coerceType;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                ThisOuter.$$$reportNull$$$0(0);
            }
            if (v == null) {
                ThisOuter.$$$reportNull$$$0(1);
            }
            StackValue stackValue = this.codegen.generateThisOrOuter(this.descriptor, this.isSuper);
            stackValue.put(this.coerceType ? type2 : stackValue.type, this.coerceType ? kotlinType : stackValue.kotlinType, v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$ThisOuter";
            objectArray[2] = "putSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FieldForSharedVar
    extends StackValueWithSimpleReceiver {
        final Type owner;
        final String name;
        final boolean isLateinit;
        final Name variableName;

        public FieldForSharedVar(Type type2, KotlinType kotlinType, Type owner, String name, Field receiver, boolean isLateinit, Name variableName) {
            super(type2, kotlinType, false, false, receiver, receiver.canHaveSideEffects());
            if (isLateinit && variableName == null) {
                throw new IllegalArgumentException("variableName should be non-null for captured lateinit variable " + name);
            }
            this.owner = owner;
            this.name = name;
            this.isLateinit = isLateinit;
            this.variableName = variableName;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                FieldForSharedVar.$$$reportNull$$$0(0);
            }
            if (v == null) {
                FieldForSharedVar.$$$reportNull$$$0(1);
            }
            Type sharedType = FieldForSharedVar.sharedTypeForType(this.type);
            Type refType = FieldForSharedVar.refType(this.type);
            v.visitFieldInsn(180, sharedType.getInternalName(), "element", refType.getDescriptor());
            if (this.isLateinit) {
                StackValue.genNonNullAssertForLateinit(v, this.variableName.asString());
            }
            this.coerceFrom(refType, null, v);
            this.coerceTo(type2, kotlinType, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                FieldForSharedVar.$$$reportNull$$$0(2);
            }
            if (v == null) {
                FieldForSharedVar.$$$reportNull$$$0(3);
            }
            this.coerceFrom(topOfStackType, topOfStackKotlinType, v);
            v.visitFieldInsn(181, FieldForSharedVar.sharedTypeForType(this.type).getInternalName(), "element", FieldForSharedVar.refType(this.type).getDescriptor());
        }

        @Override
        protected StackValueWithSimpleReceiver changeReceiver(@NotNull StackValue newReceiver) {
            if (newReceiver == null) {
                FieldForSharedVar.$$$reportNull$$$0(4);
            }
            return FieldForSharedVar.fieldForSharedVar(this, newReceiver);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newReceiver";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$FieldForSharedVar";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "changeReceiver";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Shared
    extends StackValueWithSimpleReceiver {
        private final int index;
        private final boolean isLateinit;
        private final Name name;

        public Shared(int index2, Type type2, KotlinType kotlinType, boolean isLateinit, Name name) {
            super(type2, kotlinType, false, false, Shared.local(index2, AsmTypes.OBJECT_TYPE), false);
            this.index = index2;
            if (isLateinit && name == null) {
                throw new IllegalArgumentException("Lateinit shared local variable should have name: #" + index2 + " " + type2.getDescriptor());
            }
            this.isLateinit = isLateinit;
            this.name = name;
        }

        public Shared(int index2, Type type2) {
            this(index2, type2, null, false, null);
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Shared.$$$reportNull$$$0(0);
            }
            if (v == null) {
                Shared.$$$reportNull$$$0(1);
            }
            Type refType = Shared.refType(this.type);
            Type sharedType = Shared.sharedTypeForType(this.type);
            v.visitFieldInsn(180, sharedType.getInternalName(), "element", refType.getDescriptor());
            if (this.isLateinit) {
                StackValue.genNonNullAssertForLateinit(v, this.name.asString());
            }
            this.coerceFrom(refType, null, v);
            this.coerceTo(type2, kotlinType, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                Shared.$$$reportNull$$$0(2);
            }
            if (v == null) {
                Shared.$$$reportNull$$$0(3);
            }
            this.coerceFrom(topOfStackType, topOfStackKotlinType, v);
            Type refType = Shared.refType(this.type);
            Type sharedType = Shared.sharedTypeForType(this.type);
            v.visitFieldInsn(181, sharedType.getInternalName(), "element", refType.getDescriptor());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$Shared";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Expression
    extends StackValue {
        private final KtExpression expression;
        private final ExpressionCodegen generator;

        public Expression(Type type2, KtExpression expression2, ExpressionCodegen generator2) {
            super(type2, generator2.kotlinType(expression2));
            this.expression = expression2;
            this.generator = generator2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Expression.$$$reportNull$$$0(0);
            }
            if (v == null) {
                Expression.$$$reportNull$$$0(1);
            }
            this.generator.gen(this.expression, type2, kotlinType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$Expression";
            objectArray[2] = "putSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Property
    extends StackValueWithSimpleReceiver {
        private final CallableMethod getter;
        private final CallableMethod setter;
        private final Type backingFieldOwner;
        private final PropertyDescriptor descriptor;
        private final String fieldName;
        private final ExpressionCodegen codegen;
        private final ResolvedCall resolvedCall;
        private final boolean skipLateinitAssertion;
        private final KotlinType delegateKotlinType;

        public Property(@NotNull PropertyDescriptor descriptor2, @Nullable Type backingFieldOwner, @Nullable CallableMethod getter2, @Nullable CallableMethod setter2, boolean isStaticBackingField, @Nullable String fieldName, @NotNull Type type2, @NotNull StackValue receiver, @NotNull ExpressionCodegen codegen2, @Nullable ResolvedCall resolvedCall2, boolean skipLateinitAssertion, @Nullable KotlinType delegateKotlinType) {
            if (descriptor2 == null) {
                Property.$$$reportNull$$$0(0);
            }
            if (type2 == null) {
                Property.$$$reportNull$$$0(1);
            }
            if (receiver == null) {
                Property.$$$reportNull$$$0(2);
            }
            if (codegen2 == null) {
                Property.$$$reportNull$$$0(3);
            }
            super(type2, descriptor2.getType(), Property.isStatic(isStaticBackingField, getter2), Property.isStatic(isStaticBackingField, setter2), receiver, true);
            this.backingFieldOwner = backingFieldOwner;
            this.getter = getter2;
            this.setter = setter2;
            this.descriptor = descriptor2;
            this.fieldName = fieldName;
            this.codegen = codegen2;
            this.resolvedCall = resolvedCall2;
            this.skipLateinitAssertion = skipLateinitAssertion;
            this.delegateKotlinType = delegateKotlinType;
        }

        private Property(@NotNull Property delegating, @NotNull DelegatePropertyConstructorMarker marker) {
            if (delegating == null) {
                Property.$$$reportNull$$$0(4);
            }
            if (marker == null) {
                Property.$$$reportNull$$$0(5);
            }
            super(delegating.type, delegating.delegateKotlinType, delegating.isStaticPut, delegating.isStaticStore, delegating.receiver, true);
            this.backingFieldOwner = delegating.backingFieldOwner;
            this.getter = delegating.getter;
            this.setter = delegating.setter;
            this.descriptor = delegating.descriptor;
            this.fieldName = delegating.fieldName;
            this.codegen = delegating.codegen;
            this.resolvedCall = delegating.resolvedCall;
            this.skipLateinitAssertion = delegating.skipLateinitAssertion;
            this.delegateKotlinType = null;
        }

        public Property getDelegateOrNull() {
            if (this.delegateKotlinType == null) {
                return null;
            }
            return new Property(this, DelegatePropertyConstructorMarker.MARKER);
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Property.$$$reportNull$$$0(6);
            }
            if (v == null) {
                Property.$$$reportNull$$$0(7);
            }
            if (this.getter == null) {
                assert (this.fieldName != null) : "Property should have either a getter or a field name: " + this.descriptor;
                assert (this.backingFieldOwner != null) : "Property should have either a getter or a backingFieldOwner: " + this.descriptor;
                if (this.inlineConstantIfNeeded(type2, kotlinType, v)) {
                    return;
                }
                v.visitFieldInsn(this.isStaticPut ? 178 : 180, this.backingFieldOwner.getInternalName(), this.fieldName, this.type.getDescriptor());
                if (!this.skipLateinitAssertion && this.descriptor.isLateInit()) {
                    boolean isCompanionAccessor;
                    CallableMemberDescriptor contextDescriptor = (CallableMemberDescriptor)this.codegen.context.getContextDescriptor();
                    boolean bl = isCompanionAccessor = contextDescriptor instanceof AccessorForPropertyBackingField && ((AccessorForPropertyBackingField)contextDescriptor).getAccessorKind() == AccessorKind.IN_CLASS_COMPANION;
                    if (!isCompanionAccessor) {
                        StackValue.genNonNullAssertForLateinit(v, this.descriptor.getName().asString());
                    }
                }
                this.coerceTo(type2, kotlinType, v);
            } else {
                KotlinType returnType2;
                PropertyGetterDescriptor getterDescriptor = this.descriptor.getGetter();
                assert (getterDescriptor != null) : "Getter descriptor should be not null for " + this.descriptor;
                if (this.resolvedCall != null && getterDescriptor.isInline()) {
                    CallGenerator callGenerator = this.codegen.getOrCreateCallGenerator(this.resolvedCall, ((PropertyDescriptor)this.resolvedCall.getResultingDescriptor()).getGetter());
                    callGenerator.processAndPutHiddenParameters(false);
                    callGenerator.genCall(this.getter, this.resolvedCall, false, this.codegen);
                } else {
                    this.getter.genInvokeInstruction(v);
                }
                Type typeOfValueOnStack = this.getter.getReturnType();
                KotlinType kotlinTypeOfValueOnStack = getterDescriptor.getReturnType();
                if (DescriptorUtils.isAnnotationClass(this.descriptor.getContainingDeclaration())) {
                    if (this.type.equals(AsmTypes.K_CLASS_TYPE)) {
                        AsmUtil.wrapJavaClassIntoKClass(v);
                        typeOfValueOnStack = AsmTypes.K_CLASS_TYPE;
                        kotlinTypeOfValueOnStack = null;
                    } else if (this.type.equals(AsmTypes.K_CLASS_ARRAY_TYPE)) {
                        AsmUtil.wrapJavaClassesIntoKClasses(v);
                        typeOfValueOnStack = AsmTypes.K_CLASS_ARRAY_TYPE;
                        kotlinTypeOfValueOnStack = null;
                    }
                }
                Property.coerce(typeOfValueOnStack, kotlinTypeOfValueOnStack, type2, kotlinType, v);
                if (this.descriptor instanceof AccessorForPropertyBackingField) {
                    PropertyDescriptor property2 = ((AccessorForPropertyBackingField)this.descriptor).getCalleeDescriptor();
                    if (!this.skipLateinitAssertion && property2.isLateInit() && DescriptorsJvmAbiUtil.isPropertyWithBackingFieldInOuterClass(property2) && !JvmCodegenUtil.couldUseDirectAccessToProperty(property2, true, false, this.codegen.context, false)) {
                        StackValue.genNonNullAssertForLateinit(v, property2.getName().asString());
                    }
                }
                if ((returnType2 = this.descriptor.getReturnType()) != null && KotlinBuiltIns.isNothing(returnType2)) {
                    v.aconst(null);
                    v.athrow();
                }
            }
        }

        private boolean inlineConstantIfNeeded(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Property.$$$reportNull$$$0(8);
            }
            if (v == null) {
                Property.$$$reportNull$$$0(9);
            }
            if (JvmCodegenUtil.isInlinedJavaConstProperty(this.descriptor)) {
                return this.inlineConstant(type2, kotlinType, v);
            }
            if (this.descriptor.isConst() && this.codegen.getState().getShouldInlineConstVals()) {
                return this.inlineConstant(type2, kotlinType, v);
            }
            return false;
        }

        private boolean inlineConstant(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Property.$$$reportNull$$$0(10);
            }
            if (v == null) {
                Property.$$$reportNull$$$0(11);
            }
            assert (AsmUtil.isPrimitive(this.type) || AsmTypes.JAVA_STRING_TYPE.equals(this.type)) : "Const property should have primitive or string type: " + this.descriptor;
            assert (this.isStaticPut) : "Const property should be static" + this.descriptor;
            ConstantValue<?> constantValue = this.descriptor.getCompileTimeInitializer();
            if (constantValue == null) {
                return false;
            }
            Object value2 = constantValue.getValue();
            if (this.type == Type.FLOAT_TYPE && value2 instanceof Double) {
                value2 = Float.valueOf(((Double)value2).floatValue());
            }
            StackValue.constant(value2, this.type, this.kotlinType).putSelector(type2, kotlinType, v);
            return true;
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v, boolean skipReceiver) {
            if (rightSide == null) {
                Property.$$$reportNull$$$0(12);
            }
            if (v == null) {
                Property.$$$reportNull$$$0(13);
            }
            PropertySetterDescriptor setterDescriptor = this.descriptor.getSetter();
            if (this.resolvedCall != null && setterDescriptor != null && setterDescriptor.isInline()) {
                assert (this.setter != null) : "Setter should be not null for " + this.descriptor;
                CallGenerator callGenerator = this.codegen.getOrCreateCallGenerator(this.resolvedCall, ((PropertyDescriptor)this.resolvedCall.getResultingDescriptor()).getSetter());
                if (!skipReceiver) {
                    this.putReceiver(v, false);
                }
                callGenerator.processAndPutHiddenParameters(true);
                callGenerator.putValueIfNeeded(new JvmKotlinType(((JvmMethodParameterSignature)CollectionsKt.last(this.setter.getValueParameters())).getAsmType(), ((ValueParameterDescriptor)CollectionsKt.last(setterDescriptor.getValueParameters())).getType()), rightSide);
                callGenerator.putHiddenParamsIntoLocals();
                callGenerator.genCall(this.setter, this.resolvedCall, false, this.codegen);
            } else {
                super.store(rightSide, v, skipReceiver);
            }
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                Property.$$$reportNull$$$0(14);
            }
            if (v == null) {
                Property.$$$reportNull$$$0(15);
            }
            if (this.setter == null) {
                this.coerceFrom(topOfStackType, topOfStackKotlinType, v);
                assert (this.fieldName != null) : "Property should have either a setter or a field name: " + this.descriptor;
                assert (this.backingFieldOwner != null) : "Property should have either a setter or a backingFieldOwner: " + this.descriptor;
                v.visitFieldInsn(this.isStaticStore ? 179 : 181, this.backingFieldOwner.getInternalName(), this.fieldName, this.type.getDescriptor());
            } else {
                PropertySetterDescriptor setterDescriptor = this.descriptor.getSetter();
                KotlinType setterLastParameterType = setterDescriptor != null ? ((ValueParameterDescriptor)CollectionsKt.last(setterDescriptor.getValueParameters())).getReturnType() : null;
                Property.coerce(topOfStackType, topOfStackKotlinType, (Type)ArraysKt.last((Object[])this.setter.getParameterTypes()), setterLastParameterType, v);
                this.setter.genInvokeInstruction(v);
                Type returnType2 = this.setter.getReturnType();
                if (returnType2 != Type.VOID_TYPE) {
                    AsmUtil.pop(v, returnType2);
                }
            }
        }

        private static boolean isStatic(boolean isStaticBackingField, @Nullable CallableMethod callable) {
            if (isStaticBackingField && callable == null) {
                return true;
            }
            if (callable != null && callable.isStaticCall()) {
                JvmMethodParameterSignature parameter;
                JvmMethodParameterKind kind;
                List<JvmMethodParameterSignature> parameters2 = callable.getValueParameters();
                Iterator<JvmMethodParameterSignature> iterator2 = parameters2.iterator();
                while (iterator2.hasNext() && (kind = (parameter = iterator2.next()).getKind()) != JvmMethodParameterKind.VALUE) {
                    if (kind != JvmMethodParameterKind.RECEIVER && kind != JvmMethodParameterKind.THIS) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: 
                case 6: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codegen";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegating";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "marker";
                    break;
                }
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightSide";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$Property";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inlineConstantIfNeeded";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inlineConstant";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "store";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class DelegatePropertyConstructorMarker {
            public static final DelegatePropertyConstructorMarker MARKER = new DelegatePropertyConstructorMarker();

            private DelegatePropertyConstructorMarker() {
            }
        }
    }

    public static class Field
    extends StackValueWithSimpleReceiver {
        public final Type owner;
        public final String name;
        public final DeclarationDescriptor descriptor;

        public Field(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull Type owner, @NotNull String name, boolean isStatic, @NotNull StackValue receiver, @Nullable DeclarationDescriptor descriptor2) {
            if (type2 == null) {
                Field.$$$reportNull$$$0(0);
            }
            if (owner == null) {
                Field.$$$reportNull$$$0(1);
            }
            if (name == null) {
                Field.$$$reportNull$$$0(2);
            }
            if (receiver == null) {
                Field.$$$reportNull$$$0(3);
            }
            super(type2, kotlinType, isStatic, isStatic, receiver, receiver.canHaveSideEffects());
            this.owner = owner;
            this.name = name;
            this.descriptor = descriptor2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Field.$$$reportNull$$$0(4);
            }
            if (v == null) {
                Field.$$$reportNull$$$0(5);
            }
            v.visitFieldInsn(this.isStaticPut ? 178 : 180, this.owner.getInternalName(), this.name, this.type.getDescriptor());
            this.coerceTo(type2, kotlinType, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                Field.$$$reportNull$$$0(6);
            }
            if (v == null) {
                Field.$$$reportNull$$$0(7);
            }
            this.coerceFrom(topOfStackType, topOfStackKotlinType, v);
            v.visitFieldInsn(this.isStaticStore ? 179 : 181, this.owner.getInternalName(), this.name, this.type.getDescriptor());
        }

        @Override
        protected StackValueWithSimpleReceiver changeReceiver(@NotNull StackValue newReceiver) {
            if (newReceiver == null) {
                Field.$$$reportNull$$$0(8);
            }
            return Field.field(this, newReceiver);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newReceiver";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$Field";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "changeReceiver";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CollectionElement
    extends StackValueWithSimpleReceiver {
        private final Callable getter;
        private final Callable setter;
        private final ExpressionCodegen codegen;
        private final ResolvedCall<FunctionDescriptor> resolvedGetCall;
        private final ResolvedCall<FunctionDescriptor> resolvedSetCall;

        public CollectionElement(@NotNull CollectionElementReceiver collectionElementReceiver, @NotNull Type type2, @Nullable KotlinType kotlinType, @Nullable ResolvedCall<FunctionDescriptor> resolvedGetCall, @Nullable ResolvedCall<FunctionDescriptor> resolvedSetCall, @NotNull ExpressionCodegen codegen2) {
            if (collectionElementReceiver == null) {
                CollectionElement.$$$reportNull$$$0(0);
            }
            if (type2 == null) {
                CollectionElement.$$$reportNull$$$0(1);
            }
            if (codegen2 == null) {
                CollectionElement.$$$reportNull$$$0(2);
            }
            super(type2, kotlinType, false, false, collectionElementReceiver, true);
            this.resolvedGetCall = resolvedGetCall;
            this.resolvedSetCall = resolvedSetCall;
            this.setter = resolvedSetCall == null ? null : codegen2.resolveToCallable(codegen2.accessibleFunctionDescriptor(resolvedSetCall), false, resolvedSetCall);
            this.getter = resolvedGetCall == null ? null : codegen2.resolveToCallable(codegen2.accessibleFunctionDescriptor(resolvedGetCall), false, resolvedGetCall);
            this.codegen = codegen2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                CollectionElement.$$$reportNull$$$0(3);
            }
            if (v == null) {
                CollectionElement.$$$reportNull$$$0(4);
            }
            if (this.getter == null) {
                throw new UnsupportedOperationException("no getter specified");
            }
            CallGenerator callGenerator = this.getCallGenerator();
            callGenerator.genCall(this.getter, this.resolvedGetCall, this.genDefaultMaskIfPresent(callGenerator), this.codegen);
            this.coerceTo(type2, kotlinType, v);
        }

        private boolean genDefaultMaskIfPresent(CallGenerator callGenerator) {
            DefaultCallArgs defaultArgs = ((CollectionElementReceiver)this.receiver).defaultArgs;
            return defaultArgs.generateOnStackIfNeeded(callGenerator, true);
        }

        private CallGenerator getCallGenerator() {
            CallGenerator generator2 = ((CollectionElementReceiver)this.receiver).callGenerator;
            assert (generator2 != null) : "CollectionElementReceiver should be putted on stack before CollectionElement: getCall = " + this.resolvedGetCall + ",  setCall = " + this.resolvedSetCall;
            return generator2;
        }

        @Override
        public int receiverSize() {
            if (CollectionElement.isStandardStack(this.codegen.typeMapper, this.resolvedGetCall, 1) && CollectionElement.isStandardStack(this.codegen.typeMapper, this.resolvedSetCall, 2)) {
                return 2;
            }
            return -1;
        }

        public static boolean isStandardStack(@NotNull KotlinTypeMapper typeMapper2, @Nullable ResolvedCall<?> call2, int valueParamsSize) {
            if (typeMapper2 == null) {
                CollectionElement.$$$reportNull$$$0(5);
            }
            if (call2 == null) {
                return true;
            }
            List<ValueParameterDescriptor> valueParameters2 = call2.getResultingDescriptor().getValueParameters();
            if (valueParameters2.size() != valueParamsSize) {
                return false;
            }
            for (ValueParameterDescriptor valueParameter : valueParameters2) {
                if (typeMapper2.mapType(valueParameter.getType()).getSize() == 1) continue;
                return false;
            }
            return !(call2.getDispatchReceiver() != null ? call2.getExtensionReceiver() != null : typeMapper2.mapType(call2.getResultingDescriptor().getExtensionReceiverParameter().getType()).getSize() != 1);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                CollectionElement.$$$reportNull$$$0(6);
            }
            if (v == null) {
                CollectionElement.$$$reportNull$$$0(7);
            }
            if (this.setter == null) {
                throw new UnsupportedOperationException("no setter specified");
            }
            Type lastParameterType = (Type)ArraysKt.last((Object[])this.setter.getParameterTypes());
            KotlinType lastParameterKotlinType = ((ValueParameterDescriptor)CollectionsKt.last(this.resolvedSetCall.getResultingDescriptor().getOriginal().getValueParameters())).getType();
            CollectionElement.coerce(topOfStackType, topOfStackKotlinType, lastParameterType, lastParameterKotlinType, v);
            CallGenerator callGenerator = this.getCallGenerator();
            callGenerator.putValueIfNeeded(new JvmKotlinType(lastParameterType, lastParameterKotlinType), StackValue.onStack(lastParameterType, lastParameterKotlinType));
            CollectionElementReceiver collectionElementReceiver = (CollectionElementReceiver)this.receiver;
            boolean callDefault = false;
            boolean properSetterCalls = this.codegen.getState().getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperArrayConventionSetterWithDefaultCalls);
            if (collectionElementReceiver.isGetter) {
                ArrayList getterArguments = new ArrayList(collectionElementReceiver.valueArguments);
                List getterDefaults = CollectionsKt.takeLastWhile(getterArguments, argument -> argument instanceof DefaultValueArgument);
                List<ResolvedValueArgument> setterArguments = this.resolvedSetCall.getValueArgumentsByIndex();
                List setterDefaults = CollectionsKt.takeLastWhile((List)CollectionsKt.dropLast(setterArguments, (int)1), argument -> argument instanceof DefaultValueArgument);
                if (!getterDefaults.isEmpty() || !setterDefaults.isEmpty()) {
                    Local rhsValue = StackValue.local(this.codegen.myFrameMap.enterTemp(lastParameterType), lastParameterType);
                    rhsValue.store(StackValue.onStack(this.type), v);
                    List<Type> types2 = this.getter.getValueParameterTypes();
                    for (int i = collectionElementReceiver.valueArguments.size() - 1; i >= 0; --i) {
                        ResolvedValueArgument argument2 = (ResolvedValueArgument)collectionElementReceiver.valueArguments.get(i);
                        if (!(argument2 instanceof DefaultValueArgument)) continue;
                        AsmUtil.pop(v, types2.get(i));
                    }
                    if (properSetterCalls) {
                        DefaultCallArgs defaultArgs = new DefaultCallArgs(CodegenUtilKt.unwrapFrontendVersion(this.resolvedSetCall.getResultingDescriptor()).getValueParameters().size());
                        if (!setterDefaults.isEmpty()) {
                            CallBasedArgumentGenerator setterArgumentGenerator = new CallBasedArgumentGenerator(this.codegen, callGenerator, this.resolvedSetCall.getResultingDescriptor().getValueParameters(), this.setter.getValueParameterTypes());
                            int defaultIndex = CollectionsKt.getLastIndex(setterArguments) - 1 - setterDefaults.size();
                            for (ResolvedValueArgument aDefault : setterDefaults) {
                                defaultArgs.mark(++defaultIndex);
                                ((ArgumentGenerator)setterArgumentGenerator).generateDefault(defaultIndex, (DefaultValueArgument)aDefault);
                            }
                            callDefault = true;
                        }
                        rhsValue.put(v);
                        this.codegen.myFrameMap.leaveTemp(lastParameterType);
                        defaultArgs.generateOnStackIfNeeded(callGenerator, false);
                    } else {
                        rhsValue.put(v);
                        this.codegen.myFrameMap.leaveTemp(lastParameterType);
                    }
                }
            } else {
                callDefault = properSetterCalls && this.genDefaultMaskIfPresent(callGenerator);
            }
            callGenerator.genCall(this.setter, this.resolvedSetCall, callDefault, this.codegen);
            Type returnType2 = this.setter.getReturnType();
            if (returnType2 != Type.VOID_TYPE) {
                AsmUtil.pop(v, returnType2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collectionElementReceiver";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codegen";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeMapper";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$CollectionElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isStandardStack";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CollectionElementReceiver
    extends StackValue {
        private final Callable callable;
        private final boolean isGetter;
        private final ExpressionCodegen codegen;
        private final List<ResolvedValueArgument> valueArguments;
        private final FrameMap frame;
        private final StackValue receiver;
        private final ResolvedCall<FunctionDescriptor> resolvedGetCall;
        private final ResolvedCall<FunctionDescriptor> resolvedSetCall;
        private DefaultCallArgs defaultArgs;
        private CallGenerator callGenerator;
        boolean isComplexOperationWithDup;

        public CollectionElementReceiver(@NotNull Callable callable, @NotNull StackValue receiver, ResolvedCall<FunctionDescriptor> resolvedGetCall, ResolvedCall<FunctionDescriptor> resolvedSetCall, boolean isGetter, @NotNull ExpressionCodegen codegen2, List<ResolvedValueArgument> valueArguments) {
            if (callable == null) {
                CollectionElementReceiver.$$$reportNull$$$0(0);
            }
            if (receiver == null) {
                CollectionElementReceiver.$$$reportNull$$$0(1);
            }
            if (codegen2 == null) {
                CollectionElementReceiver.$$$reportNull$$$0(2);
            }
            super(AsmTypes.OBJECT_TYPE);
            this.callable = callable;
            this.isGetter = isGetter;
            this.receiver = receiver;
            this.resolvedGetCall = resolvedGetCall;
            this.resolvedSetCall = resolvedSetCall;
            this.valueArguments = valueArguments;
            this.codegen = codegen2;
            this.frame = codegen2.myFrameMap;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                CollectionElementReceiver.$$$reportNull$$$0(3);
            }
            if (v == null) {
                CollectionElementReceiver.$$$reportNull$$$0(4);
            }
            ResolvedCall<FunctionDescriptor> call2 = this.isGetter ? this.resolvedGetCall : this.resolvedSetCall;
            StackValue newReceiver = StackValue.receiver(call2, this.receiver, this.codegen, this.callable);
            ArgumentGenerator generator2 = this.createArgumentGenerator();
            newReceiver.put(newReceiver.type, newReceiver.kotlinType, v);
            this.callGenerator.processAndPutHiddenParameters(false);
            this.defaultArgs = generator2.generate(this.valueArguments, this.valueArguments, call2.getResultingDescriptor());
        }

        private ArgumentGenerator createArgumentGenerator() {
            ResolvedCall<FunctionDescriptor> resolvedCall2;
            assert (this.callGenerator == null) : "'putSelector' and 'createArgumentGenerator' methods should be called once for CollectionElementReceiver: " + this.callable;
            ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2 = this.isGetter ? this.resolvedGetCall : this.resolvedSetCall;
            assert (resolvedCall2 != null) : "Resolved call should be non-null: " + this.callable;
            this.callGenerator = !this.isComplexOperationWithDup ? this.codegen.getOrCreateCallGenerator(resolvedCall2) : this.codegen.defaultCallGenerator;
            return new CallBasedArgumentGenerator(this.codegen, this.callGenerator, resolvedCall2.getResultingDescriptor().getValueParameters(), this.callable.getValueParameterTypes());
        }

        @Override
        public void dup(@NotNull InstructionAdapter v, boolean withReceiver) {
            if (v == null) {
                CollectionElementReceiver.$$$reportNull$$$0(5);
            }
            this.dupReceiver(v);
        }

        public void dupReceiver(@NotNull InstructionAdapter v) {
            Type type2;
            int realReceiverIndex;
            Type realReceiverType;
            if (v == null) {
                CollectionElementReceiver.$$$reportNull$$$0(6);
            }
            if (CollectionElement.isStandardStack(this.codegen.typeMapper, this.resolvedGetCall, 1) && CollectionElement.isStandardStack(this.codegen.typeMapper, this.resolvedSetCall, 2)) {
                v.dup2();
                return;
            }
            FrameMapBase.Mark mark = this.frame.mark();
            List<ValueParameterDescriptor> valueParameters2 = this.resolvedGetCall.getResultingDescriptor().getValueParameters();
            int firstParamIndex = -1;
            for (int i = valueParameters2.size() - 1; i >= 0; --i) {
                Type type3 = this.codegen.typeMapper.mapType(valueParameters2.get(i).getType());
                firstParamIndex = this.frame.enterTemp(type3);
                v.store(firstParamIndex, type3);
            }
            ReceiverValue receiverParameter = this.resolvedGetCall.getExtensionReceiver();
            int receiverIndex = -1;
            if (receiverParameter != null) {
                Type type4 = this.codegen.typeMapper.mapType(receiverParameter.getType());
                receiverIndex = this.frame.enterTemp(type4);
                v.store(receiverIndex, type4);
            }
            ReceiverValue dispatchReceiver = this.resolvedGetCall.getDispatchReceiver();
            int thisIndex = -1;
            if (dispatchReceiver != null) {
                thisIndex = this.frame.enterTemp(AsmTypes.OBJECT_TYPE);
                v.store(thisIndex, AsmTypes.OBJECT_TYPE);
            }
            if (receiverIndex != -1) {
                realReceiverType = this.codegen.typeMapper.mapType(receiverParameter.getType());
                realReceiverIndex = receiverIndex;
            } else if (thisIndex != -1) {
                realReceiverType = AsmTypes.OBJECT_TYPE;
                realReceiverIndex = thisIndex;
            } else {
                throw new UnsupportedOperationException();
            }
            if (this.resolvedSetCall.getDispatchReceiver() != null) {
                if (this.resolvedSetCall.getExtensionReceiver() != null) {
                    this.codegen.generateReceiverValue(this.resolvedSetCall.getDispatchReceiver(), false).put(AsmTypes.OBJECT_TYPE, null, v);
                }
                v.load(realReceiverIndex, realReceiverType);
            } else if (this.resolvedSetCall.getExtensionReceiver() != null) {
                v.load(realReceiverIndex, realReceiverType);
            } else {
                throw new UnsupportedOperationException();
            }
            int index2 = firstParamIndex;
            for (ValueParameterDescriptor valueParameter : valueParameters2) {
                type2 = this.codegen.typeMapper.mapType(valueParameter.getType());
                v.load(index2, type2);
                index2 -= type2.getSize();
            }
            if (thisIndex != -1) {
                v.load(thisIndex, AsmTypes.OBJECT_TYPE);
            }
            if (receiverIndex != -1) {
                v.load(receiverIndex, realReceiverType);
            }
            index2 = firstParamIndex;
            for (ValueParameterDescriptor valueParameter : valueParameters2) {
                type2 = this.codegen.typeMapper.mapType(valueParameter.getType());
                v.load(index2, type2);
                index2 -= type2.getSize();
            }
            mark.dropTo();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codegen";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$CollectionElementReceiver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dup";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dupReceiver";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UnderlyingValueOfInlineClass
    extends StackValueWithSimpleReceiver {
        public UnderlyingValueOfInlineClass(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull StackValue receiver) {
            if (type2 == null) {
                UnderlyingValueOfInlineClass.$$$reportNull$$$0(0);
            }
            if (receiver == null) {
                UnderlyingValueOfInlineClass.$$$reportNull$$$0(1);
            }
            super(type2, kotlinType, false, false, receiver, true);
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                UnderlyingValueOfInlineClass.$$$reportNull$$$0(2);
            }
            if (v == null) {
                UnderlyingValueOfInlineClass.$$$reportNull$$$0(3);
            }
            this.coerceTo(type2, kotlinType, v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$UnderlyingValueOfInlineClass";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ArrayElement
    extends StackValueWithSimpleReceiver {
        private final Type type;

        public ArrayElement(Type type2, KotlinType kotlinType, StackValue array, StackValue index2) {
            super(type2, kotlinType, false, false, new Receiver(Type.LONG_TYPE, array, index2), true);
            this.type = type2;
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                ArrayElement.$$$reportNull$$$0(0);
            }
            if (v == null) {
                ArrayElement.$$$reportNull$$$0(1);
            }
            this.coerceFrom(topOfStackType, topOfStackKotlinType, v);
            v.astore(this.type);
        }

        @Override
        public int receiverSize() {
            return 2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                ArrayElement.$$$reportNull$$$0(2);
            }
            if (v == null) {
                ArrayElement.$$$reportNull$$$0(3);
            }
            v.aload(this.type);
            this.coerceTo(type2, kotlinType, v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$ArrayElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Constant
    extends StackValue {
        @Nullable
        public final Object value;

        public Constant(@Nullable Object value2, Type type2, KotlinType kotlinType) {
            super(type2, kotlinType, false);
            assert (!Type.BOOLEAN_TYPE.equals(type2)) : "Boolean constants should be created via 'StackValue.constant'";
            this.value = value2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Constant.$$$reportNull$$$0(0);
            }
            if (v == null) {
                Constant.$$$reportNull$$$0(1);
            }
            if (this.value instanceof Integer || this.value instanceof Byte || this.value instanceof Short) {
                v.iconst(((Number)this.value).intValue());
            } else if (this.value instanceof Character) {
                v.iconst(((Character)this.value).charValue());
            } else if (this.value instanceof Long) {
                v.lconst((Long)this.value);
            } else if (this.value instanceof Float) {
                v.fconst(((Float)this.value).floatValue());
            } else if (this.value instanceof Double) {
                v.dconst((Double)this.value);
            } else {
                v.aconst(this.value);
            }
            if (this.value != null || AsmUtil.isPrimitive(type2)) {
                this.coerceTo(type2, kotlinType, v);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$Constant";
            objectArray[2] = "putSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class OnStack
    extends StackValue {
        public OnStack(Type type2) {
            this(type2, null);
        }

        public OnStack(Type type2, KotlinType kotlinType) {
            super(type2, kotlinType);
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                OnStack.$$$reportNull$$$0(0);
            }
            if (v == null) {
                OnStack.$$$reportNull$$$0(1);
            }
            this.coerceTo(type2, kotlinType, v);
        }

        @Override
        public void moveToTopOfStack(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v, int depth) {
            if (type2 == null) {
                OnStack.$$$reportNull$$$0(2);
            }
            if (v == null) {
                OnStack.$$$reportNull$$$0(3);
            }
            if (depth == 0) {
                this.put(type2, kotlinType, v);
            } else if (depth == 1) {
                int size = this.type.getSize();
                if (size == 1) {
                    v.swap();
                } else if (size == 2) {
                    v.dupX2();
                    v.pop();
                } else {
                    throw new UnsupportedOperationException("don't know how to move type " + type2 + " to top of stack");
                }
                this.coerceTo(type2, kotlinType, v);
            } else if (depth == 2) {
                int size = this.type.getSize();
                if (size == 1) {
                    v.dup2X1();
                    v.pop2();
                } else if (size == 2) {
                    v.dup2X2();
                    v.pop2();
                } else {
                    throw new UnsupportedOperationException("don't know how to move type " + type2 + " to top of stack");
                }
                this.coerceTo(type2, kotlinType, v);
            } else {
                throw new UnsupportedOperationException("unsupported move-to-top depth " + depth);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$OnStack";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveToTopOfStack";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Delegate
    extends StackValue {
        @NotNull
        private final StackValue delegateValue;
        @NotNull
        private final StackValue metadataValue;
        @NotNull
        private final VariableDescriptorWithAccessors variableDescriptor;
        @NotNull
        private final ExpressionCodegen codegen;

        private Delegate(@NotNull Type type2, @NotNull StackValue delegateValue, @NotNull StackValue metadataValue, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull ExpressionCodegen codegen2) {
            if (type2 == null) {
                Delegate.$$$reportNull$$$0(0);
            }
            if (delegateValue == null) {
                Delegate.$$$reportNull$$$0(1);
            }
            if (metadataValue == null) {
                Delegate.$$$reportNull$$$0(2);
            }
            if (variableDescriptor == null) {
                Delegate.$$$reportNull$$$0(3);
            }
            if (codegen2 == null) {
                Delegate.$$$reportNull$$$0(4);
            }
            super(type2);
            this.delegateValue = delegateValue;
            this.metadataValue = metadataValue;
            this.variableDescriptor = variableDescriptor;
            this.codegen = codegen2;
        }

        private ResolvedCall<FunctionDescriptor> getResolvedCall(boolean isGetter) {
            VariableAccessorDescriptor accessor;
            BindingContext bindingContext = this.codegen.getState().getBindingContext();
            VariableAccessorDescriptor variableAccessorDescriptor = accessor = isGetter ? this.variableDescriptor.getGetter() : this.variableDescriptor.getSetter();
            assert (accessor != null) : "Accessor descriptor for delegated local property should be present " + this.variableDescriptor;
            ResolvedCall<FunctionDescriptor> resolvedCall2 = bindingContext.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, accessor);
            assert (resolvedCall2 != null) : "Resolve call should be recorded for delegate call " + this.variableDescriptor;
            return resolvedCall2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Delegate.$$$reportNull$$$0(5);
            }
            if (v == null) {
                Delegate.$$$reportNull$$$0(6);
            }
            ResolvedCall<FunctionDescriptor> resolvedCall2 = this.getResolvedCall(true);
            List<? extends ValueArgument> arguments2 = resolvedCall2.getCall().getValueArguments();
            assert (arguments2.size() == 2) : "Resolved call for 'getValue' should have 2 arguments, but was " + arguments2.size() + ": " + resolvedCall2;
            this.codegen.tempVariables.put(arguments2.get(0).asElement(), StackValue.constant(null, AsmTypes.OBJECT_TYPE));
            this.codegen.tempVariables.put(arguments2.get(1).asElement(), this.metadataValue);
            StackValue lastValue = this.codegen.invokeFunction(resolvedCall2, this.delegateValue);
            lastValue.put(type2, kotlinType, v);
            this.codegen.tempVariables.remove(arguments2.get(0).asElement());
            this.codegen.tempVariables.remove(arguments2.get(1).asElement());
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v, boolean skipReceiver) {
            if (rightSide == null) {
                Delegate.$$$reportNull$$$0(7);
            }
            if (v == null) {
                Delegate.$$$reportNull$$$0(8);
            }
            ResolvedCall<FunctionDescriptor> resolvedCall2 = this.getResolvedCall(false);
            List<? extends ValueArgument> arguments2 = resolvedCall2.getCall().getValueArguments();
            assert (arguments2.size() == 3) : "Resolved call for 'setValue' should have 3 arguments, but was " + arguments2.size() + ": " + resolvedCall2;
            this.codegen.tempVariables.put(arguments2.get(0).asElement(), StackValue.constant(null, AsmTypes.OBJECT_TYPE));
            this.codegen.tempVariables.put(arguments2.get(1).asElement(), this.metadataValue);
            this.codegen.tempVariables.put(arguments2.get(2).asElement(), rightSide);
            StackValue lastValue = this.codegen.invokeFunction(resolvedCall2, this.delegateValue);
            lastValue.put(Type.VOID_TYPE, null, v);
            this.codegen.tempVariables.remove(arguments2.get(0).asElement());
            this.codegen.tempVariables.remove(arguments2.get(1).asElement());
            this.codegen.tempVariables.remove(arguments2.get(2).asElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegateValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "metadataValue";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variableDescriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codegen";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightSide";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$Delegate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "store";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class LateinitLocal
    extends StackValue {
        public final int index;
        private final Name name;

        private LateinitLocal(int index2, Type type2, KotlinType kotlinType, Name name) {
            super(type2, kotlinType, false);
            if (index2 < 0) {
                throw new IllegalStateException("local variable index must be non-negative");
            }
            if (name == null) {
                throw new IllegalArgumentException("Lateinit local variable should have name: #" + index2 + " " + type2.getDescriptor());
            }
            this.index = index2;
            this.name = name;
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                LateinitLocal.$$$reportNull$$$0(0);
            }
            if (v == null) {
                LateinitLocal.$$$reportNull$$$0(1);
            }
            v.load(this.index, this.type);
            StackValue.genNonNullAssertForLateinit(v, this.name.asString());
            this.coerceTo(type2, kotlinType, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                LateinitLocal.$$$reportNull$$$0(2);
            }
            if (v == null) {
                LateinitLocal.$$$reportNull$$$0(3);
            }
            this.coerceFrom(topOfStackType, topOfStackKotlinType, v);
            v.store(this.index, this.type);
            PseudoInsnsKt.storeNotNull(v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$LateinitLocal";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Local
    extends StackValue {
        public final int index;

        private Local(int index2, Type type2, KotlinType kotlinType) {
            super(type2, kotlinType, false);
            if (index2 < 0) {
                throw new IllegalStateException("local variable index must be non-negative");
            }
            this.index = index2;
        }

        private Local(int index2, Type type2) {
            this(index2, type2, (KotlinType)null);
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Local.$$$reportNull$$$0(0);
            }
            if (v == null) {
                Local.$$$reportNull$$$0(1);
            }
            v.load(this.index, this.type);
            this.coerceTo(type2, kotlinType, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                Local.$$$reportNull$$$0(2);
            }
            if (v == null) {
                Local.$$$reportNull$$$0(3);
            }
            this.coerceFrom(topOfStackType, topOfStackKotlinType, v);
            v.store(this.index, this.type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$Local";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class None
    extends StackValue {
        public static final None INSTANCE = new None();

        private None() {
            super(Type.VOID_TYPE, false);
        }

        @Override
        public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                None.$$$reportNull$$$0(0);
            }
            if (v == null) {
                None.$$$reportNull$$$0(1);
            }
            this.coerceTo(type2, kotlinType, v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$None";
            objectArray[2] = "putSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

