/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.functions.FunctionClassKind;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001/B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010&\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020)H\u0007J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010+\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020$H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00198\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/builtins/StandardNames;", "", "()V", "ANNOTATION_PACKAGE_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "BUILT_INS_PACKAGE_FQ_NAME", "BUILT_INS_PACKAGE_FQ_NAMES", "", "BUILT_INS_PACKAGE_NAME", "Lorg/jetbrains/kotlin/name/Name;", "COLLECTIONS_PACKAGE_FQ_NAME", "CONTINUATION_INTERFACE_FQ_NAME_EXPERIMENTAL", "CONTINUATION_INTERFACE_FQ_NAME_RELEASE", "COROUTINES_INTRINSICS_PACKAGE_FQ_NAME_EXPERIMENTAL", "COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL", "COROUTINES_PACKAGE_FQ_NAME_RELEASE", "ENUM_VALUES", "ENUM_VALUE_OF", "KOTLIN_REFLECT_FQ_NAME", "K_FUNCTION_PREFIX", "", "K_MUTABLE_PROPERTY_PREFIX", "K_PROPERTY_PREFIX", "K_SUSPEND_FUNCTION_PREFIX", "PREFIXES", "", "RANGES_PACKAGE_FQ_NAME", "RESULT_FQ_NAME", "TEXT_PACKAGE_FQ_NAME", "getFunctionClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "parameterCount", "", "getFunctionName", "getKFunctionClassId", "getKFunctionFqName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "getKSuspendFunctionClassId", "getKSuspendFunctionName", "getPrimitiveFqName", "primitiveType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "getSuspendFunctionClassId", "getSuspendFunctionName", "isPrimitiveArray", "", "arrayFqName", "FqNames", "compiler.common"})
public final class StandardNames {
    @JvmField
    @NotNull
    public static final Name ENUM_VALUES;
    @JvmField
    @NotNull
    public static final Name ENUM_VALUE_OF;
    @JvmField
    @NotNull
    public static final FqName COROUTINES_PACKAGE_FQ_NAME_RELEASE;
    @JvmField
    @NotNull
    public static final FqName COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL;
    @JvmField
    @NotNull
    public static final FqName COROUTINES_INTRINSICS_PACKAGE_FQ_NAME_EXPERIMENTAL;
    @JvmField
    @NotNull
    public static final FqName CONTINUATION_INTERFACE_FQ_NAME_EXPERIMENTAL;
    @JvmField
    @NotNull
    public static final FqName CONTINUATION_INTERFACE_FQ_NAME_RELEASE;
    @JvmField
    @NotNull
    public static final FqName RESULT_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName KOTLIN_REFLECT_FQ_NAME;
    @NotNull
    public static final String K_PROPERTY_PREFIX = "KProperty";
    @NotNull
    public static final String K_MUTABLE_PROPERTY_PREFIX = "KMutableProperty";
    @NotNull
    public static final String K_FUNCTION_PREFIX = "KFunction";
    @NotNull
    public static final String K_SUSPEND_FUNCTION_PREFIX = "KSuspendFunction";
    @JvmField
    @NotNull
    public static final List<String> PREFIXES;
    @JvmField
    @NotNull
    public static final Name BUILT_INS_PACKAGE_NAME;
    @JvmField
    @NotNull
    public static final FqName BUILT_INS_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName ANNOTATION_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName COLLECTIONS_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName RANGES_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName TEXT_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final Set<FqName> BUILT_INS_PACKAGE_FQ_NAMES;
    @NotNull
    public static final StandardNames INSTANCE;

    @JvmStatic
    @NotNull
    public static final String getFunctionName(int parameterCount) {
        return "Function" + parameterCount;
    }

    @JvmStatic
    @NotNull
    public static final ClassId getFunctionClassId(int parameterCount) {
        return new ClassId(BUILT_INS_PACKAGE_FQ_NAME, Name.identifier(StandardNames.getFunctionName(parameterCount)));
    }

    @JvmStatic
    @NotNull
    public static final FqNameUnsafe getKFunctionFqName(int parameterCount) {
        return FqNames.reflect(FunctionClassKind.KFunction.getClassNamePrefix() + parameterCount);
    }

    @JvmStatic
    @NotNull
    public static final ClassId getKFunctionClassId(int parameterCount) {
        FqNameUnsafe fqName2 = StandardNames.getKFunctionFqName(parameterCount);
        return new ClassId(fqName2.parent().toSafe(), fqName2.shortName());
    }

    @JvmStatic
    @NotNull
    public static final String getSuspendFunctionName(int parameterCount) {
        return FunctionClassKind.SuspendFunction.getClassNamePrefix() + parameterCount;
    }

    @JvmStatic
    @NotNull
    public static final ClassId getSuspendFunctionClassId(int parameterCount) {
        return new ClassId(COROUTINES_PACKAGE_FQ_NAME_RELEASE, Name.identifier(StandardNames.getSuspendFunctionName(parameterCount)));
    }

    @JvmStatic
    @NotNull
    public static final FqNameUnsafe getKSuspendFunctionName(int parameterCount) {
        return FqNames.reflect(FunctionClassKind.KSuspendFunction.getClassNamePrefix() + parameterCount);
    }

    @JvmStatic
    @NotNull
    public static final ClassId getKSuspendFunctionClassId(int parameterCount) {
        FqNameUnsafe fqName2 = StandardNames.getKSuspendFunctionName(parameterCount);
        return new ClassId(fqName2.parent().toSafe(), fqName2.shortName());
    }

    @JvmStatic
    public static final boolean isPrimitiveArray(@NotNull FqNameUnsafe arrayFqName) {
        Intrinsics.checkNotNullParameter((Object)arrayFqName, (String)"arrayFqName");
        return FqNames.arrayClassFqNameToPrimitiveType.get(arrayFqName) != null;
    }

    @JvmStatic
    @NotNull
    public static final FqName getPrimitiveFqName(@NotNull PrimitiveType primitiveType) {
        Intrinsics.checkNotNullParameter((Object)((Object)primitiveType), (String)"primitiveType");
        FqName fqName2 = BUILT_INS_PACKAGE_FQ_NAME.child(primitiveType.getTypeName());
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"BUILT_INS_PACKAGE_FQ_NAM\u2026d(primitiveType.typeName)");
        return fqName2;
    }

    private StandardNames() {
    }

    static {
        StandardNames standardNames;
        INSTANCE = standardNames = new StandardNames();
        Name name = Name.identifier("values");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(\"values\")");
        ENUM_VALUES = name;
        Name name2 = Name.identifier("valueOf");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.identifier(\"valueOf\")");
        ENUM_VALUE_OF = name2;
        COROUTINES_PACKAGE_FQ_NAME_RELEASE = new FqName("kotlin.coroutines");
        FqName fqName2 = COROUTINES_PACKAGE_FQ_NAME_RELEASE.child(Name.identifier("experimental"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"COROUTINES_PACKAGE_FQ_NA\u2026entifier(\"experimental\"))");
        COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL = fqName2;
        FqName fqName3 = COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL.child(Name.identifier("intrinsics"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"COROUTINES_PACKAGE_FQ_NA\u2026identifier(\"intrinsics\"))");
        COROUTINES_INTRINSICS_PACKAGE_FQ_NAME_EXPERIMENTAL = fqName3;
        FqName fqName4 = COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL.child(Name.identifier("Continuation"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"COROUTINES_PACKAGE_FQ_NA\u2026entifier(\"Continuation\"))");
        CONTINUATION_INTERFACE_FQ_NAME_EXPERIMENTAL = fqName4;
        FqName fqName5 = COROUTINES_PACKAGE_FQ_NAME_RELEASE.child(Name.identifier("Continuation"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName5, (String)"COROUTINES_PACKAGE_FQ_NA\u2026entifier(\"Continuation\"))");
        CONTINUATION_INTERFACE_FQ_NAME_RELEASE = fqName5;
        RESULT_FQ_NAME = new FqName("kotlin.Result");
        KOTLIN_REFLECT_FQ_NAME = new FqName("kotlin.reflect");
        PREFIXES = kotlin.collections.CollectionsKt.listOf((Object[])new String[]{K_PROPERTY_PREFIX, K_MUTABLE_PROPERTY_PREFIX, K_FUNCTION_PREFIX, K_SUSPEND_FUNCTION_PREFIX});
        Name name3 = Name.identifier("kotlin");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"Name.identifier(\"kotlin\")");
        BUILT_INS_PACKAGE_NAME = name3;
        FqName fqName6 = FqName.topLevel(BUILT_INS_PACKAGE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)fqName6, (String)"FqName.topLevel(BUILT_INS_PACKAGE_NAME)");
        BUILT_INS_PACKAGE_FQ_NAME = fqName6;
        FqName fqName7 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("annotation"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName7, (String)"BUILT_INS_PACKAGE_FQ_NAM\u2026identifier(\"annotation\"))");
        ANNOTATION_PACKAGE_FQ_NAME = fqName7;
        FqName fqName8 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("collections"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName8, (String)"BUILT_INS_PACKAGE_FQ_NAM\u2026dentifier(\"collections\"))");
        COLLECTIONS_PACKAGE_FQ_NAME = fqName8;
        FqName fqName9 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("ranges"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName9, (String)"BUILT_INS_PACKAGE_FQ_NAM\u2026ame.identifier(\"ranges\"))");
        RANGES_PACKAGE_FQ_NAME = fqName9;
        FqName fqName10 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("text"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName10, (String)"BUILT_INS_PACKAGE_FQ_NAM\u2026(Name.identifier(\"text\"))");
        TEXT_PACKAGE_FQ_NAME = fqName10;
        Object[] objectArray = new FqName[7];
        objectArray[0] = BUILT_INS_PACKAGE_FQ_NAME;
        objectArray[1] = COLLECTIONS_PACKAGE_FQ_NAME;
        objectArray[2] = RANGES_PACKAGE_FQ_NAME;
        objectArray[3] = ANNOTATION_PACKAGE_FQ_NAME;
        objectArray[4] = KOTLIN_REFLECT_FQ_NAME;
        FqName fqName11 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("internal"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName11, (String)"BUILT_INS_PACKAGE_FQ_NAM\u2026e.identifier(\"internal\"))");
        objectArray[5] = fqName11;
        objectArray[6] = COROUTINES_PACKAGE_FQ_NAME_RELEASE;
        BUILT_INS_PACKAGE_FQ_NAMES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010Y\u001a\u00020\u000e2\u0006\u0010Z\u001a\u00020[H\u0002J\u0010\u0010\\\u001a\u00020\u000e2\u0006\u0010Z\u001a\u00020[H\u0002J\u0010\u0010]\u001a\u00020\u000e2\u0006\u0010Z\u001a\u00020[H\u0002J\u0010\u0010^\u001a\u00020\u00042\u0006\u0010Z\u001a\u00020[H\u0002J\u0010\u0010_\u001a\u00020\u00042\u0006\u0010Z\u001a\u00020[H\u0002J\u0010\u0010`\u001a\u00020\u00042\u0006\u0010Z\u001a\u00020[H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\u00148\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\u001f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u00020,8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00107\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010:\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010;\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010<\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010>\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010?\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010@\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010A\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020D0C8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020D0C8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010F\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010G\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010H\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010I\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010J\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010K\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010L\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010M\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010N\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010O\u001a\u00020,8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010P\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010Q\u001a\u00020,8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010R\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010S\u001a\u00020,8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010T\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010U\u001a\u00020,8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010V\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010W\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010X\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lorg/jetbrains/kotlin/builtins/StandardNames$FqNames;", "", "()V", "_boolean", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "_byte", "_char", "_double", "_enum", "_float", "_int", "_long", "_short", "annotation", "Lorg/jetbrains/kotlin/name/FqName;", "annotationRetention", "annotationTarget", "any", "array", "arrayClassFqNameToPrimitiveType", "", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "charSequence", "cloneable", "collection", "comparable", "deprecated", "deprecatedSinceKotlin", "deprecationLevel", "extensionFunctionType", "fqNameToPrimitiveType", "", "functionSupertype", "intRange", "iterable", "iterator", "kCallable", "kClass", "kDeclarationContainer", "kMutableProperty0", "kMutableProperty1", "kMutableProperty2", "kMutablePropertyFqName", "kProperty", "Lorg/jetbrains/kotlin/name/ClassId;", "kProperty0", "kProperty1", "kProperty2", "kPropertyFqName", "list", "listIterator", "longRange", "map", "mapEntry", "mustBeDocumented", "mutableCollection", "mutableIterable", "mutableIterator", "mutableList", "mutableListIterator", "mutableMap", "mutableMapEntry", "mutableSet", "nothing", "number", "parameterName", "primitiveArrayTypeShortNames", "", "Lorg/jetbrains/kotlin/name/Name;", "primitiveTypeShortNames", "publishedApi", "repeatable", "replaceWith", "retention", "set", "string", "suppress", "target", "throwable", "uByte", "uByteFqName", "uInt", "uIntFqName", "uLong", "uLongFqName", "uShort", "uShortFqName", "unit", "unsafeVariance", "annotationName", "simpleName", "", "collectionsFqName", "fqName", "fqNameUnsafe", "rangesFqName", "reflect", "compiler.common"})
    public static final class FqNames {
        @JvmField
        @NotNull
        public static final FqNameUnsafe any;
        @JvmField
        @NotNull
        public static final FqNameUnsafe nothing;
        @JvmField
        @NotNull
        public static final FqNameUnsafe cloneable;
        @JvmField
        @NotNull
        public static final FqName suppress;
        @JvmField
        @NotNull
        public static final FqNameUnsafe unit;
        @JvmField
        @NotNull
        public static final FqNameUnsafe charSequence;
        @JvmField
        @NotNull
        public static final FqNameUnsafe string;
        @JvmField
        @NotNull
        public static final FqNameUnsafe array;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _boolean;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _char;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _byte;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _short;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _int;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _long;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _float;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _double;
        @JvmField
        @NotNull
        public static final FqNameUnsafe number;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _enum;
        @JvmField
        @NotNull
        public static final FqNameUnsafe functionSupertype;
        @JvmField
        @NotNull
        public static final FqName throwable;
        @JvmField
        @NotNull
        public static final FqName comparable;
        @JvmField
        @NotNull
        public static final FqNameUnsafe intRange;
        @JvmField
        @NotNull
        public static final FqNameUnsafe longRange;
        @JvmField
        @NotNull
        public static final FqName deprecated;
        @JvmField
        @NotNull
        public static final FqName deprecatedSinceKotlin;
        @JvmField
        @NotNull
        public static final FqName deprecationLevel;
        @JvmField
        @NotNull
        public static final FqName replaceWith;
        @JvmField
        @NotNull
        public static final FqName extensionFunctionType;
        @JvmField
        @NotNull
        public static final FqName parameterName;
        @JvmField
        @NotNull
        public static final FqName annotation;
        @JvmField
        @NotNull
        public static final FqName target;
        @JvmField
        @NotNull
        public static final FqName annotationTarget;
        @JvmField
        @NotNull
        public static final FqName annotationRetention;
        @JvmField
        @NotNull
        public static final FqName retention;
        @JvmField
        @NotNull
        public static final FqName repeatable;
        @JvmField
        @NotNull
        public static final FqName mustBeDocumented;
        @JvmField
        @NotNull
        public static final FqName unsafeVariance;
        @JvmField
        @NotNull
        public static final FqName publishedApi;
        @JvmField
        @NotNull
        public static final FqName iterator;
        @JvmField
        @NotNull
        public static final FqName iterable;
        @JvmField
        @NotNull
        public static final FqName collection;
        @JvmField
        @NotNull
        public static final FqName list;
        @JvmField
        @NotNull
        public static final FqName listIterator;
        @JvmField
        @NotNull
        public static final FqName set;
        @JvmField
        @NotNull
        public static final FqName map;
        @JvmField
        @NotNull
        public static final FqName mapEntry;
        @JvmField
        @NotNull
        public static final FqName mutableIterator;
        @JvmField
        @NotNull
        public static final FqName mutableIterable;
        @JvmField
        @NotNull
        public static final FqName mutableCollection;
        @JvmField
        @NotNull
        public static final FqName mutableList;
        @JvmField
        @NotNull
        public static final FqName mutableListIterator;
        @JvmField
        @NotNull
        public static final FqName mutableSet;
        @JvmField
        @NotNull
        public static final FqName mutableMap;
        @JvmField
        @NotNull
        public static final FqName mutableMapEntry;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kClass;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kCallable;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kProperty0;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kProperty1;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kProperty2;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kMutableProperty0;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kMutableProperty1;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kMutableProperty2;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kPropertyFqName;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kMutablePropertyFqName;
        @JvmField
        @NotNull
        public static final ClassId kProperty;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kDeclarationContainer;
        @JvmField
        @NotNull
        public static final FqName uByteFqName;
        @JvmField
        @NotNull
        public static final FqName uShortFqName;
        @JvmField
        @NotNull
        public static final FqName uIntFqName;
        @JvmField
        @NotNull
        public static final FqName uLongFqName;
        @JvmField
        @NotNull
        public static final ClassId uByte;
        @JvmField
        @NotNull
        public static final ClassId uShort;
        @JvmField
        @NotNull
        public static final ClassId uInt;
        @JvmField
        @NotNull
        public static final ClassId uLong;
        @JvmField
        @NotNull
        public static final Set<Name> primitiveTypeShortNames;
        @JvmField
        @NotNull
        public static final Set<Name> primitiveArrayTypeShortNames;
        @JvmField
        @NotNull
        public static final Map<FqNameUnsafe, PrimitiveType> fqNameToPrimitiveType;
        @JvmField
        @NotNull
        public static final Map<FqNameUnsafe, PrimitiveType> arrayClassFqNameToPrimitiveType;
        @NotNull
        public static final FqNames INSTANCE;

        private final FqNameUnsafe fqNameUnsafe(String simpleName) {
            FqNameUnsafe fqNameUnsafe = this.fqName(simpleName).toUnsafe();
            Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"fqName(simpleName).toUnsafe()");
            return fqNameUnsafe;
        }

        private final FqName fqName(String simpleName) {
            FqName fqName2 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier(simpleName));
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"BUILT_INS_PACKAGE_FQ_NAM\u2026e.identifier(simpleName))");
            return fqName2;
        }

        private final FqName collectionsFqName(String simpleName) {
            FqName fqName2 = COLLECTIONS_PACKAGE_FQ_NAME.child(Name.identifier(simpleName));
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"COLLECTIONS_PACKAGE_FQ_N\u2026e.identifier(simpleName))");
            return fqName2;
        }

        private final FqNameUnsafe rangesFqName(String simpleName) {
            FqNameUnsafe fqNameUnsafe = RANGES_PACKAGE_FQ_NAME.child(Name.identifier(simpleName)).toUnsafe();
            Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"RANGES_PACKAGE_FQ_NAME.c\u2026r(simpleName)).toUnsafe()");
            return fqNameUnsafe;
        }

        @JvmStatic
        @NotNull
        public static final FqNameUnsafe reflect(@NotNull String simpleName) {
            Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
            FqNameUnsafe fqNameUnsafe = KOTLIN_REFLECT_FQ_NAME.child(Name.identifier(simpleName)).toUnsafe();
            Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"KOTLIN_REFLECT_FQ_NAME.c\u2026r(simpleName)).toUnsafe()");
            return fqNameUnsafe;
        }

        private final FqName annotationName(String simpleName) {
            FqName fqName2 = ANNOTATION_PACKAGE_FQ_NAME.child(Name.identifier(simpleName));
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"ANNOTATION_PACKAGE_FQ_NA\u2026e.identifier(simpleName))");
            return fqName2;
        }

        private FqNames() {
        }

        static {
            Name name;
            PrimitiveType it;
            Collection collection;
            PrimitiveType item$iv;
            int n;
            FqNames fqNames;
            INSTANCE = fqNames = new FqNames();
            any = fqNames.fqNameUnsafe("Any");
            nothing = fqNames.fqNameUnsafe("Nothing");
            cloneable = fqNames.fqNameUnsafe("Cloneable");
            suppress = fqNames.fqName("Suppress");
            unit = fqNames.fqNameUnsafe("Unit");
            charSequence = fqNames.fqNameUnsafe("CharSequence");
            string = fqNames.fqNameUnsafe("String");
            array = fqNames.fqNameUnsafe("Array");
            _boolean = fqNames.fqNameUnsafe("Boolean");
            _char = fqNames.fqNameUnsafe("Char");
            _byte = fqNames.fqNameUnsafe("Byte");
            _short = fqNames.fqNameUnsafe("Short");
            _int = fqNames.fqNameUnsafe("Int");
            _long = fqNames.fqNameUnsafe("Long");
            _float = fqNames.fqNameUnsafe("Float");
            _double = fqNames.fqNameUnsafe("Double");
            number = fqNames.fqNameUnsafe("Number");
            _enum = fqNames.fqNameUnsafe("Enum");
            functionSupertype = fqNames.fqNameUnsafe("Function");
            throwable = fqNames.fqName("Throwable");
            comparable = fqNames.fqName("Comparable");
            intRange = fqNames.rangesFqName("IntRange");
            longRange = fqNames.rangesFqName("LongRange");
            deprecated = fqNames.fqName("Deprecated");
            deprecatedSinceKotlin = fqNames.fqName("DeprecatedSinceKotlin");
            deprecationLevel = fqNames.fqName("DeprecationLevel");
            replaceWith = fqNames.fqName("ReplaceWith");
            extensionFunctionType = fqNames.fqName("ExtensionFunctionType");
            parameterName = fqNames.fqName("ParameterName");
            annotation = fqNames.fqName("Annotation");
            target = fqNames.annotationName("Target");
            annotationTarget = fqNames.annotationName("AnnotationTarget");
            annotationRetention = fqNames.annotationName("AnnotationRetention");
            retention = fqNames.annotationName("Retention");
            repeatable = fqNames.annotationName("Repeatable");
            mustBeDocumented = fqNames.annotationName("MustBeDocumented");
            unsafeVariance = fqNames.fqName("UnsafeVariance");
            publishedApi = fqNames.fqName("PublishedApi");
            iterator = fqNames.collectionsFqName("Iterator");
            iterable = fqNames.collectionsFqName("Iterable");
            FqNames.collection = fqNames.collectionsFqName("Collection");
            list = fqNames.collectionsFqName("List");
            listIterator = fqNames.collectionsFqName("ListIterator");
            set = fqNames.collectionsFqName("Set");
            map = fqNames.collectionsFqName("Map");
            FqName fqName2 = map.child(Name.identifier("Entry"));
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"map.child(Name.identifier(\"Entry\"))");
            mapEntry = fqName2;
            mutableIterator = fqNames.collectionsFqName("MutableIterator");
            mutableIterable = fqNames.collectionsFqName("MutableIterable");
            mutableCollection = fqNames.collectionsFqName("MutableCollection");
            mutableList = fqNames.collectionsFqName("MutableList");
            mutableListIterator = fqNames.collectionsFqName("MutableListIterator");
            mutableSet = fqNames.collectionsFqName("MutableSet");
            mutableMap = fqNames.collectionsFqName("MutableMap");
            FqName fqName3 = mutableMap.child(Name.identifier("MutableEntry"));
            Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"mutableMap.child(Name.identifier(\"MutableEntry\"))");
            mutableMapEntry = fqName3;
            kClass = FqNames.reflect("KClass");
            kCallable = FqNames.reflect("KCallable");
            kProperty0 = FqNames.reflect("KProperty0");
            kProperty1 = FqNames.reflect("KProperty1");
            kProperty2 = FqNames.reflect("KProperty2");
            kMutableProperty0 = FqNames.reflect("KMutableProperty0");
            kMutableProperty1 = FqNames.reflect("KMutableProperty1");
            kMutableProperty2 = FqNames.reflect("KMutableProperty2");
            kPropertyFqName = FqNames.reflect(StandardNames.K_PROPERTY_PREFIX);
            kMutablePropertyFqName = FqNames.reflect(StandardNames.K_MUTABLE_PROPERTY_PREFIX);
            ClassId classId = ClassId.topLevel(kPropertyFqName.toSafe());
            Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"ClassId.topLevel(kPropertyFqName.toSafe())");
            kProperty = classId;
            kDeclarationContainer = FqNames.reflect("KDeclarationContainer");
            uByteFqName = fqNames.fqName("UByte");
            uShortFqName = fqNames.fqName("UShort");
            uIntFqName = fqNames.fqName("UInt");
            uLongFqName = fqNames.fqName("ULong");
            ClassId classId2 = ClassId.topLevel(uByteFqName);
            Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"ClassId.topLevel(uByteFqName)");
            uByte = classId2;
            ClassId classId3 = ClassId.topLevel(uShortFqName);
            Intrinsics.checkNotNullExpressionValue((Object)classId3, (String)"ClassId.topLevel(uShortFqName)");
            uShort = classId3;
            ClassId classId4 = ClassId.topLevel(uIntFqName);
            Intrinsics.checkNotNullExpressionValue((Object)classId4, (String)"ClassId.topLevel(uIntFqName)");
            uInt = classId4;
            ClassId classId5 = ClassId.topLevel(uLongFqName);
            Intrinsics.checkNotNullExpressionValue((Object)classId5, (String)"ClassId.topLevel(uLongFqName)");
            uLong = classId5;
            Cloneable cloneable2 = CollectionsKt.newHashSetWithExpectedSize(PrimitiveType.values().length);
            boolean bl = false;
            boolean bl2 = false;
            HashSet $this$apply = cloneable2;
            boolean bl3 = false;
            PrimitiveType[] $this$mapTo$iv = PrimitiveType.values();
            boolean $i$f$mapTo = false;
            PrimitiveType[] primitiveTypeArray = $this$mapTo$iv;
            int n2 = primitiveTypeArray.length;
            for (n = 0; n < n2; ++n) {
                PrimitiveType primitiveType = item$iv = primitiveTypeArray[n];
                collection = $this$apply;
                boolean bl4 = false;
                name = it.getTypeName();
                collection.add(name);
            }
            primitiveTypeShortNames = cloneable2;
            cloneable2 = CollectionsKt.newHashSetWithExpectedSize(PrimitiveType.values().length);
            bl = false;
            bl2 = false;
            $this$apply = cloneable2;
            boolean bl5 = false;
            $this$mapTo$iv = PrimitiveType.values();
            $i$f$mapTo = false;
            primitiveTypeArray = $this$mapTo$iv;
            n2 = primitiveTypeArray.length;
            for (n = 0; n < n2; ++n) {
                it = item$iv = primitiveTypeArray[n];
                collection = $this$apply;
                boolean bl6 = false;
                name = it.getArrayTypeName();
                collection.add(name);
            }
            primitiveArrayTypeShortNames = cloneable2;
            cloneable2 = CollectionsKt.newHashMapWithExpectedSize(PrimitiveType.values().length);
            bl = false;
            bl2 = false;
            $this$apply = cloneable2;
            boolean bl7 = false;
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                Map map2 = (Map)((Object)$this$apply);
                String string2 = primitiveType.getTypeName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"primitiveType.typeName.asString()");
                map2.put(INSTANCE.fqNameUnsafe(string2), primitiveType);
            }
            fqNameToPrimitiveType = (Map)((Object)cloneable2);
            cloneable2 = CollectionsKt.newHashMapWithExpectedSize(PrimitiveType.values().length);
            bl = false;
            bl2 = false;
            $this$apply = cloneable2;
            boolean bl8 = false;
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                Map map3 = (Map)((Object)$this$apply);
                String string3 = primitiveType.getArrayTypeName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"primitiveType.arrayTypeName.asString()");
                map3.put(INSTANCE.fqNameUnsafe(string3), primitiveType);
            }
            arrayClassFqNameToPrimitiveType = (Map)((Object)cloneable2);
        }
    }
}

