/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.util.ConcurrencyUtil;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AttributesFlyweight {
    private static final ConcurrentMap<FlyweightKey, AttributesFlyweight> entries = new ConcurrentHashMap<FlyweightKey, AttributesFlyweight>();
    private static final ThreadLocal<FlyweightKey> ourKey = new ThreadLocal();
    private final int myHashCode;
    private final Color myForeground;
    private final Color myBackground;
    @JdkConstants.FontStyle
    private final int myFontType;
    private final Color myEffectColor;
    private final EffectType myEffectType;
    @NotNull
    private final Map<EffectType, Color> myAdditionalEffects;
    private final Color myErrorStripeColor;

    @ApiStatus.Experimental
    @NotNull
    public static AttributesFlyweight create(Color foreground, Color background, @JdkConstants.FontStyle int fontType, Color effectColor, EffectType effectType, @NotNull Map<EffectType, Color> additionalEffects, Color errorStripeColor) {
        FlyweightKey key;
        if (additionalEffects == null) {
            AttributesFlyweight.$$$reportNull$$$0(0);
        }
        if ((key = ourKey.get()) == null) {
            key = new FlyweightKey();
            ourKey.set(key);
        }
        key.foreground = foreground;
        key.background = background;
        key.fontType = fontType;
        key.effectColor = effectColor;
        key.effectType = effectType;
        key.myAdditionalEffects = additionalEffects.isEmpty() ? Collections.emptyMap() : new HashMap<EffectType, Color>(additionalEffects);
        key.errorStripeColor = errorStripeColor;
        AttributesFlyweight flyweight = (AttributesFlyweight)entries.get(key);
        if (flyweight != null) {
            AttributesFlyweight attributesFlyweight = flyweight;
            if (attributesFlyweight == null) {
                AttributesFlyweight.$$$reportNull$$$0(1);
            }
            return attributesFlyweight;
        }
        AttributesFlyweight attributesFlyweight = ConcurrencyUtil.cacheOrGet(entries, key.clone(), new AttributesFlyweight(key));
        if (attributesFlyweight == null) {
            AttributesFlyweight.$$$reportNull$$$0(2);
        }
        return attributesFlyweight;
    }

    private AttributesFlyweight(@NotNull FlyweightKey key) {
        if (key == null) {
            AttributesFlyweight.$$$reportNull$$$0(3);
        }
        this.myForeground = key.foreground;
        this.myBackground = key.background;
        this.myFontType = key.fontType;
        this.myEffectColor = key.effectColor;
        this.myEffectType = key.effectType;
        this.myErrorStripeColor = key.errorStripeColor;
        this.myAdditionalEffects = key.myAdditionalEffects;
        this.myHashCode = key.hashCode();
    }

    public Color getForeground() {
        return this.myForeground;
    }

    public Color getBackground() {
        return this.myBackground;
    }

    @JdkConstants.FontStyle
    public int getFontType() {
        return this.myFontType;
    }

    public Color getEffectColor() {
        return this.myEffectColor;
    }

    public EffectType getEffectType() {
        return this.myEffectType;
    }

    @NotNull
    Map<EffectType, Color> getAdditionalEffects() {
        Map<EffectType, Color> map2 = this.myAdditionalEffects;
        if (map2 == null) {
            AttributesFlyweight.$$$reportNull$$$0(6);
        }
        return map2;
    }

    public Color getErrorStripeColor() {
        return this.myErrorStripeColor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributesFlyweight that = (AttributesFlyweight)o;
        if (this.myFontType != that.myFontType) {
            return false;
        }
        if (!Objects.equals(this.myBackground, that.myBackground)) {
            return false;
        }
        if (!Objects.equals(this.myEffectColor, that.myEffectColor)) {
            return false;
        }
        if (this.myEffectType != that.myEffectType) {
            return false;
        }
        if (!Objects.equals(this.myErrorStripeColor, that.myErrorStripeColor)) {
            return false;
        }
        if (!Objects.equals(this.myForeground, that.myForeground)) {
            return false;
        }
        return this.myAdditionalEffects.equals(that.myAdditionalEffects);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    @NonNls
    public String toString() {
        return "AttributesFlyweight{myForeground=" + this.myForeground + ", myBackground=" + this.myBackground + ", myFontType=" + this.myFontType + ", myEffectColor=" + this.myEffectColor + ", myEffectType=" + (Object)((Object)this.myEffectType) + ", myErrorStripeColor=" + this.myErrorStripeColor + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalEffects";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/markup/AttributesFlyweight";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/markup/AttributesFlyweight";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalEffects";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEffects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "withAdditionalEffects";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FlyweightKey
    implements Cloneable {
        private Color foreground;
        private Color background;
        @JdkConstants.FontStyle
        private int fontType;
        private Color effectColor;
        private EffectType effectType;
        private Color errorStripeColor;
        @NotNull
        private Map<EffectType, Color> myAdditionalEffects = Collections.emptyMap();

        private FlyweightKey() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FlyweightKey)) {
                return false;
            }
            FlyweightKey key = (FlyweightKey)o;
            if (this.fontType != key.fontType) {
                return false;
            }
            if (!Objects.equals(this.background, key.background)) {
                return false;
            }
            if (!Objects.equals(this.effectColor, key.effectColor)) {
                return false;
            }
            if (this.effectType != key.effectType) {
                return false;
            }
            if (!Objects.equals(this.errorStripeColor, key.errorStripeColor)) {
                return false;
            }
            if (!Objects.equals(this.foreground, key.foreground)) {
                return false;
            }
            return this.myAdditionalEffects.equals(key.myAdditionalEffects);
        }

        public int hashCode() {
            int result2 = this.foreground != null ? this.foreground.hashCode() : 0;
            result2 = 31 * result2 + (this.background != null ? this.background.hashCode() : 0);
            result2 = 31 * result2 + this.fontType;
            result2 = 31 * result2 + (this.effectColor != null ? this.effectColor.hashCode() : 0);
            result2 = 31 * result2 + (this.effectType != null ? this.effectType.hashCode() : 0);
            result2 = 31 * result2 + (this.errorStripeColor != null ? this.errorStripeColor.hashCode() : 0);
            result2 = 31 * result2 + this.myAdditionalEffects.hashCode();
            return result2;
        }

        protected FlyweightKey clone() {
            try {
                return (FlyweightKey)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

