/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTreeUtil {
    private static final Logger LOG = Logger.getInstance(PsiTreeUtil.class);
    private static final Key<Object> MARKER = Key.create("PsiTreeUtil.copyElements.MARKER");
    private static final Class<? extends PsiElement>[] WS = new Class[]{PsiWhiteSpace.class};
    private static final Class<? extends PsiElement>[] WS_COMMENTS = new Class[]{PsiWhiteSpace.class, PsiComment.class};

    @Contract(value="null, _, _ -> false")
    public static boolean isAncestor(@Nullable PsiElement ancestor, @NotNull PsiElement element, boolean strict) {
        PsiElement parent2;
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(0);
        }
        if (ancestor == null) {
            return false;
        }
        if ((ancestor instanceof StubBasedPsiElement && ((StubBasedPsiElement)ancestor).getStub() != null || element instanceof StubBasedPsiElement && ((StubBasedPsiElement)element).getStub() != null) && ancestor.getContainingFile() != element.getContainingFile()) {
            return false;
        }
        boolean stopAtFileLevel = !(ancestor instanceof PsiFile) && !(ancestor instanceof PsiDirectory);
        PsiElement psiElement = parent2 = strict ? element.getParent() : element;
        while (parent2 != null) {
            if (parent2.equals(ancestor)) {
                return true;
            }
            if (stopAtFileLevel && parent2 instanceof PsiFile) {
                return false;
            }
            parent2 = parent2.getParent();
        }
        return false;
    }

    @Contract(value="null, _, _ -> false")
    public static boolean isContextAncestor(@Nullable PsiElement ancestor, @NotNull PsiElement element, boolean strict) {
        PsiElement parent2;
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(1);
        }
        if (ancestor == null) {
            return false;
        }
        boolean stopAtFileLevel = !(ancestor instanceof PsiFile) && !(ancestor instanceof PsiDirectory);
        PsiElement psiElement = parent2 = strict ? element.getContext() : element;
        while (parent2 != null) {
            PsiElement context2;
            if (parent2.equals(ancestor)) {
                return true;
            }
            if (stopAtFileLevel && parent2 instanceof PsiFile && (context2 = parent2.getContext()) == null) {
                return false;
            }
            parent2 = parent2.getContext();
        }
        return false;
    }

    @Nullable
    public static PsiElement findCommonParent(@NotNull List<? extends PsiElement> elements) {
        if (elements == null) {
            PsiTreeUtil.$$$reportNull$$$0(2);
        }
        if (elements.isEmpty()) {
            return null;
        }
        PsiElement toReturn = null;
        for (PsiElement psiElement : elements) {
            if (psiElement == null || (toReturn = toReturn == null ? psiElement : PsiTreeUtil.findCommonParent(toReturn, psiElement)) != null) continue;
            return null;
        }
        return toReturn;
    }

    @Nullable
    public static PsiElement findCommonParent(PsiElement ... elements) {
        if (elements == null) {
            PsiTreeUtil.$$$reportNull$$$0(3);
        }
        if (elements.length == 0) {
            return null;
        }
        PsiElement toReturn = null;
        for (PsiElement element : elements) {
            if (element == null) continue;
            PsiElement psiElement = toReturn = toReturn == null ? element : PsiTreeUtil.findCommonParent(toReturn, element);
            if (toReturn != null) continue;
            return null;
        }
        return toReturn;
    }

    @Nullable
    public static PsiElement findCommonParent(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        int depth1;
        PsiFile file2;
        if (element1 == null) {
            PsiTreeUtil.$$$reportNull$$$0(4);
        }
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(5);
        }
        if (element1 == element2) {
            return element1;
        }
        PsiFile file1 = element1.getContainingFile();
        PsiFile topLevel = file1 == (file2 = element2.getContainingFile()) ? file1 : null;
        int depth2 = PsiTreeUtil.getDepth(element2, topLevel);
        PsiElement parent1 = element1;
        PsiElement parent2 = element2;
        for (depth1 = PsiTreeUtil.getDepth(element1, topLevel); depth1 > depth2; --depth1) {
            parent1 = parent1.getParent();
        }
        while (depth2 > depth1) {
            parent2 = parent2.getParent();
            --depth2;
        }
        while (parent1 != null && parent2 != null && !parent1.equals(parent2)) {
            parent1 = parent1.getParent();
            parent2 = parent2.getParent();
        }
        return parent1;
    }

    @Contract(pure=true)
    public static int getDepth(@NotNull PsiElement element, @Nullable PsiElement topLevel) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(6);
        }
        int depth = 0;
        for (PsiElement parent2 = element; parent2 != topLevel && parent2 != null; parent2 = parent2.getParent()) {
            ++depth;
        }
        return depth;
    }

    @Nullable
    public static PsiElement findCommonContext(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            PsiTreeUtil.$$$reportNull$$$0(7);
        }
        if (elements.isEmpty()) {
            return null;
        }
        PsiElement toReturn = null;
        for (PsiElement psiElement : elements) {
            if (psiElement == null || (toReturn = toReturn == null ? psiElement : PsiTreeUtil.findCommonContext(toReturn, psiElement)) != null) continue;
            return null;
        }
        return toReturn;
    }

    @Nullable
    public static PsiElement findCommonContext(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiElement parent1;
        if (element1 == null) {
            PsiTreeUtil.$$$reportNull$$$0(8);
        }
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(9);
        }
        if (element1 == element2) {
            return element1;
        }
        PsiFile containingFile = element1.getContainingFile();
        PsiFile topLevel = containingFile == element2.getContainingFile() ? containingFile : null;
        int depth1 = PsiTreeUtil.getContextDepth(element1, topLevel);
        int depth2 = PsiTreeUtil.getContextDepth(element2, topLevel);
        PsiElement parent2 = element2;
        for (parent1 = element1; depth1 > depth2 && parent1 != null; parent1 = parent1.getContext(), --depth1) {
        }
        while (depth2 > depth1 && parent2 != null) {
            parent2 = parent2.getContext();
            --depth2;
        }
        while (parent1 != null && parent2 != null && !parent1.equals(parent2)) {
            parent1 = parent1.getContext();
            parent2 = parent2.getContext();
        }
        return parent1;
    }

    private static int getContextDepth(@NotNull PsiElement element, @Nullable PsiElement topLevel) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(10);
        }
        int depth = 0;
        for (PsiElement parent2 = element; parent2 != topLevel && parent2 != null; parent2 = parent2.getContext()) {
            ++depth;
        }
        return depth;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T findChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(11);
        }
        return PsiTreeUtil.findChildOfType(element, aClass2, true, null);
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T findChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2, boolean strict) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(12);
        }
        return PsiTreeUtil.findChildOfType(element, aClass2, strict, null);
    }

    @Nullable
    @Contract(value="null, _, _, _ -> null")
    public static <T extends PsiElement> T findChildOfType(final @Nullable PsiElement element, final @NotNull Class<T> aClass2, final boolean strict, final @Nullable Class<? extends PsiElement> stopAt) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(13);
        }
        if (element == null) {
            return null;
        }
        PsiElementProcessor.FindElement<PsiElement> processor2 = new PsiElementProcessor.FindElement<PsiElement>(){

            @Override
            public boolean execute(@NotNull PsiElement each) {
                if (each == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (strict && each == element) {
                    return true;
                }
                if (aClass2.isInstance(each)) {
                    return this.setFound(each);
                }
                return stopAt == null || !stopAt.isInstance(each);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/psi/util/PsiTreeUtil$1", "execute"));
            }
        };
        PsiTreeUtil.processElements(element, processor2);
        return (T)((PsiElement)aClass2.cast(processor2.getFoundElement()));
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T findChildOfAnyType(@Nullable PsiElement element, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(14);
        }
        return PsiTreeUtil.findChildOfAnyType(element, true, classes2);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T findChildOfAnyType(final @Nullable PsiElement element, final boolean strict, final Class<? extends T> ... classes2) {
        if (classes2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(15);
        }
        if (element == null) {
            return null;
        }
        PsiElementProcessor.FindElement<PsiElement> processor2 = new PsiElementProcessor.FindElement<PsiElement>(){

            @Override
            public boolean execute(@NotNull PsiElement each) {
                if (each == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (strict && each == element) {
                    return true;
                }
                if (PsiTreeUtil.instanceOf(each, classes2)) {
                    return this.setFound(each);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/psi/util/PsiTreeUtil$2", "execute"));
            }
        };
        PsiTreeUtil.processElements(element, processor2);
        Object t = processor2.getFoundElement();
        return t;
    }

    @NotNull
    public static <T extends PsiElement> Collection<T> findChildrenOfType(@Nullable PsiElement element, @NotNull Class<? extends T> aClass2) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(16);
        }
        return PsiTreeUtil.findChildrenOfAnyType(element, true, aClass2);
    }

    @SafeVarargs
    @NotNull
    public static <T extends PsiElement> Collection<T> findChildrenOfAnyType(@Nullable PsiElement element, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(17);
        }
        return PsiTreeUtil.findChildrenOfAnyType(element, true, classes2);
    }

    @SafeVarargs
    @NotNull
    public static <T extends PsiElement> Collection<T> findChildrenOfAnyType(final @Nullable PsiElement element, final boolean strict, final Class<? extends T> ... classes2) {
        if (classes2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(18);
        }
        if (element == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                PsiTreeUtil.$$$reportNull$$$0(19);
            }
            return list2;
        }
        PsiElementProcessor.CollectElements processor2 = new PsiElementProcessor.CollectElements<T>(){

            @Override
            public boolean execute(@NotNull T each) {
                if (each == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (strict && each == element) {
                    return true;
                }
                if (PsiTreeUtil.instanceOf(each, classes2)) {
                    return super.execute(each);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/psi/util/PsiTreeUtil$3", "execute"));
            }
        };
        PsiTreeUtil.processElements(element, processor2);
        Collection collection = processor2.getCollection();
        if (collection == null) {
            PsiTreeUtil.$$$reportNull$$$0(20);
        }
        return collection;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(21);
        }
        if (element == null) {
            return null;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass2.isInstance(child)) continue;
            return (T)((PsiElement)aClass2.cast(child));
        }
        return null;
    }

    @Nullable
    public static PsiElement findFirstParent(@Nullable PsiElement element, Condition<? super PsiElement> condition) {
        return PsiTreeUtil.findFirstParent(element, false, condition);
    }

    @Nullable
    public static PsiElement findFirstParent(@Nullable PsiElement element, boolean strict, Condition<? super PsiElement> condition) {
        if (strict && element != null) {
            element = element.getParent();
        }
        while (element != null) {
            if (condition.value(element)) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiElement findFirstContext(@Nullable PsiElement element, boolean strict, Condition<? super PsiElement> condition) {
        if (strict && element != null) {
            element = element.getContext();
        }
        while (element != null) {
            if (condition.value(element)) {
                return element;
            }
            element = element.getContext();
        }
        return null;
    }

    @NotNull
    public static <T extends PsiElement> T getRequiredChildOfType(@NotNull PsiElement element, @NotNull Class<T> aClass2) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(22);
        }
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(23);
        }
        T child = PsiTreeUtil.getChildOfType(element, aClass2);
        assert (child != null) : "Missing required child of type " + aClass2.getName();
        T t = child;
        if (t == null) {
            PsiTreeUtil.$$$reportNull$$$0(24);
        }
        return t;
    }

    public static int countChildrenOfType(@NotNull PsiElement element, @NotNull Class<? extends PsiElement> clazz) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(25);
        }
        if (clazz == null) {
            PsiTreeUtil.$$$reportNull$$$0(26);
        }
        int result2 = 0;
        for (PsiElement cur = element.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!clazz.isInstance(cur)) continue;
            ++result2;
        }
        return result2;
    }

    public static <T extends PsiElement> T @Nullable [] getChildrenOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(27);
        }
        if (element == null) {
            return null;
        }
        List<T> result2 = PsiTreeUtil.getChildrenOfTypeAsList(element, aClass2);
        return result2.isEmpty() ? null : (PsiElement[])ArrayUtil.toObjectArray(result2, aClass2);
    }

    @SafeVarargs
    @NotNull
    public static <T extends PsiElement> List<T> getChildrenOfAnyType(@Nullable PsiElement element, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(28);
        }
        if (element == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                PsiTreeUtil.$$$reportNull$$$0(29);
            }
            return list2;
        }
        SmartList<PsiElement> result2 = null;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!PsiTreeUtil.instanceOf(child, classes2)) continue;
            if (result2 == null) {
                result2 = new SmartList<PsiElement>();
            }
            PsiElement t = child;
            result2.add(t);
        }
        if (result2 == null) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                PsiTreeUtil.$$$reportNull$$$0(30);
            }
            return list3;
        }
        SmartList<PsiElement> smartList = result2;
        if (smartList == null) {
            PsiTreeUtil.$$$reportNull$$$0(31);
        }
        return smartList;
    }

    @NotNull
    public static <T extends PsiElement> List<T> getChildrenOfTypeAsList(@Nullable PsiElement element, @NotNull Class<? extends T> aClass2) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(32);
        }
        if (element == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                PsiTreeUtil.$$$reportNull$$$0(33);
            }
            return list2;
        }
        SmartList<T> result2 = null;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass2.isInstance(child)) continue;
            if (result2 == null) {
                result2 = new SmartList<T>();
            }
            result2.add(aClass2.cast(child));
        }
        List list3 = result2 == null ? Collections.emptyList() : result2;
        if (list3 == null) {
            PsiTreeUtil.$$$reportNull$$$0(34);
        }
        return list3;
    }

    @NotNull
    public static List<PsiElement> getElementsOfRange(@NotNull PsiElement start, @NotNull PsiElement end) {
        if (start == null) {
            PsiTreeUtil.$$$reportNull$$$0(35);
        }
        if (end == null) {
            PsiTreeUtil.$$$reportNull$$$0(36);
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement e = start; e != end; e = e.getNextSibling()) {
            if (e == null) {
                throw new IllegalArgumentException("Invalid range: " + start + ".." + end);
            }
            result2.add(e);
        }
        result2.add(end);
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            PsiTreeUtil.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    @Nullable
    public static <T extends PsiElement> T getStubChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        StubElement stub;
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(38);
        }
        if (element == null) {
            return null;
        }
        StubElement stubElement = stub = element instanceof StubBasedPsiElement ? (StubElement)((StubBasedPsiElement)element).getStub() : null;
        if (stub == null) {
            return PsiTreeUtil.getChildOfType(element, aClass2);
        }
        for (StubElement childStub : stub.getChildrenStubs()) {
            Object child = childStub.getPsi();
            if (!aClass2.isInstance(child)) continue;
            return (T)((PsiElement)aClass2.cast(child));
        }
        return null;
    }

    @NotNull
    public static <T extends PsiElement> List<T> getStubChildrenOfTypeAsList(@Nullable PsiElement element, @NotNull Class<? extends T> aClass2) {
        StubElement stub;
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(39);
        }
        if (element == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                PsiTreeUtil.$$$reportNull$$$0(40);
            }
            return list2;
        }
        StubElement stubElement = stub = element instanceof StubBasedPsiElement ? (StubElement)((StubBasedPsiElement)element).getStub() : null;
        if (stub == null) {
            return PsiTreeUtil.getChildrenOfTypeAsList(element, aClass2);
        }
        SmartList<T> result2 = new SmartList<T>();
        for (StubElement childStub : stub.getChildrenStubs()) {
            Object child = childStub.getPsi();
            if (!aClass2.isInstance(child)) continue;
            result2.add(aClass2.cast(child));
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            PsiTreeUtil.$$$reportNull$$$0(41);
        }
        return smartList;
    }

    public static boolean instanceOf(Object object, Class<?> ... classes2) {
        if (object != null && classes2 != null) {
            for (Class<?> c : classes2) {
                if (!c.isInstance(object)) continue;
                return true;
            }
        }
        return false;
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getChildOfAnyType(@Nullable PsiElement element, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(42);
        }
        if (element == null) {
            return null;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            for (Class<T> clazz : classes2) {
                if (!clazz.isInstance(child)) continue;
                return (T)((PsiElement)clazz.cast(child));
            }
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getNextSiblingOfType(@Nullable PsiElement sibling, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(43);
        }
        if (sibling == null) {
            return null;
        }
        for (PsiElement child = sibling.getNextSibling(); child != null; child = child.getNextSibling()) {
            if (!aClass2.isInstance(child)) continue;
            return (T)((PsiElement)aClass2.cast(child));
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getPrevSiblingOfType(@Nullable PsiElement sibling, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(44);
        }
        if (sibling == null) {
            return null;
        }
        for (PsiElement child = sibling.getPrevSibling(); child != null; child = child.getPrevSibling()) {
            if (!aClass2.isInstance(child)) continue;
            return (T)((PsiElement)aClass2.cast(child));
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getTopmostParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        T next;
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(45);
        }
        T answer = PsiTreeUtil.getParentOfType(element, aClass2);
        while ((next = PsiTreeUtil.getParentOfType(answer, aClass2)) != null) {
            answer = next;
        }
        return answer;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(46);
        }
        return PsiTreeUtil.getParentOfType(element, aClass2, true);
    }

    @Nullable
    @Contract(value="null -> null")
    public static PsiElement getStubOrPsiParent(@Nullable PsiElement element) {
        Object stub;
        if (element instanceof StubBasedPsiElement && (stub = ((StubBasedPsiElement)element).getStub()) != null) {
            StubElement parentStub = stub.getParentStub();
            return parentStub != null ? (PsiElement)parentStub.getPsi() : null;
        }
        return element != null ? element.getParent() : null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <E extends PsiElement> E getStubOrPsiParentOfType(@Nullable PsiElement element, @NotNull Class<E> parentClass) {
        Object stub;
        if (parentClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(47);
        }
        if (element instanceof StubBasedPsiElement && (stub = ((StubBasedPsiElement)element).getStub()) != null) {
            return stub.getParentStubOfType(parentClass);
        }
        return PsiTreeUtil.getParentOfType(element, parentClass);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _, _, _ -> null")
    public static <T extends PsiElement> T getContextOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2, boolean strict, Class<? extends PsiElement> ... stopAt) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(48);
        }
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getContext();
        }
        while (element != null && !aClass2.isInstance(element)) {
            if (PsiTreeUtil.instanceOf(element, stopAt)) {
                return null;
            }
            element = element.getContext();
        }
        return (T)((PsiElement)aClass2.cast(element));
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T getContextOfType(@Nullable PsiElement element, @NotNull Class<? extends T> aClass2, boolean strict) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(49);
        }
        return PsiTreeUtil.getContextOfType(element, strict, aClass2);
    }

    @SafeVarargs
    @Nullable
    public static <T extends PsiElement> T getContextOfType(@Nullable PsiElement element, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(50);
        }
        return PsiTreeUtil.getContextOfType(element, true, classes2);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T getContextOfType(@Nullable PsiElement element, boolean strict, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(51);
        }
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getContext();
        }
        while (element != null && !PsiTreeUtil.instanceOf(element, classes2)) {
            element = element.getContext();
        }
        PsiElement t = element;
        return (T)t;
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2, boolean strict) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(52);
        }
        return PsiTreeUtil.getParentOfType(element, aClass2, strict, -1);
    }

    @Contract(value="null, _, _, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2, boolean strict, int minStartOffset) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(53);
        }
        if (element == null) {
            return null;
        }
        if (strict) {
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        while (element != null && (minStartOffset == -1 || element.getNode().getStartOffset() >= minStartOffset)) {
            if (aClass2.isInstance(element)) {
                return (T)((PsiElement)aClass2.cast(element));
            }
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _, _, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2, boolean strict, Class<? extends PsiElement> ... stopAt) {
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(54);
        }
        if (stopAt == null) {
            PsiTreeUtil.$$$reportNull$$$0(55);
        }
        if (element == null) {
            return null;
        }
        if (strict) {
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        while (element != null && !aClass2.isInstance(element)) {
            if (PsiTreeUtil.instanceOf(element, stopAt)) {
                return null;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        return (T)((PsiElement)aClass2.cast(element));
    }

    @NotNull
    public static <T extends PsiElement> List<T> collectParents(@NotNull PsiElement element, @NotNull Class<? extends T> parent2, boolean includeMyself, @NotNull Predicate<? super PsiElement> stopCondition) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(56);
        }
        if (parent2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(57);
        }
        if (stopCondition == null) {
            PsiTreeUtil.$$$reportNull$$$0(58);
        }
        if (!includeMyself) {
            element = element.getParent();
        }
        SmartList<T> parents2 = new SmartList<T>();
        while (element != null && !stopCondition.test(element)) {
            if (parent2.isInstance(element)) {
                parents2.add(parent2.cast(element));
            }
            element = element.getParent();
        }
        SmartList<T> smartList = parents2;
        if (smartList == null) {
            PsiTreeUtil.$$$reportNull$$$0(59);
        }
        return smartList;
    }

    @Nullable
    public static PsiElement findSiblingForward(@NotNull PsiElement element, @NotNull IElementType elementType, @Nullable Consumer<? super PsiElement> consumer) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(60);
        }
        if (elementType == null) {
            PsiTreeUtil.$$$reportNull$$$0(61);
        }
        return PsiTreeUtil.findSiblingForward(element, elementType, true, consumer);
    }

    @Nullable
    public static PsiElement findSiblingForward(@NotNull PsiElement element, @NotNull IElementType elementType, boolean strict, @Nullable Consumer<? super PsiElement> consumer) {
        PsiElement e;
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(62);
        }
        if (elementType == null) {
            PsiTreeUtil.$$$reportNull$$$0(63);
        }
        PsiElement psiElement = e = strict ? element.getNextSibling() : element;
        while (e != null) {
            if (elementType.equals(e.getNode().getElementType())) {
                return e;
            }
            if (consumer != null) {
                consumer.consume(e);
            }
            e = e.getNextSibling();
        }
        return null;
    }

    @Nullable
    public static PsiElement findSiblingBackward(@NotNull PsiElement element, @NotNull IElementType elementType, @Nullable Consumer<? super PsiElement> consumer) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(64);
        }
        if (elementType == null) {
            PsiTreeUtil.$$$reportNull$$$0(65);
        }
        return PsiTreeUtil.findSiblingBackward(element, elementType, true, consumer);
    }

    @Nullable
    public static PsiElement findSiblingBackward(@NotNull PsiElement element, @NotNull IElementType elementType, boolean strict, @Nullable Consumer<? super PsiElement> consumer) {
        PsiElement e;
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(66);
        }
        if (elementType == null) {
            PsiTreeUtil.$$$reportNull$$$0(67);
        }
        PsiElement psiElement = e = strict ? element.getPrevSibling() : element;
        while (e != null) {
            if (elementType.equals(e.getNode().getElementType())) {
                return e;
            }
            if (consumer != null) {
                consumer.consume(e);
            }
            e = e.getPrevSibling();
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement skipSiblingsForward(@Nullable PsiElement element, Class<? extends PsiElement> ... elementClasses) {
        if (elementClasses == null) {
            PsiTreeUtil.$$$reportNull$$$0(68);
        }
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getNextSibling(); e != null; e = e.getNextSibling()) {
            if (PsiTreeUtil.instanceOf(e, elementClasses)) continue;
            return e;
        }
        return null;
    }

    @Nullable
    @Contract(value="null -> null")
    public static PsiElement skipWhitespacesForward(@Nullable PsiElement element) {
        return PsiTreeUtil.skipSiblingsForward(element, WS);
    }

    @Nullable
    @Contract(value="null -> null")
    public static PsiElement skipWhitespacesAndCommentsForward(@Nullable PsiElement element) {
        return PsiTreeUtil.skipSiblingsForward(element, WS_COMMENTS);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement skipSiblingsBackward(@Nullable PsiElement element, Class<? extends PsiElement> ... elementClasses) {
        if (elementClasses == null) {
            PsiTreeUtil.$$$reportNull$$$0(69);
        }
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getPrevSibling(); e != null; e = e.getPrevSibling()) {
            if (PsiTreeUtil.instanceOf(e, elementClasses)) continue;
            return e;
        }
        return null;
    }

    @Nullable
    @Contract(value="null -> null")
    public static PsiElement skipWhitespacesBackward(@Nullable PsiElement element) {
        return PsiTreeUtil.skipSiblingsBackward(element, WS);
    }

    @Nullable
    @Contract(value="null -> null")
    public static PsiElement skipWhitespacesAndCommentsBackward(@Nullable PsiElement element) {
        return PsiTreeUtil.skipSiblingsBackward(element, WS_COMMENTS);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement skipParentsOfType(@Nullable PsiElement element, Class<? extends PsiElement> ... parentClasses) {
        if (parentClasses == null) {
            PsiTreeUtil.$$$reportNull$$$0(70);
        }
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getParent(); e != null; e = e.getParent()) {
            if (PsiTreeUtil.instanceOf(e, parentClasses)) continue;
            return e;
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(71);
        }
        if (element == null || element instanceof PsiFile) {
            return null;
        }
        PsiElement parent2 = element.getParent();
        if (parent2 == null) {
            return null;
        }
        return PsiTreeUtil.getNonStrictParentOfType(parent2, classes2);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getNonStrictParentOfType(@Nullable PsiElement element, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(72);
        }
        for (PsiElement run2 = element; run2 != null; run2 = run2.getParent()) {
            if (PsiTreeUtil.instanceOf(run2, classes2)) {
                PsiElement t = run2;
                return (T)t;
            }
            if (run2 instanceof PsiFile) break;
        }
        return null;
    }

    @Contract(pure=true)
    public static PsiElement @NotNull [] collectElements(@Nullable PsiElement element, @NotNull PsiElementFilter filter2) {
        if (filter2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(73);
        }
        PsiElementProcessor.CollectFilteredElements processor2 = new PsiElementProcessor.CollectFilteredElements(filter2);
        PsiTreeUtil.processElements(element, processor2);
        PsiElement[] psiElementArray = processor2.toArray();
        if (psiElementArray == null) {
            PsiTreeUtil.$$$reportNull$$$0(74);
        }
        return psiElementArray;
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <T extends PsiElement> Collection<T> collectElementsOfType(@Nullable PsiElement element, Class<T> ... classes2) {
        if (classes2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(75);
        }
        return PsiTreeUtil.findChildrenOfAnyType(element, false, classes2);
    }

    @Contract(value="null, _ -> true")
    public static boolean processElements(@Nullable PsiElement element, final @NotNull PsiElementProcessor processor2) {
        if (processor2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(76);
        }
        if (element == null) {
            return true;
        }
        if (element instanceof PsiCompiledElement || !element.isPhysical()) {
            if (!processor2.execute(element)) {
                return false;
            }
            for (PsiElement child : element.getChildren()) {
                if (PsiTreeUtil.processElements(child, processor2)) continue;
                return false;
            }
            return true;
        }
        final boolean[] result2 = new boolean[]{true};
        element.accept(new PsiRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (processor2.execute(element)) {
                    super.visitElement(element);
                } else {
                    this.stopWalking();
                    result2[0] = false;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/PsiTreeUtil$4", "visitElement"));
            }
        });
        return result2[0];
    }

    public static boolean processElements(@NotNull PsiElementProcessor processor2, PsiElement ... elements) {
        if (processor2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(77);
        }
        if (elements == null || elements.length == 0) {
            return true;
        }
        for (PsiElement element : elements) {
            if (PsiTreeUtil.processElements(element, processor2)) continue;
            return false;
        }
        return true;
    }

    public static void mark(@NotNull PsiElement element, @NotNull Object marker) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(78);
        }
        if (marker == null) {
            PsiTreeUtil.$$$reportNull$$$0(79);
        }
        element.getNode().putCopyableUserData(MARKER, marker);
    }

    @Nullable
    public static PsiElement releaseMark(@NotNull PsiElement root2, @NotNull Object marker) {
        ASTNode node;
        if (root2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(80);
        }
        if (marker == null) {
            PsiTreeUtil.$$$reportNull$$$0(81);
        }
        if (marker.equals((node = root2.getNode()).getCopyableUserData(MARKER))) {
            node.putCopyableUserData(MARKER, null);
            return root2;
        }
        for (PsiElement child = root2.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiElement result2 = PsiTreeUtil.releaseMark(child, marker);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    @Contract(pure=true)
    public static <T extends PsiElement> T findElementOfClassAtOffset(@NotNull PsiFile file2, int offset2, @NotNull Class<T> clazz, boolean strictStart) {
        if (file2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(82);
        }
        if (clazz == null) {
            PsiTreeUtil.$$$reportNull$$$0(83);
        }
        List<PsiFile> psiRoots = file2.getViewProvider().getAllFiles();
        PsiElement result2 = null;
        for (PsiElement psiElement : psiRoots) {
            T parent2;
            PsiElement elementAt = psiElement.findElementAt(offset2);
            if (elementAt == null || (parent2 = PsiTreeUtil.getParentOfType(elementAt, clazz, strictStart)) == null) continue;
            TextRange range = parent2.getTextRange();
            if (strictStart && range.getStartOffset() != offset2 || result2 != null && result2.getTextRange().getEndOffset() <= range.getEndOffset()) continue;
            result2 = parent2;
        }
        return (T)result2;
    }

    @SafeVarargs
    @Nullable
    @Contract(pure=true)
    public static <T extends PsiElement> T findElementOfClassAtOffsetWithStopSet(@NotNull PsiFile file2, int offset2, @NotNull Class<T> clazz, boolean strictStart, Class<? extends PsiElement> ... stopAt) {
        if (file2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(84);
        }
        if (clazz == null) {
            PsiTreeUtil.$$$reportNull$$$0(85);
        }
        if (stopAt == null) {
            PsiTreeUtil.$$$reportNull$$$0(86);
        }
        List<PsiFile> psiRoots = file2.getViewProvider().getAllFiles();
        PsiElement result2 = null;
        for (PsiElement psiElement : psiRoots) {
            T parent2;
            PsiElement elementAt = psiElement.findElementAt(offset2);
            if (elementAt == null || (parent2 = PsiTreeUtil.getParentOfType(elementAt, clazz, strictStart, stopAt)) == null) continue;
            TextRange range = parent2.getTextRange();
            if (strictStart && range.getStartOffset() != offset2 || result2 != null && result2.getTextRange().getEndOffset() <= range.getEndOffset()) continue;
            result2 = parent2;
        }
        return (T)result2;
    }

    @Nullable
    @Contract(pure=true)
    public static <T extends PsiElement> T findElementOfClassAtRange(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull Class<T> clazz) {
        if (file2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(87);
        }
        if (clazz == null) {
            PsiTreeUtil.$$$reportNull$$$0(88);
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        PsiElement result2 = null;
        for (Language lang : viewProvider.getLanguages()) {
            T run2;
            PsiElement elementAt = viewProvider.findElementAt(startOffset, lang);
            T prev = run2 = PsiTreeUtil.getParentOfType(elementAt, clazz, false);
            while (run2 != null && run2.getTextRange().getStartOffset() == startOffset && run2.getTextRange().getEndOffset() <= endOffset) {
                prev = run2;
                run2 = PsiTreeUtil.getParentOfType(run2, clazz);
            }
            if (prev == null) continue;
            int elementStartOffset = prev.getTextRange().getStartOffset();
            int elementEndOffset = prev.getTextRange().getEndOffset();
            if (elementStartOffset != startOffset || elementEndOffset > endOffset || result2 != null && result2.getTextRange().getEndOffset() >= elementEndOffset) continue;
            result2 = prev;
        }
        return (T)result2;
    }

    @NotNull
    public static PsiElement getDeepestFirst(@NotNull PsiElement elt) {
        if (elt == null) {
            PsiTreeUtil.$$$reportNull$$$0(89);
        }
        @NotNull PsiElement res2 = elt;
        while (true) {
            PsiElement firstChild;
            if ((firstChild = res2.getFirstChild()) == null) {
                PsiElement psiElement = res2;
                if (psiElement == null) {
                    PsiTreeUtil.$$$reportNull$$$0(90);
                }
                return psiElement;
            }
            res2 = firstChild;
        }
    }

    @NotNull
    public static PsiElement getDeepestLast(@NotNull PsiElement elt) {
        if (elt == null) {
            PsiTreeUtil.$$$reportNull$$$0(91);
        }
        @NotNull PsiElement res2 = elt;
        while (true) {
            PsiElement lastChild;
            if ((lastChild = res2.getLastChild()) == null) {
                PsiElement psiElement = res2;
                if (psiElement == null) {
                    PsiTreeUtil.$$$reportNull$$$0(92);
                }
                return psiElement;
            }
            res2 = lastChild;
        }
    }

    @Nullable
    public static PsiElement prevLeaf(@NotNull PsiElement current2) {
        if (current2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(93);
        }
        if (current2 instanceof PsiFileSystemItem) {
            return null;
        }
        PsiElement prevSibling = current2.getPrevSibling();
        if (prevSibling != null) {
            return PsiTreeUtil.lastChild(prevSibling);
        }
        PsiElement parent2 = current2.getParent();
        if (parent2 == null || parent2 instanceof PsiFile) {
            return null;
        }
        return PsiTreeUtil.prevLeaf(parent2);
    }

    @Nullable
    public static PsiElement nextLeaf(@NotNull PsiElement current2) {
        if (current2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(94);
        }
        if (current2 instanceof PsiFileSystemItem) {
            return null;
        }
        PsiElement nextSibling = current2.getNextSibling();
        if (nextSibling != null) {
            return PsiTreeUtil.firstChild(nextSibling);
        }
        PsiElement parent2 = current2.getParent();
        if (parent2 == null || parent2 instanceof PsiFile) {
            return null;
        }
        return PsiTreeUtil.nextLeaf(parent2);
    }

    @NotNull
    public static PsiElement lastChild(@NotNull PsiElement element) {
        PsiElement lastChild;
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(95);
        }
        if ((lastChild = element.getLastChild()) != null) {
            return PsiTreeUtil.lastChild(lastChild);
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            PsiTreeUtil.$$$reportNull$$$0(96);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement firstChild(@NotNull PsiElement element) {
        PsiElement child;
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(97);
        }
        if ((child = element.getFirstChild()) != null) {
            return PsiTreeUtil.firstChild(child);
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            PsiTreeUtil.$$$reportNull$$$0(98);
        }
        return psiElement;
    }

    @Nullable
    public static PsiElement prevLeaf(@NotNull PsiElement element, boolean skipEmptyElements) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(99);
        }
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf(element);
        while (skipEmptyElements && prevLeaf != null && prevLeaf.getTextLength() == 0) {
            prevLeaf = PsiTreeUtil.prevLeaf(prevLeaf);
        }
        return prevLeaf;
    }

    @Nullable
    public static PsiElement prevVisibleLeaf(@NotNull PsiElement element) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(100);
        }
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf(element, true);
        while (prevLeaf != null && StringUtil.isEmptyOrSpaces(prevLeaf.getText())) {
            prevLeaf = PsiTreeUtil.prevLeaf(prevLeaf, true);
        }
        return prevLeaf;
    }

    @Nullable
    public static PsiElement nextVisibleLeaf(@NotNull PsiElement element) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(101);
        }
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf(element, true);
        while (nextLeaf != null && StringUtil.isEmptyOrSpaces(nextLeaf.getText())) {
            nextLeaf = PsiTreeUtil.nextLeaf(nextLeaf, true);
        }
        return nextLeaf;
    }

    @Nullable
    public static PsiElement nextLeaf(@NotNull PsiElement element, boolean skipEmptyElements) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(102);
        }
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf(element);
        while (skipEmptyElements && nextLeaf != null && nextLeaf.getTextLength() == 0) {
            nextLeaf = PsiTreeUtil.nextLeaf(nextLeaf);
        }
        return nextLeaf;
    }

    public static boolean hasErrorElements(@NotNull PsiElement element) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(103);
        }
        return !SyntaxTraverser.psiTraverser(element).traverse().filter(PsiErrorElement.class).isEmpty();
    }

    public static PsiElement @NotNull [] filterAncestors(PsiElement @NotNull [] elements) {
        int previousSize;
        if (elements == null) {
            PsiTreeUtil.$$$reportNull$$$0(104);
        }
        if (LOG.isDebugEnabled()) {
            for (PsiElement element : elements) {
                LOG.debug("element = " + element);
            }
        }
        ArrayList filteredElements = new ArrayList();
        ContainerUtil.addAll(filteredElements, elements);
        block1: do {
            previousSize = filteredElements.size();
            for (PsiElement element : filteredElements) {
                for (PsiElement element2 : filteredElements) {
                    if (element == element2 || !PsiTreeUtil.isAncestor(element, element2, false)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("removing " + element2);
                    }
                    filteredElements.remove(element2);
                    continue block1;
                }
            }
        } while (filteredElements.size() != previousSize);
        if (LOG.isDebugEnabled()) {
            for (PsiElement element : filteredElements) {
                LOG.debug("filtered element = " + element);
            }
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(filteredElements);
        if (psiElementArray == null) {
            PsiTreeUtil.$$$reportNull$$$0(105);
        }
        return psiElementArray;
    }

    public static boolean treeWalkUp(@NotNull PsiScopeProcessor processor2, @NotNull PsiElement entrance, @Nullable PsiElement maxScope, @NotNull ResolveState state) {
        if (processor2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(106);
        }
        if (entrance == null) {
            PsiTreeUtil.$$$reportNull$$$0(107);
        }
        if (state == null) {
            PsiTreeUtil.$$$reportNull$$$0(108);
        }
        PsiElement prevParent = entrance;
        PsiElement scope2 = entrance;
        while (scope2 != null) {
            if (!scope2.processDeclarations(processor2, state, prevParent, entrance)) {
                return false;
            }
            if (scope2 == maxScope) break;
            prevParent = scope2;
            scope2 = prevParent.getContext();
        }
        return true;
    }

    public static boolean treeWalkUp(@NotNull PsiElement entrance, @Nullable PsiElement maxScope, @NotNull PairProcessor<? super PsiElement, ? super PsiElement> eachScopeAndLastParent) {
        if (entrance == null) {
            PsiTreeUtil.$$$reportNull$$$0(109);
        }
        if (eachScopeAndLastParent == null) {
            PsiTreeUtil.$$$reportNull$$$0(110);
        }
        PsiElement prevParent = null;
        PsiElement scope2 = entrance;
        while (scope2 != null) {
            if (!eachScopeAndLastParent.process(scope2, prevParent)) {
                return false;
            }
            if (scope2 == maxScope) break;
            prevParent = scope2;
            scope2 = prevParent.getContext();
        }
        return true;
    }

    @NotNull
    public static PsiElement findPrevParent(@NotNull PsiElement ancestor, @NotNull PsiElement descendant) {
        if (ancestor == null) {
            PsiTreeUtil.$$$reportNull$$$0(111);
        }
        if (descendant == null) {
            PsiTreeUtil.$$$reportNull$$$0(112);
        }
        PsiElement cur = descendant;
        while (cur != null) {
            PsiElement parent2 = cur.getParent();
            if (parent2 == ancestor) {
                PsiElement psiElement = cur;
                if (psiElement == null) {
                    PsiTreeUtil.$$$reportNull$$$0(113);
                }
                return psiElement;
            }
            cur = parent2;
        }
        throw new AssertionError((Object)(descendant + " is not a descendant of " + ancestor));
    }

    public static List<PsiElement> getInjectedElements(@NotNull OuterLanguageElement outerLanguageElement) {
        if (outerLanguageElement == null) {
            PsiTreeUtil.$$$reportNull$$$0(114);
        }
        PsiFile psi = outerLanguageElement.getContainingFile().getViewProvider().getPsi(outerLanguageElement.getLanguage());
        TextRange injectionRange = outerLanguageElement.getTextRange();
        ArrayList<PsiElement> res2 = new ArrayList<PsiElement>();
        assert (psi != null) : outerLanguageElement;
        for (PsiElement element = psi.findElementAt(injectionRange.getStartOffset()); element != null && injectionRange.intersectsStrict(element.getTextRange()); element = element.getNextSibling()) {
            res2.add(element);
        }
        return res2;
    }

    @Nullable
    public static PsiElement getDeepestVisibleFirst(@NotNull PsiElement psiElement) {
        PsiElement first;
        if (psiElement == null) {
            PsiTreeUtil.$$$reportNull$$$0(115);
        }
        if (StringUtil.isEmptyOrSpaces((first = PsiTreeUtil.getDeepestFirst(psiElement)).getText())) {
            first = PsiTreeUtil.nextVisibleLeaf(first);
        }
        return first;
    }

    @Nullable
    public static PsiElement getDeepestVisibleLast(@NotNull PsiElement psiElement) {
        PsiElement last;
        if (psiElement == null) {
            PsiTreeUtil.$$$reportNull$$$0(116);
        }
        if (StringUtil.isEmptyOrSpaces((last = PsiTreeUtil.getDeepestLast(psiElement)).getText())) {
            last = PsiTreeUtil.prevVisibleLeaf(last);
        }
        return last;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static <T extends PsiElement> Iterator<T> childIterator(@NotNull PsiElement element, @NotNull Class<T> aClass2) {
        if (element == null) {
            PsiTreeUtil.$$$reportNull$$$0(117);
        }
        if (aClass2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(118);
        }
        return SyntaxTraverser.psiTraverser().children(element).filter(aClass2).iterator();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 20: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 59: 
            case 74: 
            case 90: 
            case 92: 
            case 96: 
            case 98: 
            case 105: 
            case 113: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 20: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 59: 
            case 74: 
            case 90: 
            case 92: 
            case 96: 
            case 98: 
            case 105: 
            case 113: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 21: 
            case 23: 
            case 27: 
            case 32: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 28: 
            case 42: 
            case 50: 
            case 51: 
            case 71: 
            case 72: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 19: 
            case 20: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 59: 
            case 74: 
            case 90: 
            case 92: 
            case 96: 
            case 98: 
            case 105: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiTreeUtil";
                break;
            }
            case 26: 
            case 83: 
            case 85: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 55: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopCondition";
                break;
            }
            case 61: 
            case 63: 
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 68: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClasses";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClasses";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 76: 
            case 77: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 79: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 82: 
            case 84: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 89: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 93: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 107: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entrance";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eachScopeAndLastParent";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerLanguageElement";
                break;
            }
            case 115: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiTreeUtil";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findChildrenOfAnyType";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredChildOfType";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenOfAnyType";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenOfTypeAsList";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsOfRange";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubChildrenOfTypeAsList";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "collectParents";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "collectElements";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeepestFirst";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeepestLast";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "lastChild";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "firstChild";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAncestors";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "findPrevParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isContextAncestor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCommonParent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDepth";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findCommonContext";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getContextDepth";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findChildOfType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findChildOfAnyType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findChildrenOfType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findChildrenOfAnyType";
                break;
            }
            case 19: 
            case 20: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 59: 
            case 74: 
            case 90: 
            case 92: 
            case 96: 
            case 98: 
            case 105: 
            case 113: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getChildOfType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredChildOfType";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "countChildrenOfType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenOfType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenOfAnyType";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenOfTypeAsList";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getElementsOfRange";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getStubChildOfType";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getStubChildrenOfTypeAsList";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getChildOfAnyType";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getNextSiblingOfType";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getPrevSiblingOfType";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostParentOfType";
                break;
            }
            case 46: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiParentOfType";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getContextOfType";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "collectParents";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "findSiblingForward";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "findSiblingBackward";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "skipSiblingsForward";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "skipSiblingsBackward";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "skipParentsOfType";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getNonStrictParentOfType";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "collectElements";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "collectElementsOfType";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "processElements";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "mark";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "releaseMark";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "findElementOfClassAtOffset";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "findElementOfClassAtOffsetWithStopSet";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "findElementOfClassAtRange";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestFirst";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestLast";
                break;
            }
            case 93: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "prevLeaf";
                break;
            }
            case 94: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "nextLeaf";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "lastChild";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "firstChild";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "prevVisibleLeaf";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "nextVisibleLeaf";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "hasErrorElements";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "filterAncestors";
                break;
            }
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "treeWalkUp";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "findPrevParent";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedElements";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestVisibleFirst";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestVisibleLast";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "childIterator";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 19: 
            case 20: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 59: 
            case 74: 
            case 90: 
            case 92: 
            case 96: 
            case 98: 
            case 105: 
            case 113: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

