/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/PrivateInlineFunctionsReturningAnonymousObjectsChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class PrivateInlineFunctionsReturningAnonymousObjectsChecker
implements DeclarationChecker {
    @NotNull
    public static final PrivateInlineFunctionsReturningAnonymousObjectsChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Object v3;
        Object returnTypeConstructor;
        block9: {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ForbidAnonymousReturnTypesInPrivateInlineFunctions)) {
                return;
            }
            if (!(descriptor2 instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)descriptor2).isInline() && KtPsiUtilKt.isPrivate(declaration2) && declaration2 instanceof KtNamedFunction)) {
                return;
            }
            Object object = ((SimpleFunctionDescriptor)descriptor2).getReturnType();
            if (object == null || (object = ((KotlinType)object).getConstructor()) == null) {
                return;
            }
            returnTypeConstructor = object;
            Collection<KotlinType> collection = returnTypeConstructor.getSupertypes();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"returnTypeConstructor.supertypes");
            Iterable $this$singleOrNull$iv = collection;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                KotlinType it = (KotlinType)element$iv;
                boolean bl = false;
                KotlinType kotlinType = it;
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it");
                if (!TypeUtilsKt.isAnyOrNullableAny(kotlinType)) continue;
                if (found$iv) {
                    v3 = null;
                    break block9;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v3 = !found$iv ? null : single$iv;
        }
        if (v3 == null) {
            return;
        }
        PsiElement psiElement = ((KtNamedFunction)declaration2).getNameIdentifier();
        if (psiElement == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"declaration.nameIdentifier ?: return");
        PsiElement nameIdentifier = psiElement;
        ClassifierDescriptor classifierDescriptor = returnTypeConstructor.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)classifierDescriptor, (String)"returnTypeConstructor.de\u2026ationDescriptor ?: return");
        ClassifierDescriptor returnTypeDeclarationDescriptor = classifierDescriptor;
        if (DescriptorUtils.isAnonymousObject(returnTypeDeclarationDescriptor)) {
            context2.getTrace().report(Errors.PRIVATE_INLINE_FUNCTIONS_RETURNING_ANONYMOUS_OBJECTS.on(nameIdentifier));
        }
    }

    private PrivateInlineFunctionsReturningAnonymousObjectsChecker() {
    }

    static {
        PrivateInlineFunctionsReturningAnonymousObjectsChecker privateInlineFunctionsReturningAnonymousObjectsChecker;
        INSTANCE = privateInlineFunctionsReturningAnonymousObjectsChecker = new PrivateInlineFunctionsReturningAnonymousObjectsChecker();
    }
}

