/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrClassKt;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\u0015\u001a\u00020\b*\u00020\u00162\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOverloadsAnnotationLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "generateWrapper", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "target", "numDefaultParametersToExpect", "", "generateWrappers", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "lower", "generateNewValueParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "oldFunction", "generateWrapperHeader", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "backend.jvm"})
final class JvmOverloadsAnnotationLowering
implements ClassLoweringPass {
    private final JvmBackendContext context;

    /*
     * WARNING - void declaration
     */
    @Override
    public void lower(@NotNull IrClass irClass2) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Iterable $this$filterIsInstance$iv = irClass2.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrFunction it = (IrFunction)element$iv$iv;
            boolean bl = false;
            if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)it, JvmAnnotationUtilKt.getJVM_OVERLOADS_FQ_NAME())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List functions2 = (List)destination$iv$iv;
        Iterable $this$forEach$iv = functions2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrFunction it = (IrFunction)element$iv;
            boolean bl = false;
            this.generateWrappers(it, irClass2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateWrappers(IrFunction target, IrClass irClass2) {
        int n;
        Iterable $this$count$iv22 = target.getValueParameters();
        boolean $i$f$count = false;
        if ($this$count$iv22 instanceof Collection && ((Collection)$this$count$iv22).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv22) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl = false;
                if (!(it.getDefaultValue() != null)) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int numDefaultParameters = n;
        int $this$count$iv22 = numDefaultParameters - 1;
        boolean bl = false;
        while ($this$count$iv22 >= 0) {
            void i;
            IrFunction wrapper = this.generateWrapper(target, (int)i);
            IrClassKt.addMember(irClass2, wrapper);
            --i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IrFunction generateWrapper(IrFunction target, int numDefaultParametersToExpect) {
        IrGetValueImpl irGetValueImpl;
        IrGetValueImpl irGetValueImpl2;
        IrGetValueImpl irGetValueImpl3;
        IrDeclarationBase dispatchReceiver;
        IrFunctionAccessExpression irFunctionAccessExpression;
        boolean bl;
        IrDeclarationBase arg2;
        IrFunctionAccessExpression irFunctionAccessExpression2;
        IrFunction wrapperIrFunction = this.generateWrapperHeader(this.context.getIrFactory(), target, numDefaultParametersToExpect);
        IrFunction irFunction2 = target;
        if (irFunction2 instanceof IrConstructor) {
            irFunctionAccessExpression2 = new IrDelegatingConstructorCallImpl(-1, -1, this.context.getIrBuiltIns().getUnitType(), (IrConstructorSymbol)((IrConstructor)target).getSymbol());
        } else if (irFunction2 instanceof IrSimpleFunction) {
            irFunctionAccessExpression2 = new IrCallImpl(-1, -1, target.getReturnType(), (IrSimpleFunctionSymbol)((IrSimpleFunction)target).getSymbol(), null, null, 48, null);
        } else {
            String string2 = "unknown function kind: " + RenderIrElementKt.render(target);
            boolean bl2 = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        IrFunctionAccessExpression call2 = irFunctionAccessExpression2;
        for (IrDeclarationBase arg2 : IrUtilsKt.getAllTypeParameters(wrapperIrFunction)) {
            call2.putTypeArgument(arg2.getIndex(), IrTypesKt.getDefaultType(arg2));
        }
        IrFunctionAccessExpression irFunctionAccessExpression3 = call2;
        IrValueParameter irValueParameter = wrapperIrFunction.getDispatchReceiverParameter();
        if (irValueParameter != null) {
            arg2 = irValueParameter;
            boolean bl3 = false;
            bl = false;
            IrDeclarationBase irDeclarationBase = arg2;
            irFunctionAccessExpression = irFunctionAccessExpression3;
            boolean bl4 = false;
            irGetValueImpl3 = new IrGetValueImpl(-1, -1, ((IrValueDeclaration)dispatchReceiver).getSymbol(), null, 8, null);
            irFunctionAccessExpression3 = irFunctionAccessExpression;
            irGetValueImpl2 = irGetValueImpl3;
        } else {
            irGetValueImpl2 = null;
        }
        irFunctionAccessExpression3.setDispatchReceiver(irGetValueImpl2);
        IrFunctionAccessExpression irFunctionAccessExpression4 = call2;
        IrValueParameter irValueParameter2 = wrapperIrFunction.getExtensionReceiverParameter();
        if (irValueParameter2 != null) {
            void extensionReceiver;
            arg2 = irValueParameter2;
            boolean bl5 = false;
            bl = false;
            dispatchReceiver = arg2;
            irFunctionAccessExpression = irFunctionAccessExpression4;
            boolean bl6 = false;
            irGetValueImpl3 = new IrGetValueImpl(-1, -1, extensionReceiver.getSymbol(), null, 8, null);
            irFunctionAccessExpression4 = irFunctionAccessExpression;
            irGetValueImpl = irGetValueImpl3;
        } else {
            irGetValueImpl = null;
        }
        irFunctionAccessExpression4.setExtensionReceiver(irGetValueImpl);
        int parametersCopied = 0;
        int defaultParametersCopied = 0;
        bl = false;
        for (IrValueParameter valueParameter : (Iterable)target.getValueParameters()) {
            void i;
            if (valueParameter.getDefaultValue() != null) {
                if (defaultParametersCopied < numDefaultParametersToExpect) {
                    ++defaultParametersCopied;
                    call2.putValueArgument((int)i, new IrGetValueImpl(-1, -1, wrapperIrFunction.getValueParameters().get(parametersCopied++).getSymbol(), null, 8, null));
                } else {
                    call2.putValueArgument((int)i, null);
                }
            } else {
                call2.putValueArgument((int)i, new IrGetValueImpl(-1, -1, wrapperIrFunction.getValueParameters().get(parametersCopied++).getSymbol(), null, 8, null));
            }
            ++i;
        }
        wrapperIrFunction.setBody(target instanceof IrConstructor ? (IrBody)new IrBlockBodyImpl(-1, -1, CollectionsKt.listOf((Object)call2)) : (IrBody)new IrExpressionBodyImpl(-1, -1, call2));
        return wrapperIrFunction;
    }

    /*
     * WARNING - void declaration
     */
    private final IrFunction generateWrapperHeader(IrFactory $this$generateWrapperHeader, IrFunction oldFunction, int numDefaultParametersToExpect) {
        Collection<IrConstructorCall> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrElement irElement;
        IrFunctionBuilder $this$run$iv;
        boolean bl;
        boolean bl2;
        IrFunctionBuilder irFunctionBuilder;
        Object object = oldFunction;
        if (object instanceof IrConstructor) {
            IrFactory $this$buildConstructor$iv = $this$generateWrapperHeader;
            boolean $i$f$buildConstructor = false;
            irFunctionBuilder = new IrFunctionBuilder();
            bl2 = false;
            bl = false;
            $this$run$iv = irFunctionBuilder;
            boolean bl3 = false;
            IrFunctionBuilder $this$buildConstructor = $this$run$iv;
            boolean bl4 = false;
            $this$buildConstructor.setOrigin(JvmLoweredDeclarationOrigin.JVM_OVERLOADS_WRAPPER.INSTANCE);
            $this$buildConstructor.setName(oldFunction.getName());
            $this$buildConstructor.setVisibility(oldFunction.getVisibility());
            $this$buildConstructor.setReturnType(oldFunction.getReturnType());
            $this$buildConstructor.setInline(oldFunction.isInline());
            irElement = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv, $this$run$iv);
        } else if (object instanceof IrSimpleFunction) {
            IrFactory $this$buildFun$iv = $this$generateWrapperHeader;
            boolean $i$f$buildFun = false;
            irFunctionBuilder = new IrFunctionBuilder();
            bl2 = false;
            bl = false;
            $this$run$iv = irFunctionBuilder;
            boolean bl5 = false;
            IrFunctionBuilder $this$buildFun = $this$run$iv;
            boolean bl6 = false;
            $this$buildFun.setOrigin(JvmLoweredDeclarationOrigin.JVM_OVERLOADS_WRAPPER.INSTANCE);
            $this$buildFun.setName(oldFunction.getName());
            $this$buildFun.setVisibility(oldFunction.getVisibility());
            $this$buildFun.setModality(this.context.getState().getLanguageVersionSettings().supportsFeature(LanguageFeature.GenerateJvmOverloadsAsFinal) ? Modality.FINAL : ((IrSimpleFunction)oldFunction).getModality());
            $this$buildFun.setReturnType(oldFunction.getReturnType());
            $this$buildFun.setInline(oldFunction.isInline());
            $this$buildFun.setSuspend(((IrSimpleFunction)oldFunction).isSuspend());
            irElement = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$run$iv);
        } else {
            String $this$buildFun$iv = "Unknown kind of IrFunction: " + oldFunction;
            boolean $i$f$buildFun = false;
            throw (Throwable)new IllegalStateException($this$buildFun$iv.toString());
        }
        IrElement res2 = irElement;
        ((IrFunction)res2).setParent(oldFunction.getParent());
        IrFunction irFunction2 = (IrFunction)res2;
        object = oldFunction.getAnnotations();
        Collection collection2 = irFunction2.getAnnotations();
        IrFunction irFunction3 = irFunction2;
        boolean $i$f$map = false;
        void $i$f$buildFun = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p2;
            void p1;
            void $this$deepCopyWithSymbols$iv;
            void it;
            IrConstructorCall bl5 = (IrConstructorCall)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl7 = false;
            IrElement bl6 = (IrElement)it;
            IrDeclarationParent initialParent$iv = (IrDeclarationParent)res2;
            boolean $i$f$deepCopyWithSymbols = false;
            DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(null, 1, null);
            IrElementVisitorVoidKt.acceptVoid((IrElement)$this$deepCopyWithSymbols$iv, symbolRemapper$iv);
            DeepCopyTypeRemapper typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
            TypeRemapper typeRemapper = typeRemapper$iv;
            SymbolRemapper symbolRemapper = symbolRemapper$iv;
            void var21_31 = $this$deepCopyWithSymbols$iv;
            DeepCopyIrTreeWithSymbols deepCopyIrTreeWithSymbols = new DeepCopyIrTreeWithSymbols((SymbolRemapper)p1, (TypeRemapper)p2);
            IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(var21_31.transform(deepCopyIrTreeWithSymbols, null), initialParent$iv);
            if (irElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConstructorCall");
            }
            IrConstructorCall irConstructorCall = (IrConstructorCall)((IrElement)((IrConstructorCall)irElement2));
            collection.add(irConstructorCall);
        }
        collection = (List)destination$iv$iv;
        irFunction3.setAnnotations(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTypeParametersFrom$default((IrTypeParametersContainer)res2, oldFunction, null, null, 6, null);
        IrValueParameter irValueParameter = oldFunction.getDispatchReceiverParameter();
        ((IrFunction)res2).setDispatchReceiverParameter(irValueParameter != null ? org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(irValueParameter, (IrFunction)res2, null, 0, 0, 0, null, null, null, null, null, false, false, 4094, null) : null);
        IrValueParameter irValueParameter2 = oldFunction.getExtensionReceiverParameter();
        ((IrFunction)res2).setExtensionReceiverParameter(irValueParameter2 != null ? org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(irValueParameter2, (IrFunction)res2, null, 0, 0, 0, null, null, null, null, null, false, false, 4094, null) : null);
        IrFunction irFunction4 = (IrFunction)res2;
        irFunction4.setValueParameters(CollectionsKt.plus((Collection)irFunction4.getValueParameters(), (Iterable)this.generateNewValueParameters((IrFunction)res2, oldFunction, numDefaultParametersToExpect)));
        return (IrFunction)res2;
    }

    private final List<IrValueParameter> generateNewValueParameters(IrFunction $this$generateNewValueParameters, IrFunction oldFunction, int numDefaultParametersToExpect) {
        int parametersCopied = 0;
        int defaultParametersCopied = 0;
        boolean bl = false;
        List result2 = new ArrayList();
        for (IrValueParameter oldValueParameter : oldFunction.getValueParameters()) {
            if (oldValueParameter.getDefaultValue() != null && defaultParametersCopied < numDefaultParametersToExpect) {
                ++defaultParametersCopied;
                result2.add(org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(oldValueParameter, $this$generateNewValueParameters, null, parametersCopied++, 0, 0, null, null, null, null, null, oldValueParameter.isCrossinline(), oldValueParameter.isNoinline(), 506, null));
                continue;
            }
            if (oldValueParameter.getDefaultValue() != null) continue;
            result2.add(org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(oldValueParameter, $this$generateNewValueParameters, null, parametersCopied++, 0, 0, null, null, null, null, null, false, false, 4090, null));
        }
        return result2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public JvmOverloadsAnnotationLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }
}

