/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B%\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\r\u001a\u0004\u0018\u00010\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\u00172\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ,\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u00172\b\b\u0002\u0010\u001c\u001a\u00020\u00172\b\b\u0002\u0010\u001d\u001a\u00020\u0017J$\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\t2\b\b\u0002\u0010\u001b\u001a\u00020\u00172\b\b\u0002\u0010\u001d\u001a\u00020\u0017H\u0007J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J \u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017H\u0002R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/MainFunctionDetector;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "functionResolver", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lkotlin/jvm/functions/Function1;)V", "getFunctionDescriptor", "findMainFunction", "declarations", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getMainFunction", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "packageView", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "hasMain", "", "isMain", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "checkJvmStaticAnnotation", "checkReturnType", "allowParameterless", "function", "isMainWithParameter", "declaration", "isParameterNumberSuitsForMain", "parametersCount", "", "isTopLevel", "Companion", "frontend"})
public final class MainFunctionDetector {
    private final Function1<KtNamedFunction, FunctionDescriptor> getFunctionDescriptor;
    private final LanguageVersionSettings languageVersionSettings;
    public static final Companion Companion = new Companion(null);

    public final boolean hasMain(@NotNull List<? extends KtDeclaration> declarations2) {
        Intrinsics.checkParameterIsNotNull(declarations2, (String)"declarations");
        return this.findMainFunction(declarations2) != null;
    }

    @JvmOverloads
    public final boolean isMain(@NotNull KtNamedFunction function2, boolean checkJvmStaticAnnotation, boolean allowParameterless) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        if (function2.isLocal()) {
            return false;
        }
        int parametersCount = function2.getValueParameters().size();
        if (function2.getReceiverTypeReference() != null) {
            ++parametersCount;
        }
        if (!this.isParameterNumberSuitsForMain(parametersCount, function2.isTopLevel(), allowParameterless)) {
            return false;
        }
        if (!function2.getTypeParameters().isEmpty()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)"main", (Object)function2.getName()) ^ true && !MainFunctionDetector.Companion.hasAnnotationWithExactNumberOfArguments(function2, 1)) {
            return false;
        }
        if (checkJvmStaticAnnotation && !function2.isTopLevel() && !MainFunctionDetector.Companion.hasAnnotationWithExactNumberOfArguments(function2, 0)) {
            return false;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.getFunctionDescriptor.invoke((Object)function2);
        if (functionDescriptor == null) {
            return false;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        return MainFunctionDetector.isMain$default(this, functionDescriptor2, checkJvmStaticAnnotation, false, allowParameterless, 4, null);
    }

    @JvmOverloads
    public static /* synthetic */ boolean isMain$default(MainFunctionDetector mainFunctionDetector, KtNamedFunction ktNamedFunction, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return mainFunctionDetector.isMain(ktNamedFunction, bl, bl2);
    }

    @JvmOverloads
    public final boolean isMain(@NotNull KtNamedFunction function2, boolean checkJvmStaticAnnotation) {
        return MainFunctionDetector.isMain$default(this, function2, checkJvmStaticAnnotation, false, 4, null);
    }

    @JvmOverloads
    public final boolean isMain(@NotNull KtNamedFunction function2) {
        return MainFunctionDetector.isMain$default(this, function2, false, false, 6, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMain(@NotNull DeclarationDescriptor descriptor2, boolean checkJvmStaticAnnotation, boolean checkReturnType, boolean allowParameterless) {
        Object $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)MainFunctionDetector.Companion.getJVMFunctionName((FunctionDescriptor)descriptor2), (Object)"main") ^ true) {
            return false;
        }
        List<ValueParameterDescriptor> list2 = ((FunctionDescriptor)descriptor2).getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"descriptor.valueParameters");
        Iterable iterable = list2;
        Collection collection = new ArrayList();
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv = iterator2.next();
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv;
            Collection collection2 = collection;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            KotlinType kotlinType = v1.getType();
            collection2.add(kotlinType);
        }
        List parameters2 = (List)collection;
        Annotated annotated = ((FunctionDescriptor)descriptor2).getExtensionReceiverParameter();
        if (annotated != null && (annotated = annotated.getType()) != null) {
            $receiver$iv = annotated;
            Annotated annotated2 = $receiver$iv;
            iterator2 = parameters2;
            iterator2.add(annotated2);
        }
        if (!this.isParameterNumberSuitsForMain(parameters2.size(), DescriptorUtils.isTopLevelDeclaration(descriptor2), allowParameterless)) {
            return false;
        }
        List<TypeParameterDescriptor> list3 = ((FunctionDescriptor)descriptor2).getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"descriptor.typeParameters");
        $receiver$iv = list3;
        if (!$receiver$iv.isEmpty()) {
            return false;
        }
        boolean bl = false;
        if (bl) {
            return false;
        }
        if (parameters2.size() == 1) {
            Object e = parameters2.get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"parameters[0]");
            KotlinType parameterType = (KotlinType)e;
            if (!KotlinBuiltIns.isArray(parameterType)) {
                return false;
            }
            List<TypeProjection> list4 = parameterType.getArguments();
            if (list4.size() != 1) {
                return false;
            }
            KotlinType kotlinType = list4.get(0).getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"typeArguments[0].type");
            KotlinType typeArgument = kotlinType;
            if (!KotlinBuiltIns.isString(typeArgument)) {
                return false;
            }
            if (list4.get(0).getProjectionKind() == Variance.IN_VARIANCE) {
                return false;
            }
        } else {
            boolean parameterType;
            boolean bl2 = parameterType = parameters2.size() == 0;
            if (_Assertions.ENABLED && !parameterType) {
                iterator2 = "Parameter list is expected to be empty";
                throw (Throwable)((Object)new AssertionError(iterator2));
            }
            parameterType = DescriptorUtils.isTopLevelDeclaration(descriptor2);
            if (_Assertions.ENABLED && !parameterType) {
                iterator2 = "main without parameters works only for top-level";
                throw (Throwable)((Object)new AssertionError(iterator2));
            }
            KtFile containingFile = DescriptorToSourceUtils.getContainingFile(descriptor2);
            if (Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor2).getName().asString(), (Object)"main") ^ true) {
                return false;
            }
            Object object = containingFile;
            if (object != null && (object = ((KtFile)object).getDeclarations()) != null) {
                boolean bl3;
                Iterable iterable2 = (Iterable)object;
                if (iterable2 instanceof Collection && ((Collection)iterable2).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : iterable2) {
                        KtDeclaration declaration = (KtDeclaration)element$iv;
                        if (!this.isMainWithParameter(declaration, checkJvmStaticAnnotation)) continue;
                        return false;
                    }
                    bl3 = false;
                }
                if (bl3) {
                    return false;
                }
            }
        }
        if (((FunctionDescriptor)descriptor2).isSuspend() && !this.languageVersionSettings.supportsFeature(LanguageFeature.ExtendedMainConvention)) {
            return false;
        }
        if (checkReturnType && !MainFunctionDetector.Companion.isMainReturnType((FunctionDescriptor)descriptor2)) {
            return false;
        }
        if (DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            return true;
        }
        DeclarationDescriptor declarationDescriptor = ((FunctionDescriptor)descriptor2).getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (!(containingDeclaration instanceof ClassDescriptor)) return false;
        ClassKind classKind = ((ClassDescriptor)containingDeclaration).getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)classKind), (String)"containingDeclaration.kind");
        if (!classKind.isSingleton()) return false;
        if (AnnotationUtilKt.hasJvmStaticAnnotation(descriptor2)) return true;
        if (checkJvmStaticAnnotation) return false;
        return true;
    }

    public static /* synthetic */ boolean isMain$default(MainFunctionDetector mainFunctionDetector, DeclarationDescriptor declarationDescriptor, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        return mainFunctionDetector.isMain(declarationDescriptor, bl, bl2, bl3);
    }

    private final boolean isMainWithParameter(KtDeclaration declaration, boolean checkJvmStaticAnnotation) {
        return declaration instanceof KtNamedFunction && this.isMain((KtNamedFunction)declaration, checkJvmStaticAnnotation, false);
    }

    @Nullable
    public final FunctionDescriptor getMainFunction(@NotNull ModuleDescriptor module2) {
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        FqName fqName2 = FqName.ROOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"FqName.ROOT");
        return this.getMainFunction(module2, module2.getPackage(fqName2));
    }

    private final FunctionDescriptor getMainFunction(ModuleDescriptor module2, PackageViewDescriptor packageView) {
        FunctionDescriptor it;
        FunctionDescriptor functionDescriptor;
        Object element$iv$iv;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)packageView.getFragments();
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            PackageFragmentDescriptor it2 = (PackageFragmentDescriptor)element$iv$iv;
            if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getModule(it2), (Object)module2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (PackageFragmentDescriptor packageFragment2 : (List)destination$iv$iv) {
            Object v1;
            block5: {
                Collection<DeclarationDescriptor> collection = DescriptorUtils.getAllDescriptors(packageFragment2.getMemberScope());
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"DescriptorUtils.getAllDe\u2026ragment.getMemberScope())");
                $receiver$iv = collection;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList();
                iterator2 = $receiver$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv$iv = iterator2.next();
                    if (!(element$iv$iv instanceof FunctionDescriptor)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (Object element$iv : $receiver$iv) {
                    FunctionDescriptor it3 = (FunctionDescriptor)element$iv;
                    if (!MainFunctionDetector.isMain$default(this, it3, false, false, false, 14, null)) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            FunctionDescriptor functionDescriptor2 = v1;
            if (functionDescriptor2 == null) continue;
            it = functionDescriptor = functionDescriptor2;
            return it;
        }
        for (FqName subpackageName : module2.getSubPackagesOf(packageView.getFqName(), MemberScope.Companion.getALL_NAME_FILTER())) {
            FunctionDescriptor functionDescriptor3 = this.getMainFunction(module2, module2.getPackage(subpackageName));
            if (functionDescriptor3 == null) continue;
            it = functionDescriptor = functionDescriptor3;
            return it;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final KtNamedFunction findMainFunction(List<? extends KtDeclaration> declarations2) {
        Iterator iterator2;
        block2: {
            Iterable iterable;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable2 = $receiver$iv = (Iterable)declarations2;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof KtNamedFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            iterable2 = iterable = (Iterable)((List)destination$iv$iv);
            for (Iterator iterator3 : iterable2) {
                KtNamedFunction it = (KtNamedFunction)((Object)iterator3);
                if (!MainFunctionDetector.isMain$default(this, it, false, false, 6, null)) continue;
                iterator2 = iterator3;
                break block2;
            }
            iterator2 = null;
        }
        return (KtNamedFunction)((Object)iterator2);
    }

    private final boolean isParameterNumberSuitsForMain(int parametersCount, boolean isTopLevel, boolean allowParameterless) {
        boolean bl;
        switch (parametersCount) {
            case 1: {
                bl = true;
                break;
            }
            case 0: {
                if (isTopLevel && allowParameterless && this.languageVersionSettings.supportsFeature(LanguageFeature.ExtendedMainConvention)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public MainFunctionDetector(final @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.getFunctionDescriptor = (Function1)new Function1<KtNamedFunction, FunctionDescriptor>(){

            @NotNull
            public final FunctionDescriptor invoke(@NotNull KtNamedFunction function2) {
                Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
                SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)bindingContext.get(BindingContext.FUNCTION, function2);
                if (simpleFunctionDescriptor == null) {
                    throw (Throwable)new IllegalStateException("No descriptor resolved for " + function2 + " " + function2.getText());
                }
                return simpleFunctionDescriptor;
            }
        };
        this.languageVersionSettings = languageVersionSettings;
    }

    public MainFunctionDetector(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull Function1<? super KtNamedFunction, ? extends FunctionDescriptor> functionResolver) {
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull(functionResolver, (String)"functionResolver");
        this.getFunctionDescriptor = functionResolver;
        this.languageVersionSettings = languageVersionSettings;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/MainFunctionDetector$Companion;", "", "()V", "getJVMFunctionName", "", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "hasAnnotationWithExactNumberOfArguments", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "number", "", "isMainReturnType", "descriptor", "frontend"})
    public static final class Companion {
        private final boolean isMainReturnType(FunctionDescriptor descriptor2) {
            KotlinType returnType2 = descriptor2.getReturnType();
            return returnType2 != null && KotlinBuiltIns.isUnit(returnType2);
        }

        private final String getJVMFunctionName(FunctionDescriptor functionDescriptor) {
            String string = DescriptorUtils.getJvmName(functionDescriptor);
            if (string == null) {
                String string2 = functionDescriptor.getName().asString();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"functionDescriptor.name.asString()");
            }
            return string;
        }

        private final boolean hasAnnotationWithExactNumberOfArguments(KtNamedFunction function2, int number) {
            boolean bl;
            block3: {
                List<KtAnnotationEntry> list2 = function2.getAnnotationEntries();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"function.annotationEntries");
                Iterable $receiver$iv = list2;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        KtAnnotationEntry it;
                        KtAnnotationEntry ktAnnotationEntry = it = (KtAnnotationEntry)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktAnnotationEntry, (String)"it");
                        if (!(ktAnnotationEntry.getValueArguments().size() == number)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

