/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import com.google.gwt.dev.js.ThrowExceptionOnErrorReporter;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsCodeKt;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.js.backend.ast.AbstractNode;
import org.jetbrains.kotlin.js.backend.ast.DelegatingJsFunctionScopeWithTemporaryParent;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsRootScope;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.parser.ParserUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"parseJsCode", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "jsCode", "", "currentScope", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "translateJsCode", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "scope", "backend.js"})
public final class JsCodeKt {
    @NotNull
    public static final JsNode translateJsCode(@NotNull IrCall call2, @NotNull JsScope scope) {
        JsNode jsNode;
        Intrinsics.checkParameterIsNotNull((Object)call2, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        translateJsCode.1 foldString$ = translateJsCode.1.INSTANCE;
        IrExpression irExpression = call2.getValueArgument(0);
        if (irExpression == null) {
            Intrinsics.throwNpe();
        }
        IrExpression code = irExpression;
        List<JsStatement> list2 = code;
        IrExpression p1 = list2;
        list2 = JsCodeKt.parseJsCode(translateJsCode.1.INSTANCE.invoke(p1), new JsFunctionScope(scope, "<js-code>"));
        List<JsStatement> list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        List<JsStatement> statements = list3;
        int size = statements.size();
        switch (size) {
            case 0: {
                jsNode = JsEmpty.INSTANCE;
                break;
            }
            case 1: {
                AbstractNode abstractNode;
                Object e = statements.get(0);
                JsStatement it = (JsStatement)e;
                JsStatement jsStatement = it;
                if (!(jsStatement instanceof JsExpressionStatement)) {
                    jsStatement = null;
                }
                if ((abstractNode = (JsExpressionStatement)jsStatement) != null && (abstractNode = abstractNode.getExpression()) != null) {
                    jsNode = abstractNode;
                    break;
                }
                jsNode = it;
                break;
            }
            default: {
                jsNode = new JsBlock(statements);
            }
        }
        return jsNode;
    }

    private static final List<JsStatement> parseJsCode(String jsCode, JsScope currentScope2) {
        boolean bl = currentScope2 instanceof JsFunctionScope;
        if (_Assertions.ENABLED && !bl) {
            String string = "Usage of js outside of function is unexpected";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        JsRootScope temporaryRootScope = new JsRootScope(new JsProgram());
        JsScope jsScope = currentScope2;
        if (jsScope == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsFunctionScope");
        }
        DelegatingJsFunctionScopeWithTemporaryParent scope = new DelegatingJsFunctionScopeWithTemporaryParent((JsFunctionScope)jsScope, temporaryRootScope);
        return ParserUtilsKt.parse(jsCode, ThrowExceptionOnErrorReporter.INSTANCE, scope, "<js-code>");
    }
}

