/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fileClasses;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.fileClasses.JvmMultifileClassPartInfo;
import org.jetbrains.kotlin.fileClasses.JvmSimpleFileClassInfo;
import org.jetbrains.kotlin.fileClasses.ParsedJvmFileClassAnnotations;
import org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0007J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001d\u001a\u00020\u0014H\u0002J\u000e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fileClasses/JvmFileClassUtil;", "", "()V", "JVM_MULTIFILE_CLASS", "Lorg/jetbrains/kotlin/name/FqName;", "getJVM_MULTIFILE_CLASS", "()Lorg/jetbrains/kotlin/name/FqName;", "JVM_MULTIFILE_CLASS_SHORT", "", "getJVM_MULTIFILE_CLASS_SHORT", "()Ljava/lang/String;", "JVM_NAME", "getJVM_NAME", "JVM_NAME_SHORT", "getJVM_NAME_SHORT", "JVM_PACKAGE_NAME", "getJVM_PACKAGE_NAME", "JVM_PACKAGE_NAME_SHORT", "MULTIFILE_PART_NAME_DELIMITER", "findAnnotationEntryOnFileNoResolve", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "shortName", "getFacadeClassInternalName", "getFileClassInfoNoResolve", "Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "getFileClassInternalName", "getLiteralStringFromAnnotation", "annotation", "getPartFqNameForDeserialized", "descriptor", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedMemberDescriptor;", "manglePartName", "facadeName", "fileName", "parseJvmNameOnFileNoResolve", "Lorg/jetbrains/kotlin/fileClasses/ParsedJvmFileClassAnnotations;", "frontend.java"})
public final class JvmFileClassUtil {
    @NotNull
    private static final FqName JVM_NAME;
    @NotNull
    private static final String JVM_NAME_SHORT;
    @NotNull
    private static final FqName JVM_MULTIFILE_CLASS;
    @NotNull
    private static final String JVM_MULTIFILE_CLASS_SHORT;
    @NotNull
    private static final FqName JVM_PACKAGE_NAME;
    private static final String JVM_PACKAGE_NAME_SHORT;
    public static final JvmFileClassUtil INSTANCE;

    @NotNull
    public final FqName getJVM_NAME() {
        return JVM_NAME;
    }

    @NotNull
    public final String getJVM_NAME_SHORT() {
        return JVM_NAME_SHORT;
    }

    @NotNull
    public final FqName getJVM_MULTIFILE_CLASS() {
        return JVM_MULTIFILE_CLASS;
    }

    @NotNull
    public final String getJVM_MULTIFILE_CLASS_SHORT() {
        return JVM_MULTIFILE_CLASS_SHORT;
    }

    @NotNull
    public final FqName getJVM_PACKAGE_NAME() {
        return JVM_PACKAGE_NAME;
    }

    @NotNull
    public final FqName getPartFqNameForDeserialized(@NotNull DeserializedMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Object object = UtilKt.getImplClassNameForDeserialized(descriptor2);
        if (object == null || (object = ((JvmClassName)object).getFqNameForTopLevelClassMaybeWithDollars()) == null) {
            String string = "No implClassName for " + descriptor2;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final String getFileClassInternalName(@NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return JvmFileClassUtilKt.getInternalNameWithoutInnerClasses(JvmFileClassUtil.getFileClassInfoNoResolve(file2).getFileClassFqName());
    }

    @JvmStatic
    @NotNull
    public static final String getFacadeClassInternalName(@NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return JvmFileClassUtilKt.getInternalNameWithoutInnerClasses(JvmFileClassUtil.getFileClassInfoNoResolve(file2).getFacadeClassFqName());
    }

    private final String manglePartName(String facadeName, String fileName) {
        return facadeName + "__" + PackagePartClassUtils.getFilePartShortName(fileName);
    }

    @JvmStatic
    @NotNull
    public static final JvmFileClassInfo getFileClassInfoNoResolve(@NotNull KtFile file2) {
        JvmFileClassInfo jvmFileClassInfo;
        Object packageFqName;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        ParsedJvmFileClassAnnotations parsedAnnotations = INSTANCE.parseJvmNameOnFileNoResolve(file2);
        Object object = parsedAnnotations;
        if (object == null || (object = ((ParsedJvmFileClassAnnotations)object).getJvmPackageName()) == null) {
            object = packageFqName = file2.getPackageFqName();
        }
        if (parsedAnnotations != null) {
            String string = parsedAnnotations.getJvmName();
            if (string == null) {
                String string2 = file2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.name");
                string = PackagePartClassUtils.getFilePartShortName(string2);
            }
            String simpleName = string;
            FqName facadeClassFqName = ((FqName)packageFqName).child(Name.identifier(simpleName));
            if (parsedAnnotations.isMultifileClass()) {
                String string3 = file2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"file.name");
                FqName fqName2 = ((FqName)packageFqName).child(Name.identifier(INSTANCE.manglePartName(simpleName, string3)));
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName.child(Name\u2026(simpleName, file.name)))");
                FqName fqName3 = facadeClassFqName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"facadeClassFqName");
                jvmFileClassInfo = new JvmMultifileClassPartInfo(fqName2, fqName3);
            } else {
                FqName fqName4 = facadeClassFqName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName4, (String)"facadeClassFqName");
                jvmFileClassInfo = new JvmSimpleFileClassInfo(fqName4, true);
            }
        } else {
            String string = file2.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
            jvmFileClassInfo = new JvmSimpleFileClassInfo(PackagePartClassUtils.getPackagePartFqName((FqName)packageFqName, string), false);
        }
        return jvmFileClassInfo;
    }

    private final ParsedJvmFileClassAnnotations parseJvmNameOnFileNoResolve(KtFile file2) {
        FqName jvmPackageName;
        FqName fqName2;
        Object $i$a$2$unknown;
        KtAnnotationEntry p1;
        JvmFileClassUtil $i$a$1$unknown;
        Object p12;
        Object object;
        KtAnnotationEntry p13;
        JvmFileClassUtil jvmFileClassUtil;
        KtAnnotationEntry jvmNameAnnotation = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file2, JVM_NAME_SHORT);
        Object object2 = jvmNameAnnotation;
        Object jvmName = object2 != null && (object2 = (jvmFileClassUtil = this).getLiteralStringFromAnnotation(p13 = (object = object2))) != null ? (Name.isValidIdentifier((String)(p12 = (object = object2))) ? object : null) : null;
        String string = JVM_PACKAGE_NAME_SHORT;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JVM_PACKAGE_NAME_SHORT");
        KtAnnotationEntry jvmPackageNameAnnotation = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file2, string);
        Object object3 = jvmPackageNameAnnotation;
        if (object3 != null && (object3 = ($i$a$1$unknown = this).getLiteralStringFromAnnotation(p1 = ($i$a$2$unknown = object3))) != null) {
            Object p14 = $i$a$2$unknown = object3;
            fqName2 = new FqName((String)p14);
        } else {
            fqName2 = jvmPackageName = null;
        }
        if (jvmName == null && jvmPackageName == null) {
            return null;
        }
        String string2 = JVM_MULTIFILE_CLASS_SHORT;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"JVM_MULTIFILE_CLASS_SHORT");
        boolean isMultifileClass = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file2, string2) != null;
        return new ParsedJvmFileClassAnnotations((String)jvmName, jvmPackageName, isMultifileClass);
    }

    @JvmStatic
    @Nullable
    public static final KtAnnotationEntry findAnnotationEntryOnFileNoResolve(@NotNull KtFile file2, @NotNull String shortName) {
        KtAnnotationEntry ktAnnotationEntry;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)shortName, (String)"shortName");
        Object object = file2.getFileAnnotationList();
        if (object != null && (object = ((KtFileAnnotationList)object).getAnnotationEntries()) != null) {
            Object v3;
            block3: {
                Iterable $receiver$iv = (Iterable)object;
                for (Object element$iv : $receiver$iv) {
                    KtAnnotationEntry it;
                    KtAnnotationEntry ktAnnotationEntry2 = it = (KtAnnotationEntry)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktAnnotationEntry2, (String)"it");
                    KtExpression ktExpression = ktAnnotationEntry2.getCalleeExpression();
                    if (!Intrinsics.areEqual((Object)(ktExpression != null && (ktExpression = ((KtConstructorCalleeExpression)ktExpression).getConstructorReferenceExpression()) != null ? ktExpression.getReferencedName() : null), (Object)shortName)) continue;
                    v3 = element$iv;
                    break block3;
                }
                v3 = null;
            }
            ktAnnotationEntry = v3;
        } else {
            ktAnnotationEntry = null;
        }
        return ktAnnotationEntry;
    }

    private final String getLiteralStringFromAnnotation(KtAnnotationEntry annotation2) {
        List<? extends ValueArgument> list2 = annotation2.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"annotation.valueArguments");
        Object object = (ValueArgument)CollectionsKt.firstOrNull(list2);
        if (object == null || (object = object.getArgumentExpression()) == null) {
            return null;
        }
        Object argumentExpression = object;
        Object object2 = argumentExpression;
        if (!(object2 instanceof KtStringTemplateExpression)) {
            object2 = null;
        }
        KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)object2;
        if (ktStringTemplateExpression == null) {
            return null;
        }
        KtStringTemplateExpression stringTemplate = ktStringTemplateExpression;
        Object[] objectArray = stringTemplate.getEntries();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"stringTemplate.entries");
        Object object3 = ArraysKt.singleOrNull((Object[])objectArray);
        if (!(object3 instanceof KtLiteralStringTemplateEntry)) {
            object3 = null;
        }
        KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = (KtLiteralStringTemplateEntry)object3;
        if (ktLiteralStringTemplateEntry == null) {
            return null;
        }
        KtLiteralStringTemplateEntry singleEntry = ktLiteralStringTemplateEntry;
        return singleEntry.getText();
    }

    private JvmFileClassUtil() {
    }

    static {
        JvmFileClassUtil jvmFileClassUtil;
        INSTANCE = jvmFileClassUtil = new JvmFileClassUtil();
        JVM_NAME = new FqName("kotlin.jvm.JvmName");
        String string = JVM_NAME.shortName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JVM_NAME.shortName().asString()");
        JVM_NAME_SHORT = string;
        JVM_MULTIFILE_CLASS = new FqName("kotlin.jvm.JvmMultifileClass");
        JVM_MULTIFILE_CLASS_SHORT = JVM_MULTIFILE_CLASS.shortName().asString();
        JVM_PACKAGE_NAME = new FqName("kotlin.jvm.JvmPackageName");
        JVM_PACKAGE_NAME_SHORT = JVM_PACKAGE_NAME.shortName().asString();
    }
}

