/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.declarations;

import com.intellij.psi.impl.source.PsiFileImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.lazy.declarations.AbstractPsiBasedDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00100\u0018H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedPackageMemberDeclarationProvider;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "factory", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory;", "packageFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory;Ljava/util/Collection;)V", "allDeclaredSubPackages", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "containsFile", "", "file", "doCreateIndex", "", "index", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider$Index;", "getAllDeclaredSubPackages", "nameFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "getPackageFiles", "toString", "", "frontend"})
public final class FileBasedPackageMemberDeclarationProvider
extends AbstractPsiBasedDeclarationProvider
implements PackageMemberDeclarationProvider {
    private final NotNullLazyValue<Collection<FqName>> allDeclaredSubPackages;
    private final FqName fqName;
    private final FileBasedDeclarationProviderFactory factory;
    private final Collection<KtFile> packageFiles;

    @Override
    protected void doCreateIndex(@NotNull AbstractPsiBasedDeclarationProvider.Index index2) {
        Intrinsics.checkParameterIsNotNull((Object)index2, (String)"index");
        for (KtFile file2 : this.packageFiles) {
            for (KtDeclaration declaration : file2.getDeclarations()) {
                boolean bl = Intrinsics.areEqual((Object)this.fqName, (Object)file2.getPackageFqName());
                if (_Assertions.ENABLED && !bl) {
                    String string = "Files declaration utils contains file with invalid package";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                index2.putToIndex(declaration);
            }
        }
    }

    @Override
    @NotNull
    public Collection<FqName> getAllDeclaredSubPackages(@NotNull Function1<? super Name, Boolean> nameFilter2) {
        Intrinsics.checkParameterIsNotNull(nameFilter2, (String)"nameFilter");
        return (Collection)this.allDeclaredSubPackages.invoke();
    }

    @Override
    @NotNull
    public Collection<KtFile> getPackageFiles() {
        return this.packageFiles;
    }

    @Override
    public boolean containsFile(@NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return this.packageFiles.contains(file2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        void var3_4;
        String string;
        KtAnnotated it;
        Collection<String> collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = this.packageFiles;
        StringBuilder stringBuilder = new StringBuilder().append("Declarations for package ").append(this.fqName).append(" with files ");
        void var2_3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            KtFile ktFile = (KtFile)item$iv$iv;
            collection = destination$iv$iv;
            string = ((PsiFileImpl)((Object)it)).getName();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        $receiver$iv = this.packageFiles;
        stringBuilder = stringBuilder.append(collection).append(' ').append("with declarations inside ");
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (KtFile)element$iv$iv;
            Iterable list$iv$iv = ((KtFile)it).getDeclarations();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        collection = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)collection;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (KtDeclaration)item$iv$iv;
            collection = destination$iv$iv;
            String string2 = it.getName();
            if (string2 == null) {
                string2 = "???";
            }
            string = string2;
            collection.add(string);
        }
        collection = (List)var3_4;
        return stringBuilder.append(collection).toString();
    }

    public FileBasedPackageMemberDeclarationProvider(@NotNull StorageManager storageManager, @NotNull FqName fqName2, @NotNull FileBasedDeclarationProviderFactory factory2, @NotNull Collection<? extends KtFile> packageFiles) {
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        Intrinsics.checkParameterIsNotNull((Object)factory2, (String)"factory");
        Intrinsics.checkParameterIsNotNull(packageFiles, (String)"packageFiles");
        super(storageManager);
        this.fqName = fqName2;
        this.factory = factory2;
        this.packageFiles = packageFiles;
        this.allDeclaredSubPackages = storageManager.createLazyValue((Function0)new Function0<Collection<? extends FqName>>(this){
            final /* synthetic */ FileBasedPackageMemberDeclarationProvider this$0;

            @NotNull
            public final Collection<FqName> invoke() {
                Collection<FqName> collection = FileBasedPackageMemberDeclarationProvider.access$getFactory$p(this.this$0).getAllDeclaredSubPackagesOf(FileBasedPackageMemberDeclarationProvider.access$getFqName$p(this.this$0));
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"factory.getAllDeclaredSubPackagesOf(fqName)");
                return collection;
            }
            {
                this.this$0 = fileBasedPackageMemberDeclarationProvider;
                super(0);
            }
        });
    }

    @NotNull
    public static final /* synthetic */ FileBasedDeclarationProviderFactory access$getFactory$p(FileBasedPackageMemberDeclarationProvider $this) {
        return $this.factory;
    }

    @NotNull
    public static final /* synthetic */ FqName access$getFqName$p(FileBasedPackageMemberDeclarationProvider $this) {
        return $this.fqName;
    }
}

