/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js;

import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.backend.common.lower.DefaultArgumentStubGenerator;
import org.jetbrains.kotlin.backend.common.lower.DefaultParameterInjector;
import org.jetbrains.kotlin.backend.common.lower.InitializersLowering;
import org.jetbrains.kotlin.backend.common.lower.InnerClassConstructorCallsLowering;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesLowering;
import org.jetbrains.kotlin.backend.common.lower.LateinitLowering;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLowering;
import org.jetbrains.kotlin.backend.common.lower.PropertiesLowering;
import org.jetbrains.kotlin.backend.common.lower.SharedVariablesLowering;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.backend.js.CompilerKt;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin;
import org.jetbrains.kotlin.ir.backend.js.lower.BlockDecomposerLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.CallableReferenceLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.IntrinsicifyCallsLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.MultipleCatchesLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.SecondaryCtorLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.TypeOperatorLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.inline.FunctionInlining;
import org.jetbrains.kotlin.ir.backend.js.lower.inline.IrUnboundSymbolReplacerKt;
import org.jetbrains.kotlin.ir.backend.js.lower.inline.NewIrUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.lower.inline.RemoveInlineFunctionsWithReifiedTypeParametersLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.inline.ReturnableBlockLowering;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrModuleToJsTransformer;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.util.ExternalDependenciesGenerator;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.js.analyze.TopDownAnalyzerFacadeForJS;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi2ir.Psi2IrTranslator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0010\u001a\u00020\f*\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\f\u0010\u0013\u001a\u00020\u0012*\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"compile", "", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "export", "Lorg/jetbrains/kotlin/name/FqName;", "lower", "", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "performInlining", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "removeDuplicates", "backend.js"})
public final class CompilerKt {
    @NotNull
    public static final String compile(@NotNull Project project, @NotNull List<? extends KtFile> files2, @NotNull CompilerConfiguration configuration, @NotNull FqName export) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)export, (String)"export");
        JsAnalysisResult analysisResult2 = TopDownAnalyzerFacadeForJS.INSTANCE.analyzeFiles((Collection<? extends KtFile>)files2, project, configuration, CollectionsKt.emptyList(), CollectionsKt.emptyList());
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        TopDownAnalyzerFacadeForJS.checkForErrors((Collection<? extends KtFile>)files2, analysisResult2.getBindingContext());
        Psi2IrTranslator psi2IrTranslator = new Psi2IrTranslator(null, 1, null);
        GeneratorContext psi2IrContext = psi2IrTranslator.createGeneratorContext(analysisResult2.getModuleDescriptor(), analysisResult2.getBindingContext());
        IrModuleFragment moduleFragment = CompilerKt.removeDuplicates(psi2IrTranslator.generateModuleFragment(psi2IrContext, (Collection<? extends KtFile>)files2));
        JsIrBackendContext context = new JsIrBackendContext(analysisResult2.getModuleDescriptor(), psi2IrContext.getIrBuiltIns(), psi2IrContext.getSymbolTable(), moduleFragment);
        new ExternalDependenciesGenerator(psi2IrContext.getSymbolTable(), psi2IrContext.getIrBuiltIns()).generateUnboundSymbolsAsDependencies(moduleFragment);
        CompilerKt.performInlining(context, moduleFragment);
        Iterable $receiver$iv = moduleFragment.getFiles();
        for (Object element$iv : $receiver$iv) {
            IrFile it = (IrFile)element$iv;
            CompilerKt.lower(context, it);
        }
        SecondaryCtorLowering.CallsiteRedirectionTransformer transformer = new SecondaryCtorLowering.CallsiteRedirectionTransformer(context);
        Iterable $receiver$iv2 = moduleFragment.getFiles();
        for (Object element$iv : $receiver$iv2) {
            IrFile it = (IrFile)element$iv;
            it.accept(transformer, null);
        }
        JsNode program = (JsNode)moduleFragment.accept(new IrModuleToJsTransformer(context), null);
        return program.toString();
    }

    public static final void performInlining(@NotNull JsIrBackendContext $receiver, @NotNull IrModuleFragment moduleFragment) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)moduleFragment, (String)"moduleFragment");
        new FunctionInlining($receiver).inline(moduleFragment);
        NewIrUtilsKt.referenceAllTypeExternalClassifiers(moduleFragment, $receiver.getSymbolTable());
        do {
            IrUnboundSymbolReplacerKt.replaceUnboundSymbols(moduleFragment, $receiver);
            NewIrUtilsKt.referenceAllTypeExternalClassifiers(moduleFragment, $receiver.getSymbolTable());
        } while (!(collection = (Collection)$receiver.getSymbolTable().getUnboundClasses()).isEmpty());
        PatchDeclarationParentsKt.patchDeclarationParents$default(moduleFragment, null, 1, null);
        Iterable $receiver$iv = moduleFragment.getFiles();
        for (Object element$iv : $receiver$iv) {
            IrFile file2 = (IrFile)element$iv;
            LowerKt.runOnFilePostfix(RemoveInlineFunctionsWithReifiedTypeParametersLowering.INSTANCE, file2);
        }
    }

    public static final void lower(@NotNull JsIrBackendContext $receiver, @NotNull IrFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        new LateinitLowering($receiver, true).lower(file2);
        LowerKt.runOnFilePostfix(new DefaultArgumentStubGenerator($receiver, false, 2, null), file2);
        LowerKt.runOnFilePostfix(new DefaultParameterInjector($receiver, false, 2, null), file2);
        LowerKt.runOnFilePostfix(new SharedVariablesLowering($receiver), file2);
        new ReturnableBlockLowering($receiver).lower(file2);
        LowerKt.runOnFilePostfix(new LocalDeclarationsLowering($receiver, null, 2, null), file2);
        LowerKt.runOnFilePostfix(new InnerClassesLowering($receiver), file2);
        LowerKt.runOnFilePostfix(new InnerClassConstructorCallsLowering($receiver), file2);
        new PropertiesLowering().lower(file2);
        LowerKt.runOnFilePostfix(new InitializersLowering($receiver, JsLoweredDeclarationOrigin.CLASS_STATIC_INITIALIZER.INSTANCE, false), file2);
        new MultipleCatchesLowering($receiver).lower(file2);
        new TypeOperatorLowering($receiver).lower(file2);
        LowerKt.runOnFilePostfix(new BlockDecomposerLowering($receiver), file2);
        LowerKt.runOnFilePostfix(new SecondaryCtorLowering($receiver), file2);
        new CallableReferenceLowering($receiver).lower(file2);
        new IntrinsicifyCallsLowering($receiver).lower(file2);
    }

    private static final IrModuleFragment removeDuplicates(@NotNull IrModuleFragment $receiver) {
        removeDuplicates.1 removeDuplicates$ = removeDuplicates.1.INSTANCE;
        removeDuplicates$.invoke($receiver.getDependencyModules());
        Iterable $receiver$iv = $receiver.getDependencyModules();
        for (Object element$iv : $receiver$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv;
            removeDuplicates.1.INSTANCE.invoke(it.getExternalPackageFragments());
        }
        return $receiver;
    }
}

