/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.JvmBackendClassResolver;
import org.jetbrains.kotlin.codegen.RangeCodegenUtilKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValueKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.ProgressionIteratorBasicValue;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.InlineClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\u0011\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\b\u001a\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u001a\n\u0010\u001a\u001a\u00020\n*\u00020\u001b\u001a\u0018\u0010\u001c\u001a\u00020\n*\u00020\u001b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a\u0012\u0010\u001d\u001a\u00020\n*\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0013\u001a\f\u0010\u001f\u001a\u00020\n*\u00020 H\u0002\u001a\u0014\u0010!\u001a\u00020\n*\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0013H\u0002\u001a\u0014\u0010\"\u001a\u00020\n*\u00020 2\u0006\u0010\u001e\u001a\u00020\u0013H\u0002\u001a\u0014\u0010#\u001a\u00020\n*\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0013H\u0002\u001a\u0014\u0010$\u001a\u00020\n*\u00020 2\u0006\u0010\u001e\u001a\u00020\u0013H\u0002\u001a\u0018\u0010%\u001a\u00020\n*\u00020\u001b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a\n\u0010&\u001a\u00020\n*\u00020\u001b\u001a\n\u0010'\u001a\u00020\n*\u00020\u001b\u001a\n\u0010(\u001a\u00020\n*\u00020\u001b\u001a\u0018\u0010)\u001a\u00020\n*\u00020\u001b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a.\u0010*\u001a\u00020\n*\u00020\u001b2\u0006\u0010+\u001a\u00020,2\u0017\u0010-\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\n0.\u00a2\u0006\u0002\b/H\u0086\b\u001a\u0018\u00100\u001a\u00020\n*\u00020\u001b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a\n\u00101\u001a\u00020\n*\u00020\u001b\u001a\n\u00102\u001a\u00020\n*\u00020\u001b\u001a\u0012\u00103\u001a\u00020\n*\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0013\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"2\u0010\u0004\u001a&\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\u00010\u0001 \u0002*\u0012\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"JLCLASS_TO_KCLASS", "", "kotlin.jvm.PlatformType", "KCLASS_TO_JLCLASS", "UNBOXING_METHOD_NAMES", "Lcom/google/common/collect/ImmutableSet;", "shouldUseEqualsForWrappers", "", "Lorg/jetbrains/org/objectweb/asm/Type;", "areSameTypedBoxedValues", "", "values", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "buildFqNameByInternal", "Lorg/jetbrains/kotlin/name/FqName;", "internalClassName", "canValuesBeUnboxedForAreEqual", "generationState", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "isProgressionClass", "type", "isUnboxingMethodName", "name", "isWrapperClassName", "isWrapperClassNameOrNumber", "isAreEqualIntrinsic", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "isAreEqualIntrinsicForSameTypedBoxedValues", "isBoxing", "state", "isBoxingMethodDescriptor", "Lorg/jetbrains/org/objectweb/asm/tree/MethodInsnNode;", "isInlineClassBoxing", "isInlineClassBoxingMethodDescriptor", "isInlineClassUnboxing", "isInlineClassUnboxingMethodDescriptor", "isIteratorMethodCallOfProgression", "isJavaLangClassBoxing", "isJavaLangClassUnboxing", "isJavaLangComparableCompareTo", "isJavaLangComparableCompareToForSameTypedBoxedValues", "isMethodInsnWith", "opcode", "", "condition", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "isNextMethodCallOfProgressionIterator", "isPrimitiveBoxing", "isPrimitiveUnboxing", "isUnboxing", "backend"})
public final class BoxingInterpreterKt {
    private static final ImmutableSet<String> UNBOXING_METHOD_NAMES = ImmutableSet.of("booleanValue", "charValue", "byteValue", "shortValue", "intValue", "floatValue", new String[]{"longValue", "doubleValue"});
    private static final String KCLASS_TO_JLCLASS = Type.getMethodDescriptor(AsmTypes.JAVA_CLASS_TYPE, AsmTypes.K_CLASS_TYPE);
    private static final String JLCLASS_TO_KCLASS = Type.getMethodDescriptor(AsmTypes.K_CLASS_TYPE, AsmTypes.JAVA_CLASS_TYPE);
    private static final Set<Type> shouldUseEqualsForWrappers = SetsKt.setOf((Object[])new Type[]{Type.DOUBLE_TYPE, Type.FLOAT_TYPE, AsmTypes.JAVA_CLASS_TYPE});

    public static final boolean isUnboxing(@NotNull AbstractInsnNode $receiver, @NotNull GenerationState state2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
        return BoxingInterpreterKt.isPrimitiveUnboxing($receiver) || BoxingInterpreterKt.isJavaLangClassUnboxing($receiver) || BoxingInterpreterKt.isInlineClassUnboxing($receiver, state2);
    }

    public static final boolean isBoxing(@NotNull AbstractInsnNode $receiver, @NotNull GenerationState state2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
        return BoxingInterpreterKt.isPrimitiveBoxing($receiver) || BoxingInterpreterKt.isJavaLangClassBoxing($receiver) || BoxingInterpreterKt.isInlineClassBoxing($receiver, state2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPrimitiveUnboxing(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 182;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        String string = $receiver2.owner;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"owner");
        if (!BoxingInterpreterKt.isWrapperClassNameOrNumber(string)) return false;
        String string2 = $receiver2.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
        if (!BoxingInterpreterKt.isUnboxingMethodName(string2)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isJavaLangClassUnboxing(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 184;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        if (!Intrinsics.areEqual((Object)$receiver2.owner, (Object)"kotlin/jvm/JvmClassMappingKt")) return false;
        if (!Intrinsics.areEqual((Object)$receiver2.name, (Object)"getJavaClass")) return false;
        if (!Intrinsics.areEqual((Object)$receiver2.desc, (Object)KCLASS_TO_JLCLASS)) return false;
        return true;
    }

    public static final boolean isMethodInsnWith(@NotNull AbstractInsnNode $receiver, int opcode, @NotNull Function1<? super MethodInsnNode, Boolean> condition) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
        return $receiver.getOpcode() == opcode && $receiver instanceof MethodInsnNode && (Boolean)condition.invoke((Object)$receiver) != false;
    }

    private static final boolean isWrapperClassNameOrNumber(String internalClassName) {
        return BoxingInterpreterKt.isWrapperClassName(internalClassName) || Intrinsics.areEqual((Object)internalClassName, (Object)Type.getInternalName(Number.class));
    }

    private static final boolean isWrapperClassName(String internalClassName) {
        return JvmPrimitiveType.isWrapperClassName(BoxingInterpreterKt.buildFqNameByInternal(internalClassName));
    }

    private static final FqName buildFqNameByInternal(String internalClassName) {
        Type type2 = Type.getObjectType(internalClassName);
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"Type.getObjectType(internalClassName)");
        return new FqName(type2.getClassName());
    }

    private static final boolean isUnboxingMethodName(String name) {
        return UNBOXING_METHOD_NAMES.contains(name);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPrimitiveBoxing(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 184;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        String string = $receiver2.owner;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"owner");
        if (!BoxingInterpreterKt.isWrapperClassName(string)) return false;
        if (!Intrinsics.areEqual((Object)$receiver2.name, (Object)"valueOf")) return false;
        if (!BoxingInterpreterKt.isBoxingMethodDescriptor($receiver2)) return false;
        return true;
    }

    private static final boolean isBoxingMethodDescriptor(@NotNull MethodInsnNode $receiver) {
        Type ownerType = Type.getObjectType($receiver.owner);
        return Intrinsics.areEqual((Object)$receiver.desc, (Object)Type.getMethodDescriptor(ownerType, AsmUtil.unboxType(ownerType)));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isJavaLangClassBoxing(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 184;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        if (!Intrinsics.areEqual((Object)$receiver2.owner, (Object)"kotlin/jvm/internal/Reflection")) return false;
        if (!Intrinsics.areEqual((Object)$receiver2.name, (Object)"getOrCreateKotlinClass")) return false;
        if (!Intrinsics.areEqual((Object)$receiver2.desc, (Object)JLCLASS_TO_KCLASS)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isInlineClassBoxing(@NotNull AbstractInsnNode $receiver, GenerationState state2) {
        MethodInsnNode $receiver2;
        void $receiver$iv;
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 184;
        return $receiver$iv.getOpcode() == opcode$iv && $receiver$iv instanceof MethodInsnNode && BoxingInterpreterKt.isInlineClassBoxingMethodDescriptor($receiver2 = (MethodInsnNode)$receiver$iv, state2);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isInlineClassUnboxing(@NotNull AbstractInsnNode $receiver, GenerationState state2) {
        MethodInsnNode $receiver2;
        void $receiver$iv;
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 182;
        return $receiver$iv.getOpcode() == opcode$iv && $receiver$iv instanceof MethodInsnNode && BoxingInterpreterKt.isInlineClassUnboxingMethodDescriptor($receiver2 = (MethodInsnNode)$receiver$iv, state2);
    }

    private static final boolean isInlineClassBoxingMethodDescriptor(@NotNull MethodInsnNode $receiver, GenerationState state2) {
        if (Intrinsics.areEqual((Object)$receiver.name, (Object)InlineClassDescriptorResolver.BOX_METHOD_NAME.asString()) ^ true) {
            return false;
        }
        String string = $receiver.owner;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"owner");
        if (!StringsKt.endsWith$default((String)string, (String)"$Erased", (boolean)false, (int)2, null)) {
            return false;
        }
        String string2 = $receiver.owner;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"owner");
        Type ownerType = Type.getObjectType(StringsKt.removeSuffix((String)string2, (CharSequence)"$Erased"));
        JvmBackendClassResolver jvmBackendClassResolver = state2.getJvmBackendClassResolver();
        Type type2 = ownerType;
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"ownerType");
        ClassDescriptor classDescriptor = (ClassDescriptor)CollectionsKt.singleOrNull(jvmBackendClassResolver.resolveToClassDescriptors(type2));
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor descriptor2 = classDescriptor;
        if (!descriptor2.isInline()) {
            return false;
        }
        return Intrinsics.areEqual((Object)$receiver.desc, (Object)Type.getMethodDescriptor(ownerType, state2.getTypeMapper().mapType(descriptor2.getDefaultType())));
    }

    private static final boolean isInlineClassUnboxingMethodDescriptor(@NotNull MethodInsnNode $receiver, GenerationState state2) {
        if (Intrinsics.areEqual((Object)$receiver.name, (Object)InlineClassDescriptorResolver.UNBOX_METHOD_NAME.asString()) ^ true) {
            return false;
        }
        Type ownerType = Type.getObjectType($receiver.owner);
        JvmBackendClassResolver jvmBackendClassResolver = state2.getJvmBackendClassResolver();
        Type type2 = ownerType;
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"ownerType");
        ClassDescriptor classDescriptor = (ClassDescriptor)CollectionsKt.singleOrNull(jvmBackendClassResolver.resolveToClassDescriptors(type2));
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor descriptor2 = classDescriptor;
        if (!descriptor2.isInline()) {
            return false;
        }
        return Intrinsics.areEqual((Object)$receiver.desc, (Object)Type.getMethodDescriptor(state2.getTypeMapper().mapType(descriptor2.getDefaultType()), new Type[0]));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNextMethodCallOfProgressionIterator(@NotNull AbstractInsnNode $receiver, @NotNull List<? extends BasicValue> values) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        if (!(CollectionsKt.firstOrNull(values) instanceof ProgressionIteratorBasicValue)) return false;
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 185;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        if (!Intrinsics.areEqual((Object)$receiver2.name, (Object)"next")) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIteratorMethodCallOfProgression(@NotNull AbstractInsnNode $receiver, @NotNull List<? extends BasicValue> values) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 185;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        BasicValue basicValue = (BasicValue)CollectionsKt.firstOrNull(values);
        if (basicValue == null) return false;
        Type type2 = basicValue.getType();
        Type firstArgType = type2;
        if (firstArgType == null) return false;
        if (!BoxingInterpreterKt.isProgressionClass(firstArgType)) return false;
        if (!Intrinsics.areEqual((Object)$receiver2.name, (Object)"iterator")) return false;
        return true;
    }

    public static final boolean isProgressionClass(@NotNull Type type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        String string = type2.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type.internalName");
        return RangeCodegenUtilKt.isRangeOrProgression(BoxingInterpreterKt.buildFqNameByInternal(string));
    }

    public static final boolean isAreEqualIntrinsicForSameTypedBoxedValues(@NotNull AbstractInsnNode $receiver, @NotNull List<? extends BasicValue> values) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        return BoxingInterpreterKt.isAreEqualIntrinsic($receiver) && BoxingInterpreterKt.areSameTypedBoxedValues(values);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean areSameTypedBoxedValues(@NotNull List<? extends BasicValue> values) {
        void v1;
        List<? extends BasicValue> list2;
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        if (values.size() != 2) {
            return false;
        }
        List<? extends BasicValue> list3 = list2 = values;
        BasicValue basicValue = list3.get(0);
        list3 = list2;
        BasicValue v2 = list3.get(1);
        return v1 instanceof BoxedBasicValue && v2 instanceof BoxedBasicValue && Intrinsics.areEqual((Object)((BoxedBasicValue)v1).getDescriptor().getUnboxedType(), (Object)((BoxedBasicValue)v2).getDescriptor().getUnboxedType());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isAreEqualIntrinsic(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 184;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        if (!Intrinsics.areEqual((Object)$receiver2.name, (Object)"areEqual")) return false;
        if (!Intrinsics.areEqual((Object)$receiver2.owner, (Object)"kotlin/jvm/internal/Intrinsics")) return false;
        if (!Intrinsics.areEqual((Object)$receiver2.desc, (Object)"(Ljava/lang/Object;Ljava/lang/Object;)Z")) return false;
        return true;
    }

    public static final boolean canValuesBeUnboxedForAreEqual(@NotNull List<? extends BasicValue> values, @NotNull GenerationState generationState) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull(values, (String)"values");
            Intrinsics.checkParameterIsNotNull((Object)generationState, (String)"generationState");
            Iterable $receiver$iv = values;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    BasicValue it = (BasicValue)element$iv;
                    Type type2 = it.getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"it.type");
                    if (!shouldUseEqualsForWrappers.contains(BoxedBasicValueKt.getUnboxedType(type2, generationState))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean isJavaLangComparableCompareToForSameTypedBoxedValues(@NotNull AbstractInsnNode $receiver, @NotNull List<? extends BasicValue> values) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        return BoxingInterpreterKt.isJavaLangComparableCompareTo($receiver) && BoxingInterpreterKt.areSameTypedBoxedValues(values);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isJavaLangComparableCompareTo(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 185;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        if (!Intrinsics.areEqual((Object)$receiver2.name, (Object)"compareTo")) return false;
        if (!Intrinsics.areEqual((Object)$receiver2.owner, (Object)"java/lang/Comparable")) return false;
        if (!Intrinsics.areEqual((Object)$receiver2.desc, (Object)"(Ljava/lang/Object;)I")) return false;
        return true;
    }
}

